/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//********************************************************************
//********************************************************************

// This module contains the standard user compressors, such as 'u', 'u8', 'di', ...

#include "stdafx.h"

// The standard byte integer compressor 'u8'
UnsignedInt8Compressor::UnsignedInt8Compressor(Session *s, unsigned long mymindigits): UserCompressor(s)
{
   mindigits=mymindigits;
   datasize=0;contnum=1;isrejecting=1;canoverlap=1;isfixedlen=0;
}

char UnsignedInt8Compressor::ParseString(char *str,unsigned len,char *dataptr)
   // We keep the parsed value in 'val'
{
   if(ParseUnsignedInt(str,len,&val)==0)
      return 0;

   return val<256;
}

void UnsignedInt8Compressor::CompressString(char *str,unsigned len,CompressContainer *cont,char *dataptr)
{
   cont->StoreChar((unsigned char)val);
}

UnsignedInt8Uncompressor::UnsignedInt8Uncompressor(unsigned long mymindigits): UserUncompressor()
{
	Init(mymindigits);
}

UnsignedInt8Uncompressor::UnsignedInt8Uncompressor(Session *s, unsigned long mymindigits): UserUncompressor(s)
{
	Init(mymindigits);
}

void UnsignedInt8Uncompressor::Init(unsigned long mymindigits)
{
	mindigits=mymindigits;
   datasize=0;contnum=1;
}

void UnsignedInt8Uncompressor::UncompressItem(UncompressContainer *cont,char *dataptr,XMLOutput *xoutput)
{
   PrintInteger((unsigned long)(unsigned char)cont->LoadChar(),0,mindigits,xoutput);
}

char *UnsignedInt8CompressorFactory::GetName()         
{  
	return "u8"; 
}
char *UnsignedInt8CompressorFactory::GetDescription()  
{  
	return "Compressor for integers between 0 and 255"; 
}

UserCompressor *UnsignedInt8CompressorFactory::InstantiateCompressor(char *paramstr,int len)
{
   unsigned long mindigits=0;
   if(paramstr!=NULL)
   {
      char savechar=paramstr[len];
      paramstr[len]=0;
      mindigits=atoi(paramstr);
      paramstr[len]=savechar;
      if(mindigits<=0)
      {
         XMillException *e = new XMillException(XMILL_ERR_ARGUMENTS, "Invalid parameter '");
         e->ErrorCont(paramstr,len);
         e->ErrorCont("' for compressor 'u8'!");
         throw e;
      }
   }
   return new UnsignedInt8Compressor(session, mindigits);
}

UserUncompressor *UnsignedInt8CompressorFactory::InstantiateUncompressor(char *paramstr,int len)
{
   unsigned long mindigits=0;
   if(paramstr!=NULL)
   {
      char savechar=paramstr[len];
      paramstr[len]=0;
      mindigits=atoi(paramstr);
      paramstr[len]=savechar;
      return new UnsignedInt8Uncompressor(session, mindigits);
   }
   else
      return &uncompressor;
}

