/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.beans.Beans;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.ResultException;
import webwork.action.factory.ActionFactory;
import webwork.config.Configuration;
import webwork.dispatcher.ViewMapping;
import webwork.multipart.MultiPartRequest;
import webwork.multipart.MultiPartRequestWrapper;
import webwork.util.AbstractValueStack;
import webwork.util.BeanUtil;
import webwork.util.LoggerUtil;
import webwork.util.ValueStack;

public class ServletDispatcher
extends HttpServlet {
    public static final String STACK_HEAD = "webwork.valuestack.head";
    protected static Category log = Category.getInstance((Class)(class$webwork$dispatcher$ServletDispatcher != null ? class$webwork$dispatcher$ServletDispatcher : (class$webwork$dispatcher$ServletDispatcher = ServletDispatcher.class$("webwork.dispatcher.ServletDispatcher"))));
    ViewMapping mapping;
    ClassLoader classLoader;
    private static String saveDir;
    private static Integer maxSize;
    static /* synthetic */ Class class$webwork$dispatcher$ServletDispatcher;
    static /* synthetic */ Class class$webwork$dispatcher$DefaultViewMapping;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private String getActionName(String name) {
        int beginIdx = name.lastIndexOf("/");
        int endIdx = name.indexOf("." + Configuration.getString("webwork.action.extension"));
        return name.substring(beginIdx == -1 ? 0 : beginIdx + 1, endIdx == -1 ? name.length() : endIdx);
    }

    private Map getParams(String candidateAction) {
        if (candidateAction == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            String paramsList = candidateAction.substring(candidateAction.indexOf(63) + 1);
            StringTokenizer stParams = new StringTokenizer(paramsList, "&");
            HashMap<String, String> params = new HashMap<String, String>();
            while (stParams.hasMoreTokens()) {
                String nameValue = stParams.nextToken();
                StringTokenizer stNameValuePairs = new StringTokenizer(nameValue, "=");
                while (stNameValuePairs.hasMoreTokens()) {
                    String name = stNameValuePairs.nextToken();
                    String value = stNameValuePairs.nextToken();
                    params.put(name, value);
                }
            }
            return params;
        }
        catch (NoSuchElementException noSuchElementException) {
            return Collections.EMPTY_MAP;
        }
        catch (Exception e) {
            log.error((Object)"Problem tokenizing parameters", (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }

    private String getView(HttpServletRequest aRequest, String actionName, String result) throws ServletException {
        String view = null;
        view = aRequest.getParameter(result);
        if (view == null) {
            try {
                view = (String)this.mapping.getView(actionName, result);
            }
            catch (IllegalArgumentException e) {
                throw new ServletException(e.getLocalizedMessage());
            }
        }
        return view;
    }

    public void init(ServletConfig config) throws ServletException {
        block16: {
            String mappingName;
            super.init(config);
            LoggerUtil.init();
            Introspector.flushCaches();
            AbstractValueStack.clearMethods();
            try {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable throwable) {}
            if (this.classLoader == null) {
                log.error((Object)"Context classloader not properly set");
                this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            LoggerUtil.config(this.classLoader);
            try {
                mappingName = Configuration.getString("webwork.viewmapping");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                mappingName = (class$webwork$dispatcher$DefaultViewMapping != null ? class$webwork$dispatcher$DefaultViewMapping : (class$webwork$dispatcher$DefaultViewMapping = ServletDispatcher.class$("webwork.dispatcher.DefaultViewMapping"))).getName();
            }
            try {
                log.info((Object)("Loading view mapping " + mappingName));
                this.mapping = (ViewMapping)Beans.instantiate(this.classLoader, mappingName);
            }
            catch (Exception e) {
                throw new ServletException("Could not instantiate view mapping implementation", (Throwable)e);
            }
            try {
                saveDir = Configuration.getString("webwork.multipart.saveDir");
                if (saveDir.compareTo("") == 0) {
                    throw new IllegalArgumentException("saveDir=null");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
                log.warn((Object)"Unable to find 'webwork.multipart.saveDir' property setting. Defaulting to javax.servlet.context.tempdir");
                if (tempdir == null) break block16;
                saveDir = tempdir.toString();
            }
        }
        log.debug((Object)("saveDir=" + saveDir));
        try {
            String maxSizeStr = Configuration.getString("webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                try {
                    maxSize = new Integer(maxSizeStr);
                }
                catch (NumberFormatException numberFormatException) {
                    maxSize = new Integer(Integer.MAX_VALUE);
                    log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
                }
            } else {
                maxSize = new Integer(Integer.MAX_VALUE);
                log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            maxSize = new Integer(Integer.MAX_VALUE);
            log.warn((Object)"Unable to format 'webwork.multipart.maxSize' property setting. Defaulting to Integer.MAX_VALUE");
        }
        log.debug((Object)("maxSize=" + maxSize));
        log.info((Object)"Action dispatcher initialized");
    }

    private boolean isAction(String action) {
        return action == null ? false : action.endsWith("." + Configuration.getString("webwork.action.extension")) || action.indexOf("." + Configuration.getString("webwork.action.extension") + "?") != -1;
    }

    public void service(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException {
        String servletPath = (String)(aRequest = this.wrapRequest(aRequest)).getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        String actionPath = aRequest.getServletPath();
        actionPath = actionPath.substring(0, actionPath.lastIndexOf("/") + 1);
        ActionContext oldContext = ActionContext.getContext();
        try {
            block35: {
                Object var17_16;
                String candidateAction = servletPath;
                String actionName = "";
                String result = "";
                Action action = null;
                Action prevAction = null;
                int maxLinks = 10;
                try {
                    maxLinks = Integer.parseInt(Configuration.getString("webwork.action.chain.maxlinks"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.warn((Object)"Unable to retrieve maximum chain action property. Defaulting to 10.");
                }
                int linkCount = 0;
                while (this.isAction(candidateAction)) {
                    if (++linkCount > maxLinks) {
                        throw new ServletException("Exceeded maximum number of chained actions = " + Integer.toString(maxLinks));
                    }
                    actionName = this.getActionName(candidateAction);
                    this.setActionContext(actionName, aRequest, aResponse);
                    try {
                        prevAction = action;
                        action = ActionFactory.getAction(actionName);
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not instantiate action:" + actionName), (Throwable)e);
                        try {
                            aResponse.sendError(404, e.getMessage());
                            Object var7_21 = null;
                        }
                        catch (IOException ex) {
                            throw new ServletException((Throwable)ex);
                        }
                        ActionContext.setContext(oldContext);
                        return;
                    }
                    try {
                        if (prevAction != null) {
                            BeanUtil.copy(prevAction, action);
                            prevAction = null;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)"Error copying previous action to current action.", (Throwable)e);
                        throw new ServletException("Unable to copy previous action attributes to current action.");
                    }
                    Map inlineParams = this.getParams(candidateAction);
                    try {
                        BeanUtil.setProperties(inlineParams, action);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)"Error copying parameters attached to action in view map.", (Throwable)e);
                        throw new ServletException("Unable to copy parameters attached to action in view map to this action.");
                    }
                    result = null;
                    log.debug((Object)("Action:" + actionName));
                    NDC.push((String)actionName);
                    try {
                        try {
                            result = action.execute();
                        }
                        catch (SecurityException e) {
                            throw new ServletException("You're not allowed to access the action " + actionName, (Throwable)e);
                        }
                        catch (ResultException e) {
                            result = e.getResult();
                        }
                        catch (Exception e) {
                            log.debug((Object)"Action execution exception", (Throwable)e);
                            throw new ServletException("System error while executing " + action.getClass(), (Throwable)e);
                        }
                        var17_16 = null;
                    }
                    catch (Throwable throwable) {
                        var17_16 = null;
                        NDC.pop();
                        throw throwable;
                    }
                    NDC.pop();
                    log.debug((Object)("Result:" + result));
                    if (result == null) {
                        log.debug((Object)"Action has no result");
                        throw new ServletException("System error while executing " + action.getClass());
                    }
                    candidateAction = "none".equals(result.trim()) ? null : this.getView(aRequest, actionName, result);
                }
                String view = candidateAction;
                if (view == null || "".equals(view.trim())) break block35;
                if (!view.startsWith("/")) {
                    view = String.valueOf(actionPath) + view;
                }
                try {
                    log.debug((Object)("View:" + view));
                    NDC.push((String)view);
                    RequestDispatcher dispatcher = null;
                    try {
                        dispatcher = aRequest.getRequestDispatcher(view);
                    }
                    catch (Throwable throwable) {}
                    if (dispatcher == null) {
                        throw new ServletException("No presentation file with name '" + view + "' found!");
                    }
                    try {
                        try {
                            ValueStack.getStack((ServletRequest)aRequest).pushValue(action);
                            if (aRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
                                aRequest.setAttribute("webwork.view_uri", (Object)view);
                                aRequest.setAttribute("webwork.request_uri", (Object)aRequest.getRequestURI());
                                dispatcher.forward((ServletRequest)aRequest, (ServletResponse)aResponse);
                            } else {
                                dispatcher.include((ServletRequest)aRequest, (ServletResponse)aResponse);
                            }
                        }
                        catch (IOException e) {
                            throw new ServletException((Throwable)e);
                        }
                        Object var20_29 = null;
                    }
                    catch (Throwable throwable) {
                        Object var20_30 = null;
                        aRequest.setAttribute(STACK_HEAD, ValueStack.getStack((ServletRequest)aRequest).popValue());
                        throw throwable;
                    }
                    aRequest.setAttribute(STACK_HEAD, ValueStack.getStack((ServletRequest)aRequest).popValue());
                    var17_16 = null;
                }
                catch (Throwable throwable) {
                    var17_16 = null;
                    NDC.pop();
                    throw throwable;
                }
                NDC.pop();
            }
            Object var7_22 = null;
        }
        catch (Throwable throwable) {
            Object var7_23 = null;
            ActionContext.setContext(oldContext);
            throw throwable;
        }
        ActionContext.setContext(oldContext);
    }

    private void setActionContext(String actionName, HttpServletRequest request, HttpServletResponse response) {
        ActionContext context = new ActionContext();
        context.setName(actionName);
        context.setRequest(request);
        context.setResponse(response);
        context.setServletContext(this.getServletContext());
        ActionContext.setContext(context);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) {
        block2: {
            if (!MultiPartRequest.isMultiPart(request)) break block2;
            try {
                request = new MultiPartRequestWrapper((HttpServletRequest)request, saveDir, maxSize);
            }
            catch (IOException e) {
                request.setAttribute("webwork.action.ResultException", (Object)new ResultException("error", e.getLocalizedMessage()));
            }
        }
        return request;
    }
}

