/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "_id";
    private int lastId = 0;
    private String renderKitId = null;
    private String viewId = null;
    private transient List[] events = null;
    private Locale locale = null;

    public UIViewRoot() {
        this.setRendererType(null);
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        ValueBinding vb;
        String result = null;
        result = null != this.renderKitId ? this.renderKitId : ((vb = this.getValueBinding("renderKitId")) != null ? (String)vb.getValue(this.getFacesContext()) : "HTML_BASIC");
        return result;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public Locale getLocale() {
        Locale result = null;
        if (null != this.locale) {
            result = this.locale;
        } else {
            ValueBinding vb = this.getValueBinding("locale");
            FacesContext context = FacesContext.getCurrentInstance();
            if (vb != null) {
                Object resultLocale = vb.getValue(context);
                if (null == resultLocale) {
                    result = context.getApplication().getViewHandler().calculateLocale(context);
                } else if (resultLocale instanceof Locale) {
                    result = (Locale)resultLocale;
                } else if (resultLocale instanceof String) {
                    result = this.getLocaleFromString((String)resultLocale);
                }
            } else {
                result = context.getApplication().getViewHandler().calculateLocale(context);
            }
        }
        return result;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.lastId = 0;
        super.encodeBegin(context);
    }

    public void processApplication(FacesContext context) {
        this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
    }

    public void processDecodes(FacesContext context) {
        super.processDecodes(context);
        this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse()) {
            this.events = null;
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext context) {
        super.processValidators(context);
        this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse()) {
            this.events = null;
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        int i = 0;
        int len = 0;
        if (this.events == null) {
            len = PhaseId.VALUES.size();
            this.events = new List[len];
            for (i = 0; i < len; ++i) {
                this.events[i] = new ArrayList(5);
            }
        }
        this.events[event.getPhaseId().getOrdinal()].add(event);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.renderKitId, this.viewId, this.locale};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderKitId = (String)values[1];
        this.viewId = (String)values[2];
        this.locale = (Locale)values[3];
    }

    private Locale getLocaleFromString(String localeExpr) {
        Locale result = Locale.getDefault();
        if (localeExpr.indexOf("_") == -1 || localeExpr.indexOf("-") == -1) {
            if (localeExpr.length() == 2) {
                result = new Locale(localeExpr, "");
            }
        } else if (localeExpr.length() == 5) {
            String language = localeExpr.substring(0, 1);
            String country = localeExpr.substring(3, 4);
            result = new Locale(language, country);
        }
        return result;
    }

    private void broadcastEvents(FacesContext context, PhaseId phaseId) {
        List eventsForPhaseId = null;
        if (null == this.events) {
            return;
        }
        boolean hasMoreAnyPhaseEvents = true;
        boolean hasMoreCurrentPhaseEvents = true;
        eventsForPhaseId = this.events[PhaseId.ANY_PHASE.getOrdinal()];
        do {
            UIComponent source;
            FacesEvent event;
            int cursor;
            if (null != eventsForPhaseId) {
                cursor = 0;
                while (cursor < eventsForPhaseId.size()) {
                    event = (FacesEvent)eventsForPhaseId.get(cursor);
                    source = event.getComponent();
                    try {
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        // empty catch block
                    }
                    eventsForPhaseId.remove(cursor);
                }
            }
            if (null != (eventsForPhaseId = this.events[phaseId.getOrdinal()])) {
                cursor = 0;
                while (cursor < eventsForPhaseId.size()) {
                    event = (FacesEvent)eventsForPhaseId.get(cursor);
                    source = event.getComponent();
                    try {
                        source.broadcast(event);
                    }
                    catch (AbortProcessingException e) {
                        // empty catch block
                    }
                    eventsForPhaseId.remove(cursor);
                }
            }
            hasMoreAnyPhaseEvents = null != (eventsForPhaseId = this.events[PhaseId.ANY_PHASE.getOrdinal()]) && eventsForPhaseId.size() > 0;
            boolean bl = hasMoreCurrentPhaseEvents = null != this.events[phaseId.getOrdinal()] && this.events[phaseId.getOrdinal()].size() > 0;
        } while (hasMoreAnyPhaseEvents || hasMoreCurrentPhaseEvents);
    }
}

