/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.wsee;

import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import xdoclet.ConfigParamIntrospector;
import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XPackage;

public class WsdlSubTask
extends XmlSubTask {
    public static final String DEFAULT_WSDL_FILE_PATTERN = "wsdl/{0}.wsdl";
    private static String DEFAULT_TEMPLATE_FILE = "resources/wsdl.xdt";
    private boolean prefixWithPackageStructure = false;
    static /* synthetic */ Class class$xdoclet$modules$wsee$WsdlSubTask;
    static /* synthetic */ Class class$xdoclet$modules$wsee$XDocletModulesMessages;

    public WsdlSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
    }

    public boolean isPrefixWithPackageStructure() {
        return this.prefixWithPackageStructure;
    }

    public void setPrefixWithPackageStructure(boolean prefixWithPackageStructure) {
        this.prefixWithPackageStructure = prefixWithPackageStructure;
    }

    public void execute() throws XDocletException {
        this.validateOptions();
        this.startProcess();
    }

    public void validateOptions() throws XDocletException {
        Object wsdlFile = this.getContext().getConfigParam("wsdlFile");
        if (wsdlFile == ConfigParamIntrospector.NULL || "".equals(wsdlFile)) {
            wsdlFile = DEFAULT_WSDL_FILE_PATTERN;
        }
        this.setDestinationFile((String)wsdlFile);
        super.validateOptions();
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$wsee$WsdlSubTask == null ? (class$xdoclet$modules$wsee$WsdlSubTask = WsdlSubTask.class$("xdoclet.modules.wsee.WsdlSubTask")) : class$xdoclet$modules$wsee$WsdlSubTask), (String)"getGeneratedFileName");
        XPackage pak = clazz.getContainingPackage();
        String package_structure = null;
        package_structure = this.isPrefixWithPackageStructure() ? PackageTagsHandler.packageNameAsPathFor((XPackage)pak) : null;
        String packageName = this.isPackageSubstitutionInheritanceSupported() ? package_structure : null;
        String serviceName = this.getCurrentClass().getDoc().getTagAttributeValue("wsee.port-component", "name");
        String file = new File(packageName, serviceName).toString();
        String destinationFile = MessageFormat.format(this.getDestinationFile(), file);
        if (log.isDebugEnabled()) {
            log.debug((Object)("clazz.getName()=" + clazz.getName()));
            log.debug((Object)("clazz.getQualifiedName()=" + clazz.getQualifiedName()));
            log.debug((Object)("pak=" + pak));
            log.debug((Object)("packageName=" + packageName));
            log.debug((Object)("serviceName=" + serviceName));
            log.debug((Object)("destinationFile=" + destinationFile));
        }
        return destinationFile;
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString((Class)(class$xdoclet$modules$wsee$XDocletModulesMessages == null ? (class$xdoclet$modules$wsee$XDocletModulesMessages = WsdlSubTask.class$("xdoclet.modules.wsee.XDocletModulesMessages")) : class$xdoclet$modules$wsee$XDocletModulesMessages), (String)"GENERATING_WSDL_DESCRIPTOR", (String[])new String[]{this.getDestinationFile()}));
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$wsee$WsdlSubTask == null ? (class$xdoclet$modules$wsee$WsdlSubTask = WsdlSubTask.class$("xdoclet.modules.wsee.WsdlSubTask")) : class$xdoclet$modules$wsee$WsdlSubTask), (String)"matchesGenerationRules");
        if (!super.matchesGenerationRules(clazz)) {
            log.debug((Object)("Skip bean " + clazz.getQualifiedName() + " because super.matchesGenerationRules() returned false."));
            return false;
        }
        boolean isPortComponent = this.getCurrentClass().getDoc().hasTag("wsee.port-component", false);
        return isPortComponent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

