/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.PlugInConfig;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;

public class TilesPlugin
implements PlugIn {
    public static final boolean debug = true;
    protected DefinitionsFactory definitionFactory;
    static /* synthetic */ Class class$org$apache$struts$tiles$TilesRequestProcessor;
    static /* synthetic */ Class class$org$apache$struts$action$RequestProcessor;

    public void init(ActionServlet servlet, ApplicationConfig config) throws ServletException {
        DefinitionsFactoryConfig factoryConfig = this.readFactoryConfig(servlet, config);
        this.initRequestProcessorClass(config);
        this.definitionFactory = DefinitionsUtil.getDefinitionsFactory(servlet.getServletContext());
        if (this.definitionFactory != null) {
            System.out.println("Info - TilesPlugin : factory already exists. No new creation.");
            servlet.log("Info - TilesPlugin : factory already exists. No new creation.");
            return;
        }
        try {
            this.definitionFactory = DefinitionsUtil.createDefinitionsFactory(servlet.getServletContext(), factoryConfig);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        servlet.log("Tiles definition factory loaded for processor '" + config.getPrefix() + "'.");
    }

    public void destroy() {
        this.definitionFactory.destroy();
        this.definitionFactory = null;
    }

    protected DefinitionsFactoryConfig readFactoryConfig(ActionServlet servlet, ApplicationConfig config) throws ServletException {
        DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
        try {
            DefinitionsUtil.populateDefinitionsFactoryConfig(factoryConfig, servlet.getServletConfig());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new UnavailableException("Can't populate DefinitionsFactoryConfig class from 'web.xml': " + ex.getMessage());
        }
        try {
            Map strutsProperties = this.findStrutsPlugInConfigProperties(servlet, config);
            factoryConfig.populate(strutsProperties);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new UnavailableException("Can't populate DefinitionsFactoryConfig class from '" + config.getPrefix() + "/struts-config.xml':" + ex.getMessage());
        }
        return factoryConfig;
    }

    protected Map findStrutsPlugInConfigProperties(ActionServlet servlet, ApplicationConfig config) throws ServletException {
        PlugIn[] plugIns = (PlugIn[])servlet.getServletContext().getAttribute("org.apache.struts.action.PLUG_INS" + config.getPrefix());
        int index = 0;
        while (index < plugIns.length && plugIns[index] != this) {
            ++index;
        }
        if (plugIns[index] != this) {
            String msg = "Can't initialize tiles definition factory : plugin configuration object not found.";
            System.out.println(msg);
            servlet.log(msg);
            throw new ServletException(msg);
        }
        PlugInConfig plugInConfig = config.findPlugInConfigs()[index];
        return plugInConfig.getProperties();
    }

    protected void initRequestProcessorClass(ApplicationConfig config) throws ServletException {
        String tilesProcessorClassname = (class$org$apache$struts$tiles$TilesRequestProcessor == null ? (class$org$apache$struts$tiles$TilesRequestProcessor = TilesPlugin.class$("org.apache.struts.tiles.TilesRequestProcessor")) : class$org$apache$struts$tiles$TilesRequestProcessor).getName();
        ControllerConfig ctrlConfig = config.getControllerConfig();
        String configProcessorClassname = ctrlConfig.getProcessorClass();
        if (configProcessorClassname.equals((class$org$apache$struts$action$RequestProcessor == null ? (class$org$apache$struts$action$RequestProcessor = TilesPlugin.class$("org.apache.struts.action.RequestProcessor")) : class$org$apache$struts$action$RequestProcessor).getName()) || configProcessorClassname.endsWith(tilesProcessorClassname)) {
            ctrlConfig.setProcessorClass(tilesProcessorClassname);
            return;
        }
        try {
            Class tilesProcessorClass = class$org$apache$struts$tiles$TilesRequestProcessor == null ? (class$org$apache$struts$tiles$TilesRequestProcessor = TilesPlugin.class$("org.apache.struts.tiles.TilesRequestProcessor")) : class$org$apache$struts$tiles$TilesRequestProcessor;
            Class<?> configProcessorClass = Class.forName(configProcessorClassname);
            if (!tilesProcessorClass.isAssignableFrom(configProcessorClass)) {
                String msg = "TilesPlugin : Specified RequestProcessor not compatible with TilesRequestProcessor";
                System.out.println(msg);
                throw new ServletException(msg);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        debug = true;
    }
}

