/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ibm.websphere.web;

import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.util.Translator;

public class WebSphereWebXmlSubTask
extends XmlSubTask {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String BINDINGS_TEMPLATE_FILE = "resources/ibm-web-bnd_xmi.xdt";
    private static final String GENERATED_BINDINGS_FILE_NAME = "ibm-web-bnd.xmi";
    private static final String EXTENSIONS_TEMPLATE_FILE = "resources/ibm-web-ext_xmi.xdt";
    private static final String GENERATED_EXTENSIONS_FILE_NAME = "ibm-web-ext.xmi";
    private boolean hasTransformedWebXml = false;
    private String virtualHostName = "default_host";
    private String reloadInterval = "3";
    private String reloadingEnabled = "true";
    private String defaultErrorPage = "";
    private String additionalClassPath = "";
    private String fileServingEnabled = "true";
    private String directoryBrowsingEnabled = "true";
    private String serveServletsByClassnameEnabled = "true";
    private String preCompileJSPs = "true";
    private String autoRequestEncoding = "false";
    private String autoResponseEncoding = "false";
    private String autoLoadFilters = "false";
    static /* synthetic */ Class class$xdoclet$modules$ibm$websphere$web$XDocletModulesIbmWebsphereWebMessages;

    public WebSphereWebXmlSubTask() {
        this.setUseIds(true);
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getReloadInterval() {
        return this.reloadInterval;
    }

    public String getReloadingEnabled() {
        return this.reloadingEnabled;
    }

    public String getDefaultErrorPage() {
        return this.defaultErrorPage;
    }

    public String getAdditionalClassPath() {
        return this.additionalClassPath;
    }

    public String getFileServingEnabled() {
        return this.fileServingEnabled;
    }

    public String getDirectoryBrowsingEnabled() {
        return this.directoryBrowsingEnabled;
    }

    public String getServeServletsByClassnameEnabled() {
        return this.serveServletsByClassnameEnabled;
    }

    public String getPreCompileJSPs() {
        return this.preCompileJSPs;
    }

    public String getAutoRequestEncoding() {
        return this.autoRequestEncoding;
    }

    public String getAutoResponseEncoding() {
        return this.autoResponseEncoding;
    }

    public String getAutoLoadFilters() {
        return this.autoLoadFilters;
    }

    public void setVirtualHostName(String name) {
        this.virtualHostName = name;
    }

    public void setReloadInterval(String reloadInterval) {
        this.reloadInterval = this.validateIntegerValue(reloadInterval, "reloadInterval");
    }

    public void setReloadingEnabled(String reloadingEnabled) {
        this.reloadingEnabled = reloadingEnabled;
    }

    public void setDefaultErrorPage(String defaultErrorPage) {
        this.defaultErrorPage = defaultErrorPage;
    }

    public void setAdditionalClassPath(String additionalClassPath) {
        this.additionalClassPath = additionalClassPath;
    }

    public void setFileServingEnabled(String fileServingEnabled) {
        this.fileServingEnabled = this.validateBooleanValue(fileServingEnabled, "fileServingEnabled");
    }

    public void setDirectoryBrowsingEnabled(String directoryBrowsingEnabled) {
        this.directoryBrowsingEnabled = this.validateBooleanValue(directoryBrowsingEnabled, "directoryBrowsingEnabled");
    }

    public void setServeServletsByClassnameEnabled(String serveServletsByClassnameEnabled) {
        this.serveServletsByClassnameEnabled = this.validateBooleanValue(serveServletsByClassnameEnabled, "serveServletsByClassnameEnabled");
    }

    public void setPreCompileJSPs(String preCompileJSPs) {
        this.preCompileJSPs = this.validateBooleanValue(preCompileJSPs, "preCompileJSPs");
    }

    public void setAutoRequestEncoding(String autoRequestEncoding) {
        this.autoRequestEncoding = this.validateBooleanValue(autoRequestEncoding, "autoRequestEncoding");
    }

    public void setAutoResponseEncoding(String autoResponseEncoding) {
        this.autoResponseEncoding = this.validateBooleanValue(autoResponseEncoding, "autoResponseEncoding");
    }

    public void setAutoLoadFilters(String autoLoadFilters) {
        this.autoLoadFilters = this.validateBooleanValue(autoLoadFilters, "autoLoadFilters");
    }

    public void validateOptions() throws XDocletException {
    }

    public void execute() throws XDocletException {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(BINDINGS_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_BINDINGS_FILE_NAME);
        this.startProcess();
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(EXTENSIONS_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_EXTENSIONS_FILE_NAME);
        this.startProcess();
    }

    protected void engineStarted() throws XDocletException {
    }

    private String validateIntegerValue(String integerValue, String name) {
        try {
            Integer.parseInt(integerValue);
        }
        catch (NumberFormatException e) {
            this.throwInvalidConfigValueException(integerValue, name);
        }
        return integerValue;
    }

    private String validateBooleanValue(String booleanValue, String name) {
        if (booleanValue == null) {
            booleanValue = "";
        }
        if (!(TRUE.equals(booleanValue) || FALSE.equals(booleanValue) || "".equals(booleanValue))) {
            this.throwInvalidConfigValueException(booleanValue, name);
        }
        return booleanValue;
    }

    private void throwInvalidConfigValueException(String value, String name) {
        throw new RuntimeException(Translator.getString((Class)(class$xdoclet$modules$ibm$websphere$web$XDocletModulesIbmWebsphereWebMessages == null ? (class$xdoclet$modules$ibm$websphere$web$XDocletModulesIbmWebsphereWebMessages = WebSphereWebXmlSubTask.class$("xdoclet.modules.ibm.websphere.web.XDocletModulesIbmWebsphereWebMessages")) : class$xdoclet$modules$ibm$websphere$web$XDocletModulesIbmWebsphereWebMessages), (String)"INVALID_CONFIG_VALUE", (String[])new String[]{value, name}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

