/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterSearchV1
extends ASSearch
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8512041420388121326L;
    private int m_numAttribs;
    private int m_classIndex;
    private double m_treshold;
    private double m_initialThreshold;
    int m_typeOfCombination;
    private Random m_random;
    private int m_seed;
    private boolean m_debug = false;
    private StringBuffer m_InformationReports;
    private int m_totalEvals;
    protected double m_bestMerit;
    private long m_processinTime;
    private List<Subset> m_population;
    private int m_popSize;
    private int m_initialPopSize;
    private int m_calculatedInitialPopSize;
    private transient List<Subset> m_ReferenceSet;
    private transient List<Subset> m_parentsCombination;
    private List<Subset> m_attributeRanking;
    private SubsetEvaluator ASEvaluator = null;
    protected static final int COMBINATION_NOT_REDUCED = 0;
    protected static final int COMBINATION_REDUCED = 1;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Greedy Combination"), new Tag(1, "Reduced Greedy Combination")};

    public String globalInfo() {
        return "Scatter Search :\n\nPerforms an Scatter Search  through the space of attribute subsets. Start with a population of many significants and diverses subset  stops when the result is higher than a given treshold or there's not more improvement\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Felix Garcia Lopez");
        result.setValue(TechnicalInformation.Field.MONTH, "October");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.TITLE, "Solving feature subset selection problem by a Parallel Scatter Search");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Elsevier");
        result.setValue(TechnicalInformation.Field.LANGUAGE, "English");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.0$");
    }

    public ScatterSearchV1() {
        this.resetOptions();
    }

    public String thresholdTipText() {
        return "Set the treshold that subsets most overcome to be considered as significants";
    }

    public void setThreshold(double threshold) {
        this.m_initialThreshold = threshold;
    }

    public double getThreshold() {
        return this.m_initialThreshold;
    }

    public String populationSizeTipText() {
        return "Set the number of subset to generate in the initial Population";
    }

    public void setPopulationSize(int size) {
        this.m_initialPopSize = size;
    }

    public int getPopulationSize() {
        return this.m_initialPopSize;
    }

    public String combinationTipText() {
        return "Set the kind of combination for using it to combine ReferenceSet subsets.";
    }

    public void setCombination(SelectedTag c) {
        if (c.getTags() == TAGS_SELECTION) {
            this.m_typeOfCombination = c.getSelectedTag().getID();
        }
    }

    public SelectedTag getCombination() {
        return new SelectedTag(this.m_typeOfCombination, TAGS_SELECTION);
    }

    public String seedTipText() {
        return "Set the random seed.";
    }

    public void setSeed(int s) {
        this.m_seed = s;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String debugTipText() {
        return "Turn on verbose output for monitoring the search's progress.";
    }

    public void setDebug(boolean d) {
        this.m_debug = d;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tSpecify the number of subsets to generate \n\tin the initial population..", "Z", 1, "-Z <num>"));
        newVector.addElement(new Option("\tSpecify the treshold used for considering when a subset is significant.", "T", 1, "-T <threshold>"));
        newVector.addElement(new Option("\tSpecify the kind of combiantion \n\tfor using it in the combination method.", "R", 1, "-R <0 = greedy combination | 1 = reduced greedy combination >"));
        newVector.addElement(new Option("\tSet the random number seed.\n\t(default = 1)", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tVerbose output for monitoring the search.", "D", 0, "-D"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('Z', options);
        if (optionString.length() != 0) {
            this.setPopulationSize(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('T', options)).length() != 0) {
            this.setThreshold(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption('R', options)).length() != 0) {
            this.setCombination(new SelectedTag(Integer.parseInt(optionString), TAGS_SELECTION));
        } else {
            this.setCombination(new SelectedTag(0, TAGS_SELECTION));
        }
        optionString = Utils.getOption('S', options);
        if (optionString.length() != 0) {
            this.setSeed(Integer.parseInt(optionString));
        }
        this.setDebug(Utils.getFlag('D', options));
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[9];
        int current = 0;
        options[current++] = "-T";
        options[current++] = "" + this.getThreshold();
        options[current++] = "-Z";
        options[current++] = "" + this.getPopulationSize();
        options[current++] = "-R";
        options[current++] = "" + String.valueOf(this.getCombination().getSelectedTag().getID());
        options[current++] = "-S";
        options[current++] = "" + this.getSeed();
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer FString = new StringBuffer();
        FString.append("\tScatter Search \n\tInit Population: " + this.m_calculatedInitialPopSize);
        FString.append("\n\tKind of Combination: " + this.getCombination().getSelectedTag().getReadable());
        FString.append("\n\tRandom number seed: " + this.m_seed);
        FString.append("\n\tDebug: " + this.m_debug);
        FString.append("\n\tTreshold: " + Utils.doubleToString(Math.abs(this.getThreshold()), 8, 3) + "\n");
        FString.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        FString.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        if (this.m_debug) {
            return FString.toString() + "\n\n" + this.m_InformationReports.toString();
        }
        return FString.toString();
    }

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        int i;
        this.m_totalEvals = 0;
        this.m_popSize = this.m_initialPopSize;
        this.m_calculatedInitialPopSize = this.m_initialPopSize;
        this.m_treshold = this.m_initialThreshold;
        this.m_processinTime = System.currentTimeMillis();
        this.m_InformationReports = new StringBuffer();
        this.m_numAttribs = data.numAttributes();
        this.m_classIndex = data.classIndex();
        if (this.m_popSize <= 0) {
            this.m_calculatedInitialPopSize = this.m_popSize = this.m_numAttribs / 2;
        }
        this.ASEvaluator = (SubsetEvaluator)((Object)ASEval);
        if (!(this.m_treshold >= 0.0)) {
            this.m_treshold = this.calculateTreshhold();
            ++this.m_totalEvals;
        }
        this.m_random = new Random(this.m_seed);
        this.m_attributeRanking = this.RankEachAttribute();
        this.CreatePopulation(this.m_popSize);
        int bestSolutions = this.m_popSize / 4;
        int divSolutions = this.m_popSize / 4;
        if (this.m_popSize < 4) {
            bestSolutions = this.m_popSize / 2;
            divSolutions = this.m_popSize / 2;
            if (this.m_popSize == 1) {
                return this.attributeList(this.m_population.get((int)0).subset);
            }
        }
        this.m_ReferenceSet = new ArrayList<Subset>();
        for (i = 0; i < this.m_population.size(); ++i) {
            this.m_ReferenceSet.add(this.m_population.get(i));
        }
        this.GenerateReferenceSet(this.m_ReferenceSet, bestSolutions, divSolutions);
        this.m_InformationReports.append("Population: " + this.m_population.size() + "\n");
        this.m_InformationReports.append("merit    \tsubset\n");
        for (i = 0; i < this.m_population.size(); ++i) {
            this.m_InformationReports.append(this.printSubset(this.m_population.get(i)));
        }
        this.m_ReferenceSet = this.m_ReferenceSet.subList(0, bestSolutions + divSolutions);
        this.m_InformationReports.append("\nReferenceSet:");
        this.m_InformationReports.append("\n----------------Most Significants Solutions--------------\n");
        for (i = 0; i < this.m_ReferenceSet.size(); ++i) {
            if (i == bestSolutions) {
                this.m_InformationReports.append("----------------Most Diverses Solutions--------------\n");
            }
            this.m_InformationReports.append(this.printSubset(this.m_ReferenceSet.get(i)));
        }
        Subset bestTemp = new Subset(new BitSet(this.m_numAttribs), 0.0);
        while (!bestTemp.isEqual(this.m_ReferenceSet.get(0))) {
            this.CombineParents();
            this.ImproveSolutions();
            bestTemp = this.m_ReferenceSet.get(0);
            int numBest = this.m_ReferenceSet.size() / 2;
            int numDiverses = this.m_ReferenceSet.size() / 2;
            this.UpdateReferenceSet(numBest, numDiverses);
            this.m_ReferenceSet = this.m_ReferenceSet.subList(0, numBest + numDiverses);
        }
        this.m_InformationReports.append("\nLast Reference Set Updated:\n");
        this.m_InformationReports.append("merit    \tsubset\n");
        for (int i2 = 0; i2 < this.m_ReferenceSet.size(); ++i2) {
            this.m_InformationReports.append(this.printSubset(this.m_ReferenceSet.get(i2)));
        }
        this.m_bestMerit = bestTemp.merit;
        this.m_processinTime = System.currentTimeMillis() - this.m_processinTime;
        return this.attributeList(bestTemp.subset);
    }

    public void GenerateReferenceSet(List<Subset> ReferenceSet, int bestSolutions, int divSolutions) {
        ReferenceSet = this.bubbleSubsetSort(ReferenceSet);
        BitSet allBits_RefSet = this.getAllBits(ReferenceSet.subList(0, bestSolutions));
        int refSetlength = bestSolutions;
        int total = bestSolutions + divSolutions;
        while (refSetlength < total) {
            ArrayList<Integer> aux = new ArrayList<Integer>();
            for (int i = refSetlength; i < ReferenceSet.size(); ++i) {
                aux.add(this.SimetricDiference(ReferenceSet.get(i).clone(), allBits_RefSet));
            }
            int mostDiv = this.getIndexofBiggest(aux);
            ReferenceSet.set(refSetlength, ReferenceSet.get(refSetlength + mostDiv));
            allBits_RefSet = this.getAllBits(ReferenceSet.subList(0, ++refSetlength));
        }
        ReferenceSet = this.filterSubset(ReferenceSet, refSetlength);
    }

    public void UpdateReferenceSet(int numBestSolutions, int numDivsSolutions) {
        for (int i = 0; i < this.m_parentsCombination.size(); ++i) {
            this.m_ReferenceSet.add(i, this.m_parentsCombination.get(i));
        }
        this.GenerateReferenceSet(this.m_ReferenceSet, numBestSolutions, numDivsSolutions);
    }

    public void ImproveSolutions() throws Exception {
        for (int i = 0; i < this.m_parentsCombination.size(); ++i) {
            BitSet aux1 = (BitSet)this.m_parentsCombination.get((int)i).subset.clone();
            ArrayList ranking = new ArrayList();
            for (int k = 0; k < this.m_attributeRanking.size(); ++k) {
                Subset s1 = this.m_attributeRanking.get(k).clone();
                BitSet b1 = (BitSet)s1.subset.clone();
                Subset s2 = this.m_parentsCombination.get(i).clone();
                BitSet b2 = (BitSet)s2.subset.clone();
                if (b2.get(b1.nextSetBit(0))) continue;
                b2.or(b1);
                double newMerit = this.ASEvaluator.evaluateSubset(b2);
                ++this.m_totalEvals;
                if (newMerit <= s2.merit) break;
                this.m_parentsCombination.set(i, new Subset(b2, newMerit));
            }
            this.filterSubset(this.m_parentsCombination, this.m_ReferenceSet.size());
        }
    }

    public void CombineParents() throws Exception {
        this.m_parentsCombination = new ArrayList<Subset>();
        for (int i = 0; i < this.m_ReferenceSet.size() - 1; ++i) {
            for (int j = i + 1; j < this.m_ReferenceSet.size(); ++j) {
                Subset parent1 = this.m_ReferenceSet.get(i);
                Subset parent2 = this.m_ReferenceSet.get(j);
                Subset child1 = this.intersectSubsets(parent1, parent2);
                Subset child2 = child1.clone();
                Subset simDif = this.simetricDif(parent1, parent2, this.getCombination().getSelectedTag().getID());
                BitSet aux = (BitSet)simDif.subset.clone();
                boolean improvement = true;
                while (improvement) {
                    Subset best1 = this.getBestgen(child1, aux);
                    Subset best2 = this.getBestgen(child2, aux);
                    if (best1 != null || best2 != null) {
                        if (best2 == null) {
                            child1 = best1.clone();
                            continue;
                        }
                        if (best1 == null) {
                            child2 = best2.clone();
                            continue;
                        }
                        if (best1 == null || best2 == null) continue;
                        double merit1 = best1.merit;
                        double merit2 = best2.merit;
                        if (merit1 > merit2) {
                            child1 = best1.clone();
                            continue;
                        }
                        if (merit1 < merit2) {
                            child2 = best2.clone();
                            continue;
                        }
                        if (merit1 != merit2) continue;
                        if (best1.subset.cardinality() > best2.subset.cardinality()) {
                            child2 = best2.clone();
                            continue;
                        }
                        if (best1.subset.cardinality() < best2.subset.cardinality()) {
                            child1 = best1.clone();
                            continue;
                        }
                        if (best1.subset.cardinality() != best2.subset.cardinality()) continue;
                        double random = this.m_random.nextDouble();
                        if (random < 0.5) {
                            child1 = best1.clone();
                            continue;
                        }
                        child2 = best2.clone();
                        continue;
                    }
                    this.m_parentsCombination.add(child1);
                    this.m_parentsCombination.add(child2);
                    improvement = false;
                }
            }
        }
        this.m_parentsCombination = this.filterSubset(this.m_parentsCombination, this.m_ReferenceSet.size());
        this.GenerateReferenceSet(this.m_parentsCombination, this.m_ReferenceSet.size() / 2, this.m_ReferenceSet.size() / 2);
        this.m_parentsCombination = this.m_parentsCombination.subList(0, this.m_ReferenceSet.size());
    }

    public void CreatePopulation(int popSize) throws Exception {
        this.InitPopulation(popSize);
        int segmentation = this.m_numAttribs / 2;
        block2: for (int i = 0; i < this.m_popSize; ++i) {
            ArrayList<Subset> attributeRankingCopy = new ArrayList<Subset>();
            for (int j = 0; j < this.m_attributeRanking.size(); ++j) {
                attributeRankingCopy.add(this.m_attributeRanking.get(j));
            }
            double last_evaluation = -999.0;
            double current_evaluation = 0.0;
            boolean doneAnew = true;
            while (true) {
                int random_number = this.m_random.nextInt(segmentation + 1);
                if (doneAnew && i <= segmentation) {
                    random_number = i;
                }
                doneAnew = false;
                Subset s1 = ((Subset)attributeRankingCopy.get(random_number)).clone();
                Subset s2 = this.m_population.get(i).clone();
                Subset joiners = this.joinSubsets(s1, s2);
                current_evaluation = joiners.merit;
                if (!(current_evaluation > last_evaluation)) continue block2;
                this.m_population.set(i, joiners);
                last_evaluation = current_evaluation;
                try {
                    attributeRankingCopy.set(random_number, (Subset)attributeRankingCopy.get(segmentation + 1));
                    attributeRankingCopy.remove(segmentation + 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    attributeRankingCopy.set(random_number, new Subset(new BitSet(this.m_numAttribs), 0.0));
                }
            }
        }
    }

    public List<Subset> RankEachAttribute() throws Exception {
        ArrayList<Subset> result = new ArrayList<Subset>();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            BitSet an_Attribute = new BitSet(this.m_numAttribs);
            an_Attribute.set(i);
            double merit = this.ASEvaluator.evaluateSubset(an_Attribute);
            ++this.m_totalEvals;
            result.add(new Subset(an_Attribute, merit));
        }
        return this.bubbleSubsetSort(result);
    }

    public Subset getBestgen(Subset subset, BitSet gens) throws Exception {
        Subset result = null;
        double merit1 = subset.merit;
        int i = gens.nextSetBit(0);
        while (i >= 0) {
            BitSet aux = (BitSet)subset.subset.clone();
            if (!aux.get(i)) {
                aux.set(i);
                double merit2 = this.ASEvaluator.evaluateSubset(aux);
                ++this.m_totalEvals;
                if (merit2 > merit1) {
                    merit1 = merit2;
                    result = new Subset(aux, merit1);
                }
            }
            i = gens.nextSetBit(i + 1);
        }
        return result;
    }

    public List<Subset> bubbleSubsetSort(List<Subset> subsetList) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < subsetList.size() - 1; ++i) {
            Subset subset1 = subsetList.get(i);
            double merit1 = subset1.merit;
            for (int j = i + 1; j < subsetList.size(); ++j) {
                Subset subset2 = subsetList.get(j);
                double merit2 = subset2.merit;
                if (!(merit2 > merit1)) continue;
                Subset temp = subset1;
                subsetList.set(i, subset2);
                subsetList.set(j, temp);
                subset1 = subset2;
                merit1 = subset1.merit;
            }
        }
        return subsetList;
    }

    public int getIndexofBiggest(List<Integer> simDif) {
        int i;
        int aux = -99999;
        int result1 = -1;
        ArrayList<Integer> equalSimDif = new ArrayList<Integer>();
        if (simDif.size() == 0) {
            return -1;
        }
        for (i = 0; i < simDif.size(); ++i) {
            if (simDif.get(i) <= aux) continue;
            aux = simDif.get(i);
            result1 = i;
        }
        for (i = 0; i < simDif.size(); ++i) {
            if (simDif.get(i) != aux) continue;
            equalSimDif.add(i);
        }
        int finalResult = (Integer)equalSimDif.get(this.m_random.nextInt(equalSimDif.size()));
        return finalResult;
    }

    public BitSet getAllBits(List<Subset> subsets) {
        BitSet result = new BitSet(this.m_numAttribs);
        for (int i = 0; i < subsets.size(); ++i) {
            BitSet aux = subsets.get((int)i).clone().subset;
            int j = aux.nextSetBit(0);
            while (j >= 0) {
                result.set(j);
                j = aux.nextSetBit(j + 1);
            }
        }
        return result;
    }

    public void InitPopulation(int popSize) {
        this.m_population = new ArrayList<Subset>();
        for (int i = 0; i < popSize; ++i) {
            this.m_population.add(new Subset(new BitSet(this.m_numAttribs), 0.0));
        }
    }

    public Subset joinSubsets(Subset subset1, Subset subset2) throws Exception {
        BitSet b1 = (BitSet)subset1.subset.clone();
        BitSet b2 = (BitSet)subset2.subset.clone();
        b1.or(b2);
        double newMerit = this.ASEvaluator.evaluateSubset(b1);
        ++this.m_totalEvals;
        return new Subset((BitSet)b1.clone(), newMerit);
    }

    public Subset intersectSubsets(Subset subset1, Subset subset2) throws Exception {
        BitSet b1 = (BitSet)subset1.subset.clone();
        BitSet b2 = (BitSet)subset2.subset.clone();
        b1.and(b2);
        double newMerit = this.ASEvaluator.evaluateSubset(b1);
        ++this.m_totalEvals;
        return new Subset((BitSet)b1.clone(), newMerit);
    }

    public Subset simetricDif(Subset subset1, Subset subset2, int mode) throws Exception {
        BitSet b1 = (BitSet)subset1.subset.clone();
        BitSet b2 = (BitSet)subset2.subset.clone();
        b1.xor(b2);
        double newMerit = this.ASEvaluator.evaluateSubset(b1);
        ++this.m_totalEvals;
        Subset result = new Subset((BitSet)b1.clone(), newMerit);
        if (mode == 1) {
            double avgAcurracy = 0.0;
            int totalSolutions = 0;
            ArrayList<Subset> weightVector = new ArrayList<Subset>();
            BitSet res = result.subset;
            int i = res.nextSetBit(0);
            while (i >= 0) {
                double merits = 0.0;
                int numSolutions = 0;
                Subset solution = null;
                for (int j = 0; j < this.m_ReferenceSet.size(); ++j) {
                    solution = this.m_ReferenceSet.get(j);
                    if (!solution.subset.get(i)) continue;
                    merits += solution.merit;
                    ++numSolutions;
                }
                BitSet b = new BitSet(this.m_numAttribs);
                b.set(i);
                Subset s = new Subset(b, merits / (double)numSolutions);
                weightVector.add(s);
                avgAcurracy += merits;
                ++totalSolutions;
                i = res.nextSetBit(i + 1);
            }
            avgAcurracy /= (double)totalSolutions;
            BitSet newResult = new BitSet(this.m_numAttribs);
            for (int i2 = 0; i2 < weightVector.size(); ++i2) {
                Subset aux = (Subset)weightVector.get(i2);
                if (!(aux.merit >= avgAcurracy)) continue;
                newResult.or(aux.subset);
            }
            double merit = this.ASEvaluator.evaluateSubset(newResult);
            result = new Subset(newResult, merit);
        }
        return result;
    }

    public int generateRandomNumber(int limit) {
        return (int)Math.round(Math.random() * ((double)limit + 0.4));
    }

    public double calculateTreshhold() throws Exception {
        BitSet fullSet = new BitSet(this.m_numAttribs);
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            fullSet.set(i);
        }
        return this.ASEvaluator.evaluateSubset(fullSet);
    }

    public int SimetricDiference(Subset subset, BitSet bitset) {
        BitSet aux = subset.clone().subset;
        aux.xor(bitset);
        return aux.cardinality();
    }

    public List<Subset> filterSubset(List<Subset> subsetList, int preferredSize) {
        if (subsetList.size() <= preferredSize && preferredSize != -1) {
            return subsetList;
        }
        for (int i = 0; i < subsetList.size() - 1; ++i) {
            for (int j = i + 1; j < subsetList.size(); ++j) {
                Subset focus = subsetList.get(i);
                if (!focus.isEqual(subsetList.get(j))) continue;
                subsetList.remove(j);
                --j;
                if (subsetList.size() > preferredSize || preferredSize == -1) continue;
                return subsetList;
            }
        }
        return subsetList;
    }

    public String printSubset(Subset subset) {
        StringBuffer bufferString = new StringBuffer();
        if (subset == null) {
            return "";
        }
        BitSet bits = subset.subset;
        double merit = subset.merit;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bits.get(i)) continue;
            indexes.add(i + 1);
        }
        bufferString.append(Utils.doubleToString(merit, 8, 5) + "\t " + ((Object)indexes).toString() + "\n");
        return bufferString.toString();
    }

    protected void resetOptions() {
        this.m_popSize = -1;
        this.m_initialPopSize = -1;
        this.m_calculatedInitialPopSize = -1;
        this.m_treshold = -1.0;
        this.m_typeOfCombination = 0;
        this.m_seed = 1;
        this.m_debug = true;
        this.m_totalEvals = 0;
        this.m_bestMerit = 0.0;
        this.m_processinTime = 0L;
    }

    public int[] attributeList(BitSet group) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!group.get(i)) continue;
            list[count++] = i;
        }
        return list;
    }

    public class Subset
    implements Serializable {
        double merit;
        BitSet subset;

        public Subset(BitSet subset, double merit) {
            this.subset = (BitSet)subset.clone();
            this.merit = merit;
        }

        public boolean isEqual(Subset othersubset) {
            return this.subset.equals(othersubset.subset);
        }

        public Subset clone() {
            return new Subset((BitSet)this.subset.clone(), this.merit);
        }
    }
}

