/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.RevisionHandler;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Messages;
import weka.gui.beans.Startable;
import weka.gui.beans.xml.XMLBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowRunner
implements RevisionHandler {
    protected Vector m_beans;
    protected int m_runningCount = 0;
    protected transient Logger m_log = null;
    protected transient Environment m_env;
    protected boolean m_startSequentially = false;

    public FlowRunner() {
        KnowledgeFlowApp.loadProperties();
    }

    public void setLog(Logger log) {
        this.m_log = log;
    }

    protected void runSequentially(TreeMap<Integer, Startable> startables) {
        Set<Integer> s = startables.keySet();
        for (Integer i : s) {
            try {
                Startable startPoint = startables.get(i);
                startPoint.start();
                Thread.sleep(200L);
                this.waitUntilFinished();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.m_log != null) {
                    this.m_log.logMessage(ex.getMessage());
                    Messages.getInstance();
                    this.m_log.logMessage(Messages.getString("FlowRunner_RunSequentially_LogMessage_Text_First"));
                    break;
                }
                System.err.println(ex.getMessage());
                Messages.getInstance();
                System.err.println(Messages.getString("FlowRunner_RunSequentially_LogMessage_Text_Second"));
                break;
            }
        }
    }

    protected synchronized void launchThread(final Startable s, final int flowNum) {
        Thread t = new Thread(){
            private int m_num;
            {
                this.m_num = flowNum;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        s.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (FlowRunner.this.m_log != null) {
                            FlowRunner.this.m_log.logMessage(ex.getMessage());
                        } else {
                            System.err.println(ex.getMessage());
                        }
                        Object var3_2 = null;
                        FlowRunner.this.decreaseCount();
                    }
                    Object var3_1 = null;
                    FlowRunner.this.decreaseCount();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    FlowRunner.this.decreaseCount();
                    throw throwable;
                }
            }
        };
        ++this.m_runningCount;
        t.setPriority(1);
        t.start();
    }

    protected synchronized void decreaseCount() {
        --this.m_runningCount;
    }

    public synchronized void stopAllFlows() {
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_beans.elementAt(i);
            if (!(temp.getBean() instanceof BeanCommon)) continue;
            ((BeanCommon)temp.getBean()).stop();
        }
    }

    public void waitUntilFinished() {
        try {
            while (this.m_runningCount > 0) {
                Thread.sleep(200L);
            }
            while (true) {
                boolean busy = false;
                for (int i = 0; i < this.m_beans.size(); ++i) {
                    BeanInstance temp = (BeanInstance)this.m_beans.elementAt(i);
                    if (!(temp.getBean() instanceof BeanCommon) || !((BeanCommon)temp.getBean()).isBusy()) continue;
                    busy = true;
                    break;
                }
                if (busy) {
                    Thread.sleep(3000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            if (this.m_log != null) {
                Messages.getInstance();
                this.m_log.logMessage(Messages.getString("FlowRunner_WaitUntilFinished_LogMessage_Text"));
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("FlowRunner_WaitUntilFinished_Error_Text"));
            }
            this.stopAllFlows();
        }
    }

    public void load(String fileName) throws Exception {
        if (!fileName.endsWith(".kf") && !fileName.endsWith(".kfml")) {
            Messages.getInstance();
            throw new Exception(Messages.getString("FlowRunner_Load_Exception_Text"));
        }
        if (fileName.endsWith(".kf")) {
            this.loadBinary(fileName);
        } else if (fileName.endsWith(".kfml")) {
            this.loadXML(fileName);
        }
    }

    public void loadBinary(String fileName) throws Exception {
        if (!fileName.endsWith(".kf")) {
            Messages.getInstance();
            throw new Exception(Messages.getString("FlowRunner_LoadBinary_Exception_Text_First"));
        }
        FileInputStream is = new FileInputStream(fileName);
        ObjectInputStream ois = new ObjectInputStream(is);
        this.m_beans = (Vector)ois.readObject();
        ois.close();
        if (this.m_env != null) {
            String parentDir = new File(fileName).getParent();
            if (parentDir == null) {
                parentDir = "./";
            }
            this.m_env.addVariable("Internal.knowledgeflow.directory", parentDir);
        }
    }

    public void loadXML(String fileName) throws Exception {
        if (!fileName.endsWith(".kfml")) {
            Messages.getInstance();
            throw new Exception(Messages.getString("FlowRunner_LoadXML_Exception_Text"));
        }
        XMLBeans xml = new XMLBeans(null, null);
        Vector v = (Vector)xml.read(new File(fileName));
        this.m_beans = (Vector)v.get(0);
        if (this.m_env != null) {
            String parentDir = new File(fileName).getParent();
            if (parentDir == null) {
                parentDir = "./";
            }
            this.m_env.addVariable("Internal.knowledgeflow.directory", parentDir);
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("FlowRunner_LoadXML_Error_Text"));
        }
    }

    public Vector getFlows() {
        return this.m_beans;
    }

    public void setFlows(Vector beans) {
        this.m_beans = beans;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public Environment getEnvironment() {
        return this.m_env;
    }

    public void setStartSequentially(boolean s) {
        this.m_startSequentially = s;
    }

    public boolean getStartSequentially() {
        return this.m_startSequentially;
    }

    public void run() throws Exception {
        if (this.m_beans == null) {
            Messages.getInstance();
            throw new Exception(Messages.getString("FlowRunner_Run_Exception_Text"));
        }
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)this.m_beans.elementAt(i);
            if (this.m_log != null && tempB.getBean() instanceof BeanCommon) {
                ((BeanCommon)tempB.getBean()).setLog(this.m_log);
            }
            if (!(tempB.getBean() instanceof EnvironmentHandler)) continue;
            ((EnvironmentHandler)tempB.getBean()).setEnvironment(this.m_env);
        }
        int numFlows = 1;
        if (this.m_log != null) {
            if (this.m_startSequentially) {
                Messages.getInstance();
                this.m_log.logMessage(Messages.getString("FlowRunner_Run_LogMessage_Text_First"));
            } else {
                Messages.getInstance();
                this.m_log.logMessage(Messages.getString("FlowRunner_Run_LogMessage_Text_Second"));
            }
        }
        TreeMap<Integer, Startable> startables = new TreeMap<Integer, Startable>();
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)this.m_beans.elementAt(i);
            if (!(tempB.getBean() instanceof Startable)) continue;
            Startable s = (Startable)tempB.getBean();
            if (!this.m_startSequentially) {
                if (s.getStartMessage().charAt(0) != '$') {
                    if (this.m_log != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Third")).append(numFlows);
                        Messages.getInstance();
                        this.m_log.logMessage(stringBuilder2.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Fourth")).toString());
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("FlowRunner_Run_Text_First")).append(numFlows);
                        Messages.getInstance();
                        System.out.println(stringBuilder3.append(Messages.getString("FlowRunner_Run_Text_Second")).toString());
                    }
                    this.launchThread(s, numFlows);
                    ++numFlows;
                    continue;
                }
                String beanName = s.getClass().getName();
                if (s instanceof BeanCommon) {
                    String customName;
                    beanName = customName = ((BeanCommon)((Object)s)).getCustomName();
                }
                if (this.m_log != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Fifth")).append(beanName);
                    Messages.getInstance();
                    this.m_log.logMessage(stringBuilder4.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Sixth")).toString());
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("FlowRunner_Run_Text_Third")).append(beanName);
                Messages.getInstance();
                System.out.println(stringBuilder5.append(Messages.getString("FlowRunner_Run_Text_Fourth")).toString());
                continue;
            }
            boolean ok = false;
            Integer position = null;
            String beanName = s.getClass().getName();
            if (s instanceof BeanCommon) {
                String customName;
                beanName = customName = ((BeanCommon)((Object)s)).getCustomName();
                if (customName.indexOf(58) > 0) {
                    String startPos = customName.substring(0, customName.indexOf(58));
                    try {
                        position = new Integer(startPos);
                        ok = true;
                    }
                    catch (NumberFormatException n) {
                        // empty catch block
                    }
                }
            }
            if (!ok) {
                if (startables.size() == 0) {
                    position = new Integer(0);
                } else {
                    int newPos = startables.lastKey();
                    position = new Integer(++newPos);
                }
            }
            if (s.getStartMessage().charAt(0) != '$') {
                if (this.m_log != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder6 = stringBuilder.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Seventh")).append(beanName);
                    Messages.getInstance();
                    StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Eighth")).append(position);
                    Messages.getInstance();
                    this.m_log.logMessage(stringBuilder7.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Nineth")).toString());
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder8 = stringBuilder.append(Messages.getString("FlowRunner_Run_Text_Fifth")).append(beanName);
                    Messages.getInstance();
                    StringBuilder stringBuilder9 = stringBuilder8.append(Messages.getString("FlowRunner_Run_Text_Sixth")).append(position);
                    Messages.getInstance();
                    System.out.println(stringBuilder9.append(Messages.getString("FlowRunner_Run_Text_Seventh")).toString());
                }
                startables.put(position, s);
                continue;
            }
            if (this.m_log != null) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder10 = stringBuilder.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Tenth")).append(beanName);
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder10.append(Messages.getString("FlowRunner_Run_LogMessage_Text_Eleventh")).toString());
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder11 = stringBuilder.append(Messages.getString("FlowRunner_Run_Text_Eighth")).append(beanName);
            Messages.getInstance();
            System.out.println(stringBuilder11.append(Messages.getString("FlowRunner_Run_Text_Nineth")).toString());
        }
        if (this.m_startSequentially) {
            this.runSequentially(startables);
        }
    }

    public static void main(String[] args) {
        Messages.getInstance();
        weka.core.logging.Logger.log(Logger.Level.INFO, Messages.getString("FlowRunner_Main_Logger_Text"));
        if (args.length < 1) {
            Messages.getInstance();
            System.err.println(Messages.getString("FlowRunner_Main_Error_Text"));
        } else {
            try {
                FlowRunner fr = new FlowRunner();
                SimpleLogger sl = new SimpleLogger();
                String fileName = args[0];
                if (args.length == 2 && args[1].equals("-s")) {
                    fr.setStartSequentially(true);
                }
                Environment env = Environment.getSystemWide();
                fr.setLog(sl);
                fr.setEnvironment(env);
                fr.load(fileName);
                fr.run();
                fr.waitUntilFinished();
                Messages.getInstance();
                System.out.println(Messages.getString("FlowRunner_Main_Text"));
                System.exit(1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
            }
        }
    }

    @Override
    public String getRevision() {
        return "$Revision: 7059 $";
    }

    public static class SimpleLogger
    implements Logger {
        SimpleDateFormat m_DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public void logMessage(String lm) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + lm);
        }

        public void statusMessage(String lm) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + lm);
        }
    }
}

