/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.JComponent;

public class GloballyContextSensitiveAction
implements Action {
    String actionName;
    String shortDescription;
    String longDescription;
    Action delegate;
    JComponent source;
    private PropertyChangeListener focusOwnerListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            JComponent comp;
            Action action;
            if ("focusOwner".equals(evt.getPropertyName()) && evt.getNewValue() instanceof JComponent && (action = (comp = (JComponent)evt.getNewValue()).getActionMap().get(GloballyContextSensitiveAction.this.actionName)) != null) {
                GloballyContextSensitiveAction.this.changeDelegate(comp, action);
            }
        }
    };
    PropertyChangeSupport support = new PropertyChangeSupport(this);
    private PropertyChangeListener delegateListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            GloballyContextSensitiveAction.this.support.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };

    public GloballyContextSensitiveAction(String actionName, String shortDescription, String longDescription) {
        this.actionName = actionName;
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.focusOwnerListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private void changeDelegate(JComponent comp, Action action) {
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this.delegateListener);
        }
        this.source = comp;
        this.delegate = action;
        this.delegate.addPropertyChangeListener(this.delegateListener);
        boolean enabled = this.delegate.isEnabled();
        this.support.firePropertyChange("enabled", !enabled, enabled);
    }

    public boolean isEnabled() {
        return this.delegate != null && this.delegate.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.setEnabled(enabled);
        }
    }

    public Object getValue(String key) {
        if (key.equals("Name")) {
            return this.actionName;
        }
        if (key.equals("ShortDescription")) {
            return this.shortDescription;
        }
        if (key.equals("LongDescription")) {
            return this.longDescription;
        }
        if (this.delegate != null) {
            return this.delegate.getValue(key);
        }
        return null;
    }

    public void putValue(String key, Object value) {
        if (key.equals("Name")) {
            this.actionName = (String)value;
        } else if (key.equals("ShortDescription")) {
            this.shortDescription = (String)value;
        } else if (key.equals("LongDescription")) {
            this.longDescription = (String)value;
        } else if (this.delegate != null) {
            this.delegate.putValue(key, value);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.delegate != null) {
            this.delegate.actionPerformed(new ActionEvent(this.source, ae.getID(), ae.getActionCommand(), ae.getWhen(), ae.getModifiers()));
        }
    }
}

