/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DocumentHandler
extends Handler {
    private PlainDocument _doc;
    private int _max = Integer.MAX_VALUE;

    public DocumentHandler() {
        this(Integer.MAX_VALUE);
    }

    public DocumentHandler(int limit) {
        this._max = limit;
        this._doc = new PlainDocument();
    }

    public Document getDocument() {
        return this._doc;
    }

    public void close() {
    }

    public void flush() {
    }

    public void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            this.makeSpace(msg.length());
            this._doc.insertString(this._doc.getLength(), msg, null);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    private void makeSpace(int count) {
        int length = this._doc.getLength();
        if (length + count < this._max) {
            return;
        }
        try {
            if (count > this._max) {
                this._doc.remove(0, length);
            } else {
                int min = length + count - this._max;
                String remove = this._doc.getText(min, Math.min(500, length - min));
                int cr = remove.indexOf("\n");
                min = cr < 0 ? (min += remove.length()) : Math.min(min + cr + 1, length);
                this._doc.remove(0, min);
            }
        }
        catch (BadLocationException ble) {
            System.err.println("BLE! " + ble);
        }
    }
}

