/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.owasp.webscarab.model.HttpUrl;

public class UrlTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1928179376725725457L;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof HttpUrl && comp instanceof JLabel) {
            JLabel label = (JLabel)comp;
            HttpUrl url = (HttpUrl)value;
            if (url.getParameters() != null) {
                label.setText(url.getParameters());
            } else if (url.getPath().length() > 1) {
                String path = url.getPath();
                int pos = path.lastIndexOf("/", path.length() - 2);
                label.setText(path.substring(pos + 1));
            }
        }
        return comp;
    }
}

