/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.owasp.webscarab.model.Preferences;

public class ColumnWidthTracker
implements PropertyChangeListener,
TableColumnModelListener {
    private static HashMap _trackers = new HashMap();
    private String _key;
    private List _tracked = new LinkedList();

    public static ColumnWidthTracker getTracker(String key) {
        ColumnWidthTracker tracker = (ColumnWidthTracker)_trackers.get(key);
        if (tracker == null) {
            tracker = new ColumnWidthTracker(key);
            _trackers.put(key, tracker);
        }
        return tracker;
    }

    protected ColumnWidthTracker(String key) {
        this._key = key;
    }

    public void addTable(JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            this.addColumn(tc);
        }
        tcm.addColumnModelListener(this);
        this._tracked.add(tcm);
    }

    public void removeTable(JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.removePropertyChangeListener(this);
        }
        tcm.removeColumnModelListener(this);
        this._tracked.remove(tcm);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property == null || !"preferredWidth".equals(property)) {
            return;
        }
        if (!(evt.getSource() instanceof TableColumn)) {
            return;
        }
        TableColumn tc = (TableColumn)evt.getSource();
        String name = String.valueOf(tc.getHeaderValue());
        int width = tc.getPreferredWidth();
        Preferences.setPreference(this._key + "." + name + ".width", String.valueOf(width));
        Iterator it = this._tracked.iterator();
        while (it.hasNext()) {
            TableColumnModel tcm = (TableColumnModel)it.next();
            for (int i = 0; i < tcm.getColumnCount(); ++i) {
                TableColumn tc2 = tcm.getColumn(i);
                String name2 = String.valueOf(tc2.getHeaderValue());
                if (!name.equals(name2) || tc == tc2 || tc2.getPreferredWidth() == width) continue;
                tc2.setPreferredWidth(width);
            }
        }
    }

    private void addColumn(TableColumn tc) {
        String name = String.valueOf(tc.getHeaderValue());
        String preferredWidth = Preferences.getPreference(this._key + "." + name + ".width");
        if (preferredWidth != null) {
            try {
                int width = Integer.parseInt(preferredWidth);
                tc.setPreferredWidth(width);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        tc.addPropertyChangeListener(this);
    }

    public void columnAdded(TableColumnModelEvent e) {
        int index = e.getToIndex();
        TableColumnModel tcm = (TableColumnModel)e.getSource();
        TableColumn tc = tcm.getColumn(index);
        this.addColumn(tc);
    }

    public void columnMarginChanged(ChangeEvent e) {
    }

    public void columnMoved(TableColumnModelEvent e) {
    }

    public void columnRemoved(TableColumnModelEvent e) {
        TableColumnModel tcm;
        int index = e.getToIndex();
        if (index >= (tcm = (TableColumnModel)e.getSource()).getColumnCount()) {
            return;
        }
        TableColumn tc = tcm.getColumn(index);
        tc.removePropertyChangeListener(this);
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

