/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.sessionid;

import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.AbstractPluginModel;
import org.owasp.webscarab.plugin.sessionid.Calculator;
import org.owasp.webscarab.plugin.sessionid.DefaultCalculator;
import org.owasp.webscarab.plugin.sessionid.SessionID;
import org.owasp.webscarab.plugin.sessionid.SessionIDListener;
import org.owasp.webscarab.plugin.sessionid.SessionIDStore;

public class SessionIDModel
extends AbstractPluginModel {
    private FrameworkModel _model;
    private SessionIDStore _store = null;
    private Map _calculators = new TreeMap();
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private EventListenerList _listenerList = new EventListenerList();

    public SessionIDModel(FrameworkModel model) {
        this._model = model;
    }

    public ConversationModel getConversationModel() {
        return this._model.getConversationModel();
    }

    public void setStore(SessionIDStore store) {
        this._calculators.clear();
        this._store = store;
        for (int i = 0; i < this._store.getSessionIDNameCount(); ++i) {
            String key = this._store.getSessionIDName(i);
            DefaultCalculator calc = new DefaultCalculator();
            this._calculators.put(key, calc);
            for (int j = 0; j < this._store.getSessionIDCount(key); ++j) {
                calc.add(this._store.getSessionIDAt(key, j));
            }
        }
        this.fireSessionIDsChanged();
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCalculator(String key, Calculator calc) {
        this._calculators.put(key, calc);
        calc.reset();
        SessionIDStore sessionIDStore = this._store;
        synchronized (sessionIDStore) {
            int count = this._store.getSessionIDCount(key);
            for (int i = 0; i < count; ++i) {
                calc.add(this._store.getSessionIDAt(key, i));
            }
        }
        this.fireCalculatorChanged(key);
    }

    public void addSessionID(String key, SessionID id) {
        this.setModified(true);
        int insert = this._store.addSessionID(key, id);
        Calculator calc = (Calculator)this._calculators.get(key);
        if (calc == null) {
            calc = new DefaultCalculator();
            this._calculators.put(key, calc);
        }
        boolean changed = calc.add(id);
        this.fireSessionIDAdded(key, insert);
        if (changed) {
            this.fireCalculatorChanged(key);
        }
    }

    public void clearSessionIDs(String key) {
        this.setModified(true);
        this._store.clearSessionIDs(key);
        this._calculators.remove(key);
        this.fireSessionIDsChanged();
    }

    public int getSessionIDNameCount() {
        if (this._store == null) {
            return 0;
        }
        return this._store.getSessionIDNameCount();
    }

    public String getSessionIDName(int index) {
        return this._store.getSessionIDName(index);
    }

    public int getSessionIDCount(String key) {
        return this._store.getSessionIDCount(key);
    }

    public SessionID getSessionIDAt(String key, int index) {
        return this._store.getSessionIDAt(key, index);
    }

    public BigInteger getSessionIDValue(String key, SessionID id) {
        Calculator calc = (Calculator)this._calculators.get(key);
        if (calc == null) {
            return null;
        }
        return calc.calculate(id);
    }

    public BigInteger getMinimumValue(String key) {
        Calculator calc = (Calculator)this._calculators.get(key);
        if (calc == null) {
            return null;
        }
        return calc.min();
    }

    public BigInteger getMaximumValue(String key) {
        Calculator calc = (Calculator)this._calculators.get(key);
        if (calc == null) {
            return null;
        }
        return calc.max();
    }

    public Request getRequest(ConversationID id) {
        return this._model.getRequest(id);
    }

    public void addRequestCookie(ConversationID id, String cookie) {
        this._model.addConversationProperty(id, "COOKIE", cookie);
    }

    public void addResponseCookie(ConversationID id, HttpUrl url, Cookie cookie) {
        this._model.addConversationProperty(id, "SET-COOKIE", cookie.getName() + "=" + cookie.getValue());
        this._model.addUrlProperty(url, "SET-COOKIE", cookie.getName());
    }

    public String getRequestCookies(ConversationID id) {
        return this._model.getConversationProperty(id, "COOKIE");
    }

    public String getResponseCookies(ConversationID id) {
        return this._model.getConversationProperty(id, "SET-COOKIE");
    }

    public String getResponseCookies(HttpUrl url) {
        return this._model.getUrlProperty(url, "SET-COOKIE");
    }

    public void flush() throws StoreException {
        if (this._store != null && this.isModified()) {
            this._store.flush();
        }
        this.setModified(false);
    }

    public void addModelListener(SessionIDListener listener) {
        this._listenerList.add(SessionIDListener.class, listener);
    }

    public void removeModelListener(SessionIDListener listener) {
        this._listenerList.remove(SessionIDListener.class, listener);
    }

    protected void fireSessionIDAdded(String key, int index) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$sessionid$SessionIDListener == null ? SessionIDModel.class$("org.owasp.webscarab.plugin.sessionid.SessionIDListener") : class$org$owasp$webscarab$plugin$sessionid$SessionIDListener)) continue;
            try {
                ((SessionIDListener)listeners[i + 1]).sessionIDAdded(key, index);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireCalculatorChanged(String key) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$sessionid$SessionIDListener == null ? SessionIDModel.class$("org.owasp.webscarab.plugin.sessionid.SessionIDListener") : class$org$owasp$webscarab$plugin$sessionid$SessionIDListener)) continue;
            try {
                ((SessionIDListener)listeners[i + 1]).calculatorChanged(key);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireSessionIDsChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$sessionid$SessionIDListener == null ? SessionIDModel.class$("org.owasp.webscarab.plugin.sessionid.SessionIDListener") : class$org$owasp$webscarab$plugin$sessionid$SessionIDListener)) continue;
            try {
                ((SessionIDListener)listeners[i + 1]).sessionIDsChanged();
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }
}

