/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.bsf.BSFManager;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.proxy.Listener;
import org.owasp.webscarab.plugin.proxy.ListenerSpec;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;
import org.owasp.webscarab.plugin.proxy.ProxyUI;
import org.owasp.webscarab.plugin.proxy.ScriptableConnection;

public class Proxy
implements Plugin {
    private boolean _running = false;
    private Framework _framework = null;
    private ProxyUI _ui = null;
    private ArrayList _plugins = new ArrayList();
    private TreeMap _listeners = new TreeMap();
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _status = "Stopped";
    private int _pending = 0;
    private ConnectionHook _allowConnection = new ConnectionHook("Allow connection", "Called when a new connection is received from a browser\nuse connection.getAddress() and connection.closeConnection() to decide and react");
    private ConnectionHook _interceptRequest = new ConnectionHook("Intercept request", "Called when a new request has been submitted by the browser\nuse connection.getRequest() and connection.setRequest(request) to perform changes");
    private ConnectionHook _interceptResponse = new ConnectionHook("Intercept response", "Called when the request has been submitted to the server, and the response has been recieved.\nuse connection.getResponse() and connection.setResponse(response) to perform changes");

    public Proxy(Framework framework) {
        this._framework = framework;
        this.parseListenerConfig();
    }

    public Hook[] getScriptingHooks() {
        return new Hook[]{this._allowConnection, this._interceptRequest, this._interceptResponse};
    }

    public Object getScriptableObject() {
        return null;
    }

    void allowClientConnection(ScriptableConnection connection) {
        this._allowConnection.runScripts(connection);
    }

    void interceptRequest(ScriptableConnection connection) {
        this._interceptRequest.runScripts(connection);
    }

    void interceptResponse(ScriptableConnection connection) {
        this._interceptResponse.runScripts(connection);
    }

    public void setUI(ProxyUI ui) {
        this._ui = ui;
        if (this._ui != null) {
            this._ui.setEnabled(this._running);
        }
    }

    public void addPlugin(ProxyPlugin plugin) {
        this._plugins.add(plugin);
    }

    public ProxyPlugin getPlugin(String name) {
        ProxyPlugin plugin = null;
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            plugin = (ProxyPlugin)it.next();
            if (!plugin.getPluginName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public String getPluginName() {
        return new String("Proxy");
    }

    public ListenerSpec[] getProxies() {
        if (this._listeners.size() == 0) {
            return new ListenerSpec[0];
        }
        return this._listeners.keySet().toArray(new ListenerSpec[0]);
    }

    protected ProxyPlugin[] getPlugins() {
        ProxyPlugin[] plugins = new ProxyPlugin[this._plugins.size()];
        for (int i = 0; i < this._plugins.size(); ++i) {
            plugins[i] = (ProxyPlugin)this._plugins.get(i);
        }
        return plugins;
    }

    public void addListener(ListenerSpec spec) {
        this.createListener(spec);
        this.startListener((Listener)this._listeners.get(spec));
        String key = this.getKey(spec);
        Preferences.setPreference("Proxy.listener." + key + ".base", spec.getBase() == null ? "" : spec.getBase().toString());
        Preferences.setPreference("Proxy.listener." + key + ".primary", spec.isPrimaryProxy() ? "yes" : "no");
        String value = null;
        Iterator i = this._listeners.keySet().iterator();
        while (i.hasNext()) {
            key = this.getKey((ListenerSpec)i.next());
            if (value == null) {
                value = key;
                continue;
            }
            value = value + ", " + key;
        }
        Preferences.setPreference("Proxy.listeners", value);
    }

    private String getKey(ListenerSpec spec) {
        return spec.getAddress() + ":" + spec.getPort();
    }

    private void startListener(Listener l) {
        Thread t = new Thread((Runnable)l, "Listener-" + this.getKey(l.getListenerSpec()));
        t.setDaemon(true);
        t.start();
        if (this._ui != null) {
            this._ui.proxyStarted(l.getListenerSpec());
        }
    }

    private boolean stopListener(Listener l) {
        boolean stopped = l.stop();
        if (stopped && this._ui != null) {
            this._ui.proxyStopped(l.getListenerSpec());
        }
        return stopped;
    }

    public boolean removeListener(ListenerSpec spec) {
        Listener l = (Listener)this._listeners.get(spec);
        if (l == null) {
            return false;
        }
        if (this.stopListener(l)) {
            this._listeners.remove(spec);
            if (this._ui != null) {
                this._ui.proxyRemoved(spec);
            }
            String key = this.getKey(spec);
            Preferences.remove("Proxy.listener." + key + ".base");
            Preferences.remove("Proxy.listener." + key + ".simulator");
            Preferences.remove("Proxy.listener." + key + ".primary");
            String value = null;
            Iterator i = this._listeners.keySet().iterator();
            while (i.hasNext()) {
                key = this.getKey((ListenerSpec)i.next());
                if (value == null) {
                    value = key;
                    continue;
                }
                value = value + ", " + key;
            }
            if (value == null) {
                value = "";
            }
            Preferences.setPreference("Proxy.listeners", value);
            return true;
        }
        return false;
    }

    public void run() {
        Iterator it = this._listeners.keySet().iterator();
        while (it.hasNext()) {
            ListenerSpec spec = (ListenerSpec)it.next();
            try {
                spec.verifyAvailable();
                Listener l = (Listener)this._listeners.get(spec);
                if (l == null) {
                    this.createListener(spec);
                    l = (Listener)this._listeners.get(spec);
                }
                this.startListener(l);
            }
            catch (IOException ioe) {
                this._logger.warning("Unable to start listener " + spec);
                if (this._ui != null) {
                    this._ui.proxyStartError(spec, ioe);
                }
                this.removeListener(spec);
            }
        }
        this._running = true;
        if (this._ui != null) {
            this._ui.setEnabled(this._running);
        }
        this._status = "Started, Idle";
    }

    public boolean stop() {
        this._running = false;
        Iterator it = this._listeners.keySet().iterator();
        while (it.hasNext()) {
            ListenerSpec spec = (ListenerSpec)it.next();
            Listener l = (Listener)this._listeners.get(spec);
            if (l == null || this.stopListener(l)) continue;
            this._logger.severe("Failed to stop Listener-" + l.getListenerSpec());
            this._running = true;
        }
        if (this._ui != null) {
            this._ui.setEnabled(this._running);
        }
        this._status = "Stopped";
        return !this._running;
    }

    protected ConversationID gotRequest(Request request) {
        ConversationID id = this._framework.reserveConversationID();
        if (this._ui != null) {
            this._ui.requested(id, request.getMethod(), request.getURL());
        }
        ++this._pending;
        this._status = "Started, " + this._pending + " in progress";
        return id;
    }

    protected void gotResponse(ConversationID id, Response response) {
        if (this._ui != null) {
            this._ui.received(id, response.getStatusLine());
        }
        this._framework.addConversation(id, response.getRequest(), response, this.getPluginName());
        --this._pending;
        this._status = "Started, " + (this._pending > 0 ? this._pending + " in progress" : "Idle");
    }

    protected void failedResponse(ConversationID id, String reason) {
        if (this._ui != null) {
            this._ui.aborted(id, reason);
        }
        --this._pending;
        this._status = "Started, " + (this._pending > 0 ? this._pending + " in progress" : "Idle");
    }

    private void parseListenerConfig() {
        String prop = "Proxy.listeners";
        String value = Preferences.getPreference(prop);
        if (value == null || value.trim().equals("")) {
            this._logger.warning("No proxies configured!?");
            value = "127.0.0.1:8008";
        }
        String[] listeners = value.trim().split(" *,+ *");
        int port = 0;
        boolean primary = false;
        for (int i = 0; i < listeners.length; ++i) {
            HttpUrl base;
            String addr = listeners[i].substring(0, listeners[i].indexOf(":"));
            try {
                port = Integer.parseInt(listeners[i].substring(listeners[i].indexOf(":") + 1).trim());
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing port for " + listeners[i] + ", skipping it!");
                continue;
            }
            prop = "Proxy.listener." + listeners[i] + ".base";
            value = Preferences.getPreference(prop, "");
            if (value.equals("")) {
                base = null;
            } else {
                try {
                    base = new HttpUrl(value);
                }
                catch (MalformedURLException mue) {
                    this._logger.severe("Malformed 'base' parameter for listener '" + listeners[i] + "'");
                    break;
                }
            }
            prop = "Proxy.listener." + listeners[i] + ".primary";
            value = Preferences.getPreference(prop, "false");
            primary = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
            this._listeners.put(new ListenerSpec(addr, port, base, primary), null);
        }
    }

    private void createListener(ListenerSpec spec) {
        Listener l = new Listener(this, spec);
        this._listeners.put(spec, l);
        if (this._ui != null) {
            this._ui.proxyAdded(spec);
        }
    }

    public void flush() throws StoreException {
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)it.next();
            plugin.flush();
        }
    }

    public boolean isBusy() {
        return this._pending > 0;
    }

    public String getStatus() {
        return this._status;
    }

    public boolean isModified() {
        return false;
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)it.next();
            plugin.setSession(type, store, session);
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    private class ConnectionHook
    extends Hook {
        public ConnectionHook(String name, String description) {
            super(name, description);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runScripts(ScriptableConnection connection) {
            if (this._bsfManager == null) {
                return;
            }
            BSFManager bSFManager = this._bsfManager;
            synchronized (bSFManager) {
                try {
                    this._bsfManager.declareBean("connection", (Object)connection, connection.getClass());
                    super.runScripts();
                    this._bsfManager.undeclareBean("connection");
                }
                catch (Exception e) {
                    Proxy.this._logger.severe("Declaring or undeclaring a bean should not throw an exception! " + e);
                }
            }
        }
    }
}

