/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.proxy.BeanShellUI;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;

public class BeanShell
extends ProxyPlugin {
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _scriptFile = "";
    private String _beanScript;
    private String _defaultScript = "/* Please read the JavaDoc and/or the source to understand what methods are available */\n\nimport org.owasp.webscarab.model.Request;\nimport org.owasp.webscarab.model.Response;\nimport org.owasp.webscarab.httpclient.HTTPClient;\nimport java.io.IOException;\n\npublic Response fetchResponse(HTTPClient nextPlugin, Request request) throws IOException {\n   response = nextPlugin.fetchResponse(request);\n   return response;\n}\n";
    private Interpreter _interpreter = new Interpreter();
    private Framework _framework = null;
    private boolean _enabled = false;
    private BeanShellUI _ui = null;

    public BeanShell(Framework framework) {
        this._framework = framework;
        try {
            this._interpreter.set("framework", this._framework);
        }
        catch (EvalError ee) {
            this._logger.severe("Couldn't set framework: " + ee);
        }
        this.parseProperties();
    }

    public void setUI(BeanShellUI ui) {
        this._ui = ui;
        PrintStream ps = this._ui.getOut();
        if (ps != null) {
            this._interpreter.setOut(ps);
        }
        if ((ps = this._ui.getErr()) != null) {
            this._interpreter.setErr(ps);
        }
    }

    private void parseProperties() {
        String value;
        String prop = "BeanShell.scriptFile";
        this._scriptFile = value = Preferences.getPreference(prop, "");
        if (!this._scriptFile.equals("")) {
            this.loadScriptFile(this._scriptFile);
        } else {
            try {
                this.setScript(this._defaultScript);
            }
            catch (EvalError ee) {
                this._logger.severe("Invalid default script string " + ee);
            }
        }
        prop = "BeanShell.enabled";
        value = Preferences.getPreference(prop, "");
        this.setEnabled(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public String getPluginName() {
        return new String("Bean Shell");
    }

    public void setEnabled(boolean bool) {
        this._enabled = bool;
        String prop = "BeanShell.enabled";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    private void loadScriptFile(String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            this.setScript(sb.toString());
        }
        catch (Exception e) {
            this._logger.severe("Error reading BeanShell script from '" + filename + "' : " + e);
            try {
                this.setScript(this._defaultScript);
            }
            catch (EvalError ee) {
                this._logger.severe("Invalid default script string: " + ee);
            }
        }
    }

    public void setScriptFile(String filename) throws EvalError {
        this._scriptFile = filename;
        String prop = "BeanShell.scriptFile";
        Preferences.setPreference(prop, filename);
        if (!filename.equals("")) {
            this.loadScriptFile(filename);
        } else {
            this.setScript(this._defaultScript);
        }
    }

    public String getScriptFile() {
        return this._scriptFile;
    }

    public void setScript(String script) throws EvalError {
        this._beanScript = script;
        this._interpreter = new Interpreter();
        this._interpreter.eval(this._beanScript);
    }

    public String getScript() {
        return this._beanScript;
    }

    public HTTPClient getProxyPlugin(HTTPClient in) {
        return new Plugin(in);
    }

    private class Plugin
    implements HTTPClient {
        private HTTPClient _in;

        public Plugin(HTTPClient in) {
            this._in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Response fetchResponse(Request request) throws IOException {
            if (BeanShell.this._enabled) {
                try {
                    Interpreter interpreter = BeanShell.this._interpreter;
                    synchronized (interpreter) {
                        BeanShell.this._interpreter.unset("response");
                        BeanShell.this._interpreter.set("nextClient", this._in);
                        BeanShell.this._interpreter.set("request", request);
                        try {
                            BeanShell.this._interpreter.eval("Response response = fetchResponse(nextClient, request);");
                        }
                        catch (TargetError te) {
                            if (te.getTarget() instanceof IOException) {
                                throw (IOException)te.getTarget();
                            }
                            throw te;
                        }
                        Response response = (Response)BeanShell.this._interpreter.get("response");
                        BeanShell.this._interpreter.unset("model");
                        BeanShell.this._interpreter.unset("response");
                        BeanShell.this._interpreter.unset("nextClient");
                        BeanShell.this._interpreter.unset("request");
                        response.setHeader("X-BeanShell", "possibly modified");
                        return response;
                    }
                }
                catch (EvalError e) {
                    System.err.println("e is a " + e.getClass());
                    if (BeanShell.this._ui != null) {
                        BeanShell.this._ui.getErr().println(e.toString());
                    }
                    throw new IOException("Error evaluating bean script : " + e);
                }
            }
            return this._in.fetchResponse(request);
        }
    }
}

