/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fuzz.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.plugin.fuzz.FuzzFactory;
import org.owasp.webscarab.plugin.fuzz.FuzzSource;
import org.owasp.webscarab.plugin.fuzz.Fuzzer;
import org.owasp.webscarab.plugin.fuzz.FuzzerEvent;
import org.owasp.webscarab.plugin.fuzz.FuzzerListener;
import org.owasp.webscarab.plugin.fuzz.FuzzerModel;
import org.owasp.webscarab.plugin.fuzz.Parameter;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.ShowConversationAction;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;

public class FuzzerPanel
extends JPanel
implements SwingPluginUI {
    private static final long serialVersionUID = -6271384466092738141L;
    private Fuzzer _fuzzer;
    private FuzzerModel _model;
    private HeaderTableModel _headerTableModel;
    private ParameterTableModel _parameterTableModel;
    private FuzzFactory _fuzzFactory;
    private DefaultComboBoxModel _fuzzSources;
    private DefaultListModel _fuzzItems;
    private ShowConversationAction _showAction;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private JPanel actionPanel;
    private JButton addButton;
    private JButton addHeaderButton;
    private JButton addParameterButton;
    private JButton browseButton;
    private JButton closeButton;
    private JTable conversationTable;
    private JTextField currentTextField;
    private JButton deleteButton;
    private JButton deleteHeaderButton;
    private JButton deleteParameterButton;
    private JTextField descriptionTextField;
    private JTextField fileNameTextField;
    private JDialog fuzzDialog;
    private JPanel fuzzPanel;
    private JPanel headerPanel;
    private JTable headerTable;
    private JLabel itemsLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTextField methodTextField;
    private JList nameList;
    private JTable paramTable;
    private JPanel parameterPanel;
    private JTextField regexTextField;
    private JPanel requestPanel;
    private JButton sourcesButton;
    private JButton startButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JButton stopButton;
    private JTextField totalTextField;
    private JTextField urlTextField;
    private JList valueList;
    private JTextField versionTextField;

    public FuzzerPanel(Fuzzer fuzzer) {
        this._fuzzer = fuzzer;
        this._model = fuzzer.getModel();
        this.initComponents();
        this.initFields();
        this._fuzzFactory = this._fuzzer.getFuzzFactory();
        this.configureTables();
        this.addTableListeners();
        this.configureFuzzDialog();
        Listener listener = new Listener();
        this._model.addPropertyChangeListener(listener);
        this._model.addModelListener(listener);
        this._fuzzFactory.addPropertyChangeListener(listener);
    }

    private void configureTables() {
        this._headerTableModel = new HeaderTableModel();
        this.headerTable.setModel(this._headerTableModel);
        this._parameterTableModel = new ParameterTableModel();
        this.paramTable.setModel(this._parameterTableModel);
        DefaultComboBoxModel<String> paramTypes = new DefaultComboBoxModel<String>(Parameter.getParameterLocations());
        DefaultCellEditor dce = new DefaultCellEditor(new JComboBox<String>(paramTypes));
        TableColumn col = this.paramTable.getColumnModel().getColumn(0);
        col.setCellEditor(dce);
        this._fuzzSources = new DefaultComboBoxModel<String>(this._fuzzFactory.getSourceDescriptions());
        this._fuzzSources.insertElementAt("", 0);
        dce = new DefaultCellEditor(new JComboBox(this._fuzzSources));
        col = this.paramTable.getColumnModel().getColumn(5);
        col.setCellEditor(dce);
        this.paramTable.setRowHeight((int)dce.getComponent().getPreferredSize().getHeight());
        this.conversationTable.setModel(new ConversationTableModel(this._model.getConversationModel()));
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.conversationTable);
        this.conversationTable.setDefaultRenderer(Date.class, new DateRenderer());
    }

    private void addTableListeners() {
        this._showAction = new ShowConversationAction(this._model.getConversationModel());
        this.conversationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FuzzerPanel.this._logger.info("Selection changed");
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = FuzzerPanel.this.conversationTable.getSelectedRow();
                TableModel tm = FuzzerPanel.this.conversationTable.getModel();
                if (row > -1) {
                    ConversationID id = (ConversationID)tm.getValueAt(row, 0);
                    FuzzerPanel.this._showAction.putValue("CONVERSATION", id);
                    FuzzerPanel.this._logger.info("Conversation " + id + " selected");
                } else {
                    FuzzerPanel.this._showAction.putValue("CONVERSATION", null);
                }
            }
        });
        this.conversationTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                FuzzerPanel.this._logger.info("Mouse clicked in the table");
                int row = FuzzerPanel.this.conversationTable.rowAtPoint(e.getPoint());
                FuzzerPanel.this.conversationTable.getSelectionModel().setSelectionInterval(row, row);
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ActionEvent evt = new ActionEvent(FuzzerPanel.this.conversationTable, 0, (String)FuzzerPanel.this._showAction.getValue("ActionCommandKey"));
                    if (FuzzerPanel.this._showAction.isEnabled()) {
                        FuzzerPanel.this._showAction.actionPerformed(evt);
                    }
                }
            }
        });
    }

    private void configureFuzzDialog() {
        this.fuzzDialog.setBounds(200, 200, 600, 400);
        this.fuzzDialog.setResizable(false);
        this._fuzzItems = new DefaultListModel();
        this.valueList.setModel(this._fuzzItems);
        this.nameList.setModel(this._fuzzSources);
        this.nameList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FuzzSource source;
                FuzzerPanel.this._fuzzItems.clear();
                FuzzerPanel.this.itemsLabel.setText("Items : ");
                Object value = FuzzerPanel.this.nameList.getSelectedValue();
                if (value != null && !"".equals(value) && (source = FuzzerPanel.this._fuzzFactory.getSource((String)value)) != null) {
                    FuzzerPanel.this.itemsLabel.setText("Items : " + source.size());
                    while (source.hasNext() && FuzzerPanel.this._fuzzItems.size() < 100) {
                        FuzzerPanel.this._fuzzItems.addElement(source.current());
                        source.increment();
                    }
                }
            }
        });
    }

    private void initFields() {
        this.methodTextField.setText(this._model.getFuzzMethod());
        this.urlTextField.setText(this._model.getFuzzUrl());
        this.versionTextField.setText(this._model.getFuzzVersion());
        this.statusLabel.setText(this._model.getStatus());
        this.totalTextField.setText(Integer.toString(this._model.getTotalRequests()));
        this.currentTextField.setText(Integer.toString(this._model.getRequestIndex()));
    }

    private void updateFields(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (evt.getSource() == this._fuzzFactory) {
            this._fuzzSources.removeAllElements();
            this._fuzzSources.addElement("");
            String[] names = this._fuzzFactory.getSourceDescriptions();
            for (int i = 0; i < names.length; ++i) {
                this._fuzzSources.addElement(names[i]);
            }
        } else if (property.equals("FuzzMethod") && !value.equals(this.methodTextField.getText())) {
            this.methodTextField.setText(value.toString());
        } else if (property.equals("FuzzUrl") && !value.toString().equals(this.urlTextField.getText())) {
            this.urlTextField.setText(value.toString());
        } else if (property.equals("FuzzVersion") && !value.equals(this.versionTextField.getText())) {
            this.versionTextField.setText(value.toString());
        } else if (property.equals("RequestIndex") && !value.equals(this.currentTextField.getText())) {
            this.currentTextField.setText(value.toString());
        } else if (property.equals("TotalRequests") && !value.equals(this.totalTextField.getText())) {
            this.totalTextField.setText(value.toString());
        } else if (property.equals("Status")) {
            this.statusLabel.setText(value.toString());
        }
    }

    private void initComponents() {
        this.fuzzDialog = new JDialog();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.nameList = new JList();
        this.jLabel10 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.valueList = new JList();
        this.itemsLabel = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.regexTextField = new JTextField();
        this.fileNameTextField = new JTextField();
        this.browseButton = new JButton();
        this.jPanel3 = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.closeButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fuzzPanel = new JPanel();
        this.requestPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.methodTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.urlTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.versionTextField = new JTextField();
        this.headerPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.headerTable = new JTable();
        this.jPanel1 = new JPanel();
        this.addHeaderButton = new JButton();
        this.deleteHeaderButton = new JButton();
        this.jLabel7 = new JLabel();
        this.parameterPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.paramTable = new JTable();
        this.jPanel2 = new JPanel();
        this.addParameterButton = new JButton();
        this.deleteParameterButton = new JButton();
        this.statusPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.totalTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.currentTextField = new JTextField();
        this.actionPanel = new JPanel();
        this.sourcesButton = new JButton();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.jScrollPane5 = new JScrollPane();
        this.conversationTable = new JTable();
        this.statusLabel = new JLabel();
        this.fuzzDialog.getContentPane().setLayout(new GridBagLayout());
        this.fuzzDialog.setTitle("Fuzz Sources");
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel8.setText("Fuzz Sources");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane3.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.jScrollPane3.setMinimumSize(new Dimension(100, 50));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 131));
        this.nameList.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.nameList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel10.setText("Items");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.jLabel10, gridBagConstraints);
        this.jScrollPane4.setViewportView(this.valueList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.jScrollPane4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.fuzzDialog.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.itemsLabel.setText("Items : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.itemsLabel, gridBagConstraints);
        this.jLabel9.setText("Description : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel11.setText("RegEx : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.descriptionTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.regexTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.fileNameTextField, gridBagConstraints);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.browseButton, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(1, 2));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.addButton);
        this.deleteButton.setText("Remove");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.deleteButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        this.fuzzDialog.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel4.setText("File : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.fuzzDialog.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.fuzzPanel.setLayout(new GridBagLayout());
        this.requestPanel.setLayout(new GridBagLayout());
        this.jLabel3.setText("Method");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.requestPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.methodTextField.setText("GET");
        this.methodTextField.setPreferredSize(new Dimension(50, 19));
        this.methodTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.methodTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.requestPanel.add((Component)this.methodTextField, gridBagConstraints);
        this.jLabel5.setText("URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.requestPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.urlTextField.setMinimumSize(new Dimension(100, 19));
        this.urlTextField.setPreferredSize(new Dimension(200, 19));
        this.urlTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.urlTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.requestPanel.add((Component)this.urlTextField, gridBagConstraints);
        this.jLabel6.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.requestPanel.add((Component)this.jLabel6, gridBagConstraints);
        this.versionTextField.setText("HTTP/1.1");
        this.versionTextField.setMinimumSize(new Dimension(70, 19));
        this.versionTextField.setPreferredSize(new Dimension(70, 19));
        this.versionTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.versionTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.requestPanel.add((Component)this.versionTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.fuzzPanel.add((Component)this.requestPanel, gridBagConstraints);
        this.headerPanel.setLayout(new GridBagLayout());
        this.headerPanel.setMinimumSize(new Dimension(22, 50));
        this.headerPanel.setPreferredSize(new Dimension(527, 100));
        this.headerTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.headerTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.headerPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(2, 1));
        this.addHeaderButton.setText("Add");
        this.addHeaderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.addHeaderButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addHeaderButton);
        this.deleteHeaderButton.setText("Delete");
        this.deleteHeaderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.deleteHeaderButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.deleteHeaderButton);
        this.headerPanel.add((Component)this.jPanel1, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.2;
        this.fuzzPanel.add((Component)this.headerPanel, gridBagConstraints);
        this.jLabel7.setText("Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.fuzzPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.parameterPanel.setLayout(new GridBagLayout());
        this.paramTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane2.setViewportView(this.paramTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.parameterPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(2, 1));
        this.addParameterButton.setText("Add");
        this.addParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.addParameterButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.addParameterButton);
        this.deleteParameterButton.setText("Delete");
        this.deleteParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.deleteParameterButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.deleteParameterButton);
        this.parameterPanel.add((Component)this.jPanel2, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.fuzzPanel.add((Component)this.parameterPanel, gridBagConstraints);
        this.statusPanel.setLayout(new GridLayout(2, 2));
        this.jLabel1.setText("Total Requests : ");
        this.statusPanel.add(this.jLabel1);
        this.totalTextField.setColumns(5);
        this.totalTextField.setEditable(false);
        this.totalTextField.setMinimumSize(new Dimension(50, 19));
        this.statusPanel.add(this.totalTextField);
        this.jLabel2.setText("Current Request : ");
        this.statusPanel.add(this.jLabel2);
        this.currentTextField.setColumns(5);
        this.currentTextField.setEditable(false);
        this.currentTextField.setMinimumSize(new Dimension(50, 19));
        this.statusPanel.add(this.currentTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.fuzzPanel.add((Component)this.statusPanel, gridBagConstraints);
        this.actionPanel.setLayout(new GridLayout(1, 0));
        this.sourcesButton.setText("Sources");
        this.sourcesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.sourcesButtonActionPerformed(evt);
            }
        });
        this.actionPanel.add(this.sourcesButton);
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.startButtonActionPerformed(evt);
            }
        });
        this.actionPanel.add(this.startButton);
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FuzzerPanel.this.stopButtonActionPerformed(evt);
            }
        });
        this.actionPanel.add(this.stopButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.fuzzPanel.add((Component)this.actionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fuzzPanel, gridBagConstraints);
        this.conversationTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.conversationTable.setAutoResizeMode(0);
        this.jScrollPane5.setViewportView(this.conversationTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.jScrollPane5, gridBagConstraints);
        this.statusLabel.setMaximumSize(new Dimension(200, 15));
        this.statusLabel.setMinimumSize(new Dimension(200, 15));
        this.statusLabel.setPreferredSize(new Dimension(150, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.statusLabel, gridBagConstraints);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.fuzzDialog.setVisible(false);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser jfc = new JFileChooser(this.fileNameTextField.getText());
        jfc.setDialogTitle("Select a file to load");
        int returnVal = jfc.showOpenDialog(this.fuzzDialog);
        if (returnVal == 0 && (file = jfc.getSelectedFile()) != null && !file.isDirectory()) {
            this.fileNameTextField.setText(file.toString());
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        String name = (String)this.nameList.getSelectedValue();
        if (name != null) {
            this._fuzzFactory.removeSource(name);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String description = this.descriptionTextField.getText();
        String fileName = this.fileNameTextField.getText();
        String regex = this.regexTextField.getText();
        if (description.equals("")) {
            JOptionPane.showMessageDialog(null, new String[]{"Description cannot be empty"}, "Error", 0);
            return;
        }
        if (!regex.equals("") && !fileName.equals("")) {
            JOptionPane.showMessageDialog(null, new String[]{"Please enter EITHER a Regular Expression OR a File name"}, "Error", 0);
            return;
        }
        if (regex.equals("") && fileName.equals("")) {
            JOptionPane.showMessageDialog(null, new String[]{"Please enter EITHER a Regular Expression OR a File name"}, "Error", 0);
            return;
        }
        if (!fileName.equals("")) {
            try {
                File file = new File(fileName);
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(null, new String[]{file.toString() + " is a directory"}, "Error", 0);
                    return;
                }
                this._fuzzFactory.loadFuzzStrings(description, file);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, new String[]{"Error loading fuzz strings!", ioe.getMessage()}, "Error", 0);
            }
            return;
        }
        if (!regex.equals("")) {
            try {
                this._fuzzFactory.addRegexSource(description, regex);
            }
            catch (PatternSyntaxException pse) {
                JOptionPane.showMessageDialog(null, new String[]{"Invalid regular expression!", pse.getMessage()}, "Error", 0);
            }
            return;
        }
    }

    private void sourcesButtonActionPerformed(ActionEvent evt) {
        this.fuzzDialog.setVisible(true);
    }

    private void versionTextFieldActionPerformed(ActionEvent evt) {
        if (this._model.getFuzzVersion().equals(this.versionTextField.getText())) {
            return;
        }
        this._model.setFuzzVersion(this.versionTextField.getText());
    }

    private void methodTextFieldActionPerformed(ActionEvent evt) {
        if (this._model.getFuzzMethod().equals(this.methodTextField.getText())) {
            return;
        }
        this._model.setFuzzMethod(this.methodTextField.getText());
    }

    private void urlTextFieldActionPerformed(ActionEvent evt) {
        if (this._model.getFuzzUrl().equals(this.urlTextField.getText())) {
            return;
        }
        this._model.setFuzzUrl(this.urlTextField.getText());
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this._model.setBusyFuzzing(false);
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this.methodTextFieldActionPerformed(evt);
        this.urlTextFieldActionPerformed(evt);
        this.versionTextFieldActionPerformed(evt);
        this._fuzzer.startFuzzing();
    }

    private void deleteParameterButtonActionPerformed(ActionEvent evt) {
        int row = this.paramTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        this._model.removeFuzzParameter(row);
    }

    private void addParameterButtonActionPerformed(ActionEvent evt) {
        int row = this.paramTable.getSelectedRow();
        if (row == -1) {
            row = this.paramTable.getRowCount();
        }
        this._model.addFuzzParameter(row, new Parameter("Query", "v" + row, "String", "a" + row), null, 0);
    }

    private void deleteHeaderButtonActionPerformed(ActionEvent evt) {
        int row = this.headerTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        this._model.removeFuzzHeader(row);
    }

    private void addHeaderButtonActionPerformed(ActionEvent evt) {
        int row = this.headerTable.getSelectedRow();
        if (row == -1) {
            row = this.headerTable.getRowCount();
        }
        this._model.addFuzzHeader(row, new NamedValue("Header", "Value"));
    }

    public Action[] getConversationActions() {
        return new Action[]{new FuzzConversationAction()};
    }

    public ColumnDataModel[] getConversationColumns() {
        return new ColumnDataModel[0];
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return "Fuzzer";
    }

    public Action[] getUrlActions() {
        return new Action[0];
    }

    public ColumnDataModel[] getUrlColumns() {
        return new ColumnDataModel[0];
    }

    private class FuzzConversationAction
    extends AbstractAction {
        private static final long serialVersionUID = -8234938261159363334L;

        public FuzzConversationAction() {
            this.putValue("Name", "Use as fuzz template");
            this.putValue("ShortDescription", "Loads this request into the Fuzzer");
            this.putValue("CONVERSATION", null);
        }

        public void actionPerformed(ActionEvent e) {
            Object o = this.getValue("CONVERSATION");
            if (o == null || !(o instanceof ConversationID)) {
                return;
            }
            ConversationID id = (ConversationID)o;
            FuzzerPanel.this._fuzzer.loadTemplateFromConversation(id);
        }

        public void putValue(String key, Object value) {
            super.putValue(key, value);
            if (key != null && key.equals("CONVERSATION")) {
                if (value != null && value instanceof ConversationID) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }

    private class ParameterTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8566605696068089276L;
        private String[] _columnNames = new String[]{"Location", "Name", "Type", "Value", "Priority", "Fuzz Source"};

        private ParameterTableModel() {
        }

        public String getColumnName(int columnIndex) {
            return this._columnNames[columnIndex];
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public int getRowCount() {
            return FuzzerPanel.this._model.getFuzzParameterCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Parameter param = FuzzerPanel.this._model.getFuzzParameter(rowIndex);
            if (param == null) {
                return "null";
            }
            switch (columnIndex) {
                case 0: {
                    return param.getLocation();
                }
                case 1: {
                    return param.getName();
                }
                case 2: {
                    return param.getType();
                }
                case 3: {
                    return param.getValue();
                }
                case 4: {
                    return new Integer(FuzzerPanel.this._model.getFuzzParameterPriority(rowIndex));
                }
                case 5: {
                    FuzzSource source = FuzzerPanel.this._model.getParameterFuzzSource(rowIndex);
                    if (source != null) {
                        return source.getDescription();
                    }
                    return null;
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int ColumnIndex) {
            return true;
        }

        public void setValueAt(Object aValue, int rowIndex, int colIndex) {
            Parameter parameter = FuzzerPanel.this._model.getFuzzParameter(rowIndex);
            Object defValue = parameter.getValue();
            int priority = FuzzerPanel.this._model.getFuzzParameterPriority(rowIndex);
            FuzzSource source = FuzzerPanel.this._model.getParameterFuzzSource(rowIndex);
            switch (colIndex) {
                case 0: {
                    parameter = new Parameter((String)aValue, parameter.getName(), parameter.getType(), defValue);
                    break;
                }
                case 1: {
                    parameter = new Parameter(parameter.getLocation(), (String)aValue, parameter.getType(), defValue);
                    break;
                }
                case 2: {
                    parameter = new Parameter(parameter.getLocation(), parameter.getName(), (String)aValue, defValue);
                    break;
                }
                case 3: {
                    parameter = new Parameter(parameter.getLocation(), parameter.getName(), parameter.getType(), aValue);
                    break;
                }
                case 4: {
                    priority = Integer.parseInt(aValue.toString());
                    break;
                }
                case 5: {
                    source = FuzzerPanel.this._fuzzFactory.getSource((String)aValue);
                }
            }
            FuzzerPanel.this._model.setFuzzParameter(rowIndex, parameter, source, priority);
        }
    }

    private class HeaderTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3474321623837028739L;
        private String[] _columnNames = new String[]{"Header", "Value"};

        private HeaderTableModel() {
        }

        public String getColumnName(int columnIndex) {
            return this._columnNames[columnIndex];
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public int getRowCount() {
            return FuzzerPanel.this._model.getFuzzHeaderCount();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            NamedValue header = FuzzerPanel.this._model.getFuzzHeader(rowIndex);
            if (columnIndex == 0) {
                return header.getName();
            }
            return header.getValue();
        }

        public boolean isCellEditable(int rowIndex, int ColumnIndex) {
            return true;
        }

        public void setValueAt(Object aValue, int rowIndex, int colIndex) {
            NamedValue header = FuzzerPanel.this._model.getFuzzHeader(rowIndex);
            switch (colIndex) {
                case 0: {
                    header = new NamedValue((String)aValue, header.getValue());
                    break;
                }
                case 1: {
                    header = new NamedValue(header.getName(), (String)aValue);
                }
            }
            FuzzerPanel.this._model.setFuzzHeader(rowIndex, header);
        }
    }

    private class Listener
    implements PropertyChangeListener,
    FuzzerListener {
        private Listener() {
        }

        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this.updateFields(evt);
                }
            };
            this.runOnEDT(runner);
        }

        public void fuzzHeaderAdded(final FuzzerEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this._headerTableModel.fireTableRowsInserted(evt.getRow(), evt.getRow());
                }
            };
            this.runOnEDT(runner);
        }

        public void fuzzHeaderChanged(final FuzzerEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this._headerTableModel.fireTableRowsUpdated(evt.getRow(), evt.getRow());
                }
            };
            this.runOnEDT(runner);
        }

        public void fuzzHeaderRemoved(final FuzzerEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this._headerTableModel.fireTableRowsDeleted(evt.getRow(), evt.getRow());
                }
            };
            this.runOnEDT(runner);
        }

        public void fuzzParameterAdded(final FuzzerEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this._parameterTableModel.fireTableRowsInserted(evt.getRow(), evt.getRow());
                }
            };
            this.runOnEDT(runner);
        }

        public void fuzzParameterChanged(final FuzzerEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this._parameterTableModel.fireTableRowsUpdated(evt.getRow(), evt.getRow());
                }
            };
            this.runOnEDT(runner);
        }

        public void fuzzParameterRemoved(final FuzzerEvent evt) {
            Runnable runner = new Runnable(){

                public void run() {
                    FuzzerPanel.this._parameterTableModel.fireTableRowsDeleted(evt.getRow(), evt.getRow());
                }
            };
            this.runOnEDT(runner);
        }

        private void runOnEDT(Runnable runner) {
            if (SwingUtilities.isEventDispatchThread()) {
                runner.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

