/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fuzz;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.plugin.AbstractPluginModel;
import org.owasp.webscarab.plugin.fuzz.FuzzSource;
import org.owasp.webscarab.plugin.fuzz.FuzzerEvent;
import org.owasp.webscarab.plugin.fuzz.FuzzerListener;
import org.owasp.webscarab.plugin.fuzz.Parameter;
import org.owasp.webscarab.plugin.fuzz.Signature;
import org.owasp.webscarab.util.ReentrantReaderPreferenceReadWriteLock;

public class FuzzerModel
extends AbstractPluginModel {
    public static final String PROPERTY_FUZZMETHOD = "FuzzMethod";
    public static final String PROPERTY_FUZZURL = "FuzzUrl";
    public static final String PROPERTY_FUZZVERSION = "FuzzVersion";
    public static final String PROPERTY_REQUESTINDEX = "RequestIndex";
    public static final String PROPERTY_TOTALREQUESTS = "TotalRequests";
    public static final String PROPERTY_BUSYFUZZING = "BusyFuzzing";
    private FrameworkModel _model = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private EventListenerList _listenerList = new EventListenerList();
    private ReentrantReaderPreferenceReadWriteLock _rwl = new ReentrantReaderPreferenceReadWriteLock();
    private FuzzConversationModel _conversationModel;
    private String _fuzzMethod = "GET";
    private String _fuzzUrl = "http://localhost:8080/test";
    private String _fuzzVersion = "HTTP/1.0";
    private List _fuzzHeaders = new ArrayList();
    private List _fuzzParameters = new ArrayList();
    private List _fuzzSources = new ArrayList();
    private List _parameterPriorities = new ArrayList();
    private int _maxPriority = 0;
    private int _requestIndex = 0;
    private int _totalRequests = 0;
    private boolean _busyFuzzing = false;

    public FuzzerModel(FrameworkModel model) {
        this._model = model;
        this._conversationModel = new FuzzConversationModel(model);
    }

    public ConversationModel getConversationModel() {
        return this._conversationModel;
    }

    public void addConversation(ConversationID id) {
        this._conversationModel.addConversation(id);
    }

    public void setFuzzMethod(String method) {
        String old = this._fuzzMethod;
        this._fuzzMethod = method;
        if (old == null || this._fuzzMethod != old) {
            this._changeSupport.firePropertyChange(PROPERTY_FUZZMETHOD, old, this._fuzzMethod);
        }
        this.resetFuzzer();
    }

    public String getFuzzMethod() {
        return this._fuzzMethod;
    }

    public void setFuzzUrl(String url) {
        String old = this._fuzzUrl;
        this._fuzzUrl = url;
        if (old == null || this._fuzzUrl != old) {
            this._changeSupport.firePropertyChange(PROPERTY_FUZZURL, old, this._fuzzUrl);
        }
        this.resetFuzzer();
    }

    public String getFuzzUrl() {
        return this._fuzzUrl;
    }

    public void setFuzzVersion(String version) {
        String old = this._fuzzVersion;
        this._fuzzVersion = version;
        if (old == null || this._fuzzVersion != old) {
            this._changeSupport.firePropertyChange(PROPERTY_FUZZVERSION, old, this._fuzzVersion);
        }
        this.resetFuzzer();
    }

    public String getFuzzVersion() {
        return this._fuzzVersion;
    }

    public void setBusyFuzzing(boolean busy) {
        boolean old = this._busyFuzzing;
        this._busyFuzzing = busy;
        if (this._busyFuzzing != old) {
            this._changeSupport.firePropertyChange(PROPERTY_BUSYFUZZING, old, this._busyFuzzing);
        }
    }

    public boolean isBusyFuzzing() {
        return this._busyFuzzing;
    }

    public int getFuzzHeaderCount() {
        return this._fuzzHeaders.size();
    }

    public void addFuzzHeader(int index, NamedValue header) {
        this._fuzzHeaders.add(index, header);
        this.fireFuzzHeaderAdded(index);
        this.resetFuzzer();
    }

    public void setFuzzHeader(int index, NamedValue header) {
        this._fuzzHeaders.set(index, header);
        this.fireFuzzHeaderChanged(index);
        this.resetFuzzer();
    }

    public void removeFuzzHeader(int index) {
        this._fuzzHeaders.remove(index);
        this.fireFuzzHeaderRemoved(index);
        this.resetFuzzer();
    }

    public NamedValue getFuzzHeader(int position) {
        return (NamedValue)this._fuzzHeaders.get(position);
    }

    public int getFuzzParameterCount() {
        return this._fuzzParameters.size();
    }

    public void addFuzzParameter(int index, Parameter parameter, FuzzSource fuzzSource, int priority) {
        this._logger.info("Adding a parameter at index " + index);
        this._fuzzParameters.add(index, parameter);
        this._fuzzSources.add(index, fuzzSource);
        this._parameterPriorities.add(index, new Integer(priority));
        this.fireFuzzParameterAdded(index);
        this.resetFuzzer();
    }

    public void setFuzzParameter(int index, Parameter parameter, FuzzSource fuzzSource, int priority) {
        this._logger.info("Setting a parameter at index " + index + ", source is " + fuzzSource);
        this._fuzzParameters.set(index, parameter);
        this._fuzzSources.set(index, fuzzSource);
        this._parameterPriorities.set(index, new Integer(priority));
        this.fireFuzzParameterChanged(index);
        this.resetFuzzer();
    }

    public void removeFuzzParameter(int index) {
        this._logger.info("Removing parameter at index " + index);
        this._fuzzParameters.remove(index);
        this._fuzzSources.remove(index);
        this._parameterPriorities.remove(index);
        this.fireFuzzParameterRemoved(index);
        this.resetFuzzer();
    }

    public Parameter getFuzzParameter(int index) {
        return (Parameter)this._fuzzParameters.get(index);
    }

    public FuzzSource getParameterFuzzSource(int index) {
        return (FuzzSource)this._fuzzSources.get(index);
    }

    public int getFuzzParameterPriority(int index) {
        Integer p = (Integer)this._parameterPriorities.get(index);
        if (p == null) {
            return 0;
        }
        return p;
    }

    public Object getFuzzParameterValue(int index) {
        FuzzSource fuzzSource = this.getParameterFuzzSource(index);
        if (fuzzSource != null) {
            return fuzzSource.current();
        }
        return ((Parameter)this._fuzzParameters.get(index)).getValue();
    }

    public void resetFuzzer() {
        HashMap<Integer, Integer> sizes = new HashMap<Integer, Integer>();
        this._maxPriority = 0;
        int count = this.getFuzzParameterCount();
        for (int i = 0; i < count; ++i) {
            FuzzSource source = this.getParameterFuzzSource(i);
            if (source == null) continue;
            source.reset();
            Integer priority = new Integer(this.getFuzzParameterPriority(i));
            this._maxPriority = Math.max(priority, this._maxPriority);
            int size = source.size();
            Integer s = (Integer)sizes.get(priority);
            if (s == null) {
                sizes.put(priority, new Integer(size));
                continue;
            }
            sizes.put(priority, new Integer(Math.min(s, size)));
        }
        int totalsize = 1;
        Iterator it = sizes.values().iterator();
        while (it.hasNext()) {
            Integer size = (Integer)it.next();
            totalsize *= size.intValue();
        }
        this.setRequestIndex(0);
        this.setTotalRequests(totalsize);
        this._conversationModel.clear();
    }

    public boolean incrementFuzzer() {
        boolean success = false;
        int count = this.getFuzzParameterCount();
        for (int priority = 0; priority <= this._maxPriority; ++priority) {
            int paramPriority;
            FuzzSource source;
            int param;
            for (param = 0; param < count; ++param) {
                source = this.getParameterFuzzSource(param);
                if (source == null || (paramPriority = this.getFuzzParameterPriority(param)) != priority) continue;
                if (source.hasNext()) {
                    source.increment();
                    success = true;
                    continue;
                }
                success = false;
                break;
            }
            if (success) {
                this.setRequestIndex(this.getRequestIndex() + 1);
                return true;
            }
            for (param = 0; param < count; ++param) {
                source = this.getParameterFuzzSource(param);
                if (source == null || (paramPriority = this.getFuzzParameterPriority(param)) > priority) continue;
                source.reset();
            }
        }
        this.setRequestIndex(this.getTotalRequests());
        return false;
    }

    private void setRequestIndex(int index) {
        int old = this._requestIndex;
        this._requestIndex = index;
        if (this._requestIndex != old) {
            this._changeSupport.firePropertyChange(PROPERTY_REQUESTINDEX, old, this._requestIndex);
        }
    }

    public int getRequestIndex() {
        return this._requestIndex;
    }

    private void setTotalRequests(int count) {
        int old = this._totalRequests;
        this._totalRequests = count;
        if (this._totalRequests != old) {
            this._changeSupport.firePropertyChange(PROPERTY_TOTALREQUESTS, old, this._totalRequests);
        }
    }

    public int getTotalRequests() {
        return this._totalRequests;
    }

    public void addSignature(Signature signature) {
        HttpUrl url = signature.getUrl();
        this._model.addUrlProperty(url, "SIGNATURE", signature.toString());
    }

    public int getSignatureCount(HttpUrl url) {
        String[] signatures = this._model.getUrlProperties(url, "SIGNATURE");
        if (signatures == null) {
            return 0;
        }
        return signatures.length;
    }

    public Signature getSignature(HttpUrl url, int index) {
        String[] signatures = this._model.getUrlProperties(url, "SIGNATURE");
        if (signatures == null) {
            return null;
        }
        try {
            return new Signature(signatures[index]);
        }
        catch (MalformedURLException mue) {
            this._logger.severe("Malformed URL reading a signature! " + mue.getMessage());
            return null;
        }
    }

    public void addChecksum(HttpUrl url, String checksum) {
        this._model.addUrlProperty(url, "CHECKSUM", checksum);
    }

    public int getChecksumCount(HttpUrl url) {
        String[] checksums = this._model.getUrlProperties(url, "CHECKSUM");
        if (checksums == null) {
            return 0;
        }
        return checksums.length;
    }

    public String getChecksum(HttpUrl url, int index) {
        String[] checksums = this._model.getUrlProperties(url, "CHECKSUM");
        if (checksums == null) {
            return null;
        }
        return checksums[index];
    }

    public void addModelListener(FuzzerListener listener) {
        this._listenerList.add(FuzzerListener.class, listener);
    }

    public void removeModelListener(FuzzerListener listener) {
        this._listenerList.remove(FuzzerListener.class, listener);
    }

    protected void fireFuzzHeaderAdded(int index) {
        Object[] listeners = this._listenerList.getListenerList();
        FuzzerEvent evt = new FuzzerEvent(this, 101, index);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fuzz$FuzzerListener == null ? FuzzerModel.class$("org.owasp.webscarab.plugin.fuzz.FuzzerListener") : class$org$owasp$webscarab$plugin$fuzz$FuzzerListener)) continue;
            try {
                ((FuzzerListener)listeners[i + 1]).fuzzHeaderAdded(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireFuzzHeaderChanged(int index) {
        Object[] listeners = this._listenerList.getListenerList();
        FuzzerEvent evt = new FuzzerEvent(this, 102, index);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fuzz$FuzzerListener == null ? FuzzerModel.class$("org.owasp.webscarab.plugin.fuzz.FuzzerListener") : class$org$owasp$webscarab$plugin$fuzz$FuzzerListener)) continue;
            try {
                ((FuzzerListener)listeners[i + 1]).fuzzHeaderChanged(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireFuzzHeaderRemoved(int index) {
        Object[] listeners = this._listenerList.getListenerList();
        FuzzerEvent evt = new FuzzerEvent(this, 103, index);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fuzz$FuzzerListener == null ? FuzzerModel.class$("org.owasp.webscarab.plugin.fuzz.FuzzerListener") : class$org$owasp$webscarab$plugin$fuzz$FuzzerListener)) continue;
            try {
                ((FuzzerListener)listeners[i + 1]).fuzzHeaderRemoved(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireFuzzParameterAdded(int index) {
        Object[] listeners = this._listenerList.getListenerList();
        FuzzerEvent evt = new FuzzerEvent(this, 104, index);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fuzz$FuzzerListener == null ? FuzzerModel.class$("org.owasp.webscarab.plugin.fuzz.FuzzerListener") : class$org$owasp$webscarab$plugin$fuzz$FuzzerListener)) continue;
            try {
                ((FuzzerListener)listeners[i + 1]).fuzzParameterAdded(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireFuzzParameterChanged(int index) {
        Object[] listeners = this._listenerList.getListenerList();
        FuzzerEvent evt = new FuzzerEvent(this, 105, index);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fuzz$FuzzerListener == null ? FuzzerModel.class$("org.owasp.webscarab.plugin.fuzz.FuzzerListener") : class$org$owasp$webscarab$plugin$fuzz$FuzzerListener)) continue;
            try {
                ((FuzzerListener)listeners[i + 1]).fuzzParameterChanged(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireFuzzParameterRemoved(int index) {
        Object[] listeners = this._listenerList.getListenerList();
        FuzzerEvent evt = new FuzzerEvent(this, 106, index);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fuzz$FuzzerListener == null ? FuzzerModel.class$("org.owasp.webscarab.plugin.fuzz.FuzzerListener") : class$org$owasp$webscarab$plugin$fuzz$FuzzerListener)) continue;
            try {
                ((FuzzerListener)listeners[i + 1]).fuzzParameterRemoved(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    private class FuzzConversationModel
    extends AbstractConversationModel {
        private List _conversations;

        public FuzzConversationModel(FrameworkModel model) {
            super(model);
            this._conversations = new ArrayList();
        }

        void addConversation(ConversationID id) {
            try {
                FuzzerModel.this._rwl.writeLock().acquire();
                int index = this._conversations.size();
                this._conversations.add(id);
                FuzzerModel.this._rwl.readLock().acquire();
                FuzzerModel.this._rwl.writeLock().release();
                this.fireConversationAdded(id, index);
                FuzzerModel.this._rwl.readLock().release();
            }
            catch (InterruptedException ie) {
                FuzzerModel.this._logger.severe("Interrupted! " + ie);
            }
        }

        void clear() {
            try {
                FuzzerModel.this._rwl.writeLock().acquire();
                this._conversations.clear();
                FuzzerModel.this._rwl.readLock().acquire();
                FuzzerModel.this._rwl.writeLock().release();
                this.fireConversationsChanged();
                FuzzerModel.this._rwl.readLock().release();
            }
            catch (InterruptedException ie) {
                FuzzerModel.this._logger.severe("Interrupted! " + ie);
            }
        }

        public ConversationID getConversationAt(int index) {
            return (ConversationID)this._conversations.get(index);
        }

        public int getIndexOfConversation(ConversationID id) {
            return this._conversations.indexOf(id);
        }

        public Sync readLock() {
            return FuzzerModel.this._rwl.readLock();
        }

        public int getConversationCount() {
            return this._conversations.size();
        }
    }
}

