/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fuzz;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import org.owasp.webscarab.plugin.fuzz.FuzzSource;
import org.owasp.webscarab.plugin.fuzz.RegexSource;

public class FuzzFactory {
    public static final String SOURCES = "Sources";
    private Map _sources = new TreeMap();
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public String[] getSourceDescriptions() {
        return this._sources.keySet().toArray(new String[this._sources.size()]);
    }

    public void addSource(FuzzSource source) {
        this._sources.put(source.getDescription(), source);
        this._changeSupport.firePropertyChange(SOURCES, null, null);
    }

    public void loadFuzzStrings(String description, InputStream inputStream) throws IOException {
        this.addSource(new FileSource(description, new InputStreamReader(inputStream)));
    }

    public void loadFuzzStrings(String description, File file) throws IOException {
        this.addSource(new FileSource(description, new FileReader(file)));
    }

    public boolean removeSource(String name) {
        boolean success = this._sources.remove(name) != null;
        this._changeSupport.firePropertyChange(SOURCES, null, null);
        return success;
    }

    public void addRegexSource(String description, String regex) throws PatternSyntaxException {
        this.addSource(new RegexSource(description, regex));
    }

    public FuzzSource getSource(String name) {
        FuzzSource source = (FuzzSource)this._sources.get(name);
        if (source == null) {
            return null;
        }
        return source.newInstance();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private class ArraySource
    implements FuzzSource {
        private String _description;
        private String[] _items;
        private int _index = 0;

        public ArraySource(String description, String[] items) {
            this._description = description;
            this._items = items;
        }

        public String getDescription() {
            return this._description;
        }

        public int size() {
            return this._items.length;
        }

        public void reset() {
            this._index = 0;
        }

        public void increment() {
            ++this._index;
        }

        public boolean hasNext() {
            return this._index < this._items.length - 1;
        }

        public Object current() {
            return this._items[this._index];
        }

        public FuzzSource newInstance() {
            return new ArraySource(this._description, this._items);
        }
    }

    private class FileSource
    implements FuzzSource {
        private String _description;
        private String[] _items;
        private int _index = 0;

        public FileSource(String description, Reader reader) throws IOException {
            String line;
            this._description = description;
            BufferedReader br = new BufferedReader(reader);
            LinkedList<String> items = new LinkedList<String>();
            while ((line = br.readLine()) != null) {
                items.add(line);
            }
            br.close();
            this._items = items.toArray(new String[items.size()]);
        }

        public String getDescription() {
            return this._description;
        }

        public void increment() {
            ++this._index;
        }

        public boolean hasNext() {
            return this._index < this._items.length - 1;
        }

        public void reset() {
            this._index = 0;
        }

        public int size() {
            return this._items.length;
        }

        protected String[] getItems() {
            return this._items;
        }

        public Object current() {
            return this._items[this._index];
        }

        public FuzzSource newInstance() {
            return new ArraySource(this._description, this._items);
        }
    }
}

