/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.extensions.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.extensions.Extensions;
import org.owasp.webscarab.plugin.extensions.ExtensionsModel;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.ui.swing.UrlTreeModelAdapter;
import org.owasp.webscarab.ui.swing.UrlTreeRenderer;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.SwingWorker;
import org.owasp.webscarab.util.swing.TableSorter;

public class ExtensionsPanel
extends JPanel
implements SwingPluginUI {
    private static final long serialVersionUID = 431458232664764498L;
    private Extensions _extensions;
    private ExtensionsModel _model;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private JButton cancelButton;
    private JButton checkButton;
    private JPanel controlPanel;
    private JTable conversationTable;
    private JTextArea directoryTextArea;
    private JButton editButton;
    private JDialog editDialog;
    private JTextArea fileTextArea;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JButton loadButton;
    private JButton okButton;
    private JTabbedPane tabbedPane;
    private JTree urlTree;

    public ExtensionsPanel(Extensions extensions) {
        this._extensions = extensions;
        this._model = extensions.getModel();
        this.initComponents();
        this.urlTree.setModel(new UrlTreeModelAdapter(this._model.getUrlModel()));
        this.urlTree.setRootVisible(false);
        this.urlTree.setShowsRootHandles(true);
        this.urlTree.setCellRenderer(new UrlTreeRenderer());
        ConversationTableModel tm = new ConversationTableModel(this._model.getConversationModel());
        TableSorter ts = new TableSorter(tm, this.conversationTable.getTableHeader());
        this.conversationTable.setModel(ts);
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.conversationTable);
        this.conversationTable.setDefaultRenderer(Date.class, new DateRenderer());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.editDialog.setBounds((screenSize.width - 300) / 2, (screenSize.height - 150) / 2, 300, 150);
    }

    private void initComponents() {
        this.editDialog = new JDialog();
        this.tabbedPane = new JTabbedPane();
        this.jScrollPane4 = new JScrollPane();
        this.fileTextArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.directoryTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.loadButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.urlTree = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.conversationTable = new JTable();
        this.controlPanel = new JPanel();
        this.editButton = new JButton();
        this.checkButton = new JButton();
        this.editDialog.setTitle("Extensions");
        this.editDialog.setModal(true);
        this.tabbedPane.setMinimumSize(new Dimension(200, 200));
        this.tabbedPane.setPreferredSize(new Dimension(200, 200));
        this.jScrollPane4.setViewportView(this.fileTextArea);
        this.tabbedPane.addTab("File", this.jScrollPane4);
        this.jScrollPane3.setViewportView(this.directoryTextArea);
        this.tabbedPane.addTab("Directory", this.jScrollPane3);
        this.editDialog.getContentPane().add((Component)this.tabbedPane, "Center");
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionsPanel.this.loadButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.loadButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionsPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cancelButton);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionsPanel.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.okButton);
        this.editDialog.getContentPane().add((Component)this.jPanel3, "South");
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jScrollPane1.setViewportView(this.urlTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.conversationTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.conversationTable.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.conversationTable);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
        this.controlPanel.setLayout(new GridBagLayout());
        this.editButton.setText("Edit Extensions");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionsPanel.this.editButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        this.controlPanel.add((Component)this.editButton, gridBagConstraints);
        this.checkButton.setText("Check");
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionsPanel.this.checkButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add((Component)this.checkButton, new GridBagConstraints());
        this.add((Component)this.controlPanel, "South");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this._model.setDirectoryExtensions(this.stringToArray(this.directoryTextArea.getText()));
        this._model.setFileExtensions(this.stringToArray(this.fileTextArea.getText()));
        this.editDialog.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.editDialog.setVisible(false);
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("Extensions.DefaultDirectory"));
        jfc.setDialogTitle("Open extension file");
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == 0) {
            File extFile = jfc.getSelectedFile();
            try {
                String extensions = this.arrayToString(this._extensions.loadStrings(extFile));
                if (this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()).equals("File")) {
                    this.fileTextArea.setText(extensions);
                } else {
                    this.directoryTextArea.setText(extensions);
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, new String[]{"Error loading extensions: ", ioe.getMessage()}, "Error", 0);
            }
        }
        Preferences.setPreference("Extensions.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
    }

    private String arrayToString(String[] strings) {
        StringBuffer buff = new StringBuffer();
        if (strings == null) {
            return "";
        }
        for (int i = 0; i < strings.length; ++i) {
            buff.append(strings[i]).append("\n");
        }
        return buff.toString();
    }

    private String[] stringToArray(String string) {
        return string.split("\n");
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.fileTextArea.setText(this.arrayToString(this._model.getFileExtensions()));
        this.directoryTextArea.setText(this.arrayToString(this._model.getDirectoryExtensions()));
        this.editDialog.setVisible(true);
    }

    private void checkButtonActionPerformed(ActionEvent evt) {
        String action = evt.getActionCommand();
        if (action.equals("Stop")) {
            this._extensions.stopChecks();
            return;
        }
        TreePath[] selection = this.urlTree.getSelectionPaths();
        if (selection == null || selection.length == 0) {
            return;
        }
        if (this._extensions.isBusy()) {
            this.showBusyMessage();
            return;
        }
        final HttpUrl[] urls = new HttpUrl[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            urls[i] = (HttpUrl)selection[i].getLastPathComponent();
        }
        this.checkButton.setText("Stop");
        new SwingWorker(){

            public Object construct() {
                if (urls.length > 1) {
                    ExtensionsPanel.this._extensions.checkExtensionsFor(urls);
                } else {
                    ExtensionsPanel.this._extensions.checkExtensionsUnder(urls[0]);
                }
                return null;
            }

            public void finished() {
                ExtensionsPanel.this.checkButton.setText("Check");
            }
        }.start();
    }

    private void showBusyMessage() {
        this._logger.warning("Plugin is still busy, please wait");
        JOptionPane.showMessageDialog(this, "Plugin is still busy", "Please wait!", 1);
    }

    public Action[] getConversationActions() {
        return null;
    }

    public ColumnDataModel[] getConversationColumns() {
        return null;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return this._extensions.getPluginName();
    }

    public Action[] getUrlActions() {
        return null;
    }

    public ColumnDataModel[] getUrlColumns() {
        return null;
    }
}

