/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedValue {
    private String _name;
    private String _value;
    private static Logger _logger = Logger.getLogger("org.owasp.webscarab.model.NamedValue");

    public NamedValue(String name, String value) {
        _logger.setLevel(Level.INFO);
        this._name = name;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this._name + "='" + this._value + "'";
    }

    public static NamedValue[] splitNamedValues(String source, String pairSeparator, String nvSeparator) {
        try {
            if (source == null || "".equals(source)) {
                return new NamedValue[0];
            }
            String[] pairs = source.split(pairSeparator);
            _logger.fine("Split \"" + source + "\" into " + pairs.length);
            NamedValue[] values = new NamedValue[pairs.length];
            for (int i = 0; i < pairs.length; ++i) {
                String[] nv = pairs[i].split(nvSeparator, 2);
                values[i] = nv.length == 2 ? new NamedValue(nv[0], nv[1]) : (nv.length == 1 ? new NamedValue(nv[0], "") : null);
            }
            return values;
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            _logger.warning("Error splitting \"" + source + "\" using '" + pairSeparator + "' and '" + nvSeparator + "'");
            return new NamedValue[0];
        }
    }
}

