/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.nodes;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.AbstractNode;
import org.htmlparser.scanners.Scanner;
import org.htmlparser.scanners.TagScanner;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SpecialHashtable;
import org.htmlparser.visitors.NodeVisitor;

public class TagNode
extends AbstractNode
implements Tag {
    private static final String[] NONE = new String[0];
    private Scanner mScanner = mDefaultScanner;
    protected static final Scanner mDefaultScanner = new TagScanner();
    protected Vector mAttributes;
    protected static Hashtable breakTags = new Hashtable(30);

    public TagNode() {
        this(null, -1, -1, new Vector());
    }

    public TagNode(Page page, int start, int end, Vector attributes) {
        super(page, start, end);
        this.mAttributes = attributes;
        if (null == this.mAttributes || 0 == this.mAttributes.size()) {
            String[] names = this.getIds();
            if (null != names && 0 != names.length) {
                this.setTagName(names[0]);
            } else {
                this.setTagName("");
            }
        }
    }

    public TagNode(TagNode tag, TagScanner scanner) {
        this(tag.getPage(), tag.getTagBegin(), tag.getTagEnd(), tag.getAttributesEx());
        this.setThisScanner(scanner);
    }

    public String getAttribute(String name) {
        String ret = null;
        if (name.equalsIgnoreCase("$<TAGNAME>$")) {
            ret = ((Attribute)this.getAttributesEx().elementAt(0)).getName();
        } else {
            Attribute attribute = this.getAttributeEx(name);
            if (null != attribute) {
                ret = attribute.getValue();
            }
        }
        return ret;
    }

    public void setAttribute(String key, String value) {
        char quote;
        char ch;
        int i;
        boolean needed = false;
        boolean singleq = true;
        boolean doubleq = true;
        if (null != value) {
            for (i = 0; i < value.length(); ++i) {
                ch = value.charAt(i);
                if (Character.isWhitespace(ch)) {
                    needed = true;
                    continue;
                }
                if ('\'' == ch) {
                    singleq = false;
                    continue;
                }
                if ('\"' != ch) continue;
                doubleq = false;
            }
        }
        if (needed) {
            if (doubleq) {
                quote = '\"';
            } else if (singleq) {
                quote = '\'';
            } else {
                quote = '\"';
                String ref = "&quot;";
                StringBuffer buffer = new StringBuffer(value.length() * 5);
                for (i = 0; i < value.length(); ++i) {
                    ch = value.charAt(i);
                    if (quote == ch) {
                        buffer.append(ref);
                        continue;
                    }
                    buffer.append(ch);
                }
                value = buffer.toString();
            }
        } else {
            quote = '\u0000';
        }
        Attribute attribute = this.getAttributeEx(key);
        if (null != attribute) {
            attribute.setValue(value);
            if ('\u0000' != quote) {
                attribute.setQuote(quote);
            }
        } else {
            this.setAttribute(key, value, quote);
        }
    }

    public void removeAttribute(String key) {
        Attribute attribute = this.getAttributeEx(key);
        if (null != attribute) {
            this.getAttributesEx().remove(attribute);
        }
    }

    public void setAttribute(String key, String value, char quote) {
        this.setAttribute(new Attribute(key, value, quote));
    }

    public Attribute getAttributeEx(String name) {
        Attribute ret = null;
        Vector attributes = this.getAttributesEx();
        if (null != attributes) {
            int size = attributes.size();
            for (int i = 0; i < size; ++i) {
                Attribute attribute = (Attribute)attributes.elementAt(i);
                String string = attribute.getName();
                if (null == string || !name.equalsIgnoreCase(string)) continue;
                ret = attribute;
                i = size;
            }
        }
        return ret;
    }

    public void setAttributeEx(Attribute attribute) {
        this.setAttribute(attribute);
    }

    public void setAttribute(Attribute attribute) {
        boolean replaced = false;
        Vector attributes = this.getAttributesEx();
        int length = attributes.size();
        if (0 < length) {
            String name = attribute.getName();
            for (int i = 1; i < attributes.size(); ++i) {
                Attribute test = (Attribute)attributes.elementAt(i);
                String test_name = test.getName();
                if (null == test_name || !test_name.equalsIgnoreCase(name)) continue;
                attributes.setElementAt(attribute, i);
                replaced = true;
            }
        }
        if (!replaced) {
            if (0 != length && !((Attribute)attributes.elementAt(length - 1)).isWhitespace()) {
                attributes.addElement(new Attribute(" "));
            }
            attributes.addElement(attribute);
        }
    }

    public String getParameter(String name) {
        return this.getAttribute(name);
    }

    public Vector getAttributesEx() {
        return this.mAttributes;
    }

    public Hashtable getAttributes() {
        SpecialHashtable ret = new SpecialHashtable();
        Vector attributes = this.getAttributesEx();
        if (0 < attributes.size()) {
            Attribute attribute = (Attribute)attributes.elementAt(0);
            ret.put("$<TAGNAME>$", attribute.getName().toUpperCase(Locale.ENGLISH));
            for (int i = 1; i < attributes.size(); ++i) {
                attribute = (Attribute)attributes.elementAt(i);
                if (attribute.isWhitespace()) continue;
                String value = attribute.getValue();
                if (attribute.isEmpty()) {
                    value = "$<NOTHING>$";
                }
                if (null == value) {
                    value = "$<NULL>$";
                }
                ret.put(attribute.getName().toUpperCase(Locale.ENGLISH), value);
            }
        } else {
            ret.put("$<TAGNAME>$", "");
        }
        return ret;
    }

    public String getTagName() {
        String ret = this.getRawTagName();
        if (null != ret) {
            if ((ret = ret.toUpperCase(Locale.ENGLISH)).startsWith("/")) {
                ret = ret.substring(1);
            }
            if (ret.endsWith("/")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        return ret;
    }

    public String getRawTagName() {
        String ret = null;
        Vector attributes = this.getAttributesEx();
        if (0 != attributes.size()) {
            ret = ((Attribute)attributes.elementAt(0)).getName();
        }
        return ret;
    }

    public void setTagName(String name) {
        Attribute attribute = new Attribute(name, null, '\u0000');
        Vector<Attribute> attributes = this.getAttributesEx();
        if (null == attributes) {
            attributes = new Vector<Attribute>();
            this.setAttributesEx(attributes);
        }
        if (0 == attributes.size()) {
            attributes.addElement(attribute);
        } else {
            Attribute zeroth = (Attribute)attributes.elementAt(0);
            if (null == zeroth.getValue() && '\u0000' == zeroth.getQuote()) {
                attributes.setElementAt(attribute, 0);
            } else {
                attributes.insertElementAt(attribute, 0);
            }
        }
    }

    public String getText() {
        String ret = this.toHtml();
        ret = ret.substring(1, ret.length() - 1);
        return ret;
    }

    public void setAttributes(Hashtable attributes) {
        Vector<Attribute> att = new Vector<Attribute>();
        Enumeration e = attributes.keys();
        while (e.hasMoreElements()) {
            Attribute attribute;
            char quote;
            String key = (String)e.nextElement();
            String value = (String)attributes.get(key);
            if (value.startsWith("'") && value.endsWith("'") && 2 <= value.length()) {
                quote = '\'';
                value = value.substring(1, value.length() - 1);
            } else if (value.startsWith("\"") && value.endsWith("\"") && 2 <= value.length()) {
                quote = '\"';
                value = value.substring(1, value.length() - 1);
            } else {
                quote = '\u0000';
            }
            if (key.equals("$<TAGNAME>$")) {
                attribute = new Attribute(value, null, quote);
                att.insertElementAt(attribute, 0);
                continue;
            }
            attribute = new Attribute(" ");
            att.addElement(attribute);
            attribute = new Attribute(key, value, quote);
            att.addElement(attribute);
        }
        this.mAttributes = att;
    }

    public void setAttributesEx(Vector attribs) {
        this.mAttributes = attribs;
    }

    public void setTagBegin(int tagBegin) {
        this.nodeBegin = tagBegin;
    }

    public int getTagBegin() {
        return this.nodeBegin;
    }

    public void setTagEnd(int tagEnd) {
        this.nodeEnd = tagEnd;
    }

    public int getTagEnd() {
        return this.nodeEnd;
    }

    public void setText(String text) {
        Lexer lexer = new Lexer(text);
        try {
            TagNode output = (TagNode)lexer.nextNode();
            this.mPage = output.getPage();
            this.nodeBegin = output.getStartPosition();
            this.nodeEnd = output.getEndPosition();
            this.mAttributes = output.getAttributesEx();
        }
        catch (ParserException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public String toPlainTextString() {
        return "";
    }

    public String toHtml() {
        Attribute attribute;
        int i;
        int length = 2;
        Vector attributes = this.getAttributesEx();
        int size = attributes.size();
        for (i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.elementAt(i);
            length += attribute.getLength();
        }
        StringBuffer ret = new StringBuffer(length);
        ret.append("<");
        for (i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.elementAt(i);
            attribute.toString(ret);
        }
        ret.append(">");
        return ret.toString();
    }

    public String toString() {
        String text = this.getText();
        StringBuffer ret = new StringBuffer(20 + text.length());
        String type = this.isEndTag() ? "End" : "Tag";
        Cursor start = new Cursor(this.getPage(), this.getStartPosition());
        Cursor end = new Cursor(this.getPage(), this.getEndPosition());
        ret.append(type);
        ret.append(" (");
        ret.append(start);
        ret.append(",");
        ret.append(end);
        ret.append("): ");
        if (80 < ret.length() + text.length()) {
            text = text.substring(0, 77 - ret.length());
            ret.append(text);
            ret.append("...");
        } else {
            ret.append(text);
        }
        return ret.toString();
    }

    public boolean breaksFlow() {
        return breakTags.containsKey(this.getTagName());
    }

    public Hashtable getParsed() {
        return this.getAttributes();
    }

    public void accept(NodeVisitor visitor) {
        if (this.isEndTag()) {
            visitor.visitEndTag(this);
        } else {
            visitor.visitTag(this);
        }
    }

    public boolean isEmptyXmlTag() {
        Attribute attribute;
        String name;
        boolean ret = false;
        Vector attributes = this.getAttributesEx();
        int size = attributes.size();
        if (0 < size && null != (name = (attribute = (Attribute)attributes.elementAt(size - 1)).getName())) {
            int length = name.length();
            ret = name.charAt(length - 1) == '/';
        }
        return ret;
    }

    public void setEmptyXmlTag(boolean emptyXmlTag) {
        Vector attributes = this.getAttributesEx();
        int size = attributes.size();
        if (0 < size) {
            Attribute attribute = (Attribute)attributes.elementAt(size - 1);
            String name = attribute.getName();
            if (null != name) {
                int length = name.length();
                String value = attribute.getValue();
                if (null == value) {
                    if (name.charAt(length - 1) == '/') {
                        if (!emptyXmlTag) {
                            if (1 == length) {
                                attributes.removeElementAt(size - 1);
                            } else {
                                name = name.substring(0, length - 1);
                                attribute = new Attribute(name, null);
                                attributes.removeElementAt(size - 1);
                                attributes.addElement(attribute);
                            }
                        }
                    } else if (emptyXmlTag) {
                        attribute = new Attribute(" ");
                        attributes.addElement(attribute);
                        attribute = new Attribute("/", null);
                        attributes.addElement(attribute);
                    }
                } else if (emptyXmlTag) {
                    attribute = new Attribute(" ");
                    attributes.addElement(attribute);
                    attribute = new Attribute("/", null);
                    attributes.addElement(attribute);
                }
            } else if (emptyXmlTag) {
                attribute = new Attribute("/", null);
                attributes.addElement(attribute);
            }
        } else if (emptyXmlTag) {
            Attribute attribute = new Attribute("/", null);
            attributes.addElement(attribute);
        }
    }

    public boolean isEndTag() {
        String raw = this.getRawTagName();
        return null == raw ? false : 0 != raw.length() && '/' == raw.charAt(0);
    }

    public int getStartingLineNumber() {
        return this.getPage().row(this.getStartPosition());
    }

    public int getEndingLineNumber() {
        return this.getPage().row(this.getEndPosition());
    }

    public String[] getIds() {
        return NONE;
    }

    public String[] getEnders() {
        return NONE;
    }

    public String[] getEndTagEnders() {
        return NONE;
    }

    public Scanner getThisScanner() {
        return this.mScanner;
    }

    public void setThisScanner(Scanner scanner) {
        this.mScanner = scanner;
    }

    public Tag getEndTag() {
        return null;
    }

    public void setEndTag(Tag end) {
    }

    static {
        breakTags.put("BLOCKQUOTE", Boolean.TRUE);
        breakTags.put("BODY", Boolean.TRUE);
        breakTags.put("BR", Boolean.TRUE);
        breakTags.put("CENTER", Boolean.TRUE);
        breakTags.put("DD", Boolean.TRUE);
        breakTags.put("DIR", Boolean.TRUE);
        breakTags.put("DIV", Boolean.TRUE);
        breakTags.put("DL", Boolean.TRUE);
        breakTags.put("DT", Boolean.TRUE);
        breakTags.put("FORM", Boolean.TRUE);
        breakTags.put("H1", Boolean.TRUE);
        breakTags.put("H2", Boolean.TRUE);
        breakTags.put("H3", Boolean.TRUE);
        breakTags.put("H4", Boolean.TRUE);
        breakTags.put("H5", Boolean.TRUE);
        breakTags.put("H6", Boolean.TRUE);
        breakTags.put("HEAD", Boolean.TRUE);
        breakTags.put("HR", Boolean.TRUE);
        breakTags.put("HTML", Boolean.TRUE);
        breakTags.put("ISINDEX", Boolean.TRUE);
        breakTags.put("LI", Boolean.TRUE);
        breakTags.put("MENU", Boolean.TRUE);
        breakTags.put("NOFRAMES", Boolean.TRUE);
        breakTags.put("OL", Boolean.TRUE);
        breakTags.put("P", Boolean.TRUE);
        breakTags.put("PRE", Boolean.TRUE);
        breakTags.put("TD", Boolean.TRUE);
        breakTags.put("TH", Boolean.TRUE);
        breakTags.put("TITLE", Boolean.TRUE);
        breakTags.put("UL", Boolean.TRUE);
    }
}

