/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import org.jfree.data.AbstractDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DefaultKeyedValue;
import org.jfree.data.KeyedValue;
import org.jfree.data.KeyedValueDataset;
import org.jfree.util.ObjectUtils;

public class DefaultKeyedValueDataset
extends AbstractDataset
implements KeyedValueDataset,
Serializable {
    private KeyedValue data;

    public DefaultKeyedValueDataset() {
        this(null);
    }

    public DefaultKeyedValueDataset(Comparable comparable, Number number) {
        this(new DefaultKeyedValue(comparable, number));
    }

    public DefaultKeyedValueDataset(KeyedValue keyedValue) {
        this.data = keyedValue;
    }

    public Comparable getKey() {
        return this.data.getKey();
    }

    public Number getValue() {
        return this.data.getValue();
    }

    public void updateValue(Number number) {
        if (this.data == null) {
            throw new RuntimeException("updateValue: can't update null.");
        }
        this.setValue(this.data.getKey(), number);
    }

    public void setValue(Comparable comparable, Number number) {
        this.data = new DefaultKeyedValue(comparable, number);
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof KeyedValueDataset) {
            KeyedValueDataset keyedValueDataset = (KeyedValueDataset)object;
            boolean bl = ObjectUtils.equal((Object)this.data.getKey(), (Object)keyedValueDataset.getKey());
            boolean bl2 = ObjectUtils.equal((Object)this.data.getValue(), (Object)keyedValueDataset.getValue());
            return bl && bl2;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValueDataset defaultKeyedValueDataset = (DefaultKeyedValueDataset)super.clone();
        return defaultKeyedValueDataset;
    }
}

