/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PaintList;
import org.jfree.util.ShapeList;
import org.jfree.util.ShapeUtils;

public abstract class AbstractRenderer
implements Cloneable,
Serializable {
    public static final Paint DEFAULT_PAINT = Color.blue;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_VALUE_LABEL_PAINT = Color.black;
    private transient Paint paint = null;
    private PaintList paintList = new PaintList();
    private transient Paint basePaint = DEFAULT_PAINT;
    private transient Paint outlinePaint = null;
    private PaintList outlinePaintList = new PaintList();
    private transient Paint baseOutlinePaint = DEFAULT_OUTLINE_PAINT;
    private transient Stroke stroke = null;
    private ObjectList strokeList = new ObjectList();
    private transient Stroke baseStroke = DEFAULT_STROKE;
    private transient Stroke outlineStroke = null;
    private ObjectList outlineStrokeList = new ObjectList();
    private transient Stroke baseOutlineStroke = DEFAULT_OUTLINE_STROKE;
    private transient Shape shape = null;
    private ShapeList shapeList = new ShapeList();
    private transient Shape baseShape = DEFAULT_SHAPE;
    private Boolean itemLabelsVisible = null;
    private BooleanList itemLabelsVisibleList = new BooleanList();
    private Boolean baseItemLabelsVisible = Boolean.FALSE;
    private Font itemLabelFont = null;
    private ObjectList itemLabelFontList = new ObjectList();
    private Font baseItemLabelFont = new Font("SansSerif", 0, 10);
    private transient Paint itemLabelPaint = null;
    private PaintList itemLabelPaintList = new PaintList();
    private transient Paint baseItemLabelPaint = Color.black;
    private ItemLabelAnchor itemLabelAnchor = null;
    private ObjectList itemLabelAnchorList = new ObjectList();
    private ItemLabelAnchor baseItemLabelAnchor = ItemLabelAnchor.OUTSIDE12;
    private TextAnchor itemLabelTextAnchor = null;
    private ObjectList itemLabelTextAnchorList = new ObjectList();
    private TextAnchor baseItemLabelTextAnchor = TextAnchor.BOTTOM_CENTER;
    private TextAnchor itemLabelRotationAnchor = null;
    private ObjectList itemLabelRotationAnchorList = new ObjectList();
    private TextAnchor baseItemLabelRotationAnchor = TextAnchor.CENTER;
    private Number itemLabelAngle = null;
    private ObjectList itemLabelAngleList = new ObjectList();
    private Number baseItemLabelAngle = new Double(0.0);
    private transient ChartRenderingInfo info = null;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public ChartRenderingInfo getInfo() {
        return this.info;
    }

    public void setInfo(ChartRenderingInfo chartRenderingInfo) {
        this.info = chartRenderingInfo;
    }

    public abstract DrawingSupplier getDrawingSupplier();

    public Paint getItemPaint(int n, int n2) {
        return this.getSeriesPaint(n);
    }

    public Paint getSeriesPaint(int n) {
        if (this.paint != null) {
            return this.paint;
        }
        Paint paint = this.paintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextPaint();
                this.paintList.setPaint(n, paint);
            } else {
                paint = this.basePaint;
            }
        }
        return paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.paintList.setPaint(n, paint);
    }

    public Paint getBasePaint() {
        return this.basePaint;
    }

    public void setBasePaint(Paint paint) {
        this.basePaint = paint;
    }

    public Paint getItemOutlinePaint(int n, int n2) {
        return this.getSeriesOutlinePaint(n);
    }

    public Paint getSeriesOutlinePaint(int n) {
        if (this.outlinePaint != null) {
            return this.outlinePaint;
        }
        Paint paint = this.outlinePaintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextOutlinePaint();
                this.outlinePaintList.setPaint(n, paint);
            } else {
                paint = this.baseOutlinePaint;
            }
        }
        return paint;
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.outlinePaintList.setPaint(n, paint);
    }

    public Paint getBaseOutlinePaint() {
        return this.baseOutlinePaint;
    }

    public void setBaseOutlinePaint(Paint paint) {
        this.baseOutlinePaint = paint;
    }

    public Stroke getItemStroke(int n, int n2) {
        return this.getSeriesStroke(n);
    }

    public Stroke getSeriesStroke(int n) {
        if (this.stroke != null) {
            return this.stroke;
        }
        Stroke stroke = (Stroke)this.strokeList.get(n);
        if (stroke == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                stroke = drawingSupplier.getNextStroke();
                this.strokeList.set(n, (Object)stroke);
            } else {
                stroke = this.baseStroke;
            }
        }
        return stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setSeriesStroke(int n, Stroke stroke) {
        this.strokeList.set(n, (Object)stroke);
    }

    public Stroke getBaseStroke() {
        return this.baseStroke;
    }

    public void setBaseStroke(Stroke stroke) {
        this.baseStroke = stroke;
    }

    public Stroke getItemOutlineStroke(int n, int n2) {
        return this.getSeriesOutlineStroke(n);
    }

    public Stroke getSeriesOutlineStroke(int n) {
        if (this.outlineStroke != null) {
            return this.outlineStroke;
        }
        Stroke stroke = (Stroke)this.outlineStrokeList.get(n);
        if (stroke == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                stroke = drawingSupplier.getNextStroke();
                this.strokeList.set(n, (Object)stroke);
            } else {
                stroke = this.baseOutlineStroke;
            }
        }
        return stroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.outlineStrokeList.set(n, (Object)stroke);
    }

    public Stroke getBaseOutlineStroke() {
        return this.baseOutlineStroke;
    }

    public void setBaseOutlineStroke(Stroke stroke) {
        this.baseOutlineStroke = stroke;
    }

    public Shape getItemShape(int n, int n2) {
        return this.getSeriesShape(n);
    }

    public Shape getSeriesShape(int n) {
        if (this.shape != null) {
            return this.shape;
        }
        Shape shape = this.shapeList.getShape(n);
        if (shape == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                shape = drawingSupplier.getNextShape();
                this.shapeList.setShape(n, shape);
            } else {
                shape = this.baseShape;
            }
        }
        return shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setSeriesShape(int n, Shape shape) {
        this.shapeList.setShape(n, shape);
    }

    public Shape getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Shape shape) {
        this.baseShape = shape;
    }

    protected synchronized Shape createTransformedShape(Shape shape, double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public boolean isItemLabelVisible(int n, int n2) {
        return this.isSeriesItemLabelsVisible(n);
    }

    public boolean isSeriesItemLabelsVisible(int n) {
        if (this.itemLabelsVisible != null) {
            return this.itemLabelsVisible;
        }
        Boolean bl = this.itemLabelsVisibleList.getBoolean(n);
        if (bl == null) {
            bl = this.baseItemLabelsVisible;
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setItemLabelsVisible(boolean bl) {
        if (bl) {
            this.setItemLabelsVisible(Boolean.TRUE);
        } else {
            this.setItemLabelsVisible(Boolean.FALSE);
        }
    }

    public void setItemLabelsVisible(Boolean bl) {
        this.itemLabelsVisible = bl;
    }

    public void setSeriesItemLabelsVisible(int n, Boolean bl) {
        this.itemLabelsVisibleList.setBoolean(n, bl);
    }

    public Boolean getBaseItemLabelsVisible() {
        return this.baseItemLabelsVisible;
    }

    public void setBaseItemLabelsVisible(Boolean bl) {
        this.baseItemLabelsVisible = bl;
    }

    public Font getItemLabelFont(int n, int n2) {
        return this.getSeriesItemLabelFont(n);
    }

    public Font getSeriesItemLabelFont(int n) {
        if (this.itemLabelFont != null) {
            return this.itemLabelFont;
        }
        Font font = (Font)this.itemLabelFontList.get(n);
        if (font == null) {
            font = this.baseItemLabelFont;
        }
        return font;
    }

    public void setItemLabelFont(Font font) {
        this.itemLabelFont = font;
    }

    public void setSeriesItemLabelFont(int n, Font font) {
        this.itemLabelFontList.set(n, (Object)font);
    }

    public Font getBaseItemLabelFont() {
        return this.baseItemLabelFont;
    }

    public void setBaseItemLabelFont(Font font) {
        this.baseItemLabelFont = font;
    }

    public Paint getItemLabelPaint(int n, int n2) {
        return this.getSeriesItemLabelPaint(n);
    }

    public Paint getSeriesItemLabelPaint(int n) {
        if (this.itemLabelPaint != null) {
            return this.itemLabelPaint;
        }
        Paint paint = this.itemLabelPaintList.getPaint(n);
        if (paint == null) {
            paint = this.baseItemLabelPaint;
        }
        return paint;
    }

    public void setItemLabelPaint(Paint paint) {
        this.itemLabelPaint = paint;
    }

    public void setSeriesItemLabelPaint(int n, Paint paint) {
        this.itemLabelPaintList.setPaint(n, paint);
    }

    public Paint getBaseItemLabelPaint() {
        return this.baseItemLabelPaint;
    }

    public void setBaseItemLabelPaint(Paint paint) {
        this.baseItemLabelPaint = paint;
    }

    public ItemLabelAnchor getItemLabelAnchor(int n, int n2) {
        return this.getSeriesItemLabelAnchor(n);
    }

    public ItemLabelAnchor getSeriesItemLabelAnchor(int n) {
        if (this.itemLabelAnchor != null) {
            return this.itemLabelAnchor;
        }
        ItemLabelAnchor itemLabelAnchor = (ItemLabelAnchor)this.itemLabelAnchorList.get(n);
        if (itemLabelAnchor == null) {
            itemLabelAnchor = this.baseItemLabelAnchor;
        }
        return itemLabelAnchor;
    }

    public void setItemLabelAnchor(ItemLabelAnchor itemLabelAnchor) {
        this.itemLabelAnchor = itemLabelAnchor;
    }

    public void setSeriesItemLabelAnchor(int n, ItemLabelAnchor itemLabelAnchor) {
        this.itemLabelAnchorList.set(n, (Object)itemLabelAnchor);
    }

    public ItemLabelAnchor getBaseItemLabelAnchor() {
        return this.baseItemLabelAnchor;
    }

    public void setBaseItemLabelAnchor(ItemLabelAnchor itemLabelAnchor) {
        this.baseItemLabelAnchor = itemLabelAnchor;
    }

    public TextAnchor getItemLabelTextAnchor(int n, int n2) {
        return this.getSeriesItemLabelTextAnchor(n);
    }

    public TextAnchor getSeriesItemLabelTextAnchor(int n) {
        if (this.itemLabelTextAnchor != null) {
            return this.itemLabelTextAnchor;
        }
        TextAnchor textAnchor = (TextAnchor)this.itemLabelTextAnchorList.get(n);
        if (textAnchor == null) {
            textAnchor = this.baseItemLabelTextAnchor;
        }
        return textAnchor;
    }

    public void setItemLabelTextAnchor(TextAnchor textAnchor) {
        this.itemLabelTextAnchor = textAnchor;
    }

    public void setSeriesItemLabelTextAnchor(int n, TextAnchor textAnchor) {
        this.itemLabelTextAnchorList.set(n, (Object)textAnchor);
    }

    public TextAnchor getBaseItemLabelTextAnchor() {
        return this.baseItemLabelTextAnchor;
    }

    public void setBaseItemLabelTextAnchor(TextAnchor textAnchor) {
        this.baseItemLabelTextAnchor = textAnchor;
    }

    public TextAnchor getItemLabelRotationAnchor(int n, int n2) {
        return this.getSeriesItemLabelRotationAnchor(n);
    }

    public TextAnchor getSeriesItemLabelRotationAnchor(int n) {
        if (this.itemLabelRotationAnchor != null) {
            return this.itemLabelRotationAnchor;
        }
        TextAnchor textAnchor = (TextAnchor)this.itemLabelRotationAnchorList.get(n);
        if (textAnchor == null) {
            textAnchor = this.baseItemLabelRotationAnchor;
        }
        return textAnchor;
    }

    public void setItemLabelRotationAnchor(TextAnchor textAnchor) {
        this.itemLabelRotationAnchor = textAnchor;
    }

    public void setSeriesItemLabelRotationAnchor(int n, TextAnchor textAnchor) {
        this.itemLabelRotationAnchorList.set(n, (Object)textAnchor);
    }

    public TextAnchor getBaseItemLabelRotationAnchor() {
        return this.baseItemLabelRotationAnchor;
    }

    public void setBaseItemLabelRotationAnchor(TextAnchor textAnchor) {
        this.baseItemLabelRotationAnchor = textAnchor;
    }

    public Number getItemLabelAngle(int n, int n2) {
        return this.getSeriesItemLabelAngle(n);
    }

    public Number getSeriesItemLabelAngle(int n) {
        if (this.itemLabelAngle != null) {
            return this.itemLabelAngle;
        }
        Number number = (Number)this.itemLabelAngleList.get(n);
        if (number == null) {
            number = this.baseItemLabelAngle;
        }
        return number;
    }

    public void setItemLabelAngle(Number number) {
        this.itemLabelAngle = number;
    }

    public void setSeriesAngle(int n, Number number) {
        this.itemLabelAngleList.set(n, (Object)number);
    }

    public Number getBaseItemLabelAngle() {
        return this.baseItemLabelAngle;
    }

    public void setBaseAngle(Number number) {
        this.baseItemLabelAngle = number;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractRenderer) {
            AbstractRenderer abstractRenderer = (AbstractRenderer)object;
            boolean bl = ObjectUtils.equal((Object)this.paint, (Object)abstractRenderer.paint);
            boolean bl2 = ObjectUtils.equal((Object)this.paintList, (Object)abstractRenderer.paintList);
            boolean bl3 = ObjectUtils.equal((Object)this.basePaint, (Object)abstractRenderer.basePaint);
            boolean bl4 = ObjectUtils.equal((Object)this.outlinePaint, (Object)abstractRenderer.outlinePaint);
            boolean bl5 = ObjectUtils.equal((Object)this.outlinePaintList, (Object)abstractRenderer.outlinePaintList);
            boolean bl6 = ObjectUtils.equal((Object)this.baseOutlinePaint, (Object)abstractRenderer.baseOutlinePaint);
            boolean bl7 = ObjectUtils.equal((Object)this.stroke, (Object)abstractRenderer.stroke);
            boolean bl8 = ObjectUtils.equal((Object)this.strokeList, (Object)abstractRenderer.strokeList);
            boolean bl9 = ObjectUtils.equal((Object)this.baseStroke, (Object)abstractRenderer.baseStroke);
            boolean bl10 = ObjectUtils.equal((Object)this.outlineStroke, (Object)abstractRenderer.outlineStroke);
            boolean bl11 = ObjectUtils.equal((Object)this.outlineStrokeList, (Object)abstractRenderer.outlineStrokeList);
            boolean bl12 = ObjectUtils.equal((Object)this.baseOutlineStroke, (Object)abstractRenderer.baseOutlineStroke);
            boolean bl13 = ObjectUtils.equal((Object)this.shape, (Object)abstractRenderer.shape);
            boolean bl14 = ObjectUtils.equal((Object)this.shapeList, (Object)abstractRenderer.shapeList);
            boolean bl15 = ObjectUtils.equal((Object)this.baseShape, (Object)abstractRenderer.baseShape);
            boolean bl16 = ObjectUtils.equal((Object)this.itemLabelsVisible, (Object)abstractRenderer.itemLabelsVisible);
            boolean bl17 = ObjectUtils.equal((Object)this.itemLabelsVisibleList, (Object)abstractRenderer.itemLabelsVisibleList);
            boolean bl18 = ObjectUtils.equal((Object)this.baseItemLabelsVisible, (Object)abstractRenderer.baseItemLabelsVisible);
            boolean bl19 = ObjectUtils.equal((Object)this.itemLabelFont, (Object)abstractRenderer.itemLabelFont);
            boolean bl20 = ObjectUtils.equal((Object)this.itemLabelFontList, (Object)abstractRenderer.itemLabelFontList);
            boolean bl21 = ObjectUtils.equal((Object)this.baseItemLabelFont, (Object)abstractRenderer.baseItemLabelFont);
            boolean bl22 = ObjectUtils.equal((Object)this.itemLabelPaint, (Object)abstractRenderer.itemLabelPaint);
            boolean bl23 = ObjectUtils.equal((Object)this.itemLabelPaintList, (Object)abstractRenderer.itemLabelPaintList);
            boolean bl24 = ObjectUtils.equal((Object)this.baseItemLabelPaint, (Object)abstractRenderer.baseItemLabelPaint);
            boolean bl25 = ObjectUtils.equal((Object)this.itemLabelAnchor, (Object)abstractRenderer.itemLabelAnchor);
            boolean bl26 = ObjectUtils.equal((Object)this.itemLabelAnchorList, (Object)abstractRenderer.itemLabelAnchorList);
            boolean bl27 = ObjectUtils.equal((Object)this.baseItemLabelAnchor, (Object)abstractRenderer.baseItemLabelAnchor);
            boolean bl28 = ObjectUtils.equal((Object)this.itemLabelTextAnchor, (Object)abstractRenderer.itemLabelTextAnchor);
            boolean bl29 = ObjectUtils.equal((Object)this.itemLabelTextAnchorList, (Object)abstractRenderer.itemLabelTextAnchorList);
            boolean bl30 = ObjectUtils.equal((Object)this.baseItemLabelTextAnchor, (Object)abstractRenderer.baseItemLabelTextAnchor);
            boolean bl31 = ObjectUtils.equal((Object)this.itemLabelRotationAnchor, (Object)abstractRenderer.itemLabelRotationAnchor);
            boolean bl32 = ObjectUtils.equal((Object)this.itemLabelRotationAnchorList, (Object)abstractRenderer.itemLabelRotationAnchorList);
            boolean bl33 = ObjectUtils.equal((Object)this.baseItemLabelRotationAnchor, (Object)abstractRenderer.baseItemLabelRotationAnchor);
            boolean bl34 = ObjectUtils.equal((Object)this.itemLabelAngle, (Object)abstractRenderer.itemLabelAngle);
            boolean bl35 = ObjectUtils.equal((Object)this.itemLabelAngleList, (Object)abstractRenderer.itemLabelAngleList);
            boolean bl36 = ObjectUtils.equal((Object)this.baseItemLabelAngle, (Object)abstractRenderer.baseItemLabelAngle);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30 && bl31 && bl32 && bl33 && bl34 && bl35 && bl36 && bl13 && bl14 && bl15;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractRenderer abstractRenderer = (AbstractRenderer)super.clone();
        if (this.paintList != null) {
            abstractRenderer.paintList = (PaintList)this.paintList.clone();
        }
        if (this.outlinePaintList != null) {
            abstractRenderer.outlinePaintList = (PaintList)this.outlinePaintList.clone();
        }
        if (this.strokeList != null) {
            abstractRenderer.strokeList = (ObjectList)this.strokeList.clone();
        }
        if (this.outlineStrokeList != null) {
            abstractRenderer.outlineStrokeList = (ObjectList)this.outlineStrokeList.clone();
        }
        if (this.shape != null) {
            abstractRenderer.shape = ShapeUtils.clone((Shape)this.shape);
        }
        if (this.shapeList != null) {
            abstractRenderer.strokeList = (ObjectList)this.strokeList.clone();
        }
        if (this.baseShape != null) {
            abstractRenderer.baseShape = ShapeUtils.clone((Shape)this.baseShape);
        }
        if (this.itemLabelsVisibleList != null) {
            abstractRenderer.itemLabelsVisibleList = (BooleanList)this.itemLabelsVisibleList.clone();
        }
        if (this.itemLabelFontList != null) {
            abstractRenderer.itemLabelFontList = (ObjectList)this.itemLabelFontList.clone();
        }
        if (this.itemLabelPaintList != null) {
            abstractRenderer.itemLabelPaintList = (PaintList)this.itemLabelPaintList.clone();
        }
        if (this.itemLabelAnchorList != null) {
            abstractRenderer.itemLabelAnchorList = (ObjectList)this.itemLabelAnchorList.clone();
        }
        if (this.itemLabelTextAnchorList != null) {
            abstractRenderer.itemLabelTextAnchorList = (ObjectList)this.itemLabelTextAnchorList.clone();
        }
        if (this.itemLabelRotationAnchorList != null) {
            abstractRenderer.itemLabelRotationAnchorList = (ObjectList)this.itemLabelRotationAnchorList.clone();
        }
        if (this.itemLabelAngleList != null) {
            abstractRenderer.itemLabelAngleList = (ObjectList)this.itemLabelAngleList.clone();
        }
        return abstractRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.basePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.baseStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.baseOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.shape, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.baseShape, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.itemLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseItemLabelPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.basePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.baseStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.baseOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.shape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.baseShape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseItemLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

