/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.openide.actions.FindAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class MemorySnapshotPanel
extends SnapshotPanel
implements ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Icon MEMORY_RESULTS_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabMemoryResults");
    private static final Icon INFO_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabInfo");
    private static final Icon STACK_TRACES_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabStackTraces");
    private Component findActionPresenter;
    private Component findNextPresenter;
    private Component findPreviousPresenter;
    private MemoryResultsPanel memoryPanel;
    private MemoryResultsSnapshot snapshot;
    private Lookup.Provider project;
    private SaveSnapshotAction saveAction;
    private SnapshotInfoPanel infoPanel;
    private SnapshotReverseMemCallGraphPanel reversePanel;

    public MemorySnapshotPanel(Lookup context, LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.snapshot = (MemoryResultsSnapshot)ls.getSnapshot();
        this.project = ls.getProject();
        this.setLayout(new BorderLayout());
        SnapshotActionsHandler memoryActionsHandler = new SnapshotActionsHandler();
        this.infoPanel = new SnapshotInfoPanel(ls);
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            this.memoryPanel = new SnapshotLivenessResultsPanel((LivenessMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler, ls.getSettings().getAllocTrackEvery());
            SnapshotLivenessResultsPanel lmemoryPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            lmemoryPanel.setSorting(sortingColumn, sortingOrder);
            lmemoryPanel.prepareResults();
        } else {
            this.memoryPanel = new SnapshotAllocResultsPanel((AllocMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler);
            SnapshotAllocResultsPanel amemoryPanel = (SnapshotAllocResultsPanel)this.memoryPanel;
            amemoryPanel.setSorting(sortingColumn, sortingOrder);
            amemoryPanel.prepareResults();
        }
        this.infoPanel.updateInfo();
        this.addView(Bundle.MemorySnapshotPanel_MemoryResultsTabName(), MEMORY_RESULTS_TAB_ICON, Bundle.MemorySnapshotPanel_MemoryResultsTabDescr(), (Component)this.memoryPanel, null);
        if (this.snapshot.containsStacks()) {
            this.reversePanel = new SnapshotReverseMemCallGraphPanel(this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler);
            this.reversePanel.prepareResults();
            this.addView(Bundle.MemorySnapshotPanel_StackTracesTabName(), STACK_TRACES_TAB_ICON, Bundle.MemorySnapshotPanel_StackTracesTabDescr(), (Component)this.reversePanel, null);
            this.setViewEnabled((Component)this.reversePanel, false);
        }
        this.addView(Bundle.MemorySnapshotPanel_InfoTabName(), INFO_TAB_ICON, Bundle.MemorySnapshotPanel_InfoTabDescr(), this.infoPanel, null);
        this.addChangeListener(this);
        ProfilerToolbar toolBar = ProfilerToolbar.create((boolean)true);
        this.saveAction = new SaveSnapshotAction(ls);
        toolBar.add((Action)this.saveAction);
        toolBar.add((Action)new ExportAction(this, ls));
        toolBar.add((Action)new SaveViewAction(this));
        toolBar.addSeparator();
        ContextAwareAction a = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = toolBar.add(a.createContextAwareInstance(context));
        this.findPreviousPresenter = toolBar.add((Action)new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add((Action)new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)this.findActionPresenter;
            ab.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            ab.setText("");
            ab.setToolTipText(Bundle.MemorySnapshotPanel_FindActionTooltip());
        }
        toolBar.addSeparator();
        toolBar.add((Action)new CompareSnapshotsAction(ls));
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add(toolBar.getComponent(), "North");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            return this.memoryPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (selectedView == this.reversePanel) {
            return this.reversePanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (selectedView == this.infoPanel) {
            return this.infoPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        return null;
    }

    @Override
    public String getViewName() {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-memory_results";
        }
        if (selectedView == this.reversePanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-allocation_stack_traces";
        }
        if (selectedView == this.infoPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-info";
        }
        return null;
    }

    public void displayStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        this.setReverseCallGraphClass(selectedClassId, sortingColumn, sortingOrder);
        this.selectView((Component)this.reversePanel);
    }

    @Override
    public boolean fitsVisibleArea() {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            return this.memoryPanel.fitsVisibleArea();
        }
        if (selectedView == this.reversePanel) {
            return this.reversePanel.fitsVisibleArea();
        }
        if (selectedView == this.infoPanel) {
            return this.infoPanel.fitsVisibleArea();
        }
        return true;
    }

    @Override
    public boolean hasView() {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            return true;
        }
        if (selectedView == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    @Override
    public void performFind() {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
            if (this.reversePanel != null) {
                this.reversePanel.setFindString(findString);
            }
            if (!this.memoryPanel.findFirst()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        } else if (selectedView == this.reversePanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
            this.reversePanel.setFindString(findString);
            if (!this.reversePanel.findFirst()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
    }

    @Override
    public void performFindNext() {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(findString);
                }
            }
            if (!this.memoryPanel.findNext()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        } else if (selectedView == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.reversePanel.findNext()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
    }

    @Override
    public void performFindPrevious() {
        String findString;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(findString);
                }
            }
            if (!this.memoryPanel.findPrevious()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
        if (selectedView == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.reversePanel.findPrevious()) {
                ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
            }
        }
    }

    public void requestFocus() {
        if (this.memoryPanel != null) {
            this.memoryPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateToolbar();
        final Component selectedView = this.getSelectedView();
        if (selectedView != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    selectedView.requestFocus();
                }
            });
        }
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot snapshot) {
        return "snapshot-" + snapshot.getTimeTaken();
    }

    private void setReverseCallGraphClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        this.reversePanel.setClassId(selectedClassId);
        this.reversePanel.setSorting(sortingColumn, sortingOrder);
        this.reversePanel.prepareResults();
        this.setViewEnabled((Component)this.reversePanel, true);
    }

    private void updateToolbar() {
        Component selectedView = this.getSelectedView();
        boolean findEnabled = selectedView != this.infoPanel && (selectedView != this.reversePanel || !this.reversePanel.isEmpty());
        this.findActionPresenter.setEnabled(findEnabled);
        this.findPreviousPresenter.setEnabled(findEnabled);
        this.findNextPresenter.setEnabled(findEnabled);
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            if (this.memoryPanel instanceof SnapshotAllocResultsPanel) {
                ((SnapshotAllocResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, Bundle.MemorySnapshotPanel_MemoryResultsTabName());
            } else if (this.memoryPanel instanceof SnapshotLivenessResultsPanel) {
                ((SnapshotLivenessResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, Bundle.MemorySnapshotPanel_MemoryResultsTabName());
            }
        } else if (selectedView == this.reversePanel) {
            this.reversePanel.exportData(exportedFileType, eDD, Bundle.MemorySnapshotPanel_StackTracesTabName());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public boolean hasExportableView() {
        Component selectedView = this.getSelectedView();
        if (selectedView == this.memoryPanel) {
            return true;
        }
        if (selectedView == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    private class SnapshotActionsHandler
    implements MemoryResUserActionsHandler {
        private SnapshotActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (methodName == null && methodSig == null && (VMUtils.isVMPrimitiveType((String)className) || VMUtils.isPrimitiveType((String)className))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) && "traceVMObjectAlloc".equals(methodName)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)MemorySnapshotPanel.this.project, (String)className, (String)methodName, (String)methodSig);
            }
        }

        public void showStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
            MemorySnapshotPanel.this.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
        }
    }
}

