/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.openide.filesystems.DefaultURLMapperProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public abstract class URLMapper {
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int NETWORK = 2;
    private static Lookup.Result<URLMapper> result;
    private static final List<URLMapper> CACHE_JUST_COMPUTING;
    private static final ThreadLocal<List<URLMapper>> threadCache;
    private static List<URLMapper> cache;

    static void reset() {
        cache = null;
        result = Lookup.getDefault().lookupResult(URLMapper.class);
        result.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                Class<URLMapper> clazz = URLMapper.class;
                synchronized (URLMapper.class) {
                    cache = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static URL findURL(FileObject fo, int type) {
        for (URLMapper mapper : URLMapper.getInstances()) {
            URL retVal = mapper.getURL(fo, type);
            if (retVal == null) continue;
            return retVal;
        }
        if (type == 0) {
            return FileURL.encodeFileObject(fo);
        }
        return null;
    }

    public abstract URL getURL(FileObject var1, int var2);

    @Deprecated
    public static FileObject[] findFileObjects(URL url) {
        LinkedHashSet<FileObject> retSet = new LinkedHashSet<FileObject>();
        for (URLMapper mapper : URLMapper.getInstances()) {
            FileObject[] retVal = mapper.getFileObjects(url);
            if (retVal == null) continue;
            retSet.addAll(Arrays.asList(retVal));
        }
        return retSet.toArray(new FileObject[retSet.size()]);
    }

    public static FileObject findFileObject(URL url) {
        if (url == null) {
            throw new NullPointerException("Cannot pass null URL to URLMapper.findFileObject");
        }
        FileObject[] results = null;
        Iterator<URLMapper> instances = URLMapper.getInstances().iterator();
        while (instances.hasNext() && (results == null || results.length == 0)) {
            URLMapper mapper = instances.next();
            results = mapper.getFileObjects(url);
        }
        return results != null && results.length > 0 ? results[0] : null;
    }

    public abstract FileObject[] getFileObjects(URL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<URLMapper> getInstances() {
        Class<URLMapper> clazz = URLMapper.class;
        synchronized (URLMapper.class) {
            if (cache != null && (cache != CACHE_JUST_COMPUTING || threadCache.get() == CACHE_JUST_COMPUTING)) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return cache;
            }
            cache = CACHE_JUST_COMPUTING;
            threadCache.set(CACHE_JUST_COMPUTING);
            // ** MonitorExit[var0] (shouldn't be in output)
            ArrayList<URLMapper> res = null;
            try {
                res = new ArrayList<URLMapper>(result.allInstances());
                URLMapper def = null;
                Iterator it = res.iterator();
                while (it.hasNext()) {
                    URLMapper m = (URLMapper)it.next();
                    if (!(m instanceof DefaultURLMapperProxy)) continue;
                    def = m;
                    it.remove();
                    break;
                }
                if (def != null) {
                    res.add(def);
                }
                ArrayList<URLMapper> arrayList = res;
                return arrayList;
            }
            finally {
                Class<URLMapper> clazz2 = URLMapper.class;
                synchronized (URLMapper.class) {
                    if (cache == CACHE_JUST_COMPUTING) {
                        cache = res;
                    }
                    threadCache.set(null);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
        }
    }

    static {
        CACHE_JUST_COMPUTING = new ArrayList<URLMapper>();
        threadCache = new ThreadLocal();
        DefaultURLMapperProxy.setDefault(new DefaultURLMapper());
        URLMapper.reset();
    }

    private static class DefaultURLMapper
    extends URLMapper {
        DefaultURLMapper() {
        }

        @Override
        public FileObject[] getFileObjects(URL url) {
            FileObject[] foRes;
            File f;
            String prot = url.getProtocol();
            if (prot.equals("nbfs")) {
                FileObject[] fileObjectArray;
                FileObject retVal = FileURL.decodeURL(url);
                if (retVal == null) {
                    fileObjectArray = null;
                } else {
                    FileObject[] fileObjectArray2 = new FileObject[1];
                    fileObjectArray = fileObjectArray2;
                    fileObjectArray2[0] = retVal;
                }
                return fileObjectArray;
            }
            if (prot.equals("jar")) {
                return DefaultURLMapper.getFileObjectsForJarProtocol(url);
            }
            if (prot.equals("file") && (f = DefaultURLMapper.toFile(url)) != null && (foRes = this.findFileObjectsInRepository(f)) != null && foRes.length > 0) {
                return foRes;
            }
            return null;
        }

        private FileObject[] findFileObjectsInRepository(File f) {
            if (!f.equals(FileUtil.normalizeFile(f))) {
                throw new IllegalArgumentException("Parameter file was not normalized. Was " + f + " instead of " + FileUtil.normalizeFile(f));
            }
            Enumeration<? extends FileSystem> en = Repository.getDefault().getFileSystems();
            LinkedList<FileObject> list = new LinkedList<FileObject>();
            String fileName = f.getAbsolutePath();
            while (en.hasMoreElements()) {
                File file2Fo;
                FileSystem fs = en.nextElement();
                String rootName = null;
                FileObject fsRoot = fs.getRoot();
                File root = DefaultURLMapper.findFileInRepository(fsRoot);
                if (root == null) {
                    Object rootPath = fsRoot.getAttribute("FileSystem.rootPath");
                    if (rootPath == null || !(rootPath instanceof String)) continue;
                    rootName = (String)rootPath;
                }
                if (rootName == null) {
                    rootName = root.getAbsolutePath();
                }
                if (fileName.indexOf(rootName) != 0) continue;
                String res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                FileObject fo = fs.findResource(res);
                File file = file2Fo = fo != null ? DefaultURLMapper.findFileInRepository(fo) : null;
                if (fo == null || file2Fo == null || !f.equals(file2Fo)) continue;
                if (fo.getClass().toString().indexOf("org.netbeans.modules.masterfs.MasterFileObject") != -1) {
                    list.addFirst(fo);
                    continue;
                }
                list.addLast(fo);
            }
            FileObject[] results = new FileObject[list.size()];
            list.toArray(results);
            return results;
        }

        @Override
        public URL getURL(FileObject fo, int type) {
            if (fo == null) {
                return null;
            }
            if (type == 2) {
                return null;
            }
            if (fo instanceof MultiFileObject && type == 0) {
                return null;
            }
            File fFile = DefaultURLMapper.findFileInRepository(fo);
            if (fFile != null) {
                try {
                    return DefaultURLMapper.toURL(fFile, fo);
                }
                catch (MalformedURLException mfx) {
                    assert (false) : mfx;
                    return null;
                }
            }
            URL retURL = null;
            FileSystem fs = null;
            try {
                fs = fo.getFileSystem();
            }
            catch (FileStateInvalidException fsex) {
                return null;
            }
            if (fs instanceof JarFileSystem) {
                JarFileSystem jfs = (JarFileSystem)fs;
                File f = jfs.getJarFile();
                if (f == null) {
                    return null;
                }
                try {
                    String toReplace = "__EXCLAMATION_REPLACEMENT__";
                    retURL = new URL("jar:" + Utilities.toURI((File)new File(f, toReplace + fo.getPath())).toString().replaceFirst("/" + toReplace, "!/") + (fo.isFolder() && !fo.isRoot() ? "/" : ""));
                }
                catch (MalformedURLException mfx) {
                    mfx.printStackTrace();
                    return null;
                }
            } else if (fs instanceof XMLFileSystem) {
                URL retVal = null;
                try {
                    retVal = ((XMLFileSystem)fs).getURL(fo.getPath());
                    if (retVal == null) {
                        return null;
                    }
                    if (type == 0) {
                        return retVal;
                    }
                    boolean isInternal = retVal.getProtocol().startsWith("nbres");
                    if (type == 1 && !isInternal) {
                        return retVal;
                    }
                    return null;
                }
                catch (FileNotFoundException fnx) {
                    return null;
                }
            }
            return retURL;
        }

        private static URL toURL(File fFile, FileObject fo) throws MalformedURLException {
            URL retVal = Utilities.toURI((File)fFile).toURL();
            if (retVal != null && fo.isFolder()) {
                String urlDef = retVal.toExternalForm();
                String pathSeparator = "/";
                if (!urlDef.endsWith("/")) {
                    retVal = new URL(urlDef + "/");
                }
            }
            return retVal;
        }

        private static File findFileInRepository(FileObject fo) {
            File f = (File)fo.getAttribute("java.io.File");
            return f != null ? FileUtil.normalizeFile(f) : null;
        }

        private static FileObject[] getFileObjectsForJarProtocol(URL url) {
            FileObject[] fileObjectArray;
            JarFileSystem fs;
            FileObject retVal = null;
            JarURLParser jarUrlParser = new JarURLParser(url);
            File file = jarUrlParser.getJarFile();
            String entryName = jarUrlParser.getEntryName();
            if (file != null && (fs = DefaultURLMapper.findJarFileSystem(file)) != null) {
                if (entryName == null) {
                    entryName = "";
                }
                retVal = fs.findResource(entryName);
            }
            if (retVal == null) {
                fileObjectArray = null;
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = retVal;
            }
            return fileObjectArray;
        }

        private static JarFileSystem findJarFileSystem(File jarFile) {
            JarFileSystem retVal = null;
            Enumeration<? extends FileSystem> en = Repository.getDefault().getFileSystems();
            while (en.hasMoreElements()) {
                File fsJarFile;
                FileSystem fs = en.nextElement();
                if (!(fs instanceof JarFileSystem) || !(fsJarFile = ((JarFileSystem)fs).getJarFile()).equals(jarFile)) continue;
                retVal = (JarFileSystem)fs;
                break;
            }
            return retVal;
        }

        private static File toFile(URL u) {
            if (u == null) {
                throw new NullPointerException();
            }
            try {
                URI uri = new URI(u.toExternalForm());
                return FileUtil.normalizeFile(Utilities.toFile((URI)uri));
            }
            catch (URISyntaxException use) {
                return null;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private static class JarURLParser {
            private File jarFile;
            private String entryName;

            JarURLParser(URL originalURL) {
                this.parse(originalURL);
            }

            void parse(URL originalURL) {
                String spec = originalURL.getFile();
                int separator = spec.indexOf(33);
                if (separator != -1) {
                    try {
                        this.jarFile = DefaultURLMapper.toFile(new URL(spec.substring(0, separator++)));
                        this.entryName = null;
                    }
                    catch (MalformedURLException e) {
                        return;
                    }
                    if (++separator != spec.length()) {
                        try {
                            this.entryName = URLDecoder.decode(spec.substring(separator, spec.length()), "UTF-8");
                        }
                        catch (UnsupportedEncodingException ex) {
                            return;
                        }
                    }
                }
            }

            File getJarFile() {
                return this.jarFile;
            }

            String getEntryName() {
                return this.entryName;
            }
        }
    }
}

