/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.selector.api.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.api.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.ui.WrappingSearchCursor;
import org.openide.util.Lookup;

public class TreePathSearch
extends WrappingSearchCursor<TreePath> {
    private TreeNode root;
    private final ClassIndex ci;
    private final List<Lookup> contexts = new ArrayList<Lookup>();
    private final List<List<SourceClassInfo>> rslts = new ArrayList<List<SourceClassInfo>>();

    protected TreePathSearch(TreeNode root, String searchTerm, ClassIndex ci) {
        super(searchTerm);
        this.ci = ci;
        this.root = root;
        Enumeration<? extends TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            SelectorNode n = (SelectorNode)e.nextElement();
            this.contexts.add(n.getLookup());
            this.rslts.add(null);
        }
    }

    @Override
    protected TreePath getItem(int slotIndex, int itemIndex) {
        SourceClassInfo sci = this.getSlot(slotIndex).get(itemIndex);
        if (sci != null) {
            return this.findPath(sci, slotIndex);
        }
        return null;
    }

    @Override
    protected int getSlotSize(int slotIndex) {
        return this.getSlot(slotIndex).size();
    }

    @Override
    protected int getSlotsNumber() {
        return this.contexts.size();
    }

    private List<SourceClassInfo> getSlot(int slotIndex) {
        List<SourceClassInfo> scis = this.rslts.get(slotIndex);
        if (scis == null) {
            String pattern = ".*" + this.getSearchTerm() + ".*";
            Lookup c = this.contexts.get(slotIndex);
            scis = this.ci.getClasses(pattern, c);
            this.rslts.set(slotIndex, scis);
        }
        return scis;
    }

    private TreePath findPath(SourceClassInfo sci, int slotIndex) {
        if (sci == null) {
            return null;
        }
        ClientUtils.SourceCodeSelection scs = new ClientUtils.SourceCodeSelection(sci.getQualifiedName() + "$**", null, null);
        SelectorNode n = this.findNode((SelectorNode)this.root.getChildAt(slotIndex), scs);
        if (n != null) {
            TreeNode[] nPath = n.getPath();
            Object[] path = new Object[nPath.length + 1];
            path[0] = this.root;
            System.arraycopy(nPath, 0, path, 1, nPath.length);
            return new TreePath(path);
        }
        return null;
    }

    private SelectorNode findNode(SelectorNode root, ClientUtils.SourceCodeSelection sig) {
        ArrayDeque<SelectorNode> toSearch = new ArrayDeque<SelectorNode>();
        toSearch.add(root);
        while (!toSearch.isEmpty()) {
            if (this.isCancelled()) {
                return null;
            }
            SelectorNode n = (SelectorNode)toSearch.poll();
            ClientUtils.SourceCodeSelection nodeSig = n.getSignature();
            if (nodeSig != null && nodeSig.equals((Object)sig)) {
                return n;
            }
            if (nodeSig != null && !nodeSig.contains(sig)) continue;
            Enumeration e = n.children();
            while (e.hasMoreElements()) {
                if (this.isCancelled()) {
                    return null;
                }
                SelectorNode childNode = (SelectorNode)e.nextElement();
                ClientUtils.SourceCodeSelection childSig = childNode.getSignature();
                if (childSig != null && childSig.equals((Object)sig)) {
                    return childNode;
                }
                if (childSig != null && !childSig.contains(sig) || childNode instanceof MethodsNode || childNode instanceof ConstructorsNode) continue;
                toSearch.offer(childNode);
            }
        }
        return null;
    }

    public static interface ClassIndex {
        public List<SourceClassInfo> getClasses(String var1, Lookup var2);
    }
}

