/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Exceptions;

final class FileObjectKeeper
implements FileChangeListener {
    private static final Logger LOG = Logger.getLogger(FileObjectKeeper.class.getName());
    private static final Object TIME_STAMP_LOCK = new Object();
    private Set<FolderObj> kept;
    private Collection<FileChangeListener> listeners;
    private final FolderObj root;
    private long timeStamp;

    public FileObjectKeeper(FolderObj root) {
        this.root = root;
    }

    public synchronized void addRecursiveListener(FileChangeListener fcl) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet<FileChangeListener>();
        }
        LOG.log(Level.FINEST, "addRecursiveListener for {0} isEmpty: {1}", new Object[]{this.root, this.listeners.isEmpty()});
        if (this.listeners.isEmpty()) {
            Callable stop = null;
            boolean deepClass = fcl.getClass().getName().equals("org.openide.filesystems.DeepListener");
            if (fcl instanceof Callable && deepClass) {
                stop = (Callable)fcl;
            }
            FileFilter filter = null;
            if (fcl instanceof FileFilter && deepClass) {
                filter = (FileFilter)fcl;
            }
            this.listenToAll(stop, filter);
        }
        this.listeners.add(fcl);
    }

    public synchronized void removeRecursiveListener(FileChangeListener fcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(fcl);
        LOG.log(Level.FINEST, "removeRecursiveListener for {0} isEmpty: {1}", new Object[]{this.root, this.listeners.isEmpty()});
        if (this.listeners.isEmpty()) {
            this.listenNoMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> init(long previous, FileObjectFactory factory, boolean expected) {
        boolean recursive;
        Object object = TIME_STAMP_LOCK;
        synchronized (object) {
            boolean bl = recursive = this.timeStamp < -1L;
            if (this.timeStamp > 0L) {
                this.timeStamp = -this.timeStamp;
            }
        }
        File file = Watcher.wrap(this.root.getFileName().getFile(), this.root);
        LinkedList<File> arr = new LinkedList<File>();
        long ts = this.root.getProvidedExtensions().refreshRecursively(file, previous, arr);
        try {
            for (File f : arr) {
                if (f.isDirectory()) continue;
                long lm = f.lastModified();
                LOG.log(Level.FINE, "  check {0} for {1}", new Object[]{lm, f});
                if (lm > ts) {
                    ts = lm;
                }
                if (lm <= previous || factory == null || recursive) continue;
                BaseFileObj prevFO = factory.getCachedOnly(f);
                if (prevFO == null) {
                    BaseFileObj who = factory.getValidFileObject(f, FileObjectFactory.Caller.GetChildern);
                    if (who != null) {
                        LOG.log(Level.FINE, "External change detected {0}", (Object)who);
                        who.fireFileChangedEvent(expected);
                        continue;
                    }
                    LOG.log(Level.FINE, "Cannot get valid FileObject. File probably removed: {0}", f);
                    continue;
                }
                LOG.log(Level.FINE, "Do classical refresh for {0}", (Object)prevFO);
                prevFO.refresh(expected, true);
            }
        }
        catch (StackOverflowError ex) {
            Exceptions.attachMessage((Throwable)ex, (String)("FileObjectKeeper.init for " + (Object)((Object)this.root) + " timeStamp: " + this.timeStamp + " recursive: " + recursive));
            throw ex;
        }
        Object object2 = TIME_STAMP_LOCK;
        synchronized (object2) {
            if (!recursive) {
                this.timeStamp = ts;
            }
        }
        LOG.log(Level.FINE, "Testing {0}, time {1}", new Object[]{file, this.timeStamp});
        return arr;
    }

    private void listenTo(FileObject fo, boolean add, Collection<? super File> children) {
        if (add) {
            fo.addFileChangeListener((FileChangeListener)this);
            if (fo instanceof FolderObj) {
                FolderObj folder = (FolderObj)fo;
                folder.getKeeper(children);
                folder.getChildren();
                Set<FolderObj> k = this.kept;
                if (k != null) {
                    k.add(folder);
                }
            }
            LOG.log(Level.FINER, "Listening to {0}", fo);
        } else {
            fo.removeFileChangeListener((FileChangeListener)this);
            LOG.log(Level.FINER, "Ignoring {0}", fo);
        }
    }

    private void listenToAll(Callable<?> stop, FileFilter filter) {
        assert (Thread.holdsLock(this));
        assert (this.kept == null) : "Already listening to " + this.kept + " now requested for " + (Object)((Object)this.root);
        this.kept = new HashSet<FolderObj>();
        LinkedList it = new LinkedList();
        this.listenTo(this.root, true, it);
        FileObjectFactory factory = null;
        while (true) {
            File f = (File)it.poll();
            LOG.log(Level.FINEST, "listenToAll, processing {0}", f);
            if (f == null || FileObjectKeeper.isCyclicSymlink(f)) break;
            if (factory == null) {
                factory = FileObjectFactory.getInstance(f);
            }
            BaseFileObj fo = factory.getValidFileObject(f, FileObjectFactory.Caller.Others);
            LOG.log(Level.FINEST, "listenToAll, check {0} for stop {1}", new Object[]{fo, stop});
            if (!(fo instanceof FolderObj)) continue;
            FolderObj obj = (FolderObj)fo;
            if (filter != null && !filter.accept(obj.getFileName().getFile())) continue;
            Boolean shallStop = null;
            if (stop != null) {
                try {
                    shallStop = (Boolean)stop.call();
                }
                catch (Exception ex) {
                    shallStop = Boolean.TRUE;
                }
            }
            if (Boolean.TRUE.equals(shallStop)) {
                LOG.log(Level.INFO, "addRecursiveListener to {0} interrupted", (Object)this.root);
                return;
            }
            this.listenTo(obj, true, it);
        }
    }

    private void listenNoMore() {
        assert (Thread.holdsLock(this));
        this.listenTo(this.root, false, null);
        Set<FolderObj> k = this.kept;
        if (k != null) {
            for (FolderObj fo : k) {
                this.listenTo(fo, false, null);
            }
            this.kept = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileFolderCreated(FileEvent fe) {
        Collection<FileChangeListener> arr = this.listeners;
        FileObject folder = fe.getFile();
        if (folder instanceof FolderObj) {
            FolderObj obj = (FolderObj)folder;
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                File f;
                LinkedList it = new LinkedList();
                this.listenTo(obj, true, it);
                FileObjectFactory factory = null;
                while ((f = (File)it.poll()) != null) {
                    BaseFileObj fo;
                    if (factory == null) {
                        factory = FileObjectFactory.getInstance(f);
                    }
                    if (!((fo = factory.getValidFileObject(f, FileObjectFactory.Caller.Others)) instanceof FolderObj)) continue;
                    this.listenTo((FolderObj)fo, true, it);
                }
            }
        }
        if (arr == null || this.kept == null) {
            return;
        }
        for (FileChangeListener l : arr) {
            l.fileFolderCreated(fe);
        }
    }

    public void fileDataCreated(FileEvent fe) {
        Collection<FileChangeListener> arr = this.listeners;
        if (arr == null) {
            return;
        }
        for (FileChangeListener l : arr) {
            l.fileDataCreated(fe);
        }
    }

    public void fileChanged(FileEvent fe) {
        Collection<FileChangeListener> arr = this.listeners;
        if (arr == null) {
            return;
        }
        for (FileChangeListener l : arr) {
            l.fileChanged(fe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fe) {
        Collection<FileChangeListener> arr = this.listeners;
        FileObject f = fe.getFile();
        if (f.isFolder() && fe.getSource() == f && f != this.root) {
            return;
        }
        if (f instanceof FolderObj) {
            FolderObj obj = (FolderObj)f;
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                if (this.kept != null) {
                    this.kept.remove((Object)obj);
                }
                this.listenTo(obj, false, null);
            }
        }
        if (arr == null) {
            return;
        }
        for (FileChangeListener l : arr) {
            l.fileDeleted(fe);
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        Collection<FileChangeListener> arr = this.listeners;
        if (arr == null) {
            return;
        }
        FileObject f = fe.getFile();
        if (f.isFolder() && fe.getSource() == f && f != this.root) {
            return;
        }
        for (FileChangeListener l : arr) {
            l.fileRenamed(fe);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        Collection<FileChangeListener> arr = this.listeners;
        if (arr == null) {
            return;
        }
        for (FileChangeListener l : arr) {
            l.fileAttributeChanged(fe);
        }
    }

    long childrenLastModified() {
        return Math.abs(this.timeStamp);
    }

    boolean isOn() {
        if (this.kept != null) {
            return true;
        }
        FolderObj obj = this.root.getExistingParent();
        return obj != null && obj.hasRecursiveListener();
    }

    private static boolean isCyclicSymlink(File f) {
        File p = f.getParentFile();
        while (p != null) {
            if (p.getName().equals(f.getName())) {
                try {
                    if (f.getCanonicalFile().equals(p.getCanonicalFile())) {
                        return true;
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Can't convert to cannonical files {0} and {1}", new Object[]{f, p});
                    LOG.log(Level.FINE, null, ex);
                }
            }
            p = p.getParentFile();
        }
        return false;
    }
}

