/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils;

import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;

public class StringUtils {
    private static final String THIS_WEEK_FORMAT;
    private static final String LAST_WEEK_FORMAT;
    private static final String YESTERDAY_FORMAT;
    private static NumberFormat percentage;
    private static NumberFormat intFormat;
    private static char SEPARATOR;
    private static SimpleDateFormat thisWeekFormat;
    private static SimpleDateFormat lastWeekFormat;
    private static SimpleDateFormat yesterdayFormat;
    private static DateFormat todayFormat;
    private static DateFormat otherFormat;
    private static DateFormat fullFormat;

    public static void appendSplittedLongString(StringBuffer sb, String s, int maxLineLen) {
        int nLines = s.length() / maxLineLen + (s.length() % maxLineLen != 0 ? 1 : 0);
        int idx = 0;
        for (int i = 0; i < nLines; ++i) {
            int endIdx;
            if (i > 0) {
                sb.append('\n');
            }
            if ((endIdx = idx + maxLineLen) > s.length()) {
                endIdx = s.length();
            }
            sb.append(s.substring(idx, endIdx));
            idx = endIdx;
        }
    }

    public static String[][] convertPackedStringsIntoStringArrays(byte[] packedData, int[] packedArrayOffsets, int dim) {
        String[][] ret = new String[dim][];
        int len = packedArrayOffsets.length / dim;
        for (int i = 0; i < dim; ++i) {
            ret[i] = new String[len];
        }
        int idx = 0;
        int lastIdx = packedArrayOffsets.length - 1;
        for (int j = 0; j < len; ++j) {
            for (int i = 0; i < dim; ++i) {
                int utf8Len = idx < lastIdx ? packedArrayOffsets[idx + 1] - packedArrayOffsets[idx] : packedData.length - packedArrayOffsets[idx];
                ret[i][j] = StringUtils.utf8ToString(packedData, packedArrayOffsets[idx], utf8Len);
                ++idx;
            }
        }
        return ret;
    }

    public static String floatPerCentToString(float t) {
        return percentage.format(t);
    }

    public static String formatFullDate(Date date) {
        return fullFormat.format(date);
    }

    public static String formatUserDate(Date date) {
        Calendar now = Calendar.getInstance();
        Calendar before = Calendar.getInstance();
        before.setTime(date);
        if (before.getTimeInMillis() <= now.getTimeInMillis()) {
            int daysDelta = StringUtils.getDaysDifference(before, now);
            if (daysDelta == 0) {
                return todayFormat.format(date);
            }
            if (daysDelta == 1) {
                return yesterdayFormat.format(date);
            }
            int weekDelta = StringUtils.getWeekDifference(before, now);
            if (weekDelta == 0) {
                return thisWeekFormat.format(date);
            }
            if (weekDelta == 1) {
                return lastWeekFormat.format(date);
            }
        }
        return otherFormat.format(date);
    }

    public static String mcsTimeToString(long t) {
        StringBuilder tmpBuf = new StringBuilder();
        if (t >= 100000L) {
            return intFormat.format(t / 1000L);
        }
        if (t >= 10000L) {
            long x = t / 1000L;
            tmpBuf.append(intFormat.format(x));
            tmpBuf.append(SEPARATOR);
            tmpBuf.append(Long.toString((t - x * 1000L) / 100L));
            return tmpBuf.toString();
        }
        if (t >= 1000L) {
            long x = t / 1000L;
            tmpBuf.append(intFormat.format(x));
            tmpBuf.append(SEPARATOR);
            tmpBuf.append(Long.toString((t - x * 1000L) / 10L));
            return tmpBuf.toString();
        }
        if (t >= 100L) {
            tmpBuf.append("0");
            tmpBuf.append(SEPARATOR);
        } else if (t >= 10L) {
            tmpBuf.append("0");
            tmpBuf.append(SEPARATOR);
            tmpBuf.append("0");
        } else {
            tmpBuf.append("0");
            tmpBuf.append(SEPARATOR);
            tmpBuf.append("00");
        }
        return tmpBuf.append(Long.toString(t)).toString();
    }

    public static String nBytesToString(long b) {
        StringBuilder tmpBuf = new StringBuilder();
        if (b < 102400L) {
            return intFormat.format(b) + " B";
        }
        if (b < 0x6400000L) {
            long k = b >> 10;
            tmpBuf.append(intFormat.format(k));
            if (b < 0x6400000L) {
                tmpBuf.append(SEPARATOR);
                tmpBuf.append(Long.toString((b - (k << 10)) / 102L));
            }
            tmpBuf.append(" KB");
            return tmpBuf.toString();
        }
        long m = b >> 20;
        tmpBuf.append(intFormat.format(m));
        if (b < 0x280000000L) {
            tmpBuf.append(SEPARATOR);
            tmpBuf.append(Long.toString((b - (m << 20)) / 104858L));
        }
        tmpBuf.append(" MB");
        return tmpBuf.toString();
    }

    public static String[] parseArgsString(String args) {
        if (args == null) {
            return new String[0];
        }
        ArrayList<String> listRes = new ArrayList<String>();
        int pos0 = 0;
        int len = args.length();
        while (pos0 < len) {
            int pos1;
            for (pos1 = pos0; pos1 < len && args.charAt(pos1) != ' ' && args.charAt(pos1) != '\b'; ++pos1) {
            }
            listRes.add(args.substring(pos0, pos1));
            for (pos0 = pos1 + 1; pos0 < len && (args.charAt(pos0) == ' ' || args.charAt(pos0) == '\b'); ++pos0) {
            }
        }
        return listRes.toArray(new String[listRes.size()]);
    }

    public static String userFormClassName(String className) {
        if (className == null) {
            return null;
        }
        if ((className = className.replace('/', '.')).startsWith("[")) {
            String elemType = null;
            int lastBrackPos = className.lastIndexOf(91);
            if (lastBrackPos == className.length() - 2) {
                switch (className.charAt(lastBrackPos + 1)) {
                    case 'C': {
                        elemType = "char";
                        break;
                    }
                    case 'B': {
                        elemType = "byte";
                        break;
                    }
                    case 'I': {
                        elemType = "int";
                        break;
                    }
                    case 'Z': {
                        elemType = "boolean";
                        break;
                    }
                    case 'F': {
                        elemType = "float";
                        break;
                    }
                    case 'D': {
                        elemType = "double";
                        break;
                    }
                    case 'S': {
                        elemType = "short";
                        break;
                    }
                    case 'J': {
                        elemType = "long";
                    }
                }
            } else {
                elemType = className.substring(lastBrackPos + 1);
            }
            int nDims = lastBrackPos + 1;
            StringBuilder tmpBuf = new StringBuilder();
            tmpBuf.append(elemType);
            for (int i = 0; i < nDims; ++i) {
                tmpBuf.append("[]");
            }
            return tmpBuf.toString();
        }
        return className;
    }

    public static String utf8ToString(byte[] src, int stPos, int utf8Len) {
        char[] strBuf = new char[utf8Len];
        int i = stPos;
        int j = 0;
        int limit = stPos + utf8Len;
        while (i < limit) {
            int b;
            if ((b = src[i++] & 0xFF) >= 224) {
                b = (b & 0xF) << 12;
                b |= (src[i++] & 0x3F) << 6;
                b |= src[i++] & 0x3F;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6;
                b |= src[i++] & 0x3F;
            }
            strBuf[j++] = (char)b;
        }
        return new String(strBuf, 0, j).intern();
    }

    private static int getDaysDifference(Calendar before, Calendar after) {
        int diff = after.get(6) - before.get(6);
        return diff += before.getMaximum(6) * (after.get(1) - before.get(1));
    }

    private static int getWeekDifference(Calendar before, Calendar after) {
        int diff = after.get(3) - before.get(3);
        return diff += before.getMaximum(3) * (after.get(1) - before.get(1));
    }

    static {
        intFormat = NumberFormat.getIntegerInstance();
        SEPARATOR = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.utils.Bundle");
        THIS_WEEK_FORMAT = messages.getString("StringUtils_ThisWeekFormat");
        LAST_WEEK_FORMAT = messages.getString("StringUtils_LastWeekFormat");
        YESTERDAY_FORMAT = messages.getString("StringUtils_YesterdayFormat");
        percentage = NumberFormat.getNumberInstance();
        percentage.setMaximumFractionDigits(1);
        percentage.setMinimumFractionDigits(1);
        thisWeekFormat = new SimpleDateFormat(THIS_WEEK_FORMAT);
        lastWeekFormat = new SimpleDateFormat(LAST_WEEK_FORMAT);
        yesterdayFormat = new SimpleDateFormat(YESTERDAY_FORMAT);
        todayFormat = DateFormat.getTimeInstance(2);
        otherFormat = DateFormat.getDateTimeInstance(2, 2);
        fullFormat = DateFormat.getDateTimeInstance(0, 2);
    }
}

