/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.DynamicConstantPoolExtension;
import org.netbeans.lib.profiler.instrumentation.HandleServletDoMethodCallInjector;
import org.netbeans.lib.profiler.instrumentation.InstrumentationFactory;
import org.netbeans.lib.profiler.instrumentation.RootMethods;

public abstract class RecursiveMethodInstrumentor
extends ClassManager {
    protected Hashtable instrClasses = new Hashtable();
    protected InstrumentationFilter instrFilter;
    protected byte[] codeBytes;
    protected boolean dontInstrumentEmptyMethods;
    protected boolean dontScanGetterSetterMethods;
    protected boolean instrumentSpawnedThreads;
    protected boolean reflectInvokeInstrumented = false;
    protected int markerInjectionType;
    protected int nInstrClasses;
    protected int nInstrMethods;
    protected int normalInjectionType;
    protected int offset;
    protected int rootInjectionType;
    RootMethods rootMethods;
    private ProfilerEngineSettings engineSettings;

    RecursiveMethodInstrumentor(ProfilingSessionStatus status, ProfilerEngineSettings settings) {
        super(status);
        switch (status.currentInstrType) {
            case 3: {
                this.normalInjectionType = 0;
                this.rootInjectionType = 1;
                this.markerInjectionType = 2;
                break;
            }
            case 4: {
                this.normalInjectionType = 3;
                this.rootInjectionType = 4;
                this.markerInjectionType = 5;
            }
        }
        this.reflectInvokeInstrumented = false;
        this.dontScanGetterSetterMethods = !settings.getInstrumentGetterSetterMethods();
        this.dontInstrumentEmptyMethods = !settings.getInstrumentEmptyMethods();
        this.instrumentSpawnedThreads = settings.getInstrumentSpawnedThreads();
        this.instrFilter = settings.getInstrumentationFilter();
        this.engineSettings = settings;
    }

    abstract Object[] getInitialMethodsToInstrument(String[] var1, int[] var2, byte[][] var3, RootMethods var4);

    public abstract Object[] getMethodsToInstrumentUponClassLoad(String var1, int var2, boolean var3);

    public abstract Object[] getMethodsToInstrumentUponMethodInvocation(String var1, int var2, String var3, String var4);

    public abstract Object[] getMethodsToInstrumentUponReflectInvoke(String var1, int var2, String var3, String var4);

    protected void initInstrMethodData() {
        this.instrClasses.clear();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
    }

    protected static boolean rootClassNameIsReal(String rootClassName) {
        return !rootClassName.equals("*NO_CLASS_NAME*");
    }

    protected void addToSubclassList(DynamicClassInfo clazz, DynamicClassInfo addedClassInfo) {
        String[] interfaces;
        String superClassName = clazz.getSuperclassName();
        int loaderId = clazz.getLoaderId();
        DynamicClassInfo superClass = RecursiveMethodInstrumentor.javaClassForName(superClassName, loaderId);
        clazz.setSuperClass(superClass);
        if (superClass != null && !clazz.isInterface()) {
            if (addedClassInfo != null) {
                superClass.addSubclass(addedClassInfo);
                this.findAndMarkOverridingMethodsReachable(superClass, addedClassInfo);
            }
            if (superClassName != "java/lang/Object") {
                this.addToSubclassList(superClass, addedClassInfo);
            }
        }
        if ((interfaces = clazz.getInterfaceNames()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                DynamicClassInfo superInterface = RecursiveMethodInstrumentor.javaClassForName(interfaces[i], loaderId);
                clazz.setSuperInterface(superInterface, i);
                if (superInterface == null) continue;
                if (addedClassInfo != null) {
                    superInterface.addSubclass(addedClassInfo);
                    this.findAndMarkOverridingMethodsReachable(superInterface, addedClassInfo);
                }
                this.addToSubclassList(superInterface, addedClassInfo);
            }
        }
    }

    protected abstract void findAndMarkOverridingMethodsReachable(DynamicClassInfo var1, DynamicClassInfo var2);

    protected abstract void processInvoke(DynamicClassInfo var1, boolean var2, int var3);

    protected final int at(int index) {
        return this.codeBytes[this.offset + index] & 0xFF;
    }

    protected final long intAt(int tbl, int entry) {
        int base = tbl + (entry << 2);
        return this.codeBytes[base] << 24 | (this.codeBytes[base + 1] & 0xFF) << 16 | (this.codeBytes[base + 2] & 0xFF) << 8 | this.codeBytes[base + 3] & 0xFF;
    }

    protected void scanMethod(DynamicClassInfo clazz, int index) {
        byte[] bytecode = clazz.getMethodBytecode(index);
        this.scanBytecode(clazz, bytecode);
    }

    protected final int shortAt(int index) {
        int base = this.offset + index;
        return (this.codeBytes[base] & 0xFF) << 8 | this.codeBytes[base + 1] & 0xFF;
    }

    protected boolean scanBytecode(DynamicClassInfo clazz, byte[] code) {
        this.codeBytes = code;
        this.offset = 0;
        block6: while (this.offset < this.codeBytes.length) {
            int opcode = this.at(0);
            if (opcode == 196) {
                opcode = this.at(1);
                if (opcode >= 21 && opcode <= 25 || opcode >= 54 && opcode <= 58 || opcode == 169) {
                    this.offset += 4;
                    continue;
                }
                if (opcode == 132) {
                    this.offset += 6;
                    continue;
                }
                ++this.offset;
                continue;
            }
            switch (opcode) {
                case 170: {
                    int tbl = this.offset + 1 + 3 & 0xFFFFFFFC;
                    long default_skip = this.intAt(tbl, 0);
                    long low = this.intAt(tbl, 1);
                    long high = this.intAt(tbl, 2);
                    this.offset = (tbl += 12) + (int)(high - low + 1L << 2);
                    continue block6;
                }
                case 171: {
                    int tbl = this.offset + 1 + 3 & 0xFFFFFFFC;
                    long default_skip = this.intAt(tbl, 0);
                    int npairs = (int)this.intAt(tbl, 1);
                    int nints = npairs * 2;
                    this.offset = (tbl += 8) + (nints << 2);
                    continue block6;
                }
                case 182: 
                case 183: 
                case 184: {
                    if (clazz == null) {
                        return false;
                    }
                    int index = this.shortAt(1);
                    this.processInvoke(clazz, opcode == 182, index);
                    this.offset += 3;
                    continue block6;
                }
                case 185: {
                    if (clazz == null) {
                        return false;
                    }
                    int index = this.shortAt(1);
                    this.processInvoke(clazz, true, index);
                    this.offset += 5;
                    continue block6;
                }
            }
            this.offset += opc_length[opcode];
        }
        return true;
    }

    protected abstract boolean tryInstrumentSpawnedThreads(DynamicClassInfo var1);

    protected static boolean isEmptyMethod(byte[] code) {
        return code.length == 1;
    }

    protected static boolean isGetterSetterMethod(byte[] code) {
        return code.length == 5 ? (code[0] & 0xFF) == 42 && (code[1] & 0xFF) == 180 && (code[4] & 0xFF) >= 172 && (code[4] & 0xFF) <= 176 : code.length == 6 && (code[0] & 0xFF) == 42 && (code[1] & 0xFF) >= 27 && (code[1] & 0xFF) <= 43 && (code[2] & 0xFF) == 181 && (code[5] & 0xFF) == 177;
    }

    protected boolean isLeafMethod(byte[] code) {
        return this.scanBytecode(null, code);
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrClasses == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    protected void markAllMethodsMarker(DynamicClassInfo clazz) {
        clazz.setAllMethodsMarkers();
    }

    protected void markAllMethodsRoot(DynamicClassInfo clazz) {
        clazz.setAllMethodsRoots();
    }

    protected void markClassAndMethodForInstrumentation(DynamicClassInfo clazz, int methodIdx) {
        if (this.status.getStartingMethodId() + this.nInstrMethods < 65535) {
            this.addInsrClass(clazz);
            ++this.nInstrMethods;
        } else {
            clazz.setMethodInstrumented(methodIdx);
        }
    }

    protected void markProfilingPointForInstrumentation(String classNameDot, String className, int classLoaderId) {
        RuntimeProfilingPoint[] pp;
        for (RuntimeProfilingPoint point : pp = this.engineSettings.getRuntimeProfilingPoints()) {
            if (!classNameDot.equals(point.getClassName())) continue;
            DynamicClassInfo clazz = RecursiveMethodInstrumentor.javaClassForName(className, classLoaderId);
            if (clazz != null) {
                this.markProfilingPonitForInstrumentation(clazz);
            }
            return;
        }
    }

    protected void markProfilingPonitForInstrumentation(DynamicClassInfo clazz) {
        RuntimeProfilingPoint[] pp = this.engineSettings.getRuntimeProfilingPoints();
        RuntimeProfilingPoint[] ppclass = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(pp, clazz);
        if (ppclass.length > 0) {
            this.addInsrClass(clazz);
        }
    }

    protected boolean markMethod(DynamicClassInfo clazz, int rootMethod) {
        String rootMethodName = this.rootMethods.methodNames[rootMethod];
        String rootMethodSignature = this.rootMethods.methodSignatures[rootMethod];
        boolean isMarkerMethod = this.rootMethods.markerMethods[rootMethod];
        int rootMethodIdx = clazz.getMethodIndex(rootMethodName, rootMethodSignature);
        if (rootMethodIdx == -1) {
            return false;
        }
        if (isMarkerMethod) {
            clazz.setMethodMarker(rootMethodIdx);
        } else {
            clazz.setMethodRoot(rootMethodIdx);
        }
        return true;
    }

    protected boolean markMethodMarker(DynamicClassInfo clazz, String rootMethodName, String rootMethodSignature) {
        int rootMethodIdx = clazz.getMethodIndex(rootMethodName, rootMethodSignature);
        if (rootMethodIdx == -1) {
            return false;
        }
        clazz.setMethodMarker(rootMethodIdx);
        return true;
    }

    protected boolean markMethodRoot(DynamicClassInfo clazz, String rootMethodName, String rootMethodSignature) {
        int rootMethodIdx = clazz.getMethodIndex(rootMethodName, rootMethodSignature);
        if (rootMethodIdx == -1) {
            return false;
        }
        clazz.setMethodRoot(rootMethodIdx);
        return true;
    }

    private Object[] createInstrumentedMethodPack15() {
        DynamicClassInfo reflectMethodClass = null;
        int reflectMethodClassIdx = -1;
        if (!this.reflectInvokeInstrumented) {
            int idx = 0;
            Enumeration e = this.instrClasses.elements();
            while (e.hasMoreElements()) {
                DynamicClassInfo clazz = (DynamicClassInfo)e.nextElement();
                if (clazz.getName() == "java/lang/reflect/Method") {
                    reflectMethodClassIdx = idx;
                    reflectMethodClass = clazz;
                    break;
                }
                ++idx;
            }
            if (reflectMethodClassIdx == -1 && (reflectMethodClass = RecursiveMethodInstrumentor.javaClassForName("java.lang.reflect.Method", 0)) != null) {
                ++this.nInstrClasses;
            }
            if (reflectMethodClass == null) {
                this.reflectInvokeInstrumented = true;
            }
        }
        String[] instrMethodClasses = new String[this.nInstrClasses];
        int[] instrClassLoaderIds = new int[this.nInstrClasses];
        boolean[] instrMethodLeaf = new boolean[this.nInstrMethods];
        byte[][] replacementClassFileBytes = new byte[this.nInstrClasses][];
        int methodId = this.status.getStartingMethodId();
        int classIdx = 0;
        int methodIdx = 0;
        Enumeration e = this.instrClasses.elements();
        while (e.hasMoreElements()) {
            DynamicClassInfo clazz = (DynamicClassInfo)e.nextElement();
            int nMethods = clazz.getMethodNames().length;
            instrMethodClasses[classIdx] = clazz.getName().replace('/', '.').intern();
            instrClassLoaderIds[classIdx] = clazz.getLoaderId();
            boolean hasRootMethods = clazz.hasUninstrumentedRootMethods();
            boolean hasMarkerMethods = clazz.hasUninstrumentedMarkerMethods();
            DynamicConstantPoolExtension.getCPFragment(clazz, this.normalInjectionType);
            if (hasRootMethods) {
                DynamicConstantPoolExtension.getCPFragment(clazz, this.rootInjectionType);
            }
            if (hasMarkerMethods) {
                DynamicConstantPoolExtension.getCPFragment(clazz, this.markerInjectionType);
            }
            int imInClass = 0;
            byte[][] replacementMethodInfos = new byte[nMethods][];
            RuntimeProfilingPoint[] pointsForClass = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(this.engineSettings.getRuntimeProfilingPoints(), clazz);
            for (int i = 0; i < nMethods; ++i) {
                RuntimeProfilingPoint[] points = RecursiveMethodInstrumentor.getRuntimeProfilingPoints(pointsForClass, i);
                if (!clazz.isMethodInstrumented(i)) {
                    if (clazz.isMethodReachable(i) && !clazz.isMethodUnscannable(i)) {
                        clazz.setMethodInstrumented(i);
                        instrMethodLeaf[methodIdx] = clazz.isMethodLeaf(i);
                        replacementMethodInfos[i] = InstrumentationFactory.instrumentMethod(clazz, i, this.normalInjectionType, this.rootInjectionType, this.markerInjectionType, methodId++, points);
                        clazz.saveMethodInfo(i, replacementMethodInfos[i]);
                        this.status.updateInstrMethodsInfo(instrMethodClasses[classIdx], instrClassLoaderIds[classIdx], clazz.getMethodNames()[i], clazz.getMethodSignatures()[i]);
                        ++imInClass;
                        ++methodIdx;
                        continue;
                    }
                    if (points.length <= 0) continue;
                    replacementMethodInfos[i] = InstrumentationFactory.instrumentAsProiflePointHitMethod(clazz, i, this.normalInjectionType, points);
                    clazz.saveMethodInfo(i, replacementMethodInfos[i]);
                    ++imInClass;
                    continue;
                }
                replacementMethodInfos[i] = clazz.getMethodInfo(i);
                ++imInClass;
            }
            this.instrumentServletDoMethods(clazz, replacementMethodInfos);
            if (imInClass > 0) {
                if (hasRootMethods) {
                    clazz.setHasUninstrumentedRootMethods(false);
                }
                if (hasMarkerMethods) {
                    clazz.setHasUninstrumentedMarkerMethods(false);
                }
                DynamicConstantPoolExtension wholeECP = DynamicConstantPoolExtension.getAllAddedCPFragments(clazz);
                int nAddedCPEntries = wholeECP.getNEntries();
                byte[] addedCPContents = wholeECP.getContents();
                replacementClassFileBytes[classIdx] = ClassRewriter.rewriteClassFile(clazz, replacementMethodInfos, nAddedCPEntries, addedCPContents);
            }
            ++classIdx;
        }
        if (!this.reflectInvokeInstrumented) {
            int nMethods = reflectMethodClass.getMethodNames().length;
            byte[][] replacementMethodInfos = new byte[nMethods][];
            if (reflectMethodClassIdx == -1) {
                instrMethodClasses[classIdx] = "java.lang.reflect.Method";
                instrClassLoaderIds[classIdx] = 0;
            } else {
                classIdx = reflectMethodClassIdx;
                for (int i = 0; i < nMethods; ++i) {
                    replacementMethodInfos[i] = reflectMethodClass.getMethodInfo(i);
                }
            }
            int idx = reflectMethodClass.getMethodIndex("invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
            DynamicConstantPoolExtension.getCPFragment(reflectMethodClass, 6);
            replacementMethodInfos[idx] = InstrumentationFactory.instrumentAsReflectInvokeMethod(reflectMethodClass, idx);
            DynamicConstantPoolExtension wholeECP = DynamicConstantPoolExtension.getAllAddedCPFragments(reflectMethodClass);
            int nAddedCPEntries = wholeECP.getNEntries();
            byte[] addedCPContents = wholeECP.getContents();
            replacementClassFileBytes[classIdx] = ClassRewriter.rewriteClassFile(reflectMethodClass, replacementMethodInfos, nAddedCPEntries, addedCPContents);
            reflectMethodClass.saveMethodInfo(idx, replacementMethodInfos[idx]);
            this.reflectInvokeInstrumented = true;
        }
        return new Object[]{instrMethodClasses, instrClassLoaderIds, instrMethodLeaf, replacementClassFileBytes};
    }

    private void instrumentServletDoMethods(DynamicClassInfo clazz, byte[][] replacementMethodInfos) {
        if (!Boolean.getBoolean("org.netbeans.lib.profiler.servletTracking")) {
            return;
        }
        if (clazz.isServletDoMethodScanned()) {
            return;
        }
        clazz.setServletDoMethodScanned();
        if (!clazz.isSubclassOf(HandleServletDoMethodCallInjector.getClassName())) {
            return;
        }
        DynamicConstantPoolExtension.getCPFragment(clazz, 7);
        String[] methods = HandleServletDoMethodCallInjector.getMethodNames();
        String[] sigs = HandleServletDoMethodCallInjector.getMethodSignatures();
        for (int i = 0; i < methods.length; ++i) {
            int midx = clazz.getMethodIndex(methods[i], sigs[i]);
            if (midx == -1) continue;
            replacementMethodInfos[midx] = InstrumentationFactory.instrumentAsServletDoMethod(clazz, midx);
            clazz.saveMethodInfo(midx, replacementMethodInfos[midx]);
        }
    }

    private void addInsrClass(DynamicClassInfo clazz) {
        String classNameAndLoader = clazz.getNameAndLoader();
        if (!this.instrClasses.containsKey(classNameAndLoader)) {
            this.instrClasses.put(classNameAndLoader, clazz);
            ++this.nInstrClasses;
        }
    }

    protected static class ReachableMethodPlaceholder
    extends PlaceholderClassInfo {
        protected ArrayList methodNamesAndSigs = new ArrayList();

        ReachableMethodPlaceholder(String className, int classLoaderId) {
            super(className, classLoaderId);
        }

        public void registerReachableMethod(String methodName, String methodSig) {
            int nameIdx = this.methodNamesAndSigs.indexOf(methodName);
            if (nameIdx != -1 && this.methodNamesAndSigs.get(nameIdx + 1).equals(methodSig)) {
                return;
            }
            this.methodNamesAndSigs.add(methodName);
            this.methodNamesAndSigs.add(methodSig);
        }
    }
}

