/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.snaptracer.PackageStateHandler;
import org.netbeans.modules.profiler.snaptracer.ProbeStateHandler;
import org.netbeans.modules.profiler.snaptracer.SessionInitializationException;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerProbe;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.openide.util.RequestProcessor;

final class TracerController {
    private static final Logger LOGGER = Logger.getLogger(TracerController.class.getName());
    private static final String PROPERTY_STATE = "state";
    static final int STATE_SESSION_INACTIVE = 0;
    static final int STATE_SESSION_RUNNING = 1;
    static final int STATE_SESSION_IMPOSSIBLE = -1;
    static final int STATE_SESSION_STARTING = Integer.MAX_VALUE;
    static final int STATE_SESSION_STOPPING = Integer.MIN_VALUE;
    private final TracerModel model;
    private final PropertyChangeSupport changeSupport;
    private int state;
    private TracerProgressObject progress;
    private String error;
    private boolean wasNegativeValue;
    private RequestProcessor processor;

    TracerController(TracerModel model) {
        this.model = model;
        this.changeSupport = new PropertyChangeSupport(this);
        this.state = 0;
    }

    private void setState(final int state) {
        Runnable stateSetter = new Runnable(){

            @Override
            public void run() {
                if (TracerController.this.state == -1) {
                    return;
                }
                int oldState = TracerController.this.state;
                TracerController.this.state = state;
                TracerController.this.changeSupport.firePropertyChange(TracerController.PROPERTY_STATE, oldState, state);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            stateSetter.run();
        } else {
            SwingUtilities.invokeLater(stateSetter);
        }
    }

    int getState() {
        return this.state;
    }

    TracerProgressObject getProgress() {
        return this.progress;
    }

    String getErrorMessage() {
        return this.error;
    }

    void addListener(PropertyChangeListener listener) {
        if (this.changeSupport != null && this.state != -1) {
            this.changeSupport.addPropertyChangeListener(PROPERTY_STATE, listener);
        }
    }

    void removeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(PROPERTY_STATE, listener);
        }
    }

    void performSession() {
        this.startSession();
        this.doPerformSession();
        this.stopSession();
    }

    void performAfterSession(Runnable task) {
        this.getProcessor().post(task);
    }

    private void startSession() {
        if (!this.model.areProbesDefined()) {
            return;
        }
        if (this.doStartSession()) {
            this.setState(1);
        } else {
            this.setState(0);
        }
    }

    private void stopSession() {
        if (this.state == 1) {
            this.setState(Integer.MIN_VALUE);
        }
        this.doStopSession();
        this.setState(0);
    }

    private boolean doStartSession() {
        this.wasNegativeValue = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerController.this.model.getTimelineSupport().resetValues();
            }
        });
        Set<Map.Entry<TracerPackage, List<TracerProbe>>> toNotify = this.model.getDefinedProbeSets();
        this.notifySessionInitializing(toNotify);
        this.setState(Integer.MAX_VALUE);
        if (!this.notifySessionStarting(toNotify)) {
            return false;
        }
        this.notifySessionRunning(toNotify);
        return true;
    }

    private void doPerformSession() {
        int samples = this.model.getSamplesCount();
        for (int i = 0; i < samples; ++i) {
            this.fetchData(i);
        }
    }

    private void doStopSession() {
        Set<Map.Entry<TracerPackage, List<TracerProbe>>> toNotify = this.model.getDefinedProbeSets();
        this.notifySessionStopping(toNotify);
        this.notifySessionFinished(toNotify);
    }

    private void notifySessionInitializing(Set<Map.Entry<TracerPackage, List<TracerProbe>>> items) {
        ArrayList<TracerProgressObject> progresses = new ArrayList<TracerProgressObject>();
        int steps = 0;
        for (Map.Entry<TracerPackage, List<TracerProbe>> item : items) {
            List<TracerProbe> probes = item.getValue();
            TracerProbe[] probesArr = probes.toArray(new TracerProbe[probes.size()]);
            PackageStateHandler ph = item.getKey().getStateHandler();
            if (ph != null) {
                try {
                    TracerProgressObject c = ph.sessionInitializing(probesArr, null, -1);
                    if (c != null) {
                        steps += c.getSteps();
                        progresses.add(c);
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Package exception in sessionInitializing", t);
                }
            }
            for (TracerProbe probe : probes) {
                ProbeStateHandler rh = probe.getStateHandler();
                if (rh == null) continue;
                try {
                    TracerProgressObject c = rh.sessionInitializing(null, -1);
                    if (c == null) continue;
                    steps += c.getSteps();
                    progresses.add(c);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionInitializing", t);
                }
            }
        }
        if (steps == 0) {
            this.progress = null;
        } else {
            this.progress = new TracerProgressObject(steps, "Starting session...");
            TracerProgressObject.Listener l = new TracerProgressObject.Listener(){

                @Override
                public void progressChanged(int addedSteps, int currentStep, String text) {
                    TracerController.this.progress.addSteps(addedSteps, text);
                }
            };
            for (TracerProgressObject o : progresses) {
                o.addListener(l);
            }
        }
        this.error = null;
    }

    private boolean notifySessionStarting(Set<Map.Entry<TracerPackage, List<TracerProbe>>> items) {
        Iterator<Map.Entry<TracerPackage, List<TracerProbe>>> itemsI = items.iterator();
        HashMap notifiedItems = new HashMap();
        String notifiedName = null;
        try {
            while (itemsI.hasNext()) {
                Map.Entry<TracerPackage, List<TracerProbe>> item = itemsI.next();
                TracerPackage pkg = item.getKey();
                notifiedName = pkg.getName();
                List<TracerProbe> probes = item.getValue();
                TracerProbe[] probesArr = probes.toArray(new TracerProbe[probes.size()]);
                PackageStateHandler ph = pkg.getStateHandler();
                if (ph != null) {
                    ph.sessionStarting(probesArr, null);
                }
                ArrayList<TracerProbe> notifiedList = new ArrayList<TracerProbe>();
                notifiedItems.put(pkg, notifiedList);
                for (TracerProbe probe : probes) {
                    notifiedName = this.model.getDescriptor(probe).getProbeName();
                    ProbeStateHandler rh = probe.getStateHandler();
                    if (rh != null) {
                        rh.sessionStarting(null);
                    }
                    notifiedList.add(probe);
                }
            }
            return true;
        }
        catch (SessionInitializationException sie) {
            LOGGER.log(Level.INFO, "Package or probe failed to start Tracer session", sie);
            this.error = sie.getUserMessage();
            if (this.error == null) {
                this.error = notifiedName + " failed to start";
            }
            Set<Map.Entry<TracerPackage, List<TracerProbe>>> notifiedItemsE = notifiedItems.entrySet();
            this.notifySessionStopping(notifiedItemsE);
            this.setState(Integer.MIN_VALUE);
            this.notifySessionFinished(notifiedItemsE);
            return false;
        }
        catch (Throwable t) {
            LOGGER.log(Level.INFO, "Package or probe exception in sessionStarting", t);
            return true;
        }
    }

    private void notifySessionRunning(Set<Map.Entry<TracerPackage, List<TracerProbe>>> items) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> item : items) {
            List<TracerProbe> probes = item.getValue();
            TracerProbe[] probesArr = probes.toArray(new TracerProbe[probes.size()]);
            PackageStateHandler ph = item.getKey().getStateHandler();
            if (ph != null) {
                try {
                    ph.sessionRunning(probesArr, null);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Package exception in sessionRunning", t);
                }
            }
            for (TracerProbe probe : probes) {
                ProbeStateHandler rh = probe.getStateHandler();
                if (rh == null) continue;
                try {
                    rh.sessionRunning(null);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionRunning", t);
                }
            }
        }
    }

    private void notifySessionStopping(Set<Map.Entry<TracerPackage, List<TracerProbe>>> items) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> item : items) {
            List<TracerProbe> probes = item.getValue();
            TracerProbe[] probesArr = probes.toArray(new TracerProbe[probes.size()]);
            PackageStateHandler ph = item.getKey().getStateHandler();
            if (ph != null) {
                try {
                    ph.sessionStopping(probesArr, null);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Package exception in sessionStopping", t);
                }
            }
            for (TracerProbe probe : probes) {
                ProbeStateHandler rh = probe.getStateHandler();
                if (rh == null) continue;
                try {
                    rh.sessionStopping(null);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionStopping", t);
                }
            }
        }
    }

    private void notifySessionFinished(Set<Map.Entry<TracerPackage, List<TracerProbe>>> items) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> item : items) {
            List<TracerProbe> probes = item.getValue();
            TracerProbe[] probesArr = probes.toArray(new TracerProbe[probes.size()]);
            PackageStateHandler ph = item.getKey().getStateHandler();
            if (ph != null) {
                try {
                    ph.sessionFinished(probesArr, null);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Package exception in sessionFinished", t);
                }
            }
            for (TracerProbe probe : probes) {
                ProbeStateHandler rh = probe.getStateHandler();
                if (rh == null) continue;
                try {
                    rh.sessionFinished(null);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Probe exception in sessionFinished", t);
                }
            }
        }
    }

    private void notifyRefreshRateChanged(Set<Map.Entry<TracerPackage, List<TracerProbe>>> items) {
        for (Map.Entry<TracerPackage, List<TracerProbe>> item : items) {
            List<TracerProbe> probes = item.getValue();
            TracerProbe[] probesArr = probes.toArray(new TracerProbe[probes.size()]);
            PackageStateHandler ph = item.getKey().getStateHandler();
            if (ph != null) {
                try {
                    ph.refreshRateChanged(probesArr, null, -1);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Package exception in refreshRateChanged", t);
                }
            }
            for (TracerProbe probe : probes) {
                ProbeStateHandler rh = probe.getStateHandler();
                if (rh == null) continue;
                try {
                    rh.refreshRateChanged(null, -1);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, "Probe exception in refreshRateChanged", t);
                }
            }
        }
    }

    private synchronized RequestProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = new RequestProcessor("Tracer Processor for " + this.model.getSnapshot().toString());
        }
        return this.processor;
    }

    private void fetchData(final int sampleIndex) {
        final List<TracerProbe> probes = this.model.getDefinedProbes();
        if (probes.isEmpty()) {
            return;
        }
        final int itemsCount = this.model.getTimelineSupport().getItemsCount();
        this.getProcessor().post(new Runnable(){

            @Override
            public void run() {
                TracerController.this.fetchDataImpl(probes, itemsCount, sampleIndex);
            }
        });
    }

    private void fetchDataImpl(List<TracerProbe> probes, int itemsCount, int sampleIndex) {
        final long[] values = new long[itemsCount];
        int currentIndex = 0;
        final long timestamp = this.model.getTimestamp(sampleIndex);
        for (TracerProbe probe : probes) {
            long[] itemValues;
            try {
                itemValues = probe.getItemValues(sampleIndex);
            }
            catch (Throwable t) {
                itemValues = new long[probe.getItemsCount()];
                Arrays.fill(itemValues, Long.MAX_VALUE);
                LOGGER.log(Level.INFO, "Probe exception in getItemValues", t);
            }
            for (int i = 0; i < itemValues.length; ++i) {
                long value = itemValues[i];
                if (value < 0L) {
                    if (!this.wasNegativeValue) {
                        ProfilerDialogs.displayWarning((String)Bundle.Warning_NegativeValue());
                        LOGGER.info("Probe " + this.model.getDescriptor(probe).getProbeName() + " returned negative value: " + value);
                        this.wasNegativeValue = true;
                    }
                    value = 0L;
                }
                values[currentIndex++] = value;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerController.this.model.getTimelineSupport().addValues(timestamp, values);
            }
        });
    }

    void viewRemoved() {
        this.stopSession();
        this.setState(-1);
    }
}

