/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.OQLController;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.HeapFragmentWalkerUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;

public class HeapFragmentWalker {
    public static final int RETAINED_SIZES_UNSUPPORTED = -1;
    public static final int RETAINED_SIZES_UNKNOWN = 0;
    public static final int RETAINED_SIZES_CANCELLED = 1;
    public static final int RETAINED_SIZES_COMPUTING = 2;
    public static final int RETAINED_SIZES_COMPUTED = 3;
    private AnalysisController analysisController;
    private OQLController oqlController;
    private ClassesController classesController;
    private Heap heapFragment;
    private HeapFragmentWalkerUI walkerUI;
    private HeapWalker heapWalker;
    private InstancesController instancesController;
    private NavigationHistoryManager navigationHistoryManager;
    private SummaryController summaryController;
    private List<StateListener> stateListeners;
    private int retainedSizesStatus;

    public HeapFragmentWalker(Heap heapFragment, HeapWalker heapWalker) {
        this(heapFragment, heapWalker, false);
    }

    public HeapFragmentWalker(Heap heapFragment, HeapWalker heapWalker, boolean supportsRetainedSizes) {
        this.heapFragment = heapFragment;
        this.heapWalker = heapWalker;
        this.retainedSizesStatus = supportsRetainedSizes ? 0 : -1;
        this.summaryController = new SummaryController(this);
        this.classesController = new ClassesController(this);
        this.instancesController = new InstancesController(this);
        this.analysisController = new AnalysisController(this);
        this.navigationHistoryManager = new NavigationHistoryManager(this);
        this.oqlController = new OQLController(this);
    }

    public final synchronized int computeRetainedSizes(boolean masterAction) {
        if (this.retainedSizesStatus != -1 && this.retainedSizesStatus != 3) {
            if (!ProfilerDialogs.displayConfirmationDNSA((String)Bundle.HeapFragmentWalker_ComputeRetainedMsg(), (String)Bundle.HeapFragmentWalker_ComputeRetainedCaption(), null, (String)"HeapFragmentWalker.computeRetainedSizes", (boolean)false)) {
                this.changeState(1, masterAction);
            } else {
                this.changeState(2, masterAction);
                List classes = this.heapFragment.getAllClasses();
                for (JavaClass jclass : classes) {
                    List instances = jclass.getInstances();
                    if (instances.size() <= 0) continue;
                    Dialog progress = HeapFragmentWalker.showProgress(Bundle.HeapFragmentWalker_ComputingRetainedCaption(), Bundle.HeapFragmentWalker_ComputingRetainedMsg());
                    ((Instance)instances.get(0)).getRetainedSize();
                    if (progress == null) break;
                    progress.setVisible(false);
                    progress.dispose();
                    break;
                }
                this.changeState(3, masterAction);
            }
        }
        return this.retainedSizesStatus;
    }

    private static Dialog showProgress(String caption, String message) {
        final CountDownLatch latch = new CountDownLatch(1);
        final Dialog progress = HeapFragmentWalker.createProgressPanel(caption, message);
        progress.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    latch.countDown();
                }
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                progress.setVisible(true);
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return progress;
    }

    private static Dialog createProgressPanel(String caption, String message) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        panel.setBorder(new EmptyBorder(15, 15, 15, 15));
        panel.add((Component)new JLabel(message), "North");
        JProgressBar progress = new JProgressBar();
        progress.setIndeterminate(true);
        panel.add((Component)progress, "South");
        Dimension ps = panel.getPreferredSize();
        ps.setSize(Math.max(ps.getWidth(), 350.0), Math.max(ps.getHeight(), 50.0));
        panel.setPreferredSize(ps);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)panel, caption, true, new Object[0], DialogDescriptor.CANCEL_OPTION, 1, null, null));
        return dialog;
    }

    public final synchronized int getRetainedSizesStatus() {
        return this.retainedSizesStatus;
    }

    public final void addStateListener(StateListener listener) {
        if (this.stateListeners == null) {
            this.stateListeners = new ArrayList<StateListener>();
        }
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    public final void removeStateListener(StateListener listener) {
        if (this.stateListeners == null || !this.stateListeners.contains(listener)) {
            return;
        }
        this.stateListeners.remove(listener);
        if (this.stateListeners.size() == 0) {
            this.stateListeners = null;
        }
    }

    private void changeState(int newState, final boolean masterChange) {
        this.retainedSizesStatus = newState;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HeapFragmentWalker.this.stateListeners == null) {
                    return;
                }
                StateEvent e = new StateEvent(HeapFragmentWalker.this.retainedSizesStatus, masterChange);
                for (StateListener listener : HeapFragmentWalker.this.stateListeners) {
                    listener.stateChanged(e);
                }
            }
        });
    }

    public AbstractTopLevelController getActiveController() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return null;
        }
        if (ui.isSummaryViewActive()) {
            return this.summaryController;
        }
        if (ui.isClassesViewActive()) {
            return this.classesController;
        }
        if (ui.isInstancesViewActive()) {
            return this.instancesController;
        }
        if (ui.isAnalysisViewActive()) {
            return this.analysisController;
        }
        if (ui.isOQLViewActive()) {
            return this.oqlController;
        }
        return null;
    }

    public OQLController getOQLController() {
        return this.oqlController;
    }

    public AnalysisController getAnalysisController() {
        return this.analysisController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public File getHeapDumpFile() {
        return this.heapWalker.getHeapDumpFile();
    }

    public Lookup.Provider getHeapDumpProject() {
        return this.heapWalker.getHeapDumpProject();
    }

    public Heap getHeapFragment() {
        return this.heapFragment;
    }

    public InstancesController getInstancesController() {
        return this.instancesController;
    }

    public boolean isNavigationBackAvailable() {
        return this.navigationHistoryManager.isNavigationBackAvailable();
    }

    public boolean isNavigationForwardAvailable() {
        return this.navigationHistoryManager.isNavigationForwardAvailable();
    }

    public JPanel getPanel() {
        if (this.walkerUI == null) {
            this.walkerUI = new HeapFragmentWalkerUI(this);
        }
        return this.walkerUI;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public long getTotalLiveBytes() {
        return this.heapFragment.getSummary().getTotalLiveBytes();
    }

    public long getTotalLiveInstances() {
        return this.heapFragment.getSummary().getTotalLiveInstances();
    }

    public void createNavigationHistoryPoint() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return;
        }
        this.navigationHistoryManager.createNavigationHistoryPoint();
        ui.updateNavigationActions();
    }

    public void navigateBack() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return;
        }
        this.navigationHistoryManager.navigateBack();
        ui.updateNavigationActions();
    }

    public void navigateForward() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return;
        }
        this.navigationHistoryManager.navigateForward();
        ui.updateNavigationActions();
    }

    public void showInstancesForClass(JavaClass jClass) {
        this.switchToInstancesView();
        this.instancesController.setClass(jClass);
    }

    public void switchToOQLView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showOQLView();
    }

    public void switchToAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showAnalysisView();
    }

    public void switchToClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showClassesView();
    }

    public void switchToHistoryOQLView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryOQLView();
    }

    public void switchToHistoryAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryAnalysisView();
    }

    public void switchToHistoryClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryClassesView();
    }

    public void switchToHistoryInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryInstancesView();
    }

    public void switchToHistorySummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistorySummaryView();
    }

    public void switchToInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showInstancesView();
    }

    public void switchToSummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showSummaryView();
    }

    NavigationHistoryManager.NavigationHistoryCapable getNavigationHistorySource() {
        AbstractTopLevelController activeController = this.getActiveController();
        if (activeController instanceof NavigationHistoryManager.NavigationHistoryCapable) {
            return (NavigationHistoryManager.NavigationHistoryCapable)((Object)activeController);
        }
        return null;
    }

    public static final class StateEvent {
        private int retainedSizesStatus;
        private boolean masterChange;

        StateEvent(int retainedSizesStatus) {
            this(retainedSizesStatus, false);
        }

        StateEvent(int retainedSizesStatus, boolean masterChange) {
            this.retainedSizesStatus = retainedSizesStatus;
            this.masterChange = masterChange;
        }

        public int getRetainedSizesStatus() {
            return this.retainedSizesStatus;
        }

        public boolean isMasterChange() {
            return this.masterChange;
        }
    }

    public static interface StateListener {
        public void stateChanged(StateEvent var1);
    }
}

