/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.SearchScopeDefinitionProvider;
import org.openide.util.Lookup;

public class SearchScopeList {
    private List<SearchScopeDefinition> scopes = null;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private ProxyChangeListener proxyChangeListener = new ProxyChangeListener();

    public SearchScopeList(SearchScopeDefinition ... extraSearchScopes) {
        this.scopes = this.createScopeList(extraSearchScopes);
    }

    public void clean() {
        for (SearchScopeDefinition ssd : this.scopes) {
            ssd.removeChangeListener(this.proxyChangeListener);
            ssd.clean();
        }
        this.scopes.clear();
        this.changeListeners.clear();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private List<SearchScopeDefinition> createScopeList(SearchScopeDefinition ... extraSearchScopes) {
        this.scopes = new ArrayList<SearchScopeDefinition>(6);
        Collection providers = Lookup.getDefault().lookupAll(SearchScopeDefinitionProvider.class);
        for (SearchScopeDefinitionProvider provider : providers) {
            this.scopes.addAll(provider.createSearchScopeDefinitions());
        }
        this.scopes.addAll(Arrays.asList(extraSearchScopes));
        Collections.sort(this.scopes, new ScopePriorityComparator());
        for (SearchScopeDefinition scope : this.scopes) {
            scope.addChangeListener(this.proxyChangeListener);
        }
        return this.scopes;
    }

    public List<SearchScopeDefinition> getSeachScopeDefinitions() {
        return this.scopes;
    }

    private class ProxyChangeListener
    implements ChangeListener {
        private ProxyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (ChangeListener changeListener : SearchScopeList.this.changeListeners) {
                changeListener.stateChanged(e);
            }
        }
    }

    private class ScopePriorityComparator
    implements Comparator<SearchScopeDefinition> {
        private ScopePriorityComparator() {
        }

        @Override
        public int compare(SearchScopeDefinition o1, SearchScopeDefinition o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

