/*************************************************************************
vStrip by [maven] (maven@maven.de)
dvd2avi_plugin.c: generates (hopefully) dvd2avi 1.76 compatible project-files

DVD2AVI by Chia-chen Kuo
  
*************************************************************************/

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include "s_types.h"
#include "vstrip.h"
#include "dvd2avi_plugin.h"

bool dvd2avi_process(byte *data, tp_vs_streaminfo const si, void *user_data)
{
	t_dvd2avi* d2v = (t_dvd2avi *)user_data;

	if (d2v && (!si || (si->out_flags && (si->out_flags->flags & vso_ONLY_KEEP_GOPS) == 0 && (si->out_flags->flags & vso_DEMUX) == 0 &&
		(d2v->last_idx != si->idx || d2v->last_lba != si->lba))))
	{
		dword i, nbytes;

		memmove(d2v->buffer, d2v->buffer + d2v->buffer_start, d2v->buffer_len); // move the old-bit up front
		nbytes = d2v->buffer_len;
		if (si)
		{
			memmove(d2v->buffer + d2v->buffer_len, data, si->length); // move the new bit behind
			d2v->buffer_start = d2v->buffer_len;
			d2v->buffer_len = si->length;
		}
		
		if (nbytes > 0)
		{
			if (d2v->framerate == 0 && *((dword *)data) == be2me_32(SEQUENCE_HEADER_CODE))
			{ // parse sequence header for resolution & framerate
				dword wh = be2me_32(*((dword *)(data + 4))) >> 8;

				d2v->width = (wh >> 12) & 0xfff;
				d2v->height = wh & 0xfff;

				switch (data[7] & 0x0f)
				{
					case 1:
						d2v->framerate = 23976;
					break;
					case 2:
						d2v->framerate = 24000;
					break;
					case 3:
						d2v->framerate = 25000;
					break;
					case 4:
						d2v->framerate = 29970;
					break;
					case 5:
						d2v->framerate = 30000;
					break;
					case 6:
						d2v->framerate = 50000;
					break;
					case 7:
						d2v->framerate = 59940;
					break;
					case 8:
						d2v->framerate = 60000;
					break;
				}
			}

			i = 0;
			while (i < nbytes)
			{
				bool found_pic = FALSE;

				// now search for picture-header
				for (; i < nbytes; i++)
					if (*((dword *)(d2v->buffer + i)) == be2me_32(PICTURE_START_CODE))
					{
						found_pic = TRUE;
						d2v->current.type = (d2v->buffer[i + 5] >> 3) & 7;
						if (d2v->found_iframe && !d2v->skipped_bframe && d2v->current.type != PICTURE_B_TYPE)
							d2v->skipped_bframe = TRUE; // we've skipped the initial B-Frames
						if (d2v->current.type == PICTURE_I_TYPE)
						{
							int ofs = d2v->last_idx + i + 6; // where are we next reading from?

							d2v->current.lba = d2v->buffer_lba - 1;
							while ((ofs & 3) != 0)
								ofs++; // this is the end of the current readptr
							ofs += 4; // add the next pointer
							if (ofs > fio_SECTOR_SIZE)
								d2v->current.lba++; // if we took info from the next lba, increase it
							d2v->current.file_idx = d2v->buffer_file_idx;
							d2v->found_iframe = TRUE;
						}
						else if (d2v->found_iframe && !d2v->skipped_bframe && d2v->current.type == PICTURE_B_TYPE)
							found_pic = FALSE; // ignore the B-Frames after the 1st I-Frame 
						i++;
						break;
					}

				if (found_pic)
				{
					// search for picture_coding (and cancel on the next picture-header) extension
					for (; i < nbytes + d2v->buffer_len; i++)
					{
						if (*((dword *)(d2v->buffer + i)) == be2me_32(PICTURE_EXTENSION_START_CODE) || *((dword *)(d2v->buffer + i)) == be2me_32(PICTURE_START_CODE))
						{
							if (*((dword *)(d2v->buffer + i)) == be2me_32(PICTURE_EXTENSION_START_CODE) && (d2v->buffer[i + 4] >> 4) == PICTURE_CODING_EXTENSION_ID)
							{
	//							fprintf(d2v->file, "picture_coding_ext: %i + %i\n", si->lba, si->idx);
								d2v->picture_structure = d2v->buffer[i + 6] & 3;
								d2v->top_field_first = (d2v->buffer[i + 7] >> 7) & 1;
								d2v->repeat_first_field = (d2v->buffer[i + 7] >> 1) & 1;
								d2v->current.trf = (d2v->top_field_first << 1) + d2v->repeat_first_field;
								found_pic = FALSE; // so for the next loop things will be ok
								i++;
								break;
							}
						}
					}
					if (d2v->found_iframe)
					{
						if (d2v->picture_structure == PICTURE_FRAME_PICTURE && d2v->second_field)
							d2v->second_field = 0;

						if (d2v->current.type != PICTURE_B_TYPE)
						{
							d2v->forward = d2v->backward;
							d2v->backward = d2v->current;
						}
						if ((d2v->frame_number && d2v->picture_structure == PICTURE_FRAME_PICTURE) || d2v->second_field)
						{
							if (d2v->current.type == PICTURE_B_TYPE)
							{
								if (d2v->num_iframes > 0 && d2v->gops[d2v->num_iframes - 1])
								{
									if (d2v->gops[d2v->num_iframes - 1]->num >= d2v->max_inter)
									{
										d2v->max_inter += 2;
										d2v->gops[d2v->num_iframes - 1] = realloc(d2v->gops[d2v->num_iframes - 1], sizeof *d2v->gops[d2v->num_iframes - 1] + (d2v->max_inter * sizeof *d2v->gops[d2v->num_iframes - 1]->flags));
									}
									d2v->gops[d2v->num_iframes - 1]->flags[d2v->gops[d2v->num_iframes - 1]->num] = d2v->current.trf;
									d2v->gops[d2v->num_iframes - 1]->num++;
								}
							}
							else
							{
								switch (d2v->forward.type)
								{
									case PICTURE_I_TYPE:
										if (d2v->num_iframes >= d2v->max_iframes)
										{
											d2v->max_iframes *= 2;
											d2v->gops = realloc(d2v->gops, d2v->max_iframes * sizeof *d2v->gops);
										}
										d2v->gops[d2v->num_iframes] = malloc(sizeof *d2v->gops[d2v->num_iframes] + (d2v->max_inter * sizeof *d2v->gops[d2v->num_iframes]->flags));
										d2v->gops[d2v->num_iframes]->file_idx = d2v->forward.file_idx;

										d2v->gops[d2v->num_iframes]->num = 0;

										d2v->gops[d2v->num_iframes]->lba = d2v->forward.lba;
										d2v->num_iframes++;
									case PICTURE_P_TYPE:
										if (d2v->num_iframes > 0 && d2v->gops[d2v->num_iframes - 1])
										{
											if (d2v->gops[d2v->num_iframes - 1]->num >= d2v->max_inter)
											{
												d2v->max_inter += 2;
												d2v->gops[d2v->num_iframes - 1] = realloc(d2v->gops[d2v->num_iframes - 1], sizeof *d2v->gops[d2v->num_iframes - 1] + (d2v->max_inter * sizeof *d2v->gops[d2v->num_iframes - 1]->flags));
											}
											d2v->gops[d2v->num_iframes - 1]->flags[d2v->gops[d2v->num_iframes - 1]->num] = d2v->forward.trf;
											d2v->gops[d2v->num_iframes - 1]->num++;
										}
									break;
								}
							}
						}
						if (d2v->picture_structure != PICTURE_FRAME_PICTURE)
							d2v->second_field = !d2v->second_field;

						if (!d2v->second_field)
							d2v->frame_number++;
					}
				}
			}
		}
		if (si)
		{
			d2v->last_idx = si->idx;
			d2v->last_lba = si->lba;
			d2v->buffer_file_idx = si->out_file_num;
			d2v->buffer_lba = si->out_lba;
		}
	}
	return TRUE;
}

dword dvd2avi_get_num_lba(const char* fname)
{
	int fp;
	dword lba = 0;
	
	fp = _open(fname, _O_BINARY | _O_RDONLY); // check size
	if (fp != -1)
	{
		__int64 fposition = _filelengthi64(fp);
		
		lba = (dword)(fposition / fio_SECTOR_SIZE);
		_close(fp);
	}
	return lba;
}

t_dvd2avi* dvd2avi_init(void)
{
	t_dvd2avi* d2v = malloc(sizeof *d2v);

	d2v->last_idx = -1;
	d2v->last_lba = -1;
	d2v->framerate = 0;
	d2v->found_iframe = d2v->skipped_bframe = FALSE;
	d2v->frame_number = d2v->second_field = 0;
	d2v->max_inter = 8;
	d2v->max_iframes = 32;
	d2v->gops = malloc(d2v->max_iframes * sizeof *d2v->gops);
	d2v->num_iframes = 0;
	d2v->buffer_start = 0;
	d2v->buffer_len = 0;
	return d2v;
}

void dvd2avi_write_free(const char* vobname, t_dvd2avi* d2v)
{
	if (vobname && *vobname && d2v && d2v->found_iframe && d2v->framerate > 0)
	{
		FILE *f;
		char pre[256], ext[256], buf[256];
		char *ptr;

		// finish the last buffer
		dvd2avi_process(NULL, NULL, d2v);
		strcpy(ext, ".");
		strcpy(pre, vobname);
		ptr = strrchr(pre, '.');
		if (ptr)
		{
			strcpy(ext, ptr);
			*ptr = 0;
		}

		strcpy(buf, pre);
		strcat(buf, ".d2v");
				
		f = fopen(buf, "wt");

		if (f)
		{
			int i;
			int num_file = 0;
			dword last_lba = 0;

			for (i = 0; i < d2v->num_iframes; i++)
				num_file = max(num_file, d2v->gops[i]->file_idx);

			// header + filelist
			fprintf(f, "DVD2AVIProjectFile\n%d\n", max(1, num_file));
			if (num_file == 0)
			{
				fprintf(f, "%d %s\n", strlen(vobname), vobname); // no splitting
				last_lba = dvd2avi_get_num_lba(vobname);
			}
			else
			{
				int last = 0;

				for (i = 0; i < d2v->num_iframes; i++)
				{
					if (last != d2v->gops[i]->file_idx)
					{
						last = d2v->gops[i]->file_idx;
						sprintf(buf, "%s_%u%s", pre, last, ext);
						fprintf(f, "%d %s\n", strlen(buf), buf);
					}
					if (i == d2v->num_iframes - 1)
						last_lba = dvd2avi_get_num_lba(buf); // we keep the high lba of the last file
				}

			}

			fprintf(f, "\nStream_Type=%d,0,0\n", 1); // system stream is all we can do
			fprintf(f, "iDCT_Algorithm=%d\n", 1); // mmx
			fprintf(f, "YUVRGB_Scale=%d\n", 1); // use RGB-scale
			fprintf(f, "Luminance=128,0\n");
			fprintf(f, "Picture_Size=0,0,0,0,0,0\n");

			fprintf(f, "Field_Operation=%d\n", 0);
			fprintf(f, "Frame_Rate=%d\n", d2v->framerate);
			fprintf(f, "Location=%d,%X,%d,%X\n", 0, 0, max(1, num_file) - 1, last_lba);

			for (i = 0; i < d2v->num_iframes; i++)
			{
				int j;

				// fix up LBA
				if (d2v->gops[i]->lba < 0)
				{
					if (num_file <= 1 || d2v->gops[i]->file_idx <= 1)
						d2v->gops[i]->lba = 0;
					else
					{
						d2v->gops[i]->file_idx--;
						sprintf(buf, "%s_%u%s", pre, d2v->gops[i]->file_idx, ext);
						d2v->gops[i]->lba = dvd2avi_get_num_lba(buf) - 1;
					}
				}

				fprintf(f, "\n7 %d %X", max(1, d2v->gops[i]->file_idx) - 1, d2v->gops[i]->lba);
				for (j = 0; j < d2v->gops[i]->num; j++)
					fprintf(f, " %d", d2v->gops[i]->flags[j]);
			}
			fprintf(f, " 9\n\nFINISHED");
			fclose(f);
		}
	}
	if (d2v)
	{
		int i;

		for (i = 0; i < d2v->num_iframes; i++)
			free(d2v->gops[i]);
		free(d2v->gops);
		free(d2v);
	}
}