/*

Ultima Offline eXperiment III (UOX3)
UO Server Emulation Program

Copyright 1997, 98 by Marcus Rating (Cironian)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 * In addition to that license, if you are running this program or modified  *
 * versions of it on a public system you HAVE TO make the complete source of *
 * the version used by you available or provide people with a location to    *
 * download it.                                                              *

You can contact the author by sending email to <cironian@stratics.com>.

*/

#include "uox3.h"
#include "srvkey.h"
#include "debug.h"

#define DBGFILE "uox3.cpp"

int tempint[MAXCLIENT];

// EviLDeD  -  Instance of the CWorldMain Class
// December 23, 1998
CWorldMain cwmWorldState;
// EviLDeD  -  End

void dostreamcode(int s)
{
 int actByte = 0, bitByte = 0, nrBits;
 unsigned int value;

 for(int tempPos = 0; tempPos <= boutlength[s]; tempPos++)
 {
  if(tempPos == boutlength[s]) value = keyid[256];
  else value = keyid[(unsigned char)outbuffer[s][tempPos]];
  nrBits = value & 0xF;
  value >>= 4;
  while(nrBits)
  {
   xoutbuffer[actByte] = (char)(((unsigned int)xoutbuffer[actByte] << 1) + ((value >> (nrBits - 1)) & 0x1));
   nrBits--;
   bitByte++;
   if(bitByte == 8)
   {
    bitByte = 0;
    actByte++;
   }
  }
 }
 if(bitByte)
 {
  while(bitByte < 8)
  {
   xoutbuffer[actByte] <<= 1;
   bitByte++;
  }
  actByte++;
 }
 send(client[s], xoutbuffer, actByte, 0);
}

#ifdef __NT__
///////////////////

HANDLE hco;
CONSOLE_SCREEN_BUFFER_INFO csbi;

void gotoxy(int x, int y)
{
 COORD xy;

 xy.X=x;
 xy.Y=y;
 SetConsoleCursorPosition(hco, xy);
}

void clearscreen()
{
#ifdef __MINGW32__   // my compiler doesn't like long value
 unsigned int y;
#else
 unsigned long int y;
#endif
 COORD xy;

 xy.X=0;
 xy.Y=0;
 FillConsoleOutputCharacter(hco, ' ', 80*25, xy, &y);
 SetConsoleCursorPosition(hco, xy);
}

void constart()
{
 hco=GetStdHandle(STD_OUTPUT_HANDLE);
 GetConsoleScreenBufferInfo(hco, &csbi);
}

///////////////////
#endif

#ifndef __NT__
void closesocket(int s)
{
 shutdown(s, 2);
 close(s);
}
#endif

char crypt (int s, char c)
{
 unsigned int mask[2];
 mask[0] = cryptmask[s][0];
 mask[1] = cryptmask[s][1];

 cryptmask[s][1] =
        (MASTERKEY1 >> ((5 * mask[1] * mask[1]) & 0xff))
        + (mask[1] * MASTERKEY1)
        + (mask[0] * mask[0] * MASTERKEY2)
        + MASTERKEY3;
 cryptmask[s][0] =
        (MASTERKEY4 >> ((3 * mask[0] * mask[0]) & 0xff))
        + (mask[0] * MASTERKEY4)
        - (cryptmask[s][1] * cryptmask[s][1] * MASTERKEY5)
        + MASTERKEY6;

 return c ^ (char)mask[0];

}

int xrecv(int s) // Better receive routine than the one currently used; not intergrated yet
{
 int count, i;
#ifdef DEBUG
 int x, y, j;
 char st[10], txt[17];
#endif

 count=recv(client[s], &buffer[s][binlength[s]], MAXBUFFER-binlength[s], 0);
#ifdef DEBUG
 x=0;
#endif
 for (i=binlength[s];i<binlength[s]+count;i++)
 {
  buffer[s][i]=crypt(s, buffer[s][i]);
#ifdef DEBUG
  y=x%16;
  if ((y)==0)
  {
   sprintf(st, "%x", x);
   printf("C%i [",s);
   for (j=4-strlen(st);j>0;j--) printf("0");
   printf("%s] ", st);
  }
  sprintf(st, "%X", buffer[s][i]);
  if (strlen(st)==2) printf("%s ", st); else printf("0%s ", st);
  if (!(iscntrl(buffer[s][i]))) txt[y]=buffer[s][i]; else txt[y]='.';
  if (y==15)
  {
   txt[16]=0;
   printf("%s\n", txt);
  }
  x++;
#endif
 }
 binlength[s]+=count;
#ifdef DEBUG
 if ((y)!=15)
 {
  txt[y+1]=0;
  for (j=15-y;j>0;j--) printf("   ");
  printf("%s\n",txt);
 }
#endif
 return count;
}

void processed(int s, int i) // To be used later together with xrecv
{
 memcpy(buffer[s], &buffer[s][i], binlength[s]-i);
 binlength[s]-=i;
 if (binlength[s]<0) binlength[s]=0;
}

void flushbuffer(int s) // Sends buffered data at once
{
 if (boutlength[s]>0)
 {
//  printf("S = %i, bout = %i, cc = %i\n", s, boutlength[s], cryptclient[s]);
  if (cryptclient[s])
  {
   dostreamcode(s);
  }
  else
  {
   send(client[s], outbuffer[s], boutlength[s], 0);
  }
  boutlength[s]=0;
//  printf("Done\n");
 }
}

void clearbuffers() // Sends ALL buffered data
{
 int i;

 for (i=0;i<now;i++)
 {
  flushbuffer(i);
 }
}

void xsend(int s, void *point, int length, int test) // Buffering send function
{
// printf("XSEND [%i] with %i -> ", s, length);
 test=test;
 if (boutlength[s]+length>MAXBUFFER) flushbuffer(s);
 memcpy(&outbuffer[s][boutlength[s]], point, length);
 boutlength[s]+=length;
// printf("%i\n", boutlength[s]);
}

int str2num(char *s) // Convert string to integer
{
 unsigned int i;
 int n=0;
 int neg=0;
 unsigned int length=strlen(s);
 for(i=0;i<length;i++)
 {
  if (s[i]=='-') neg=1;
  n*=10; // Multiply by 10
  if (isdigit(s[i]))
  n=n+(s[i])-48; // Convert char to number from 0 to 9
 }
 if (neg) n=-n;
 return n;
}

int hstr2num(char *s) // Convert hex string to integer
{
 unsigned int i;
 int n=0;
 for (i=0;i<strlen(s);i++)
 {
  n*=16;
  if (isdigit(s[i]))
      n=n+(s[i])-48; // Convert char to number from 0 to 9
  if ((s[i]>=65) && (s[i]<=70)) // Uppercase A-F
      n=n+(s[i])-65+10;
  if ((s[i]>=97) && (s[i]<=102)) // Lowercase A-F
      n=n+(s[i])-97+10;
 }
 if (s[0]=='-') n=-n;
 return n;
}

void readscript () // Read a line from the opened script file
{
 int i, valid=0;
 char c;
 temp[0]=0;
 while(!valid)
 {
  i=0;
  if (feof(scpfile)) return;
  c=(char)fgetc(scpfile);
  while (c!=10)
  {
   if (c!=13)// && c!=0)
   {
    temp[i]=c;
    i++;
   }
   if (feof(scpfile)) return;
   c=(char)fgetc(scpfile);
  }
  temp[i]=0;
  valid=1;
  if (temp[0]=='/' && temp[1]=='/') valid=0;
  if (temp[0]=='{') valid=0;
  if (temp[0]==0) valid=0;
 }
}

void openscript (char *name) // Open script file
{
 scpfile=fopen(name,"r");
 if (scpfile==NULL)
 {
   printf("ERROR: %s not found...\n",name);
   error=1;
   keeprun=0;
   return;
 }
 openings++;
// printf("Openings: %i\n",openings);
}

void closescript ()
{
 fclose(scpfile);
 openings--;
}

void read1 () // Read script line without splitting parameters
{
 readscript();
 sprintf(script1, "%s", temp);
}

void read2 () // Read line from script
{
 int i;
 readscript();
 i=0;
 script1[0]=0;
 script2[0]=0;
 while(temp[i]!=0 && temp[i]!=' ')
 {
  i++;
 }
 strncpy(script1, temp, i);
 script1[i]=0;
 if (script1[0]!='}' && temp[i]!=0) strcpy(script2, temp+i+1);
 return;
}

void psplit (char *pass0) // Split login password into UOX password and UO password
{
 int i;
 i=0;
 pass1[0]=0;
 while (pass0[i]!='/' && pass0[i]!=0) i++;
 strncpy(pass1,pass0,i);
 pass1[i]=0;
 if (pass0[i]!=0) strcpy(pass2, pass0+i+1);
}

int inrange1 (int a, int b) // Are players from sockets a and b in visual range (Obsolete)
{
 int c=1;
 int xa, xb, ya, yb, dx, dy;
 if (a==b) c=0;
 xa=chars[currchar[a]].x;
 ya=chars[currchar[a]].y;
 xb=chars[currchar[b]].x;
 yb=chars[currchar[b]].y;
 dx=abs(xa-xb);
 dy=abs(ya-yb);
 if (dx>VISRANGE) c=0;
 if (dy>VISRANGE) c=0;
 return c;
}

int inrange1p (int a, int b) // Are characters a and b in visual range
{
 int c=1;
 int xa, xb, ya, yb, dx, dy;

 xa=chars[a].x;
 ya=chars[a].y;
 xb=chars[b].x;
 yb=chars[b].y;
 dx=abs(xa-xb);
 dy=abs(ya-yb);
 if (dx>VISRANGE) c=0;
 if (dy>VISRANGE) c=0;
 return c;
}

unsigned int chardist (int a, int b) // Distance between characters a and b
{
 int c=1;
 int xa, xb, ya, yb, dx, dy;

 xa=chars[a].x;
 ya=chars[a].y;
 xb=chars[b].x;
 yb=chars[b].y;
 dx=abs(xa-xb);
 dy=abs(ya-yb);
#ifdef __NT__
 c=(int)(sqrt(dx*dx+dy*dy));
#else
 c=(int)(hypot(dx, dy));
#endif
 return c;
}

int inrange2 (int s, int i) // Is item i in visual range for player on socket s
{
 int c=1;
 int xa, xb, ya, yb, dx, dy;
 int vr=VISRANGE;

 if ((items[i].id1==0x40)&&(items[i].id2>=0x7C)&&(items[i].id2<=0x7F)) vr=BUILDRANGE;
 xa=chars[currchar[s]].x;
 ya=chars[currchar[s]].y;
 xb=items[i].x;
 yb=items[i].y;
 dx=abs(xa-xb);
 dy=abs(ya-yb);
 if (dx>vr) c=0;
 if (dy>vr) c=0;
 return c;
}

int online(int c) // Is the player owning the character c online
{
 int i, x=0;

 for (i=0;i<now;i++) if ((currchar[i]==c)&&(perm[i])) x=1;
 return x;
}

void makeplace(int s, int i) // Decode a teleport location number into X/Y/Z
{
 int x=0, y=0, z=0;

 openscript("location.scp");
 sprintf(temp, "LOCATION %i", i);
 if (location_script.find(temp))
 {
  do
  {
   read2();
   if (!(strcmp(script1,"X")))
   {
    x=str2num(script2);
   }
   if (!(strcmp(script1,"Y")))
   {
    y=str2num(script2);
   }
   if (!(strcmp(script1,"Z")))
   {
    z=str2num(script2);
   }
  }
  while (strcmp(script1,"}"));
 }
 addx[s]=x;
 addy[s]=y;
 addz[s]=z;
 closescript();
}

int bestskill(int p) // Which skill is the highest for character p
{
 int i,a=0,b=0;

 for (i=0;i<TRUESKILLS;i++) if (chars[p].baseskill[i]>b)
 {
  a=i;
  b=chars[p].baseskill[i];
 }
 return a;
}

void loadcustomtitle() // for custom titles
{ 
 int titlecount=0;
 char sect[512]; 

 openscript("titles.scp");
 sprintf(sect,"SKILL");
 if(!titles_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   sprintf(title[titlecount].skill,"%s", script1);
   titlecount++;
  }
 }
 while (script1[0]!='}');
 closescript();
 script1[0]=0;
 titlecount=0;
 openscript("titles.scp");
 sprintf(sect,"PROWESS");
 if(!titles_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   sprintf(title[titlecount].prowess,"%s", script1);
   titlecount++;
  }
 }
 while (script1[0]!='}');
 closescript();
 script1[0]=0;
 titlecount=0;
 openscript("titles.scp");
 sprintf(sect,"FAME");
 if(!titles_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   sprintf(title[titlecount].fame,"%s", script1);
   if (titlecount==23)
   {
    *(title[titlecount].fame)='\0'; // was sprintf(title[titlecount].fame,"");
    sprintf(title[++titlecount].fame,"%s", script1);
   }
   titlecount++;
  }
 }
 while (script1[0]!='}');
 closescript();
}

char *title1(int p) // Paperdoll title for character p (1)
{
 int titlenum;
 int x=chars[p].baseskill[bestskill(p)];

 titlenum=0;
 if (x>=300) titlenum=1;
 if (x>=410) titlenum=2;
 if (x>=510) titlenum=3;
 if (x>=610) titlenum=4;
 if (x>=720) titlenum=5;
 if (x>=820) titlenum=6;
 if (x>=920) titlenum=7;
 if (x>=1000) titlenum=8;

 sprintf(prowesstitle,"%s",title[titlenum].prowess);
 return prowesstitle;
}

char *title2(int p) // Paperdoll title for character p (2)
{
   int titlenum=0;
   int x=bestskill(p);
   titlenum=x+1;
   sprintf(skilltitle,"%s",title[titlenum].skill);
   return skilltitle;
}

char *title3(int p) // Paperdoll title for character p (3)
{
 char thetitle[50];
 int titlenum=0;
 int k;
 unsigned int f;
  
 k=chars[p].karma;
 f=chars[p].fame;
 *thetitle='\0'; // was sprintf(thetitle,"");

 if (k>=10000)
 {
  titlenum=3;
  if (f>=1250) titlenum=2;
  if (f>=2500) titlenum=1;
  if (f>=5000) titlenum=0;
 }
 else if ((5000<=k)&&(k<9999))
 {
  titlenum=7;
  if (f>=1250) titlenum=6;
  if (f>=2500) titlenum=5;
  if (f>=5000) titlenum=4;
 }
 else if ((2500<=k)&&(k<5000))
 {
  titlenum=11;
  if (f>=1250) titlenum=10;
  if (f>=2500) titlenum=9;
  if (f>=5000) titlenum=8;
 }
 else if ((1250<=k)&&(k<2500))
 {
  titlenum=15;
  if (f>=1250) titlenum=14;
  if (f>=2500) titlenum=13;
  if (f>=5000) titlenum=12;
 }
 else if ((625<=k)&&(k<1250))
 {
  titlenum=19;
  if (f>=500) titlenum=18;
  if (f>=1000) titlenum=17;
  if (f>=5000) titlenum=16;
 }
 else if ((-625<k)&&(k<625))
 {
  titlenum=23;
  if (f>=1250) titlenum=22;
  if (f>=2500) titlenum=21;
  if (f>=5000) titlenum=20;
 }
 else if ((-1250<k)&&(k<=-625))
 {
  titlenum=24;
  if (f>=1250) titlenum=25;
  if (f>=2500) titlenum=26;
  if (f>=5000) titlenum=27;
  if (f>=10000) titlenum=28;
 }
 else if ((-2500<k)&&(k<=-1250))
 {
  titlenum=29;
  if (f>=1250) titlenum=30;
  if (f>=2500) titlenum=31;
  if (f>=5000) titlenum=32;
 }
 else if ((-5000<k)&&(k<=-2500))
 {
  titlenum=33;
  if (f>=1250) titlenum=34;
  if (f>=2500) titlenum=35;
  if (f>=5000) titlenum=36;
  if (f>=10000) titlenum=37;
 }
 else if ((-10000<k)&&(k<=-5000))
 {
  titlenum=38;
  if (f>=1250) titlenum=39;
  if (f>=2500) titlenum=40;
  if (f>=5000) titlenum=41;
 }
 else if (k<=-10000)
 {
  titlenum=42;
  if (f>=1250) titlenum=43;
  if (f>=2500) titlenum=44;
  if (f>=5000) titlenum=45;
 }
 sprintf(thetitle,"%s ",title[titlenum].fame);
 if (titlenum==24) *thetitle='\0'; // was sprintf(thetitle,"");
 if (f>=10000)
 {
  if (chars[p].id2==0x91) sprintf(fametitle,"The %sLady ",thetitle);
  else sprintf(fametitle,"The %sLord ",thetitle);
 }
 else
 {
  if (!(strcmp(thetitle," ")==0)) sprintf(fametitle,"The %s",thetitle);
  else *fametitle='\0'; // was sprintf(fametitle,"");
 }
 return fametitle;
}

int memcharfree()
{
int i,k;
k=-1;

if (cmemcheck!=-1)
   {
   k=freecharmem[cmemcheck];
   cmemcheck--;
   }

if (k==-1)
 {
 k=charcount;
 if (cmemover==1)
  {
  cmemover=0;
  cmemcheck++;
  for (i=0;i<charcount;i++)
   {
   if (cmemcheck==300)
    {
    cmemover=1; 
    break;
    }
   if (chars[i].free==1)
    {
    freecharmem[cmemcheck]=i;
    cmemcheck++;
    }
   }
  }
 }
return k;
}

void gcollect () // Remove items which were in deleted containers
{
int a,b,c,d,x,i,j, removed, rtotal=0;
int cachecnt=0, idelete;
int contcache[MAXITEMS];  // - containter cache until pointer arrays are installed

do
 {
 removed=0;
 for (i=0;i<itemcount;i++)
  {
  if (items[i].free==0)
   {
   idelete=0;
   a=items[i].cont1;
   b=items[i].cont2;
   c=items[i].cont3;
   d=items[i].cont4;
   if (!((a==255)&&(b==255)&(c=255)&&(d==255)))
    {
    idelete=1;
    if (a<0x40) // container is a character...verify the character??
     {
     for (j=0;j<charcount;j++)
      if ((chars[j].ser1==a)&&(chars[j].ser2==b)&&(chars[j].ser3==c)&&(chars[j].ser4==d))
       {
       if (chars[j].free==0)
        {
        idelete=0;
        break;
        }
       }
      }
     else  // find the container if there is one.
      {
      if (cachecnt)
       {
       for (j=0;j<cachecnt;j++)
        {
        x=contcache[j];
        if ((items[x].ser1==a)&&(items[x].ser2==b)&&(items[x].ser3==c)&&(items[x].ser4==d))
         {
         if (items[x].free==0)
          {
          idelete=0;
          break;
          }
         }
        }
       }
      if (idelete)  // well, not in cache, so search all the items
       {
       for (j=0;j<itemcount;j++)
        {  
        if ((items[j].ser1==a)&&(items[j].ser2==b)&&(items[j].ser3==c)&&(items[j].ser4==d))
         { 
         if (items[j].free==0)
          {
          idelete=0;
          // add item to cache since probably more than one item in container
          contcache[cachecnt++]=j;
          break;
          }
         }
        }
       }
      }
     }
    if (idelete)
     {
     deleitem(i);
     removed++;
     }
    }
   }
  rtotal=rtotal+removed;
 } 
while (removed>0);
if (rtotal>0) printf("GCOL: Removed %i items.\n",rtotal);
}

void deletechar (int k) // Delete character
{
 int j;

 removeitem[1]=chars[k].ser1;
 removeitem[2]=chars[k].ser2;
 removeitem[3]=chars[k].ser3;
 removeitem[4]=chars[k].ser4;
 j=removefromptr(&charsp[chars[k].serial%256], k);
 if (chars[k].spawnserial!=-1) j=removefromptr(&cspawnsp[chars[k].spawnserial%256], k);
 if (chars[k].ownserial!=-1) j=removefromptr(&cownsp[chars[k].ownserial%256], k);

 for (j=0;j<now;j++)
 {
  xsend(j, removeitem, 5, 0);
  //if (currchar[j]>k) currchar[j]--;
 }
  chars[k].free=1;
  chars[k].x=20+(xcounter++);
  chars[k].y=50+(ycounter);
  chars[k].z=9;
  chars[k].summontimer=0;
 if (xcounter==40)
  {
  ycounter++;
  xcounter=0;
  }
 if (ycounter==80)
  {
  ycounter=0;
  xcounter=0;
  }

 if (cmemcheck<300)
  {
  cmemcheck++;
  freecharmem[cmemcheck]=k;
  }
 else cmemover=1;

 gcollect();
}

void readwscline () // Read line from UOX3.WSC
{
 int i, valid=0;
 char c;
 temp[0]=0;
 while (!valid)
 {
  i=0;
  if (feof(wscfile)) return;
  c=(char)fgetc(wscfile);
  while (c!=10)
  {
   if (c!=13)// && c!=0)
   {
    temp[i]=c;
    i++;
   }
   if (feof(wscfile)) return;
   c=(char)fgetc(wscfile);
  }
  temp[i]=0;
  valid=1;
  if (temp[0]=='/' && temp[1]=='/') valid=0;
  if (temp[0]=='{') valid=0;
  if (temp[0]==0) valid=0;
 }
}

void readw2 ()
{
 int i=0;

 readwscline();
 script1[0]=0;
 script2[0]=0;
 script3[0]=0;
 while(temp[i]!=0 && temp[i]!=' ') i++;
 strncpy(script1, temp, i);
 script1[i]=0;
 if (script1[0]!='}' && temp[i]!=0) strcpy(script2, temp+i+1);
 return;
}

void readw3 ()
{
 int i=0,j;

 readwscline();
 script1[0]=0;
 script2[0]=0;
 script3[0]=0;
 while(temp[i]!=0 && temp[i]!=' ') i++;
 strncpy(script1, temp, i);
 script1[i]=0;
 if (script1[0]=='}' || temp[i]==0) return;
 i++;
 j=i;
 while(temp[i]!=0 && temp[i]!=' ') i++;
 strncpy(script2, temp+j, i-j);
 script2[i-j]=0;
 strcpy(script3, temp+i+1);
}

void loadchar(int x) // Load a character from WSC
{
 unsigned long int i;
 int j;
 x=charcount;
 charcount++;
 initchar(x);
 //initchar automatically adds to pointer array, remove cuz we don't know char
 //serial # yet.
 removefromptr(&charsp[chars[x].serial%256], x);
 chars[x].ser1=0;
 chars[x].ser2=0;
 chars[x].ser3=0;
 chars[x].ser4=0;
 chars[x].serial=0;
 chars[x].dir=4;
 chars[x].hp=chars[x].st=10;
 chars[x].stm=chars[x].dx=10;
 chars[x].mn=chars[x].in=10;
 for (i=0;i<TRUESKILLS;i++)
 {
  chars[x].baseskill[i]=1;
  chars[x].skill[i]=1;
 }
 chars[x].hunger=0;
 do
 {
  readw2();
  if (!(strcmp(script1, "SERIAL")))
  {
   i=str2num(script2);
   if (charcount2<=i) charcount2=i+1;
   chars[x].ser1=i/16777216;
   chars[x].ser2=i/65536;
   chars[x].ser3=i/256;
   chars[x].ser4=i%256;
   chars[x].serial=i;
   setptr(&charsp[i%256], x); //Load into charsp array
  }
  if (!(strcmp(script1, "NAME"))) sprintf(chars[x].name, "%s", script2);
  if (!(strcmp(script1, "TITLE"))) sprintf(chars[x].title, "%s", script2);
  if (!(strcmp(script1, "ACCOUNT"))) chars[x].account=str2num(script2);
  if (!(strcmp(script1, "X"))) chars[x].x=str2num(script2);
  if (!(strcmp(script1, "Y"))) chars[x].y=str2num(script2);
  if (!(strcmp(script1, "Z"))) chars[x].dispz=chars[x].z=str2num(script2);
  if (!(strcmp(script1, "DISPZ"))) chars[x].dispz=str2num(script2);
  if (!(strcmp(script1, "OLDX"))) chars[x].oldx=str2num(script2);
  if (!(strcmp(script1, "OLDY"))) chars[x].oldy=str2num(script2);
  if (!(strcmp(script1, "OLDZ"))) chars[x].oldz=str2num(script2);
  if (!(strcmp(script1, "DIR"))) chars[x].dir=str2num(script2);
  if (!(strcmp(script1, "BODY")))
  {
   i=str2num(script2);
   chars[x].id1=i/256;
   chars[x].id2=i%256;
  }
  if (!(strcmp(script1, "XBODY")))
  {
   i=str2num(script2);
   chars[x].xid1=i/256;
   chars[x].xid2=i%256;
  }
  if (!(strcmp(script1, "SKIN")))
  {
   i=str2num(script2);
   chars[x].skin1=i/256;
   chars[x].skin2=i%256;
  }
  if (!(strcmp(script1, "XSKIN")))
  {
   i=str2num(script2);
   chars[x].xskin1=i/256;
   chars[x].xskin2=i%256;
  }
  if (!(strcmp(script1, "SAY")))
  {
   i=str2num(script2);
   chars[x].saycolor1=i/256;
   chars[x].saycolor2=i%256;
  }
  if (!(strcmp(script1, "EMOTE")))
  {
   i=str2num(script2);
   chars[x].emotecolor1=i/256;
   chars[x].emotecolor2=i%256;
  }
  if (!(strcmp(script1, "PRIV"))) chars[x].priv=str2num(script2);
  if (!(strcmp(script1, "ALLMOVE"))) chars[x].priv2=str2num(script2);
  if (!(strcmp(script1, "FONT"))) chars[x].fonttype=str2num(script2);
  if (!(strcmp(script1, "STRENGTH"))) chars[x].st=str2num(script2);
  if (!(strcmp(script1, "STRENGTH2"))) chars[x].st2=str2num(script2);
  if (!(strcmp(script1, "DEXTERITY"))) chars[x].dx=str2num(script2);
  if (!(strcmp(script1, "DEXTERITY2"))) chars[x].dx2=str2num(script2);
  if (!(strcmp(script1, "INTELLIGENCE"))) chars[x].in=str2num(script2);
  if (!(strcmp(script1, "INTELLIGENCE2"))) chars[x].in2=str2num(script2);
  if (!(strcmp(script1, "HITPOINTS"))) chars[x].hp=str2num(script2);
  if (!(strcmp(script1, "STAMINA"))) chars[x].stm=str2num(script2);
  if (!(strcmp(script1, "MANA"))) chars[x].mn=str2num(script2);
  if (!(strcmp(script1, "NPC"))) chars[x].npc=str2num(script2);
  if (!(strcmp(script1, "SHOP"))) chars[x].shop=str2num(script2);
  if (!(strcmp(script1, "OWN")))
  {
   i=str2num(script2);
   chars[x].own1=i/16777216;
   chars[x].own2=i/65536;
   chars[x].own3=i/256;
   chars[x].own4=i%256;
   chars[x].ownserial=i;
   if (chars[x].ownserial!=-1) setptr(&cownsp[i%256], x); //Load into charsp array
  }
  if (!(strcmp(script1, "ROBE")))
  {
   i=str2num(script2);
   chars[x].robe1=i/16777216;
   chars[x].robe2=i/65536;
   chars[x].robe3=i/256;
   chars[x].robe4=i%256;
  }
  if (!(strcmp(script1, "KARMA"))) chars[x].karma=str2num(script2);
  if (!(strcmp(script1, "FAME"))) chars[x].fame=str2num(script2);
  if (!(strcmp(script1, "KILLS"))) chars[x].kills=str2num(script2);
  if (!(strcmp(script1, "DEATHS"))) chars[x].deaths=str2num(script2);
  if (!(strcmp(script1, "DEAD"))) chars[x].dead=str2num(script2);
  if (!(strcmp(script1, "PACKITEM"))) chars[x].packitem=str2num(script2);
  if (!(strcmp(script1, "FIXEDLIGHT"))) chars[x].fixedlight=str2num(script2);
  if (!(strcmp(script1, "SPEECH"))) chars[x].speech=str2num(script2);
  if ((script1[0]=='S')&&(script1[1]=='K')&&(script1[2]=='I')&&
      (script1[3]=='L')&&(script1[4]=='L'))
  {
      chars[x].baseskill[j=str2num(&script1[5])]=str2num(script2);
      updateSkillLevel(x, j);
  }
  if (!(strcmp(script1, "RESERVED1"))) chars[x].cell=str2num(script2);
  if (!(strcmp(script1, "ATT"))) chars[x].att=str2num(script2);
  if (!(strcmp(script1, "DEF"))) chars[x].def=str2num(script2);
  if (!(strcmp(script1, "LODAMAGE"))) chars[x].lodamage=str2num(script2);
  if (!(strcmp(script1, "HIDAMAGE"))) chars[x].hidamage=str2num(script2);
  if (!(strcmp(script1, "WAR"))) chars[x].war=str2num(script2);
  if (!(strcmp(script1, "NPCWANDER"))) chars[x].npcWander=str2num(script2);
  if (!(strcmp(script1, "OLDNPCWANDER"))) chars[x].oldnpcWander=str2num(script2);
  if (!(strcmp(script1, "FX1"))) chars[x].fx1=str2num(script2);
  if (!(strcmp(script1, "FY1"))) chars[x].fy1=str2num(script2);
  if (!(strcmp(script1, "FZ1"))) chars[x].fz1=str2num(script2);
  if (!(strcmp(script1, "FX2"))) chars[x].fx2=str2num(script2);
  if (!(strcmp(script1, "FY2"))) chars[x].fy2=str2num(script2);
  if (!(strcmp(script1, "SPAWN")))
  {
   i=str2num(script2);
   chars[x].spawn1=i/16777216;
   chars[x].spawn2=i/65536;
   chars[x].spawn3=i/256;
   chars[x].spawn4=i%256;
   chars[x].spawnserial=i;
   if (chars[x].spawnserial!=-1) setptr(&cspawnsp[i%256], x); //Load into charsp array
  }
  if (!(strcmp(script1, "HIDDEN"))) chars[x].hidden=str2num(script2);
  if (!(strcmp(script1, "HUNGER"))) chars[x].hunger=str2num(script2);
  if (!(strcmp(script1, "NPCAITYPE"))) chars[x].npcaitype=str2num(script2);
  if (!(strcmp(script1, "SPATTACK"))) chars[x].spattack=str2num(script2);
  if (!(strcmp(script1, "SPADELAY"))) chars[x].spadelay=str2num(script2);
  if (!(strcmp(script1, "TAMING"))) chars[x].taming=str2num(script2);
  if (!(strcmp(script1, "SUMMONTIMER"))) chars[x].summontimer=str2num(script2);
  if (!(strcmp(script1, "TOWN"))) chars[x].town=str2num(script2);
  if (!(strcmp(script1, "TOWNVOTE")))
  {
   i=str2num(script2);
//   if (charcount2<=i) charcount2=i+1;
   chars[x].townvote1=i/16777216;
   chars[x].townvote2=i/65536;
   chars[x].townvote3=i/256;
   chars[x].townvote4=i%256;
  }
  if (!(strcmp(script1, "TOWNTITLE"))) chars[x].towntitle=str2num(script2);
  if (!(strcmp(script1, "TOWNPRIV"))) chars[x].townpriv=str2num(script2);
  if (!(strcmp(script1, "ADVOBJ"))) chars[x].advobj=str2num(script2);
  if (!(strcmp(script1, "POISON"))) chars[x].poison=str2num(script2);
  if (!(strcmp(script1, "POISONED"))) chars[x].poisoned=str2num(script2);
  if (!(strcmp(script1, "FLEEAT"))) chars[x].fleeat=str2num(script2);
  if (!(strcmp(script1, "REATTACKAT"))) chars[x].reattackat=str2num(script2);
  if (!(strcmp(script1, "TRIGGER"))) chars[x].trigger=str2num(script2);
  if (!(strcmp(script1, "TRIGWORD"))) sprintf(chars[x].trigword, "%s", script2);
  if (!(strcmp(script1, "DISABLED"))) chars[x].disabled=str2num(script2);
  if (!(strcmp(script1, "SPLIT"))) chars[x].split=str2num(script2);
  if (!(strcmp(script1, "SPLITCHANCE"))) chars[x].splitchnc=str2num(script2);
  if (!(strcmp(script1, "NOTRAIN"))) chars[x].cantrain=0;
 }
 while (strcmp(script1, "}"));
 if (chars[x].npc && chars[x].war) chars[x].war=0;
}

void loaditem (int x) // Load an item from WSC
{
 unsigned long int i;

 x=itemcount;
 itemcount++;
 inititem(x);
 sprintf(items[x].name,"#");
 items[x].ser1=0x40;
 items[x].id1=0x0F;
 items[x].id2=0xA6;
 do
 {
  readw2();
  if (!(strcmp(script1, "SERIAL")))
  {
   i=str2num(script2);
   if (itemcount2<=i) itemcount2=i+1;
   items[x].ser1=i/16777216;
   items[x].ser2=i/65536;
   items[x].ser3=i/256;
   items[x].ser4=i%256;
   items[x].serial=i; //Tauriel
   setptr(&itemsp[i%256], x); //set item in pointer array
  }
  if (!(strcmp(script1, "NAME"))) sprintf(items[x].name, "%s", script2);
  if (!(strcmp(script1, "NAME2"))) sprintf(items[x].name2, "%s", script2);
  if (!(strcmp(script1, "ID")))
  {
   i=str2num(script2);
   items[x].id1=i/256;
   items[x].id2=i%256;
  }
  if (!(strcmp(script1, "X"))) items[x].x=str2num(script2);
  if (!(strcmp(script1, "Y"))) items[x].y=str2num(script2);
  if (!(strcmp(script1, "Z"))) items[x].z=str2num(script2);
  if (!(strcmp(script1, "COLOR")))
  {
   i=str2num(script2);
   items[x].color1=i/256;
   items[x].color2=i%256;
  }
  if (!(strcmp(script1, "CONT")))
  {
   i=str2num(script2);
   items[x].cont1=i/16777216;
   items[x].cont2=i/65536;
   items[x].cont3=i/256;
   items[x].cont4=i%256;
   items[x].contserial=i;
   if (i!=-1) setptr(&contsp[i%256], x); //set item in pointer array
  }
  if (!(strcmp(script1, "LAYER"))) items[x].layer=str2num(script2);
  if (!(strcmp(script1, "TYPE"))) items[x].type=str2num(script2);
  if (!(strcmp(script1, "TYPE2"))) items[x].type2=str2num(script2);
  if (!(strcmp(script1, "OFFSPELL"))) items[x].offspell=str2num(script2);
  if (!(strcmp(script1, "MORE")))
  {
   i=str2num(script2);
   items[x].more1=i/16777216;
   items[x].more2=i/65536;
   items[x].more3=i/256;
   items[x].more4=i%256;
  }
  if (!(strcmp(script1, "MORE2")))
  {
   i=str2num(script2);
   items[x].moreb1=i/16777216;
   items[x].moreb2=i/65536;
   items[x].moreb3=i/256;
   items[x].moreb4=i%256;
  }
  if (!(strcmp(script1, "MOREX"))) items[x].morex=str2num(script2);
  if (!(strcmp(script1, "MOREY"))) items[x].morey=str2num(script2);
  if (!(strcmp(script1, "MOREZ"))) items[x].morez=str2num(script2);
  if (!(strcmp(script1, "AMOUNT"))) items[x].amount=str2num(script2);
  if (!(strcmp(script1, "PILEABLE"))) items[x].pileable=str2num(script2);
  if (!(strcmp(script1, "DOORFLAG"))) items[x].doordir=str2num(script2);
  if (!(strcmp(script1, "DYEABLE"))) items[x].dye=str2num(script2);
  if (!(strcmp(script1, "CORPSE"))) items[x].corpse=str2num(script2);
  if (!(strcmp(script1, "ATT"))) items[x].att=str2num(script2);
  if (!(strcmp(script1, "DEF"))) items[x].def=str2num(script2);
  if (!(strcmp(script1, "HIDAMAGE"))) items[x].hidamage=str2num(script2);
  if (!(strcmp(script1, "LODAMAGE"))) items[x].lodamage=str2num(script2);
  if (!(strcmp(script1, "ST"))) items[x].st=str2num(script2);
  if (!(strcmp(script1, "HP"))) items[x].hp=str2num(script2);
  if (!(strcmp(script1, "MAXHP"))) items[x].maxhp=str2num(script2);
  if (!(strcmp(script1, "ST2"))) items[x].st2=str2num(script2);
  if (!(strcmp(script1, "DX"))) items[x].dx=str2num(script2);
  if (!(strcmp(script1, "DX2"))) items[x].dx2=str2num(script2);
  if (!(strcmp(script1, "IN"))) items[x].in=str2num(script2);
  if (!(strcmp(script1, "IN2"))) items[x].in2=str2num(script2);
  if (!(strcmp(script1, "SPD"))) items[x].spd=str2num(script2);
  if (!(strcmp(script1, "WIPE"))) items[x].wipe=str2num(script2);
  if (!(strcmp(script1, "MOVABLE"))) items[x].magic=str2num(script2);
  if (!(strcmp(script1, "OWNER")))
  {
   i=str2num(script2);
   items[x].owner1=i/16777216;
   items[x].owner2=i/65536;
   items[x].owner3=i/256;
   items[x].owner4=i%256;
   items[x].ownserial=i;
   setptr(&ownsp[i%256], x); //set item in pointer array
  }
  if (!(strcmp(script1, "VISIBLE"))) items[x].visible=str2num(script2);
  if (!(strcmp(script1, "SPAWN")))
  {
   i=str2num(script2);
   items[x].spawn1=i/16777216;
   items[x].spawn2=i/65536;
   items[x].spawn3=i/256;
   items[x].spawn4=i%256;
   items[x].spawnserial=i;
   setptr(&spawnsp[i%256], x); //set item in pointer array
  }
  if (!(strcmp(script1, "DIR"))) items[x].dir=str2num(script2);
  if (!(strcmp(script1, "PRIV"))) items[x].priv=str2num(script2);
  if (!(strcmp(script1, "VALUE"))) items[x].value=str2num(script2);
  if (!(strcmp(script1, "RESTOCK"))) items[x].restock=str2num(script2);
  if (!(strcmp(script1, "TRIGGER"))) items[x].trigger=str2num(script2);
  if (!(strcmp(script1, "TRIGTYPE"))) items[x].trigtype=str2num(script2);
  if (!(strcmp(script1, "DISABLED"))) items[x].disabled=str2num(script2);
  if (!(strcmp(script1, "USES"))) items[x].tuses=str2num(script2);
 }
 while (strcmp(script1, "}"));
 if (items[x].maxhp==0) items[x].maxhp=items[x].hp;
}

char *RealTime(char *time_str)
{
    struct tm *curtime;
    time_t bintime;
    time(&bintime);
    curtime = localtime(&bintime);
    strftime(time_str, 80, "%I:%M:%S %p", curtime);
    return time_str;
}

void savelog(const char *msg, char *logfile)
{
	if (server_data.log>=1)
	{
		char time_str[80];
		FILE *file;

		file=fopen(logfile,"a");
		fprintf(file,"[%s] %s",RealTime(time_str),msg);
		
		#ifdef DEBUG
		printf("DEBUG: Logging to %s\n", logfile);
		#endif
		
		fclose(file);
	}
}

void loadnewworld () // Load world from UOX3.WSC
{
 charcount=0;
 itemcount=0;
 charcount2=1;
 itemcount2=0x40000000;
 wscfile=fopen("uox3.wsc", "r");
 if (wscfile==NULL)
 {
   printf("ERROR: UOX3.WSC not found, using blank world instead\n");
   return;
 }
 printf("Loading UOX3.WSC...\n");
 do
 {
  readw3();
  if (!(strcmp(script1, "SECTION")))
  {
   if (!(strcmp(script2, "CHARACTER")))
   {
    loadchar(str2num(script3));
   }
   if (!(strcmp(script2, "WORLDITEM")))
   {
    loaditem(str2num(script3));
   }
  }
 }
 while (strcmp(script1, "EOF"));
 fclose(wscfile);
}

void splitline () // For putting single words of cline into comm array
{
 int i=0;
 char *s;
 char *d;

 d=" ";
 s=strtok(cline,d);
 while (s!=NULL)
 {
  comm[i]=s;
  i++;
  s=strtok(NULL,d);
 }
 tnum=i;
}

int makenumber (int countx) // Converts decimal string comm[count] to int
{
 unsigned int i;
 int n=0;
 unsigned int length=strlen(comm[countx]);
 for(i=0;i<length;i++)
 {
  n*=10; // Multiply by 10
  if (isdigit(comm[countx][i]))
  n=n+(comm[countx][i])-48; // Convert char to number from 0 to 9
 }
 if (comm[countx][0]=='-') n=-n;
 return n;
}

int hexnumber(int countx) // Converts hex string comm[count] to int
{
 unsigned int i;
 int n=0;
 unsigned int length=strlen(comm[countx]);
 for(i=0;i<length;i++)
 {
  n*=16; // Multiply by 16
  if (isdigit(comm[countx][i]))
      n=n+(comm[countx][i])-48; // Convert char to number from 0 to 9
  if ((comm[countx][i]>=65) && (comm[countx][i]<=70)) // Uppercase A-F
      n=n+(comm[countx][i])-65+10;
  if ((comm[countx][i]>=97) && (comm[countx][i]<=102)) // Lowercase A-F
      n=n+(comm[countx][i])-97+10;
 }
 if (comm[countx][0]=='-') n=-n;
 return n;
}

int makenum2(char *s) // Converts string to integer
{
 unsigned int i;
 int n=0;
 unsigned int length=strlen(s);
 for(i=0;i<length;i++)
 {
  n*=10; // Multiply by 10
  if (isdigit(s[i])) n=n+(s[i])-48; // Convert char to number from 0 to 9
 }
 if (s[0]=='-') n=-n;
 return n;
}

void gentable (int n, char a1, char a2, char a3, char a4) // Initialize encryption table
{
 unsigned int seed = ((unsigned int)a1 << 24) + ((unsigned int)a2 << 16) + ((unsigned int)a3 << 8) + (unsigned int)a4;

 cryptmask[n][0] = (((~seed) ^ 0x00001357) << 16) | ((seed ^ 0xffffaaaa) & 0x0000ffff);
 cryptmask[n][1] = ((seed ^ 0x43210000) >> 16) | (((~seed) ^ 0xabcdffff) & 0xffff0000);
}

char mapheight(int x, int y) // Height of MAP0.MUL at given coordinates
{
 long int pos;
 int x1, x2;
 int y1, y2;
 char z;

 x1=x/8; // Block
 y1=y/8;
 x2=(x-(x1*8)); // Offset
 y2=(y-(y1*8));
 pos=(x1*512*196)+(y1*196)+(y2*24)+(x2*3)+4+2;
 fseek(mapfile, pos, SEEK_SET);
 z=(char) fgetc(mapfile);
 return z;
}

char maptype(int x, int y) // Height of MAP0.MUL at given coordinates
{
 long int pos;
 int x1, x2;
 int y1, y2;
 char z;

 x1=x/8; // Block
 y1=y/8;
 x2=(x-(x1*8)); // Offset
 y2=(y-(y1*8));
 pos=(x1*512*196)+(y1*196)+(y2*24)+(x2*3)+4;
 fseek(mapfile, pos, SEEK_SET);
 z=(char) fgetc(mapfile);
 if (z!=68)
         return 1;
 z=(char) fgetc(mapfile);
 if (z!=2)
         return 1;
 return 0;
}

long int verseek(long int file, long int block)
{
 long int vers, i;
 versionrecord ver;

 fseek(verfile, 0, SEEK_SET);
 fread(&vers, 4, 1, verfile);
 for (i=0;i<vers;i++)
 {
  if (feof(verfile))
  {
   printf("Error: Avoiding bad read crash.\n");
   return 0;
  }
  fread(&ver, sizeof(versionrecord), 1, verfile);
  if ((ver.file==file)&&(ver.block==block))
  {
   fseek(verfile, ver.filepos, SEEK_SET);
   return(ver.length);
  }
 }
 return 0;
}

char vertile(int tilenum, tile_st *tile)
{
 long int pos, block;

 block=(tilenum/32);
 if (verseek(VERFILE_TILEDATA, block+0x200)==0)
 {
//  printf("No Ver\n");
  return 0;
 }
 else
 {
//  printf("Ver\n");
  pos=4+(sizeof(tile_st)*(tilenum%32));
  fseek(verfile, pos, SEEK_CUR);
  fread(tile, sizeof(tile_st), 1, verfile);
  return 1;
 }
}

void seektile(int tilenum, tile_st *tile)
{
 long int pos, block;

 if (tilenum>=0x4000)
 {
  sprintf((*tile).name, "multi");
  (*tile).flag1=0;
  (*tile).flag2=0;
  (*tile).flag3=0;
  (*tile).flag4=0;
  (*tile).weight=255;
  (*tile).height=0;
 }
 else
 {
  block=(tilenum/32)+1;
  if (!vertile(tilenum, tile))
  {
   pos=TILEDATA_TILES+(block*4)+(sizeof(tile_st)*tilenum);
   fseek(tilefile, pos, SEEK_SET);
   fread(tile, sizeof(tile_st), 1, tilefile);
  }
 }
}

char verland(int landnum, land_st *land)
{
 long int pos, block;

 block=(landnum/32);
 if (verseek(VERFILE_TILEDATA, block)==0)
 {
//  printf("No Ver\n");
  return 0;
 }
 else
 {
//  printf("Ver\n");
  pos=4+(sizeof(land_st)*(landnum%32));
  fseek(verfile, pos, SEEK_CUR);
  fread(land, sizeof(land_st), 1, verfile);
  return 1;
 }
}

void seekland(int landnum, land_st *land)
{
 long int pos, block;

 block=(landnum/32)+1;
 if (!verland(landnum, land))
 {
  pos=(block*4)+(sizeof(land_st)*landnum);
  fseek(tilefile, pos, SEEK_SET);
  fread(land, sizeof(land_st), 1, tilefile);
 }
}

void seekmulti(int multinum, FILE **mfile, long int *length)
{
 int len;
 st_multiidx multiidx;

 len=verseek(VERFILE_MULTI, multinum);
 if (len==0)
 {
  fseek(midxfile, multinum*sizeof(st_multiidx), SEEK_SET);
  fread(&multiidx, sizeof(st_multiidx), 1, midxfile);
  fseek(multifile, multiidx.start, SEEK_SET);
  *mfile=multifile;
  *length=multiidx.length;
 }
 else
 {
  *mfile=verfile;
  *length=len;
 }
}

char tileheight(int tilenum)
{
 tile_st tile;

 seektile(tilenum, &tile);
 if (tile.flag2&4) tile.height=tile.height/2; // For Stairs+Ladders
 if (!(tile.flag2&2)) tile.height=0;
 return (tile.height);
}
//o-------------------------------------------------------------o
//|   Function    :  char staheight(int x,int y,int oldz);
//|   Date        :  Unknown     Touched: Dec 21, 1998
//|   Programmer  :  Unknown
//o-------------------------------------------------------------o
//|   Purpose     :  Height of statics at/above given coordinates
//o-------------------------------------------------------------o
char staheight(int x, int y, int oldz)
{
   long int pos, pos2, length;
   int x1, x2;
   int y1, y2;
   signed char z, ztemp, found;
   int i;
   staticrecord stat;

   // EviLDeD  -  Bug killing
   memset(&stat,0,sizeof(staticrecord));

   stat.itemid=stat.itemid;
   stat.extra=stat.extra;
   z=-127;
   found=0;
   x1=x/8; // Block
   y1=y/8;
   x2=(x-(x1*8)); // Offset
   y2=(y-(y1*8));
   pos=(x1*512*12)+(y1*12);
   fseek(sidxfile, pos, SEEK_SET);
   fread(&pos2, 4, 1, sidxfile);
   if (pos2!=-1)
   {
      if (feof(sidxfile))
      {
         printf("Error: Avoiding bad read crash.\n");
         return 0;
      }
      fread(&length, 4, 1, sidxfile);
      length=length/7;
      fseek(statfile, pos2, SEEK_SET);
      for (i=0;i<length;i++)
      {
         if (feof(statfile))
         {
            printf("Error: Avoiding bad z pos crash.\n");
            return z;
         }
         fread(&stat, 7, 1, statfile);
         if ((stat.xoff==x2)&&(stat.yoff==y2))
         {
            ztemp=stat.zoff+tileheight(stat.itemid);
            if ((ztemp<=oldz+7)&&(ztemp>z))
            {
               z=ztemp;
               found=1; 
            }
         }
      }
   }
   return z;
}

// Height of dynamic items at/above given coordinates
char dynheight(int x, int y, int oldz)
{
 int i;
 signed char z=-127, ztemp;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].x==x)&&(items[i].y==y))
  {
   ztemp=items[i].z+tileheight((items[i].id1*256)+items[i].id2);
   if ((ztemp<=oldz+11)&&(ztemp>z))
   {
    z=ztemp;
   }
  }
 }
 return z;
}

char height(int x, int y, int oldz) // Height of player who walked to X/Y/OLDZ
{
 signed char mapz, staz, dynz, z;

 mapz=mapheight(x, y);
 staz=staheight(x, y, oldz);
 dynz=dynheight(x, y, oldz);
 if (staz==-127) z=mapz; else z=staz;
 if (dynz!=-127) z=dynz;
 return z;
}

int cgold2(int item) // Calculate total gold
{
  char i1, i2, i3, i4;
  int i, total=0, serial,ci;

  i1=items[item].ser1;
  i2=items[item].ser2;
  i3=items[item].ser3;
  i4=items[item].ser4;
  serial=calcserial(i1,i2,i3,i4);
  for (ci=0;ci<contsp[serial%256].max;ci++)
  {
    i=contsp[serial%256].pointer[ci];
    if (i!=-1 && items[i].contserial==serial)
    {
      if ((items[i].id1==0x0E)&&(items[i].id2==0xED))
      {
        total+=items[i].amount;
      }
      if ((items[i].type==1)||(items[i].type==8))
      {
        total+=cgold2(i);
      }
    }
  }
  return total;
}

int calcgold(int p) // Calculate total gold
{
  char p1, p2, p3, p4;
  int i,ci,serial;

  p1=chars[p].ser1;
  p2=chars[p].ser2;
  p3=chars[p].ser3;
  p4=chars[p].ser4;
  serial=calcserial(p1,p2,p3,p4);
// for (i=0;i<itemcount;i++)
// if ((items[i].cont1==p1)&&(items[i].cont2==p2)&&(items[i].cont3==p3)&&(items[i].cont4==p4)&&
  for (ci=0;ci<contsp[serial%256].max;ci++)
  {
    i=contsp[serial%256].pointer[ci];
    if ((items[i].contserial==serial) && (items[i].layer==0x15))
    {
      return (cgold2(i));
    }
  }
  return 0;
}

int packitem(int p) // Find packitem
{
  int serial,j,ci;
  int i=chars[p].packitem;
  if ((items[i].contserial==chars[p].serial) && (items[i].layer==0x15))
  {
      return chars[p].packitem;
  }

  // - For some reason it's not defined, so go look for it.
  serial=chars[p].serial;
  j=serial%256;
  for (ci=0;ci<contsp[j].max;ci++)
  {
    i=contsp[j].pointer[ci];
    if ((items[i].contserial==serial) &&
        (items[i].layer==0x15))
    {
      chars[p].packitem=i;  //Record it for next time
      return (i);
    }
  }
  return -1;
}

void soundeffect(int s, unsigned char a, unsigned char b) // Play sound effect for player
{
 int i;

 sfx[2]=a;
 sfx[3]=b;
 sfx[6]=chars[currchar[s]].x/256;
 sfx[7]=chars[currchar[s]].x%256;
 sfx[8]=chars[currchar[s]].y/256;
 sfx[9]=chars[currchar[s]].y%256;
 for (i=0;i<now;i++)
 if ((perm[i])&&((inrange1(s,i))||(s==i)))
 {
  xsend(i, sfx, 12, 0);
 }
}

void soundeffect2(int p, unsigned char a, unsigned char b)
{
 int i;

 sfx[2]=a;
 sfx[3]=b;
 sfx[6]=chars[p].x/256;
 sfx[7]=chars[p].x%256;
 sfx[8]=chars[p].y/256;
 sfx[9]=chars[p].y%256;
 for (i=0;i<now;i++)
 if ((perm[i])&&(inrange1p(p, currchar[i])))
 {
  xsend(i, sfx, 12, 0);
 }
}

void soundeffect3(int p, unsigned char a, unsigned char b)
{
 int i;

 sfx[2]=a;
 sfx[3]=b;
 sfx[6]=items[p].x/256;
 sfx[7]=items[p].x%256;
 sfx[8]=items[p].y/256;
 sfx[9]=items[p].y%256;
 for (i=0;i<now;i++)
 if ((perm[i])&&(inrange2(i, p)))
 {
  xsend(i, sfx, 12, 0);
 }
}

void action(int s, int x) // Character does a certain action
{
 int i;

 doact[1]=chars[currchar[s]].ser1;
 doact[2]=chars[currchar[s]].ser2;
 doact[3]=chars[currchar[s]].ser3;
 doact[4]=chars[currchar[s]].ser4;
 doact[5]=x/256;
 doact[6]=x%256;
 xsend(s, doact, 14, 0);
 for (i=0;i<now;i++) if ((inrange1(s, i))&&(perm[i])) xsend(i, doact, 14, 0);
}

void npcaction(int npc, int x) // NPC character does a certain action
{
 int i;

 doact[1]=chars[npc].ser1;
 doact[2]=chars[npc].ser2;
 doact[3]=chars[npc].ser3;
 doact[4]=chars[npc].ser4;
 doact[5]=x/256;
 doact[6]=x%256;
 for (i=0;i<now;i++) if ((inrange1p(currchar[i], npc))&&(perm[i])) xsend(i, doact, 14, 0);
}

void sysbroadcast(char *txt) // System broadcast in bold text
{
 int tl, i;

 tl=44+strlen(txt)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=1;
 talk[4]=1;
 talk[5]=1;
 talk[6]=1;
 talk[7]=1;
 talk[8]=1;
 talk[9]=1;
// talk[10]=0x03;
// talk[11]=0xB2;
 talk[10]=0x08;
 talk[11]=0x4d;
 talk[12]=0;
 talk[13]=0;
 for (i=0;i<now;i++)
 {
  if (perm[i])
  {
   xsend(i, talk, 14, 0);
   xsend(i, sysname, 30, 0);
   xsend(i, txt, strlen(txt)+1, 0);
  }
 }
 clearbuffers();
}

void sysmessage(int s, char *txt) // System message (In lower left corner)
{
 if(s==-1) return;
 int tl=44+strlen(txt)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=1;
 talk[4]=1;
 talk[5]=1;
 talk[6]=1;
 talk[7]=1;
 talk[8]=1;
 talk[9]=0;
// talk[10]=0x03;
// talk[11]=0xB2;
 talk[10]=0x00;
 talk[11]=0x40;
 talk[12]=0;
 talk[13]=3;
 xsend(s, talk, 14, 0);
 xsend(s, sysname, 30, 0);
 xsend(s, txt, strlen(txt)+1, 0);
}

void itemmessage(int s, char *txt, int a1, int a2, int a3, int a4) // The message when an item is clicked
{
 int tl;
 tl=44+strlen(txt)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=a1;
 talk[4]=a2;
 talk[5]=a3;
 talk[6]=a4;
 talk[7]=1;
 talk[8]=1;
 talk[9]=6; // Mode: "You see"
 talk[10]=0x03;
 talk[11]=0xB2;
 talk[12]=0;
 talk[13]=3;
 xsend(s, talk, 14, 0);
 xsend(s, sysname, 30, 0);
 xsend(s, txt, strlen(txt)+1, 0);
}

void wornitems(int s, int j) // Send worn items of player j
{
 int i,serial,serhash,ci;

 chars[j].onhorse=0;
 serial=chars[j].serial;
 serhash=serial%256;
 for (ci=0;ci<contsp[serhash].max;ci++)
 {
   i=contsp[serhash].pointer[ci];
   if ((i!=-1) && (items[i].contserial==serial) && (items[i].free==0))
  {
   if (items[i].layer==0x19) chars[j].onhorse=1;
   wearitem[1]=items[i].ser1;
   wearitem[2]=items[i].ser2;
   wearitem[3]=items[i].ser3;
   wearitem[4]=items[i].ser4;
   wearitem[5]=items[i].id1;
   wearitem[6]=items[i].id2;
   wearitem[8]=items[i].layer;
   wearitem[9]=items[i].cont1;
   wearitem[10]=items[i].cont2;
   wearitem[11]=items[i].cont3;
   wearitem[12]=items[i].cont4;
   wearitem[13]=items[i].color1;
   wearitem[14]=items[i].color2;
   xsend(s, wearitem, 15, 0);
  }
 }
}

void backpack(int s, int a1, int a2, int a3, int a4) // Send Backpack (with items)
{
 int i, count=0,serial,serhash,ci;
 char bpopen[13]="\x24\x40\x0B\x00\x1A\x00\x3C\x3C\x00\x05\x00\x00";
  serial=calcserial(a1,a2,a3,a4);
  serhash=serial%256;
  for (i=0;i<contsp[serhash].max;i++)
  {
    ci=contsp[serhash].pointer[i];
    if ((ci!=-1) && (items[ci].contserial==serial) && (items[ci].free==0))
    {
      count++;
    }
  }
 bpopen[10]=count/256;
 bpopen[11]=count%256;
 count=(count*19)+5;
 bpopen[8]=count/256;
 bpopen[9]=count%256;
 bpopen[1]=a1;
 bpopen[2]=a2;
 bpopen[3]=a3;
 bpopen[4]=a4;
 bpopen[5]=0x00;
 bpopen[6]=0x47;
   i=findbyserial(&itemsp[serhash], serial, 0);
   if (i==-1)
   {
     printf("UOX3.CPP: backpack() couldn't find backpack: %d.\n",serial);
     return;
   }
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x75')) bpopen[6]=0x3C; // Backpack
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x76')) bpopen[6]=0x3D; // Leather Bag
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x77')) bpopen[6]=0x3E; // Barrel
   if ((items[i].id1=='\x09')&&(items[i].id2=='\x90')) bpopen[6]=0x41; // Round Basket
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x79')) bpopen[6]=0x40; // Box/Pouch
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x7A')) bpopen[6]=0x3F; // Square Basket
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x7C')) bpopen[6]=0x4A; // Silver Chest
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x7D')) bpopen[6]=0x43; // Wooden Box
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x7E')) bpopen[6]=0x44; // Wooden Crate
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x7F')) bpopen[6]=0x3E; // Keg
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x80')) bpopen[6]=0x4B; // Brass Box
   if ((items[i].id1=='\x20')&&(items[i].id2=='\x06')) bpopen[6]=0x09; // Coffin
   // Misc. Containers
   if ((items[i].id1=='\x09')&&(items[i].id2=='\xB2')) bpopen[6]=0x3C; // Backpack 2
   if ((items[i].id1=='\x09')&&(items[i].id2=='\xAA')) bpopen[6]=0x3F; // Wooden Box
   if ((items[i].id1=='\x09')&&(items[i].id2=='\xA8')) bpopen[6]=0x40; // Metal Box
   if ((items[i].id1=='\x09')&&(items[i].id2=='\xAB')) bpopen[6]=0x4A; // Metal/Silver Chest
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x40')) bpopen[6]=0x42; // Metal & Gold Chest
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x41')) bpopen[6]=0x42; // Metal & Gold Chest
   if ((items[i].id1=='\x09')&&(items[i].id2=='\xA9')) bpopen[6]=0x44; // Small Wooden Crate
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x3E')) bpopen[6]=0x44; // Small Wooden Crate
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x3F')) bpopen[6]=0x44; // Small Wooden Crate
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x3C')) bpopen[6]=0x44; // Large Wooden Crate
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x3D')) bpopen[6]=0x44; // Large Wooden Crate
   // Bookcases
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x97')) bpopen[6]=0x4D; // Bookcase
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x98')) bpopen[6]=0x4D; // Bookcase
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x99')) bpopen[6]=0x4D; // Bookcase
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x9A')) bpopen[6]=0x4D; // Bookcase
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x9B')) bpopen[6]=0x4D; // Bookcase
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x9C')) bpopen[6]=0x4D; // Bookcase
   // Armoires
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x4D')) bpopen[6]=0x4E; // Fancy Armoire
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x51')) bpopen[6]=0x4E; // Fancy Armoire
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x4F')) bpopen[6]=0x4F; // Wooden Armoire
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x53')) bpopen[6]=0x4F; // Wooden Armoire
   // Open Armoires
   // Hey, who knows - you might use these sometime
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x4C')) bpopen[6]=0x4E; // Fancy Armoire (open)
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x50')) bpopen[6]=0x4E; // Fancy Armoire (open)
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x4E')) bpopen[6]=0x4F; // Wooden Armoire (open)
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x52')) bpopen[6]=0x4F; // Wooden Armoire (open)
   // Chest Drawers
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x30')) bpopen[6]=0x48; // chest of drawers (fancy)
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x38')) bpopen[6]=0x48; // chest of drawers (fancy)
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x2C')) bpopen[6]=0x51; // chest of drawers (wood)
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x34')) bpopen[6]=0x51; // chest of drawers (wood)
   // Dressers
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x3C')) bpopen[6]=0x51; // Dresser
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x3D')) bpopen[6]=0x51; // Dresser
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x44')) bpopen[6]=0x51; // Dresser
   if ((items[i].id1=='\x0A')&&(items[i].id2=='\x35')) bpopen[6]=0x51; // Dresser
   // Wooden Chests
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x42')) bpopen[6]=0x49; // Wooden & Gold Chest
   if ((items[i].id1=='\x0E')&&(items[i].id2=='\x43')) bpopen[6]=0x49; // Wooden & Gold Chest
   // Bank box
   if ((items[i].id1=='\x09')&&(items[i].id2=='\xB2') && items[i].morex==1) bpopen[6]=0x4A; // Bank box

   xsend(s, bpopen, 12, 0);
 for (i=0;i<contsp[serhash].max;i++)
 {
   ci=contsp[serhash].pointer[i];
   if ((ci!=-1) && (items[ci].contserial==serial) && (items[ci].free==0))
  {
   //fix location of items if they mess up. (needs tweaked for container types)
   if (items[ci].x>150) items[ci].x=150;
   if (items[ci].y>140) items[ci].y=140;
   //end fix
   bpitem[0]=items[ci].ser1;
   bpitem[1]=items[ci].ser2;
   bpitem[2]=items[ci].ser3;
   bpitem[3]=items[ci].ser4;
   bpitem[4]=items[ci].id1;
   bpitem[5]=items[ci].id2;
   bpitem[7]=items[ci].amount/256;
   bpitem[8]=items[ci].amount%256;
   bpitem[9]=items[ci].x/256;
   bpitem[10]=items[ci].x%256;
   bpitem[11]=items[ci].y/256;
   bpitem[12]=items[ci].y%256;
   bpitem[13]=a1;
   bpitem[14]=a2;
   bpitem[15]=a3;
   bpitem[16]=a4;
   bpitem[17]=items[ci].color1;
   bpitem[18]=items[ci].color2;
   bpitem[21]=items[ci].decaytime=0;// reseting the decaytimer in the backpack
   xsend(s, bpitem, 19, 0);
  }
 }
// xsend(s, restart, 2, 0);
}

void backpack2(int s, int a1, int a2, int a3, int a4) // Send corpse stuff
{
 int i, count=0, count2,serial,serhash,ci;
 char bpopen2[6]="\x3C\x00\x05\x00\x00";
 char display1[8]="\x89\x00\x0D\x40\x01\x02\x03";
 char display2[6]="\x01\x40\x01\x02\x03";

  serial=calcserial(a1,a2,a3,a4);
  serhash=serial%256;
 for (i=0;i<contsp[serhash].max;i++)
 {
   ci=contsp[serhash].pointer[i];
   if ((ci!=-1) && (items[ci].contserial==serial) && (items[ci].layer!=0) && (items[ci].free==0))
  {
  count++;
  }
 }
// printf("Count=%i\n", count);
 count2=(count*5)+7 + 1 ; // 5 bytes per object, 7 for this header and 1 for
                          // terminator
 display1[1]=count2/256;
 display1[2]=count2%256;
 display1[3]=a1;
 display1[4]=a2;
 display1[5]=a3;
 display1[6]=a4;
 xsend(s, display1, 7, 0);
 for (i=0;i<contsp[serhash].max;i++)
 {
   ci=contsp[serhash].pointer[i];
   if ((ci!=-1) && (items[ci].contserial==serial) && (items[ci].layer!=0))
  {
   display2[0]=items[ci].layer;
   display2[1]=items[ci].ser1;
   display2[2]=items[ci].ser2;
   display2[3]=items[ci].ser3;
   display2[4]=items[ci].ser4;
   xsend(s, display2, 5, 0);
  }
 }

// Terminate with a 0
  char nul = 0;
  xsend(s, &nul, 1, 0);

// printf("Items: %i\n",count);
 bpopen2[3]=count/256;
 bpopen2[4]=count%256;
 count2=(count*19)+5;
 bpopen2[1]=count2/256;
 bpopen2[2]=count2%256;
// xsend(s, pause, 2, 0);
 xsend(s, bpopen2, 5, 0);
 for (i=0;i<contsp[serhash].max;i++)
 {
   ci=contsp[serhash].pointer[i];
   if ((ci!=-1) && (items[ci].contserial==serial) && (items[ci].layer!=0))
  {
   bpitem[0]=items[ci].ser1;
   bpitem[1]=items[ci].ser2;
   bpitem[2]=items[ci].ser3;
   bpitem[3]=items[ci].ser4;
   bpitem[4]=items[ci].id1;
   bpitem[5]=items[ci].id2;
   bpitem[7]=items[ci].amount/256;
   bpitem[8]=items[ci].amount%256;
   bpitem[9]=items[ci].x/256;
   bpitem[10]=items[ci].x%256;
   bpitem[11]=items[ci].y/256;
   bpitem[12]=items[ci].y%256;
   bpitem[13]=a1;
   bpitem[14]=a2;
   bpitem[15]=a3;
   bpitem[16]=a4;
   bpitem[17]=items[ci].color1;
   bpitem[18]=items[ci].color2;
   bpitem[21]=items[ci].decaytime=0;// reseting the decaytimer in the backpack
   xsend(s, bpitem, 19, 0);
  }
 }
// xsend(s, restart, 2, 0);
}

void sendbpitem(int s, int i) // Update single item in backpack
{
 int x1,x2,x3,x4,j,x,c,change,serial;

 char display3[2]="\x25";

 bpitem[0]=items[i].ser1;
 bpitem[1]=items[i].ser2;
 bpitem[2]=items[i].ser3;
 bpitem[3]=items[i].ser4;
 bpitem[4]=items[i].id1;
 bpitem[5]=items[i].id2;
 bpitem[7]=items[i].amount/256;
 bpitem[8]=items[i].amount%256;
 bpitem[9]=items[i].x/256;
 bpitem[10]=items[i].x%256;
 bpitem[11]=items[i].y/256;
 bpitem[12]=items[i].y%256;
 bpitem[13]=items[i].cont1;
 bpitem[14]=items[i].cont2;
 bpitem[15]=items[i].cont3;
 bpitem[16]=items[i].cont4;
 bpitem[17]=items[i].color1;
 bpitem[18]=items[i].color2;
 bpitem[21]=items[i].decaytime=0; // reseting the decaytimer in the backpack

// we need to find the topmost container that the item is in
// be it a character or another container.

 c = -1;
 x = -1;
 x1 = items[i].cont1;
 x2 = items[i].cont2;
 x3 = items[i].cont3;
 x4 = items[i].cont4;
 serial=items[i].contserial=calcserial(x1,x2,x3,x4);  //error correcting code
 do
 {
  change=0;
  if (x1>=0x40)
  {
     j=findbyserial(&itemsp[serial%256], serial, 0);
     if (j!=-1)
     {
      x = j;
      change=1;
      x1 = items[j].cont1;
      x2 = items[j].cont2;
      x3 = items[j].cont3;
      x4 = items[j].cont4;
      serial=items[j].contserial=calcserial(x1,x2,x3,x4);  //error correcting code
     }
  }
  else
  {
    j=findbyserial(&charsp[serial%256], serial, 1);
    if (j!=-1)
    {
      change=1;
      c = j;
      x1 = 255;
    }
  }
 } while (x1!=255 && change==1);
 if (!change)
 {
  printf("UOX3: Sendbpitem bug. Item %i not in container.\n",serial);
  return;
 }
 if (((c!=-1)&&(inrange1p(currchar[s],c)))|| // if item is in a character's
                                       //pack (or subcontainer) and player is in range
     ((c==-1)&&(inrange2(s,x))))  // or item is in container on ground and
                                      // container is in range
 {
  xsend(s, display3, 1, 0);
  xsend(s, bpitem, 19, 0);
 }

// chars[currchar[s]].weight=calcweight(s);
}

void senditem(int s, int i) // Send items (on ground)
{
	int j,pack,serial;
	char itmput[20]="\x1A\x00\x13\x40\x01\x02\x03\x20\x42\x00\x32\x06\x06\x06\x4A\x0A\x00\x00\x00";

	if (items[i].cont1!=255)
	{
		pack=1;
		if (items[i].cont1<0x40)
		{
			serial=items[i].contserial;
			j=findbyserial(&charsp[serial%256], serial, 1);
			if (j!=-1 && chars[j].serial==serial) pack=0;
		}
   if (pack)
   {
     sendbpitem(s,i);
     return;
   }
 }

 if ((items[i].contserial==-1) && (inrange2(s,i)))
 {
  itmput[3]=(items[i].ser1)+0x80; // Enable Piles
  itmput[4]=items[i].ser2;
  itmput[5]=items[i].ser3;
  itmput[6]=items[i].ser4;
  itmput[7]=items[i].id1;
  itmput[8]=items[i].id2;
  itmput[9]=items[i].amount/256;
  itmput[10]=items[i].amount%256;
  itmput[11]=items[i].x/256;
  itmput[12]=items[i].x%256;
  itmput[13]=(items[i].y/256)+0xC0; // Enable Dye and Move
  itmput[14]=items[i].y%256;
  itmput[15]=items[i].z;
  itmput[16]=items[i].color1;
  itmput[17]=items[i].color2;
  itmput[18]=0;
  if (items[i].visible==1)
  {
    if (chars[currchar[s]].serial!=items[i].ownserial)
    {
      itmput[18]+=0x80;
    }
  }
  if (items[i].visible==2)
  {
    itmput[18]+=0x80;
  }
  if (items[i].visible==3)
  {
    if ((chars[currchar[s]].id1==0x03 && chars[currchar[s]].id2==0xDB) || !chars[currchar[s]].priv&1)
         itmput[18]+=0x80;
  }

  if (items[i].magic==1) itmput[18]+=0x20;
  if (chars[currchar[s]].priv2&1) itmput[18]+=0x20;
  if (items[i].magic==3 && chars[currchar[s]].serial==items[i].ownserial)
      itmput[18]+=0x20;
  if (chars[currchar[s]].priv2&4)
  {
   if ((items[i].id1==0x40) && (items[i].id2<=0xFF))
   {
    itmput[7]=0x14;
    itmput[8]=0xf0;
   }
  }
  if (items[i].dir)
  {
   itmput[19]=itmput[18];
   itmput[18]=itmput[17];
   itmput[17]=itmput[16];
   itmput[16]=itmput[15];
   itmput[15]=items[i].dir;
   itmput[2]=0x14;
   itmput[11]+=0x80;
   xsend(s, itmput, 20, 0);
  } else
  {
   itmput[2]=0x13;
   xsend(s, itmput, 19, 0);
  }
  if ((items[i].id1==0x20)&&(items[i].id2==0x06))
  {
   backpack2(s, items[i].ser1, items[i].ser2, items[i].ser3, items[i].ser4);
  }
 }
 //chars[currchar[s]].weight=calcweight(currchar[s]);
 //statwindow(s, currchar[s]);
}

void all_items(int s) // Send ALL items to player
{
 int i;
 for (i=0;i<itemcount;i++) if (items[i].free==0) senditem(s, i);
}

void all_items_all() // Send ALL items to ALL player (Target: Reduce use of this lag-causing function)
{
 int s;
 for (s=0;s<now;s++) all_items(s);
}

void disconnect (int s) // Force disconnection of player
{
 int i, j;

 printf("UOX3: Client %i disconnected. [Total:%i]\n",s,now-1);
 if (usedfree[s]) freelogins++;
 flushbuffer(s);
 closesocket(client[s]);
 if ((chars[currchar[s]].account==acctno[s])&&(server_data.partmsg)) 
 {
    sprintf(temp,"%s has left the realm",chars[currchar[s]].name);
    sysbroadcast(temp);//message upon leaving a server 
 } 
 if (acctno[s]!=-1) acctinuse[acctno[s]]=0; //Bug clearing logged in accounts!
 acctno[s]=-1;
 for (i=0;i<now;i++)
 if ((i!=s)&&(perm[i]))
 {
  removeitem[1]=chars[currchar[s]].ser1;
  removeitem[2]=chars[currchar[s]].ser2;
  removeitem[3]=chars[currchar[s]].ser3;
  removeitem[4]=chars[currchar[s]].ser4;
  xsend(i, removeitem, 5, 0);
 }
 for (j=s;j<now-1;j++)
 {
  client[j]=client[j+1];
  newclient[j]=newclient[j+1];
  currchar[j]=currchar[j+1];
  clientip[j][0]=clientip[j+1][0];
  clientip[j][1]=clientip[j+1][1];
  clientip[j][2]=clientip[j+1][2];
  clientip[j][3]=clientip[j+1][3];
  acctno[j]=acctno[j+1];
//  war[j]=war[j+1];
  perm[j]=perm[j+1];
  addid1[j]=addid1[j+1];
  addid2[j]=addid2[j+1];
  addid3[j]=addid3[j+1];
  addid4[j]=addid4[j+1];
  addx[j]=addx[j+1];
  addy[j]=addy[j+1];
  addz[j]=addz[j+1];
  cryptclient[j]=cryptclient[j+1];
  cryptmask[j][0]=cryptmask[j+1][0];
  cryptmask[j][1]=cryptmask[j+1][1];
 }
 currchar[now]=0;
 now--;
}

void login1(int s) // Initial login (Login on "loginserver", new format)
{
 unsigned long int i, j, tlen, t;
 unsigned long int ip;
 char acctused[3]="\x82\x01";
 char newlist1[7]="\xA8\x01\x23\xFF\x00\x01";
 char newlist2[41]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x01\x7F\x00\x00\x01";

 acctno[s]=-1;
 for (i=0;i<acctcount;i++)
 {
  t=0;
  if (strlen(&buffer[s][1])==strlen(acct[i][0]))
  {
   t=1;
   for (j=0;j<strlen(&buffer[s][1]);j++)
        if (toupper(buffer[s][j+1])!=toupper(acct[i][0][j])) t=0;
   if (strlen(&buffer[s][1])==0) t=0;
  }
  if (t==1) acctno[s]=i;
 }
 if (acctno[s]!=-1)
 {
  psplit(&buffer[s][31]);
  t=0;
  if (strlen(pass1)==strlen(acct[acctno[s]][1]))
  {
   t=1;
   for (j=0;j<strlen(pass1);j++)
        if (toupper(pass1[j])!=toupper(acct[acctno[s]][1][j])) t=0;
   if (strlen(pass1)==0) t=0;
   //if ((acct[acctno[s]][1][0]=='x')&&(acct[acctno[s]][1][1]=='x')&&(acct[acctno[s]][1][2]=='x'))
	 //account banning by Anthracks 1-3-99
		if (((acct[acctno[s]][1][0]=='x')&&(acct[acctno[s]][1][1]=='x')&&(acct[acctno[s]][1][2]=='x')) || acct[acctno[s]][2][0]=='1') // They are banned
        t=2;
  }

  if (t==0)
  {
   acctno[s]=-1;
   xsend(s, nopass, 2, 0);
//   disconnect(s);
  }
  if (t==2)
  {
   acctno[s]=-1;
   xsend(s, acctblock, 2, 0);
//   disconnect(s);
  }
 }
 else
 {
  xsend(s, noaccount, 2, 0);
//  disconnect(s);
 }
 if (acctinuse[acctno[s]])
 {
  acctno[s]=-1;
  xsend(s, acctused, 2, 0);
//  disconnect(s);
 }
 if (acctno[s]!=-1)
 {
#ifndef __NT__
  sprintf(temp,"Client [%i.%i.%i.%i] connected using Account '%s'.\n",(client_addr.sin_addr.s_addr&0x000000ff),(client_addr.sin_addr.s_addr&0x0000ff00)>>8,(client_addr.sin_addr.s_addr&0x00ff0000)>>16,(client_addr.sin_addr.s_addr&0xff000000)>>24,&buffer[s][1]);
#else
  sprintf(temp,"Client [%i.%i.%i.%i] connected using Account '%s'.\n",client_addr.sin_addr.S_un.S_un_b.s_b1 _ client_addr.sin_addr.S_un.S_un_b.s_b2 _ client_addr.sin_addr.S_un.S_un_b.s_b3 _ client_addr.sin_addr.S_un.S_un_b.s_b4,&buffer[s][1]);
#endif
  savelog(temp,"server.log");

  acctinuse[acctno[s]]=1;
  tlen=6+(servcount*40);
  newlist1[1]=tlen/256;
  newlist1[2]=tlen%256;
  newlist1[4]=servcount/256;
  newlist1[5]=servcount%256;
  xsend(s, newlist1, 6, 0);
  for (i=0;i<servcount;i++)
  {
   newlist2[0]=i/256;
   newlist2[1]=i%256;
   sprintf(&newlist2[2], "%s", serv[i][0]);
   ip=inet_addr(serv[i][1]);
   newlist2[39]=(char) (ip/16777216);
   newlist2[38]=(char) (ip/65536);
   newlist2[37]=(char) (ip/256);
   newlist2[36]=(char) (ip%256);
   xsend(s, newlist2, 40, 0);
  }
 }
}

void relay(int s) // Relay player to a certain IP
{
 unsigned long int ip;

 ip=inet_addr(serv[buffer[s][2]][1]);
 login03[4]=(char) (ip/16777216);
 login03[3]=(char) (ip/65536);
 login03[2]=(char) (ip/256);
 login03[1]=(char) (ip%256);
 login03[5]=UOX_PORT/256;
 login03[6]=UOX_PORT%256;
 srand(ip+acctno[s]+now+getclock()); // Perform randomize
 login03[7]=127;
 login03[8]=0;
 login03[9]=0;
 login03[10]=1;
 xsend(s, login03, 11, 0);
}

void goodauth(int s)
{
 int i, j, tlen;

 tlen=4+(5*60)+1+(startcount*63);
 login04a[1]=tlen/256;
 login04a[2]=tlen%256;
 login04a[3]=5;
 xsend(s, login04a, 4, 0);
 j=0;
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].account==acctno[s])&&(chars[i].free==0))
  //if (chars[i].account==acctno[s])
  {
//   for (k=0;k<strlen(chars[i].name);k++) login04b[k]=chars[i].name[k];
   sprintf(login04b, chars[i].name);
   xsend(s, login04b, 60, 0);
   j++;
  }
 }
 for (i=0;i<60;i++) login04b[i]=0;
 for (i=j;i<5;i++)
 {
  xsend(s, login04b, 60, 0);
 }
 buffer[s][0]=startcount;
 xsend(s, buffer[s], 1, 0);
 for (i=0;i<startcount;i++)
 {
  login04d[0]=i;
  for (j=0;j<=strlen(start[i][0]);j++) login04d[j+1]=start[i][0][j];
  for (j=0;j<=strlen(start[i][1]);j++) login04d[j+32]=start[i][1][j];
  xsend(s, login04d, 63, 0);
 }
}

void failauth(int s)
{
 char noauth[3]="\x53\x01";

 xsend(s, noauth, 2, 0); // Say "Character doesnt exist" and close client
 disconnect(s);
 return;
}

void authtest(int s)
{
 int auth;
 char answer[3];

 auth=1;
 recv(server[s], answer, 2, 0);
 if ((answer[0]!=0xA8)&&(answer[0]!=0x81)) auth=0;
 closesocket(server[s]);
 server[s]=-1;
 if (auth)
 {
  printf("AUTH: Authentication successful\n");
  goodauth(s);
 }
 else
 {
  printf("AUTH: Authentication failed\n");
  failauth(s);
 }
// sysbroadcast("Normal server operation resumed.");
}

void charlist(int s) // Gameserver login and character listing
{
 int i, j, t;
#ifdef LSERVCHECK
#ifdef NOSINGLEONLY
 int ls, ls2, auth;
 int lcode, positive;
 char verify1[5]="\x12\x34\x56\x78";
// char verify1[5]="\xC2\xC3\xCA\x6C";
 char verify2[63]="\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
#endif
#endif

 acctno[s]=-1;
 for (i=0;i<acctcount;i++)
 {
  t=0;
  if (strlen(&buffer[s][5])==strlen(acct[i][0]))
  {
   t=1;
   for (j=0;j<strlen(&buffer[s][5]);j++)
        if (toupper(buffer[s][j+5])!=toupper(acct[i][0][j])) t=0;
   if (strlen(&buffer[s][5])==0) t=0;
  }
  if (t==1) acctno[s]=i;
 }
 if (acctno[s]!=-1)
 {
  psplit(&buffer[s][35]);
  t=0;
  if (strlen(pass1)==strlen(acct[acctno[s]][1]))
  {
   t=1;
   for (j=0;j<strlen(pass1);j++)
        if (toupper(pass1[j])!=toupper(acct[acctno[s]][1][j])) t=0;
   if (strlen(pass1)==0) t=0;
   if ((acct[acctno[s]][1][0]=='x')&&(acct[acctno[s]][1][1]=='x')&&(acct[acctno[s]][1][2]=='x'))
        t=2;
  }

  if (t==0)
  {
   acctno[s]=-1;
   xsend(s, nopass, 2, 0);
   disconnect(s);
   return;
  }
  if (t==2)
  {
   acctno[s]=-1;
   xsend(s, acctblock, 2, 0);
   disconnect(s);
   return;
  }
 }
 else
 {
  xsend(s, noaccount, 2, 0);
  disconnect(s);
  return;
 }
 if (acctno[s]==0) goodauth(s);
 else
 {
#ifdef LSERVCHECK
#ifdef NOSINGLEONLY
  auth=1;
  if (acctno[s]!=0)
//  sysbroadcast("Excuse the delay, player logging in.");
   ls=0;
   positive=0;
   do
   {
   server[s]=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
   connection.sin_family=AF_INET;
   if ((ls==0)||(ls==1))
   {
    connection.sin_addr.s_addr=0xE1D218DD; // Encrypted IP adress of loginserver
   }
   if ((ls==2)||(ls==3))
   {
    connection.sin_addr.s_addr=0xF0D218DD;
   }
   connection.sin_addr.s_addr=(connection.sin_addr.s_addr^0x9D54F712);
   if ((ls==0)||(ls==2))
   {
    connection.sin_port=0x5F1E;
   }
   if ((ls==1)||(ls==3))
   {
    connection.sin_port=0x601E;
   }
   printf("AUTH: Trying loginserver %i...\n",ls+1);
   len_connection_addr=sizeof (struct sockaddr);
   lcode=connect(server[s],(struct sockaddr *)&connection, len_connection_addr);
   if (lcode>=0)
   {
    positive=1;
   }
   ls++;
  }
  while (! ((ls==4)||(positive)) );
  if (!positive)
  {
   printf("AUTH: Could not connect to loginserver\n");
   if (freelogins>0)
   {
    printf("AUTH: Using offline login for player. (%i out of 4)\n", 5-freelogins);
    freelogins--;
    usedfree[s]=1;
    goodauth(s);
   }
   else
   {
    printf("AUTH: Out of offline logins. Disconnecting player.\n");
    failauth(s);
   }
  }
  else
  {
   printf("AUTH: Connected to loginserver\n");
   gentable(MAXCLIENT+1,0x12,0x34,0x56,0x78);
//   gentable(MAXCLIENT+1, 194, 195, 202, 108);
   send(server[s], verify1, 4, 0);
   verify2[0]=0x80;
   sprintf(&verify2[1], "%s", &buffer[s][5]);
   sprintf(&verify2[31], "%s", pass2);
   verify2[61]=0x12;
   for (ls2=0;ls2<62;ls2++)
   {
    verify2[ls2]=verify2[ls2]^ctable[MAXCLIENT+1][ls2];
   }
   send(server[s], verify2, 62, 0);
  }
#endif
#endif
#ifdef SINGLEONLY
  if (acctno[s]!=0) // This is for single-player testing releases
  {
   printf("AUTH: Only server operator is allowed to login with this version\n");
   failauth(s);
  }
#endif
#ifdef NOLSERVCHECK
  goodauth(s);
#endif
 }
}

void chardel (int s) // Deletion of character
{
 int i, j, k, tlen;

 if (acctno[s]!=-1)
 {
  j=0;
  k=-1;
  for (i=0;i<charcount;i++)
  {
   if ((chars[i].account==acctno[s]&&chars[i].free==0))
   {
    if (j==buffer[s][0x22]) k=i;
    j++;
   }
  }
  if (k!=-1)
  {
   deletechar(k);
  }
  tlen=4+(5*60)+1+(startcount*63);
  login04a[1]=tlen/256;
  login04a[2]=tlen%256;
  xsend(s, login04a, 4, 0);
  j=0;
  for (i=0;i<charcount;i++)
  {
   if ((chars[i].account==acctno[s])&&(chars[i].free==0))
   {
      sprintf(login04b, chars[i].name);
      xsend(s, login04b, 60, 0);
      j++;
   } 

  }
  for (i=0;i<60;i++) login04b[i]=0;
  for (i=j;i<5;i++)
  {
   xsend(s, login04b, 60, 0);
  }
  buffer[s][0]=startcount;
  xsend(s, buffer[s], 1, 0);
  for (i=0;i<startcount;i++)
  {
   login04d[0]=i;
   for (j=0;j<=strlen(start[i][0]);j++) login04d[j+1]=start[i][0][j];
   for (j=0;j<=strlen(start[i][1]);j++) login04d[j+32]=start[i][1][j];
   xsend(s, login04d, 63, 0);
  }
 }
}

void textflags (int s, int i, char *name)
{
 int a1, a2, a3, a4;
 char name2[150];

 a1=chars[i].ser1;
 a2=chars[i].ser2;
 a3=chars[i].ser3;
 a4=chars[i].ser4;
 if (chars[i].townpriv==2) sprintf(name2, "Mayor %s", name);
 else sprintf(name2, "%s", name);
 //if (chars[i].npc) itemmessage(s, "[NPC]", a1, a2, a3, a4);
 if (chars[i].priv&4) strcat(name2, " (invulnerable)");
 if (chars[i].priv2&2) strcat(name2, " (frozen)");
 itemmessage(s, name2, a1, a2, a3, a4);
}

void showcname (int s, int i, char b) // Singleclick text for a character
{
 int a1, a2, a3, a4;
 int c;
 int x;

 a1=chars[i].ser1;
 a2=chars[i].ser2;
 a3=chars[i].ser3;
 a4=chars[i].ser4;
 if ((chars[currchar[s]].priv&8)||b)
 {
  sprintf(temp, "%s [%x %x %x %x]", chars[i].name, a1, a2, a3, a4);
 }
 else
 {
  if (!(chars[i].npc))
  {
   if (!online(i)) sprintf(temp, "%s (OFF)", chars[i].name);
   else sprintf(temp, "%s", chars[i].name);
  }
  else
  {
   temp[0]=0;
   x=0;
//\/ Revert to old code for a sec..testing for bug Krozy mentioned....
/*  while (chars[i].name[x]!=0)
   {
    y=x;
    while (chars[i].name[x]!='_' && chars[i].name[x]!=0) x++;
    strncpy(temp+y,&chars[i].name[y],x-y);
    if (chars[i].name[x]=='_')
    {
     temp[x]=' ';
     x++;
    }
   }
   temp[x]=0; */
        do
         {
         c=chars[i].name[x];
         if (/*(c!=' ')&&*/(c!=0))
          {
          if(c=='_')
       c=' ';
          sprintf(temp, "%s%c", temp, c);
          }
         x++;
         }
        while (/*(chars[i].name[x-1]!=' ')&&*/(c!=0));
//\/
  }
 }
 textflags(s, i, temp);
}

void teleport(int s) // Teleports character to its current set coordinates
{
 int i;
 int k=calcSocketFromChar(s);
 
 for (i=0;i<now;i++)
 if ((perm[i])&&(i!=k))
 {
  removeitem[1]=chars[s].ser1;
  removeitem[2]=chars[s].ser2;
  removeitem[3]=chars[s].ser3;
  removeitem[4]=chars[s].ser4;
  xsend(i, removeitem, 5, 0);
 }
 if (k!=-1)  // If a player, move them to the appropriate XYZ
 {
  goxyz[1]=chars[s].ser1;
  goxyz[2]=chars[s].ser2;
  goxyz[3]=chars[s].ser3;
  goxyz[4]=chars[s].ser4;
  goxyz[5]=chars[s].id1;
  goxyz[6]=chars[s].id2;
  goxyz[8]=chars[s].skin1;
  goxyz[9]=chars[s].skin2;
  goxyz[10]=0;
  if (chars[s].hidden) goxyz[10]=0x80;
  goxyz[11]=chars[s].x/256;
  goxyz[12]=chars[s].x%256;
  goxyz[13]=chars[s].y/256;
  goxyz[14]=chars[s].y%256;
  goxyz[17]=chars[s].dir|0x80;
  goxyz[18]=chars[s].dispz;
  xsend(k, goxyz, 19, 0);
  all_items(k);
  walksequence[k]=-1;
 }
 for (i=0;i<now;i++) // Send the update to all players.
 {
  // Dupois - had to remove the && (k!=i)), doesn update the client
  // Added Oct 08, 1998
  if ((inrange1p(s, currchar[i]))&&(perm[i]))// && (k!=i)) // If inrange, and a player
  {
   impowncreate(i, s, 1);
  }
 }
 if (k!=-1)
 {
  for (i=0;i<charcount;i++)
  { //Tauriel only send inrange people (walking takes care of out of view)
   if ((online(i)||chars[i].npc||(chars[s].priv&1))&&(s!=i)&&(inrange1p(s, i)))
   {
    impowncreate(k, i, 1);
   }
  }
  if (perm[k]) dolight(k, worldcurlevel);
 }
 checkregion(s);
}

void checktele(int s)
{
 if ((chars[currchar[s]].x==1296)&&(chars[currchar[s]].y==1081))
  {
        chars[currchar[s]].x=5587;
        chars[currchar[s]].y=631;
        chars[currchar[s]].z=0;
        chars[currchar[s]].dispz=0;
        teleport(currchar[s]);
  }
}

void updatechar(int c) // If character status has been changed (Polymorph), resend him
{
 int i;

 for (i=0;i<now;i++)
 if (perm[i])
 {
  removeitem[1]=chars[c].ser1;
  removeitem[2]=chars[c].ser2;
  removeitem[3]=chars[c].ser3;
  removeitem[4]=chars[c].ser4;
  xsend(i, removeitem, 5, 0);
  if (currchar[i]==c)
  {
   goxyz[1]=chars[c].ser1;
   goxyz[2]=chars[c].ser2;
   goxyz[3]=chars[c].ser3;
   goxyz[4]=chars[c].ser4;
   goxyz[5]=chars[c].id1;
   goxyz[6]=chars[c].id2;
   goxyz[8]=chars[c].skin1;
   goxyz[9]=chars[c].skin2;
   goxyz[10]=0;
   if (chars[c].hidden) goxyz[10]=0x80;
   goxyz[11]=chars[c].x/256;
   goxyz[12]=chars[c].x%256;
   goxyz[13]=chars[c].y/256;
   goxyz[14]=chars[c].y%256;
   goxyz[17]=chars[c].dir|0x80;
   goxyz[18]=chars[c].z;
   xsend(i, goxyz, 19, 0);
   walksequence[i]=-1;
   all_items(i);
  }
  if (inrange1p(c, currchar[i]))
  {
   impowncreate(i, c, 0);
  }
 }
}

void gumpmenu(int s, int m)
{
 char sect[512];
 short int length, length2, textlines=0;
 int i;

 openscript("misc.scp");
 sprintf(sect, "GUMPMENU %i", m);
 if (!misc_script.find(sect))
 {
  closescript();
  return;
 }
 length=21;
 length2=1;
 do
 {
  read1();
  if (script1[0]!='}')
  {
   length+=strlen(script1)+4;
   length2+=strlen(script1)+4;
  }
 }
 while (script1[0]!='}');
 length+=3;
 sprintf(sect, "GUMPTEXT %i", m);
 if (!misc_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read1();
  if (script1[0]!='}')
  {
   length+=(strlen(script1)*2)+2;
   textlines++;
  }
 }
 while (script1[0]!='}');
 gump1[1]=length/256;
 gump1[2]=length%256;
 gump1[3]=chars[currchar[s]].ser1;
 gump1[4]=chars[currchar[s]].ser2;
 gump1[5]=chars[currchar[s]].ser3;
 gump1[6]=chars[currchar[s]].ser4;
 gump1[7]=0;
 gump1[8]=0;
 gump1[9]=0;
 gump1[10]=0x12; // Gump Number
 gump1[19]=length2/256;
 gump1[20]=length2%256;
 xsend(s, gump1, 21, 0);
 sprintf(sect, "GUMPMENU %i", m);
 if (!misc_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read1();
  if (script1[0]!='}')
  {
   sprintf(sect, "{ %s }", script1);
   xsend(s, sect, strlen(sect), 0);
  }
 }
 while (script1[0]!='}');
 gump2[1]=textlines/256;
 gump2[2]=textlines%256;
 xsend(s, gump2, 3, 0);
 sprintf(sect, "GUMPTEXT %i", m);
 if (!misc_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read1();
  if (script1[0]!='}')
  {
   gump3[0]=strlen(script1)/256;
   gump3[1]=strlen(script1)%256;
   xsend(s, gump3, 2, 0);
   gump3[0]=0;
   for (i=0;i<strlen(script1);i++)
   {
    gump3[1]=script1[i];
    xsend(s, gump3, 2, 0);
   }
  }
 }
 while (script1[0]!='}');
 closescript();
}

//BEGIN TOWNSTONE FUNCTIONS. LAST UPDATED ON AUG 26, 1998
//PLEASE DO NOT MODIFY THESE FUNCTIONS.  I (Krozy) will add functionality
//to them.  I have the plans for townstones worked out, and would
//appreciate it if nobody 'ruined' it by making changes.  In the event I
//do not update the townstone code over a period of 45 days, then you
//may assume that I have left the uox project. -Krozy

void towncalcnewmayor(int j)
{
 //j = the town (region), not the item.
 int a,b,c=0,d=0,e=0,s1,s2,s3,s4;
 struct tm *newtime;
 time_t aclock;
 newtime = localtime(&aclock);
 for(a=0;a<charcount;a++) {
  if(chars[a].town==0) {
   chars[a].townpriv=0;
   chars[a].towntitle=0;
  }
  if(chars[a].town==j) {
   if(chars[a].townpriv==2) chars[a].townpriv=1; //reset current mayor.
   for(b=0;b<charcount;b++) {
    if((chars[b].town==j)&&
       (chars[b].townvote1==chars[a].ser1)&&
       (chars[b].townvote2==chars[a].ser2)&&
       (chars[b].townvote3==chars[a].ser3)&&
       (chars[b].townvote4==chars[a].ser4)) {
     c++; //c is the number of votes that chars[a] has.
    }
   }
   if(c>d){ //if number of votes is higher then max then
    d=c; //set new max votes
    e=((chars[a].ser1*16777216)+(chars[a].ser2*65536)+(chars[a].ser3*256)+(chars[a].ser4));
   }
  }
 }
 //Handle wilderness Townstones
 if(townname(j,3)=="the wilderness") e=0;

 //Set all townstones in this region to have the new mayor.
 c=newtime->tm_mday; //we're going to set all townstones in this region
 d=newtime->tm_wday; //to the most recent update time.
 for(a=0;a<itemcount;a++) {
  if ((items[a].id1==0x0E)&&((items[a].id2==0xDD)||(items[a].id2==0xDE))) {
   b=calcRegionFromXY(items[a].x, items[a].y);
   if(b==j) {
    items[a].morex=e;
    items[a].morey=c;
    items[a].morez=d;
   }
  }
 }
 //Set the Town privledges of the new mayor to '2'.
 s1=(e/16777216);
 s2=(e/65536);
 s3=(e/256);
 s4=(e%256);
 for(a=0;a<charcount;a++) {
  if((chars[a].ser1==s1)&&
     (chars[a].ser2==s2)&&
     (chars[a].ser3==s3)&&
     (chars[a].ser4==s4)) {
   chars[a].townpriv=2;
   chars[a].towntitle=1;
  }
 }
}

void towninit(void){
 int a,b,c;
 struct tm *newtime;
 time_t aclock;
 time(&aclock);
 newtime = localtime(&aclock);

 //get real life day of month
 b = newtime->tm_mday;
 //get real weekday
 c = newtime->tm_wday;

 //repair any messed up npcs!
 for(a=0;a<charcount;a++) {
  if(chars[a].npc) {
   chars[a].town=0;
   chars[a].townvote1=0;
   chars[a].townvote2=0;
   chars[a].townvote3=0;
   chars[a].townvote4=0;
   chars[a].towntitle=0;
   chars[a].townpriv=0;
  }
 }

 for(a=0;a<itemcount;a++){
  if ((items[a].id1==0x0E)&&((items[a].id2==0xDD)||(items[a].id2==0xDE))) {
   if((items[a].morey!=b)&&(items[a].morez==c)) {
    //Weekday is the same, but its not the same day of the month, so
    //a week must have passed.
    items[a].morey=b;
    items[a].morez=c;
    towncalcnewmayor(calcRegionFromXY(items[a].x, items[a].y));
   }
  }
 }
}

char *townname(int x, int type)
{
 char *s;
 char checkword[4]="of ";
 int calcreg,len;
 //checkword="of ";
 len = strlen(checkword);
 if (type==1) { //GET TOWNNAME FROM THIS OBJECT.
  calcreg=calcRegionFromXY(items[x].x, items[x].y);
 } else
 if (type==2) { //GET TOWNNAME FROM THIS CHARACTER (GM /townname COMMAND).
  calcreg=calcRegionFromXY(chars[currchar[x]].x, chars[currchar[x]].y);
 } else {
  calcreg=x;    //GET TOWNNAME FROM THIS REGION (ALL OTHERS)
 }
 sprintf(temp, "%s", region[calcreg].name);
 if ((s = strstr(temp,checkword))!= NULL) {
  for (len=len;len > 0;len--) s++;
 } else {
  return "the wilderness";
 }
 return s;
}

char *townmayor(int j)
{
 char *s=NULL;
 int a,s1,s2,s3,s4;
 if(items[j].morex==0) {
  s="unruled region";
 } else {
  s1=((items[j].morex)/16777216);
  s2=((items[j].morex)/65536);
  s3=((items[j].morex)/256);
  s4=((items[j].morex)%256);
  for (a=0;a<charcount;a++) {
   if((chars[a].ser1==s1)&&
      (chars[a].ser2==s2)&&
      (chars[a].ser3==s3)&&
      (chars[a].ser4==s4)) {
    s=strstr(chars[a].name,chars[a].name);
   }
  }
 }
 return s;
}

char *townmayorvote(int s)
{
 int i;
 char *t;
 t="none";
 for (i=0;i<charcount;i++) {
  if ((chars[i].ser1==chars[currchar[s]].townvote1)&&
      (chars[i].ser2==chars[currchar[s]].townvote2)&&
      (chars[i].ser3==chars[currchar[s]].townvote3)&&
      (chars[i].ser4==chars[currchar[s]].townvote4)) {
   t=chars[i].name;
  }
 }
 return t;
}

int townpopulation(int j)
{
 int a=0, b=0;
 for (a=0;a<charcount;a++) {
  if(chars[a].town==j) b++;
 }
 if(townname(j,3)=="the wilderness") b=-1;
 return b;
}

void townvoteformayortarget(int s)
{
  int i,serial,serhash,ci;
  char temp2[512];

  serial=calcserial(buffer[s][7], buffer[s][8], buffer[s][9], buffer[s][10]);
  serhash=serial%256;
  for (ci=0;ci<charsp[serhash].max;ci++)
  {
    i=charsp[serhash].pointer[ci];
    if ((i!=-1) && (chars[i].serial==serial))
    {
      if(chars[i].town==chars[currchar[s]].town)
      {
        chars[currchar[s]].townvote1=buffer[s][7];
        chars[currchar[s]].townvote2=buffer[s][8];
        chars[currchar[s]].townvote3=buffer[s][9];
        chars[currchar[s]].townvote4=buffer[s][10];
        sprintf(temp2, "You have voted for %s to be Mayor of %s", chars[i].name, townname(chars[i].town,3));
        sysmessage(s, temp2);
      }
      else
      {
        sysmessage(s, "The person you have voted for is not of your town.");
      }
      return;
    }
  }
  sysmessage(s,"That is not a person.");
}

void townline(int line, int j, char type, int s)
{
 //type will be used for privledges by player (non, resident, mayor, etc..)
 //0 = nonresident, 1 = resident, 2 = mayor, 3 = town council, 4 = guard,
 //5 = guard captain, 6 = merchant, 7 = head merchant, 8 = clergy
 line--; if (line==0) sprintf(script1, "nomove");
 line--; if (line==0) sprintf(script1, "noclose");
 line--; if (line==0) sprintf(script1, "page 0");
 line--; if (line==0) sprintf(script1, "resizepic 0 0 5120 290 350");    //The background
 line--; if (line==0) sprintf(script1, "button 20 310 2130 2129 1 0 1"); //OKAY
 line--; if (line==0) sprintf(script1, "text 80 310 500 0");            //Phase info
 line--; if (line==0) sprintf(script1, "page 1");
 line--; if (line==0) sprintf(script1, "text 20 10 500 1");   //Townstone for <townname>
 line--; if (line==0) sprintf(script1, "gumppic 10 50 1141"); //Mayor
 line--; if (line==0) sprintf(script1, "text 20 51 0 2");
 line--; if (line==0) sprintf(script1, "text 120 51 0 3");
 line--; if (line==0) sprintf(script1, "gumppic 10 70 1141"); //Population
 line--; if (line==0) sprintf(script1, "text 20 71 0 4");
 line--; if (line==0) sprintf(script1, "text 120 71 0 5");
 line--; if (line==0) sprintf(script1, "button 10 120 2151 2152 1 0 2");  //Leave or Join
 line--; if (line==0) sprintf(script1, "text 50 125 500 6");
 if(type>0) {
  line--; if (line==0) sprintf(script1, "button 10 150 2151 2152 1 0 3"); //Toggle Town Title
  line--; if (line==0) sprintf(script1, "text 50 155 500 7");
  if(townname(j,1)!="the wilderness") {
   line--; if(line==0) sprintf(script1, "button 10 180 2151 2152 1 0 4"); //Vote for Mayor
   line--; if(line==0) sprintf(script1, "text 50 185 500 8");
   line--; if(line==0) sprintf(script1, "text 50 205 500 9");
   line--; if(line==0) sprintf(script1, "text 50 225 500 10");
  }
 }
 line--; if (line==0) sprintf(script1, "}"); //Terminate it
}

void towntext(int line, int j, char type, int s)
{
 //type will be used for privledges by player (non, resident, mayor, etc..)
 //0 = nonresident, 1 = resident, 2 = mayor, 3 = town council, 4 = guard,
 //5 = guard captain, 6 = merchant, 7 = head merchant, 8 = clergy
 char town[80];
 int townpop;
 sprintf(town,"%s",townname(j,1));
 townpop=townpopulation(calcRegionFromXY(items[j].x, items[j].y));
 line--; if (line==0) sprintf(script1,"Townstones Phase 1 of 7");
 line--; if (line==0) sprintf(script1,"Townstone for %s", town);
 line--; if (line==0) sprintf(script1,"Mayor");
 //line--; if (line==0) sprintf(script1,"%s", townmayor(calcRegionFromXY(items[j].x, items[j].y)));
 line--; if (line==0) sprintf(script1,"%s", townmayor(j));
 line--; if (line==0) sprintf(script1,"Population");
 if(townpop>=0) {
  line--; if (line==0) sprintf(script1,"%i", townpop);
 } else {
  line--; if (line==0) sprintf(script1,"unknown");
 }
 line--; if (line==0) {
  if(townname(j,1)!="the wilderness") {
   if(type<1) {
    sprintf(script1, "Become a resident of %s", townname(j,1));
   } else {
    sprintf(script1, "Leave residency of %s", townname(j,1));
   }
  } else {
   if(type<1) {       //Non-Residents get 1 option.
    sprintf(script1, "Become a resident of the wild.");
   } else {           //Residency option #1
    sprintf(script1, "Leave residency of the wild.");
   }
  }
 }
 if (type>0) {        //List all options for residents.
  line--; if (line==0) {
   if(chars[currchar[s]].towntitle) {
    sprintf(script1, "Toggle Town Title off");
   } else {
    sprintf(script1, "Toggle Town Title on");
   }
  }
  if(townname(j,1)!="the wilderness") {
   line--; if (line==0) sprintf(script1, "Vote for Mayor");
   line--; if (line==0) sprintf(script1, "Currently voting for:");
   line--; if (line==0) sprintf(script1, "%s", townmayorvote(s));
  }
 }
 line--; if (line==0) sprintf(script1,"}"); //Terminate it
}

void townmenu(int s, int j, int type)
{
 char sect[512];
 short int length, length2, textlines;
 int i;
 int line;
 int townpriv=0;

 //Set the townpriv dependent upon their privledges and their town vs. the
 //region of the stone.  If they are not a member of this town or any town
 //they are considered a 'non-resident', which holds the value of 0, which
 //has been defined above.
 //Currently this doesnt check for all wilderness areas as one.. but..
 //since wilderness people can only be a wilderness resident or toggle
 //their title, it doesnt mean much since if their region doesn't match,
 //they can change to the region of the stone they are using, and set their
 //title again.
 if((calcRegionFromXY(items[j].x,items[j].y))==(chars[currchar[s]].town)) {
  //They are a resident of this Townstone, set townpriv to their priv.
  townpriv=chars[currchar[s]].townpriv;
 }

 length=21;
 length2=1;
 line=0;
 do
 {
  line++;
  townline(line, j, townpriv, s);
  if (script1[0]!='}')
  {
   length+=strlen(script1)+4;
   length2+=strlen(script1)+4;
  }
 }
 while (script1[0]!='}');
 length+=3;
 textlines=0;
 line=0;
 do
 {
  line++;
  towntext(line, j, townpriv, s);
  if (script1[0]!='}')
  {
   length+=(strlen(script1)*2)+2;
   textlines++;
  }
 }
 while (script1[0]!='}');
 gump1[1]=length/256;
 gump1[2]=length%256;
 //type3
 gump1[3]=items[j].ser1;
 gump1[4]=items[j].ser2;
 gump1[5]=items[j].ser3;
 gump1[6]=items[j].ser4;
 //type3
 gump1[7]=0;
 gump1[8]=0;
 gump1[9]=0;
 gump1[10]=type; // Gump Number
 gump1[19]=length2/256;
 gump1[20]=length2%256;
 xsend(s, gump1, 21, 0);
 line=0;
 do
 {
  line++;
  townline(line, j, townpriv, s);
  if (script1[0]!='}')
  {
   sprintf(sect, "{ %s }", script1);
   xsend(s, sect, strlen(sect), 0);
  }
 }
 while (script1[0]!='}');
 gump2[1]=textlines/256;
 gump2[2]=textlines%256;
 xsend(s, gump2, 3, 0);
 line=0;
 do
 {
  line++;
  towntext(line, j, townpriv, s);
  if (script1[0]!='}')
  {
   gump3[0]=strlen(script1)/256;
   gump3[1]=strlen(script1)%256;
   xsend(s, gump3, 2, 0);
   gump3[0]=0;
   for (i=0;i<strlen(script1);i++)
   {
    gump3[1]=script1[i];
    xsend(s, gump3, 2, 0);
   }
  }
 }
 while (script1[0]!='}');
}

//END TOWNSTONE FUNCTIONS.-Krozy
void whocommand(int s, int type,int buttonnum)
{
char sect[512];
 short int length, length2, textlines;
 int i,k;
 int line;
 char menuarray[MAXCHARS+50][50];
 char menuarray1[MAXCHARS+50][50];
 unsigned int linecount=0;
 unsigned int linecount1=0,position=40,linenum=6;

		for (k=0;k<buttonnum;k++)
		{
			if(perm[k]) //Keeps NPC's from appearing on the list
			{			
			chars[currchar[k]].name, chars[currchar[k]].ser1, chars[currchar[k]].ser2, chars[currchar[k]].ser3, chars[currchar[k]].ser4;
			}
		}

//--static pages
 sprintf(menuarray[linecount++], "nomove");
 sprintf(menuarray[linecount++], "noclose");
 sprintf(menuarray[linecount++], "page 0");
 sprintf(menuarray[linecount++], "resizepic 0 0 5120 260 280");    //The background
 sprintf(menuarray[linecount++], "button 20 240 2130 2129 1 0 1"); //OKAY
 sprintf(menuarray[linecount++], "text 20 10 300 0");           //text <Spaces from Left> <Space from top> <Length, Color?> <# in order>
 sprintf(menuarray[linecount++], "text 20 30 300 1");

 //--Command Button Page 
 sprintf(menuarray[linecount++], "page 1");
 sprintf(menuarray[linecount++], "text 20 60 300 2");	//goto text
 sprintf(menuarray[linecount++], "button 150 60 1209 1210 1 0 200"); //goto button
 sprintf(menuarray[linecount++], "text 20 80 300 3");	//gettext
 sprintf(menuarray[linecount++], "button 150 80 1209 1210 1 0 201"); //get button
 sprintf(menuarray[linecount++], "text 20 100 300 4");	//Jail text
 sprintf(menuarray[linecount++], "button 150 100 1209 1210 1 0 202"); //Jail button
 sprintf(menuarray[linecount++], "text 20 120 300 5");	//Release text
 sprintf(menuarray[linecount++], "button 150 120 1209 1210 1 0 203"); //Release button
 sprintf(menuarray[linecount++], "text 20 140 300 6");	//Kick user text
 sprintf(menuarray[linecount++], "button 150 140 1209 1210 1 0 204"); //kick button
 sprintf(menuarray[linecount++], "text 20 180 300 7");

				
 length=21;
 length2=1;
 
for(line=0;line<linecount;line++)
 {

  if (strlen(menuarray[line])==0)
	  break;
  {
   length+=strlen(menuarray[line])+4;
   length2+=strlen(menuarray[line])+4;
  }
 }
 
 length+=3;
 textlines=0;
 line=0;

   sprintf(menuarray1[linecount1++], "User %i selected",buttonnum);
   sprintf(menuarray1[linecount1++], "Name: %s",chars[currchar[k]].name);   
   sprintf(menuarray1[linecount1++], "Goto Character:");
   sprintf(menuarray1[linecount1++], "Get Character:");
   sprintf(menuarray1[linecount1++], "Jail Character:");
   sprintf(menuarray1[linecount1++], "Release Character:");
   sprintf(menuarray1[linecount1++], "Kick Character:");
   sprintf(menuarray1[linecount1++], "Serial#[%i %i %i %i]",chars[currchar[k]].ser1,chars[currchar[k]].ser2,chars[currchar[k]].ser3,chars[currchar[k]].ser4);   

   
for(line=0;line<linecount1;line++)
 {

  if (strlen(menuarray1[line])==0)
	  break;
  {
   length+=strlen(menuarray1[line])*2 +2;
   textlines++;
  }
 }

 gump1[1]=length/256;
 gump1[2]=length%256;
 gump1[7]=0;
 gump1[8]=0;
 gump1[9]=0;
 gump1[10]=type; // Gump Number
 gump1[19]=length2/256;
 gump1[20]=length2%256;
 xsend(s, gump1, 21, 0);
 
for(line=0;line<linecount;line++)
 {
   sprintf(sect, "{ %s }", menuarray[line]);
   xsend(s, sect, strlen(sect), 0);
 }
 
 gump2[1]=textlines/256;
 gump2[2]=textlines%256;

xsend(s, gump2, 3, 0);

for(line=0;line<linecount1;line++)
 {
	if (strlen(menuarray1[line])==0)
	  break;
		{
		gump3[0]=strlen(menuarray1[line])/256;
		gump3[1]=strlen(menuarray1[line])%256;
		xsend(s, gump3, 2, 0);
		gump3[0]=0;
			for (i=0;i<strlen(menuarray1[line]);i++)
				{
				gump3[1]=menuarray1[line][i];
				xsend(s, gump3, 2, 0);
				}
		}
	}
}



void whomenu(int s, int type) //WhoList--By Homey-- Thx Zip and Taur helping me on this
	{
char sect[512];
 short int length, length2, textlines;
 int i,k;
 int line;
 char menuarray[MAXCHARS+50][50];
 char menuarray1[MAXCHARS+50][50];
 unsigned int linecount=0;
 unsigned int linecount1=0,pagenum=1,position=40,linenum=1,buttonnum=7;

		for (k=0;k<now;k++)
		{
			if(perm[k]) //Keeps NPC's from appearing on the list
			{
			chars[currchar[k]].name, chars[currchar[k]].ser1, chars[currchar[k]].ser2, chars[currchar[k]].ser3, chars[currchar[k]].ser4;
			}
		}

//--static pages
 sprintf(menuarray[linecount++], "nomove");
 sprintf(menuarray[linecount++], "noclose");
 sprintf(menuarray[linecount++], "page 0");
 sprintf(menuarray[linecount++], "resizepic 0 0 5120 320 340");    //The background
 sprintf(menuarray[linecount++], "button 20 300 2130 2129 1 0 1"); //OKAY
 sprintf(menuarray[linecount++], "text 20 10 300 0");           //text <Spaces from Left> <Space from top> <Length, Color?> <# in order>

 
sprintf(menuarray[linecount++], "page %i",pagenum);
 //--Start User List
for(i=0;i<k;i++)
	{
	if(i>0 && (!(i%10)))
		{
		position=40;
		pagenum++;
		sprintf(menuarray[linecount++], "page %i",pagenum);
		}
	sprintf(menuarray[linecount++], "text 40 %i 300 %i",position,linenum); //usernames
	sprintf(menuarray[linecount++], "button 20 %i 1209 1210 1 0 %i",position,buttonnum);
	position+=20;
	linenum++;
	buttonnum++;
	}

 pagenum=1; //lets make some damn buttons
 for (i=0;i<k;i+=10)
 {
	sprintf(menuarray[linecount++], "page %i", pagenum);
	if (i>=10)
 		sprintf(menuarray[linecount++], "button 150 300 2223 2223  0 %i",pagenum-1); //back button
 	if ((k>10) && ((i+10)<k))
 		sprintf(menuarray[linecount++], "button %i 300 2224 2224  0 %i", 150+(20*(pagenum>1)),pagenum+1); //forward button
 	pagenum++;
 }		

				
 length=21;
 length2=1;
 
for(line=0;line<linecount;line++)
 {

  if (strlen(menuarray[line])==0)
	  break;
  {
   length+=strlen(menuarray[line])+4;
   length2+=strlen(menuarray[line])+4;
  }
 }
 
 length+=3;
 textlines=0;
 line=0;

   sprintf(menuarray1[linecount1++], "Users currently online: %i",k);
  
   
   //Start user list
for(i=0;i<k;i++)
sprintf(menuarray1[linecount1++], "Users %i Name: %s",i,chars[currchar[i]].name);
   
for(line=0;line<linecount1;line++)
 {

  if (strlen(menuarray1[line])==0)
	  break;
  {
   length+=strlen(menuarray1[line])*2 +2;
   textlines++;
  }
 }
 
 gump1[1]=length/256;
 gump1[2]=length%256;
 gump1[7]=0;
 gump1[8]=0;
 gump1[9]=0;
 gump1[10]=type; // Gump Number
 gump1[19]=length2/256;
 gump1[20]=length2%256;
 xsend(s, gump1, 21, 0);
 
for(line=0;line<linecount;line++)
 {
   sprintf(sect, "{ %s }", menuarray[line]);
   xsend(s, sect, strlen(sect), 0);
 }
 
 gump2[1]=textlines/256;
 gump2[2]=textlines%256;

xsend(s, gump2, 3, 0);

for(line=0;line<linecount1;line++)
 {
	if (strlen(menuarray1[line])==0)
	  break;
		{
		gump3[0]=strlen(menuarray1[line])/256;
		gump3[1]=strlen(menuarray1[line])%256;
		xsend(s, gump3, 2, 0);
		gump3[0]=0;
			for (i=0;i<strlen(menuarray1[line]);i++)
				{
				gump3[1]=menuarray1[line][i];
				xsend(s, gump3, 2, 0);
				}
		}
	}
}


void tline(int line, int j, char type)
{
 line--; if (line==0) sprintf(script1, "page 0");
 line--; if (line==0) sprintf(script1,"resizepic 0 0 2520 400 350");
 line--; if (line==0) sprintf(script1, "text 40 10 32 0");
 line--; if (line==0) sprintf(script1,"button 35 280 2130 2129 1 0 1");
 if (type==1) { line--; if (line==0) sprintf(script1, "tilepic 300 180 %i", (items[j].id1*256)+items[j].id2); }
 line--; if (line==0) sprintf(script1, "page 1");
 if (type==1)
 {
  line--; if (line==0) sprintf(script1, "button 366 320 2224 2224 0 2");
  line--; if (line==0) sprintf(script1, "text 288 317 32 1");
 }
 line--; if (line==0) sprintf(script1, "text 90 70 0 3");
 line--; if (line==0) sprintf(script1, "text 160 70 16 4");
 line--; if (line==0) sprintf(script1, "button 30 70 2116 2115 1 0 2");
 line--; if (line==0) sprintf(script1, "text 90 95 0 5");
 line--; if (line==0) sprintf(script1, "text 160 95 16 6");
 line--; if (line==0) sprintf(script1, "button 30 95 2116 2115 1 0 3");
 line--; if (line==0) sprintf(script1, "text 90 120 0 7");
 line--; if (line==0) sprintf(script1, "text 160 120 16 8");
 line--; if (line==0) sprintf(script1, "button 30 120 2116 2115 1 0 4");
 line--; if (line==0) sprintf(script1, "text 90 145 0 9");
 line--; if (line==0) sprintf(script1, "text 160 145 16 10");
 line--; if (line==0) sprintf(script1, "button 30 145 2116 2115 1 0 5");
 line--; if (line==0) sprintf(script1, "text 90 170 0 11");
 line--; if (line==0) sprintf(script1, "text 160 170 16 12");
 line--; if (line==0) sprintf(script1, "button 30 170 2116 2115 1 0 6");
 line--; if (line==0) sprintf(script1, "text 90 195 0 13");
 line--; if (line==0) sprintf(script1, "text 160 195 16 14");
 line--; if (line==0) sprintf(script1, "button 30 195 2116 2115 1 0 7");
 line--; if (line==0) sprintf(script1, "text 90 220 0 15");
 line--; if (line==0) sprintf(script1, "text 160 220 16 16");
 line--; if (line==0) sprintf(script1, "button 30 220 2116 2115 1 0 8");
 if (type==2)
 {
  line--; if (line==0) sprintf(script1, "text 90 245 0 17");
  line--; if (line==0) sprintf(script1, "text 160 245 16 18");
  line--; if (line==0) sprintf(script1, "button 30 245 2116 2115 1 0 9");
 }
 if (type==1)
 {
  line--; if (line==0) sprintf(script1, "text 90 245 0 19");
  line--; if (line==0) sprintf(script1, "text 160 245 16 20");
  line--; if (line==0) sprintf(script1, "button 30 245 2116 2115 1 0 10");
 }
 line--; if (line==0) sprintf(script1, "page 2");
 line--; if (line==0) sprintf(script1, "button 40 320 2223 2223 0 1");
 line--; if (line==0) sprintf(script1, "text 65 317 32 2");
 line--; if (line==0) sprintf(script1, "button 366 320 2224 2224 0 3");
 line--; if (line==0) sprintf(script1, "text 288 317 32 1");
 if (type==1)
 {
  line--; if (line==0) sprintf(script1, "text 90 70 0 17");
  line--; if (line==0) sprintf(script1, "text 160 70 16 18");
  line--; if (line==0) sprintf(script1, "button 30 70 2116 2115 1 0 9");
  line--; if (line==0) sprintf(script1, "text 90 95 0 21");
  line--; if (line==0) sprintf(script1, "text 160 95 16 22");
  line--; if (line==0) sprintf(script1, "button 30 95 2116 2115 1 0 11");
  line--; if (line==0) sprintf(script1, "text 90 120 0 23");
  line--; if (line==0) sprintf(script1, "text 160 120 16 24");
  line--; if (line==0) sprintf(script1, "button 30 120 2116 2115 1 0 12");
  line--; if (line==0) sprintf(script1, "text 90 145 0 25");
  line--; if (line==0) sprintf(script1, "text 160 145 16 26");
  line--; if (line==0) sprintf(script1, "button 30 145 2116 2115 1 0 13");
  line--; if (line==0) sprintf(script1, "text 90 170 0 27");
  line--; if (line==0) sprintf(script1, "text 160 170 16 28");
  line--; if (line==0) sprintf(script1, "button 30 170 2116 2115 1 0 14");
  line--; if (line==0) sprintf(script1, "text 90 195 0 29");
  line--; if (line==0) sprintf(script1, "text 160 195 16 30");
  line--; if (line==0) sprintf(script1, "button 30 195 2116 2115 1 0 15");
  line--; if (line==0) sprintf(script1, "text 90 220 0 31");
  line--; if (line==0) sprintf(script1, "text 160 220 16 32");
  line--; if (line==0) sprintf(script1, "button 30 220 2116 2115 1 0 16");
  line--; if (line==0) sprintf(script1, "text 90 245 0 33");
  line--; if (line==0) sprintf(script1, "text 160 245 16 34");
  line--; if (line==0) sprintf(script1, "button 30 245 2116 2115 1 0 17");
 }
 line--; if (line==0) sprintf(script1, "page 3");
 line--; if (line==0) sprintf(script1, "button 40 320 2223 2223 0 2");
 line--; if (line==0) sprintf(script1, "text 65 317 32 2");
 if (type==1)
 {
  line--; if (line==0) sprintf(script1, "text 90 70 0 35");
  line--; if (line==0) sprintf(script1, "text 160 70 16 36");
  line--; if (line==0) sprintf(script1, "button 30 70 2116 2115 1 0 18");
  line--; if (line==0) sprintf(script1, "text 90 95 0 37");
  line--; if (line==0) sprintf(script1, "text 160 95 16 38");
  line--; if (line==0) sprintf(script1, "button 30 95 2116 2115 1 0 19");
 }
 line--; if (line==0) sprintf(script1, "}");
}

void ttext(int line, int j, char type)
{
 if (type==1) { line--; if (line==0) sprintf(script1,"Item Properties"); }
 if (type==2) { line--; if (line==0) sprintf(script1,"Character Properties"); }
 line--; if (line==0) sprintf(script1,"Next page");
 line--; if (line==0) sprintf(script1,"Previous page");
 if (type==1)
 {
  line--; if (line==0) sprintf(script1,"Name");
  line--; if (line==0) sprintf(script1,"%s", items[j].name);
  line--; if (line==0) sprintf(script1,"ID");
  line--; if (line==0) sprintf(script1,"0x%x (%i)", (items[j].id1*256)+items[j].id2, (items[j].id1*256)+items[j].id2);
  line--; if (line==0) sprintf(script1,"Hue");
  line--; if (line==0) sprintf(script1,"0x%x (%i)", (items[j].color1*256)+items[j].color2, (items[j].color1*256)+items[j].color2);
  line--; if (line==0) sprintf(script1,"X");
  line--; if (line==0) sprintf(script1,"%i (0x%x)", items[j].x, items[j].x);
  line--; if (line==0) sprintf(script1,"Y");
  line--; if (line==0) sprintf(script1,"%i (0x%x)", items[j].y, items[j].y);
  line--; if (line==0) sprintf(script1,"Z");
  line--; if (line==0) sprintf(script1,"%i (0x%x)", items[j].z, items[j].z);
  line--; if (line==0) sprintf(script1,"Type");
  line--; if (line==0) sprintf(script1,"%i", items[j].type);
  line--; if (line==0) sprintf(script1,"Layer");
  line--; if (line==0) sprintf(script1,"%i (0x%x)", items[j].layer, items[j].layer);
  line--; if (line==0) sprintf(script1,"Amount");
  line--; if (line==0) sprintf(script1,"%i", items[j].amount);
  line--; if (line==0) sprintf(script1,"More");
  line--; if (line==0) sprintf(script1,"0x%x", (items[j].more1*16777216)+(items[j].more2*65536)+(items[j].more3*256)+items[j].more4);
  line--; if (line==0) sprintf(script1,"MoreB");
  line--; if (line==0) sprintf(script1,"0x%x", (items[j].moreb1*16777216)+(items[j].moreb2*65536)+(items[j].moreb3*256)+items[j].moreb4);
  line--; if (line==0) sprintf(script1,"Stackable");
  line--; if (line==0) sprintf(script1,"%i", items[j].pileable);
  line--; if (line==0) sprintf(script1,"Dyeable");
  line--; if (line==0) sprintf(script1,"%i", items[j].dye);
  line--; if (line==0) sprintf(script1,"Corpse");
  line--; if (line==0) sprintf(script1,"%i", items[j].corpse);
  line--; if (line==0) sprintf(script1,"Attack");
  line--; if (line==0) sprintf(script1,"%i", items[j].att);
  line--; if (line==0) sprintf(script1,"Defense");
  line--; if (line==0) sprintf(script1,"%i", items[j].def);
  line--; if (line==0) sprintf(script1,"Magic");
  line--; if (line==0) sprintf(script1,"%i", items[j].magic);
  line--; if (line==0) sprintf(script1,"Visible");
  line--; if (line==0) sprintf(script1,"%i", items[j].visible);
 }
 if (type==2)
 {
  line--; if (line==0) sprintf(script1,"Name");
  line--; if (line==0) sprintf(script1,"%s", chars[j].name);
  line--; if (line==0) sprintf(script1,"Title");
  line--; if (line==0) sprintf(script1,"%s", chars[j].title);
  line--; if (line==0) sprintf(script1,"X");
  line--; if (line==0) sprintf(script1,"%i", chars[j].x);
  line--; if (line==0) sprintf(script1,"Y");
  line--; if (line==0) sprintf(script1,"%i", chars[j].y);
  line--; if (line==0) sprintf(script1,"Z");
  line--; if (line==0) sprintf(script1,"%i", chars[j].z);
  line--; if (line==0) sprintf(script1,"Direction");
  line--; if (line==0) sprintf(script1,"%i", chars[j].dir);
  line--; if (line==0) sprintf(script1,"Body");
  line--; if (line==0) sprintf(script1,"(0x%x) %i", (chars[j].id1*256)+chars[j].id2, (chars[j].id1*256)+chars[j].id2);
  line--; if (line==0) sprintf(script1,"Skin");
  line--; if (line==0) sprintf(script1,"(0x%x) %i", (chars[j].skin1*256)+chars[j].skin2, (chars[j].skin1*256)+chars[j].skin2);
 }
 line--; if (line==0) sprintf(script1,"}");
}

void tweakmenu(int s, int j, int type)
{
 char sect[512];
 short int length, length2, textlines;
 int i;
 int line;

 length=21;
 length2=1;
 line=0;
 do
 {
  line++;
  tline(line, j, type);
  if (script1[0]!='}')
  {
   length+=strlen(script1)+4;
   length2+=strlen(script1)+4;
  }
 }
 while (script1[0]!='}');
 length+=3;
 textlines=0;
 line=0;
 do
 {
  line++;
  ttext(line, j, type);
  if (script1[0]!='}')
  {
   length+=(strlen(script1)*2)+2;
   textlines++;
  }
 }
 while (script1[0]!='}');
 gump1[1]=length/256;
 gump1[2]=length%256;
 if (type==1)
 {
  gump1[3]=items[j].ser1;
  gump1[4]=items[j].ser2;
  gump1[5]=items[j].ser3;
  gump1[6]=items[j].ser4;
 }
 if (type==2)
 {
  gump1[3]=chars[j].ser1;
  gump1[4]=chars[j].ser2;
  gump1[5]=chars[j].ser3;
  gump1[6]=chars[j].ser4;
 }
 gump1[7]=0;
 gump1[8]=0;
 gump1[9]=0;
 gump1[10]=type; // Gump Number
 gump1[19]=length2/256;
 gump1[20]=length2%256;
 xsend(s, gump1, 21, 0);
 line=0;
 do
 {
  line++;
  tline(line, j, type);
  if (script1[0]!='}')
  {
   sprintf(sect, "{ %s }", script1);
   xsend(s, sect, strlen(sect), 0);
  }
 }
 while (script1[0]!='}');
 gump2[1]=textlines/256;
 gump2[2]=textlines%256;
 xsend(s, gump2, 3, 0);
 line=0;
 do
 {
  line++;
  ttext(line, j, type);
  if (script1[0]!='}')
  {
   gump3[0]=strlen(script1)/256;
   gump3[1]=strlen(script1)%256;
   xsend(s, gump3, 2, 0);
   gump3[0]=0;
   for (i=0;i<strlen(script1);i++)
   {
    gump3[1]=script1[i];
    xsend(s, gump3, 2, 0);
   }
  }
 }
 while (script1[0]!='}');
}

void entrygump(int s, char tser1, char tser2, char tser3, char tser4, char type, char index, short int maxlength, char *text1)
{
 short int length;
 char textentry1[12]="\xAB\x01\x02\x01\x02\x03\x04\x00\x01\x12\x34";
 char textentry2[9]="\x01\x01\x00\x00\x12\x34\x12\x34";

 sprintf(temp, "(%i chars max)", maxlength);
 length=11+strlen(text1)+1+8+strlen(temp)+1;
 textentry1[1]=length/256;
 textentry1[2]=length%256;
 textentry1[3]=tser1;
 textentry1[4]=tser2;
 textentry1[5]=tser3;
 textentry1[6]=tser4;
 textentry1[7]=type;
 textentry1[8]=index;
 textentry1[9]=(strlen(text1)+1)/256;
 textentry1[10]=(strlen(text1)+1)%256;
 xsend(s, textentry1, 11, 0);
 xsend(s, text1, strlen(text1)+1, 0);
 textentry2[4]=maxlength/256;
 textentry2[5]=maxlength%256;
 textentry2[6]=(strlen(temp)+1)/256;
 textentry2[7]=(strlen(temp)+1)%256;
 xsend(s, textentry2, 8, 0);
 xsend(s, temp, strlen(temp)+1, 0);
}

void gumpbutton(int s, int button, char tser1, char tser2, char tser3, char tser4, char type)
{
 int j=-1,serial,i;

 serial=calcserial(tser1,tser2,tser3,tser4);
 if (type>4) return; //increase this value with each new gump added.
 if (type==1) //Tweaking an Item
   j=findbyserial(&itemsp[serial%256], serial, 0);
 if (type==2) //Tweaking a Character
   j=findbyserial(&charsp[serial%256], serial, 1);
 if (type==3) //Townstones
   j=findbyserial(&itemsp[serial%256], serial, 0);
 if (type==4) //wholist
   j=findbyserial(&itemsp[serial%256], serial, 0);

 if (button==1) return;
 if (type==1) // Item
 {
  if (button==2) // Name
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 50, "Enter a new name for the item. (# = default name)");
  }
  if (button==3) // ID
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new ID number for the item in hex.");
  }
  if (button==4) // Hue
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new hue for the item in hex.");
  }
  if (button==5) // X
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new X coordinate for the item in decimal.");
  }
  if (button==6) // Y
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new Y coordinate for the item in decimal.");
  }
  if (button==7) // Z
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new Z coordinate for the item in decimal.");
  }
  if (button==8) // Type
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new type for the item in decimal.");
  }
  if (button==9) // Layer
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new layer for the item in decimal.");
  }
  if (button==10) // Amount
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter the new amount for the item in decimal.");
  }
  if (button==11) // More
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 8, "Enter the new More for the item in hex.");
  }
  if (button==12) // MoreB
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 8, "Enter the new MoreB for the item in hex.");
  }
  if (button==13) // Pileable
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 1, "Enter the new stackable toggle for the item. (0/1)");
  }
  if (button==14) // Dye
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 1, "Enter the new dyeable toggle for the item. (0/1)");
  }
  if (button==15) // Corpse
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 1, "Enter the new corpse toggle for the item. (0/1)");
  }
  if (button==16) // Att
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 5, "Enter the new attack value for the item in decimal.");
  }
  if (button==17) // Def
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 5, "Enter the new defense value for the item in decimal.");
  }
  if (button==18) // Magic
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 1, "Enter the new magic value for the item in decimal.");
  }
  if (button==19) // Visible
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 1, "Enter the new visible value for the item in decimal.");
  }
 }
 if (type==2) // Char
 {
  if (button==2) // Name
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 50, "Enter a new name for the character.");
  }
  if (button==3) // Title
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 50, "Enter a new name for the character.");
  }
  if (button==4) // X
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter a new X coordinate for the character in decimal.");
  }
  if (button==5) // Y
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter a new Y coordinate for the character in decimal.");
  }
  if (button==6) // Z
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter a new Z coordinate for the character in decimal.");
  }
  if (button==7) // Dir
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 1, "Enter a new direction for the character in decimal.");
  }
  if (button==8) // Body
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter a new body type for the character in hex.");
  }
  if (button==9) // Skin
  {
   entrygump(s, tser1, tser2, tser3, tser4, type, button, 4, "Enter a new skin hue for the character in hex.");
  }
 }
 if (type==3) // Townstones
 {
  if (button==2) // Leave/Join
  {
   if (chars[currchar[s]].town)
   {
    //They are a resident of a region (not necessarily this one).
    if (chars[currchar[s]].town==calcRegionFromXY(items[j].x, items[j].y)) {
     //They are a resident of this region, set their .town property to 0.
     if(chars[currchar[s]].townpriv==2) { //They were a mayor. Find new one.
      chars[currchar[s]].townpriv=0;
      towncalcnewmayor(chars[currchar[s]].town);
     }
     chars[currchar[s]].town=0;
     chars[currchar[s]].townpriv=0;
    } else {
     //They are not a resident of this region, set their .town property to
     //the region associated with the townstone.
     if(chars[currchar[s]].townpriv==2) { //They were a mayor. Find new one.
      chars[currchar[s]].townpriv=0;
      towncalcnewmayor(chars[currchar[s]].town);
     }
     chars[currchar[s]].town=calcRegionFromXY(items[j].x, items[j].y);
     chars[currchar[s]].townpriv=1;
     townmenu(s, j, 3);
    }
   } else {
    //They are not a resident of any region, set their .town property to the
    //region associated with this townstone.
     chars[currchar[s]].town=calcRegionFromXY(items[j].x, items[j].y);
     chars[currchar[s]].townpriv=1;
     townmenu(s, j, 3);
   }
   chars[currchar[s]].townvote1=0;
   chars[currchar[s]].townvote2=0;
   chars[currchar[s]].townvote3=0;
   chars[currchar[s]].townvote4=0;
   chars[currchar[s]].towntitle=0;
  }
  if (button==3) { // Toggle Title
   if(chars[currchar[s]].towntitle) {
    chars[currchar[s]].towntitle=0;
   } else {
    chars[currchar[s]].towntitle=1;
   }
   townmenu(s, j, 3);
  }
  if (button==4) { // Vote for Mayor
   target(s,0,1,0,161,"Select person to vote for.");
  }
 }
 if (type==4)//wholist *Homey
	 if(button<200)	
		 {		
		 button-=7;
		 chars[currchar[s]].making=button;
		 whocommand(s,type,button);
		 }
		else
		{ 
		 switch(button)
			 {
			 case 200://gochar
					i=chars[currchar[s]].making;
					chars[currchar[s]].x=chars[currchar[i]].x;
					chars[currchar[s]].y=chars[currchar[i]].y;
					chars[currchar[s]].dispz=chars[currchar[s]].z=chars[currchar[i]].z;
					teleport(currchar[s]);
					break;
			 case 201://xtele
					xteleport(s, 3);
			     	break;
			 case 202://jail char
				 if(s==chars[currchar[s]].making)
					 {
					 sysmessage(s,"You cannot jail yourself!");					 
					 break;
					 }
					 else
						 {
						for(i=0;i<chars[currchar[s]].making;i++)
							{
								if(perm[i]) //Keeps NPC's from appearing on the list
								 {							
 								chars[currchar[i]].serial;								
								 }
							}
						 //chars[currchar[s]].making=chars[currchar[i]].serial;
						 jailtarget(s,chars[currchar[i]].serial);
					     break;
						 }						 
			 case 203://release
				for(i=0;i<chars[currchar[s]].making;i++)
					{
						if(perm[i])
							{							
 							chars[currchar[i]].serial;
							}
					}
				//chars[currchar[s]].making=chars[currchar[i]].serial;			 
				releasetarget(s,chars[currchar[i]].serial);
				break;
			 case 204:
				 if(s==chars[currchar[s]].making)
					 {
					 sysmessage(s,"You cannot kick yourself");
					 }
					 else
						 {
						sysmessage(s, "Kicking player");				
						disconnect(chars[currchar[s]].making);
						break;
						 }
			 }
		}
}

void gumpinput(int s)
{
 char type, index, tser1, tser2, tser3, tser4;
 char *text;
 int i,j,k,serial;

 type=buffer[s][7];
 index=buffer[s][8];
 tser1=buffer[s][3];
 tser2=buffer[s][4];
 tser3=buffer[s][5];
 tser4=buffer[s][6];
 text=&buffer[s][12];
 serial=calcserial(tser1,tser2,tser3,tser4);
 if (type==1 && (chars[currchar[s]].priv|1))
 {
  j=findbyserial(&itemsp[serial%256], serial, 0);
  if (buffer[s][9]==0)
  {
   tweakmenu(s, j, type);
   return;
  }
  if (index==2) // Name
  {
   sprintf(items[j].name, "%s", text);
  }
  if (index==3) // ID
  {
   k=hstr2num(text);
   items[j].id1=k/256;
   items[j].id2=k%256;
  }
  if (index==4) // Hue
  {
   k=hstr2num(text);
   items[j].color1=k/256;
   items[j].color2=k%256;
  }
  if (index==5) // X
  {
   k=str2num(text);
   items[j].x=k;
  }
  if (index==6) // Y
  {
   k=str2num(text);
   items[j].y=k;
  }
  if (index==7) // Z
  {
   k=str2num(text);
   items[j].z=k;
  }
  if (index==8) // Type
  {
   k=str2num(text);
   items[j].type=k;
  }
  if (index==9) // Layer
  {
   k=str2num(text);
   items[j].layer=k;
  }
  if (index==10) // Amount
  {
   k=str2num(text);
   items[j].amount=k;
  }
  if (index==11) // More
  {
   k=hstr2num(text);
   items[j].more1=k/16777216;
   items[j].more2=k/65536;
   items[j].more3=k/256;
   items[j].more4=k%256;
  }
  if (index==12) // MoreB
  {
   k=hstr2num(text);
   items[j].moreb1=k/16777216;
   items[j].moreb2=k/65536;
   items[j].moreb3=k/256;
   items[j].moreb4=k%256;
  }
  if (index==13) // Pileable
  {
   k=str2num(text);
   items[j].pileable=k;
  }
  if (index==14) // Dye
  {
   k=str2num(text);
   items[j].dye=k;
  }
  if (index==15) // Corpse
  {
   k=str2num(text);
   items[j].corpse=k;
  }
  if (index==16) // Att
  {
   k=str2num(text);
   items[j].att=k;
  }
  if (index==17) // Def
  {
   k=str2num(text);
   items[j].def=k;
  }
  if (index==18) // Magic
  {
   k=str2num(text);
   items[j].magic=k;
  }
  if (index==19) // Visible
  {
   k=str2num(text);
   items[j].visible=k;
  }
  for (i=0;i<now;i++) if(perm[i]) senditem(i, j);
  tweakmenu(s, j, type);
 }
 if (type==2 && (chars[currchar[s]].priv|1))
 {
   j=findbyserial(&charsp[serial%256], serial, 1);
  if (buffer[s][9]==0)
  {
   tweakmenu(s, j, type);
   return;
  }
  if (index==2) // Name
  {
   sprintf(chars[j].name, "%s", text);
  }
  if (index==3) // Title
  {
   sprintf(chars[j].title, "%s", text);
  }
  if (index==4) // X
  {
   k=str2num(text);
   chars[j].x=k;
  }
  if (index==5) // Y
  {
   k=str2num(text);
   chars[j].y=k;
  }
  if (index==6) // Z
  {
   k=str2num(text);
   chars[j].z=k;
   chars[j].dispz=k;
  }
  if (index==7) // Dir
  {
   k=str2num(text);
   chars[j].dir=k;
  }
  if (index==8) // Body
  {
   k=hstr2num(text);
   chars[j].xid1=chars[j].id1=k/256;
   chars[j].xid2=chars[j].id2=k%256;
  }
  if (index==9) // Skin
  {
   k=hstr2num(text);
   chars[j].xskin1=chars[j].skin1=k/256;
   chars[j].xskin2=chars[j].skin2=k%256;
  }
  teleport(j);
  tweakmenu(s, j, type);
 }
}

void target(int s, int a1, int a2, int a3, int a4, char *txt) // Send targetting cursor to client
{
 char tarcrs[20]="\x6C\x01\x40\x01\x02\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";

 targetok[s]=1;
 tarcrs[2]=a1;
 tarcrs[3]=a2;
 tarcrs[4]=a3;
 tarcrs[5]=a4;
 sysmessage(s, txt);
 xsend(s, tarcrs, 19, 0);
}

//o---------------------------------------------------------------------------o
//|   Function    -  void addtarget(int s)
//|   Date        -  UnKnown
//|   Programmer  -  UnKnown  (Touched tabstops by Tauriel Dec 29, 1998)
//o---------------------------------------------------------------------------o
//|   Purpose     -  Adds an item when using /add # # .
//o---------------------------------------------------------------------------o
void addtarget(int s)
{
  if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
  int j,c,pileable=0;
  tile_st tile;

  if (addid1[s]==0x40)
  {
    switch (addid2[s])
    {
      case 100:
      case 102:
      case 104:
      case 106:
      case 108:
      case 110:
      case 112:
      case 114:
      case 116:
      case 118:
      case 120:
      case 122:
      case 124:
      case 126:
      case 140:
				buildhouse(s,addid3[s]);//If its a valid house, send it to buildhouse!
        return;
    }
  }
  seektile((addid1[s]*256)+addid2[s], &tile);
  if (tile.flag2&0x08) pileable=1;

  c=SpawnItem(s, 1, "#", pileable, addid1[s], addid2[s], NULL, NULL, 0,0);
	items[c].priv=0;	//Make them not decay
  items[c].x=(buffer[s][11]*256)+buffer[s][12];
  items[c].y=(buffer[s][13]*256)+buffer[s][14];
  items[c].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
  //if(chars[currchar[s]].making==999) chars[currchar[s]].making=c; // store house #
  for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
  addid1[s]=0;
  addid2[s]=0;
//  if(chars[currchar[s]].making==999)
/*  if (house) (taken out for house scripting)
  {
    chars[currchar[s]].making=c; // store house #
    buildhouse(s,1);
  }*/
  //if(c==chars[currchar[s]].making) buildhouse(s,1);
}

void addhere(int s, char z)
{
 int j,c,pileable=0;
 tile_st tile;
 c=memitemfree();
 inititem(c);

 seektile((addid1[s]*256)+addid2[s], &tile);
 if (tile.flag2&0x08) pileable=1;

 c=SpawnItem(s, 1, "#", pileable, addid1[s], addid2[s], 0, 0, 0, 0);
 items[c].x=chars[currchar[s]].x;
 items[c].y=chars[currchar[s]].y;
 items[c].z=z;
 items[c].doordir=0;
 items[c].priv=0;
 for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
 addid1[s]=0;
 addid2[s]=0;
}

void tiling(int s)  // Clicking the corners of tiling calls this function - Crwth 01/11/1999
{
  if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

	if (clickx[s]==-1 && clicky[s]==-1) {
		clickx[s]=buffer[s][11]*256+buffer[s][12];
		clicky[s]=buffer[s][13]*256+buffer[s][14];
		target(s,0,1,0,198,"Select second corner of bounding box.");
		return;
	}
  
	int j,c,pileable=0;
  tile_st tile;
	int x1=clickx[s],x2=buffer[s][11]*256+buffer[s][12];
	int y1=clicky[s],y2=buffer[s][13]*256+buffer[s][14];

	clickx[s]=-1;clicky[s]=-1;

	if (x1>x2) {c=x1;x1=x2;x2=c;}
	if (y1>y2) {c=y1;y1=y2;y2=c;}

  if (addid1[s]==0x40)
  {
    switch (addid2[s])
    {
      case 100:
      case 102:
      case 104:
      case 106:
      case 108:
      case 110:
      case 112:
      case 114:
      case 116:
      case 118:
      case 120:
      case 122:
      case 124:
      case 126:
      case 140:
				addtarget(s);
        return;
    }
  }
  
	int x,y;

	seektile((addid1[s]*256)+addid2[s], &tile);
  if (tile.flag2&0x08) pileable=1;
	for (x=x1;x<=x2;x++)
		for (y=y1;y<=y2;y++) {
			c=SpawnItem(s, 1, "#", pileable, addid1[s], addid2[s], NULL, NULL, 0,0);
			items[c].priv=0;	//Make them not decay
			items[c].x=x;
			items[c].y=y;
			items[c].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
			for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
		}

  addid1[s]=0;
  addid2[s]=0;
}

void wiping(int s)  // Clicking the corners of wiping calls this function - Crwth 01/11/1999
{
  if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

	if (clickx[s]==-1 && clicky[s]==-1) {
		clickx[s]=buffer[s][11]*256+buffer[s][12];
		clicky[s]=buffer[s][13]*256+buffer[s][14];
		if (addid1[s]) target(s,0,1,0,199,"Select second corner of inverse wiping box.");
		else target(s,0,1,0,199,"Select second corner of wiping box.");
		return;
	}
  
	int x1=clickx[s],x2=buffer[s][11]*256+buffer[s][12];
	int y1=clicky[s],y2=buffer[s][13]*256+buffer[s][14];

	clickx[s]=-1;clicky[s]=-1;

	int c;

	if (x1>x2) {c=x1;x1=x2;x2=c;}
	if (y1>y2) {c=y1;y1=y2;y2=c;}

	if (addid1[s]==1) {  // addid1[s]==1 means to inverse wipe
		for (int i=0;i<itemcount;i++)
		if (!(items[i].x>=x1 && items[i].x<=x2 && items[i].y>=y1 && items[i].y<=y2) && items[i].contserial==-1 && items[i].wipe==0)
			deleitem(i);
	}
	else {
		for (int i=0;i<itemcount;i++)
		if (items[i].x>=x1 && items[i].x<=x2 && items[i].y>=y1 && items[i].y<=y2 && items[i].contserial==-1 && items[i].wipe==0)
			deleitem(i);
	}
}

void renametarget(int s)
{
  int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   sprintf(items[i].name,xtext[s]);
  }

  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   sprintf(chars[i].name,xtext[s]);
  }
}

void teletarget(int s)
{
 int success;

 if (line_of_sight(s,chars[currchar[s]].x, chars[currchar[s]].y, chars[currchar[s]].dispz,
	 (buffer[s][11]*256)+buffer[s][12], (buffer[s][13]*256)+buffer[s][14], buffer[s][16]+
	  tileheight(buffer[s][17]*256+buffer[s][18]), (WALLS_CHIMNEYS + DOORS + ROOFING_SLANTED))||
	(chars[currchar[s]].priv&0x01))
 {
  if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
 
  if (stablock((buffer[s][11]*256)+buffer[s][12],(buffer[s][13]*256)+buffer[s][14],
                buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18])) &&
      !(chars[currchar[s]].priv&0x01))
  {
   sysmessage(calcSocketFromChar(currchar[s]),"You cannot teleport there!");
   return;
  }
  if (currentSpellType[s] !=2)  // not a wand cast
  {
   success=subtractmana(currchar[s], 3);  // subtract mana on scroll or spell
   if (currentSpellType == 0)             // del regs on normal spell
   delereagents(currchar[s], 0, 1, 0, 0, 1, 0, 0, 0);
  }
 
  soundeffect(s, 0x01, 0xFE);
  chars[currchar[s]].x=(buffer[s][11]*256)+buffer[s][12];
  chars[currchar[s]].y=(buffer[s][13]*256)+buffer[s][14];
  chars[currchar[s]].dispz=chars[currchar[s]].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
  teleport(currchar[s]);
  staticeffect(currchar[s], 0x37, 0x2A, 0x09, 0x06);
 } 
}

void removetarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   sysmessage(s, "Removing item.");
   deleitem(i);
  }
}

void dyetarget(int s)
{
 int i,j,k,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  if ((addid1[s]==255)&&(addid2[s]==255))
  {
    i=findbyserial(&itemsp[serial%256], serial, 0);
    if (i!=-1)
    {
      dyevat[1]=items[i].ser1;
      dyevat[2]=items[i].ser2;
      dyevat[3]=items[i].ser3;
      dyevat[4]=items[i].ser4;
      dyevat[7]=items[i].id1;
      dyevat[8]=items[i].id2;
      xsend(s, dyevat, 9, 0);
      for (k=0;k<now;k++) if (perm[k]) senditem(k, i);
    }
    i=findbyserial(&charsp[serial%256], serial, 1);
    if (i!=-1)
    {
      dyevat[1]=chars[i].ser1;
      dyevat[2]=chars[i].ser2;
      dyevat[3]=chars[i].ser3;
      dyevat[4]=chars[i].ser4;
      dyevat[7]=0x21;
      dyevat[8]=0x06;
      xsend(s, dyevat, 9, 0);
    }
  }
  else
  {
    i=findbyserial(&itemsp[serial%256], serial, 0);
    if (i!=-1)
    {
      items[i].color1=addid1[s];
      items[i].color2=addid2[s];
      if (!(dyeall[s]))
      {
        if ( ((items[i].color1*256+items[i].color2)<0x0002) ||
            ((items[i].color1*256+items[i].color2)>0x03E9) )
        {
          items[i].color1=0x03;
          items[i].color2=0xE9;
        }
      }
      for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
    }
    i=findbyserial(&charsp[serial%256], serial, 1);
    if (i!=-1)
    {
      chars[i].skin1=addid1[s];
      chars[i].skin2=addid2[s];
      chars[i].xskin1=addid1[s];
      chars[i].xskin2=addid2[s];
      updatechar(i);
    }
  }
}

void newztarget(int s)
{
 int i,j,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].z=addid1[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
  }
 
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].dispz=chars[i].z=addid1[s];
   teleport(i);
  }
}

void typetarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].type=addid1[s];
  }
}

void idtarget(int s)
{
  int i,j,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].id1=addid1[s];
   items[i].id2=addid2[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
  }
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    chars[i].id1=addid1[s];
    chars[i].id2=addid2[s];
    chars[i].xid1=addid1[s];
    chars[i].xid2=addid2[s];
    updatechar(i);
  }
}

void xteleport(int s, int x)
{
	int i,j=0,serial;
	if (x==0)
	{
	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  	i=findbyserial(&charsp[serial%256], serial, 1);
  	}
	else if (x==5)
  {
    serial=calcserial(hexnumber(1),hexnumber(2),hexnumber(3),hexnumber(4));
  	i=findbyserial(&charsp[serial%256], serial, 1);
  }
  else if (x==2)
  {
     if (perm[makenumber(1)])
     {
     		i=currchar[makenumber(1)];
     }
     else return;
  }
  else if (x==3)
  {
  	i=chars[currchar[s]].making;
	chars[currchar[i]].x=chars[currchar[s]].x;
    chars[currchar[i]].y=chars[currchar[s]].y;
    chars[currchar[i]].dispz=chars[currchar[i]].z=chars[currchar[s]].z;
    teleport(currchar[i]);
    return;
		
  }

  if (i!=-1)
  {
   chars[i].x=chars[currchar[s]].x;
   chars[i].y=chars[currchar[s]].y;
   chars[i].dispz=chars[i].z=chars[currchar[s]].z;
   updatechar(i);
   j++;
  }
  if(j) return;
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].x=chars[currchar[s]].x;
   items[i].y=chars[currchar[s]].y;
   items[i].z=chars[currchar[s]].z;
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);   
  }
}

void xgotarget(int s)
{
  int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    chars[i].x=addx[s];
    chars[i].y=addy[s];
    chars[i].dispz=chars[i].z=addz[s];
    updatechar(i);
  }
}

void morexyztarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].morex=addx[s];
   items[i].morey=addy[s];
   items[i].morez=addz[s];
  }
}

void morextarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].morex=addx[s];
  }
}

void moreytarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].morey=addx[s];
  }
}

void moreztarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].morez=addx[s];
  }
}

void privtarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].priv=addid1[s];
   chars[i].priv2=addid2[s];
  }
}

void moretarget(int s)
{
  int i,j,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].more1=addid1[s];
   items[i].more2=addid2[s];
   items[i].more3=addid3[s];
   items[i].more4=addid4[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
  }
}

void keytarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   if (((items[i].more1==addid1[s])&&(items[i].more2==addid2[s])&&
       (items[i].more3==addid3[s])&&(items[i].more4==addid4[s]))||
       (addid1[s]=='\xFF'))
   {
    if (((items[i].type==1)||(items[i].type==63))&&(iteminrange(s,i,2)))
    {
     if(items[i].type==1) items[i].type=8;
     if(items[i].type==63) items[i].type=64;
     sysmessage(s, "You lock the container.");
    }
    else if ((items[i].type==8)||(items[i].type==64)&&(iteminrange(s,i,2)))
    {
     if(items[i].type==8) items[i].type=1;
     if(items[i].type==64) items[i].type=63;
     sysmessage(s, "You unlock the container.");
    }
    else if ((items[i].type==12)&&(iteminrange(s,i,2)))
    {
     items[i].type=13;
     sysmessage(s, "You lock the door.");
    }
    else if ((items[i].type==13)&&(iteminrange(s,i,2)))
    {
     items[i].type=12;
     sysmessage(s, "You unlock the door.");
    }
    else if ((items[i].id1==0x0b)&&(items[i].id2==0xd2))
    {
     sysmessage(s, "What do you wish the sign to say?");
         addid1[s]=i;chars[currchar[s]].making=998;
    }

   }
   else
   {
    if (items[i].more1=='\x00') sysmessage(s, "That does not have a lock.");
    else sysmessage(s, "The key does not fit into that lock.");
   }
  }
}

void setnpctrigger(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
//   if (chars[i].npc)
//   {
    sysmessage(s,"NPC triggered");
    chars[i].trigger=addx[s];
//   }else{
//    sysmessage(s,"You can not trigger Player Characters");
//   }
  }
}

void setitemtrigger(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   sysmessage(s,"Item triggered");
   items[i].trigger=addx[s];
  }
}

void settriggertype(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   sysmessage(s,"Trigger type set");
   items[i].trigtype=addx[s];
  }
}

void settriggerword(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   sysmessage(s,"Trigger word set");
   strcpy(chars[i].trigword,xtext[s]);
  }
}

void loadcannon(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if (((items[i].more1==addid1[s])&&(items[i].more2==addid2[s])&&
       (items[i].more3==addid3[s])&&(items[i].more4==addid4[s]))||
       (addid1[s]=='\xFF'))
    {
      if ((items[i].morez==0)&&(iteminrange(s,i,2)))
      {
        if(items[i].morez==0) items[i].morez=1;
          sysmessage(s, "You load the cannon.");
      }
      else
      {
        if (items[i].more1=='\x00') sysmessage(s, "That doesn't work in cannon.");
        else sysmessage(s, "That object doesn't fit into cannon.");
      }
    }
  }
}

void istatstarget(int s)
{
  int i,serial;
  tile_st tile;

  if ((buffer[s][7]==0)&&(buffer[s][8]==0)&&(buffer[s][9]==0)&&(buffer[s][10]==0))
  {
	seektile(((buffer[s][0x11]*256)+buffer[s][0x12]), &tile);
    sprintf(temp, "Item [Static] ID [%x %x]",buffer[s][0x11], buffer[s][0x12]);
    sysmessage(s, temp);
	sprintf(temp, "ID2 [%i],  Height [%i]",((buffer[s][0x11]*256)+buffer[s][0x12]), tile.height);
	sysmessage(s, temp);
  }
  else
  {
    serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
    i=findbyserial(&itemsp[serial%256], serial, 0);
    if (i!=-1)
    {
      sprintf(temp, "Item [Dynamic] Ser [%x %x %x %x]      ID [%x %x] Name [%s] Color [%x %x] Cont [%x %x %x %x] Layer [%x] Type [%d] Magic [%x] More [%x %x %x %x] Position [%i %i %i] Amount [%i] Priv [%x] STR [%d] HP [%d] Damage [%d-%d] MoreXYZ [%i %i %i]",
           items[i].ser1,items[i].ser2,items[i].ser3,items[i].ser4,items[i].id1,items[i].id2,
           items[i].name,items[i].color1,items[i].color2,
           items[i].cont1,items[i].cont2,items[i].cont3,items[i].cont4,
           items[i].layer,items[i].type,items[i].magic,
           items[i].more1,items[i].more2,items[i].more3,items[i].more4,
           items[i].x,items[i].y,items[i].z,items[i].amount, items[i].priv,
           items[i].st, items[i].hp, items[i].lodamage, items[i].hidamage,
           items[i].morex, items[i].morey, items[i].morez);
      sysmessage(s, temp);
    }
  }
}

void cstatstarget(int s)
{
  int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   sprintf(temp, "Ser [%x %x %x %x] ID [%x %x] Name [%s] Skin [%x %x] Account [%x] Priv [%x %x] Position [%i %i %i] CTimeout [%i] Fame [%i] Karma [%i] Deaths [%i] Kills [%i] NPCAI [%x] NPCWANDER [%d] WEIGHT [%.2f]",
   chars[i].ser1,chars[i].ser2,chars[i].ser3,chars[i].ser4,chars[i].id1,chars[i].id2,
   chars[i].name,chars[i].skin1,chars[i].skin2,
   chars[i].account,chars[i].priv,chars[i].priv2,
   chars[i].x,chars[i].y,chars[i].z, chars[i].timeout,
   chars[i].fame,chars[i].karma,chars[i].deaths,chars[i].kills,
   chars[i].npcaitype, chars[i].npcWander, chars[i].weight);
   sysmessage(s, temp);
   gumpopen(s, i, 0, 8);
   statwindow(s, i);
  }
}

void gmtarget(int s)
{
int i, j;
int  n, z, mypack, retitem;
 

  mypack=-1; 
  retitem=-1;


 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   chars[i].id1=0x03;
   chars[i].id2=0xDB;
   chars[i].skin1=0x80;
   chars[i].skin2=0x21;
   chars[i].xid1=0x03;
   chars[i].xid2=0xDB;
   chars[i].xskin1=0x80;
   chars[i].xskin2=0x21;
   chars[i].priv=0xF7;
   chars[i].priv2=0xDD;

   for (j=0;j<TRUESKILLS;j++)
   {
    chars[i].baseskill[j]=1000;
    chars[i].skill[j]=1000;
   }
   if (strncmp(chars[i].name, "GM", 2))
   {
    sprintf(temp, "GM %s", chars[i].name);
    sprintf(chars[i].name, "%s", temp);
   }
   
   break;
  }
 }
for(z=0;z<itemcount;z++)
  {
    if (items[z].contserial==chars[i].serial &&
        items[z].layer!=0x15 && items[z].layer!=0x1D &&
        items[z].layer!=0x10 && items[z].layer!=0x0B && (items[z].free==0))
    {
      if (mypack==-1)
      {
        mypack=packitem(i);
      }
      if (mypack==-1)
      {
        chars[i].packitem=n=SpawnItem(calcSocketFromChar(i),1,"#",0,0x0E,0x75,0,0,0,0);
        setserial(n,i,4);
        items[n].layer=0x15;
        items[n].type=1;
        items[n].dye=1;
        mypack=n;
        retitem=n;
      }
      items[z].x=(rand()%80)+50;
      items[z].y=(rand()%80)+50;
      items[z].z=9;
	if (items[z].contserial!=-1) removefromptr(&contsp[items[z].contserial%256], z);
      setserial(z,mypack,1);
      items[z].layer=0x00;

      removeitem[1]=items[z].ser1;
      removeitem[2]=items[z].ser2;
      removeitem[3]=items[z].ser3;
      removeitem[4]=items[z].ser4;
      for(j=0;j<now;j++)
      if (perm[j])
      {
        xsend(j, removeitem, 5, 0);
        senditem(j, z);
      }
    }
    else if (items[z].contserial==chars[i].serial &&
            (items[z].layer==0x0B || items[z].layer==0x10))
    {
      deleitem(z);
    }

  }
updatechar(i);
}

void cnstarget(int s)
{
 int i;

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   chars[i].id1=0x03;
   chars[i].id2=0xDB;
   chars[i].skin1=0x80;
   chars[i].skin2=0x03;
   chars[i].xid1=0x03;
   chars[i].xid2=0xDB;
   chars[i].xskin1=0x80;
   chars[i].xskin2=0x02;
   chars[i].priv=0xB6;
   chars[i].priv2=0x8D;
   if (strncmp(chars[i].name, "Counselor", 9))
   {
    sprintf(temp, "Counselor %s", chars[i].name);
    sprintf(chars[i].name, "%s", temp);
   }
   updatechar(i);
   break;
  }
 }
}

void killtarget(int s, int ly)
{
 int i, k,serial,serhash,ci;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);

  k=findbyserial(&charsp[serial%256], serial, 1);
  if (k!=-1)
  {
    serhash=serial%256;
    for (ci=0;ci<contsp[serhash].max;ci++)
    {
      i=contsp[serhash].pointer[ci];
      if ((i!=-1) && (items[i].contserial==serial) && 
          (items[i].layer==ly))
      {
        deleitem(i);
      }
    }
  }
}

void fonttarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);

  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    chars[i].fonttype=addid1[s];
  }
}

//o---------------------------------------------------------------------------o
//|   Function    -  void deathstuff(int i)
//|   Date        -  UnKnown
//|   Programmer  -  UnKnown  (Touched tabstops by Tauriel Dec 28, 1998)
//o---------------------------------------------------------------------------o
//|   Purpose     -  Performs death stuff. I.E.- creates a corpse, moves items
//|                  to it, take out of war mode, does animation and sound, etc.
//o---------------------------------------------------------------------------o
void deathstuff(int i)
{
  int z, j=0, k,c, l, q, x, ele, corpsenum, p, t;
  int serial,serial1,serhash,serhash1,ci,ci1;

  char clearmsg[8];
  int nType=0;

  if((chars[i].id1==0x00)&&((chars[i].id2==0x0c)||(chars[i].id2>=0x3b)&&(chars[i].id2<=0x3d)))
  {nType=1;}

  if (!(chars[i].dead))
  {
    for (t=0;t<charcount;t++)
    {
      if (chars[t].targ==i)
      {
        if (chars[t].npcaitype==0x40)
        {
          chars[t].summontimer=(getclock()+(CLOCKS_PER_SEC*20));    
          chars[t].npcWander=2;
          chars[t].npcaitype=0x04;
          chars[t].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
          npctalkall(t,"Thou have suffered thy punishment, scoundrel.");
        }
        chars[t].targ=-1;
        chars[t].timeout=0;
        chars[chars[t].attacker].attacker=-1;
        chars[chars[t].attacker].attackfirst=0;
        chars[t].attacker=-1;
        chars[t].attackfirst=0;
        if (chars[t].npc && chars[t].war) npcToggleCombat(t);
      }
    }
    p=packitem(i);
    z=calcSocketFromChar(i);
    if (z!=-1) j=unmounthorse(z);
    serial=chars[i].serial;
    serhash=serial%256;
    for (ci=0;ci<contsp[serhash].max;ci++)
    {
      j=contsp[serhash].pointer[ci];
      if ((j!=-1) && (items[j].type==1) && (items[j].x==26) && (items[j].y==0) &&
          (items[j].z==0) && (items[j].id1==0x1E) && (items[j].id2==0x5E) &&
          (items[j].contserial==chars[i].serial))
      {
        endtrade(items[j].ser1, items[j].ser2, items[j].ser3, items[j].ser4);
      }
    }
    ele=0;
    if(!(chars[i].npc==1)) chars[i].id1=0x01; // Character is a ghost
    if (chars[i].xid2==0x91)
    {
      chars[i].id2=0x93;  // Male or Female
    }
    else
    {
      chars[i].id2=0x92;
    }
    if (chars[i].xid1==0x01 && chars[i].xid2==0x91)
    {
      soundeffect2(i,0x01,0x51); // Female Death
    }
    if (chars[i].xid1==0x01 && chars[i].xid2==0x90)
    {
      soundeffect2(i,0x01,0x5a); // Male Death
    }
    else
    {
      playmonstersound(i, chars[i].xid1, chars[i].xid2, SND_DIE);
    }
    chars[i].skin1=0x00; // Undyed
    chars[i].skin2=0x00;
    chars[i].dead=1;     // Dead
    chars[i].hp=0;       // With no hp left
    chars[i].poisoned=0;
    #ifdef DEBUG
      printf("%s killed by %s.\n",chars[i].name,chars[chars[i].attacker].name);
    #endif
    // Make the corpse
    sprintf(temp,"a corpse of %s",chars[i].name);
    x=c=SpawnItem(z,1, temp, 0, 0x20, 0x06, chars[i].xskin1, chars[i].xskin2, 0,0);
    ele=items[c].amount=(chars[i].xid1*256)+chars[i].xid2; // Amount == corpse type
    items[c].type=1;
    items[c].x=chars[i].x;
    items[c].y=chars[i].y;
    items[c].z=chars[i].z;
    items[c].more1=nType;
    items[c].dir=chars[i].dir;
    items[c].corpse=1;
    items[c].decaytime=(getclock()+(server_data.decaytimer*CLOCKS_PER_SEC));
    corpsenum=c;

    // Put objects on corpse
    serial=chars[i].serial;
    serhash=serial%256;
    for (ci=0;ci<contsp[serhash].max;ci++)
    {
      j=contsp[serhash].pointer[ci];
      if ((j!=-1) && (items[j].contserial==serial) && (items[j].layer!=0x0B) && (items[j].layer!=0x10))
      {
        if (items[j].type==1 && items[j].layer!=0x1A && items[j].layer!=0x1B &&
            items[j].layer!=0x1C && items[j].layer!=0x1D)
        {
          // search backpack for spellbook && newbie items
          serial1=items[j].serial;
          serhash1=serial1%256;
          for (ci1=0;ci1<contsp[serhash1].max;ci1++)
          {
            k=contsp[serhash1].pointer[ci1];
            if ((k!=-1) && (items[k].contserial==serial1) && (!(items[k].priv&0x02)))
            {
              items[k].layer=0;
              setserial(k, corpsenum, 1);
              items[k].x=20+(rand()%50);
              items[k].y=85+(rand()%75);
              items[k].z=9;
            }
          }
        }
        else
        {
          if (items[j].layer==0x1A)
          {
            clearmsg[0]=0x3B;
            clearmsg[1]=0x00;
            clearmsg[2]=0x08;
            clearmsg[3]=chars[i].ser1;
            clearmsg[4]=chars[i].ser2;
            clearmsg[5]=chars[i].ser3;
            clearmsg[6]=chars[i].ser4;
            clearmsg[7]=0x00;
            for (l=0;l<now;l++)
              if (perm[l] && inrange1p(i, currchar[l])) xsend(l, clearmsg, 8, 0);
          }
        }  // keep newbie stuff and bank with player
        if ((!(items[j].priv&0x02)) && items[j].layer!=0x1D)
        {
          if (j!=p)
          {
            setserial(j, corpsenum, 1);
          }
        }
        else
        {
          if(p!=-1 && items[j].layer!=0x1D)
          {
            if(j!=p)
            {
              items[j].layer=0;
              setserial(j, p, 1);
            }
          }
        }
        if ((items[j].layer==0x15)&&(chars[i].shop==0)) items[j].layer=0x1A;
        items[j].x=20+(rand()%50);
        items[j].y=85+(rand()%75);
        items[j].z=9;
        removeitem[1]=items[j].ser1;
        removeitem[2]=items[j].ser2;
        removeitem[3]=items[j].ser3;
        removeitem[4]=items[j].ser4;
        for (k=0;k<now;k++)
        {
          if (perm[k]) xsend(k, removeitem, 5, 0);
        }
      }

      if ((items[j].contserial==serial)&& ((items[j].layer==0x0B)||(items[j].layer==0x10)))
      {
        //removefromptr(&contsp[chars[i].serial%256], j); //Tauriel fix for hair missing after
        //setserial(j,x,1);                               //        being rezzed
        sprintf(items[j].name,"Hair/Beard");
        items[j].x=0x47;
        items[j].y=0x93;
        items[j].z=0;
      }
    }
    if (chars[i].npc==0)
    { 
      sprintf(temp,"Death Shroud");
      c=SpawnItem(z, 1, temp, 0, 0x20, 0x4E, 0, 0, 0, 0);
      chars[i].robe1=items[c].ser1; //itemcount2/16777216;
      chars[i].robe2=items[c].ser2; //itemcount2/65536;
      chars[i].robe3=items[c].ser3; //itemcount2/256;
      chars[i].robe4=items[c].ser4; //itemcount2;
      setserial(c, i, 4);
      items[c].layer=0x16;
      items[c].def=1;
    }
    if (server_data.showdeathanim) deathaction(i, corpsenum);
    if (chars[i].npc==0)
    {
      teleport(i);
      q=calcSocketFromChar(i);
      if (q!=-1) deathmenu(q);
    }

    for (j=0;j<charcount;j++)
    {
      if ((chars[j].targ==i) && chars[j].npc && chars[j].war)
      {
        npcToggleCombat(j);
      }
    }

    if ((ele==13)||(ele==15)||(ele==16)||(ele==574))
    {
      sprintf(items[c].name,"a backpack");
			items[c].color1=0;
			items[c].color2=0;
	  items[c].amount = 1;
	  items[c].id1=0x09;
	  items[c].id2=0xB2;
     // deleitem(corpsenum);  leave for elementals I guess
     // gcollect();
    }
    //else
      for (j=0;j<now;j++)
      {
        if (perm[j]) senditem(j,corpsenum);
      }
    if (chars[i].npc==1) deletechar(i);
		if(ele==65535) deleitem(corpsenum);
  } 
}

void ghosttarget(int s)
{
 int i,x=0;
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   if(chars[i].dead==0)
   {
   bolteffect(i);
   soundeffect2(i, 0x00, 0x29);
   x++;
   deathstuff(i);
   break;
   }
  }
 }
if(x==0)
sysmessage(s,"That player is already dead.");
}


void bolttarget(int s)
{
 int i;
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   bolteffect(i);
   soundeffect2(i, 0x00, 0x29);
   break;
  }
 }
}

void amounttarget(int s)
{
 int i,j;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
      (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
  {
   items[i].amount=addx[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
   break;
  }
 }
}


void setamount2target(int s)
{
 int i,j;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
      (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
  {
   items[i].amount2=addx[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
  }
 }
}

void closetarget(int s)
{
 int i, j;
 char closestr[6]="\x26\x00\x00\x00\x00";

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   for (j=0;j<now;j++)
   {
    sysmessage(s, "Kicking player");
    if (currchar[j]==i)
    {
     disconnect(j);//xsend(j, closestr, 5, 0);
     break;
    }
   }
   break;
  }
 }
}

int addmenutarget(int s, int x, int addmitem) //Tauriel 11-22-98 updated for new items
{
  int c, j;
  if (s!=-1 && buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return -1;
  c=CreateScriptItem(s, addmitem, 0);
  if (x) for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
  return c;
}

void npcmenutarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 int x;
 x=addmitem[s];

 addrespawnnpc(s,x,0);
}

void movabletarget (int s)
{
 int i,j;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
      (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
  {
   items[i].magic=addx[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
   break;
  }
 }
}

void visibletarget (int s)
{
 int i,j;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
      (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
  {
   items[i].visible=addx[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
   return;
  }
 }
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   chars[i].hidden=addx[s];
   updatechar(i);
   return;
  }
 }
}


void teleporters(int s)
{
 int i;

 for(i=0;i<max_tele_locations;i++)
 {
  if(chars[s].x == tele_locations[i][0])
  {
   if(chars[s].y == tele_locations[i][1])
   {
    if((tele_locations[i][2] == 999)||(chars[s].z == tele_locations[i][2]))
    {
     chars[s].x=tele_locations[i][3];
     chars[s].y=tele_locations[i][4];
     chars[s].dispz=chars[s].z=tele_locations[i][5];
     teleport(s);

    }
   }
   else
    if(chars[s].y < tele_locations[i][1])
     break;
  }
  else
   if(chars[s].x < tele_locations[i][0])
    break;
 }
}

void read_in_teleport(void)
{
 FILE *fp;
 char text[256];
 int i;
 char seps[]   = " ,\t\n";
 char *token;

 fp = fopen("teleport.scp","r");
 max_tele_locations=0;

 if(fp==NULL)
 {
  printf("ERROR: Teleport Data not found\n");
  error=1;
    keeprun=0;
    return;
  }

 while((!feof(fp))&&(max_tele_locations<MAX_TELE_LOCATIONS))
 {
  fgets(text,255,fp);

  if(text[0]!=';')
  {
   tele_locations[max_tele_locations][0] = 0;
   tele_locations[max_tele_locations][1] = 0;
   tele_locations[max_tele_locations][2] = 0;
   tele_locations[max_tele_locations][3] = 0;
   tele_locations[max_tele_locations][4] = 0;
   tele_locations[max_tele_locations][5] = 0;
   token = strtok( text, seps );
   i = 0;
   while( token != NULL )
   {
    if(i==2)
     if(token[0] == 'A')
      tele_locations[max_tele_locations][i] = 999;
     else
      tele_locations[max_tele_locations][i] = atoi(token);
    else
     tele_locations[max_tele_locations][i] = atoi(token);

    i++;
    if(i==6)
     break;

    token = strtok( NULL, seps );
   }
   max_tele_locations++;
  }
 }

 fclose(fp);
}

void ownertarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
   chars[i].own1=addid1[s];
   chars[i].own2=addid2[s];
   chars[i].own3=addid3[s];
   chars[i].own4=addid4[s];
   chars[i].ownserial=calcserial(addid1[s],addid2[s],addid3[s],addid4[s]);
   setptr(&cownsp[chars[i].ownserial%256], i);
 }

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
  {
   items[i].owner1=addid1[s];
   items[i].owner2=addid2[s];
   items[i].owner3=addid3[s];
   items[i].owner4=addid4[s];
   items[i].ownserial=calcserial(addid1[s],addid2[s],addid3[s],addid4[s]);
   setptr(&ownsp[items[i].ownserial%256], i);
 }
}

void usehairdye(int s, int x)
{
 //s is the player, x is the hair dye bottle object number
 int hairobject=-1, beardobject=-1, itemcounter=-1;
 int j;

 //Find hair object.(layer 11, 0x0B)
 //Find beard object.(layer 16, 0x10)
 while ((hairobject==-1)&&(itemcounter<itemcount)) {
  itemcounter++;
  if ((items[itemcounter].layer==0x0B)&&
      (items[itemcounter].contserial==chars[currchar[s]].serial))
  {
   hairobject=itemcounter;
  }
  if ((items[itemcounter].layer==0x10)&&
      (items[itemcounter].contserial==chars[currchar[s]].serial))
  {
   beardobject=itemcounter;
  }
 }
 while ((beardobject==-1)&&(itemcounter<itemcount)) {
  itemcounter++;
  if ((items[itemcounter].layer==0x10)&&
      (items[itemcounter].contserial==chars[currchar[s]].serial))
  {
   beardobject=itemcounter;
  }
 }

 //Now change the color to the hair dye bottle color!
 if (hairobject) {
  items[hairobject].color1=items[x].color1;
  items[hairobject].color2=items[x].color2;
  for (j=0;j<now;j++) if (perm[j]) senditem(j,hairobject);
 }
 if (beardobject) {
  items[beardobject].color1=items[x].color1;
  items[beardobject].color2=items[x].color2;
  for (j=0;j<now;j++) if (perm[j]) senditem(j,beardobject);
 }

 //Now delete the hair dye bottle!
 deleitem(x);
}

void colorstarget (int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if (((items[i].id1==0x0F)&&(items[i].id2==0xAB))||                        //dye vat
        ((items[i].id1==0x0E)&&((items[i].id2==0xFF)||(items[i].id2==0x27)))) //hair dye
    {
      dyevat[1]=items[i].ser1;
      dyevat[2]=items[i].ser2;
      dyevat[3]=items[i].ser3;
      dyevat[4]=items[i].ser4;
      dyevat[7]=items[i].id1;
      dyevat[8]=items[i].id2;
      xsend(s, dyevat, 9, 0);
    }
    else
    {
      sysmessage(s, "You can only use this item on a dye vat.");
    }
  }
}

void dvattarget (int s)
{
 int i,j,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
    if (items[i].dye==1)
    {
      items[i].color1=addid1[s];
      items[i].color2=addid2[s];
      for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
    }
    else
    {
      sysmessage(s, "You can only dye clothes with this.");
    }
  }
}

void addnpctarget(int s)
{
 int c;
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF &&
     buffer[s][14]==0xFF) return;
 c=memcharfree ();
 
 initchar(c);
 sprintf(chars[c].name, "Dummy");
 chars[c].id1=addid1[s];
 chars[c].id2=addid2[s];
 chars[c].xid1=addid1[s];
 chars[c].xid2=addid2[s];
 chars[c].skin1=0;
 chars[c].skin2=0;
 chars[c].xskin1=0;
 chars[c].xskin2=0;
 chars[c].priv=0x10;
 chars[c].x=(buffer[s][11]*256)+buffer[s][12];
 chars[c].y=(buffer[s][13]*256)+buffer[s][14];
 chars[c].dispz=chars[c].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
 chars[c].npc=1;
/* if (c==charcount)
  {
  charcount++;
  charcount2++;
  }*/
 updatechar(c);
}

void freezetarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].priv2=chars[i].priv2|2;
  }
}

void unfreezetarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].priv2=chars[i].priv2&(!2);
  }
}

void allsettarget(int s)
{
 int i, j, k;
 //unsigned short int tempskill;

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   k=calcSocketFromChar(i);
   if (addx[s]<TRUESKILLS)
   {
       chars[i].baseskill[addx[s]]=addy[s];
       updateSkillLevel(i, addx[s]);
    if (k!=-1) updateskill(k, addx[s]);
   }
   else if (addx[s]==ALLSKILLS)
   {
    for (j=0;j<TRUESKILLS;j++)
    {
        chars[i].baseskill[j]=addy[s];
        updateSkillLevel(i, j);
     if (k!=-1) updateskill(k,j);
    }
   }
   else if (addx[s]==STR)
   {
    chars[i].st=addy[s];
    for (j=0;j<TRUESKILLS;j++)
    {
      updateSkillLevel(i,j);
     if (k!=-1) updateskill(k,j);
    }
    if (k!=-1) statwindow(k,i);
   }
   else if (addx[s]==DEX)
   {
    chars[i].dx=addy[s];
    for (j=0;j<TRUESKILLS;j++)
    {
      updateSkillLevel(i,j);
     if (k!=-1) updateskill(k,j);
    }
    if (k!=-1) statwindow(k,i);
   }
   else if (addx[s]==INT)
   {
    chars[i].in=addy[s];
    for (j=0;j<TRUESKILLS;j++)
    {
      updateSkillLevel(i,j);
     if (k!=-1) updateskill(k,j);
    }
    if (k!=-1) statwindow(k,i);
   }
   else if (addx[s]==FAME)
   {
    chars[i].fame=addy[s];
   }
   else if (addx[s]==KARMA)
   {
    chars[i].karma=addy[s];
   }
   break;
  }
 }
}

void infotarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
 int tilenum;
 tile_st tile;

 tilenum=(buffer[s][0x11])*256+buffer[s][0x12];
 seektile(tilenum, &tile);
 printf("Flag1:%x\n", tile.flag1);
 printf("Flag2:%x\n", tile.flag2);
 printf("Flag3:%x\n", tile.flag3);
 printf("Flag4:%x\n", tile.flag4);
 printf("Weight:%x\n", tile.weight);
 printf("Layer:%x\n", tile.layer);
 printf("Anim:%lx\n", tile.animation);
 printf("Unknown1:%lx\n", tile.unknown1);
 printf("Unknown2:%x\n", tile.unknown2);
 printf("Unknown3:%x\n", tile.unknown3);
 printf("Height:%x\n", tile.height);
 printf("Name:%s\n", tile.name);
 sysmessage(s, "Item info has been dumped to the console.");
}

void tweaktarget(int s)
{
 int i;

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   tweakmenu(s, i, 2);
   return;
  }
 }
 for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
      (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
  {
   tweakmenu(s, i, 1);
   break;
  }
 }
}

void setinvulflag(int s)
{
 int i;
 
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   if (addx[s]==1)
   {
    chars[i].priv=chars[i].priv|4;
   }
   else
   {
    chars[i].priv=chars[i].priv&251;
   }
  }
 }
}

void explodeitem(int s, unsigned int nItem)
{
	unsigned int dmg=0,len=0,c;
	int x, y, z,dx,dy,dz;
	// - send the effect (visual and sound)
	if (items[nItem].x<150 && items[nItem].y<150 && items[nItem].z==9) //(in pack)
	{
		staticeffect(currchar[s], 0x36, 0xB0, 0x00, 0x09);
		c=currchar[s];
		items[nItem].x=chars[c].x;
		items[nItem].y=chars[c].y;
		items[nItem].z=chars[c].z;
	  soundeffect2(currchar[s], 0x02, 0x07);

	}
	else
	{
		staticeffect2(nItem, 0x36, 0xB0, 0x00, 0x09, 0x00);
    soundeffect3(nItem, 0x02, 0x07);
	}
	len=items[nItem].morex/250; //4 square max damage at 100 alchemy
	switch (items[nItem].morez)
	{
		case 1:dmg=RandomNum(5,10) ;break;
		case 2:dmg=RandomNum(10,20) ;break;
		case 3:dmg=RandomNum(20,40) ;break;
	}

	if (dmg<5) dmg=RandomNum(5,10);  // 5 points minimum damage
	if (len<2) len=2;  // 2 square min damage range
		
	for (c=0;c<charcount;c++)
	{
		if((online(c) || chars[c].npc) && !(chars[c].priv&4))
		{
			dx=abs(chars[c].x-items[nItem].x);
			dy=abs(chars[c].y-items[nItem].y);
			dz=abs(chars[c].z-items[nItem].z);
			if ((dx<=len)&&(dy<=len)&&(dz<=len))
			{
				//staticeffect(c, 0x36, 0xB0, 0x09, 0x09);
				chars[c].hp-=dmg+(2-min(dx,dy));
				updatestats(c, 0);
				if (chars[c].hp<=0)
				{
					deathstuff(c);
				}
				else
				{
					npcattacktarget(c, currchar[s]);
					updatechar(c);
				}
			}
		}	
	}
	deleitem(nItem);
}

void exppotiontarget(int s) //Throws the potion and places it (unmovable) at that spot
{
	//11*256+12 and 13*256+14.
	int i, x, y, z, len, c, dmg=0, k=0, serial;
	int dx,dy,dz;
	x=(buffer[s][11]*256)+buffer[s][12];
	y=(buffer[s][13]*256)+buffer[s][14];
	z=buffer[s][16];
	if (x!=65535)
	{
		i=calcItemFromSer(addid1[s],addid2[s],addid3[s],addid4[s]);
		items[i].x=x;
		items[i].y=y;
		items[i].z=z;
		items[i].cont1=-1;
		items[i].cont2=-1;
		items[i].cont3=-1;
		items[i].cont4=-1;
		items[i].contserial=-1;
		items[i].magic=2; //make item unmovable once thrown
		movingeffect2(currchar[s], i, 0x0F, 0x0D, 0x11, 0x00, 0x00);
		for (unsigned int j=0;j<now;j++) if (perm[j]) senditem(j,i);
		//deleitem(i);
	}

/*		len=items[i].morex/250;
		//printf("DEBUG: %i,%i,%i [Item: %i]\n",x,y,z,i);
		k=memcharfree();
		initchar(k);
		chars[k].id1=0;
		chars[k].id2=0;
		chars[k].xid1=-1;
		chars[k].xid2=-1;
		chars[k].skin1=0;
		chars[k].skin2=0;
		chars[k].xskin1=0;
		chars[k].xskin2=0;
		chars[k].x=x;
		chars[k].y=y;
		chars[k].z=z;
		chars[k].hp=1;
		chars[k].priv=0x10;
		chars[k].npc = 1;
		updatechar(k);
		movingeffect2(currchar[s], i, 0x0F, 0x0D, 0x11, 0x00, 0x00);
		movingeffect(currchar[s], k, 0x0F, 0x0D, 0x11, 0x00, 0x01);
		soundeffect2(k, 0x02, 0x07);
		deathstuff(k);
		items[i].x=x;
		items[i].y=y;
		items[i].z=z;
		items[i].cont1=-1;
		items[i].cont2=-1;
		items[i].cont3=-1;
		items[i].cont4=-1;
		items[i].contserial=-1;
		for (unsigned int j=0;j<now;j++) if (perm[j]) senditem(j,i);
		all_items(s);
		//printf("Crash me Int->String! %i->%s\n",items[i].name,i);
		switch (items[i].morez)
		{
		case 1:dmg=items[i].morex/200;break;
				case 2:dmg=items[i].morex/100;break;
				case 3:dmg=items[i].morex/50;break;
				}
		for (c=0;c<charcount;c++)
		{
			if((online(c)) || (chars[c].npc))
		  {
				
				dx=abs(chars[c].x-x);
				dy=abs(chars[c].y-y);
				dz=abs(chars[c].z-z);								
				if ((dx<=len)&&(dy<=len)&&(dz<=len))
				{
					staticeffect(c, 0x36, 0xB0, 0x09, 0x09);									
					chars[c].hp-=dmg+(2-min(dx,dy));
			    if (chars[c].hp<=0)
					{
						deathstuff(c);
					} 
					else 
					{										
						npcattacktarget(c, currchar[s]);
						updatechar(c);
					}
								//printf("DEBUG: Dmg char #: %i [%i]-[%i,%i,%i] [Len: %i]\n",c,dmg+(6-min(min(dx,dy),dz)),dx,dy,dz,len);
				}
			}	
		}
		deleitem(i);
	}*/
}

void multitarget(int s) // If player clicks on something with the targetting cursor
{
 int a1, a2, a3, a4, i;

 a1=buffer[s][2];
 a2=buffer[s][3];
 a3=buffer[s][4];
 a4=buffer[s][5];
 targetok[s]=0;
 if ((a1==0)&&(a2==1)&&(a3==0))
 {
  switch(a4)
  {
   case 0: addtarget(s); break;
   case 1: if (chars[currchar[s]].priv&1) renametarget(s); break;
   case 2: teletarget(s); break;
   case 3: if (chars[currchar[s]].priv&1) removetarget(s); break;
   case 4: if (chars[currchar[s]].priv&1) dyetarget(s); break;
   case 5: newztarget(s); break;
   case 6: typetarget(s); break;
   case 7: if (chars[currchar[s]].priv&1) idtarget(s); break;
   case 8: if (chars[currchar[s]].priv&1) xgotarget(s); break;
   case 9: if (chars[currchar[s]].priv&1) privtarget(s); break;
   case 10: if (chars[currchar[s]].priv&1) moretarget(s); break;
   case 11: keytarget(s); break;
   case 12: istatstarget(s); break;
   case 13: cstatstarget(s); break;
   case 14: if (chars[currchar[s]].priv&1) gmtarget(s); break;
   case 15: if (chars[currchar[s]].priv&1) cnstarget(s); break;
   case 16: if (chars[currchar[s]].priv&1) killtarget(s, 0x0b); break;
   case 17: if (chars[currchar[s]].priv&1) killtarget(s, 0x10); break;
   case 18: if (chars[currchar[s]].priv&1) killtarget(s, 0x15); break;
   case 19: if (chars[currchar[s]].priv&1) fonttarget(s); break;
   case 20: if (chars[currchar[s]].priv&1) ghosttarget(s); break;
   case 21: resurrecttarget(s); break;
   case 22: bolttarget(s); break;
   case 23: amounttarget(s); break;
   case 24:
		 {
			 for(i=0;i<itemcount;i++)
			 {
				 if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
					 (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10]))
				 {
					 triggerwitem(s,i,0);
					 chars[currchar[s]].envokeid1=0x00;
					 chars[currchar[s]].envokeid2=0x00;
					 return;
				 } 
			 }
			 triggerwitem(s,-1,0);
			 chars[currchar[s]].envokeid1=0x00;
			 chars[currchar[s]].envokeid2=0x00;
			 return;
		 }
   case 25: if (chars[currchar[s]].priv&1) closetarget(s); break;
   case 26: addmenutarget(s, 1, addmitem[s]); break;
   case 27: npcmenutarget(s); break;
   case 28: if (chars[currchar[s]].priv&1) movabletarget(s); break;
   case 29: armsloretarget(s); break;
   case 30: if (chars[currchar[s]].priv&1) ownertarget(s); break;
   case 31: colorstarget(s); break;
   case 32: dvattarget(s); break;
   case 33: if (chars[currchar[s]].priv&1) addnpctarget(s); break;
   case 34: if (chars[currchar[s]].priv&1) freezetarget(s); break;
   case 35: if (chars[currchar[s]].priv&1) unfreezetarget(s); break;
   case 36: if (chars[currchar[s]].priv&1) allsettarget(s); break;
   case 37: anatomytarget(s); break;
   case 38: recall(s); break;
   case 39: mark(s); break;
   case 40: itemidtarget(s); break;
   case 41: evaluate_int_target(s); break;
   case 42: tametarget(s); break;
   case 43: gate(s); break;
   case 44: heal(s); break;
   case 45: fishtarget(s); break;
   case 46: infotarget(s); break;
   case 47: titletarget(s); break;
   case 50: smith(s); break;
   case 51: mine(s); break;
   case 52: smeltore(s); break;
   case 53: npcact(s); break;
   case 54: createfoodtarget(s); break;
   case 56: if (chars[currchar[s]].priv&1) npctarget(s); break;
   case 57: if (chars[currchar[s]].priv&1) npctarget2(s); break;
   case 58: if (chars[currchar[s]].priv&1) npcrecttarget(s); break;
   case 59: if (chars[currchar[s]].priv&1) npccircletarget(s); break;
   case 60: if (chars[currchar[s]].priv&1) npcwandertarget(s); break;
   case 61: if (chars[currchar[s]].priv&1) visibletarget(s); break;
   case 62: if (chars[currchar[s]].priv&1) tweaktarget(s); break;
   case 63: if (chars[currchar[s]].priv&1) morextarget(s); break;
   case 64: if (chars[currchar[s]].priv&1) moreytarget(s); break;
   case 65: if (chars[currchar[s]].priv&1) moreztarget(s); break;
   case 66: if (chars[currchar[s]].priv&1) morexyztarget(s); break;
   case 67: invistarget(s); break;
   case 68: magicarrowtarget(s); break;
   case 69: evtarget(s); break;
   case 70: bstarget(s); break;
   case 71: flamestriketarget(s); break;
   case 72: explosiontarget(s); break;
   case 73: lightningtarget(s); break;
   case 74: fireballtarget(s); break;
   case 75: ebolttarget(s); break;
   case 76: axetarget(s); break;
   case 77: detecthidden(s); break;
   case 78: reveal(s); break;
   case 79: provocationtarget1(s); break;
   case 80: provocationtarget2(s); break;
   case 81: enticementtarget1(s); break;
   case 82: enticementtarget2(s); break;
   case 83: healtarget(s); break;
   case 84: greaterhealtarget(s); break;
   case 85: harmtarget(s); break;
   case 86: swordtarget(s); break;
   case 87: if (chars[currchar[s]].priv&1) sbopencontainer(s); break;
   case 88: if (chars[currchar[s]].priv&1) setdirtarget(s); break;
   case 89: if (chars[currchar[s]].priv&1) objprivtarget(s); break;
   case 90: dispeltarget(s); break;
   case 91: firefieldtarget(s); break;
   case 92: wallofstonetarget(s); break;
   case 93: parafieldtarget(s); break;
   case 94: energyfieldtarget(s); break;
   case 95: dispelfieldtarget(s); break;
   case 96: paralyzetarget(s); break;
   case 97: mindblasttarget(s); break;
   case 98: poisonfieldtarget(s); break;
   case 99: nightsighttarget(s); break;
   case 100: clumsytarget(s); break;
   case 101: feeblemindtarget(s); break;
   case 102: weakentarget(s); break;
   case 103: agilitytarget(s); break;
   case 104: cunningtarget(s); break;
   case 105: strengthtarget(s); break;
   case 106: if (chars[currchar[s]].priv&1) npcaitarget(s); break;
   case 107: if (chars[currchar[s]].priv&1) xbanktarget(s); break;
   case 108: alchemytarget(s); break;
   case 109: bottletarget(s); break;
   case 110: if (chars[currchar[s]].priv&1) dupetarget(s); break;
   case 111: if (chars[currchar[s]].priv&1) movetobagtarget(s); break;
   case 112: if (chars[currchar[s]].priv&1) sellstufftarget(s); break;
   case 113: if (chars[currchar[s]].priv&1) manatarget(s); break;
   case 114: if (chars[currchar[s]].priv&1) staminatarget(s); break;
   case 115: if (chars[currchar[s]].priv&1) gmopentarget(s); break;
   case 116: if (chars[currchar[s]].priv&1) makeshoptarget(s); break;
   case 117: followtarget(s); break;
   case 118: attacktarget(s); break;
   case 119: transfertarget(s); break;
   case 121: if (chars[currchar[s]].priv&1) buyshoptarget(s); break;
   case 122: if (chars[currchar[s]].priv&1) setvaluetarget(s); break;
   case 123: if (chars[currchar[s]].priv&1) setrestocktarget(s); break;
   case 124: blesstarget(s); break;
   case 125: cursetarget(s); break;
   case 126: if (chars[currchar[s]].priv&1 || chars[currchar[s]].priv&80) jailtarget(s,-1); break;
   case 127: if (chars[currchar[s]].priv&1 || chars[currchar[s]].priv&80) releasetarget(s,-1); break;
   case 128: createbandagetarget(s); break;
   case 129: if (chars[currchar[s]].priv&1) setamount2target(s); break;
   case 130: healingSkillTarget(s); break;
   case 131: if (chars[currchar[s]].priv&1) permHideTarget(s); break;
   case 132: if (chars[currchar[s]].priv&1) unhidetarget(s); break;
   case 133: if (chars[currchar[s]].priv&1) setwipetarget(s); break;
   case 134: carpentry(s); break;
   case 135: if (chars[currchar[s]].priv&1) setspeechtarget(s); break;
   case 136: if (chars[currchar[s]].priv&1) xteleport(s,0); break;
   case 150: if (chars[currchar[s]].priv&1) setspattacktarget(s); break;
   case 151: if (chars[currchar[s]].priv&1) fullstatstarget(s); break;
   case 152: beggingtarget(s); break;
   case 153: animalloretarget(s); break;
   case 160: inscribe(s,0); break;
   case 161: townvoteformayortarget(s); break;
   case 162: lockpick(s); break;
//   case 163: smeltgold(s); break;
   case 164: wheel(s, YARN); break;
   case 165: loom(s); break;
   case 166: wheel(s, THREAD); break;
   case 167: tailoring(s); break;
   case 168: cookmeat(s); break;
   case 169: cannontarget(s); break;
   case 170: loadcannon(s); break;
   case 171: buildcannon(s); break;
   case 172: fletching(s); break;
   case 173: makedough(s); break;
   case 174: makepizza(s); break;
   case 175: if (chars[currchar[s]].priv&1) setpoisontarget(s); break;
   case 176: if (chars[currchar[s]].priv&1) setpoisonedtarget(s); break;
   case 177: if (chars[currchar[s]].priv&1) setspadelaytarget(s); break;
   case 178: if (chars[currchar[s]].priv&1) setadvobjtarget(s); break;
   case 179: if (chars[currchar[s]].priv&1) setinvulflag(s); break;
   case 180: tinkering(s); break;
   case 181: poisontarget(s); break;  
   case 182: curetarget(s); break;
   case 183: tinkeraxel(s); break;
   case 184: tinkerawg(s); break;
   case 185: tinkerclock(s); break;
   case 186: vialtarget(s); break;
   case 188: manadraintarget(s); break;
   case 189: manavampiretarget(s); break;
   case 190: meteorswarmptarget(s); break;
   case 191: chainlightningtarget(s); break;
   case 192: archcuretarget(s); break;
   case 193: masscursetarget(s); break;
   case 194: massdispeltarget(s); break;
   case 195: magiclocktarget(s); break;
   case 196: magictraptarget(s); break;
   case 197: magicuntraptarget(s); break;
	 case 198: tiling(s); break;
	 case 199: wiping(s); break;
   case 200: if (chars[currchar[s]].priv&1) setitemtrigger(s); break;
   case 201: if (chars[currchar[s]].priv&1) setnpctrigger(s); break;
   case 202: if (chars[currchar[s]].priv&1) settriggertype(s); break;
   case 203: if (chars[currchar[s]].priv&1) settriggerword(s); break;
   case 204: triggerwitem(s,-1,1); break;
   case 205: stealingtarget(s); break;
	 case 206: cantraintarget(s); break;
	 case 207: exppotiontarget(s); break;
   case 209: setsplittarget(s); break;
   case 210: setsplitchancetarget(s); break;
   case 212: possess(s); break;
}
 }
}

void weather(int s) // Send new weather to player
{
 char wdry[5]="\x65\x00\x00\x00";
 char wrain[5]="\x65\x01\x46\x00";
 char wsnow[5]="\x65\x02\x46\xEC";

 if (wtype==0) xsend(s, wdry, 4, 0);
 if (wtype==1) xsend(s, wrain, 4, 0);
 if (wtype==2) xsend(s, wsnow, 4, 0);
}

void dyeitem(int s) // Rehue an item
{
 int i,j;

 for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==buffer[s][1])&&(items[i].ser2==buffer[s][2])&&
      (items[i].ser3==buffer[s][3])&&(items[i].ser4==buffer[s][4]))
  {
   items[i].color1=buffer[s][7];
   items[i].color2=buffer[s][8];
   if (!(dyeall[s]))
   {
    if ( ((items[i].color1*256+items[i].color2)<0x0002) ||
         ((items[i].color1*256+items[i].color2)>0x03E9) )
    {
     items[i].color1=0x03;
     items[i].color2=0xE9;
    }
   }
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
   return;
  }
 }
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][1])&&(chars[i].ser2==buffer[s][2])&&
      (chars[i].ser3==buffer[s][3])&&(chars[i].ser4==buffer[s][4]))
  {
   chars[i].skin1=buffer[s][7];
   chars[i].skin2=buffer[s][8];
   chars[i].xskin1=buffer[s][7];
   chars[i].xskin2=buffer[s][8];
   updatechar(i);
   break;
  }
 }
}

void skillwindow(int s) // Opens the skills list
{
 int i,k;
 //unsigned short int tempskill;
 char skillstart[5]="\x3A\x00\xBE\x00";
 char skillmid[5]="\x00\x00\x00\x00";
 char skillend[3]="\x00\x00";

 k = currchar[s];

 xsend(s, skillstart, 4, 0);
 for (i=0;i<TRUESKILLS;i++)
 {
  updateSkillLevel(k,i);
  skillmid[1]=i+1;
  skillmid[2]=chars[currchar[s]].skill[i]/256;
  skillmid[3]=chars[currchar[s]].skill[i]%256;
  xsend(s, skillmid, 4, 0);
 }
 xsend(s, skillend, 2, 0);
}

void updatestats(int c, char x)
{
 int i, a=0, b=0;
 char updater[10]="\xA1\x01\x02\x03\x04\x01\x03\x01\x02";

 updater[0]=0xA1+x;
 updater[1]=chars[c].ser1;
 updater[2]=chars[c].ser2;
 updater[3]=chars[c].ser3;
 updater[4]=chars[c].ser4;
 if (x==0)
 {
  a=chars[c].st;
  b=chars[c].hp;
 }
 if (x==2)
 {
  a=chars[c].dx;
  b=chars[c].stm;
 }
 if (x==1)
 {
  a=chars[c].in;
  b=chars[c].mn;
 }
 updater[5]=a/256;
 updater[6]=a%256;
 updater[7]=b/256;
 updater[8]=b%256;
 for (i=0;i<now;i++) if (inrange1p(currchar[i], c) && perm[i]) xsend(i, updater, 9, 0);
}

void statwindow(int s, int i) // Opens the status window
{
 int x;
 char statstring[67]="\x11\x00\x42\x00\x05\xA8\x90XYZ\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x34\xFF\x01\x00\x00\x5F\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x00\x75\x30\x01\x2C\x00\x00";

 statstring[3]=chars[i].ser1;
 statstring[4]=chars[i].ser2;
 statstring[5]=chars[i].ser3;
 statstring[6]=chars[i].ser4;
 sprintf(&statstring[7],"%s",chars[i].name);
 statstring[37]=chars[i].hp/256;
 statstring[38]=chars[i].hp%256;
 statstring[39]=chars[i].st/256;
 statstring[40]=chars[i].st%256;
 if ((chars[currchar[s]].priv&1)&&(currchar[s]!=i))
 {
  statstring[41]=0xFF;
 }
 else
 {
  statstring[41]=0x00;
 }
 if ((chars[i].xid1==0x01)&&(chars[i].xid2==0x91))
 {
  statstring[43]=1;
 }
 else
 {
  statstring[43]=0;
 }
 statstring[44]=chars[i].st/256;
 statstring[45]=chars[i].st%256;
 statstring[46]=chars[i].dx/256;
 statstring[47]=chars[i].dx%256;
 statstring[48]=chars[i].in/256; // Real INT
 statstring[49]=chars[i].in%256;
 statstring[50]=chars[i].stm/256;
 statstring[51]=chars[i].stm%256;
 statstring[52]=chars[i].dx/256;
 statstring[53]=chars[i].dx%256;
 statstring[54]=chars[i].mn/256;
 statstring[55]=chars[i].mn%256;
 statstring[56]=chars[i].in/256; // MaxMana
 statstring[57]=chars[i].in%256;
 x=calcgold(i);
 statstring[58]=x/16777216;
 statstring[59]=x/65536;
 statstring[60]=x/256;
 statstring[61]=x%256;
 x=calcdef(i,0);
 statstring[62]=x/256; // AC
 statstring[63]=x%256;
 x=(int)(chars[i].weight);
 statstring[64]=x/256;
 statstring[65]=x%256;
 xsend(s, statstring, 66, 0);
}

void srequest(int s)
{
 if (buffer[s][5]==4) statwindow(s, calcCharFromSer(buffer[s][6], buffer[s][7], buffer[s][8], buffer[s][9]));
 if (buffer[s][5]==5) skillwindow(s);
}

void updates(int s) // Update Window
{
 int x, y, pos, j;

 openscript("misc.scp");
 if (!misc_script.find("MOTD"))
 {
  closescript();
  return;
 }
 pos=ftell(scpfile);
 x=-1;
 y=-2;
 do
 {
  read1();
  x++;
  y+=strlen(script1)+1;
 }
 while (strcmp(script1, "}"));
 y+=10;
 fseek(scpfile, pos, SEEK_SET);
 updscroll[1]=y/256;
 updscroll[2]=y%256;
 updscroll[3]=2;
 updscroll[8]=(y-10)/256;
 updscroll[9]=(y-10)%256;
// xsend(s, pause, 2, 0);
 xsend(s, updscroll, 10, 0);
 for (j=0;j<x;j++)
 {
  read1();
  xsend(s, script1, strlen(script1), 0);
  xsend(s, spc, 1, 0);
 }
// xsend(s, restart, 2, 0);
 closescript();
}

void tips(int s, int i) // Tip of the day window
{
 int x, y, pos, j;

 if (i==0) i=1;
 openscript("misc.scp");
 if (!misc_script.find("TIPS"))
 {
  closescript();
  return;
 }
 x=i;
 do
 {
  read2();
  if (!(strcmp("TIP", script1))) x--;
 }
 while ((x>0)&&script1[0]!='}'&&script1[0]!=0);
 closescript();
 if (!(strcmp("}", script1)))
 {
  tips(s, 1);
  return;
 }
 openscript("misc.scp");
 sprintf(temp, "TIP %i", str2num(script2));
 if (!misc_script.find(temp))
 {
  closescript();
  return;
 }
 pos=ftell(scpfile);
 x=-1;
 y=-2;
 do
 {
  read1();
  x++;
  y+=strlen(script1)+1;
 }
 while (strcmp(script1, "}"));
 y+=10;
 fseek(scpfile, pos, SEEK_SET);
 updscroll[1]=y/256;
 updscroll[2]=y%256;
 updscroll[3]=0;
 updscroll[7]=i;
 updscroll[8]=(y-10)/256;
 updscroll[9]=(y-10)%256;
// xsend(s, pause, 2, 0);
 xsend(s, updscroll, 10, 0);
 for (j=0;j<x;j++)
 {
  read1();
  xsend(s, script1, strlen(script1), 0);
  xsend(s, spc, 1, 0);
 }
// xsend(s, restart, 2, 0);
 closescript();
}

void readbook(int s, int i, int p) // Book window
{
 int x, y, pos, j;
 char bookpage[14]="\x66\x01\x02\x40\x01\x02\x03\x00\x01\x00\x01\x00\x01";

 openscript("misc.scp");
 sprintf(temp, "BOOK %i",
        (items[i].more1*16777216)+(items[i].more2*65536)+(items[i].more3*256)+items[i].more4);
 if (!misc_script.find(temp))
 {
  closescript();
  return;
 }
 x=p;
 do
 {
  do
  {
   read2();
  }
  while (strcmp(script1, "PAGE"));
  x--;
 }
 while (x>0);
 closescript();
 openscript("misc.scp");
 sprintf(temp, "PAGE %s", script2);
 if (!misc_script.find(temp))
 {
  closescript();
  return;
 }
 pos=ftell(scpfile);
 x=-1;
 y=-2;
 do
 {
  read1();
  x++;
  y+=strlen(script1)+1;
 }
 while (strcmp(script1, "}"));
 y+=13;
 fseek(scpfile, pos, SEEK_SET);
 bookpage[1]=y/256;
 bookpage[2]=y%256;
 bookpage[3]=items[i].ser1;
 bookpage[4]=items[i].ser2;
 bookpage[5]=items[i].ser3;
 bookpage[6]=items[i].ser4;
 bookpage[9]=p/256;
 bookpage[10]=p%256;
 bookpage[11]=x/256;
 bookpage[12]=x%256;
// xsend(s, pause, 2, 0);
 xsend(s, bookpage, 13, 0);
 for (j=0;j<x;j++)
 {
  read1();
  xsend(s, script1, strlen(script1)+1, 0);
 }
// xsend(s, restart, 2, 0);
 closescript();
}

void openbook(int s, int i)
{
 char bookopen[9]="\x93\x40\x01\x02\x03\x00\x00\x02";
 char booktitle[61]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
 char bookauthor[31]="\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";

 openscript("misc.scp");
 sprintf(temp, "BOOK %i",
        (items[i].more1*16777216)+(items[i].more2*65536)+(items[i].more3*256)+items[i].more4);
 if (!misc_script.find(temp))
 {
  closescript();
  return;
 }
 bookopen[1]=items[i].ser1;
 bookopen[2]=items[i].ser2;
 bookopen[3]=items[i].ser3;
 bookopen[4]=items[i].ser4;
 do
 {
  read2();
 }
 while (strcmp(script1, "PAGES"));
 bookopen[7]=str2num(script2);
 do
 {
  read2();
 }
 while (strcmp(script1, "TITLE"));
 sprintf(booktitle, "%s", script2);
 do
 {
  read2();
 }
 while (strcmp(script1, "AUTHOR"));
 sprintf(bookauthor, "%s", script2);
// xsend(s, pause, 2, 0);
 xsend(s, bookopen, 8, 0);
 xsend(s, booktitle, 60, 0);
 xsend(s, bookauthor, 30, 0);
// xsend(s, restart, 2, 0);
 closescript();
}

// Dupois - added doorsfx() to be used with dooruse()
// Added Oct 8, 1998
// Plays the proper door sfx for doors/gates/secretdoors
void doorsfx(int item, int x, int y)
{
 const int OPENWOOD = 0xEA;
 const int OPENGATE = 0xEB;
 const int OPENSTEEL = 0xEC;
 const int OPENSECRET = 0xED;
 const int CLOSEWOOD = 0xF1;
 const int CLOSEGATE = 0xF2;
 const int CLOSESTEEL = 0xF3;
 const int CLOSESECRET = 0xF4;

 // printf(" value of door being used is: %x, sfx is set to %d (0=open, 1=close)\n", x, y);

 if (y==0) // Request open door sfx
 {
  if (((x>=0x0695)&&(x<0x06C5))|| // Open wooden / ratan door
  ((x>=0x06D5)&&(x<=0x06F4)))
  soundeffect3(item, 0x00, OPENWOOD);

  if (((x>=0x0839)&&(x<=0x0848))|| // Open gate
  ((x>=0x084C)&&(x<=0x085B))||
  ((x>=0x0866)&&(x<=0x0875)))
  soundeffect3(item, 0x00, OPENGATE);

  if (((x>=0x0675)&&(x<0x0695))|| // Open metal
  ((x>=0x06C5)&&(x<0x06D5)))
  soundeffect3(item, 0x00, OPENSTEEL);

  if ((x>=0x0314)&&(x<=0x0365)) // Open secret
  soundeffect3(item, 0x00, OPENSECRET);
 }
 else if (y==1) // Request close door sfx
 {
  if (((x>=0x0695)&&(x<0x06C5))|| // close wooden / ratan door
  ((x>=0x06D5)&&(x<=0x06F4)))
  soundeffect3(item, 0x00, CLOSEWOOD);

  if (((x>=0x0839)&&(x<=0x0848))|| // close gate
  ((x>=0x084C)&&(x<=0x085B))||
  ((x>=0x0866)&&(x<=0x0875)))
  soundeffect3(item, 0x00, CLOSEGATE);

  if (((x>=0x0675)&&(x<0x0695))|| // close metal
  ((x>=0x06C5)&&(x<0x06D5)))
  soundeffect3(item, 0x00, CLOSESTEEL);

  if ((x>=0x0314)&&(x<=0x0365)) // close secret
  soundeffect3(item, 0x00, CLOSESECRET);
 }
} // doorsfx() END


void dooruse(int s, int item)
{
 int i, db, x, z;
 char changed=0;
 
 //if (items[item].type!=12) return; // Fix locked doors moving
 if ((iteminrange(s,item,2)==0)&& s>-1) {sysmessage(s, "You cannot reach the handle from here");return;}
 for (i=0;i<DOORTYPES;i++)
 {
  db=doorbase[i];
 
  x=((items[item].id1*256)+items[item].id2);
  if (x==(db+0))
  {
   items[item].id2++;
   items[item].x--;
   items[item].y++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+1))
  {
   items[item].id2--;
   items[item].x++;
   items[item].y--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  } else
  if (x==(db+2))
  {
   items[item].id2++;
   items[item].x++;
   items[item].y++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+3))
  {
   items[item].id2--;
   items[item].x--;
   items[item].y--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  } else
 
  if (x==(db+4))
  {
   items[item].id2++;
   items[item].x--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+5))
  {
   items[item].id2--;
   items[item].x++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  } else
  if (x==(db+6))
  {
   items[item].id2++;
   items[item].x++;
   items[item].y--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+7))
  {
   items[item].id2--;
   items[item].x--;
   items[item].y++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  } else
 
  if (x==(db+8))
  {
   items[item].id2++;
   items[item].x++;
   items[item].y++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+9))
  {
   items[item].id2--;
   items[item].x--;
   items[item].y--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  } else
  if (x==(db+10))
  {
   items[item].id2++;
   items[item].x++;
   items[item].y--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+11))
  {
   items[item].id2--;
   items[item].x--;
   items[item].y++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  }
  if (x==(db+12))
  {
   items[item].id2++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+13))
  {
   items[item].id2--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  } else
  if (x==(db+14))
  {
   items[item].id2++;
   items[item].y--;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xEA);
   doorsfx(item, x, 0);
   tempeffect2(0, item, 13, 0, 0, 0);
  } else
  if (x==(db+15))
  {
   items[item].id2--;
   items[item].y++;
   for (z=0;z<now;z++) if (perm[z] && inrange2(z, item)) senditem(z, item);
   changed=1;
//   soundeffect3(item, 0x00, 0xF1);
   doorsfx(item, x, 1);
   items[item].dooropen=0;
  }
 }
 if (changed==0 && s>-1) sysmessage(s, "This doesnt seem to be a valid door type. Contact a GM.");
}

//o---------------------------------------------------------------------------o
//|   Function :  void gmpage(int s,char *reason)
//|   Date     :  Unknown
//|   Programmer  :  Unknown
//o---------------------------------------------------------------------------o
//|   Purpose     :  Help button (Calls GM Call Menus up)
//o---------------------------------------------------------------------------o
void gmpage(int s, char *reason)
{
   int i, a1, a2, a3, a4, x=0;
   int x2=0;

   a1=chars[currchar[s]].ser1;
   a2=chars[currchar[s]].ser2;
   a3=chars[currchar[s]].ser3;
   a4=chars[currchar[s]].ser4;
   
   for(i=1;i<MAXPAGES;i++)
   {
      if(gmpages[i].handled==1)
      {
         gmpages[i].handled=0;
         sprintf(gmpages[i].name,chars[currchar[s]].name);
         sprintf(gmpages[i].reason,reason);
         gmpages[i].ser1=a1;
         gmpages[i].ser2=a2;
         gmpages[i].ser3=a3;
         gmpages[i].ser4=a4;
         time_t current_time = time(0);
         struct tm *local = localtime(&current_time);
         sprintf(gmpages[i].timeofcall, "%02d:%02d:%02d", local->tm_hour, local->tm_min, local->tm_sec);
         sprintf(temp,"%s [%d][%d][%d][%d] called at %s, %s",gmpages[i].name,a1,a2,a3,a4,gmpages[i].timeofcall,gmpages[i].reason);
         if(heartbeat) Writeslot(temp);
         chars[currchar[s]].playercallnum=i;
         chars[currchar[s]].pagegm=1;
         x2++;
         break;
      }
   }
   if (x2==0)
   {
      sysmessage(s,"The GM Queue is currently full. Contact the shard operator");
      sysmessage(s,"and ask them to increase the size of the queue.");
   }
   else
   {
      if(strcmp(reason,"OTHER"))
      {
         chars[currchar[s]].pagegm=0;
         sprintf(temp, "Page from %s [%x %x %x %x]: %s",
         chars[currchar[s]].name, a1, a2, a3, a4, reason);
         for (i=0;i<now;i++) if (chars[currchar[i]].priv&0x20)
         {
            x=1;
            sysmessage(i, temp);
         }
         if (x==1)
         {
            sysmessage(s, "Available Game Masters have been notified of your request.");
         }
         else sysmessage(s, "There was no Game Master available to take your call.");
      }
      else sysmessage(s,"Please enter the reason for your GM request");
   }
}

//o---------------------------------------------------------------------------o
//|   Function -  void cpage(int s,char *reason)
//|   Date     -  UnKnown
//|   Programmer  -  UnKnown  (Touched tabstops by EviLDeD Dec 23, 1998)
//o---------------------------------------------------------------------------o
//|   Purpose     -  
//o---------------------------------------------------------------------------o
void cpage(int s, char *reason) // Help button (Calls Counselor Call Menus up)
{
   int i, a1, a2, a3, a4, x;
   int x2=0;

   x=0;
   a1=chars[currchar[s]].ser1;
   a2=chars[currchar[s]].ser2;
   a3=chars[currchar[s]].ser3;
   a4=chars[currchar[s]].ser4;

   for(i=1;i<MAXPAGES;i++)
   {
      if(counspages[i].handled==1)
      {
         counspages[i].handled=0;
         sprintf(counspages[i].name,chars[currchar[s]].name);
         sprintf(counspages[i].reason,reason);
         counspages[i].ser1=a1;
         counspages[i].ser2=a2;
         counspages[i].ser3=a3;
         counspages[i].ser4=a4;
         time_t current_time = time(0);
         struct tm *local = localtime(&current_time);
         sprintf(counspages[i].timeofcall, "%02d:%02d:%02d", local->tm_hour, local->tm_min, local->tm_sec);
         sprintf(temp,"%s [%d][%d][%d][%d] called at %s, %s",counspages[i].name,a1,a2,a3,a4,counspages[i].timeofcall,counspages[i].reason);
         if(heartbeat) Writeslot(temp);
         chars[currchar[s]].playercallnum=i;
         chars[currchar[s]].pagegm=2;
         x2++;
         break;
      }
   }
   if(x2==0)
   {
      sysmessage(s,"The Counselor Queue is currently full. Contact the shard operator");
      sysmessage(s,"and ask them to increase the size of the queue.");
   }
   else
   {
      if(strcmp(reason,"OTHER"))
      {
         chars[currchar[s]].pagegm=0;
         sprintf(temp, "Counselor Page from %s [%x %x %x %x]: %s",
         chars[currchar[s]].name, a1, a2, a3, a4, reason);
         for (i=0;i<now;i++) if (chars[currchar[i]].priv&0x80)
         {
            x=1;
            sysmessage(i, temp);
         }
         if (x==1)
         {
            sysmessage(s, "Available Counselors have been notified of your request.");
         }
         else sysmessage(s, "There was no Counselor available to take your call.");
      }
      else sysmessage(s,"Please enter the reason for your Counselor request");
   }
}

void get_item(int s) // Client grabs an item
{
 	int i, x,  npc=-1, j, c, amount, packnum, update=0,serial;
 	tile_st tile;

 	serial=calcserial(buffer[s][1],buffer[s][2],buffer[s][3],buffer[s][4]);
 	i=findbyserial(&itemsp[serial%256], serial, 0);

	//test UOP blocking Tauriel 1-12-99
/*	if  (!(chars[currchar[s]].priv&0x01) && (i!=-1) &&
      (items[i].contserial!=chars[currchar[s]].serial))
	{
		x=-1;
		sysmessage(s, "You cannot use items equipped by other players.");
		bounce[1]=0;
		xsend(s, bounce, 2, 0);
		if (items[i].id1>=0x40) senditem(s, i);
		return;
	}*/
	//Zippy's stealing changes  
  x=i;
	if (x!=-1) 
	if (items[x].contserial!=-1)  //Find character owning item
	{
		do  //Find character owning item
 		{
			if (items[x].cont1<0x40) // it's a character
			{
				npc=findbyserial(&charsp[items[x].contserial%256], items[x].contserial, 1);
			} else  //its an item
			{
				x=findbyserial(&itemsp[items[x].contserial%256], items[x].contserial, 0);
				if (x==-1 || items[x].corpse!=0) npc=0; 
			}
 		} while (npc==-1);
	}


// 	if (((items[x].contserial>0)&&(npc>1))&&(!(chars[currchar[s]].priv&0x01))&&
//		 (items[x].layer==0) && (npc!=currchar[s]))
	if (npc>1 && !(chars[currchar[s]].priv&0x01) && npc!=currchar[s])
 	{
	 	//printf("DEBUG: Contser: %i NPC: %i Char: %i",items[x].contserial,npc, currchar[s]);
	 	bounce[1]=0;
	 	xsend(s, bounce, 2, 0);
	 	return;
 	}
	//End Zippy's change
	
	if (i!=-1 && items[i].corpse!=1)
  {
    packnum=packitem(currchar[s]);
    if (checkwhereitem(packnum, i, s))
		{
      //additemweight(i, currchar[s]);
      statwindow(s,currchar[s]);
      //updateweight(s);      not used yet
    }
		seektile((items[i].id1*256)+items[i].id2, &tile);
		if ((((items[i].magic==2)||((tile.weight==255)&&(items[i].magic!=1)))&&((chars[currchar[s]].priv2&1)==0)) ||
         (items[i].magic==3 && !(items[i].ownserial==chars[currchar[s]].serial)))
		{
			bounce[1]=0;
			xsend(s, bounce, 2, 0);
			if (items[i].id1>=0x40) senditem(s, i);
		}
		else
		{
			items[i].layer=0;
			if (items[i].cont1!=0xff) soundeffect(s,0x00,0x57);
			if (items[i].amount>1)
			{
				amount=(buffer[s][5]*256)+buffer[s][6];
				if (amount>items[i].amount) amount=items[i].amount;
				if (amount<items[i].amount)
				{
					c=memitemfree();
					inititem(c);
					memcpy(&items[c], &items[i], sizeof(item_st));  // Tauriel reduce code faster too
					items[c].ser1=itemcount2/16777216;
					items[c].ser2=itemcount2/65536;
					items[c].ser3=itemcount2/256;
					items[c].ser4=itemcount2;
					items[c].serial=itemcount2;
					items[c].amount=items[i].amount-amount;
					//Tauriel sorry, there is no way to make this call the item creation stuff
					setptr(&itemsp[itemcount2%256], c);
					if (items[c].contserial!=-1) setptr(&contsp[items[c].contserial%256], c);
					if (items[c].ownserial!=-1) setptr(&ownsp[items[c].ownserial%256], c);
					if (items[c].spawnserial!=-1) setptr(&spawnsp[items[c].spawnserial%256], c);

					statwindow(s,currchar[s]);
					for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
					if (c==itemcount) itemcount++;
					itemcount2++;
				}

				if (items[i].id1==0x0E && items[i].id2==0xED)
				{
					if (items[i].contserial==items[packnum].serial)
						update=1;
				}
				items[i].amount=amount;
				for (j=0;j<now;j++) if (j!=s) senditem(j,i);
			}
				items[i].x=0;
				items[i].y=0;
				items[i].z=0;
				if (items[i].contserial!=-1) removefromptr(&contsp[items[i].contserial%256], i);
				items[i].cont1=255;
				items[i].cont2=255;
				items[i].cont3=255;
				items[i].cont4=255;
				items[i].contserial=-1;
		}
  }
	if (update) statwindow(s,currchar[s]);
}

void wear_item(int s) // Item is dropped on paperdoll
{
	int a1, a2, a3, a4,cserial,iserial;
	int i, j, k, pack;
	tile_st tile;

	a1=buffer[s][1];
	a2=buffer[s][2];
	a3=buffer[s][3];
	a4=buffer[s][4];
	cserial=calcserial(buffer[s][6],buffer[s][7],buffer[s][8],buffer[s][9]);
	iserial=calcserial(a1,a2,a3,a4);
	k=-1;
 /*for (i=0;i<charcount;i++)
 if ((chars[i].ser1==buffer[s][6])&&(chars[i].ser2==buffer[s][7])&&
     (chars[i].ser3==buffer[s][8])&&(chars[i].ser4==buffer[s][9]))
 {
  k=i;
  break;
 }*/
	k=findbyserial(&charsp[cserial%256], cserial, 1);
/* for (i=0;i<itemcount;i++)
 {
  if ((items[i].ser1==a1)&&(items[i].ser2==a2)&&(items[i].ser3==a3)&&(items[i].ser4==a4))
  {*/
	i=findbyserial(&itemsp[iserial%256], iserial, 0);
	if (i!=-1)
	{
		if (k==currchar[s] && items[i].st>chars[k].st)
    {
			sysmessage(s,"You are not strong enough to use that.");
			bounce[1]=5;
			xsend(s, bounce, 2, 0);
			if(items[i].id1>=0x40) senditem(s, i);
			pack=packitem(currchar[s]);
      if (checkwhereitem(pack, i, s))
      {
				//subtractitemweight( i, currchar[s]);
				statwindow(s,currchar[s]);
      }
			return;
    }
		seektile((items[i].id1*256)+items[i].id2, &tile);
		if ((((items[i].magic==2)||((tile.weight==255)&&(items[i].magic!=1)))&&((chars[currchar[s]].priv2&1)==0)) ||
          (items[i].magic==3 && !(items[i].ownserial==chars[currchar[s]].serial)))
		{
			bounce[1]=5;
			xsend(s, bounce, 2, 0);
			if (items[i].id1>=0x40) senditem(s, i);
			return;
		}
		items[i].cont1=buffer[s][6];
		items[i].cont2=buffer[s][7];
		items[i].cont3=buffer[s][8];
		items[i].cont4=buffer[s][9];
		items[i].contserial=calcserial(items[i].cont1,items[i].cont2,items[i].cont3,items[i].cont4);
		if (items[i].contserial!=-1) setptr(&contsp[items[i].contserial%256], i);
		items[i].layer=buffer[s][5];
		chars[currchar[s]].st = (chars[currchar[s]].st + items[i].st2);
		chars[currchar[s]].dx = (chars[currchar[s]].dx + items[i].dx2);
		chars[currchar[s]].in = (chars[currchar[s]].in + items[i].in2);
		if (showlayer) printf("Item equipped on layer %i.\n",items[i].layer);
		removeitem[1]=items[i].ser1;
		removeitem[2]=items[i].ser2;
		removeitem[3]=items[i].ser3;
		removeitem[4]=items[i].ser4;
		for (j=0;j<now;j++)
		{
			//if ((abs(chars[currchar[j]].x-items[i].x)<VISRANGE)&&(abs(chars[currchar[j]].y-items[i].y)<VISRANGE))
			//{
			if (perm[j]) xsend(j, removeitem, 5, 0);
			//}
		}
		wearitem[1]=items[i].ser1;
		wearitem[2]=items[i].ser2;
		wearitem[3]=items[i].ser3;
		wearitem[4]=items[i].ser4;
		wearitem[5]=items[i].id1;
		wearitem[6]=items[i].id2;
		wearitem[8]=items[i].layer;
		wearitem[9]=items[i].cont1;
		wearitem[10]=items[i].cont2;
		wearitem[11]=items[i].cont3;
		wearitem[12]=items[i].cont4;
		wearitem[13]=items[i].color1;
		wearitem[14]=items[i].color2;
		xsend(s, wearitem, 15, 0);
		//wornitems(s, k);
		for (j=0;j<now;j++)
		{
			if (inrange1(s, j)&&perm[j]) wornitems(j, k);
		}
		// Dupois - see itemsfx() for details
		// Added Oct 09, 1998
		itemsfx(s, items[i].id1, items[i].id2);
		//soundeffect(s, 0x00, 0x48);
		// Dupois - end
		statwindow(s,currchar[s]);
		//break;
	}
// }
}

void dump_item(int s) // Item is dropped on ground
{
  int i, j, k, t,serial,serhash,ci, nChar;
  tile_st tile;

	nChar=currchar[s];  //chars[] array #
  serial=calcserial(buffer[s][1],buffer[s][2],buffer[s][3],buffer[s][4]);
  serhash=serial%256;
  i=findbyserial(&itemsp[serhash], serial, 0);
  if (i!=-1)
  {
		//test UOP blocking Tauriel 1-12-99
		if (items[i].contserial!=-1)
		{
			bounce[1]=5;
			xsend(s, bounce, 2, 0);
      if (items[i].id1>=0x40) senditem(s, i);
      return;
		}

    seektile((items[i].id1*256)+items[i].id2, &tile);
    if ((((items[i].magic==2)||((tile.weight==255)&&(items[i].magic!=1)))&&((chars[currchar[s]].priv2&1)==0)) ||
        (items[i].magic==3 && !(items[i].ownserial==chars[currchar[s]].serial)))
    {
      bounce[1]=5;
      xsend(s, bounce, 2, 0);
      if (items[i].id1>=0x40) senditem(s, i);
      return;
    }
    if (buffer[s][5]!='\xFF')
    {
      items[i].x=(buffer[s][5]*256)+buffer[s][6];
      items[i].y=(buffer[s][7]*256)+buffer[s][8];
      items[i].z=buffer[s][9];
      if (items[i].contserial!=-1) removefromptr(&contsp[items[i].serial%256], i);
      items[i].cont1=255;
      items[i].cont2=255;
      items[i].cont3=255;
      items[i].cont4=255;
      items[i].contserial=-1;
      removeitem[1]=items[i].ser1;
      removeitem[2]=items[i].ser2;
      removeitem[3]=items[i].ser3;
      removeitem[4]=items[i].ser4;
      for (j=0;j<now;j++)
      {
        if (perm[j])
        {
          xsend(j, removeitem, 5, 0);
          senditem(j, i);
        }
      }
    }
    else
    {
       t=calcCharFromSer(buffer[s][10], buffer[s][11], buffer[s][12], buffer[s][13]);
       if (t != -1)
       if (t!=currchar[s])
       {
         if (chars[t].npc)
         {
           //This crazy training stuff done by Anthracks (fred1117@tiac.net)
           if(!(chars[t].id1==0x01 && (chars[t].id2==0x90 || chars[t].id2==0x91)))
           {
             bounce[1]=5;
             xsend(s, bounce, 2, 0);
             if(items[i].contserial==-1) //1==255 && items[i].cont2==255 && items[i].cont3==255 && items[i].cont4==255)
             {
               if (items[i].id1>=0x40) senditem(s, i);
             }
             else
               senditem(s, i);
             return;
           }
           if(chars[nChar].trainer!=chars[t].serial)
           {
             npctalk(s, t, "Thank thee kindly, but I have done nothing to warrant a gift.");
             bounce[1]=5;
             xsend(s, bounce, 2, 0);
             if(items[i].contserial==-1) //1==255 && items[i].cont2==255 && items[i].cont3==255 && items[i].cont4==255)
             {
               if (items[i].id1>=0x40) senditem(s, i);
             }
             else
               senditem(s, i);
             return;
           }
           else // The player is training from this NPC
             { // This NPC is trainging the player
               if(items[i].id1==0x0e && items[i].id2==0xed)
               { // They gave the NPC gold
                 npctalk(s, t, "I thank thee for thy payment. That should give thee a good start on thy way. Farewell!");
                 int oldskill=chars[nChar].baseskill[chars[t].trainingplayerin]; 
                chars[nChar].baseskill[chars[t].trainingplayerin]+=items[i].amount;
                 if(chars[nChar].baseskill[chars[t].trainingplayerin]>250) chars[nChar].baseskill[chars[t].trainingplayerin]=250;
                 updateSkillLevel(nChar, chars[t].trainingplayerin);
                 updateskill(s,chars[t].trainingplayerin);
                 if(items[i].amount>250)
                 { // Paid too much
                   items[i].amount-=250-oldskill;
                   bounce[1]=5;
                   xsend(s, bounce, 2, 0);
                   if(items[i].contserial==-1) //1==255 && items[i].cont2==255 && items[i].cont3==255 && items[i].cont4==255)
                   {
                     if (items[i].id1>=0x40) senditem(s, i);
                   }
                   else
                     senditem(s, i);
                 }
                 else {items[i].free=1; deleitem(i);} // Gave exact change
                 chars[nChar].trainer=-1;
                 chars[t].trainingplayerin=-1;
                 return;
               }
               else // Did not give gold
               {
                 npctalk(s, t, "I am sorry, but I can only accept gold.");
                 bounce[1]=5;
                 xsend(s, bounce, 2, 0);
                 if(items[i].contserial==-1) //1==255 && items[i].cont2==255 && items[i].cont3==255 && items[i].cont4==255)
                 {
                   if (items[i].id1>=0x40) senditem(s, i);
                 }
                 else
                   senditem(s, i);
                 return;
               }
           }
        }
	     else
        {
          j=tradestart(s, t);
          if (items[i].contserial!=-1) removefromptr(&contsp[items[i].serial%256], i);
          setserial(i, j, 1);
          items[i].x=30;
          items[i].y=30;
          items[i].z=9;
          removeitem[1]=items[i].ser1;
          removeitem[2]=items[i].ser2;
          removeitem[3]=items[i].ser3;
          removeitem[4]=items[i].ser4;
          for (k=0;k<now;k++)
          {
            if (perm[k])
            {
              xsend(k, removeitem, 5, 0);
              sendbpitem(k, i);
            }
          }
        }
      }
      else
      {
        serial=chars[t].serial;
        serhash=serial%256;
        for (ci=0;ci<contsp[serhash].max;ci++)
        {
          j=contsp[serhash].pointer[ci];
          if ((j!=-1) && (items[j].contserial==chars[t].serial) &&
            ((items[j].type==1)||(items[j].type==63)||(items[j].type==65))&&(items[j].layer==0x15))
          {
            if (items[j].contserial!=-1) removefromptr(&contsp[items[j].serial%256], i);
            setserial(i, j,1);
            items[i].x=20+(rand()%100);
            items[i].y=40+(rand()%80);
            items[i].z=9;
            removeitem[1]=items[i].ser1;
            removeitem[2]=items[i].ser2;
            removeitem[3]=items[i].ser3;
            removeitem[4]=items[i].ser4;
            for (k=0;k<now;k++)
            {
              if (perm[k])
              {
                xsend(k, removeitem, 5, 0);
                senditem(k, i);
              }
            }
            break;
          }
        }
      }
    }
  //chars[currchar[s]].weight=calcweight(currchar[s]);
  statwindow(s,currchar[s]);
  // Dupois - see itemsfx() for details
  // Added Oct 09, 1998
  itemsfx(s, items[i].id1, items[i].id2);
  // Dupois - end
  }
}

void pack_item(int s) // Item is put into container
{
  int nCont=-1, nItem=-1;
  int j, k, z, serial, serhash;
  tile_st tile;
  char bufftemp[50];
  strcpy(bufftemp, buffer[s]);

  //p=-1,q=-1;
 // Tauriel 11-27-98 loop through items once to find p & k not twice!
  serial=calcserial(buffer[s][10],buffer[s][11],buffer[s][12],buffer[s][13]);
  serhash=serial%256;
  nCont=findbyserial(&itemsp[serhash], serial, 0);

  serial=calcserial(buffer[s][1],buffer[s][2],buffer[s][3],buffer[s][4]);
  serhash=serial%256;
  nItem=findbyserial(&itemsp[serhash], serial, 0);

  if (items[nCont].layer==0 && items[nCont].id1==0x1E && items[nCont].id2==0x5E &&
      items[nCont].contserial==chars[currchar[s]].serial)
  {
    // Trade window???
    serial=calcserial(items[nCont].moreb1, items[nCont].moreb2, items[nCont].moreb3, items[nCont].moreb4);
    z=findbyserial(&itemsp[serial%256], serial, 0);

    if ((z!=-1) && (items[z].morez || items[nCont].morez))
    {
      items[z].morez=0;
      items[nCont].morez=0;
      sendtradestatus(z, nCont);
    }
  }
 
  if (nCont==-1)
  {
    for (j=0;j<now;j++) if (perm[j]) senditem(j, nCont);
    return;
  }
	//testing UOP Blocking Tauriel 1-12-99
		if (items[nItem].contserial!=-1)
		{
			bounce[1]=5;
			xsend(s, bounce, 2, 0);
      if (items[nItem].id1>=0x40) senditem(s, nItem);
      return;
		}

  seektile((items[nItem].id1*256)+items[nItem].id2, &tile);
  if ((((items[nItem].magic==2)||((tile.weight==255)&&(items[nItem].magic!=1)&&(items[nCont].corpse!=1)))&&((chars[currchar[s]].priv2&1)==0)) ||
        (items[nItem].magic==3 && !(items[nItem].ownserial==chars[currchar[s]].serial)))
  {
    bounce[1]=5;
    xsend(s, bounce, 2, 0);
    if (items[nCont].id1>=0x40) senditem(s, nCont);
    return;
  }
    // - Trash container
  if (items[nCont].type==87)
  {
    deleitem(nItem);
    sysmessage(s, "As you let go of the item it disappears.");
    return;
  }
    // - Spell Book
  if (items[nCont].type==9)
  {
    if (items[nItem].id1!=0x1F || items[nItem].id2<0x2D || items[nItem].id2>0x72)
    {
      bounce[1]=5;
      xsend(s, bounce, 2, 0);
      sysmessage(s, "You can only place spell scrolls in a spellbook!");
      if (items[nCont].id1>=0x40) senditem(s, nCont);
      return;
    }
    z=packitem(currchar[s]);
    if ((!(items[nCont].contserial==chars[currchar[s]].serial)) &&
       (!(items[nCont].contserial==items[z].serial)) && (!(chars[currchar[s]].priv&0x40)))
    {
      bounce[1]=5;
      xsend(s, bounce, 2, 0);
      sysmessage(s, "You cannot place spells in other peoples spellbooks.");
      if (items[nCont].id1>=0x40) senditem(s, nCont);
      return;
    }
  }

  if (!(((items[nCont].pileable)&&(items[nItem].pileable)&&
         (items[nCont].id1==items[nItem].id1)&&(items[nCont].id2==items[nItem].id2)) ||
         ((items[nCont].type!=1)&&(items[nCont].type!=9))))
  {
    if (items[nItem].contserial!=-1) removefromptr(&contsp[items[nItem].contserial%256], nItem);
    setserial(nItem, nCont, 1);
    if (buffer[s][5]!='\xFF')
    {
      items[nItem].x=(buffer[s][5]*256)+buffer[s][6];
      items[nItem].y=(buffer[s][7]*256)+buffer[s][8];
    }
    else
    {
      items[nItem].x=95;
      items[nItem].y=80;
    }
    items[nItem].z=9;
    removeitem[1]=items[nItem].ser1;
    removeitem[2]=items[nItem].ser2;
    removeitem[3]=items[nItem].ser3;
    removeitem[4]=items[nItem].ser4;
    for (j=0;j<now;j++)
    {
      if (perm[j]) xsend(j, removeitem, 5, 0);
      senditem(j, nItem);
    }
    // Dupois - see itemsfx() for details
    // Added Oct 09, 1998
    itemsfx(s, items[nItem].id1, items[nItem].id2);
    //soundeffect(s, 0x00, 0x48);
    // Dupois - end
    statwindow(s,currchar[s]);
  }
  else
      // - Unlocked item spawner or unlockable item spawner
  if (items[nCont].type==63 || items[nCont].type==65)
  {
    items[nItem].cont1=buffer[s][10];
    items[nItem].cont2=buffer[s][11];
    items[nItem].cont3=buffer[s][12];
    items[nItem].cont4=buffer[s][13];
    items[nItem].contserial=calcserial(buffer[s][10],buffer[s][11],buffer[s][12],buffer[s][13]);
 
    removeitem[1]=items[nItem].ser1;
    removeitem[2]=items[nItem].ser2;
    removeitem[3]=items[nItem].ser3;
    removeitem[4]=items[nItem].ser4;
    for (j=0;j<now;j++)
    {
      if (perm[j]) xsend(j, removeitem, 5, 0);
      senditem(j, nItem);
    }
    // Dupois - see itemsfx() for details
    // Added Oct 09, 1998
    itemsfx(s, items[nItem].id1, items[nItem].id2);
    //soundeffect(s, 0x00, 0x48);
    // Dupois - end
  }
  else  // - Pileable
  if ((items[nCont].pileable) && (items[nItem].pileable) &&
      (items[nCont].id1==items[nItem].id1)&&(items[nCont].id2==items[nItem].id2))
  {
    if ( (items[nCont].amount+items[nItem].amount) > 65535)
    {
      items[nItem].amount -= (65535-items[nCont].amount);
      dupeitem(s, nCont, items[nItem].amount);
      items[nCont].amount = 65535;
      deleitem(nItem);
    }
    else
    {
      items[nCont].amount=items[nCont].amount+items[nItem].amount;
      deleitem(nItem);
      itemsfx(s, items[nItem].id1, items[nItem].id2);
    }
    for (j=0;j<now;j++) if (perm[j]) 
    {
      senditem(j, nCont);
    }
 }
 else
 {
  items[nItem].x=(buffer[s][5]*256)+buffer[s][6];
  items[nItem].y=(buffer[s][7]*256)+buffer[s][8];
  items[nItem].z=buffer[s][9];
  if (items[nItem].contserial!=-1) removefromptr(&contsp[items[nItem].contserial%256], nItem);
  items[nItem].cont1=255;
  items[nItem].cont2=255;
  items[nItem].cont3=255;
  items[nItem].cont4=255;
  items[nItem].contserial=-1;
  removeitem[1]=items[nItem].ser1;
  removeitem[2]=items[nItem].ser2;
  removeitem[3]=items[nItem].ser3;
  removeitem[4]=items[nItem].ser4;
  for (k=0;k<now;k++)
  {
   if (perm[k]) xsend(k, removeitem, 5, 0);
  }
  for (j=0;j<now;j++) if (perm[j]) senditem(j, nCont);
 }
}

void startchar(int s) // Send character startup stuff to player
{
 char zbuf[255];
 char modeset[6]="\x72\x00\x00\x32\x00";
 char techstuff[21]="\x69\x00\x05\x01\x00\x69\x00\x05\x02\x00\x69\x00\x05\x03\x00\x55\x5B\x0C\x13\x03";
 char startup[38]="\x1B\x00\x05\xA8\x90\x00\x00\x00\x00\x01\x90\x06\x08\x06\x49\x00\x0A\x04\x00\x00\x00\x7F\x00\x00\x00\x00\x00\x07\x80\x09\x60\x00\x00\x00\x00\x00\x00";
  int i,serial,serhash,ci;

 perm[s]=1;
 targetok[s]=0;
 startup[1]=chars[currchar[s]].ser1;
 startup[2]=chars[currchar[s]].ser2;
 startup[3]=chars[currchar[s]].ser3;
 startup[4]=chars[currchar[s]].ser4;
 startup[9]=chars[currchar[s]].id1;
 startup[10]=chars[currchar[s]].id2;
 startup[11]=chars[currchar[s]].x/256;
 startup[12]=chars[currchar[s]].x%256;
 startup[13]=chars[currchar[s]].y/256;
 startup[14]=chars[currchar[s]].y%256;
 startup[16]=chars[currchar[s]].z;
 startup[17]=chars[currchar[s]].dir;
 chars[currchar[s]].spiritspeaktimer=0;  // initially set spiritspeak timer to 0

 xsend(s, startup, 37, 0);
// xsend(s, pause, 2, 0);
 chars[currchar[s]].war=0;
 wornitems(s, currchar[s]);
 teleport(currchar[s]);
 xsend(s, modeset, 5, 0);
 impowncreate(s, currchar[s], 0);
 xsend(s, techstuff, 20, 0);
//chars[currchar[s]].weight=calcweight(currchar[s]);
 #ifdef __NT__
  sprintf(idname, "%s Server Version %s Alpha [WIN32] by %s <%s>", PRODUCT, VER, NAME, EMAIL);
 #else
  sprintf(idname, "Ultima Offline eXperiment 3 Server Version %s Alpha [LINUX] by %s <%s>", VER, NAME, EMAIL);
 #endif
 sysmessage(s, idname);
 weather(s);
// xsend(s, restart, 2, 0);
 updates(s);
 chars[currchar[s]].region=255;
 checkregion(currchar[s]);
 //Tauriel set packitem at login
// for (i=0;i<itemcount;i++)
// if ((items[i].cont1==chars[s].ser1)&&(items[i].cont2==chars[s].ser2)&&
//     (items[i].cont3==chars[s].ser3)&&(items[i].cont4==chars[s].ser4)&&
  serial=chars[s].serial;
  serhash=serial%256;
  for (i=0;i<contsp[serhash].max;i++)
  {
    ci=contsp[serhash].pointer[i];
    if ((items[ci].contserial==serial) && (items[i].layer==0x15))
    {
      chars[currchar[s]].packitem=ci;
    }
  }
 if (server_data.joinmsg)
 {
   sprintf(temp,"%s entered the realm",chars[currchar[s]].name);//message upon entering a server
   sysbroadcast(temp);//message upon entering a server
 }
 sprintf(zbuf,"%s Logged in the game",chars[currchar[s]].name); //for logging to UOXmon
 if(heartbeat) Writeslot(zbuf);
 acctinuse[acctno[s]]=1;
}

int validhair(int a, int b) // Is selected hair type valid
{
 int x=1;

 if (a!='\x20') x=0;
 if ((b!='\x3B')&&(b!='\x3C')&&(b!='\x3D')&&(b!='\x44')&&(b!='\x45')&&(b!='\x46')&&
     (b!='\x47')&&(b!='\x48')&&(b!='\x49')&&(b!='\x4A')) x=0;
 return x;
}

int validbeard(int a, int b) // Is selected beard type valid
{
 int x=1;

 if (a!='\x20') x=0;
 if ((b!='\x3E')&&(b!='\x3F')&&(b!='\x40')&&(b!='\x41')&&(b!='\x4B')&&(b!='\x4C')&&
     (b!='\x4D')) x=0;
 return x;
}

void charcreate(int s) // All the character creation stuff
{
 int i,n;
 int randbuf;
 //unsigned short int tempskill;
 int totalstats,totalskills;
	unsigned int c;
 c=memcharfree ();
 
 initchar(c);

 for (i=0;i<=strlen(&buffer[s][10]);i++) chars[c].name[i]=buffer[s][10+i];
 chars[c].account=acctno[s];
 if (buffer[s][0x46]!='\x00')
 {
  chars[c].id2='\x91';
  chars[c].xid2='\x91';
 }
 chars[c].skin1=buffer[s][0x50]|0x80;
 chars[c].skin2=buffer[s][0x51];
 if ( ((chars[c].skin1*256+chars[c].skin2)<0x83EA) ||
      ((chars[c].skin1*256+chars[c].skin2)>0x8422) )
 {
  chars[c].skin1=0x83;
  chars[c].skin2=0xEA;
 }
 chars[c].xskin1=chars[c].skin1;
 chars[c].xskin2=chars[c].skin2;
 chars[c].priv=defaultpriv1;
 chars[c].priv2=defaultpriv2;
 if (acctno[s]==0) chars[c].priv=0xE7;
 chars[c].x=makenum2(start[buffer[s][0x5B]][2]);
 chars[c].y=makenum2(start[buffer[s][0x5B]][3]);
 chars[c].dispz=chars[c].z=makenum2(start[buffer[s][0x5B]][4]);

 chars[c].dir=4;

 chars[c].hp=chars[c].st=buffer[s][0x47];
 if (chars[c].st>45) chars[c].st=45;          // fix for hack exploit
 if (chars[c].st<10) chars[c].st=10;
 totalstats=chars[c].st;
 chars[c].stm=chars[c].dx=buffer[s][0x48];
 if (chars[c].dx>45) chars[c].dx=45;          // fix for hack exploit
 if (chars[c].dx<10) chars[c].dx=10;
 if (chars[c].dx+totalstats>65) chars[c].dx=65-totalstats;
 totalstats+=chars[c].dx;
 chars[c].mn=chars[c].in=buffer[s][0x49];
 if (chars[c].in>45) chars[c].in=45;          // fix for hack exploit
 if (chars[c].in<10) chars[c].in=10;
 if (chars[c].in+totalstats>65) chars[c].in=65-totalstats;

 if (buffer[s][0x4b]>50) buffer[s][0x4b]=50; // fixes for hack exploit
 totalskills=buffer[s][0x4b];
 if (buffer[s][0x4d]>50) buffer[s][0x4d]=50;
 if (buffer[s][0x4d]+totalskills>100) buffer[s][0x4d]=100-totalskills;
 totalskills+=buffer[s][0x4d];
 if (buffer[s][0x4f]>50) buffer[s][0x4f]=50;
 if (buffer[s][0x4f]+totalskills>100) buffer[s][0x4f]=100-totalskills;

 for (i=0;i<TRUESKILLS;i++)
 {
  chars[c].baseskill[i]=0;
  if (i==buffer[s][0x4a]) chars[c].baseskill[buffer[s][0x4a]]=buffer[s][0x4b]*10;
  if (i==buffer[s][0x4c]) chars[c].baseskill[buffer[s][0x4c]]=buffer[s][0x4d]*10;
  if (i==buffer[s][0x4e]) chars[c].baseskill[buffer[s][0x4e]]=buffer[s][0x4f]*10;
  updateSkillLevel(c, i);
 }

 if (validhair(buffer[s][0x52],buffer[s][0x53]))
 {

  n=SpawnItem(s,1, "#", 0, buffer[s][0x52], buffer[s][0x53], buffer[s][0x54], buffer[s][0x55],0,0);
  if ( ((items[n].color1*256+items[n].color2)<0x044E) ||
       ((items[n].color1*256+items[n].color2)>0x04AD) )
  {
   items[n].color1=0x04;
   items[n].color2=0x4E;
  }
  setserial(n, c, 4);
  items[n].layer=0x0B;
 }

 if ( (validbeard(buffer[s][0x56],buffer[s][0x57])) && (chars[c].id2==0x90) )
 {
  n=SpawnItem(s,1, "#", 0, buffer[s][0x56], buffer[s][0x57], buffer[s][0x58], buffer[s][0x59],0,0);
  if ( ((items[n].color1*256+items[n].color2)<0x044E) ||
       ((items[n].color1*256+items[n].color2)>0x04AD) )
  {
   items[n].color1=0x04;
   items[n].color2=0x4E;
  }
  setserial(n, c, 4);
  items[n].layer=0x10;
 }
  // - create the backpack
 chars[c].packitem=n=SpawnItem(s,1, "#", 0, 0x0E, 0x75, 0, 0,0,0);
 setserial(n, c, 4);
 items[n].layer=0x15;
 items[n].type=1;
 items[n].dye=1;
 n=SpawnItem(s,1,"#",0,0x09,0x15,0,0,0,0);
 randbuf=rand()%2;
 if (randbuf==0)
 {
  if ((chars[c].id2=='\x90') && (chars[c].xid2=='\x90'))
  {
   items[n].id1=0x15;
   items[n].id2=0x39;
   items[n].layer=0x04;
  } else
  {
   items[n].id1=0x15;
   items[n].id2=0x16;
   items[n].layer=23;
  }
 }
 if (randbuf==1)
 {
  if ((chars[c].id2=='\x90') && (chars[c].xid2=='\x90'))
  {
   items[n].id1=0x15;
   items[n].id2=0x2E;
   items[n].layer=0x04;
  } else
  {
   items[n].id1=0x15;
   items[n].id2=0x37;
   items[n].layer=23;
  }
 }
 randbuf=rand()%6;
 if (randbuf==0)
 {
  items[n].color1=0x02;
  items[n].color2=0x84;
 }
 if (randbuf==1)
 {
  items[n].color1=0x02;
  items[n].color2=0x1F;
 }
 if (randbuf==2)
 {
  items[n].color1=0x03;
  items[n].color2=0xC3;
 }
 if (randbuf==3)
 {
  items[n].color1=0x03;
  items[n].color2=0xD9;
 }
 if (randbuf==4)
 {
  items[n].color1=0x02;
  items[n].color2=0xE8;
 }
 if (randbuf==5)
 {
  items[n].color1=0x02;
  items[n].color2=0xD1;
 }
 setserial(n, c, 4);
 items[n].type=0;
 items[n].dye=1;

 n=SpawnItem(s,1,"#",0,0x09,0x15,0,0,0,0);

 randbuf=rand()%2;
 if (randbuf==0)
 {
  items[n].id1=0x1E;
  items[n].id2=0xFD;
 }
 if (randbuf==1)
 {
  items[n].id1=0x15;
  items[n].id2=0x17;
 }
 randbuf=rand()%5;
 if (randbuf==0)
 {
  items[n].color1=0x01;
  items[n].color2=0x34;
 }
 if (randbuf==1)
 {
  items[n].color1=0x00;
  items[n].color2=0x28;
 }
 if (randbuf==2)
 {
  items[n].color1=0x00;
  items[n].color2=0x35;
 }
 if (randbuf==3)
 {
  items[n].color1=0x01;
  items[n].color2=0xCA;
 }
 if (randbuf==4)
 {
  items[n].color1=0x02;
  items[n].color2=0x1A;
 }
 setserial(n, c, 4);
 items[n].layer=0x05;
 items[n].dye=1;
 items[n].def=1;

 n=SpawnItem(s,1,"#",0,0x17,0x0F,0x02,0x87,0,0);
 setserial(n, c, 4);
 items[n].layer=0x03;
 items[n].dye=1;
 items[n].def=1;

 n=SpawnItem(s,1,"#",0,0x0F,0x51,0,0,0,0);
 setserial(n, c, 4);
 items[n].layer=0x01;
 items[n].att=5;

#ifdef SPECIAL
 n=SpawnItem(s,1,"#",0,0x09,0x15,0,0,0,0);
 randbuf=rand()%7;
 if (randbuf==0)
 {
  items[n].id1=0x15;
  items[n].id2=0x4b;
 }
 if (randbuf==1)
 {
  items[n].id1=0x15;
  items[n].id2=0x45;
 }
 if (randbuf==2)
 {
  items[n].id1=0x15;
  items[n].id2=0x47;
 }
 if (randbuf==3)
 {
  items[n].id1=0x15;
  items[n].id2=0x49;
 }
 if (randbuf==4)
 {
  items[n].id1=0x17;
  items[n].id2=0x1c;
 }
 if (randbuf==5)
 {
  items[n].id1=0x1f;
  items[n].id2=0x0b;
 }
 if (randbuf==6)
 {
  items[n].id1=0x14;
  items[n].id2=0x51;
 }
 setserial(n, c, 4);
 items[n].layer=0x06;
#endif

 // Give the character some gold
 n=SpawnItem(s,goldamount,"#",1,0x0E,0xED,0,0,1,0);
 setserial(n, packitem(c), 1);
 items[n].layer=0x01;
 items[n].att=5;

 currchar[s]=c;
 newbieitems(c);

 perm[s]=1;
/* if (c==charcount)
  {
  charcount++;
  charcount2++;
  }*/

 startchar(s);
}

void charplay (int s) // After hitting "Play Character" button
{
 int i, j, k;

 if (acctno[s]>-1)
 {
  j=0;
  k=-1;
  for (i=0;i<charcount;i++)
  {
   if ((chars[i].account==acctno[s])&&(chars[i].npc==0)&&(chars[i].free==0))
   {
    if (j==buffer[s][0x44]) k=i;
    j++;
   }
  }
  if (k!=-1)
  {
   currchar[s]=k;
   startchar(s);
  }
 }
 else
 {
  disconnect(s);
 }
}

void deny(int k, int s, int sequence)
{
 char walkdeny[9]="\x21\x00\x01\x02\x01\x02\x00\x01";

 walkdeny[1]=sequence;
 walkdeny[2]=chars[s].x/256;
 walkdeny[3]=chars[s].x%256;
 walkdeny[4]=chars[s].y/256;
 walkdeny[5]=chars[s].y%256;
 walkdeny[6]=chars[s].dir;
 walkdeny[7]=chars[s].dispz;
 xsend(k, walkdeny, 8, 0);
 walksequence[k]=-1;
}

void walking(int s, int dir, int sequence)
{
 char walkok[4]="\x22\x00\x01";
 int oldx, oldy, newx, newy, i, j, k;
 signed char z, oldz, seekz, dispz=0;
 int num;
 tile_st tile;
 land_st land;
 long int pos, pos2, length, fpos;
 int x, y, x1, x2;
 int y1, y2;
 struct map_st
 {
  short int id;
  signed char z;
 };
 signed int testz;
 char gmbody;
 map_st map1, map2, map3, map4;
 staticrecord stat;
 FILE *mfile;
 st_multi multi;

 k=calcSocketFromChar(s);
 if ((k!=-1)&&(walksequence[k]+1!=sequence)&&(sequence!=256))
 {
  deny(k, s, sequence);
  return;
 }
   // if (!checkweight(s, k)) return; //check if char are overload - Tauriel
   //fix for lag with checking weight (also weight.cpp), don't check for npcs, gms, counselors
 //Bud rem'd out weight check for walking till weight code works well
// if (!chars[s].npc && !(chars[s].priv&0x01) && !(chars[s].priv&0x80))
// { 
//    if (!checkweight(s, k) || (chars[s].stm<3))
//    {
//       sysmessage(k, "you are too fatigued to move.");
//       return;
//    }
// }
   // -- end of lag fix for checking weight
 if (chars[s].priv2&2)
 {
  if (k!=-1)
  {
   teleport(s);
   sysmessage(k, "You are frozen and cannot move.");
  }
 }
 else
 {
  oldx=chars[s].x;
  oldy=chars[s].y;
  if ((dir&0x0F)==chars[s].dir)
  {
   if ((chars[s].hidden)&&(!(chars[s].priv2&8)))
   {
    chars[s].hidden=0;
   }

   if (chars[s].npc) chars[s].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC)); //reset move timer

   switch(dir&0x0F)
   {
    case '\x00' : chars[s].y--;
    break;
    case '\x01' : { chars[s].x++; chars[s].y--; }
    break;
    case '\x02' : chars[s].x++;
    break;
    case '\x03' : { chars[s].x++; chars[s].y++; }
    break;
    case '\x04' : chars[s].y++;
    break;
    case '\x05' : { chars[s].x--; chars[s].y++; }
    break;
    case '\x06' : chars[s].x--;
    break;
    case '\x07' : { chars[s].x--; chars[s].y--; }
    break;
   }

  xycount=0;

  x=chars[s].x;
  y=chars[s].y;

  x1=x/8; // Block
  y1=y/8;
  x2=(x-(x1*8)); // Offset
  y2=(y-(y1*8));
  pos=(x1*512*196)+(y1*196)+(y2*24)+(x2*3)+4;
  fseek(mapfile, pos, SEEK_SET);
  fread(&map1, 3, 1, mapfile);

  if (map1.id!=2)
  {
   x=chars[s].x+1;
   y=chars[s].y;
   x1=x/8; // Block
   y1=y/8;
   x2=(x-(x1*8)); // Offset
   y2=(y-(y1*8));
   pos=(x1*512*196)+(y1*196)+(y2*24)+(x2*3)+4;
   fseek(mapfile, pos, SEEK_SET);
   fread(&map2, 3, 1, mapfile);

   x=chars[s].x;
   y=chars[s].y+1;
   x1=x/8; // Block
   y1=y/8;
   x2=(x-(x1*8)); // Offset
   y2=(y-(y1*8));
   pos=(x1*512*196)+(y1*196)+(y2*24)+(x2*3)+4;
   fseek(mapfile, pos, SEEK_SET);
   fread(&map3, 3, 1, mapfile);

   x=chars[s].x+1;
   y=chars[s].y+1;
   x1=x/8; // Block
   y1=y/8;
   x2=(x-(x1*8)); // Offset
   y2=(y-(y1*8));
   pos=(x1*512*196)+(y1*196)+(y2*24)+(x2*3)+4;
   fseek(mapfile, pos, SEEK_SET);
   fread(&map4, 3, 1, mapfile);

   if (abs(map1.z-map4.z) <= abs(map2.z-map3.z))
   {
    testz=map1.z+map4.z;
   }
   else
   {
    testz=map2.z+map3.z;
   }

   seekland(map1.id, &land);

   xyblock[xycount].type=0;
   xyblock[xycount].basez=testz/2;
   if (testz%2<0) xyblock[xycount].basez--;
    // ^^^ Fix to make it round DOWN, not just in the direction of zero
    // If your compiler does this already (though I dont think any compiler will), comment this out
   xyblock[xycount].id=map1.id;
   xyblock[xycount].flag1=land.flag1;
   xyblock[xycount].flag2=land.flag2;
   xyblock[xycount].flag3=land.flag3;
   xyblock[xycount].flag4=land.flag4;
   xyblock[xycount].height=0;
   xyblock[xycount].weight=255;
   xycount++;
  }

  // - This needs to use a pointer/array to cut down on walking lag...
  for (i=0;i<itemcount;i++)
  {
    if (items[i].id1<0x40)
    {
      if ((items[i].x==chars[s].x)&&(items[i].y==chars[s].y))
      {
        if (items[i].trigger!=0)
        {
          if ((items[i].trigtype==1)&&(!chars[s].dead))
          {
            if (!items[i].disabled)
            {
              triggerwitem(k,i,1);  //When player steps on a trigger
            }
          }
        }
        seektile(items[i].id1*256+items[i].id2, &tile);
        xyblock[xycount].type=1;
        xyblock[xycount].basez=items[i].z;
        xyblock[xycount].id=items[i].id1*256+items[i].id2;
        xyblock[xycount].flag1=tile.flag1;
        xyblock[xycount].flag2=tile.flag2;
        xyblock[xycount].flag3=tile.flag3;
        xyblock[xycount].flag4=tile.flag4;
        xyblock[xycount].height=tile.height;
        xyblock[xycount].weight=tile.weight;
        xycount++;
      }
    }
   else
   {
    if (
        (abs(items[i].x-chars[s].x)<=BUILDRANGE)&&
        (abs(items[i].y-chars[s].y)<=BUILDRANGE)
        )
    {
     seekmulti((items[i].id1*256+items[i].id2)-0x4000, &mfile, &length);
     length=length/sizeof(st_multi);
         if (length == -1)
         {
                printf("walking() - Bad length in multi file. Avoiding stall.\n");
                length = 0;
         }
     for (j=0;j<length;j++)
     {
      fread(&multi, sizeof(st_multi), 1, mfile);
      if (multi.visible && (items[i].x+multi.x == chars[s].x) && (items[i].y+multi.y == chars[s].y))
      {
       fpos=ftell(mfile);
       seektile(multi.tile, &tile);
       fseek(mfile, fpos, SEEK_SET);
       xyblock[xycount].type=2;
       xyblock[xycount].basez=multi.z+items[i].z;
       xyblock[xycount].id=multi.tile;
       xyblock[xycount].flag1=tile.flag1;
       xyblock[xycount].flag2=tile.flag2;
       xyblock[xycount].flag3=tile.flag3;
       xyblock[xycount].flag4=tile.flag4;
       xyblock[xycount].height=tile.height;
       xyblock[xycount].weight=255;
       xycount++;
      }
     }
    }
   }
  } //- end of itemcount for loop

  x=chars[s].x;
  y=chars[s].y;
  x1=x/8; // Block
  y1=y/8;
  x2=(x-(x1*8)); // Offset
  y2=(y-(y1*8));
  pos=(x1*512*12)+(y1*12);
  fseek(sidxfile, pos, SEEK_SET);
  fread(&pos2, 4, 1, sidxfile);
  if (pos2!=-1)
  {
   fread(&length, 4, 1, sidxfile);
   length=length/7;
   fseek(statfile, pos2, SEEK_SET);
   for (i=0;i<length;i++)
   {
    fread(&stat, 7, 1, statfile);
    if ((stat.xoff==x2)&&(stat.yoff==y2))
    {
     seektile(stat.itemid, &tile);
     xyblock[xycount].type=2;
     xyblock[xycount].basez=stat.zoff;
     xyblock[xycount].id=stat.itemid;
     xyblock[xycount].flag1=tile.flag1;
     xyblock[xycount].flag2=tile.flag2;
     xyblock[xycount].flag3=tile.flag3;
     xyblock[xycount].flag4=tile.flag4;
     xyblock[xycount].height=tile.height;
     xyblock[xycount].weight=255;
     xycount++;
    }
   }
  }

  z=-128;
  oldz=chars[s].z;
  if (
     ((chars[s].id1==0x03)&&(chars[s].id2==0xDB)) ||
     ((chars[s].id1==0x01)&&(chars[s].id2==0x92)) ||
     ((chars[s].id1==0x01)&&(chars[s].id2==0x93))
     ) gmbody=1; else gmbody=0;
  do
  {
   seekz=127;
   num=-1;
   for (i=0;i<xycount;i++)
   {
    if (xyblock[i].basez+xyblock[i].height<seekz)
    {
     num=i;
     seekz=xyblock[i].basez+xyblock[i].height;
    }
   }
   if (num==-1)
   {
#ifdef DEBUG
    printf("(walking) Error?\n");
#endif
    xycount=0;
    z=-128;
   }
   else
   {
//    printf("xyBaseZ: %i, xyHeight: %i, xyType: %i\n", xyblock[num].basez, xyblock[num].height, xyblock[num].type);
//    printf("xyid: %i, oldz: %i, cpriv: %i cpriv2: %i\n", xyblock[num].id, oldz, chars[s].priv, chars[s].priv2);
//    printf("xyflag1: %i, xyflag2: %i, xyflag3: %i, xyflag4: %i\n", xyblock[num].flag1,xyblock[num].flag2,xyblock[num].flag3,xyblock[num].flag4);
//    printf("gmbody: %i, xyweight: %i\n",gmbody,xyblock[num].weight);
    if (xyblock[num].type!=0)
    {
     if (xyblock[num].height==0) xyblock[num].height++;
     if ((!(xyblock[num].id==1))&&(xyblock[num].basez<=oldz+12))
     {
      if ((xyblock[num].flag1&0x80)&&(!((chars[s].priv&1)||(chars[s].dead))))
      {
//       printf("A\n");
       z=-128;
      }
      else
      {
       if (gmbody)
       {
        if ( ((xyblock[num].weight==255)&&(!(chars[s].priv2&1))) || (xyblock[num].type==2) )
        if ( (xyblock[num].weight==255) || (xyblock[num].type==2) )
        {
         if (xyblock[num].flag2&0x04)
         {
          if (xyblock[num].basez<oldz+3)
          {
           z=xyblock[num].basez+xyblock[num].height;
           dispz=xyblock[num].basez+(xyblock[num].height/2);
          }
          else
          {
           if ((chars[s].priv&1)||(chars[s].dead)||(xyblock[num].flag4&0x20))
           {
            dispz=z=xyblock[num].basez;
           }
           else
           {
//            printf("B\n");
            z=-128;
           }
          }
         }
         else
         {
          if (xyblock[num].basez+xyblock[num].height<oldz+3)
          {
           dispz=z=xyblock[num].basez+xyblock[num].height;
          }
          else
          {
           if ((chars[s].priv&1)||(chars[s].dead)||(xyblock[num].flag4&0x20))
           {
            dispz=z=xyblock[num].basez;
           }
           else
           {
//            printf("C\n");
            z=-128;
           }
          }
         }
        }
       }
       else
       {
        if (((xyblock[num].flag1&0x40)&&(!(xyblock[num].flag1&1)))&&(!(chars[s].priv&1)))
//        if ((xyblock[num].flag1&0x40)&&(!(chars[s].priv&1)))
        {
//         printf("D (ID=%x)\n", xyblock[num].id);
         z=-128;
        }
        else
        {
         if (xyblock[num].flag2&4)
         {
          if (xyblock[num].basez<oldz+3)
          {
           z=xyblock[num].basez+xyblock[num].height;
           dispz=xyblock[num].basez+(xyblock[num].height/2);
          }
          else
          {
           if (chars[s].priv&1)
           {
            dispz=z=xyblock[num].basez;
           }
           else
           {
//            printf("E\n");
            z=-128;
           }
          }
         }
         else
         {
          if (xyblock[num].basez+xyblock[num].height<oldz+3)
          {
           dispz=z=xyblock[num].basez+xyblock[num].height;
          }
          else
          {
           if (chars[s].priv&1)
           {
            dispz=z=xyblock[num].basez;
           }
           else
           {
            if (xyblock[num].flag2&0x20)
            {
//             printf("F: %x %x %x %x\n", xyblock[num].flag1, xyblock[num].flag2, xyblock[num].flag3, xyblock[num].  flag4);
             z=-128;
            }
           }
          }
         }
        }
       }
      }
     }
    }
    else
    {
     if (((xyblock[num].flag1&0x80)||(xyblock[num].flag1&0x40))&&(!(chars[s].priv&1)))
     {
//      printf("G\n");
         if(s==-1) z=-128;
     }
     else
     {
      if ((z==-128)||(xyblock[num].basez+xyblock[num].height<oldz+3))
      {
       dispz=z=xyblock[num].basez;
      }
     }
    }
    memcpy(&xyblock[num],&xyblock[xycount-1],sizeof(unitile_st));
    xycount--;
   }
  }
  while (xycount>0);

  if (z==-128)
  {
   chars[s].x=oldx;
   chars[s].y=oldy;
   if (k!=-1) deny(k, s, sequence);
   return;
  }

  chars[s].dispz=dispz;
  chars[s].z=z;

   if (!(
        ((chars[s].id1==0x03)&&(chars[s].id2==0xDB)) ||
        ((chars[s].id1==0x01)&&(chars[s].id2==0x92)) ||
        ((chars[s].id1==0x01)&&(chars[s].id2==0x93)) ||
        (chars[s].priv&0x01) ||
        (chars[s].priv&0x80)
      ))
   for (i=0;i<charcount;i++)
   {
    if (i!=s && (online(i) || chars[i].npc))
    {
     if (chars[i].x==chars[s].x && chars[i].y==chars[s].y && chars[i].z==chars[s].z)
     {
      if (!chars[i].hidden)
          {
       sprintf(temp, "Being perfectly rested, you shove %s out of the way.", chars[i].name);
       if (k!=-1) sysmessage(k, temp);
       chars[s].stm=max(chars[s].stm-10, 0);
       // updatestats(currchar[s], 2); // replaced with:
       updatestats(s, 2);  // arm code
          }
          else
          {
       if (k!=-1) sysmessage(k, "Being perfectly rested, you shove something invisible out of the way.");
       chars[s].stm=max(chars[s].stm-10, 0);
       // updatestats(currchar[s], 2); // replaced with:
       updatestats(s, 2);  // arm code
          }
     }
    }
   }
  }
  chars[s].dir=(dir&0x0F);
  if (k!=-1)
  {
   walkok[1]=buffer[k][2];
   walkok[2]=0x41;
   if (chars[s].hidden) walkok[2]=0x00;
   xsend(k, walkok, 3, 0);
   walksequence[k]=sequence;
   if (walksequence[k]==255) walksequence[k]=0;
  }
  newx=chars[s].x;
  newy=chars[s].y;
  for (i=0;i<now;i++)
  {
   if ((inrange1p(s, currchar[i]))&&(perm[i]))
   {
    if (
        (((abs(newx-chars[currchar[i]].x)==VISRANGE)||(abs(newy-chars[currchar[i]].y)==VISRANGE)) &&
         ((abs(oldx-chars[currchar[i]].x)>VISRANGE)||(abs(oldy-chars[currchar[i]].y)>VISRANGE))) ||
        ((abs(newx-chars[currchar[i]].x)==VISRANGE)&&(abs(newy-chars[currchar[i]].y)==VISRANGE))
       )
    {
     impowncreate(i, s, 1);
    }
    else
//    if ((abs(newx-chars[currchar[i]].x)<VISRANGE)||(abs(newy-chars[currchar[i]].y)<VISRANGE))
    {
     extmove[1]=chars[s].ser1;
     extmove[2]=chars[s].ser2;
     extmove[3]=chars[s].ser3;
     extmove[4]=chars[s].ser4;
     extmove[5]=chars[s].id1;
     extmove[6]=chars[s].id2;
     extmove[7]=chars[s].x/256;
     extmove[8]=chars[s].x%256;
     extmove[9]=chars[s].y/256;
     extmove[10]=chars[s].y%256;
     extmove[11]=chars[s].dispz;
     extmove[12]=dir;
//     extmove[12]=chars[currchar[s]].dir&0x7F;
//     extmove[12]=buffer[s][1];
     if (chars[s].war) extmove[15]=0x40; else extmove[15]=0x00;
     if (chars[s].hidden) extmove[15]=extmove[15]|0x80;
     if (perm[i]) xsend(i, extmove, 17, 0);
    }
   }
  }
  if (k!=-1)
  {
   for (i=0;i<charcount;i++)
   {
    if ((online(i)||chars[i].npc)||(chars[s].priv&01))//Let GMs see logged out players
    {
     if (
         (((abs(newx-chars[i].x)==VISRANGE)||(abs(newy-chars[i].y)==VISRANGE)) &&
         ((abs(oldx-chars[i].x)>VISRANGE)||(abs(oldy-chars[i].y)>VISRANGE))) ||
         ((abs(newx-chars[i].x)==VISRANGE)&&(abs(newy-chars[i].y)==VISRANGE))
        )
     {
      impowncreate(k, i, 1);
     }
    }
   }      // }// XXX-ZIPPY
   // - this needs to be updated to use region pointers

   for (i=0;i<itemcount;i++)
   {
    if ((items[i].id1==0x39 && (items[i].id2==0x96 || items[i].id2==0x8C))&&
        (items[i].x==chars[s].x)&&(items[i].y==chars[s].y)&&(items[i].z==chars[s].z))
    {//Fire Field
     if (!checkresist(s, 4))
     {
      magicdamage(s, 1);
     }
     soundeffect2(s, 2, 8);
    }
    if ((items[i].id1==0x39 && (items[i].id2==0x79 || items[i].id2==0x67))&&
        (items[i].x==chars[s].x)&&(items[i].y==chars[s].y)&&(items[i].z==chars[s].z))
    {//Para Field
     if (!checkresist(s, 4))
     {
      tempeffect(s, s, 1, 0, 0, 0);
     }
     soundeffect2(s, 0x02, 0x04);
    } //if (k!=-1) { //XXX-ZIPPY
    if ((items[i].id1==0x40)&&(items[i].id2>=0x7C)&&(items[i].id2<=0x7E))
    {
     if ((abs(newx-items[i].x)==BUILDRANGE)||(abs(newy-items[i].y)==BUILDRANGE))
     {
      senditem(k, i);
     }
    } else
    {
     if ((abs(newx-items[i].x)==VISRANGE)||(abs(newy-items[i].y)==VISRANGE))
     {
      senditem(k, i);
     }
    }
   }
  }
 if ((chars[s].x!=oldx)||(chars[s].y!=oldy))
  {
  if (!(chars[s].dead)) objTeleporters(s);
  teleporters(s);
  }
 gatecollision(s);
 checkregion(s); 
 }
}

void walking2(int s) // Only for switching to combat mode
{
 int i;

 for (i=0;i<now;i++) {
  if ((inrange1p(s, currchar[i]))&&(perm[i]))
  {
   extmove[1]=chars[s].ser1;
   extmove[2]=chars[s].ser2;
   extmove[3]=chars[s].ser3;
   extmove[4]=chars[s].ser4;
   extmove[5]=chars[s].id1;
   extmove[6]=chars[s].id2;
   extmove[7]=chars[s].x/256;
   extmove[8]=chars[s].x%256;
   extmove[9]=chars[s].y/256;
   extmove[10]=chars[s].y%256;
   extmove[11]=chars[s].dispz;
   extmove[12]=chars[s].dir&0x7F;
   if (chars[s].war) extmove[15]=0x40; else extmove[15]=0x00;
   if (chars[s].hidden) extmove[15]=extmove[15]|0x80;
   xsend(i, extmove, 17, 0);
  }
 }
}

int validtelepos(int s)
{
 int z;

 z=-1;
 if ((chars[currchar[s]].x>=1397)&&(chars[currchar[s]].x<=1400)&&
     (chars[currchar[s]].y>=1622)&&(chars[currchar[s]].y<=1630))
  z=28;
 if ((chars[currchar[s]].x>=1510)&&(chars[currchar[s]].x<=1537)&&
     (chars[currchar[s]].y>=1455)&&(chars[currchar[s]].y<=1456))
  z=15;
 return z;
}

int unmounthorse(int s) // Get off a horse (Remove horse item and spawn new horse)
{
   int k,c,ci,serial,serhash;

  serial=chars[currchar[s]].serial;
  serhash=serial%256;
  for (k=0;k<contsp[serhash].max;k++)
  {
    ci=contsp[serhash].pointer[k];
    if ((items[ci].contserial==serial) && (items[ci].layer==0x19)&&(items[ci].free==0))
     {
        c=memcharfree ();
      
        initchar(c);
        chars[currchar[s]].onhorse=0;
        sprintf(chars[c].name, "%s", items[ci].name);
        chars[c].id1=0x00;
        if (items[ci].id2==0x9F) chars[c].id2=0xC8;
        if (items[ci].id2==0xA0) chars[c].id2=0xE2;
        if (items[ci].id2==0xA1) chars[c].id2=0xE4;
        if (items[ci].id2==0xA2) chars[c].id2=0xCC;
        if (items[ci].id2==0xA3) chars[c].id2=0xD2;//desert
        if (items[ci].id2==0xA4) chars[c].id2=0xDA;//Harp
        if (items[ci].id2==0xA5) chars[c].id2=0xDB;//Another
        if (items[ci].id2==0xA6) chars[c].id2=0xDC;//llama
        chars[c].xid1=chars[c].id1;
        chars[c].xid2=chars[c].id2;
        chars[c].skin1=items[ci].color1;
        chars[c].skin2=items[ci].color2;
        chars[c].xskin1=items[ci].color1;
        chars[c].xskin2=items[ci].color2;
        chars[c].priv=0x10;
        chars[c].x=chars[currchar[s]].x;
        chars[c].y=chars[currchar[s]].y;
        chars[c].dispz=chars[c].z=chars[currchar[s]].z;
        chars[c].dir=chars[currchar[s]].dir;
        chars[c].npc=1;
        chars[c].own1=chars[currchar[s]].ser1;
        chars[c].own2=chars[currchar[s]].ser2;
        chars[c].own3=chars[currchar[s]].ser3;
        chars[c].own4=chars[currchar[s]].ser4;
        chars[c].ownserial=chars[currchar[s]].serial;
        setptr(&cownsp[chars[c].ownserial%256], c);
        chars[c].npcWander=items[ci].moreb1;
        chars[c].ftarg=-1;
        chars[c].fx1=items[ci].x;
        chars[c].fx2=items[ci].att;
        chars[c].fy1=items[ci].y;
        chars[c].fy2=items[ci].def;
        chars[c].fz1=items[ci].z;
        /*if (c==charcount)
        {
           charcount++;
           charcount2++;
        }*/
        updatechar(c);
        deleitem(ci);
        return 0;
     }
  }
  return -1;
}

void endmessage(int x=0) // If shutdown is initialized
{
   int igetclock = getclock();
   if (endtime<igetclock) endtime=igetclock;
   sprintf(temp, "Server going down in %i minutes.",
      ((endtime-igetclock)/CLOCKS_PER_SEC)/60);
   sysbroadcast(temp);
}

void illinst(int x=0) //Thunderstorm linux fix
{
  sysbroadcast("Fatal Server Error! Bailing out - Have a nice day!");
  printf("Illegal Instruction Signal caught - attempting shutdown");
  endmessage();
}

void weblaunch(int s, char *txt) // Direct client to a web page
{
 int l;
 char launchstr[4]="\xA5\x00\x00";

 sysmessage(s, "Launching your web browser. Please wait...");
 l=strlen(txt)+4;
 launchstr[1]=l/256;
 launchstr[2]=l%256;
 xsend(s, launchstr, 3, 0);
 xsend(s, txt, strlen(txt)+1, 0);
}

void gmmenu(int s, int m) // Open one of the gray GM Call menus
{
 int total, i;
 int lentext;
 char sect[512];
 char gmtext[11][257];
 int gmnumber=0;
 int gmindex;

 openscript("menus.scp");
 sprintf(sect, "GMMENU %i", m);
 if (!menus_script.find(sect))
 {
  closescript();
  return;
 }
 gmindex=m;
 read1();
 lentext=sprintf(gmtext[0], "%s", script1);
 do
 {
  read1();
  if (script1[0]!='}')
  {
   gmnumber++;
   sprintf(gmtext[gmnumber], "%s", script1);
   read1();
  }
 }
 while (script1[0]!='}');
 closescript();
 total=9+1+lentext+1;
 for (i=1;i<=gmnumber;i++)
 {
  total+=4+1+strlen(gmtext[i]);
 }
 gmprefix[1]=total/256;
 gmprefix[2]=total%256;
 gmprefix[3]=chars[currchar[s]].ser1;
 gmprefix[4]=chars[currchar[s]].ser2;
 gmprefix[5]=chars[currchar[s]].ser3;
 gmprefix[6]=chars[currchar[s]].ser4;
 gmprefix[7]=gmindex/256;
 gmprefix[8]=gmindex%256;
 xsend(s, gmprefix, 9, 0);
 xsend(s, &lentext, 1, 0);
 xsend(s, gmtext[0], lentext, 0);
 lentext=gmnumber;
 xsend(s, &lentext, 1, 0);
 for (i=1;i<=gmnumber;i++)
 {
  gmmiddle[0]=(i-1)/256;
  gmmiddle[1]=(i-1)%256;
  xsend(s, gmmiddle, 4, 0);
  lentext=strlen(gmtext[i]);
  xsend(s, &lentext, 1, 0);
  xsend(s, gmtext[i], lentext, 0);
 }
}

void itemmenu(int s, int m) // Menus for item creation
{
 int total, i;
 int lentext;
 char sect[512];
 char gmtext[30][257];
 int gmid[30];
 int gmnumber=0;
 int gmindex;

 openscript("items.scp");
 sprintf(sect, "ITEMMENU %i", m);
 if (!items_script.find(sect))
 {
  closescript();
  return;
 }
 gmindex=m;
 read1();
 sprintf(gmtext[0], "%s", script1);
 do
 {
  read2();
  if (script1[0]!='}')
  {
   gmnumber++;
   gmid[gmnumber]=hstr2num(script1);
   sprintf(gmtext[gmnumber], "%s", script2);
   read1();
  }
 }
 while (script1[0]!='}');
 closescript();
 sprintf(temp, "%i: %s", m, gmtext[0]);
 lentext=sprintf(gmtext[0], "%s", temp);
 total=9+1+lentext+1;
 for (i=1;i<=gmnumber;i++)
 {
  total+=4+1+strlen(gmtext[i]);
 }
 gmprefix[1]=total/256;
 gmprefix[2]=total%256;
 gmprefix[3]=chars[currchar[s]].ser1;
 gmprefix[4]=chars[currchar[s]].ser2;
 gmprefix[5]=chars[currchar[s]].ser3;
 gmprefix[6]=chars[currchar[s]].ser4;
 gmprefix[7]=(gmindex+ITEMMENUOFFSET)/256;
 gmprefix[8]=(gmindex+ITEMMENUOFFSET)%256;
 xsend(s, gmprefix, 9, 0);
 xsend(s, &lentext, 1, 0);
 xsend(s, gmtext[0], lentext, 0);
 lentext=gmnumber;
 xsend(s, &lentext, 1, 0);
 for (i=1;i<=gmnumber;i++)
 {
  gmmiddle[0]=gmid[i]/256;
  gmmiddle[1]=gmid[i]%256;
  xsend(s, gmmiddle, 4, 0);
  lentext=strlen(gmtext[i]);
  xsend(s, &lentext, 1, 0);
  xsend(s, gmtext[i], lentext, 0);
 }
}

void scriptcommand (int s, char *script1, char *script2) // Execute command from script
{
 char tstring[1024];
 int total, ho, mi, se;
 int tmp, i;
 int c;

 strupr(script1);
 strupr(script2);

 if (!(strcmp("GMMENU", script1)))
 {
  gmmenu(s, str2num(script2));
  return;
 }
 if (!(strcmp("ITEMMENU", script1)))
 {
  itemmenu(s, str2num(script2));
  return;
 }
 if (!(strcmp("WEBLINK", script1)))
 {
  weblaunch(s, script2);
  return;
 }
 if (!(strcmp("SYSMESSAGE", script1)))
 {
  sysmessage(s, script2);
  return;
 }
 if (!(strcmp("GMPAGE", script1)))
 {
  gmpage(s, script2);
  return;
 }
 if (!(strcmp("CPAGE", script1)))
 {
  cpage(s, script2);
  return;
 }
 if (!(strcmp("VERSION", script1)))
 {
  sysmessage(s, idname);
  return;
 }
 if (!(strcmp("ADDITEM", script1)))
 {
  addmitem[s]=str2num(script2);
  switch (chars[currchar[s]].making)
  {
   case BLACKSMITHING:  makemenutarget(s,addmitem[s],BLACKSMITHING);
                        break;
   case CARPENTRY:      makemenutarget(s,addmitem[s],CARPENTRY);
                        break;
   case TAILORING:      makemenutarget(s,addmitem[s],TAILORING);
                        break;
   case COOKING:        makemenutarget(s,addmitem[s],COOKING);
                        break;
   case BOWCRAFT:       makemenutarget(s,addmitem[s],BOWCRAFT);
                        break;   
   case TINKERING:          makemenutarget(s,addmitem[s],TINKERING);
                                                break;
   
   default:
            sprintf(tstring, "Select location for item. [Number: %i]", addmitem[s]);
            target(s, 0, 1, 0, 26, tstring);
  }
  chars[currchar[s]].making=0;
  return;
 }
 if (!(strcmp("BATCH", script1)))
 {
  executebatch=str2num(script2);
  return;
 }
 if (!(strcmp("INFORMATION", script1)))
 {
  total=(getclock()-starttime)/CLOCKS_PER_SEC;
  ho=total/3600;
  total-=ho*3600;
  mi=total/60;
  total-=mi*60;
  se=total;
  /*sprintf(tstring, "Time up [%i:%i:%i] Connected players [%i out of %i accounts] Items [%i/%i] Characters [%i/%i]",
          ho,mi,se,now,acctcount,itemcount,MAXITEMS,charcount,MAXCHARS);*/
  total=0;
  c=0;
  for (i=0;i<itemcount;i++) if (items[i].free==0) total++;
  for (i=0;i<charcount;i++) if (chars[i].free==0) c++;
  sprintf(tstring, "Time up [%i:%i:%i] Connected players [%i out of %i accounts] Items [%i/%i] Characters [%i/%i]",
          ho,mi,se,now,acctcount,total,MAXITEMS,c,MAXCHARS);
  sysmessage(s, tstring);
  return;
 }
 if (!(strcmp("NPC", script1)))
 {
  addmitem[s]=str2num(script2);
  sprintf(tstring, "Select location for NPC. [Number: %i]", addmitem[s]);
  target(s, 0, 1, 0, 27, tstring);
  return;
 }
 if (!(strcmp("POLY", script1)))
 {
  tmp=hstr2num(script2);
  chars[currchar[s]].id1=tmp/256;
  chars[currchar[s]].xid1=tmp/256;
  chars[currchar[s]].id2=tmp%256;
  chars[currchar[s]].xid2=tmp%256;
  teleport(currchar[s]);
  return;
 }
 if (!(strcmp("SKIN", script1)))
 {
  tmp=hstr2num(script2);
  chars[currchar[s]].skin1=tmp/256;
  chars[currchar[s]].xskin1=tmp/256;
  chars[currchar[s]].skin2=tmp%256;
  chars[currchar[s]].xskin2=tmp%256;
  teleport(currchar[s]);
  return;
 }
 if (!(strcmp("LIGHT", script1)))
 {
  worldfixedlevel=hstr2num(script2);
  if (worldfixedlevel!=255) setabovelight(worldfixedlevel);
  else setabovelight(worldcurlevel);
  return;
 }
 if (!(strcmp("DRY", script1)))
 {
  wtype=0;
  for (i=0;i<now;i++) if (perm[i]) weather(i);
  return;
 }
 if (!(strcmp("RAIN", script1)))
 {
  if (wtype==2)
  {
   wtype=0;
   for (i=0;i<now;i++) if (perm[i]) weather(i);
  }
  wtype=1;
  for (i=0;i<now;i++) if (perm[i]) weather(i);
  return;
 }
 if (!(strcmp("SNOW", script1)))
 {
  if (wtype==1)
  {
   wtype=0;
   for (i=0;i<now;i++) if (perm[i]) weather(i);
  }
  wtype=2;
  for (i=0;i<now;i++) if (perm[i]) weather(i);
  return;
 }
 if (!(strcmp("GCOLLECT", script1)))
 {
  gcollect();
  return;
 }
 if (!(strcmp("GOPLACE", script1)))
 {
  tmp=str2num(script2);
  makeplace(s, tmp);
  if (addx[s]!=0)
  {
   chars[currchar[s]].x=addx[s];
   chars[currchar[s]].y=addy[s];
   chars[currchar[s]].dispz=chars[currchar[s]].z=addz[s];
   teleport(currchar[s]);
  }
  return;
 }
 if (!(strcmp("MAKEMENU", script1)))
 {
  makemenu(s, str2num(script2), chars[currchar[s]].making);
  return;
 }
 if (!(strcmp("CREATETRACKINGMENU", script1)))
 {
  createtrackingmenu(s, str2num(script2));
  return;
 }
 if(!(strcmp("TRACKINGMENU", script1)))
 {
  trackingmenu(s, str2num(script2));
  return;
 }
}

void choice(int s) // Choice from GMMenu, Itemmenu or Makemenu received
{
 int main, sub;
 char sect[512];
 int i, need=0, minskill=0;
 Script *script;

 main=(buffer[s][5]*256)+buffer[s][6];
 sub=(buffer[s][7]*256)+buffer[s][8];

 if( (main&0xFF00)==0xFF00)
 {
  if (im_choice(s, main, sub)==0) return;
 }
 if (main>1246 && main<1255)
 {
  dopotion(s, main-1246, sub, calcItemFromSer(addid1[s], addid2[s], addid3[s], addid4[s]));
  return;
 }
 else if (main<ITEMMENUOFFSET) // GM Menus
 {
  openscript("menus.scp");
  sprintf(sect, "GMMENU %i", main);
  script = &menus_script;
 }
 else if ((main>=5256) && (main<8192)) // Tracking fix 12-30-98
 {
  openscript("items.scp");
  sprintf(sect, "ITEMMENU %i", main-256);
  script = &items_script;
 }
 else if(main>=ITEMMENUOFFSET && main<MAKEMENUOFFSET)
 {
  openscript("items.scp");
  sprintf(sect, "ITEMMENU %i", main-ITEMMENUOFFSET);
  script = &items_script;
 }
 else if(main>=MAKEMENUOFFSET && main<TRACKINGMENUOFFSET)
 {
  openscript("create.scp");
  sprintf(sect, "MAKEMENU %i", main-MAKEMENUOFFSET);
  script = &create_script;
 }
 else // Tracking
 {
  if((main-TRACKINGMENUOFFSET)>=TRACKINGMENUOFFSET+1&&(main-TRACKINGMENUOFFSET)<=TRACKINGMENUOFFSET+3)
  {
   if(!sub) return;
   if(!checkskill(currchar[s],TRACKING, 0, 1000))
   {
    sysmessage(s,"You fail your attempt at tracking.");
    return;
   }
   tracking(s,sub-1);
  }
  openscript("tracking.scp");
  sprintf(sect, "TRACKINGMENU %i", main-TRACKINGMENUOFFSET);
  script = &tracking_script;
 }

 if (!script->find(sect))
 {
  closescript();
  return;
 }
 read1();
 i=0;
 do
 {
  read1();
  if (script1[0]!='}')
  {
   i++;
   if (main>=MAKEMENUOFFSET && main<TRACKINGMENUOFFSET)
   {
    read2();
    need=str2num(script2);
    read2();
    minskill=str2num(script2);
//    printf("needs %i, has %i\nskillneed %i, skillhas %i\n",need,itemmake[s].has,minskill,chars[currchar[s]].skill[chars[currchar[s]].making]);
    if ((itemmake[s].has<need)||(chars[currchar[s]].skill[chars[currchar[s]].making]<minskill))
     i--;
   }
   read2();
//   printf("%s %i\n",script1,str2num(script2));
   if (i==sub)
   {
    closescript();
    itemmake[s].needs=need;
    scriptcommand(s, script1, script2);
    itemmake[s].minskill=minskill;
    itemmake[s].maxskill=5*minskill;
    if (itemmake[s].maxskill<200) itemmake[s].maxskill=200;
   }
  }
 }
 while ((script1[0]!='}')&&(i!=sub));
 if (i!=sub) closescript();
}

void batchcheck(int s) // Do we have to run a batch file
{
 sprintf(temp, "BATCH %i", executebatch);
 openscript("menus.scp");
 if (!menus_script.find(temp))
 {
  closescript();
  return;
 }
 do
 {
  read2();
  if (script1[0]!='}') scriptcommand(s, script1, script2);
 }
 while (script1[0]!='}');
 closescript();
 executebatch=0;
}

void command(int s) // Client entered a '/' command like /ADD
{
 int i=9,newhours,newminutes;
 char c=0;
 char *comm;
 char nonuni[512];
 int offset=9; 

 if(!(chars[currchar[s]].unicode))
 {
   while (buffer[s][i]!='\x00')
   {
      tbuffer[i]=buffer[s][i];
      buffer[s][i]=toupper(buffer[s][i]);
      i++;
   }
   tbuffer[i]='\x00';
   cline = &buffer[s][8];
   splitline();
   if (tnum<1) return;
   comm=&buffer[s][9]; 
 }
 else
 {
   i=0;
   offset=14;
   // we will have to convert from unicode to non-unicode
   for (i=13;i<(buffer[s][1]*256)+buffer[s][2];i=i+2)
   {
      nonuni[(i-13)/2]=buffer[s][i];
   } 
   i=14;
   while (nonuni[i-13]!='\x00')
   {
      tbuffer[i]=nonuni[i-13];
      nonuni[i-13]=toupper(nonuni[i-13]);
      i++;
   } 
   tbuffer[i]='\x00'; 
   cline = &nonuni[1];
   splitline();
   if (tnum<1) return; 
   comm=&nonuni[1];
 } 

 if (!(strcmp("USE",comm)))
 {
  target(s, 0, 1, 0, 24, "What object will you use?");
  return;
 }
 if (!(strcmp("RESEND",comm)))
 {
  all_items(s);
  return;
 }
 if (!(strcmp("POINT",comm)))
 {
  //teleport(currchar[s]); // Taken out for house code
  return;
 }
 if (!(strcmp("WHERE",comm)))
 {
  sprintf(temp, "You are at: %i %i (%i)",chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z);
  sysmessage(s, temp);
  return;
 }
 if (!(chars[currchar[s]].priv&0x01))
 {
  if (!(strcmp("ADD",comm)))
  {
   itemmenu(s, 0);
   return;
  }
 }
 if (chars[currchar[s]].priv&0x80) //Player is a counselor
 {
  if (!(strcmp("Q",comm)))
  {
   if (!(chars[currchar[s]].priv&0x01)) //They are not a GM
   {
   showgmque(s, 0);
   }
   else
   {
   showgmque(s, 1); // They are a GM
   }
   return;
  }  
  if (!(strcmp("NEXT",comm)))
  {
   if (!(chars[currchar[s]].priv&0x01)) //They are not a GM
   {
   nextcall(s, 0);
   }
   else
   {
   nextcall(s, 1); // They are a GM
   }
   return;
  }  
  if (!(strcmp("CLEAR",comm)))
  {
   if (!(chars[currchar[s]].priv&0x01)) //They are not a GM
   {
   donewithcall(s, 0);
   }
   else
   {
   donewithcall(s, 1); // They are a GM
   }
   return;
  }  
  if (!(strcmp("GOTOCUR",comm)))
  {
   gotocurcall(s);
   return;
  }
  if (!(strcmp("GMTRANSFER",comm)))
  {
   gmtransfer(s);
   return;
  }
  if (!(strcmp("JAIL",comm)))
  {
   target(s, 0, 1, 0, 126, "Select player to jail.");
   return;
  }
  if (!(strcmp("RELEASE",comm)))
  {
   target(s, 0, 1, 0, 127, "Select player to release from jail.");
   return;
  }
  if (!(strcmp("ISTATS",comm)))
  {
   target(s, 0, 1, 0, 12, "Select item to inspect.");
   return;
  }
  if (!(strcmp("CSTATS",comm)))
  {
   target(s, 0, 1, 0, 13, "Select char to inspect.");
   return;
  }
  if (!(strcmp("GOPLACE",comm)))
  {
   if (tnum==2)
   {
    makeplace(s, makenumber(1));
    if (addx[s]!=0)
    {
     chars[currchar[s]].x=addx[s];
     chars[currchar[s]].y=addy[s];
     chars[currchar[s]].dispz=chars[currchar[s]].z=addz[s];
     teleport(currchar[s]);
    }
   }
   return;
  }
 }
 if (chars[currchar[s]].priv&0x01) //Char is a GM
 {
  if (!(strcmp("GOCHAR",comm)))
  {
   if (tnum==5)
   {
    for (i=0;i<charcount;i++)
    {
     if ((chars[i].ser1==hexnumber(1))&&(chars[i].ser2==hexnumber(2))&&
         (chars[i].ser3==hexnumber(3))&&(chars[i].ser4==hexnumber(4)))
     {
      chars[currchar[s]].x=chars[i].x;
      chars[currchar[s]].y=chars[i].y;
      chars[currchar[s]].dispz=chars[currchar[s]].z=chars[i].z;
      teleport(currchar[s]);
      break;
     }
    }
   }
   if (tnum==2)
   {
    for (i=0;i<now;i++)
    {
     if (i==makenumber(1))
     {
      chars[currchar[s]].x=chars[currchar[i]].x;
      chars[currchar[s]].y=chars[currchar[i]].y;
      chars[currchar[s]].dispz=chars[currchar[s]].z=chars[currchar[i]].z;
      teleport(currchar[s]);
      break;
     }
    }
   }
   return;
  }
  if (!(strcmp("FIX",comm)))
  {
   if (tnum==2)
   {
    if (validtelepos(s)==-1)
    {
     chars[currchar[s]].dispz=chars[currchar[s]].z=makenumber(1);
    }
    else
    {
     chars[currchar[s]].dispz=chars[currchar[s]].z=validtelepos(s);
    }
    teleport(currchar[s]);
   }
   return;
  }
  if (!(strcmp("XGOPLACE",comm)))
  {
   if (tnum==2)
   {
    makeplace(s, makenumber(1));
    if (addx[s]!=0)
    {
     target(s, 0, 1, 0, 8, "Select char to teleport.");
    }
   }
   return;
  }
  if (!(strcmp("SHOWIDS",comm)))
  {
   for (i=0;i<charcount;i++)
   if (inrange1p(currchar[s], i)) showcname(s, i, 1);
   return;
  }
  if (!(strcmp("POLY",comm)))
  {
   if (tnum==3)
   {
    chars[currchar[s]].id1=hexnumber(1);
    chars[currchar[s]].id2=hexnumber(2);
    chars[currchar[s]].xid1=hexnumber(1);
    chars[currchar[s]].xid2=hexnumber(2);
    teleport(currchar[s]);
   }
   return;
  }
  if (!(strcmp("SKIN",comm)))
  {
   if (tnum==3)
   {
    chars[currchar[s]].skin1=hexnumber(1);
    chars[currchar[s]].skin2=hexnumber(2);
    chars[currchar[s]].xskin1=hexnumber(1);
    chars[currchar[s]].xskin2=hexnumber(2);
    teleport(currchar[s]);
   }
   return;
  }
  if (!(strcmp("ACTION",comm)))
  {
   if (tnum==2) action(s, hexnumber(1));
   return;
  }
  if (!(strcmp("TELE",comm)))
  {
   target(s, 0, 1, 0, 2, "Select teleport target.");
   return;
  }
  if (!(strcmp("XTELE",comm)))
  {
   if (tnum==5 || tnum==2) xteleport(s, tnum);
   else
   {
    target(s, 0, 1, 0, 136, "Select char to teleport to your position.");
   }
   return;
  }
  if (!(strcmp("GO",comm)))
  {
   if (tnum==4)
   {
    chars[currchar[s]].x=makenumber(1);
    chars[currchar[s]].y=makenumber(2);
    chars[currchar[s]].dispz=chars[currchar[s]].z=makenumber(3);
    teleport(currchar[s]);
   }
   return;
  }
 if (!(strcmp("XGO",comm)))
  {
   if (tnum==4)
   {
    addx[s]=makenumber(1);
    addy[s]=makenumber(2);
    addz[s]=makenumber(3);
    target(s, 0, 1, 0, 8, "Select char to teleport.");
   }
   return;
  }
  if (!(strcmp("SETMOREX",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 63, "Select object to set morex on.");
   }
   return;
  }
  if (!(strcmp("SETMOREY",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 64, "Select object to set morey on.");
   }
   return;
  }
  if (!(strcmp("SETMOREZ",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 65, "Select object to set morez on.");
   }
   return;
  }
  if (!(strcmp("SETMOREXYZ",comm)))
  {
   if (tnum==4)
   {
    addx[s]=makenumber(1);
    addy[s]=makenumber(2);
    addz[s]=makenumber(3);
    target(s, 0, 1, 0, 66, "Select object to set morex, morey, and morez on.");
   }
   return;
  }
  if (!(strcmp("SETHEXMOREXYZ",comm)))
  {
   if (tnum==4)
   {
    addx[s]=hexnumber(1);
    addy[s]=hexnumber(2);
    addz[s]=hexnumber(3);
    target(s, 0, 1, 0, 66, "Select object to set hex morex, morey, and morez on.");
   }
   return;
  }
  if (!(strcmp("SETNPCAI",comm)))
  {
   if (tnum==2)
   {
    addid1[s]=hexnumber(1);
    target(s, 0, 1, 0, 106, "Select npc to set AI type on.");
   }
   return;
  }
  if (!(strcmp("XBANK",comm)))
  {
   target(s, 0, 1, 0, 107, "Select target to open bank of.");
   return;
  }
  
	if (!(strcmp("TILE",comm)))  // Tiling out an area with an item - Crwth 01/11/1999
	{
		if (tnum==3) {
			addid1[s]=hexnumber(1);
			addid2[s]=hexnumber(2);
			clickx[s]=-1;
			clicky[s]=-1;
			target(s,0,1,0,198,"Select first corner of bounding box.");  // 198 didn't seem taken...
		}
		return;
	}
	if (!(strcmp("WIPE",comm)))  // Wiping out an area of all items - Crwth 01/11/1999
	{
		addid1[s]=0; // addid1[s]==0 is used to denote a true wipe
		if (tnum==1) {
			clickx[s]=-1;
			clicky[s]=-1;
			target(s,0,1,0,199,"Select first corner of wiping box.");  // 199 didn't seem taken...
		} else if (tnum==2) {
			if (!strcmp("ALL",&tbuffer[offset+5])) {
				// Really should warn that this will wipe ALL objects...
				wipe(s);
		}}
		else if (tnum==5) { // Wipe according to world coordinates
			clickx[s]=makenumber(1);
			clicky[s]=makenumber(2);
			buffer[s][11]=makenumber(3)/256;buffer[s][12]=makenumber(3)%256; // Do NOT try this at home, kids!
			buffer[s][13]=makenumber(4)/256;buffer[s][14]=makenumber(4)%256;
			wiping(s);
		}

		return;
	}
	if (!(strcmp("IWIPE",comm)))  // Wiping out everything not in an area of all items - Crwth 01/11/1999
	{
		addid1[s]=1;  // addid1[s]==1 is used to denote the INVERSE wipe
		if (tnum==1) {
			clickx[s]=-1;
			clicky[s]=-1;
			target(s,0,1,0,199,"Select first corner of inverse wiping box.");  // 199 didn't seem taken...
		} else if (tnum==2) {
			if (!strcmp("ALL",&tbuffer[offset+6])) {
        sysmessage(s,"Well aren't you the funny one!");
		}}
		else if (tnum==5) { // Wipe according to world coordinates
			clickx[s]=makenumber(1);
			clicky[s]=makenumber(2);
			buffer[s][11]=makenumber(3)/256;buffer[s][12]=makenumber(3)%256; // Do NOT try this at home, kids!
			buffer[s][13]=makenumber(4)/256;buffer[s][14]=makenumber(4)%256;
			wiping(s);
		}

		return;
	}
  if (!(strcmp("ADD",comm)))
  {
   if (tnum==3)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    if (addid1[s]<0x40)
    {
			target(s, 0, 1, 0, 0, "Select location for item.");
    }/* else { //This was causing server crashes (after added, if someone walked it would get
                               //in an endless loop through the mutli section of walking() )
               addid3[s]=0;
               buildhouse(s,0);
       }*/
   } else if (tnum==1)
   {
    itemmenu(s, 1);
   }
   return;
  }
  if (!(strcmp("ADDX",comm)))
  {
   if (tnum==3)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    addhere(s, chars[currchar[s]].z);
   }
   if (tnum==4)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    addhere(s, makenumber(3));
   }
   return;
  }
  if (!(strcmp("RENAME",comm)))
  {
   if (tnum>1)
   {
    sprintf(xtext[s], "%s", &tbuffer[offset+7]);
    target(s, 0, 1, 0, 1, "Select item or character to rename.");
   }
   return;
  }
  if (!(strcmp("TITLE",comm)))
  {
   if (tnum>1)
   {
    sprintf(xtext[s], "%s", &tbuffer[offset+6]);
    target(s, 0, 1, 0, 47, "Select character to change the title of.");
   }
   return;
  }
  if (!(strcmp("SAVE",comm)))
  {
   //savenewworld(1);
   cwmWorldState.savenewworld(1);
   saveserverscript(1);
   return;
  }
  if (!(strcmp("REMOVE",comm)))
  {
   target(s, 0, 1, 0, 3, "Select item to remove.");
   return;
  }
if (!(strcmp("TRAINER",comm)))
  {
   /*if (tnum==3)
   {
    i=0;
    script1[0]=0;
    while (tbuffer[offset+9+i]!=' ' && tbuffer[offset+9+i]!=0) i++;
    strncpy(script1,&tbuffer[offset+9],i);
    script1[i]=0;
    strupr(script1);    
    addx[s]=-1;
    for (i=0;i<SKILLS;i++)
    {
     if (!(strcmp(skillname[i], script1))) addx[s]=i;
    }
    if (addx[s]!=-1)
    {
     addy[s]=makenumber(2);*/
     //target(s, 0, 1, 0, 206, "Select character to allow or disallow to train this skill.");
     target(s, 0, 1, 0, 206, "Select character to become a trainer.");
//    }
//   }
   return;
  }
  if (!(strcmp("DYE",comm)))
  {
   dyeall[s]=1;
   if (tnum==3)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
   }
   else
   {
    addid1[s]=255;
    addid2[s]=255;
   }
   target(s, 0, 1, 0, 4, "Select item to dye.");
   return;
  }
  if (!(strcmp("NEWZ",comm)))
  {
   if (tnum==2)
   {
    addid1[s]=makenumber(1);
    target(s, 0, 1, 0, 5, "Select item to reposition.");
   }
   return;
  }
  if (!(strcmp("SETTYPE",comm)))
  {
   if (tnum==2)
   {
    addid1[s]=makenumber(1);
    target(s, 0, 1, 0, 6, "Select item to edit type.");
   }
   return;
  }
  if (!(strcmp("ITRIG",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 200, "Select item to trigger.");
   }
   return;
  }
  if (!(strcmp("CTRIG",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 201, "Select NPC to trigger.");
   }
   return;
  }
  if (!(strcmp("TTRIG",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 202, "Select item to set trigger type.");
   }
   return;
  }
  if (!(strcmp("WTRIG",comm)))
  {
   if (tnum>1)
   {
    sprintf(xtext[s], "%s", &tbuffer[16]);
    target(s, 0, 1, 0, 203, "Select the NPC to set trigger word on.");
   }
   return;
  }
  if (!(strcmp("SETID",comm)))
  {
   if (tnum==3)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    target(s, 0, 1, 0, 7, "Select item to polymorph.");
   }
   return;
  }
  if (!(strcmp("SETPRIV",comm)))
  {
   if (tnum==3)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    target(s, 0, 1, 0, 9, "Select char to edit priv.");
   }
   if (tnum==2)
   {
    addid1[s]=hexnumber(1);
    target(s, 0, 1, 0, 89, "Select object to edit priv.");
   }
   return;
  }
  if (!(strcmp("NODECAY",comm)))
  {
    addid1[s]=0;
    target(s, 0, 1, 0, 89, "Select object to make permenant.");
    return;
  }
#ifdef UNRELEASED
  if (!(strcmp("SEND",comm)))
  {
   for (i=1;i<tnum;i++) temp[i-1]=hexnumber(i);
//   sysmessage(s, "Sending...");
   printf("Sending to client %i.\n",s);
   xsend(s, temp, tnum-1, 0);
   return;
  }
#endif
  if (!(strcmp("SHOWTIME",comm)))
  {
   if (ampm || (!ampm && hour==12))
    sprintf(temp, "%s %2.2d %s %2.2d %s", "UOX3: Time: ", hour, ":", minute, "PM");
   else
    sprintf(temp, "%s %2.2d %s %2.2d %s", "UOX3: Time: ", hour, ":",minute, "AM");
   sysmessage(s,temp);
   return;
  }
  if (!(strcmp("SETTIME",comm)))
  {
   if (tnum==3)
   {
    newhours = makenumber(1);
    newminutes = makenumber(2);
    if ((newhours < 25) && (newhours > 0) && (newminutes > -1) && (newminutes <60))
    {
     if (newhours > 12)
     {
      ampm=1;
      hour=newhours-12;
     }
     else
     {
      ampm=0;
      hour=newhours;
     }
     minute=newminutes;
    }
   }
   return;
  }
  if (!(strcmp("SETMORE",comm)))
  {
   if (tnum==5)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    addid3[s]=hexnumber(3);
    addid4[s]=hexnumber(4);
    target(s, 0, 1, 0, 10, "Select item to edit 'more' value.");
   }
   return;
  }
  if (!(strcmp("SHUTDOWN",comm)))
  {
   if (tnum==2)
   {
    endtime=getclock()+(CLOCKS_PER_SEC*makenumber(1));
    if (makenumber(1)==0)
    {
     endtime=0;
     sysbroadcast("Shutdown has been interrupted.");
    }
    else endmessage();
   }
   return;
  }
  if (!(strcmp("MAKEGM",comm)))
  {
   target(s, 0, 1, 0, 14, "Select character to make a GM.");
   return;
  }
  if (!(strcmp("MAKECNS",comm)))
  {
   target(s, 0, 1, 0, 15, "Select character to make a Counselor.");
   return;
  }
  if (!(strcmp("KILLHAIR",comm)))
  {
   target(s, 0, 1, 0, 16, "Select character for cutting hair.");
   return;
  }
  if (!(strcmp("KILLBEARD",comm)))
  {
   target(s, 0, 1, 0, 17, "Select character for shaving.");
   return;
  }
  if (!(strcmp("KILLPACK",comm)))
  {
   target(s, 0, 1, 0, 18, "Select character to remove pack.");
   return;
  }
  if (!(strcmp("SETFONT",comm)))
  {
   if (tnum==2)
   {
    addid1[s]=hexnumber(1);
    target(s, 0, 1, 0, 19, "Select character to change font.");
   }
   return;
  }
if (!(strcmp("WHOLIST",comm)))
 {
  whomenu(s,4);
  return;
 }
  if (!(strcmp("KILL",comm)))
  {
   target(s, 0, 1, 0, 20, "Select character to kill.");
   return;
  }
  if (!(strcmp("RESURRECT",comm)))
  {
   target(s, 0, 1, 0, 21, "Select character to resurrect.");
   return;
  }
  if (!(strcmp("BOLT",comm)))
  {
   target(s, 0, 1, 0, 22, "Select character to bolt.");
   return;
  }
#ifdef UNRELEASED
  if (!(strcmp("BLT2",comm)))
  {
   if (tnum==4)
   {
    boltstring[1]=hexnumber(1);
    boltstring[2]=0;
    boltstring[3]=0;
    boltstring[4]=0;
    boltstring[5]=1;
    boltstring[10]=hexnumber(2);
    boltstring[11]=hexnumber(3);
    xsend(s, boltstring, 28, 0);
   }
   return;
  }
#endif
  if (!(strcmp("SFX",comm)))
  {
   if (tnum==3)
   {
    soundeffect(s, hexnumber(1), hexnumber(2));
   }
   return;
  }
  if (!(strcmp("NPCACTION",comm)))
  {
   if (tnum==2)
   {
    addid1[s]=hexnumber(1);
    target(s, 0, 1, 0, 53 , "Select npc to make act.");
   }
   return;
  }
  if (!(strcmp("LIGHT",comm)))
  {
   if (tnum==2)
   {
    worldfixedlevel=hexnumber(1);
    if (worldfixedlevel!=255) setabovelight(worldfixedlevel);
    else setabovelight(worldcurlevel);
   }
   return;
  }
  if (!(strcmp("SETAMOUNT",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 23, "Select item to edit amount.");
   }
   return;
  }
  if (!(strcmp("SETAMOUNT2",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 129, "Select item to edit amount.");
   }
   return;
  }
#ifdef UNRELEASED
  if (!(strcmp("WEB",comm)))
  {
   if (tnum>1)
   {
    sprintf(xtext[s], "%s", &tbuffer[offset+4]);
    weblaunch(s, xtext[s]);
   }
   return;
  }
#endif
  if (!(strcmp("DISCONNECT",comm)))
  {
   if (tnum==2) disconnect(makenumber(1));
  }
  if (!(strcmp("KICK",comm)))
  {
   target(s, 0, 1, 0, 25, "Select character to kick.");
   return;
  }
  if (!(strcmp("TELL",comm)))
  {
   if (tnum>2) tellmessage(s, makenumber(1), &tbuffer[offset+6]);
   return;
  }
  if (!(strcmp("DRY",comm)))
  {
   wtype=0;
   for (i=0;i<now;i++) if (perm[i]) weather(i);
   return;
  }
  if (!(strcmp("RAIN",comm)))
  {
   if (wtype==2)
   {
    wtype=0;
    for (i=0;i<now;i++) if (perm[i]) weather(i);
   }
   wtype=1;
   for (i=0;i<now;i++) if (perm[i]) weather(i);
   return;
  }
  if (!(strcmp("SNOW",comm)))
  {
   if (wtype==1)
   {
    wtype=0;
    for (i=0;i<now;i++) if (perm[i]) weather(i);
   }
   wtype=2;
   for (i=0;i<now;i++) if (perm[i]) weather(i);
   return;
  }
  if (!(strcmp("GMMENU",comm)))
  {
   if (tnum==2) gmmenu(s, makenumber(1));
   return;
  }
  if (!(strcmp("ITEMMENU",comm)))
  {
   if (tnum==2) itemmenu(s, makenumber(1));
   return;
  }
  if (!(strcmp("ADDITEM",comm)))
  {
   if (tnum==2)
   {
        addmitem[s] = makenumber(1); // Anthracks' fix
        sprintf(temp, "Select location for item. [Number: %i]", addmitem[s]);
        target(s, 0, 1, 0, 26, temp);
   }
   return;
  }
  if (!(strcmp("DUPE",comm))) //added
  {
   if (tnum==2)
   {
    addid1[s]=makenumber(1);
    target(s, 0, 1, 0, 110, "Select an item to dupe.");
   }
   else
   {
    addid1[s]=1;
    target(s, 0, 1, 0, 110, "Select an item to dupe.");
   }
   return;
  }
  if (!(strcmp("MOVETOBAG",comm)))
  {
   target(s, 0, 1, 0, 111, "Select an item to move into your bag.");
   return;
  }
  if (!(strcmp("COMMAND",comm)))
  {
   if (tnum>1)
   {
    i=0;
    script1[0]=0;
    script2[0]=0;
    while(tbuffer[offset+8+i]!=' ' && tbuffer[offset+8+i]!=0) i++;
    strncpy(script1,&tbuffer[offset+8],i);
    script1[i]=0;
    if ((script1[0]!='}')&&(c!=0)) strcpy(script2, &tbuffer[offset+8+i+1]);
    scriptcommand(s, script1, script2);
   }
   return;
  }
  if (!(strcmp("GCOLLECT",comm)))
  {
   gcollect();
   return;
  }
  if (!(strcmp("ALLMOVEON",comm)))
  {
   chars[currchar[s]].priv2=chars[currchar[s]].priv2|0x01;
   teleport(currchar[s]);
   return;
  }
  if (!(strcmp("ALLMOVEOFF",comm)))
  {
   chars[currchar[s]].priv2=chars[currchar[s]].priv2&(0xFF-0x01);
   teleport(currchar[s]);
   return;
  }
  if (!(strcmp("SHOWHS",comm)))
  {
   chars[currchar[s]].priv2=chars[currchar[s]].priv2|0x04;
   teleport(currchar[s]);
   sysmessage(s, "House icons visible.");
   return;
  }
  if (!(strcmp("HIDEHS",comm)))
  {
   chars[currchar[s]].priv2=chars[currchar[s]].priv2&(0xFF-0x04);
   teleport(currchar[s]);
   sysmessage(s, "House icons hidden");
   return;
  }
  if (!(strcmp("SETMOVABLE",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 28, "Select item to edit mobility.");
   }
   return;
  }
  if (!(strcmp("SET",comm)))
  {
   if (tnum==3)
   {
    i=0;
    script1[0]=0;
    while (tbuffer[offset+4+i]!=' ' && tbuffer[offset+4+i]!=0) i++;
    strncpy(script1,&tbuffer[offset+4],i);
    script1[i]=0;
    strupr(script1);
    addx[s]=-1;
    for (i=0;i<SKILLS;i++)
    {
     if (!(strcmp(skillname[i], script1))) addx[s]=i;
    }
    if (addx[s]!=-1)
    {
     addy[s]=makenumber(2);
     target(s, 0, 1, 0, 36, "Select character to modify.");
    }
   }
   return;
  }
#ifdef UNRELEASED
  if (!(strcmp("TEMP",comm)))
  {
   if (tnum==2)
   {
    tempflag=hexnumber(1);
    sysmessage(s, "TEMP changed.");
//    teleport(currchar[s]);
   }
   return;
  }
#endif
  if (!(strcmp("SETVISIBLE",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 61, "Select item to edit visibility.");
   }
   return;
  }
  if (!(strcmp("SETDIR",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 88, "Select item to edit dir.");
   }
   return;
  }
  if (!(strcmp("SETSPEECH",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 135, "Select npc to edit speech.");
   }
   return;
  }
  if (!(strcmp("SETOWNER",comm)))
  {
   if (tnum==5)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    addid3[s]=hexnumber(3);
    addid4[s]=hexnumber(4);
    target(s, 0, 1, 0, 30, "Select NPC or OBJECT to edit owner.");
   }
   return;
  }
  if (!(strcmp("ADDNPC",comm)))
  {
   if (tnum==3)
   {
    addid1[s]=hexnumber(1);
    addid2[s]=hexnumber(2);
    target(s, 0, 1, 0, 33, "Select location for the NPC.");
   }
   else if (tnum==2)
   {
    addmitem[s]=makenumber(1);
    target(s, 0, 1, 0, 27, "Select location for the NPC.");
   }
   return;
  }
  if (!(strcmp("FREEZE", comm)))
  {
   target(s, 0, 1, 0, 34, "Select player to freeze in place.");
   return;
  }
  if (!(strcmp("UNFREEZE", comm)))
  {
   target(s, 0, 1, 0, 35, "Select player to unfreeze.");
   return;
  }
  if (!(strcmp("READINI", comm)))
  {
   readini();
   for (i=0;i<servcount;i++)
   if (serv[i][1][0]=='*') sprintf(serv[i][1],"%i.%i.%i.%i",ph1,ph2,ph3,ph4);
   sysmessage(s, "INI file reloaded.");
   return;
  }
  if (!(strcmp("GUMPMENU",comm)))
  {
   if (tnum==2)
   {
    gumpmenu(s, makenumber(1));
   }
   return;
  }
  if (!(strcmp("TILEDATA",comm)))
  {
   target(s,0,1,0,46,"Select item to inspect.");
   return;
  }
  if(!(strcmp("RECALL",comm)))
  {
   target(s,0,1,0,38,"Select rune from which to recall.");
   return;
  }
  if(!(strcmp("MARK",comm)))
  {
   target(s,0,1,0,39,"Select rune to mark.");
   return;
  }
  if(!(strcmp("GATE",comm)))
  {
   target(s,0,1,0,43,"Select rune from which to gate.");
   return;
  }
  if(!(strcmp("HEAL",comm)))
  {
   target(s,0,1,0,44,"Select person to heal.");
   return;
  }
  if(!(strcmp("NPCTARGET",comm)))
  {
   target(s, 0, 1, 0, 56, "Select player for the NPC to follow.");
   return;
  }
  if(!(strcmp("CACHESTATS",comm)))
  {
   sprintf(temp, "Hits: %d", stablockcachehit);
   sysmessage(s, temp);
   sprintf(temp, "Misses: %d", stablockcachemiss);
   sysmessage(s, temp);
   sprintf(temp, "Total: %d", (stablockcachehit+stablockcachemiss));
   sysmessage(s, temp);
   return;
  }
  if(!(strcmp("NPCRECT",comm)))
  {
   if (tnum==5)
   {
    npcshape[0]=makenumber(1);
    npcshape[1]=makenumber(2);
    npcshape[2]=makenumber(3);
    npcshape[3]=makenumber(4);
    target(s, 0, 1, 0, 58, "Select the NPC to set the bounding rectangle for.");
   }
   return;
  }
  if(!(strcmp("NPCCIRCLE",comm)))
  {
   if (tnum==4)
   {
    npcshape[0]=makenumber(1);
    npcshape[1]=makenumber(2);
    npcshape[2]=makenumber(3);
    target(s, 0, 1, 0, 59, "Select the NPC to set the bounding circle for.");
   }
   return;
  }
  if(!(strcmp("NPCWANDER",comm)))
  {
   if (tnum==2)
   {
    npcshape[0]=makenumber(1);
    target(s, 0, 1, 0, 60, "Select the NPC to set the wander method for.");
   }
   return;
  }
  if (!(strcmp("TWEAK",comm)))
  {
   target(s, 0, 1, 0, 62, "Select item or character to tweak.");
   return;
  }
  if (!(strcmp("SBOPEN",comm)))
  {
   target(s, 0, 1, 0, 87, "Select spellbook to open as a container.");
   return;
  }
  if (!(strcmp("SECONDSPERUOMINUTE",comm)))
  {
   if (tnum==2)
   {
    secondsperuominute=makenumber(1);
    sysmessage(s, "Seconds per UO minute set.");
   }
   return;
  }
  if (!(strcmp("BRIGHTLIGHT",comm)))
  {
   if (tnum==2)
   {
    worldbrightlevel=hexnumber(1);
    sysmessage(s, "World bright light level set.");
   }
   return;
  }
  if (!(strcmp("DARKLIGHT",comm)))
  {
   if (tnum==2)
   {
    worlddarklevel=hexnumber(1);
    sysmessage(s, "World dark light level set.");
   }
   return;
  }
  if (!(strcmp("DUNGEONLIGHT",comm)))
  {
   if (tnum==2)
   {
    dungeonlightlevel=min(hexnumber(1), 27);
    sysmessage(s, "Dungeon light level set.");
   }
   return;
  }
  if (!(strcmp("TIME",comm)))
  {
   telltime(s);
   return;
  }
  if(!(strcmp("MANA",comm)))
  {
   target(s,0,1,0,113,"Select person to restore mana to.");
   return;
  }
  if(!(strcmp("STAMINA",comm)))
  {
   target(s,0,1,0,114,"Select person to refresh.");
   return;
  }
  if(!(strcmp("GMOPEN",comm)))
  {
   if (tnum==2) addmitem[s]=hexnumber(1);
   else addmitem[s]=0x15;
   target(s, 0, 1, 0, 115, "Select the character to open the container on.");
   return;
  }
  if (!(strcmp("MAKESHOP", comm)))
  {
   target(s, 0, 1, 0, 116, "Select the character to add shopkeeper buy containers to.");
   return;
  }
  if (!(strcmp("BUY", comm)))
  {
   target(s, 0, 1, 0, 121, "Select the shopkeeper you'd like to buy from.");
   return;
  }
  if (!(strcmp("SETVALUE",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 122, "Select item to edit value.");
   }
   return;
  }
  if (!(strcmp("SETRESTOCK",comm)))
  {
   if (tnum==2)
   {
    addx[s]=makenumber(1);
    target(s, 0, 1, 0, 123, "Select item to edit amount to restock.");
   }
   return;
  }
  if (!(strcmp("RESTOCK", comm)))
  {
   restock(0);
   sysmessage(s, "Manual shop restock has occurred.");
   return;
  }
  if (!(strcmp("RESTOCKALL", comm)))
  {
   restock(1);
   sysmessage(s, "Restocking all shops to their maximums");
   return;
  }
  if (!(strcmp("SETSHOPRESTOCKRATE", comm)))
  {
   if (tnum==2)
   {
    shoprestockrate=makenumber(1);
    sysmessage(s, "NPC shop restock rate changed.");
   }
   else sysmessage(s, "Invalid number of parameters.");
   return;
  }
  if (!(strcmp("WHO", comm)))
  {
   who(s);
   return;
  }
  if (!(strcmp("GMS", comm)))
  {
   gms(s);
   return;
  }
  if (!(strcmp("SELL", comm)))
  {
   target(s, 0, 1, 0, 112, "Click the NPC to sell to.");
   return;
  }
  if (!(strcmp("MIDI", comm)))
  {
   if (tnum==3) playmidi(s, makenumber(1), makenumber(2));
   return;
  }
  if (!(strcmp("GUMPOPEN", comm)))
  {
   if (tnum==3) gumpopen(s, currchar[s], hexnumber(1), hexnumber(2));
   return;
  }
  if (!(strcmp("RESPAWN", comm)))
  {
   respawnnow();
   return;
  }
  if (!(strcmp("SETSPATTACK",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 150, "Select creature to set SPATTACK on.");
   }
   return;
  }
  if (!(strcmp("SETSPADELAY",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 177, "Select creature to set SPADELAY on.");
   }
   return;
  }
  if (!(strcmp("SETPOISON",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 175, "Select creature to set POISON.");
   }
   return;
  }
  if (!(strcmp("SETPOISONED",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 176, "Select creature to set POISONED.");
   }
   return;
  }
  if (!(strcmp("SETADVOBJ",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 178, "Select creature to set ADVOBJ.");
   }
   return;
  }
  
  if (!(strcmp("SETWIPE", comm)))
  {
   addid1[s]=makenumber(1);
   target(s, 0, 1, 0, 133, "Select item to modify.");
   return;
  }
  if(!(strcmp("FULLSTATS",comm)))
  {
   target(s,0,1,0,151,"Select creature to restore full stats.");
   return;
  }
  if(!(strcmp("HIDE",comm)))
  {
   target(s,0,1,0,131,"Select creature to hide.");
   return;
  }
  if(!(strcmp("UNHIDE",comm)))
  {
   target(s,0,1,0,132,"Select creature to reveal.");
   return;
  }
  if(!(strcmp("RELOADSERVER",comm)))
  {
   loadserverscript();
   sysmessage(s,"Server.scp reloaded.");
   return;
  }
  if(!(strcmp("LOADDEFAULTS",comm)))
  {
   loadserverdefaults();
   return;
  }
  if (!(strcmp("CQ",comm)))
  {   
   showgmque(s, 0); // Show the Counselor queue, not GM queue   
   return;
  }
  if (!(strcmp("CNEXT",comm)))
  {   
   nextcall(s, 0); // Show the Counselor queue, not GM queue   
   return;
  }
  if (!(strcmp("CCLEAR",comm)))
  {   
   donewithcall(s, 0); // Show the Counselor queue, not GM queue   
   return;
  }    
  if(!(strcmp("MINECHECK",comm))) 
  {
   if (tnum==2)
   server_data.minecheck=makenumber(1);
  }
  if (!(strcmp("INVUL",comm)))
  {
   addx[s]=1;
   target(s,0,1,0,179,"Select creature to make invulnerable.");
  }
  if (!(strcmp("NOINVUL",comm)))
  {
   addx[s]=0;
   target(s,0,1,0,179,"Select creature to make mortal again.");
  }
  if (!(strcmp("GUARDSON",comm)))
  {
   server_data.guardsactive=1;
   sysbroadcast("Guards have been reactivated.");
  }
  if (!(strcmp("GUARDSOFF",comm)))
  {
   server_data.guardsactive=0;
   sysbroadcast("Warning: Guards have been deactivated globally.");
  }
  if (!(strcmp("HOUSE",comm)))
  {
        tempint[s]=hexnumber(1);
        target(s,0,1,0,207,"Select location for house.");
  }
  //  EviLDeD  -  Catch default command to announce world saves over the system
  //  December 27, 1998
  if(!(strcmp("ANNOUNCEON",comm)))
  {
     cwmWorldState.announce((server_data.announceworldsaves=1));
     sysbroadcast("WorldStat Saves will be displayed.");
  }
  if(!(strcmp("ANNOUNCEOFF",comm)))
  {
     cwmWorldState.announce((server_data.announceworldsaves=0));
     sysbroadcast("WorldStat Saves will not be displayed.");
  }
  //  EviLDeD  -  End
  if (!(strcmp("WF",comm)))
  {
    if (tnum==2)
    {
      addid1[s]=255;
      target(s, 0, 1, 0, 6, "Select item to make WorldForge compatible.");
    }
    return;
  }
  if (!(strcmp("NODECAY",comm)))
  {
    addid1[s]=0;
    target(s, 0, 1, 0, 89, "Select object to make permenant.");
    return;
  }
  if (!(strcmp("SPLIT",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 209, "Select creature to make able to split.");
   }
   return;
  }
  if (!(strcmp("SPLITCHANCE",comm)))
  {
   if (tnum==2)
   {
    tempint[s]=hexnumber(1);
    target(s, 0, 1, 0, 210, "Select creature to set it's chance of spliting.");
   }
   return;
  }
  if (!(strcmp("POSSESS",comm)))
  {
   target(s, 0, 1, 0, 212, "Select creature to POSSESS!!!.");
   return;
  }
 }
}

void broadcast(int s) // GM Broadcast (Done if a GM yells something)
{
 int i,tl;
 char nonuni[512]; 

 if(chars[currchar[s]].unicode)
 for (i=13;i<(buffer[s][1]*256)+buffer[s][2];i=i+2)
 {
    nonuni[(i-13)/2]=buffer[s][i];
 } 

 //char talk2[19];
 
 
 if(!(chars[currchar[s]].unicode))
 {
 //tl=48+(buffer[s][1]*256)+buffer[s][2];
 tl=44+strlen(&buffer[s][8])+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=chars[currchar[s]].ser1;
 talk[4]=chars[currchar[s]].ser2;
 talk[5]=chars[currchar[s]].ser3;
 talk[6]=chars[currchar[s]].ser4;
 talk[7]=chars[currchar[s]].id1;
 talk[8]=chars[currchar[s]].id2;
 talk[9]=1;
 talk[10]=buffer[s][4];
 talk[11]=buffer[s][5];
 talk[12]=buffer[s][6];
// talk[13]=buffer[s][7];
 talk[13]=chars[currchar[s]].fonttype;
 for (i=0;i<now;i++)
 {
  if (perm[i])
  {
   xsend(i, talk, 14, 0);
   xsend(i, chars[currchar[s]].name, 30, 0);   
   xsend(i, &buffer[s][8], strlen(&buffer[s][8])+1, 0);   
  }
 }
 } // end unicode IF
 else
 {
 tl=44+strlen(&nonuni[0])+1;
 
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=chars[currchar[s]].ser1;
 talk[4]=chars[currchar[s]].ser2;
 talk[5]=chars[currchar[s]].ser3;
 talk[6]=chars[currchar[s]].ser4;
 talk[7]=chars[currchar[s]].id1;
 talk[8]=chars[currchar[s]].id2;
 talk[9]=1;
 talk[10]=buffer[s][4];
 talk[11]=buffer[s][5];
 talk[12]=buffer[s][6];
 talk[13]=chars[currchar[s]].fonttype;
   
   for (i=0;i<now;i++)
   {
    if (perm[i])
    {
     xsend(i, talk, 14, 0);
     xsend(i, chars[currchar[s]].name, 30, 0);     
     xsend(i, &nonuni[0], strlen(&nonuni[0])+1, 0);   
    }
   }
  }
}

void itemtalk(int s, int item, char *txt) // Item "speech"
{
 int tl;

 tl=44+strlen(txt)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=items[item].ser1;
 talk[4]=items[item].ser2;
 talk[5]=items[item].ser3;
 talk[6]=items[item].ser4;
 talk[7]=items[item].id1;
 talk[8]=items[item].id2;
 talk[9]=0; // Type
 talk[10]=0;
 talk[11]=0;
 talk[12]=0;
 talk[13]=3;
 xsend(s, talk, 14, 0);
 xsend(s, items[item].name, 30, 0);
 xsend(s, txt, strlen(txt)+1, 0);
}

void npctalk(int s, int npc, char *txt) // NPC speech
{
 int tl;

 tl=44+strlen(txt)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=chars[npc].ser1;
 talk[4]=chars[npc].ser2;
 talk[5]=chars[npc].ser3;
 talk[6]=chars[npc].ser4;
 talk[7]=chars[npc].id1;
 talk[8]=chars[npc].id2;
 talk[9]=0; // Type
 talk[10]=chars[npc].saycolor1=0x00;
 talk[11]=chars[npc].saycolor2=0x5b;
 talk[12]=0;
 talk[13]=chars[currchar[s]].fonttype;
 xsend(s, talk, 14, 0);
 xsend(s, chars[npc].name, 30, 0);
 xsend(s, txt, strlen(txt)+1, 0);
}

void npctalkall(int npc, char *txt) // NPC speech to all in range.
{
 int i;

 for (i=0;i<now;i++)
  if (inrange1p(npc, currchar[i])&&perm[i])
   npctalk(i, npc, txt);
}

void npcemote(int s, int npc, char *txt) // NPC speech
{
 int tl;

 tl=44+strlen(txt)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=chars[npc].ser1;
 talk[4]=chars[npc].ser2;
 talk[5]=chars[npc].ser3;
 talk[6]=chars[npc].ser4;
 talk[7]=chars[npc].id1;
 talk[8]=chars[npc].id2;
 talk[9]=2; // Type
 talk[10]=chars[npc].emotecolor1=0x00;
 talk[11]=chars[npc].emotecolor2=0x26;
 talk[12]=0;
 talk[13]=chars[currchar[s]].fonttype;
 xsend(s, talk, 14, 0);
 xsend(s, chars[npc].name, 30, 0);
 xsend(s, txt, strlen(txt)+1, 0);
}

void npcemoteall(int npc, char *txt) // NPC speech to all in range.
{
 int i;

 for (i=0;i<now;i++)
  if (inrange1p(npc, currchar[i])&&perm[i])
   npcemote(i, npc, txt);
}

/*
Unicode speech format
byte=char, short=char[2], int=char[4], wchar=char[2]=unicode character

Message Sent By Client:
0xAD - Unicode Speech Request
BYTE cmd (0xAD)
short msgsize 1,2
byte type (0=say, 2=emote, 8=whisper, 9=yell) 3
short color 4,5
short font 6,7
BYTE[4] lang (null terminated, "enu " for US english.) 8,9,10,11
wchar[?] text (null terminated, ?=(msgsize-12)/2) 13

Message Sent By Server:
0xAE - Unicode Speech Message
BYTE cmd (0xAE) 0
short msgsize 1,2
BYTE[4] ser (ser of speaker, all 0xFF if none) 3,4,5,6
BYTE[2] model (id of speaker, all 0xFF if none)7,8
BYTE type 9
short color 10,11
short font 12, 13
BYTE[4] language (same as before) 14,15,16,17
BYTE[30] speaker's name (normal chars, not wchars) 18-48
WCHAR[?] text (null terminated, ?=(msgsize-48)/2
*/

void unicodetalking(int s) // PC speech
{
 int tl, i, j,resp, found, x1, x2, y1, y2, match, m2, sml;
 char sect[512];
 char nonuni[512];
 char talk2[19];
 
 tl=48+(buffer[s][1]*256)+buffer[s][2];

 for (i=13;i<(buffer[s][1]*256)+buffer[s][2];i=i+2)
  {
    nonuni[(i-13)/2]=buffer[s][i];
  } 

 if ((buffer[s][13]=='/') || ((buffer[s][13]=='.') && (buffer[s][14]!='.'))) command(s);
 else
 {
  resp=response(s);

  if ((buffer[s][3]=='\x09')&&(chars[currchar[s]].priv&2))
  {
   broadcast(s);
  }
  else
  {      
   talk2[0]=(char)0xAE;
   talk2[1]=tl>>8;
   talk2[2]=tl&0xFF;
   talk2[3]=chars[currchar[s]].ser1;
   talk2[4]=chars[currchar[s]].ser2;
   talk2[5]=chars[currchar[s]].ser3;
   talk2[6]=chars[currchar[s]].ser4;
   talk2[7]=chars[currchar[s]].id1;
   talk2[8]=chars[currchar[s]].id2;
   talk2[9]=buffer[s][3]; // Type
   talk2[10]=buffer[s][4];
   talk2[11]=buffer[s][5];
   talk2[12]=buffer[s][6];
   talk2[13]=chars[currchar[s]].fonttype;
   talk2[14]=buffer[s][8];
   talk2[15]=buffer[s][9];
   talk2[16]=buffer[s][10];         
   xsend(s, talk2, 18, 0);
   xsend(s, chars[currchar[s]].name, 30, 0);   
   for(i=-1;i<(tl-48)-2;i+=2)
   {
   xsend(s, &buffer[s][i+13], 2, 0);   
   }      
   if (talk2[9]==0)
   {
           chars[currchar[s]].saycolor1=buffer[s][4];
           chars[currchar[s]].saycolor2=buffer[s][5];
   }
   if (talk2[9]==2)
   {
           chars[currchar[s]].emotecolor1=buffer[s][4];
           chars[currchar[s]].emotecolor2=buffer[s][5];
           return;
   }
  for (i=0;i<now;i++)
   {
    if ((inrange1(i, s)&&perm[i]))
    {
     xsend(i, talk2, 18, 0);
     xsend(i, chars[currchar[s]].name, 30, 0);          
    if((chars[currchar[i]].priv&0x01)||(chars[currchar[i]].priv&0x80));// GM/Counselors can see ghosts talking always  Seers?
     else if(chars[currchar[i]].spiritspeaktimer==0) // If the spiritspeaktimer is set, you can talk to the dead
     {
      if(chars[currchar[s]].dead==1&&chars[currchar[i]].dead==0)  // Ghost can talk normally to other ghosts
      {
       for(j=0;j<strlen(&nonuni[0])+1;j++) // convert the string to ghost talk
       {
        if(nonuni[j]==32)
          nonuni[j]=32;
        else if(nonuni[j]%2)
          nonuni[j]='O';
        else
          nonuni[j]='o';
       }
      }
     }
     for(j=-1;j<(tl-48)-2;j+=2)
     {
      xsend(i, &buffer[s][j+13], 2, 0);   
     }      
    }
   }
   if(chars[currchar[s]].dead==1)  // this makes it so npcs do not respond to dead people
     return;

   i=0;
   found=0;
   x1=chars[currchar[s]].x;
   y1=chars[currchar[s]].y;
   do
   {
    if ((i!=currchar[s]) && (chars[i].npc))
    {
     x2=chars[i].x;
     y2=chars[i].y;
     if ((abs(x1-x2)<=2) && (abs(y1-y2)<=2)) found=i+1;
    }
    i++;
   }
   while ((i<charcount)&&(found==0));
   if ((found!=0)&&(chars[found-1].speech))
   {
        responsevendor(s);
    found--;
    for (i=0;i<strlen(&nonuni[0]);i++) nonuni[i]=toupper(nonuni[i]);
    talkingto[found]=currchar[s];
    openscript("speech.scp");
    sprintf(sect, "SPEECH %i", chars[found].speech);
    if (!speech_script.find(sect))
    {
     closescript();
     return;
    }
    match=0;
    sprintf(sect, "NO DEFAULT TEXT DEFINED");
    do
    {
     read2();
     if (script1[0]!='}')
     {
      if (!(strcmp("DEFAULT",script1)))
      {
       sprintf(sect, "%s", script2);
      }
      if (!(strcmp("ON",script1)))
      {
       j=0;
       do
       {
        m2=1;
        sml=strlen(script2);
        if (strlen(&nonuni[j])<sml)
        {
//         sml=strlen(&buffer[s][8+j]);
         m2=0;
        }
        else
        for (i=0;i<sml;i++)
        {
         if (nonuni[i+j]!=toupper(script2[i]))
         {
          m2=0;
         }
        }
        j++;
       }
       while ((j<strlen(&nonuni[0]))&&(m2==0));
       if (m2==1) match=1;
      }
      if (!(strcmp("SAY",script1)))
      {
       if (match==1)
       {
        npctalk(s, found, script2);
        match=2;
       }
      }
     }
    }
    while (script1[0]!='}');
    if (match==0)
    {
     npctalk(s, found, sect);
    }
    closescript();
   }
  }
 }
}

void talking(int s) // PC speech
{
 int tl, i, j, resp=0, found, x1, x2, y1, y2, match, m2, sml;
 char sect[512];

 if ((buffer[s][8]=='/') || ((buffer[s][8]=='.') && (buffer[s][9]!='.'))) command(s);
 else
 {
  resp=response(s);
	if (resp!=0) return;  //Vendor responded already
  if ((buffer[s][3]=='\x09')&&(chars[currchar[s]].priv&2))
  {
   broadcast(s);
  }
  else
  {
   tl=44+strlen(&buffer[s][8])+1;
   talk[1]=tl/256;
   talk[2]=tl%256;
   talk[3]=chars[currchar[s]].ser1;
   talk[4]=chars[currchar[s]].ser2;
   talk[5]=chars[currchar[s]].ser3;
   talk[6]=chars[currchar[s]].ser4;
   talk[7]=chars[currchar[s]].id1;
   talk[8]=chars[currchar[s]].id2;
   talk[9]=buffer[s][3]; // Type
   talk[10]=buffer[s][4];
   talk[11]=buffer[s][5];
   talk[12]=buffer[s][6];
//   talk[13]=buffer[s][7]; // Font
   talk[13]=chars[currchar[s]].fonttype;
   xsend(s, talk, 14, 0);
   xsend(s, chars[currchar[s]].name, 30, 0);
   xsend(s, &buffer[s][8], strlen(&buffer[s][8])+1, 0);

   if (talk[9]==0)
   {
     chars[currchar[s]].saycolor1=buffer[s][4];
     chars[currchar[s]].saycolor2=buffer[s][5];
   }
   if (talk[9]==2)
   {
     chars[currchar[s]].emotecolor1=buffer[s][4];
     chars[currchar[s]].emotecolor2=buffer[s][5];
     return;
   }
   if (server_data.log==2)
   {
	sprintf(temp,"%s: %s\n",chars[currchar[s]].name,&buffer[s][8]);
	savelog(temp,"speech.log");
   }

   for (i=0;i<now;i++)
   {
    if ((inrange1(i, s)&&perm[i]))
    {
     xsend(i, talk, 14, 0);
     xsend(i, chars[currchar[s]].name, 30, 0);
    if((chars[currchar[i]].priv&0x01)||(chars[currchar[i]].priv&0x80));// GM/Counselors can see ghosts talking always  Seers?
     else if(chars[currchar[i]].spiritspeaktimer==0) // If the spiritspeaktimer is set, you can talk to the dead
     {
      if(chars[currchar[s]].dead==1&&chars[currchar[i]].dead==0)  // Ghost can talk normally to other ghosts
      {
       for(j=8;j<strlen(&buffer[s][8])+8;j++) // convert the string to ghost talk
       {
        if(buffer[s][j]==32)
          buffer[s][j]=32;
        else if(buffer[s][j]%2)
          buffer[s][j]='O';
        else
          buffer[s][j]='o';
       }
      }
     }
     xsend(i, &buffer[s][8], strlen(&buffer[s][8])+1, 0);
    }
   }
   if(chars[currchar[s]].dead==1)  // this makes it so npcs do not respond to dead people
     return;

   i=0;
   found=0;
   x1=chars[currchar[s]].x;
   y1=chars[currchar[s]].y;
   do
   {
    if ((i!=currchar[s]) && (chars[i].npc))
    {
     x2=chars[i].x;
     y2=chars[i].y;
     if ((abs(x1-x2)<=2) && (abs(y1-y2)<=2)) found=i+1;
    }
    i++;
   }
   while ((i<charcount)&&(found==0));
   if ((found!=0)&&(chars[found-1].speech))
   {
        responsevendor(s);
    found--;
    for (i=0;i<strlen(&buffer[s][8]);i++) buffer[s][i+8]=toupper(buffer[s][i+8]);
    talkingto[found]=currchar[s];
    openscript("speech.scp");
    sprintf(sect, "SPEECH %i", chars[found].speech);
    if (!speech_script.find(sect))
    {
     closescript();
     return;
    }
    match=0;
    sprintf(sect, "NO DEFAULT TEXT DEFINED");
    do
    {
     read2();
     if (script1[0]!='}')
     {
      if (!(strcmp("DEFAULT",script1)))
      {
       sprintf(sect, "%s", script2);
      }
      if (!(strcmp("ON",script1)))
      {
       j=0;
       do
       {
        m2=1;
        sml=strlen(script2);
        if (strlen(&buffer[s][8+j])<sml)
        {
//         sml=strlen(&buffer[s][8+j]);
         m2=0;
        }
        else
        for (i=0;i<sml;i++)
        {
         if (buffer[s][i+8+j]!=toupper(script2[i]))
         {
          m2=0;
         }
        }
        j++;
       }
       while ((j<strlen(&buffer[s][8]))&&(m2==0));
       if (m2==1) match=1;
      }
      if (!(strcmp("SAY",script1)))
      {
       if (match==1)
       {
        npctalk(s, found, script2);
        match=2;
       }
      }
     }
    }
    while (script1[0]!='}');
    if (match==0)
    {
     npctalk(s, found, sect);
    }
    closescript();
   }
  }
 }
}


void singleclick(int s)
{
 int i, j, a1, a2, a3, a4, serial;
 char temp2[100];
 tile_st tile;
 char mode, ok, used;

 a1=buffer[s][1];
 a2=buffer[s][2];
 a3=buffer[s][3];
 a4=buffer[s][4];
 serial=calcserial(a1,a2,a3,a4);
 for (i=0;i<charcount;i++)
  if ((chars[i].ser1==a1)&&(chars[i].ser2==a2)&&(chars[i].ser3==a3)&&(chars[i].ser4==a4))
 {
  showcname(s, i, 0);
  return;
 }
// for (i=0;i<itemcount;i++)
//  if ((items[i].ser1==a1)&&(items[i].ser2==a2)&&(items[i].ser3==a3)&&(items[i].ser4==a4))
 i=findbyserial(&itemsp[serial%256], serial, 0);
 if (i==-1)
 {
   printf("UOX3.CPP: singleclick couldn't find item serial: %d\n", serial);
   return;
 }
  if (chars[currchar[s]].priv&8)
  {
   sprintf(temp, "%i %s [%x %x %x %x]", items[i].amount, items[i].name, a1, a2, a3, a4);
   itemmessage(s, temp, a1, a2, a3, a4);
  }
  else
  {
   if (items[i].name[0]!='#')
   {
    if ((!(items[i].pileable))||(items[i].amount==1))
    {
     itemmessage(s, items[i].name, a1, a2, a3, a4);
    }
    else
    {
     sprintf(temp, "%i %ss", items[i].amount, items[i].name);
     itemmessage(s, temp, a1, a2, a3, a4);
    }
   }
   else
   {
    seektile((items[i].id1*256)+items[i].id2, &tile);
    if (items[i].amount==1)
    {
     if (tile.flag2&0x80) sprintf(temp, "an ");
     else if (tile.flag2&0x40) sprintf(temp, "a ");
     else temp[0]=0;
    }
    else sprintf(temp, "%i ", items[i].amount);
    mode=0;
    used=0;
    for (j=0;j<strlen(tile.name);j++)
    {
     ok=0;
     if ((tile.name[j]=='%')&&(mode==0)) mode=2;
     else if ((tile.name[j]=='%')&&(mode!=0)) mode=0;
     else if ((tile.name[j]=='/')&&(mode==2)) mode=1;
     else if (mode==0) ok=1;
     else if ((mode==1)&&(items[i].amount==1)) ok=1;
     else if ((mode==2)&&(items[i].amount>1)) ok=1;
     if (ok)
     {
      strcpy(temp2,temp);
      sprintf(temp, "%s%c", temp2, tile.name[j]);
      if (mode) used=1;
     }
    }
    if ((!used)&&(items[i].amount>1))
    {
     strcpy(temp2,temp);
     sprintf(temp, "%ss", temp2);
    }
        if (items[i].type == 15)
        {
         char charges[]="charges";
         sprintf(temp, "%s %s %i %s",temp, items[i].name2, items[i].morez, charges);
        }
    itemmessage(s, temp, a1, a2, a3, a4);
   }
  }
}

void mounthorse(int s, int x) // Remove horse char and give player a horse item
{
   int j,c;

   if(npcinrange(s,x,2)==0) return;
   if (chars[x].ownserial==chars[currchar[s]].serial)
//    (chars[x].own1==chars[currchar[s]].ser1)&&
//    (chars[x].own2==chars[currchar[s]].ser2)&&
//    (chars[x].own3==chars[currchar[s]].ser3)&&
//    (chars[x].own4==chars[currchar[s]].ser4))
   {
      if (chars[currchar[s]].onhorse)
      {
       sysmessage(s,"You are already on a mount.");
       return;
      }
      sprintf(temp, "%s", chars[x].name);
      chars[currchar[s]].onhorse=1;
      c=SpawnItem(s, 1, temp, 0, 0x09, 0x15, chars[x].skin1, chars[x].skin2, 0, 0);

      items[c].id1=0x3E;
      if (chars[x].id2==0xC8) items[c].id2=0x9F;
      if (chars[x].id2==0xE2) items[c].id2=0xA0;
      if (chars[x].id2==0xE4) items[c].id2=0xA1;
      if (chars[x].id2==0xCC) items[c].id2=0xA2;
      if (chars[x].id2==0xD2) items[c].id2=0xA3;//desert
      if (chars[x].id2==0xDA) items[c].id2=0xA4;//Harp
      if (chars[x].id2==0xDB) items[c].id2=0xA5;//Another
      if (chars[x].id2==0xDC) items[c].id2=0xA6;//llama
      setserial(c,currchar[s], 4);
      items[c].layer=0x19;
      items[c].x=chars[x].fx1;
      items[c].y=chars[x].fy1;
      items[c].z=chars[x].fz1;
      items[c].moreb1=chars[x].npcWander;
      items[c].att=chars[x].fx2;
      items[c].def=chars[x].fy2;
      wornitems(s, currchar[s]);
      for (j=0;j<now;j++)
      {
         if (inrange1(s, j)&&perm[j]) wornitems(j, currchar[s]);
      }
      deletechar(x);
   }
   else
   {
      sysmessage(s, "You dont own that creature.");
   }
}

void doubleclick(int s)
{
//changed this routine to return after entering a condition check.
//there is no need to stay in here longer than neccessary.  Zadius
//NOTICE:  There are alot of condition checks in this routine that can be replaced
//by a trigger.  Make a replacement trigger for it then remove it.
 int a1, a2, a3, a4, x, i, j, c, w=0, k, keyboard,serial;
 char pdoll[67]="\x88\x00\x05\xA8\x90\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
// char map1[22]="\x33\x01\x90\x40\x01\x02\x03\x13\x9D\x04\x44\x05\x74\x06\xC8\x07\x84\x00\xC8\x00\xC8";
 char map1[20]="\x90\x40\x01\x02\x03\x13\x9D\x00\x00\x00\x00\x13\xFF\x0F\xA0\x01\x90\x01\x90";
 char map2[12]="\x56\x40\x01\x02\x03\x05\x00\x00\x00\x00\x00";
 int los;
 int p;

 a1=buffer[s][1]&0x7F;
 a2=buffer[s][2];
 a3=buffer[s][3];
 a4=buffer[s][4];
 serial=calcserial(a1,a2,a3,a4);
 keyboard=buffer[s][1]&0x80;
 x=-1;
 x=findbyserial(&charsp[serial%256], serial, 1);

 if (
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xC8'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xE2'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xE4'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xCC'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xDC'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xD2'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xDA'))||
     ((chars[x].npc)&&(chars[x].id1=='\x00')&&(chars[x].id2=='\xDB'))
    )
 {
  if (chardist(currchar[s], x)<2)
  {
   if (chars[currchar[s]].dead) sysmessage(s,"Ghosts cannot ride!");
    else mounthorse(s, x);
  }
   else sysmessage(s, "You need to get closer.");
  x=-1;	
 }
 if ((chars[x].npc)&&((chars[x].id1!='\x01')||(chars[x].id2<0x90)||(chars[x].id2>0x93)))
 {
    x=-1;
    sysmessage(s, "You cannot open monsters paperdolls.");
 }
 if (x!=-1)
 {
   if ((chars[currchar[s]].serial==serial) && (!keyboard))
   if (unmounthorse(s)==0) x=-1;
 }
 if (x!=-1)
 {
  pdoll[1]=a1;
  pdoll[2]=a2;
  pdoll[3]=a3;
  pdoll[4]=a4;

  if (chars[x].priv&0x10) {                                     //GM.
     sprintf(&pdoll[5], "%s %s", chars[x].name, chars[x].title);
  } else {                                                      //Player.
     sprintf(&pdoll[5], "%s%s", title3(x), chars[x].name);      //Repuation + Name
     if ((chars[x].towntitle)||(chars[x].townpriv==2)) {        //TownTitle.
        if (chars[x].townpriv==2) {                             //Mayor
           sprintf(&pdoll[5], "The Mayor %s of %s, %s %s", chars[x].name, townname(chars[x].town,3), title1(x), title2(x));
        } else {                                                //Resident
           sprintf(&pdoll[5], "%s of %s, %s %s", chars[x].name, townname(chars[x].town,3), title1(x), title2(x));
        }
     } else {                                                   //NoTownTitle
        strcpy(temp,&pdoll[5]);                                 //?
        if (strlen(chars[x].title)>0) {                         //Titled & Skill
           sprintf(&pdoll[5], "%s %s, %s %s", temp, chars[x].title, title1(x), title2(x));
        } else {                                                //Just skilled
           sprintf(&pdoll[5], "%s, %s %s", temp, title1(x), title2(x));
        }
     }
  }
  xsend(s, pdoll, 66, 0);
 }
 x=-1;
 x=findbyserial(&itemsp[serial%256], serial, 0);
 if (x==-1) return;
 if (items[x].type==16)
 {
  if (chars[currchar[s]].dead==1)
  {
   buffer[s][7]=chars[currchar[s]].ser1;
   buffer[s][8]=chars[currchar[s]].ser2;
   buffer[s][9]=chars[currchar[s]].ser3;
   buffer[s][10]=chars[currchar[s]].ser4;
   resurrecttarget(s);
   sysmessage(s,"You have been resurrected.");
   return;
  }
 }
 if ((chars[currchar[s]].dead==1)&&(x!=-1))
 {
  x=-1;
  sysmessage(s, "You may not do that as a ghost.");
 }
	// Zippy's snooping change start
 if (x!=-1)
	if (((items[x].type==1)||(items[x].type==63)||(items[x].type==65)||(items[x].type==87))&&(server_data.rogue))//&&(items[x].layer==0x15)
	{
		int npc, contser;
		contser=items[x].contserial; //calcserial(items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4);

		if (contser<0)
		{
			backpack(s,a1,a2,a3,a4);
			return;
		}
		if (items[x].cont1>=0x40)
		{
			do
			{
				x=findbyserial(&contsp[items[x].contserial%256], items[x].contserial, 0); //calcItemFromSer(items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4);	
				//printf("Repeat: %i\n",z);
				//z++;
			} while (items[x].cont1>=0x40);
		}
		npc=findbyserial(&charsp[items[x].contserial%256], items[x].contserial, 1); //calcCharFromSer(items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4);
		if ((npcinrange(s,npc,2))||(chars[currchar[s]].priv&0x01)||(iteminrange(s,x,2)))
		{
			if ((x!=-1)&&(contser>1)&&(contser!=chars[currchar[s]].serial)&&!(chars[currchar[s]].priv&0x01)) //calcserial(chars[currchar[s]].ser1,chars[currchar[s]].ser2,chars[currchar[s]].ser3,chars[currchar[s]].ser4))&&!(chars[currchar[s]].priv&0x01))
			{
				if ((checkskill(currchar[s],SNOOPING,0,1000))&&(!(chars[npc].priv&0x01)))
				{
					backpack(s, a1, a2, a3, a4);
					sysmessage(s,"You successfully peek into that container.");
				} else {
					sysmessage(s,"You failed to peek into that container.");
					//printf("Priv %i\n",chars[npc].priv);
					if (chars[npc].npc) npctalk(s,npc, "Art thou attempting to disturb my privacy?");
					sprintf(temp,"You notice %s trying to peek into your pack!",chars[currchar[s]].name);
					sysmessage(calcCharFromSer(items[x].cont1,items[x].cont2,items[x].cont3,items[x].cont4),temp);
					if (chars[currchar[s]].karma<=1000) chars[currchar[s]].karma-=10;
				}
			} else backpack(s, a1, a2, a3, a4);
		} else {
			sysmessage(s,"You are too far away!");
	 }
	 return;
 }
 //Zippy's snooping change - end
 if  (!(chars[currchar[s]].priv&0x01)&&(x>=0)&&(items[x].layer!=0)&&
//      ((items[x].cont1!=chars[currchar[s]].ser1)||(items[x].cont2!=chars[currchar[s]].ser2)||
//       (items[x].cont3!=chars[currchar[s]].ser3)||(items[x].cont4!=chars[currchar[s]].ser4)))
      (items[x].contserial!=chars[currchar[s]].serial))
 {
  x=-1;
  sysmessage(s, "You cannot use items equipped by other players.");
 }
 if (x>=0)
 if((chars[currchar[s]].objectdelay<=getclock())||(chars[currchar[s]].priv&1))
 {
 chars[currchar[s]].objectdelay=getclock()+(server_data.objectdelay*CLOCKS_PER_SEC);
 {
  if (items[x].trigger > 0)
  {
    if (iteminrange(s,x,1))  
        if (items[x].trigtype==0)
        {
          if (!items[x].disabled)
          {
            triggerwitem(s, x, 1); //if players uses trigger
          } else {
            sysmessage(s,"That doesnt seem to work right now.");
          }

        }
    else
    sysmessage(s, "You are not close enough to use that.");
    return;
  }
  
  //check this on trigger in the event that the .trigger property is not set on the item
  //trigger code.  Check to see if item is envokable by id
  if (checkenvoke(items[x].id1,items[x].id2))
  {
    chars[currchar[s]].envokeitem=x;
    chars[currchar[s]].envokeid1=items[x].id1;
    chars[currchar[s]].envokeid2=items[x].id2;
    target(s, 0, 1, 0, 24, "What will you use this on?");
    return;
  }

  if (items[x].type==15)
  {
   if (items[x].morez!=0)
   {
        if(castspell(s, (8*(items[x].morex-1))+items[x].morey, 2, x))
        { items[x].morez--;
         if (items[x].morez == 0)
         {
                items[x].type = items[x].type2;
                items[x].morex = 0;
                items[x].morey = 0;
                items[x].offspell = 0;
         }
        }
   }
   return;
  }
  if ((items[x].id1==0x0F)&&(items[x].id2==0xA9))
  {
   dyeall[s]=0;
   target(s, 0, 1, 0, 31, "Which dye vat will you use this on?");
   return;
  }
  if ((items[x].id1==0x0F)&&(items[x].id2==0xAB))
  {
   addid1[s]=items[x].color1;
   addid2[s]=items[x].color2;
   target(s, 0, 1, 0, 32, "Select the clothing to use this on.");
   return;
  }
  if ((items[x].id1==0x14)&&(items[x].id2==0xF0)&&(items[x].type!=103))
  {  //experimental house code
   chars[currchar[s]].making=x;
   chars[currchar[s]].fx1=x; //for deleting it later
   addid3[s]=items[x].morex;
   buildhouse(s,items[x].morex);
   //target(s,0,1,0,207,"Select Location for house.");
   return;
  }
  if ((items[x].type==1)||(items[x].type==63)||(items[x].type==65)||(items[x].type==87))
  {
    if (items[x].moreb1==1) magictrap(s, x);
//   if ((items[x].cont1==255)&&(items[x].cont2==255)&&(items[x].cont3==255)&&(items[x].cont4==255))
    if (items[x].contserial==-1)
      backpack(s, a1, a2, a3, a4);
//   else if ((items[x].cont1==chars[currchar[s]].ser1)&&(items[x].cont2==chars[currchar[s]].ser2)&&
//            (items[x].cont3==chars[currchar[s]].ser3)&&(items[x].cont4==chars[currchar[s]].ser4))
    else if (items[x].contserial==chars[currchar[s]].serial)
     backpack(s, a1, a2, a3, a4);
   else if (items[x].cont1>='\x40') backpack(s, a1, a2, a3, a4);
   else if (chars[currchar[s]].priv&0x40) backpack(s, a1, a2, a3, a4);
   else if (checkskill(currchar[s],SNOOPING,0,1000))
        {
        backpack(s, a1, a2, a3, a4);
        sysmessage(s,"You successfully peek into their pack.");
        }
        else
          {
						int npc=-1;
                  sprintf(temp,"You notice %s trying to peek into your pack!",chars[currchar[s]].name);
									npc=findbyserial(&charsp[items[x].contserial%256], items[x].contserial, 1);
									if (npc!=-1)
									{
										sysmessage(calcSocketFromChar(npc),temp);
									}
          if (chars[currchar[s]].karma<=1000) chars[currchar[s]].karma-=10;
          }
   //else sysmessage(s, "You may not look into other peoples belongings.");
   return;
  }
  if (items[x].type==2)
  {
   for (j=0;j<itemcount;j++) if (items[j].type==3)
   {
    if (items[j].z==29)
    {
     items[j].z=46;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,j);
     w=1;
    }
    else if (items[j].z==46)
    {
     items[j].z=29;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,j);
     w=0;
    }
   }
   if (w==1) sysmessage(s, "Order Gate opened.");
   else sysmessage(s, "Order Gate closed.");
   return;
  }
  if (items[x].type==4)
  {
   for (j=0;j<itemcount;j++) if (items[j].type==5)
   {
    if (items[j].z==15)
    {
     items[j].z=31;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,j);
     w=1;
    }
    else if (items[j].z==31)
    {
     items[j].z=15;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,j);
     w=0;
    }
   }
   if (w==1) sysmessage(s, "Chaos Gate opened.");
   else sysmessage(s, "Chaos Gate closed.");
   return;
  }
  if (items[x].type==6)
  {
   target(s, 0, 1, 0, 2, "Select teleport target.");
   return;
  }
  if ((items[x].id1==0x10) && ((items[x].id2==0x71) || (items[x].id2==0x75)))
  {
    sysmessage(s, "You must wait for it to stop swinging !");
    return;
  }
  if ((items[x].id1==0x10) && ((items[x].id2==0x0a) || (items[x].id2==0x0b)))
  {
    AButte(s,x);
    return;
  }
  if (items[x].type==7)
  {
   addid1[s]=items[x].more1;
   addid2[s]=items[x].more2;
   addid3[s]=items[x].more3;
   addid4[s]=items[x].more4;
   if (items[x].more1==255) addid1[s]=255;
   target(s, 0, 1, 0, 11, "Select item to use the key on.");
   return;
  }
  if ((items[x].type==8)||(items[x].type==64))
  {
   sysmessage(s, "This item is locked.");
   return;
  }
  if (items[x].type==9)
  {
   k=packitem(currchar[s]);
//   if (((items[x].cont1==items[k].ser1)&&(items[x].cont2==items[k].ser2)&&
//        (items[x].cont3==items[k].ser3)&&(items[x].cont4==items[k].ser4))||
//       ((items[x].cont1==chars[currchar[s]].ser1)&&(items[x].cont2==chars[currchar[s]].ser2)&&
//        (items[x].cont3==chars[currchar[s]].ser1)&&(items[x].cont4==chars[currchar[s]].ser4)&&
   if ((items[x].contserial==items[k].serial) || (items[x].contserial==chars[currchar[s]].serial) && (items[x].layer==1))
   {
    spellbook(s);
   }
   else
   {
    sysmessage(s, "If you wish to open a spellbook, it must be equipped or in your main backpack.");
   }
   return;
  }
  if (items[x].type==10)
  {
   map1[1]=items[x].ser1;
   map1[2]=items[x].ser2;
   map1[3]=items[x].ser3;
   map1[4]=items[x].ser4;
   map2[1]=items[x].ser1;
   map2[2]=items[x].ser2;
   map2[3]=items[x].ser3;
   map2[4]=items[x].ser4;
   xsend(s, map1, 19, 0);
   xsend(s, map2, 11, 0);
   return;
  }
  if (items[x].type==11)
  {
   openbook(s, x);
   return;
  }
  if (items[x].type==12)
  {
   dooruse(s, x);
   return;
  }
  if (items[x].type==13)
  {
   p=packitem(currchar[s]);
   for (j=0;j<itemcount;j++)
   {
     if (
         (items[j].type==7)&&
         ((items[j].more1==items[x].more1)&&(items[j].more2==items[x].more2)&&
         (items[j].more3==items[x].more3)&&(items[j].more4==items[x].more4))&&
         ((items[j].cont1==items[p].ser1)&&(items[j].cont2==items[p].ser2)&&
         (items[j].cont3==items[p].ser3)&&(items[j].cont4==items[p].ser4))
        )
     {
         npctalk(s,currchar[s],"You quickly unlock, use, and then relock the door.");
         dooruse(s, x);
         return;
     }
   }
   sysmessage(s, "This door is locked.");
   return;
  }
  if (items[x].type==14) // For eating food
  {
   int foodsnd;
   foodsnd=rand()%3;
   if (chars[currchar[s]].hunger != 6)
   {
    switch(foodsnd)
    {
       case 0: soundeffect2(currchar[s], 0x00, 0x3A);
               break;
       case 1: soundeffect2(currchar[s], 0x00, 0x3B);
               break;
       case 2: soundeffect2(currchar[s], 0x00, 0x3C);
    }
   }
   switch(chars[currchar[s]].hunger)
   {
    case 0:  sysmessage(s, "You eat the food, but are still extremely hungry.");
             break;
    case 1:  sysmessage(s, "You eat the food, but are still extremely hungry.");
             break;
    case 2:  sysmessage(s, "After eating the food, you feel much less hungry.");
             break;
    case 3:  sysmessage(s, "You eat the food, and begin to feel more satiated.");
             break;
    case 4:  sysmessage(s, "You feel quite full after consuming the food.");
             break;
    case 5:  sysmessage(s, "You are nearly stuffed, but manage to eat the food.");
             break;
    case 6:  sysmessage(s, "You are simply too full to eat any more!");
             break;
   }
   if (chars[currchar[s]].hunger<6)
   {
     int j;
     //Remove a food item
     if (items[x].amount!=1)
     {
        items[x].amount--;
        for (j=0;j<now;j++) if (perm[j] && inrange2(j,x)) senditem(j,x);
     }
     else
     {
        deleitem(x);
     }
     chars[currchar[s]].hunger++;
   }
   return;
  }
  if (items[x].type==18)
  {
   int a1, a2, a3, a4, j;
   a1=items[x].ser1;
   a2=items[x].ser2;
   a3=items[x].ser3;
   a4=items[x].ser4;
   j=rand()%10;
   switch(j)
    {
     case 0:  itemmessage(s,"Seek out the mystic llama herder.", a1, a2, a3, a4);
              break;
     case 1:  itemmessage(s,"Wherever you go, there you are.", a1, a2, a3, a4);
              break;
     case 2:  itemmessage(s,"Quick! Lord British is giving away gold at the castle!", a1, a2, a3, a4);
              break;
     case 3:  itemmessage(s,"Remember, change your underwear once a day.", a1, a2, a3, a4);
              break;
     case 4:  itemmessage(s,"The message appears to be too cloudy to make anything out of it.", a1, a2, a3, a4);
              break;
     case 5:  itemmessage(s,"You have just lost five strength.. not!", a1, a2, a3, a4);
              break;
     case 6:  itemmessage(s,"You're really playing a game you know", a1, a2, a3, a4);
              break;
     case 7:  itemmessage(s,"You will be successful in all you do.", a1, a2, a3, a4);
              break;
     case 8:  itemmessage(s,"You are a person of culture.", a1, a2, a3, a4);
              break;
     case 9:  itemmessage(s,"Give me a break! How much good fortune do you expect!", a1, a2, a3, a4);
              break;
    }
   soundeffect(s, 0x01, 0xEC);
   return;
  }
  if (items[x].type==19)
  {
   usepotion(currchar[s], x);
   return;
  }
  if (items[x].id1==0x0E && items[x].id2==0x9C)
  {
          if (checkskill(currchar[s], MUSICIANSHIP,0,1000)) soundeffect2(currchar[s], 0x00, 0x38);
   else soundeffect2(currchar[s], 0x00, 0x39);
   return;
  }
  if (items[x].id1==0x0E && (items[x].id2==0x9D || items[x].id2==0x9E))
  {
          if (checkskill(currchar[s], MUSICIANSHIP,0,1000)) soundeffect2(currchar[s], 0x00, 0x52);
   else soundeffect2(currchar[s], 0x00, 0x53);
   return;
  }
  if (items[x].id1==0x0E && (items[x].id2==0xB1 || items[x].id2==0xB2))
  {
          if (checkskill(currchar[s], MUSICIANSHIP,0,1000)) soundeffect2(currchar[s], 0x00, 0x45);
   else soundeffect2(currchar[s], 0x00, 0x46);
   return;
  }
  if (items[x].id1==0x0E && (items[x].id2==0xB3 || items[x].id2==0xB4))
  {
          if (checkskill(currchar[s], MUSICIANSHIP,0,1000)) soundeffect2(currchar[s], 0x00, 0x4C);
   else soundeffect2(currchar[s], 0x00, 0x4D);
   return;
  }
  if (items[x].id1==0x1F && (items[x].id2>0x2C && items[x].id2<0x6D))
  {
		int success=0;
		if (items[x].id2==0x2D)  //Reactive Armor spell scrolls
		{
			success=castspell(s,7, 1, 0);
		}
		if ((items[x].id2>=0x2E)&&(items[x].id2<=0x34))  //first circle spell scrolls
		{
			success=castspell(s,items[x].id2-0x2D, 1, 0);
		}
		if ((items[x].id2>=0x35)&&(items[x].id2<=0x6C))  //2 to 8 circle spell scrolls
		{
      success=castspell(s,items[x].id2-0x2D+1, 1, 0);
		}

		//remove scrolls if spell cast Tauriel
		if (success)
		{
			if (items[x].amount!=1)
			{
				items[x].amount--;
				for (j=0;j<now;j++) if (perm[j] && inrange2(j,x)) senditem(j,x);
			}
			else
			{
				deleitem(x);
			}
		}
		return;
  }
  if (items[x].type==50)
  {
   chars[currchar[s]].runenumb=x;
   sysmessage(s,"Enter new rune name.");
   return;
  }
  if (((items[x].id1==0x0F)&&                          // Executioner Axe, Battle Axe,
      ((items[x].id2>=0x43)&&(items[x].id2<=0x4E)))|| // Axe, Double Axe and Bardiche
      ((items[x].id1==0x13)&&
      ((items[x].id2==0xaf)||(items[x].id2==0xb0)||   // War Axe
       (items[x].id2==0xfa)||(items[x].id2==0xfb)))|| // Large Battle Axe
      ((items[x].id1==0x14)&&
      ((items[x].id2==0x42)||(items[x].id2==0x43)||   // Two Handed Axe
       (items[x].id2==0x3e)||(items[x].id2==0x3f))))  // Halberd
   {
    target(s, 0, 1, 0, 76, "What would you like to use that on ?");
   return;
  }
  if ((items[x].id1==0x0F)&&((items[x].id2==0xB4)||(items[x].id2==0xB5))|| //sledge hammers
      (items[x].id1==0x0F)&&((items[x].id2==0xBB)||(items[x].id2==0xBC))|| //tongs
      (items[x].id1==0x13)&&((items[x].id2==0xE3)||(items[x].id2==0xE4)))  //smith's hammers
  {
   target(s, 0, 1, 0, 50, "Select material to use.");
   return;
  }
  if ((items[x].id1==0x10)&&(items[x].id2>=0x26)&&(items[x].id2<=0x35)) //carpentry tools
  {
   target(s, 0, 1, 0, 134, "Select material to use.");
   return;
  }
  if ((items[x].id1==0x0E)&&((items[x].id2==0x85)||(items[x].id2==0x86))|| //pickaxes
      (items[x].id1==0x0F)&&((items[x].id2==0x39)||(items[x].id2==0x3A)))  //shovels
  {
   target(s, 0, 1, 0, 51, "Where do you want to dig?");
   return;
  } // Added by Genesis 11-16-98 to implement empty vial to vial of blood
  if((items[x].id1==0x0E)&&(items[x].id2==0x24)) //empty vial
  {
// if((items[x].cont1==items[packitem(currchar[s])].ser1)&&
//    (items[x].cont2==items[packitem(currchar[s])].ser2)&&
//    (items[x].cont3==items[packitem(currchar[s])].ser3)&&
//    (items[x].cont4==items[packitem(currchar[s])].ser4))
    if (items[x].contserial==items[packitem(currchar[s])].serial)
   {
      target(s, 0, 1, 0, 186, "What do you want to fill the vial with?");
   }
   else sysmessage(s,"The vial is not in your pack");
   return;
  }
   if ((items[x].id1==0x0D)&&(items[x].id2==0xF9)) //cotton to thread 
  {
       chars[currchar[s]].tailitem=x;   
           target(s, 0, 1, 0, 166, "Select spinning wheel to spin cotton.");
   return;
  }
   if ((items[x].id1==0x09)&&(items[x].id2==0xF1)) //Raw meat to Cooked
  {
       chars[currchar[s]].tailitem=x;   
           target(s, 0, 1, 0, 168, "Select where to cook meat on.");
     
   return;
  }
  if ((items[x].type==100))
  {
    for(i=0;i<itemcount;i++)
    {

      if(((items[i].moreb1==items[x].morex)&&(items[i].moreb2==items[x].morey)&&(items[i].moreb3==items[x].morez))||((items[i].morex==items[x].morex)&&(items[i].morey==items[x].morey)&&(items[i].morez==items[x].morez))&&((i!=x)&&(items[x].morex!=0)&&(items[x].morey!=0)&&(items[x].morez!=0)))
      { 

        if((items[i].morex==0)&&(items[i].morey==0)&&(items[i].morez==0))
        { 
          items[i].morex=items[i].moreb1;
          items[i].morey=items[i].moreb2;
          items[i].morez=items[i].moreb3;
          items[i].visible=0;
          for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
        } else {
          items[i].moreb1=items[i].morex;
          items[i].moreb2=items[i].morey;
          items[i].moreb3=items[i].morez;
          items[i].morex=0;
          items[i].morey=0;
          items[i].morez=0;
          items[i].visible=2;
          for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
        }
      }
    }
    return;
  }
  if (items[x].type==101)
  {
    i=items[x].morex;
    chars[currchar[s]].id1=i/256; 
    chars[currchar[s]].id2=i%256; 
    teleport(currchar[s]);
    items[x].type=102;
    return;
  }
  if (items[x].type==102)
  { 
    chars[currchar[s]].id1=chars[currchar[s]].xid1; 
    chars[currchar[s]].id2=chars[currchar[s]].xid2; 
    teleport(currchar[s]);
    items[x].type=101;
    return;
  }
  if ((items[x].id1==0x0F)&&((items[x].id2==0xA0)||(items[x].id2==0xA1))|| //thread to cloth
      (items[x].id1==0x0E)&&((items[x].id2==0x1D)||(items[x].id2==0x1E)))  //yarn to cloth
  {
      chars[currchar[s]].tailitem=x;
          target(s, 0, 1, 0, 165, "Select loom to make your cloth");
          return;
  }
  if ((items[x].id1==0x14)&&(items[x].id2==0xED)) //Build cannon
  {
                target(s, 0, 1, 0, 171, "Build this Monster!");
                deleitem(x);
                return;
   
  }
  if (items[x].id1==0x1B && (items[x].id2>=0xD1 && items[x].id2<=0xD6))  // make shafts
  {
   itemmake[s].materialid1=items[x].id1;
   itemmake[s].materialid2=items[x].id2;
   target(s, 0, 1, 0, 172, "What would you like to use this with?"); 
   return;
  }
   if ((items[x].id1==0x0E)&&(items[x].id2==0x73)) //cannon ball
  {
       
           target(s, 0, 1, 0, 170, "Select cannon to load."); 
           deleitem(x);    
           return;
   
  }
  if ((items[x].id1==0x0F)&&(items[x].id2==0xF8)||(items[x].id2==0xF9)) //pitcher of water to flour
  {
      chars[currchar[s]].tailitem=x;
          target(s, 0, 1, 0, 173, "Select flour to pour this on.");  
          return;
  }
  if ((items[x].id1==0x09)&&(items[x].id2==0xC0)||(items[x].id2==0xC1)) //sausages to dough
  {
      chars[currchar[s]].tailitem=x;
          target(s, 0, 1, 0, 174, "Select dough to put this on.");  
          return;
     
  }
  if ((items[x].id1==0x0D)&&(items[x].id2==0xF8)) //wool to yarn 
  {
       chars[currchar[s]].tailitem=x;   
           target(s, 0, 1, 0, 164, "Select your spin wheel to spin wool.");      
           return;
  
  }
   if ((items[x].id1==0x0F)&&(items[x].id2==0x9D)) //sewing kit for tailoring
  {
   target(s, 0, 1, 0, 167, "Select material to use.");
   return;
  }

  if ((items[x].id1==0x19)&&((items[x].id2==0xB7)||(items[x].id2==0xB9)||(items[x].id2==0xBA)||(items[x].id2==0xB8)))
  {
   chars[currchar[s]].smeltitem=x;
   target(s, 0, 1, 0, 52, "Select forge to smelt ore on.");//smelting  for all ore changed by Myth 11/12/98
   return;
  }

  if (((items[x].id1==0x0E)&&
       ((items[x].id2>=0xC2)&&(items[x].id2<=0xC5)))|| //cleaver skinning knife
      ((items[x].id1==0x0F)&&
       ((items[x].id2==0x51)||(items[x].id2==0x52)) || // Dagger
        ((items[x].id2>=0x5E)&&(items[x].id2<=0x61)))|| // Broad Sword Long Sword1
      ((items[x].id1==0x13)&&
       ((items[x].id2>=0xB5)&&(items[x].id2<=0xBA)|| // Scimitar Long Sword2 Viking Sword
        (items[x].id2==0xFE)||(items[x].id2==0xFF)))|| // Katana
      ((items[x].id1==0x14)&&
       ((items[x].id2==0x00)||(items[x].id2==0x01)|| // Kryss
        (items[x].id2==0x40)||(items[x].id2==0x41)))) // Cutlass
  {
   target(s, 0, 1, 0, 86, "What would you like to use that on ?");
   return;
  }
  if ((items[x].id1==0x0D)&&((items[x].id2==0xE1)||(items[x].id2==0xE2)))
  {
   if(checkskill(currchar[s],CAMPING, 0, 500))
   {
    c=SpawnItem(s,1,"#",0,0x0D,0xE3,0,0,0,0);
    items[c].type=45;
    items[c].dir=2;
    if (items[x].cont1==255 && items[x].cont2==255 && items[x].cont3==255 && items[x].cont4==255)
    {
      items[c].x=items[x].x;
      items[c].y=items[x].y;
      items[c].z=items[x].z;
    }
    else
    {
      items[c].x=chars[currchar[s]].x;
      items[c].y=chars[currchar[s]].y;
      items[c].z=chars[currchar[s]].z;
    }
    items[c].priv=items[c].priv|1;
    items[c].decaytime=(getclock()+(server_data.decaytimer*CLOCKS_PER_SEC));
    for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
    deleitem(x);
    }else
    {
     sysmessage(s, "You fail to light a fire.");
    }
    return;
  }
  if ((items[x].id1==0x15)&&((items[x].id2==0x08)))
  {
   if(checkskill(currchar[s],ITEMID, 0, 10))
   {
     items[x].id1=0x15;
     items[x].id2=0x09;
     items[x].type=45;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,x);
    }else
    {
     sysmessage(s, "You failed to use this statue.");
    }
    return;
  }
  if ((items[x].id1==0x15)&&((items[x].id2==0x09)))
  {
   if(checkskill(currchar[s],ITEMID, 0, 10))
   {
     items[x].id1=0x15;
     items[x].id2=0x08;
     items[x].type=45;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,x);
    }else
    {
     sysmessage(s, "You failed to use this statue.");
    }
    return;
  }
  if ((items[x].id1==0x12)&&((items[x].id2==0x30)||(items[x].id2==0x46)))
  { //giullotines (sp?)
   if(checkskill(currchar[s],ITEMID, 0, 10))
   {
     items[x].id1=0x12;
     items[x].id2=0x45;
     items[x].type=45;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,x);
    }else
    {
     sysmessage(s, "You failed to use this.");
    }  
    return;
  }
  if ((items[x].id1==0x12)&&((items[x].id2==0x45)))
  { // Guiotine(sp) stop animation
   if(checkskill(currchar[s],ITEMID, 0, 10))
   {
     items[x].id1=0x12;
     items[x].id2=0x30;
     items[x].type=45;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,x);
    }else
    {
     sysmessage(s, "You failed to use this.");
    }
    return;
  }
  if ((items[x].id1==0x10)&&((items[x].id2==0x39)))  //closed flour sack
  {
   if(checkskill(currchar[s],ITEMID, 0, 10))
   {
     items[x].id1=0x10;
     items[x].id2=0x3A;
     items[x].type=45;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,x);
    }else
    {
     sysmessage(s, "You failed to use this.");
    }
    return;
  }
  if ((items[x].id1==0x10)&&((items[x].id2==0x3A))) //open flour sack
  {
   if(checkskill(currchar[s],ITEMID, 0, 10))
   {
     items[x].id1=0x10;
     items[x].id2=0x39;
     items[x].type=45;
     for (k=0;k<now;k++) if (perm[k]) senditem(k,x);
    }else
    {
     sysmessage(s, "You failed to use this.");
    }
    return;
  }
  if ((items[x].id1==0x0D)&&((items[x].id2==0xBF)||(items[x].id2==0xC0)))
  {
   target(s, 0, 1, 0, 45, "Fish where?");
   return;
  }
  if ((items[x].id1==0x10)&&((items[x].id2==0x4b)||(items[x].id2==0x4c)||(items[x].id2==0x86)))  //Clock and bracelet
  {
   telltime(s);
   return;
  }
  if (items[x].id1==0x0E && items[x].id2==0x9B) // Mortar for Alchemy
  {
   if (items[x].type==17)
   {
    addid1[s]=items[x].ser1;
    addid2[s]=items[x].ser2;
    addid3[s]=items[x].ser3;
    addid4[s]=items[x].ser4;
    target(s, 0, 1, 0, 109, "Where is an empty bottle for your potion?");
   }
   else
   {
    addid1[s]=items[x].ser1;
    addid2[s]=items[x].ser2;
    addid3[s]=items[x].ser3;
    addid4[s]=items[x].ser4;
    target(s, 0, 1, 0, 108, "What do you wish to grind with your mortar and pestle?");
   }
   return;
  }
    if ((items[x].id1==0x0F) && ((items[x].id2==0x9E) || (items[x].id2==0x9F)))
  {
   target(s, 0, 1, 0, 128, "What cloth should I use these scissors on?");
   return;
  }
    if ((items[x].id1==0x0E) && (items[x].id2==0x21))
  {
   npcshape[0]=x;
   target(s, 0, 1, 0, 130, "Who will you use the bandages on?");
   return;
  }
  if ((items[x].id1==0x10)&&((items[x].id2==0x57)||(items[x].id2==0x58)))   //Sextents
  {
   sprintf(temp, "You are at: %i East, %i South",chars[currchar[s]].x,chars[currchar[s]].y);
   sysmessage(s, temp);
   return;
  }
  if ((items[x].id1==0x0E)&&((items[x].id2==0x27)||(items[x].id2==0xFF)))   //Hair Dye
  {
   usehairdye(s, x);
   return;
  }
  //if ((items[x].id1==0x0E)&&((items[x].id2==0xDD)||(items[x].id2==0xDE)))   //Townstones
  if (items[x].type==35)
  {
   townmenu(s, x, 3);
   return;
  }
  if ((items[x].id1==0x14)&&((items[x].id2>=0xFB)&&(items[x].id2<=0xFE)))
  {
   addmitem[s]=x;
   target(s, 0, 1, 0, 162, "What lock would you like to pick?");
   return;
  }
  if (((items[x].id1==0x0C)&&   
      ((items[x].id2==0x4f)||(items[x].id2==0x50)||(items[x].id2==0x51)||
       (items[x].id2==0x52)||(items[x].id2==0x53)||(items[x].id2==0x54)))) //cotton plants
  {
    if (!chars[s].onhorse) action(s,0x0D);
    else action(s,0x1d);
    soundeffect(s,0x01,0x3E);
    c=SpawnItem(s,1,"#",1,0x0D,0xF9,0,0,1,1);
    setserial(c,packitem(currchar[s]), 1);
    items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01;
    sysmessage(s, "You reach down and pick some cotton.");
    return;
  }
  if ((items[x].id1==0x10)&&(items[x].id2==0x5B)||(items[x].id2==0x5C)||
          (items[x].id1==0x10)&&(items[x].id2==0x53)||(items[x].id2==0x54)) //tinker axle
  {
          target(s, 0, 1, 0, 183, "Select part to combine the it with.");
          deleitem(x);
          return;
  }
  if ((items[x].id1==0x10)&&(items[x].id2==0x51)||
      (items[x].id2==0x52)||
          (items[x].id2==0x55)||
      (items[x].id2==0x56)||
          (items[x].id2==0x5D)||
      (items[x].id2==0x5E))  
  {
          itemmake[s].materialid1=items[x].id1;
          itemmake[s].materialid2=items[x].id2;
          target(s, 0, 1, 0, 184, "Select part to combine it with.");
          return;
  }
  if ((items[x].id1==0x10)&&(items[x].id2==0x4F)||(items[x].id2==0x50)||
          (items[x].id1==0x10)&&(items[x].id2==0x4D)||(items[x].id2==0x4E)) //tinker clock
  {
          target(s, 0, 1, 0, 185, "select clock frame to combine with");
          deleitem(x);
          return;
  }
  if ((items[x].id1==0x10)&&(items[x].id2==0x59)||(items[x].id2==0x5A))//tinker sextant
  {
   if(checkskill(currchar[s],TINKERING, 0, 1000))
   {
   sysmessage(s, "You create the sextant.");
   sprintf(temp,"a sextant");
   c=SpawnItem(s,1,temp,0,0x10,0x57,0,0,1,1);
     setserial(c,packitem(currchar[s]), 1);
   items[chars[currchar[s]].tailitem].priv=items[chars[currchar[s]].tailitem].priv|0x01;
   deleitem(x);
   }else
   sysmessage(s, "you fail to create the sextant.");
   return;
  }

  if ((items[x].id1==0x10) && ((items[x].id2==0x70) || (items[x].id2==0x74)))
  {
    if (iteminrange(s,x,1))  
        tdummy(s);
    else
    sysmessage(s, "You need to be closer to use that.");
    return;
  }
  if ((items[x].id1==0x10) && ((items[x].id2==0x71) || (items[x].id2==0x75)))
  {
     sysmessage(s, "You must wait for it to stop swinging !");
     return;
  }
  if ((items[x].id1==0x1E)&&(items[x].id2==0xBC)) //tinker's tools
  {
   target(s, 0, 1, 0, 180, "Select material to use.");
   return;
  }
   if (items[x].type==103) //Army enlistment
  {    
    enlist(s, items[x].morex);
    deleitem(x);
    return;
  }
  if (items[x].type==104) // Teleport object
  {
    chars[currchar[s]].x=items[x].morex;
    chars[currchar[s]].y=items[x].morey;
    chars[currchar[s]].z=chars[currchar[s]].dispz=items[x].morez;
    teleport(currchar[s]);
    return;
  }
  if (items[x].type==105)  // For drinking
  {
   int drinksnd;
   drinksnd=rand()%2;      
    switch(drinksnd)
    {
       case 0: soundeffect2(currchar[s], 0x00, 0x31);
               break;
       case 1: soundeffect2(currchar[s], 0x00, 0x30);
               break;       
    }   
   
     int j;
     //Remove a drink
     if (items[x].amount!=1)
     {
        items[x].amount--;
        for (j=0;j<now;j++) if (perm[j] && inrange2(j,x)) senditem(j,x);
     }
     else
     {
        deleitem(x);
     }
    sysmessage(s,"You take a swig of your drink.");
    return;
  }  
  sysmessage(s, "You can't think of a way to use that item.");
 }
 }
 else sysmessage(s, "You must wait to perform another action.");
}

int receive(int s, int x, int a) // Old socket receive function (To be replaced soon)
{
 int i, count;
#ifdef DEBUG
  int j;
  int buf2c;
  char buf2[32];
#endif

 if (a) count=0; // Just to get rid of warning message
 do
 {
 count=recv(client[s], &buffer[s][recvcount], x-recvcount, 0);
 if (count>0)
 {
 for (i=recvcount;i<recvcount+count;i++) buffer[s][i]=crypt(s, buffer[s][i]);
 recvcount+=count;
#ifdef DEBUG
 buf2c=0;
 if (((recvcount==x)||(x==2560))&&(a))
 {
 printf("\n");
 for (i=0;i<recvcount;i++)
 {
  buf2[buf2c]=buffer[s][i];
  buf2c++;
  if ((buf2c==16)||(i==recvcount-1))
  {
   printf("C%i %2x : ",s,((i%256)/16)*16);
   for (j=0;j<buf2c;j++)
   {
    printf("%2x ",buf2[j]);
   }
   printf("[");
   for (j=0;j<buf2c;j++)
   {
    if ((isalnum(buf2[j]))||(isprint(buf2[j]))) printf("%c",buf2[j]); else printf(".");
   }
   buf2c=0;
   printf("]\n");
  }
 }
 }
#endif
 }
 }
 while ((x!=2560)&&(x!=recvcount)&&(count>0));
 return count;
}

void getmsg(int s) // Receive message from client
{
 int count, ho, mi, se, total, i, j, k, book,serial,serhash,ci;
 char nonuni[512];
 if (newclient[s])
 {
  count=recv(client[s], buffer[s], 4, 0);
  if ((buffer[s][0]=='\x21')&&(count<4)) // UOMon
  {
   total=(getclock()-starttime)/CLOCKS_PER_SEC;
   ho=total/3600;
   total-=ho*3600;
   mi=total/60;
   total-=mi*60;
   se=total;
   sprintf(monitor, "UOX3 LoginServer\r\nUOX3 Server: up for %ih %im %is\r\n",ho,mi,se);
   xsend(s, monitor, strlen(monitor), 0);
   newclient[s]=0;
  } else
  {
   clientip[s][0]=buffer[s][0];
   clientip[s][1]=buffer[s][1];
   clientip[s][2]=buffer[s][2];
   clientip[s][3]=buffer[s][3];
   gentable(s, buffer[s][0], buffer[s][1], buffer[s][2], buffer[s][3]); // Init encryption table
   newclient[s]=0;
   if ((buffer[s][0]==0x12)&&(buffer[s][1]==0x34)&&(buffer[s][2]==0x56)&&(buffer[s][3]==0x78))
    disconnect(s);
  }
 }
 else
 {
  recvcount=0;
  if (receive(s, 1, 0)>0)
  {
   switch(buffer[s][0])
    {
	case 0x01:// Main Menu on the character select screen
     disconnect(s);
     break;
    case 0x80:// First Login
     receive(s, 62, 1);
     login1(s);
     break;
    case 0xA0:// Server Select
     receive(s, 3, 1);
     relay(s);
     break;
    case 0x91:// Second Login
     receive(s, 65, 1);
     cryptclient[s]=1;
     charlist(s);
     break;
    case 0x83:// Character Delete
     receive(s, 0x27, 1);
     chardel(s);
     break;
    case 0x00:// Character Create
     receive(s, 100, 1);
     charcreate(s);
     break;
    case 0x5D:// Character Select
     receive(s, 0x49, 1);
     charplay(s);
     break;
    case 0x02:// Walk
     receive(s, 3, 1);
     walking(currchar[s], buffer[s][1], buffer[s][2]);
     break;
    case 0x73:// Keep alive
     receive(s, 2, 1);
     xsend(s, buffer[s], 2, 0);
     break;
    case 0x22:// Resync Request
     receive(s, 3, 1);
     teleport(currchar[s]);
     break;
    case 0x03:// Speech
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     chars[currchar[s]].unicode=0;
     if(chars[currchar[s]].making==998) //rename house sign
     {
      sprintf(items[addid1[s]].name,"%s",buffer[s]+8);
      chars[currchar[s]].making=0;
      addid1[s]=0;
     } else
     if(chars[currchar[s]].runenumb!=-1)
     {
      sprintf(items[chars[currchar[s]].runenumb].name,"Rune to %s",buffer[s]+8);
      sprintf(temp,"Rune renamed to: Rune to %s",buffer[s]+8);
      sysmessage(s,temp);
      chars[currchar[s]].runenumb=-1;
     } else
     if(chars[currchar[s]].pagegm==1)
     {
      int a1,a2,a3,a4;
      a1=chars[currchar[s]].ser1;
      a2=chars[currchar[s]].ser2;
      a3=chars[currchar[s]].ser3;
      a4=chars[currchar[s]].ser4;
      sprintf(gmpages[chars[currchar[s]].playercallnum].reason,"%s",buffer[s]+8);
      sprintf(temp, "GM Page from %s [%x %x %x %x]: %s",
      chars[currchar[s]].name, a1, a2, a3, a4, gmpages[chars[currchar[s]].playercallnum].reason);
      int x=0;
      for (i=0;i<now;i++)
       if (chars[currchar[i]].priv&0x20)
       {
        x=1;
        sysmessage(i, temp);
       }
      if (x==1)
      {
       sysmessage(s, "Available Game Masters have been notified of your request.");
      }
      else sysmessage(s, "There was no Game Master available to take your call.");
      chars[currchar[s]].pagegm=0;
     } else
     if (chars[currchar[s]].pagegm==2) //Counselor page
     {
      int a1,a2,a3,a4;
      a1=chars[currchar[s]].ser1;
      a2=chars[currchar[s]].ser2;
      a3=chars[currchar[s]].ser3;
      a4=chars[currchar[s]].ser4;
      sprintf(counspages[chars[currchar[s]].playercallnum].reason,"%s",buffer[s]+8);
      sprintf(temp, "Counselor Page from %s [%x %x %x %x]: %s",
      chars[currchar[s]].name, a1, a2, a3, a4, counspages[chars[currchar[s]].playercallnum].reason);
      int x=0;
      for (i=0;i<now;i++)
       if (chars[currchar[i]].priv&0x20)
       {
        x=1;
        sysmessage(i, temp);
       }
      if (x==1)
      {
       sysmessage(s, "Available Counselors have been notified of your request.");
      }
      else sysmessage(s, "There was no Counselor available to take your call.");
      chars[currchar[s]].pagegm=0;
     }
     else talking(s);
     break;
    case 0xAD: // Unicode Speech
     receive(s, 3, 0);
     receive(s, ((buffer[s][1]*256)+buffer[s][2]), 1);
     chars[currchar[s]].unicode=1;
     for (i=13;i<(buffer[s][1]*256)+buffer[s][2];i=i+2)
     {
       nonuni[(i-13)/2]=buffer[s][i];
     } 
     if(chars[currchar[s]].making==998) //rename house sign
     {
      sprintf(items[addid1[s]].name,"%s",nonuni);
      chars[currchar[s]].making=0;
      addid1[s]=0;
     } else
     if(chars[currchar[s]].runenumb!=-1)
     {
      sprintf(items[chars[currchar[s]].runenumb].name,"Rune to %s",nonuni);
      sprintf(temp,"Rune renamed to: Rune to %s",nonuni);
      sysmessage(s,temp);
      chars[currchar[s]].runenumb=-1;
     } else
     if(chars[currchar[s]].pagegm==1)
     {
      int a1,a2,a3,a4;
      a1=chars[currchar[s]].ser1;
      a2=chars[currchar[s]].ser2;
      a3=chars[currchar[s]].ser3;
      a4=chars[currchar[s]].ser4;
      sprintf(gmpages[chars[currchar[s]].playercallnum].reason,"%s",nonuni);
      sprintf(temp, "GM Page from %s [%x %x %x %x]: %s",
      chars[currchar[s]].name, a1, a2, a3, a4, gmpages[chars[currchar[s]].playercallnum].reason);
      int x=0;
      for (i=0;i<now;i++)
       if (chars[currchar[i]].priv&0x20)
       {
        x=1;
        sysmessage(i, temp);
       }
      if (x==1)
      {
       sysmessage(s, "Available Game Masters have been notified of your request.");
      }
      else sysmessage(s, "There was no Game Master available to take your call.");
      chars[currchar[s]].pagegm=0;
     } else
     if (chars[currchar[s]].pagegm==2) //Counselor page
     {
      int a1,a2,a3,a4;
      a1=chars[currchar[s]].ser1;
      a2=chars[currchar[s]].ser2;
      a3=chars[currchar[s]].ser3;
      a4=chars[currchar[s]].ser4;
      sprintf(counspages[chars[currchar[s]].playercallnum].reason,"%s",nonuni);
      sprintf(temp, "Counselor Page from %s [%x %x %x %x]: %s",
      chars[currchar[s]].name, a1, a2, a3, a4, counspages[chars[currchar[s]].playercallnum].reason);
      int x=0;
      for (i=0;i<now;i++)
       if (chars[currchar[i]].priv&0x20)
       {
        x=1;
        sysmessage(i, temp);
       }
      if (x==1)
      {
       sysmessage(s, "Available Counselors have been notified of your request.");
      }
      else sysmessage(s, "There was no Counselor available to take your call.");
      chars[currchar[s]].pagegm=0;
     }
     else
     unicodetalking(s);
     break;    
    case 0x06:// Doubleclick
     receive(s, 5, 1);
     doubleclick(s);
     break;
    case 0x09:// Singleclick
     receive(s, 5, 1);
     singleclick(s);
     break;
    case 0x6C:// Targeting
     receive(s, 19, 1);
     if(targetok[s]) multitarget(s);
     break;
    case 0x13:// Equip Item
     receive(s, 10, 1);
     wear_item(s);
     break;
    case 0x07:// Get Item
     receive(s, 7, 1);
     get_item(s);
     break;
    case 0x08:// Drop Item
     receive(s, 14, 1);
     if ( (buffer[s][10]>=0x40) && (buffer[s][10]!=0xff) )
                 pack_item(s);
     else 
                 dump_item(s);
     break;
    case 0x72:// Combat Mode
     receive(s, 5, 1);
     chars[currchar[s]].war=buffer[s][1];
     chars[currchar[s]].targ=-1;
     xsend(s, buffer[s], 5, 0);
     walking2(currchar[s]);
     dosocketmidi(s);
     break;
    case 0x12:// Ext. Command
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     if (buffer[s][3]=='\xC7') // Action
     {
      if (!(strcmp(&buffer[s][4],"bow"))) action(s, 0x20);
      if (!(strcmp(&buffer[s][4],"salute"))) action(s, 0x21);
     } else
     if (buffer[s][3]=='\x24') // Skill
     {
      i=4;
      while (buffer[s][i]!=' ') i++;
      buffer[s][i]=0;
      skilluse(s, str2num(&buffer[s][4]));
     } else
     if ((buffer[s][3]=='\x27')||(buffer[s][3]=='\x56'))  // Spell
     {
      j=0;
      k=packitem(currchar[s]);
      serial=items[k].serial;
      serhash=serial%256;
      for (i=0;i<contsp[serhash].max;i++)
      {
        ci=contsp[serhash].pointer[i];
        if ((items[ci].contserial==serial) && (items[ci].type==9))
        {
          j=ci;
          break;
        }
      }
      if (j==0)
      {
        serial=chars[currchar[s]].serial;
        serhash=serial%256;
        for (i=0;i<contsp[serhash].max;i++)
        {
          ci=contsp[serhash].pointer[i];
          if ((items[ci].contserial==serial) && (items[ci].layer==1)) j=ci;
        }
      }
      if (j!=0)
      {
        book=buffer[s][4]-0x30;
        if (buffer[s][5]>0x20) book=(book*10)+(buffer[s][5]-0x30);
      }

      if (j!=0 && checkBook(((book-1)/8)+1, (book-1)%8, j))
         if (chars[s].priv2&2) sysmessage(s, "You cannot cast spells while frozen.");
         else castspell(s, book, 0, 0);
      else sysmessage(s, "You don't have that spell.");
     } else
     if ((buffer[s][2]=='\x05')&&(buffer[s][3]=='\x43'))  // Open spell book
     {
      spellbook(s);
     }
     break;
    case 0x9B:// GM Page
     receive(s, 0x102, 1);
     gmmenu(s, 1);
     break;
    case 0x7D:// Choice
     receive(s, 13, 1);
     choice(s);
     break;
    case 0x95:// Color Select
     receive(s, 9, 1);
     dyeitem(s);
     break;
    case 0x34:// Status Request
     receive(s, 10, 1);
     srequest(s);
     break;
    case 0x75:// Rename Character
     receive(s, 0x23, 1);
     for(i=0;i<charcount;i++)
      if((buffer[s][1]==chars[i].ser1)&&(buffer[s][2]==chars[i].ser2)&&
        (buffer[s][3]==chars[i].ser3)&&(buffer[s][4]==chars[i].ser4))
        {
         strncpy(chars[i].name, &buffer[s][5], 50);
        }
     break;
    case 0x66:// Read Book
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     serial=calcserial(buffer[s][3],buffer[s][4],buffer[s][5],buffer[s][6]);
     i=findbyserial(&itemsp[serial%256], serial, 0);
     if (i!=-1)
     {
        readbook(s, i, (buffer[s][9]*256)+buffer[s][10]);
        return;
     }
     break;
    case 0xA7:// Get Tip
     receive(s, 4, 1);
     tips(s, (buffer[s][1]*256)+buffer[s][2]+1);
     break;
    case 0xA4:// Spy
     receive(s, 0x95, 1);
     break;
    case 0x05:// Attack
     receive(s, 5, 1);
     if(chars[currchar[s]].dead==0)
     {
      chars[currchar[s]].targ=calcCharFromSer(buffer[s][1], buffer[s][2], buffer[s][3], buffer[s][4]);
      if((chars[currchar[s]].hidden)&&(!(chars[currchar[s]].priv2&8)))
      {
       chars[currchar[s]].hidden=0;
       updatechar(currchar[s]);
      }
      for (i=0;i<charcount;i++)
      if((chars[i].ser1==buffer[s][1])&&(chars[i].ser2==buffer[s][2])&&
         (chars[i].ser3==buffer[s][3])&&(chars[i].ser4==buffer[s][4]))
      {
       if(chars[i].dead==1)
       {
        sysmessage(s,"That person is already dead!");
        return;
       }
       sprintf(temp, "* You see %s attacking %s *", chars[currchar[s]].name, chars[i].name);

      // Dupois pointed out the for loop was changing i which would drive stuff nuts later
       for (j=0;j<now;j++)
       {
         if((inrange1(s, j) && perm[j]) && (s!=j))
         {
           chars[i].emotecolor1=0x00;
           chars[i].emotecolor2=0x26;
           //npcemoteall(i,temp);
					 npcemote(j, i, temp);
         }
       }
       if (!(chars[i].npcaitype==0x40)||(!(chars[i].targ==-1)))
        {
        chars[i].attacker=currchar[s];
        chars[i].attackfirst=0;
        }
       chars[currchar[s]].attackfirst=1;
       chars[currchar[s]].attacker=i;

       // Teleporting Guards code 
       if ((region[chars[i].region].priv&0x01 == 1) &&
           (!(chars[currchar[s]].npc) || (chars[currchar[s]].npc) && (chars[currchar[s]].npcaitype==2)) &&
           (server_data.guardsactive))
       {
        //Dupois - Added to only summon guards if attacking a NPC with NPCAITYPE=0 AND TITLE=0 (Animals)
        //Added Oct 29, 1998
        //printf("UOX3: %s is attacking %s in a guarded region servDat.animGuard=%d\n", chars[currchar[s]].name, chars[i].name, server_data.animals_guarded);
        if (server_data.animals_guarded==1)
         spawnguard(currchar[s], s, chars[currchar[s]].x+2, chars[currchar[s]].y, chars[currchar[s]].z);
        else
        {
         if ((chars[i].npcaitype>0)||(strlen(chars[i].title)>0))
         {
          //printf("UOX3: %s is attacking a guarded creature and must be destroyed!\n", chars[currchar[s]].name);
          spawnguard(currchar[s], s, chars[currchar[s]].x+2, chars[currchar[s]].y, chars[currchar[s]].z);
          //printf("UOX3: Guards have been dispatched to kill %s!\n", chars[currchar[s]].name);
         }
        }
       }
     if ((chars[i].npc)&&!(chars[i].npcaitype==0x40))
       {
        if (!(chars[i].war)) npcToggleCombat(i);
        chars[i].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
       }
       break;
      }
     }
     else sysmessage(s,"You are dead and cannot do that.");
     break;
    case 0xB1:// Gumpmenu choice
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     gumpbutton(s, buffer[s][14], buffer[s][3], buffer[s][4], buffer[s][5], buffer[s][6], buffer[s][10]);
     break;
    case 0xAC:// Textentry input
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     gumpinput(s);
     break;
    case 0x2C:// Resurrect menu choice
     receive(s, 2, 0);
     if(buffer[s][1]==0x02) sysmessage(s, "You are now a ghost.");
     if(buffer[s][1]==0x01) sysmessage(s, "The connection between your spirit and the world is too weak.");
     break;
    case 0x3B:// Buy from vendor...
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     buyaction(s);
     break;
    case 0x9F:// Sell to vendor...
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     sellaction(s);
     break;
    case 0x69:// Client text change
     receive(s, 3, 0);// What a STUPID message...  It would be useful if
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);// it included the color changed to, but it doesn't!
     break;
    case 0x6F:// Secure Trading message
     receive(s, 3, 0);
     receive(s, (buffer[s][1]*256)+buffer[s][2], 1);
     trademsg(s);
     break;
    case 0xB6:// T2A Popuphelp request
     receive(s, 9, 0);
     break;
    case 0xB8:// T2A Profile request
     receive(s, 8, 0);
     break;
    default:
     printf("Unknown message:%x\n", buffer[s][0]);
#ifdef DEBUG
printf("???\n");
#endif
     FD_ZERO(&all);
     FD_SET(client[s],&all);
     nfds=client[s]+1;
     if (select(nfds, &all, NULL, NULL, &uoxtimeout)>0)
     {
//    recvcount=0;
      receive(s, 2560, 1);
      }
     break;
    }
  }
  else
  {
   disconnect(s);
  }
 }
}

void sockinit() // Initialize sockets
{
 int i;
 char h1=0, h2=0, h3=0, h4=0;
 int bcode;
 int on=1, off=0;

#ifdef __NT__
 wVersionRequested=0x0101;
 err=WSAStartup(wVersionRequested, &wsaData);
 if (err)
 {
  printf("ERROR: Winsock 1.1 not found...\n");
  keeprun=0;
  error=1;
  return;
 }
#endif

 a_socket=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 if (a_socket<0)
 {
  printf("ERROR: Unable to create socket\n");
  keeprun=0;
  error=1;
  return;
 }
#ifndef __NT__
 setsockopt(a_socket, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));
#endif
/* gethostname(hname,40);
 he=gethostbyname(hname);
 conns=0;
 if (he==NULL)
 {
  printf("NOTE: No available connections. Using loopback adress for offline operation.\n");
  printf("      Remember that this may cause client crashes on startup. Read the readme!.txt\n");
  printf("      chapter 'Setup Instructions' on information about how to solve this.");
  h1=127;
  h2=0;
  h3=0;
  h4=1;
 }
 else
 {
  do
  {
   p=(*he).h_addr_list[conns];
   if (p!=NULL) conns++;
  }
  while (p!=NULL);
  if (conns==0)
  {
   printf("NOTE: No available connections. Using loopback adress for offline operation.");
   h1=127;
   h2=0;
   h3=0;
   h4=1;
  }
  else if (conns==1)
  {
   printf("NOTE: Available connection found.");
   h1=(*he).h_addr_list[0][0];
   h2=(*he).h_addr_list[0][1];
   h3=(*he).h_addr_list[0][2];
   h4=(*he).h_addr_list[0][3];
  }
  else
  {
   printf("NOTE: Multiple available connections found.\n");
   printf("IP adresses:\n");
   for (i=0;i<conns;i++)
   {
    printf("%i : %i.%i.%i.%i\n",i+1,(*he).h_addr_list[i][0],(*he).h_addr_list[i][1],
                                    (*he).h_addr_list[i][2],(*he).h_addr_list[i][3]);
   }
   printf("\n");
   do
   {
    printf("Choose connection number (1-%i): ",conns);
         scanf("%i",&number);
    number--;
   }
   while ((number<0)||(number>conns-1));
   h1=(*he).h_addr_list[number][0];
   h2=(*he).h_addr_list[number][1];
   h3=(*he).h_addr_list[number][2];
   h4=(*he).h_addr_list[number][3];
  }
 }
 sprintf(ipa,"%i.%i.%i.%i",h1,h2,h3,h4); */
 len_connection_addr=sizeof (struct sockaddr_in);
 connection.sin_family=AF_INET;
// connection.sin_addr.s_addr=inet_addr(ipa);
 connection.sin_addr.s_addr=INADDR_ANY;
//  connection.sin_port=htons(UOX_PORT);
 connection.sin_port=((UOX_PORT%256)*256)+(UOX_PORT/256);
 bcode=bind(a_socket, (struct sockaddr *)&connection, len_connection_addr);
 if (bcode<0)
 {
  printf("ERROR: Unable to bind socket 1 - Error code: %i\n",bcode);
  keeprun=0;
  error=1;
  return;
 }
 listen(a_socket, 42);
// printf("\nUOX3: Listening on connection (%i.%i.%i.%i:%i)\n",h1,h2,h3,h4,UOX_PORT);
 login03[1]=h1;
 login03[2]=h2;
 login03[3]=h3;
 login03[4]=h4;
 login03[7]=h1;
 login03[8]=h2;
 login03[9]=h3;
 login03[10]=h4;
 for (i=0;i<servcount;i++) if (serv[i][1][0]=='*') sprintf(serv[i][1],"%i.%i.%i.%i",h1,h2,h3,h4);
 ph1=h1;
 ph2=h2;
 ph3=h3;
 ph4=h4;
}

void sockclose () // Close all sockets for shutdown
{
 int i;
 closesocket(a_socket);
 for (i=0;i<now;i++) closesocket(client[i]);
}

void checkconn() // Check for connection requests
{
 int s;
 int len;

 if (now<MAXIMUM)
 {
  FD_ZERO(&conn);
  FD_SET(a_socket, &conn);
  nfds=a_socket+1;
  s=select(nfds, &conn, NULL, NULL, &uoxtimeout);
  if (s>0)
  {
        len=sizeof (struct sockaddr_in);
//   printf("Waiting at accept()\n");
   client[now]=accept(a_socket, (struct sockaddr *)&client_addr, &len);
//   printf("Done! :)\n");
   if (client[now]<0)
   {
    printf("ERROR: Error at client connection!\n");
    error=1;
    keeprun=0;
    return;
   }
   server[now]=-1;
   newclient[now]=1;
   acctno[now]=-1;
   addid1[now]=0;
   addid2[now]=0;
   addid3[now]=0;
   addid4[now]=0;
   perm[now]=0;
   funnypack[now]=0;
   binlength[now]=0;
   boutlength[now]=0;
   cryptclient[now]=0;
   cryptmask[now][0]=0;
   cryptmask[now][1]=0;
   usedfree[now]=0;
   walksequence[now]=-1;
#ifdef __NT__
   printf("UOX3: Client %i [%i.%i.%i.%i] connected [Total:%i].\n",now,client_addr.sin_addr.S_un.S_un_b.s_b1 _ client_addr.sin_addr.S_un.S_un_b.s_b2 _ client_addr.sin_addr.S_un.S_un_b.s_b3 _ client_addr.sin_addr.S_un.S_un_b.s_b4,now+1);
#else
   printf("UOX3: Client %i connected [Total:%i].\n",now,now+1);
#endif
   now++;
   return;
  }
  if (s<0)
  {
   printf("ERROR: Select (Conn) failed!\n");
   keeprun=0;
   error=1;
   return;
  }
 }
}

void checkmessage () // Check for messages from the clients
{
 int s, i, oldnow;

 FD_ZERO(&all);
 FD_ZERO(&errsock);
 nfds=0;
 for (i=0;i<now;i++)
 {
  FD_SET(client[i],&all);
  FD_SET(client[i],&errsock);
  if (client[i]+1>nfds) nfds=client[i]+1;
  if (server[i]>=0)
  {
   FD_SET(server[i],&all);
   FD_SET(server[i],&errsock);
   if (server[i]+1>nfds) nfds=server[i]+1;
  }
 }
 s=select(nfds, &all, NULL, &errsock, &uoxtimeout);
 if (s>0)
 {
  oldnow=now;
  for (i=0;i<now;i++)
  {
   if (FD_ISSET(client[i],&errsock))
   {
         disconnect(i);
   }
   if (server[i] >= 0) {
    if (FD_ISSET(server[i],&errsock))
    {
     closesocket(server[i]);
     failauth(i);
    }
   }
   if ((FD_ISSET(client[i],&all))&&(oldnow==now))
   {
    getmsg(i);
    if (executebatch) batchcheck(i);
   }
   if (server[i] >= 0)
   {
    if ((FD_ISSET(server[i],&all))&&(oldnow==now))
    {
     authtest(i);
    }
   }
  }
 }
/* if (s<0)
 {
  printf("ERROR: Select (Mess) failed!\n");
  keeprun=0;
  error=1;
  return;
 } */
}

//o----------------------------------------------------------------------------o
//|   Function -  void checkkey()
//|   Date     -  Unknown
//|   Programmer  -  Unknown  (Touched up by EviLDeD)
//o----------------------------------------------------------------------------o
//|   Purpose     -  Facilitate console control. SysOp keys, and localhost 
//|               controls.
//o----------------------------------------------------------------------------o
#ifdef __NT__
void checkkey ()
{
   char c;
    int i;
    int lookfor;

   if (kbhit())
   {
      c=toupper(getch());
      if (c=='S')
      {
         if (secure)
         {
            printf("UOX3: Secure mode disabled.\n");
            secure=0;
         }
         else
         {
            printf("UOX3: Secure mode re-enabled.\n");
            secure=1;
         }
      } 
      else
         if (secure==1)
         {
            printf("NOTE: Secure mode prevents keyboard commands!\n");
            return;
         }
         switch(c)
         {
            case '\x1B':
               printf("UOX3: Immediate Shutdown initialized!\n");
               if(heartbeat) Writeslot("shutdown");
               keeprun=0;
               break;
            case 'Q':
               printf("UOX3: Immediate Shutdown initialized!\n");
               if(heartbeat) Writeslot("shutdown");
               keeprun=0;
               break;
            case 'T':
               endtime=getclock()+(CLOCKS_PER_SEC*600);
               endmessage();
               break;
            case '#':
               cwmWorldState.savenewworld(1);
               saveserverscript(1);
               break;
            case 'L':
               if (showlayer)
               {
                  printf("UOX3: Layer display disabled.\n");
                  showlayer=0;
               }
               else
               {
                  printf("UOX3: Layer display enabled.\n");
                  showlayer=1;
               }
               break;
            case 'I':
               readini();
               //  for (i=0;i<servcount;i++)
               //  if (serv[i][1][0]=='*') sprintf(serv[i][1],"%i.%i.%i.%i",ph1,ph2,ph3,ph4);
               printf("UOX3: INI file reloaded.\n");
               break;
            case  'D':    // Disconnect account 0 (useful when client crashes)
               for (i=0;i<now;i++)
                  if (acctno[i]==0) disconnect(i);
               break;
            case '1':
               sysbroadcast("ATTENTION PLAYERS!!! SERVER BEING BROUGHT DOWN!");
               printf("ATTENTION PLAYERS!!! SERVER BEING BROUGHT DOWN!\n");
               break;
            case '2':
               sysbroadcast("BROADCAST MESSAGE 2");
               printf("BROADCAST MESSAGE 2\n");
               break;
            case 'H':                // Enable/Disable heartbeat
               if (heartbeat==1) printf("UOX3: Heartbeat Disabled\n");
               else printf("UOX3: Heartbeat Enabled\n");
               heartbeat = !heartbeat;
               break;
            case 'P':                // Display profiling information
               LogMessage("Performace Dump:\n");
               LogMessage("Network code: %fmsec [%i samples]\n" _ (float)((float)networkTime/(float)networkTimeCount) _ networkTimeCount);
               LogMessage("Timer code: %fmsec [%i samples]\n" _ (float)((float)timerTime/(float)timerTimeCount) _ timerTimeCount);
               LogMessage("Auto code: %fmsec [%i samples]\n" _ (float)((float)autoTime/(float)autoTimeCount) _ autoTimeCount);
               LogMessage("Loop Time: %fmsec [%i samples]\n" _ (float)((float)loopTime/(float)loopTimeCount) _ loopTimeCount);
               LogMessage("Simulation Cycles: %f per sec\n" _ (1000.0*(1.0/(float)((float)loopTime/(float)loopTimeCount))));
               break;
            case 'W':                // Display logged in chars
							{int j=0;
								printf("Current Users in the World:\n");
								for (unsigned int i=0;i<now;i++)
								{
									if(perm[i]) //Keeps NPC's from appearing on the list
									{
										j++;
										printf("%i) %s [%x %x %x %x]\n", (j-1), chars[currchar[i]].name, chars[currchar[i]].ser1, chars[currchar[i]].ser2, chars[currchar[i]].ser3, chars[currchar[i]].ser4);
									}
								}
								printf("Total Users Online: %d\n", j);
							}
               break;
            case 'A': //reload the accounts file
               loadaccounts();
               break;
         }
   }
}
#endif

void checktimers() // Check shutdown timers
{
 int tclock=getclock();
 if (lclock>tclock) overflow=1;
 else overflow=0;
 if (endtime)
 {
  if (endtime<=tclock) keeprun=0;
 }
 lclock=tclock;
}

void checkauto() // Check automatic/timer controlled stuff (Like fighting and regeneration)
{
 int x, pcalc, timer;
 char zbuf[10];
 unsigned int i,currenttime=getclock(); //\/ getclock only once
 char t[120];

 if ((heartbeat)&&(hbu>5))
 {
  sprintf(zbuf,"%d",saveinterval-5);//printf(zbuf);
  Writeslot(zbuf);hbu=0;
 }
 if (wtype!=0)
 {
  if (resendweathertime<=currenttime||(overflow))
  {
   for (i=0;i<now;i++) weather(i);
   resendweathertime=currenttime+(40*CLOCKS_PER_SEC);
  }
 }
 if (shoprestocktime<currenttime||(overflow))
 {
  restock(0);
  shoprestocktime=currenttime+(shoprestockrate*60*CLOCKS_PER_SEC);
 }
 if (saveinterval != 0)
 {
  if (autosaved == 0)
  {
   autosaved = 1;
   time(&oldtime);
  }
  time(&newtime);
  if (difftime(newtime, oldtime)>=saveinterval)
  {
   autosaved = 0;
   cwmWorldState.savenewworld(0);
   //savenewworld(0);
   saveserverscript(0);
  }
 }

//Time functions
 if (uotickcount<=currenttime||(overflow))
 {
  if (minute < 59) {minute++;hbu++;}
  else
  {
   minute=0;
   if (hour < 12) hour++;
   else
   {
    hour = 1;
    ampm = !ampm;
    if (!ampm) day++;
   }
  }
  uotickcount=currenttime+secondsperuominute*CLOCKS_PER_SEC;
  if (minute%8==0)
    moon1=(moon1+1)%8;
  if (minute%3==0)
    moon2=(moon2+1)%8;
 }

 doworldlight();  //Changes lighting, if it is currently time to.

 for (i=0;i<charcount;i++)
 {
  if (!chars[i].free) //bud
   {
   if ((chars[i].disabled!=0)&&((chars[i].disabled<=currenttime)||(overflow)))
   {
     chars[i].disabled=0;
   }
   if (chars[i].summontimer<=currenttime||(overflow))
    {
    if(chars[i].summontimer>0)
     {
     soundeffect(i, 0x01, 0xFE);
     chars[i].dead=1;
     deletechar(i);
     i++;
    }
   }
  }
  if(server_data.bg_sounds>=1)
    {
    if(server_data.bg_sounds>10) server_data.bg_sounds=10;
    timer=server_data.bg_sounds*100;
    if((online(i))&&(!(chars[i].npc))&&(!(chars[i].dead))&&((rand()%(timer))==(timer/2))) bgsound(calcSocketFromChar(i));
    }

  // flee code
  if (chars[i].npc) //;
  {
   if ((chars[i].fleeat==0)) chars[i].fleeat=NPC_BASE_FLEEAT;
   if ((chars[i].reattackat==0)) chars[i].reattackat=NPC_BASE_REATTACKAT;
  }
  if ((chars[i].npc)&&
          !(chars[i].npcWander==5)&&
          (chars[i].hp<chars[i].st*chars[i].fleeat/100))
  {
   chars[i].oldnpcWander=chars[i].npcWander;
   chars[i].npcWander=5;
   chars[i].npcmovetime=(int)(currenttime+(NPCSPEED*CLOCKS_PER_SEC));
  }

  if ((chars[i].npc)&&
          (chars[i].npcWander==5)&&
          (chars[i].hp>chars[i].st*chars[i].reattackat/100))
  {
   chars[i].npcWander=chars[i].oldnpcWander;
   chars[i].npcmovetime=(int)(currenttime+(NPCSPEED*CLOCKS_PER_SEC));
   chars[i].oldnpcWander=0; // so it won't save this at the wsc file
  }
  // end of flee code

  if (!(chars[i].dead))
  {
   if (chars[i].hp>chars[i].st)
   {
    chars[i].hp=chars[i].st;
    updatestats(i, 0);
   }
   if (chars[i].stm>chars[i].dx)
   {
    chars[i].stm=chars[i].dx;
    updatestats(i, 2);
   }
   if (chars[i].mn>chars[i].in)
   {
    chars[i].mn=chars[i].in;
    updatestats(i, 1);
   }
   if ((hungerdamagetimer<=currenttime)||(overflow)) // Damage them if they are very hungry
   {
    hungerdamagetimer=currenttime+(server_data.hungerdamagerate*CLOCKS_PER_SEC);
    if (chars[i].hp>0 && chars[i].hunger<3 && server_data.hungerdamage && !(chars[i].priv&0x80))
    {     
     chars[i].hp=chars[i].hp-server_data.hungerdamage;
     updatestats(i, 0);
      if(chars[i].hp<=0)
      { 
        sysmessage(calcSocketFromChar(i),"You have died of starvation");
        deathstuff(i);
      }
    }
   }
   if ((chars[i].regen<=currenttime)||(overflow))
   {
    chars[i].regen=currenttime+(server_data.hitpointrate*CLOCKS_PER_SEC);
    if (chars[i].hp<chars[i].st && chars[i].hunger>3 || server_data.hungerrate==0)
    {
     if (chars[i].skill[17]<500) chars[i].hp++;
     else if (chars[i].skill[17]<800) chars[i].hp += 2;
     else chars[i].hp += 3;
     if (chars[i].hp>chars[i].st) chars[i].hp=chars[i].st;
     updatestats(i, 0);
    }
   }
   if ((chars[i].regen2<=currenttime)||(overflow))
   {
    chars[i].regen2=currenttime+(server_data.staminarate*CLOCKS_PER_SEC);
    if (chars[i].stm<chars[i].dx)
    {
     chars[i].stm++;
     updatestats(i, 2);
    }
   }
   if ((chars[i].regen3<=currenttime)||(overflow))
   {
    if(server_data.armoraffectmana)chars[i].regen3=currenttime+((server_data.manarate+(calcdef(i,0)-2))*CLOCKS_PER_SEC);    
    else
    chars[i].regen3=currenttime+(server_data.manarate*CLOCKS_PER_SEC);    
    if (chars[i].mn<chars[i].in)
    {
     chars[i].mn++;
     updatestats(i, 1);
    }
   }
   if ((chars[i].hidden==2)&&((chars[i].invistimeout<=currenttime)||(overflow)))
   {
    chars[i].hidden=0;
    updatechar(i);
   }

   if(chars[i].spiritspeaktimer) chars[i].spiritspeaktimer--;

   if(chars[i].trackingtimer)
   {
    chars[i].trackingtimer--;
    if(!(chars[i].trackingtimer%tracking_data.redisplaytime))
      track(i);
   }
   if(chars[i].fishingtimer)
   {
    if(chars[i].fishingtimer==1) fish(i);
    chars[i].fishingtimer--;
   }

   if ((chars[i].hungertime<=getclock())||(overflow))
   {
    if (chars[i].hunger) chars[i].hunger--;
    switch(chars[i].hunger)
    {
      case 5:
      sysmessage(calcSocketFromChar(i),"You are still stuffed from your last meal");
      break;
      case 4:
      sysmessage(calcSocketFromChar(i),"You are not very hungry but could eat more");
      break;
      case 3:
      sysmessage(calcSocketFromChar(i),"You are feeling fairly hungry");
      break;
      case 2:
      sysmessage(calcSocketFromChar(i),"You are extremely hungry");
      break;
      case 1:
      sysmessage(calcSocketFromChar(i),"You are very weak from starvation");
      break;
      case 0:
      sysmessage(calcSocketFromChar(i),"You must eat very soon or you will die!");
      break;
    }
    chars[i].hungertime=currenttime+(server_data.hungerrate*CLOCKS_PER_SEC); // Bookmark
   }

   if ( (chars[i].poisoned) && (online(i) || chars[i].npc) && !(chars[i].priv&4) )
   {
    if ((chars[i].poisontime<=currenttime)||(overflow))
        {
         if (chars[i].poisoned==1)
         {
      chars[i].poisontime=currenttime+(5*CLOCKS_PER_SEC);
          if ((chars[i].poisontxt<=currenttime)||(overflow))
          {
           chars[i].poisontxt=currenttime+(10*CLOCKS_PER_SEC);
           sprintf(t,"* %s looks a bit nauseous *",chars[i].name);
           chars[i].emotecolor1=0x00;//buffer[s][4];
       chars[i].emotecolor2=0x26;//buffer[s][5];
           npcemoteall(i,t);
          }
           //npctalkall(i,t);
          chars[i].hp=chars[i].hp-RandomNum(1,2);
      updatestats(i, 0);
         }
         if (chars[i].poisoned==2)
         {
          chars[i].poisontime=currenttime+(4*CLOCKS_PER_SEC);
          if ((chars[i].poisontxt<=currenttime)||(overflow))
          {
           chars[i].poisontxt=currenttime+(10*CLOCKS_PER_SEC);
           sprintf(t,"* %s looks disoriented and nauseous! *",chars[i].name);
           chars[i].emotecolor1=0x00;//buffer[s][4];
       chars[i].emotecolor2=0x26;//buffer[s][5];
           npcemoteall(i,t);
           //npctalkall(i,t);     
          }
          x=RandomNum(5,10);
          if (chars[i].hp<20) x=RandomNum(25,40);
          if (chars[i].hp<10) x=RandomNum(40,130);
          pcalc=(chars[i].hp*x/100);
          chars[i].hp=chars[i].hp-pcalc;
          updatestats(i, 0);
         }
     if (chars[i].poisoned==3)
         {
          chars[i].poisontime=currenttime+(3*CLOCKS_PER_SEC);
          if ((chars[i].poisontxt<=currenttime)||(overflow))
          {
           chars[i].poisontxt=currenttime+(10*CLOCKS_PER_SEC);
           sprintf(t,"* %s is in severe pain! *",chars[i].name);
           chars[i].emotecolor1=0x00;//buffer[s][4];
       chars[i].emotecolor2=0x26;//buffer[s][5];
           npcemoteall(i,t);
           //npctalkall(i,t);
          }
          x=RandomNum(15,25);
          if (chars[i].hp<20) x=RandomNum(25,50);
          if (chars[i].hp<10) x=RandomNum(60,130);
          pcalc=(chars[i].hp*x/100);
          chars[i].hp=chars[i].hp-pcalc;
          updatestats(i, 0);
         }
     if (chars[i].poisoned==4)
         {
          chars[i].poisontime=currenttime+(3*CLOCKS_PER_SEC);
          if ((chars[i].poisontxt<=currenttime)||(overflow))
          {
           chars[i].poisontxt=currenttime+(10*CLOCKS_PER_SEC);
           sprintf(t,"* %s looks extremely weak and is wrecked in pain! *",chars[i].name);
           chars[i].emotecolor1=0x00;//buffer[s][4];
       chars[i].emotecolor2=0x26;//buffer[s][5];
           npcemoteall(i,t);
           //npctalkall(i,t);
          }
          x=RandomNum(10,40);
          if (chars[i].hp<20) x=RandomNum(30,80);
          if (chars[i].hp<10) x=RandomNum(80,130);
          pcalc=(chars[i].hp*x/100);
          chars[i].hp=chars[i].hp-pcalc;
          updatestats(i, 0);
         }
    }
        if (chars[i].hp<1)
        {
         deathstuff(i);
         sysmessage(calcSocketFromChar(i), "The poison has killed you.");
        }
   }

   if (!chars[i].dead) combat(i,currenttime);
  }
 }
 npcMovement(currenttime);
 //added respawn, gatedestruct delays for performance
 if (respawntime<=currenttime||(overflow))
 {
  respawn(currenttime);
  respawntime=(getclock()+(5*CLOCKS_PER_SEC));
 }
 if (gatedesttime<=currenttime||(overflow))
 {
  gatedestruction(currenttime);
  gatedesttime=(getclock()+(15*CLOCKS_PER_SEC));
 }
 decay(currenttime);
 checktempeffects();
 checkfieldeffects(currenttime);
 checknpcai(currenttime);
 if (server_data.UOXBot) checkdumpdata(currenttime); // This dumps data for Ridcully's UOXBot
}

void scriptlist(int x, int spc, int all)
{
 int pos, i;

 openscript("items.scp");
 sprintf(temp, "ITEMMENU %i", x);
 if (!items_script.find(temp))
 {
  closescript();
  return;
 }
 read1();
 do
 {
  read2();
  if (script1[0]!='}')
  {
   sprintf(temp, "%s", script2);
   read2();
   if ((all)||(!(strcmp("ITEMMENU",script1))))
   {
    for (i=0;i<spc;i++) fprintf(lstfile, " ");
    fprintf(lstfile, "%s (%s %s)\n",temp,script1,script2);
    if (!(strcmp("ITEMMENU",script1)))
    {
     pos=ftell(scpfile);
     closescript();
     scriptlist(str2num(script2), spc+2, all);
     openscript("items.scp");
     fseek(scpfile, pos, SEEK_SET);
     sprintf(script1, "DUMMY");
    }
   }
  }
 }
 while (script1[0]!='}');
 closescript();
}

void scriptmax(char *txt)
{
 int ok, i, x, highest, current;
 char str[512];

 highest=-1;
 if (strcmp("ITEM",txt)&&strcmp("ITEMMENU",txt))
   openscript("npc.scp");
 else
   openscript("items.scp");
 sprintf(str, "SECTION %s ", txt);
 do
 {
  readscript();
  ok=1;
  x=strlen(str);
  if (strlen(temp)<x) x=strlen(temp);
  for (i=0;i<x;i++) if (str[i]!=temp[i]) ok=0;
  if (ok==1)
  {
   current=str2num(&temp[x]);
   if (current==highest) printf("WARNING: Duplicate section %s %i\n",txt,highest);
   if (current>highest) highest=current;
  }
 }
 while (strcmp("EOF",temp));
 closescript();
 fprintf(lstfile, " %s: %i\n", txt, highest);
}

int main(int argc, char *argv[])
{
        int i;
        unsigned long tempSecs;
        unsigned long tempMilli;
        unsigned long loopSecs;
        unsigned long loopMilli;
        unsigned long tempTime;

#ifdef __NT__
 constart();
 sprintf(temp, "%s V%s", PRODUCT, VER);
 SetConsoleTitle(temp);
 clearscreen();
#else
 signal(SIGPIPE, SIG_IGN); // This appears when we try to write to a broken network connection
 signal(SIGTERM, &endmessage);
 signal(SIGQUIT, &endmessage);
 signal(SIGINT, &endmessage); 
 signal(SIGILL, &illinst);

#endif

 openings=0;
 if (argc>1)
 if (!(strcmp(argv[1],"#")))
 {
  printf("\nUOX3 Menu List Generator Module\n\n");
  printf("Creating UOXMENUS.LST...\n");
  lstfile=fopen("UOXMENUS.LST","w");
  if (lstfile==NULL)
  {
    printf("ERROR: UOXMENUS.LST could not be created.\n");
         error=1;
    keeprun=0;
    return 0;
  }
  fprintf(lstfile, "UOX3 Script Menu List\n\n");
  fprintf(lstfile, "This file is intended to allow you to do a quick lookup for certain items\n");
  fprintf(lstfile, "or menus that you might be searching.\n\n");
  fprintf(lstfile, "Maximum used numbers: (Always use numbers higher than those)\n");
  scriptmax("GMMENU");
  scriptmax("BATCH");
  scriptmax("NPC");
  scriptmax("SPEECH");
  scriptmax("ITEMMENU");
  scriptmax("ITEM");
  scriptmax("LOCATION");
  fprintf(lstfile, "\nShort List: (Menus only)\n");
  fprintf(lstfile, "GM Master Item Menu (ITEMMENU 1)\n");
  scriptlist(1, 1, 0);
  fprintf(lstfile, "\nLong List: (Menus and Items)\n");
  fprintf(lstfile, "GM Master Item Menu (ITEMMENU 1)\n");
  scriptlist(1, 1, 1);
  fprintf(lstfile, "\nUOX3 Copyright 1998 by UOX Team\n");
  fclose(lstfile);
  printf("List creation complete!\n");
  return 0;
 }
 uoxtimeout.tv_sec=0;
 uoxtimeout.tv_usec=0;
 keeprun=1;
 error=0;
 now=0;
 secure=1;
 charcount=0;
 itemcount=0;
 charcount2=1;
 itemcount2=0x40000000;
 donpcupdate=0;
 wtype=0;
 cmemover=0;
 cmemcheck=-1;
 imemover=0;
 imemcheck=-1;
 xcounter=0;
 ycounter=0;
 for (i=0;i<301;i++) freecharmem[i]=-1;
 for (i=0;i<501;i++) freeitemmem[i]=-1;
 for (i=0;i<MAXACCT;i++) acctinuse[i]=0;
 for (i=0;i<MAXCHARS;i++) talkingto[i]=0;
 for (i=0;i<STABLOCKCACHESIZE;i++) stablockcachex[i]=-1;
 for (i=0;i<MAXLAYERS;i++) layers[i]=0;
 // Tauriel item pointer lookups 12-3-09
 // This allocates arrays like itemsp[].pointer[] for setting = items[] #
 // itemsp[].max is current maximum for this serial%256 block
 printf("Building pointer arrays.\n");
 for (i=0;i<256;i++)
 {
   int memerrflg =0;
   if ((itemsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;
   else if ((charsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;
   else if ((cownsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;
   else if ((spawnsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;
   else if ((contsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;
   else if ((cspawnsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;
   else if ((ownsp[i].pointer = (int *) malloc(25 * sizeof(int)))== NULL)
     memerrflg=1;

   if (memerrflg)
   {
     printf("Error allocating pointer memory\n Press return to exit\n");
     error=1;
     keeprun=0;
     return 0;
   }
   // with 25 starting value should give about 6,150 (256*25) items initially.
   // and it will dynamically reallocate in 50 unit increments after that
   // initialize them to -1 so we know where free ones are
   itemsp[i].max=ownsp[i].max=spawnsp[i].max=contsp[i].max=cownsp[i].max=cspawnsp[i].max=charsp[i].max=25;
   for (int j=0;j<25;j++)
     itemsp[i].pointer[j]=ownsp[i].pointer[j]=cownsp[i].pointer[j]=spawnsp[i].pointer[j]=contsp[i].pointer[j]=cspawnsp[i].pointer[j]=charsp[i].pointer[j]=-1;
 }

 stablockcachei=0;
 stablockcachehit=0;
 stablockcachemiss=0;
 globallight=0;
 executebatch=0;
 showlayer=0;
 autosaved = 0;
 readini();
 mapfile=fopen(mapname,"rb");
 if (mapfile==NULL)
 {
  printf("ERROR: Map %s not found...\n",mapname);
  error=1;
  keeprun=0;
  return 0;
 }
 freelogins=4;
 sidxfile=fopen(sidxname,"rb");
 if (sidxfile==NULL)
 {
  printf("ERROR: Statics Index %s not found...\n",sidxname);
  error=1;
  keeprun=0;
  return 0;
 }
 statfile=fopen(statname,"rb");
 if (statfile==NULL)
 {
  printf("ERROR: Statics File %s not found...\n",statname);
  error=1;
  keeprun=0;
  return 0;
 }
 verfile=fopen(vername,"rb");
 if (verfile==NULL)
 {
  printf("ERROR: Version File %s not found...\n",vername);
  error=1;
  keeprun=0;
  return 0;
 }
 tilefile=fopen(tilename,"rb");
 if (tilefile==NULL)
 {
  printf("ERROR: Tiledata File %s not found...\n",tilename);
  error=1;
  keeprun=0;
  return 0;
 }
 multifile=fopen(multiname,"rb");
 if (multifile==NULL)
 {
  printf("ERROR: Multi data file %s not found...\n",multiname);
  error=1;
  keeprun=0;
  return 0;
 }
 midxfile=fopen(midxname,"rb");
 if (midxfile==NULL)
 {
  printf("ERROR: Multi index file %s not found...\n",midxname);
  error=1;
  keeprun=0;
  return 0;
 }
 read_in_teleport();
#ifdef __NT__
 sprintf(idname, "%s Version %s Alpha [WIN32] by %s <%s>", PRODUCT, VER, NAME, EMAIL);
#else
 sprintf(idname, "Ultima Offline eXperiment 3 Server Version %s Alpha [LINUX] by %s <%s>", VER, NAME, EMAIL);
#endif
 printf("\n%s V%s Alpha", PRODUCT, VER);
#ifdef __NT__
 printf(" for Win32");
#else
 printf(" for Linux");
#endif
 printf("\n");
 printf("(Configured for connections by UO Client versions starting with 1.25.%i)\n", CLIENTVERSION);
 printf("Copyright (C) 1997, 98 Marcus Rating (Cironian)\n\n");
 printf("This program is free software; you can redistribute it and/or modify\n");
 printf("it under the terms of the GNU General Public License as published by\n");
 printf("the Free Software Foundation; either version 2 of the License, or\n");
 printf("(at your option) any later version.\n\n");
 printf("%s version %s\n", PRODUCT, VER);
 printf("Compiled at %s (%s %s)\n",__DATE__,__TIME__,TIMEZONE);
 printf("Compiled by %s <%s>\n",NAME,EMAIL);
 if (sizeof(tile_st)!=37)
         printf("This version of UOX3 was complied incorrectly. sizeof(tile_st) = %d \n", sizeof(tile_st));
 printf("\n");
 sockinit();
 srand(getclock()); // initial randomization call
 loadserverdefaults();
 loadserverscript();
 loadnewworld();
// sectioning(); // For sectioning Items and chars arrays
 clearalltrades();
 im_loadmenus( "inscribe.gmp", tellscroll ); //loading gump for inscribe()
 gcollect();
 FD_ZERO(&conn);
 starttime=getclock();
 endtime=0;
 lclock=0;
 initque(); // Initialize gmpages[] array
 loadregions();
 towninit();
 loadskills();
 loadcustomtitle();
 //   EviLDeD  -  Make sure to set the WorldSave announce value here
 //   December 27, 1998
 cwmWorldState.announce(server_data.announceworldsaves);
 //   EviLDeD  -  End
 printf("UOX3: Startup Complete.\n");
 savelog("-=Server Startup=-\n=======================================================================\n","server.log");
 if (strlen(server_data.archivepath)>1)
  printf("UOX3: Archiving enabled. (%s)\n",server_data.archivepath);
while (keeprun)
 {
#ifdef __NT__
  checkkey();
#endif
#ifdef _MSVC
  Sleep(20); //kolours - slight tune to 40 from 50 (09/19/98)
#else
#ifdef __NT__
  delay(20); // My compiler uses sleep() for full seconds, so I had to use this.
#else
  usleep(20000); //kolours - slight tune to 40000 from 50000 (09/19/98)
#endif
#endif

        if(loopTimeCount >= 1000)       {
                loopTimeCount = 0;
                loopTime = 0;
        }
        loopTimeCount++;

        StartMilliTimer(loopSecs, loopMilli);
        
        if(networkTimeCount >= 1000)    {
                networkTimeCount = 0;
                networkTime = 0;
        }
        
        StartMilliTimer(tempSecs, tempMilli);
        
        checkconn();
        checkmessage();
        
        tempTime = CheckMilliTimer(tempSecs, tempMilli);
        networkTime += tempTime;
        networkTimeCount++;

        if(timerTimeCount >= 1000)      {
                timerTimeCount = 0;
                timerTime = 0;
        }
        
        StartMilliTimer(tempSecs, tempMilli);
  
        checktimers();
        
        tempTime = CheckMilliTimer(tempSecs, tempMilli);
        timerTime += tempTime;
        timerTimeCount++;

        if(autoTimeCount >= 1000)       {
                autoTimeCount = 0;
                autoTime = 0;
        }
        StartMilliTimer(tempSecs, tempMilli);
        
        checkauto();
        
        tempTime = CheckMilliTimer(tempSecs, tempMilli);
        autoTime  += tempTime;
        autoTimeCount++;

        clearbuffers();
        tempTime = CheckMilliTimer(loopSecs, loopMilli);
        loopTime += tempTime;

 }

 sysbroadcast("The server is shutting down");
 Writeslot("shutdown");
 im_clearmenus();
 sockclose();
 fclose(mapfile);
 fclose(sidxfile);
 fclose(statfile);
 fclose(verfile);
 fclose(tilefile);
 fclose(multifile);
 fclose(midxfile);
// WSACleanup(); (Commented out as this caused weird bugs for some reason; works fine now)
 cwmWorldState.savenewworld(1);
 saveserverscript(1);
 printf("\n");
 if (error) {
	 printf("ERROR: Server terminated by error!\n");
	 savelog("Server Shutdown by Error!\n=======================================================================\n\n\n","server.log");
 } else {
	 printf("UOX3: Server shutdown complete!\n");
	 savelog("Server Shutdown!\n=======================================================================\n\n\n","server.log");
 }
 return 0;
}

char iteminrange (int s, int i, int distance)
{
 int c=1;
 int xa, xb, ya, yb, dx, dy;
 int vr=distance;
 xa=chars[currchar[s]].x;
 ya=chars[currchar[s]].y;
 xb=items[i].x;
 yb=items[i].y;
 dx=abs(xa-xb);
 dy=abs(ya-yb);
 if (dx>vr) c=0;
 if (dy>vr) c=0;
 if (chars[currchar[s]].priv&1) c=1;
 return c;
}

char npcinrange (int s, int i, int distance)
{
 int c=1;
 int xa, xb, ya, yb, dx, dy;
 int vr=distance;
 if (i==-1) return 1;
 xa=chars[currchar[s]].x;
 ya=chars[currchar[s]].y;
 xb=chars[i].x;
 yb=chars[i].y;
 dx=abs(xa-xb);
 dy=abs(ya-yb);
 if (dx>vr) c=0;
 if (dy>vr) c=0;
 if (chars[currchar[s]].priv&1) c=1;
 return c;
}

void titletarget(int s)
{
  int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    sprintf(chars[i].title,xtext[s]);
  }
}

void decay(unsigned int currenttime)  // for item decay, only corpses for now
{
 int i,j,k,serial,serhash,ci;
 if (nextdecaytime<=currenttime||(overflow))
 {
  for (i=0;i<itemcount;i++)
  {
//   if (items[i].priv&0x01 && items[i].cont1==0xFF && items[i].cont2==0xFF &&
//       items[i].cont3==0xFF && items[i].cont4==0xFF && items[i].free==0)
    if (items[i].priv&0x01 && items[i].contserial==-1 && items[i].free==0)
   {
    if (items[i].decaytime==0)
     items[i].decaytime=5*60*CLOCKS_PER_SEC+currenttime; // 5 minutes, * 60 secs per min, * clocks_per_sec
    if (items[i].decaytime<currenttime)
    {
     if (items[i].corpse==1)
     {
       serial=items[i].serial;
       serhash=serial%256;
        for (ci=0;ci<contsp[serhash].max;ci++)
        {
          j=contsp[serhash].pointer[ci];
          if ((items[j].contserial==items[i].serial) &&
              (items[j].layer!=0x0B)&&(items[j].layer!=0x10))
          {
            removefromptr(&contsp[items[j].contserial%256], j);
            items[j].cont1=255;
            items[j].cont2=255;
            items[j].cont3=255;
            items[j].cont4=255;
            items[j].contserial=-1;
            items[j].x=items[i].x;
            items[j].y=items[i].y;
            items[j].z=items[i].z;
            for (k=0;k<now;k++) if (perm[k] && inrange2(k, j)) senditem(k,j);
          }
//       if ((items[j].cont1==items[i].ser1)&&(items[j].cont2==items[i].ser2)&&
//           (items[j].cont3==items[i].ser3)&&(items[j].cont4==items[i].ser4)&&
          if ((items[j].contserial==items[i].serial) &&
              (items[j].free==0)&&
              ((items[j].layer==0x0B)||(items[j].layer==0x10)))
          {
            deleitem(j);
          }
        }
     }
     deleitem(i);
    }
   }
  }
  nextdecaytime=currenttime+(5*CLOCKS_PER_SEC);
 }
}

void npcact(int s)
{
  int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   npcaction(i,addid1[s]);
  }
}

void objTeleporters(int s)
{
 int i;

 for (i=0;i<itemcount;i++)
 {
  // teleporters
  if ((items[i].type==60)&&(items[i].x==chars[s].x)&&
      (items[i].y==chars[s].y)&&
          ((abs(items[i].z) + 10 ) >= abs(chars[s].z)) &&
          ((abs(items[i].z) - 10 ) <= abs(chars[s].z)) && (items[i].morex+items[i].morey+items[i].morez !=0))
  {
   chars[s].x=items[i].morex;
   chars[s].y=items[i].morey;
   chars[s].dispz=chars[s].z=items[i].morez;
   teleport(s);
  }

  // advancement objects
  if ((items[i].type==80)&&(items[i].x==chars[s].x)&&(items[i].y==chars[s].y)
          &&((abs(items[i].z) + 10 ) >= abs(chars[s].z)) && ((abs(items[i].z) - 10 ) <= abs(chars[s].z))
          &&!(chars[s].npc)) 
   if(items[i].more1!=0 || items[i].more2!=0 || items[i].more3!=0 || items[i].more4!=0)
    {
      if(chars[s].ser1==items[i].more1 && chars[s].ser2==items[i].more2 && chars[s].ser3==items[i].more3 && chars[s].ser4==items[i].more4)
      advancementobjects(s,items[i].morex,0);
    }
    else
    advancementobjects(s,items[i].morex,0);
  if ((items[i].type==81)&&(items[i].x==chars[s].x)&&(items[i].y==chars[s].y)
          &&((abs(items[i].z) + 10 ) >= abs(chars[s].z)) && ((abs(items[i].z) - 10 ) <= abs(chars[s].z))
          &&!(chars[s].npc))
  if(items[i].more1!=0 || items[i].more2!=0 || items[i].more3!=0 || items[i].more4!=0)
    {
      if(chars[s].ser1==items[i].more1 && chars[s].ser2==items[i].more2 && chars[s].ser3==items[i].more3 && chars[s].ser4==items[i].more4)
      advancementobjects(s,items[i].morex,1);
    }
    else
    advancementobjects(s,items[i].morex,1);
  // The above code lets you restrict a gate's use by setting its MORE values to a char's
  // serial #

  // damage objects
  if ((!(chars[s].priv&4))&&
          (items[i].type==85)&&(items[i].x==chars[s].x)&&
      (items[i].y==chars[s].y)&&((abs(items[i].z) + 10 ) >= abs(chars[s].z)) && ((abs(items[i].z) - 10 ) <= abs(chars[s].z)))
  {
   chars[s].hp=chars[s].hp-(items[i].morex+RandomNum(items[i].morey,items[i].morez));
   if (chars[s].hp<1) chars[s].hp=0;
   updatestats(s, 0);
   if (chars[s].hp==0) deathstuff(s);
  }
 // monster gates
  if ((items[i].type==82)&&(items[i].x==chars[s].x)&&(items[i].y==chars[s].y)
     &&((abs(items[i].z) + 10 ) >= abs(chars[s].z)) && ((abs(items[i].z) - 10 ) <= abs(chars[s].z))
     &&!(chars[s].npc))
     monstergate(s,items[i].morex);

  // sound objects
  if ((items[i].type==86)&&(items[i].x==chars[s].x)&&
      (items[i].y==chars[s].y)&&((abs(items[i].z) + 10 ) >= abs(chars[s].z)) && ((abs(items[i].z) - 10 ) <= abs(chars[s].z)))
  {
   if (RandomNum(1,100)<=items[i].morez)
   soundeffect3(i, items[i].morex, items[i].morey);   
  }
 }
}

void npcToggleCombat(int s)
{
 chars[s].war=(!(chars[s].war));
 walking2(s);
}

int chardir(int a, int b)   // direction from character a to char b
{
 int dir,xdif,ydif;

 xdif = chars[b].x-chars[a].x;
 ydif = chars[b].y-chars[a].y;

 if ((xdif==0)&&(ydif<0)) dir=0;
 else if ((xdif>0)&&(ydif<0)) dir=1;
 else if ((xdif>0)&&(ydif==0)) dir=2;
 else if ((xdif>0)&&(ydif>0)) dir=3;
 else if ((xdif==0)&&(ydif>0)) dir=4;
 else if ((xdif<0)&&(ydif>0)) dir=5;
 else if ((xdif<0)&&(ydif==0)) dir=6;
 else if ((xdif<0)&&(ydif<0)) dir=7;
 else dir=-1;

 return dir;
}

char tileblock(int tilenum)
{
 tile_st tile;

 seektile(tilenum, &tile);

 return (tile.flag1&0x40);
}

char tilewalk(int tilenum)
{
 tile_st tile;

 seektile(tilenum, &tile);

 return (tile.flag4&0x04);
}

char stablock(int x, int y, int oldz)
{
 int k;
// Check stablock cache, if enabled.
 if (STABLOCKCACHESIZE)
 {
  k=0;
  while (k<STABLOCKCACHESIZE && stablockcachex[k]!=-1)
  {
   if (stablockcachex[k]==x && stablockcachey[k]==y && stablockcachez[k]==oldz)
   {
    stablockcachehit++;
    return stablockcacher[k];
   }
   k++;
  }
 }
 stablockcachemiss++;
 if (!oldstablock(x, y, oldz))
 {
  k=height(x+1, y, oldz);
  if (oldz<127 && k>127) k=k-256;
  if (k>=oldz-5)
  {
   k=height(x-1, y, oldz);
   if (oldz<127 && k>127) k=k-256;
   if (k>=oldz-5)
   {
    k=height(x, y+1, oldz);
    if (oldz<127 && k>127) k=k-256;
    if (k>=oldz-5)
    {
     k=height(x, y-1, oldz);
     if (oldz<127 && k>127) k=k-256;
     if (k>=oldz-5)
     {
      stablockcachex[stablockcachei]=x;
      stablockcachey[stablockcachei]=y;
      stablockcachez[stablockcachei]=oldz;
      stablockcacher[stablockcachei]=0;
      stablockcachei=(stablockcachei+1)%STABLOCKCACHESIZE;
      return 0;
     }
    }
   }
  }
 }
 stablockcachex[stablockcachei]=x;
 stablockcachey[stablockcachei]=y;
 stablockcachez[stablockcachei]=oldz;
 stablockcacher[stablockcachei]=1;
 stablockcachei=(stablockcachei+1)%STABLOCKCACHESIZE;
 return 1;
}

char oldstablock(int x, int y, int oldz) // Blocking statics at/above given coordinates?
{
 long int pos, pos2, length;
 int x1, x2;
 int y1, y2;
 signed char z, ztemp, found, btemp;
 int i;
// tile_st tile;
 struct staticrecord
 {
  short int itemid;
  char xoff;
  char yoff;
  char zoff;
  short int extra; // Unknown yet
 } stat;

 //   EviLDeD  -  Bug killing
 memset(&stat,0,sizeof(staticrecord));

 stat.itemid=stat.itemid;
 stat.extra=stat.extra;
 z=-127;
 found=0;
 x1=x/8; // Block
 y1=y/8;
 x2=(x-(x1*8)); // Offset
 y2=(y-(y1*8));
 pos=(x1*512*12)+(y1*12);
 fseek(sidxfile, pos, SEEK_SET);
 fread(&pos2, 4, 1, sidxfile);
 if (pos2!=-1)
 {
   if (feof(sidxfile))
   {
        printf("Error: Avoiding bad read crash.\n");
    return 0;
   }
  fread(&length, 4, 1, sidxfile);
  length=length/7;
  fseek(statfile, pos2, SEEK_SET);
  for (i=0;i<length;i++)
  {
   if (feof(statfile))
   {
        printf("Error: Avoiding bad z pos crash.\n");
    return z;
   }
   fread(&stat, 7, 1, statfile);
   if ((stat.xoff==x2)&&(stat.yoff==y2))  //If the x and y offsets matchup.
   {
    ztemp=stat.zoff+tileheight(stat.itemid);
    if (oldz>=stat.zoff-1 && (oldz<ztemp || (oldz<ztemp+1 && abs(oldz-stat.zoff)<=2)))
    {
            btemp=tileblock(stat.itemid);
                if (btemp) return 1;
    }
   }
  }
 }
 return 0;
}

char oldstawalk(int x, int y, int oldz) // Walking statics at/above given coordinates?
{
 long int pos, pos2, length;
 int x1, x2;
 int y1, y2;
 signed char z, ztemp, found, btemp;
 int i;
// tile_st tile;
 struct staticrecord
 {
  short int itemid;
  char xoff;
  char yoff;
  char zoff;
  short int extra; // Unknown yet
 } stat;

 //   EviLDeD  -  Bug killing
 memset(&stat,0,sizeof(staticrecord));

 stat.itemid=stat.itemid;
 stat.extra=stat.extra;
 z=-127;
 found=0;
 x1=x/8; // Block
 y1=y/8;
 x2=(x-(x1*8)); // Offset
 y2=(y-(y1*8));
 pos=(x1*512*12)+(y1*12);
 fseek(sidxfile, pos, SEEK_SET);
 fread(&pos2, 4, 1, sidxfile);
 if (pos2!=-1)
 {
   if (feof(sidxfile))
   {
        printf("Error: Avoiding bad read crash.\n");
    return 0;
   }
  fread(&length, 4, 1, sidxfile);
  if (length == 0) return 0;
  return 1;
  length=length/7;
  fseek(statfile, pos2, SEEK_SET);
  for (i=0;i<length;i++)
  {
   if (feof(statfile))
   {
        printf("Error: Avoiding bad z pos crash.\n");
    return z;
   }
   fread(&stat, 7, 1, statfile);
   if ((stat.xoff==x2)&&(stat.yoff==y2))  //If the x and y offsets matchup.
   {
    ztemp=stat.zoff+tileheight(stat.itemid);
    if (abs(oldz-stat.zoff)<=5)
    {
            btemp=tilewalk(stat.itemid);
                if (btemp) return 1;
    }
   }
  }
 }
 return 0;
}

int calcSocketFromChar(int i)
{
  int j;
        
  if ((i<0) || (i >= MAXCHARS))
  {
    //LogMessage("calcSocketFromChar() - Bad char number (%i)\n" _ i);
    return -1;
  }
  if (chars[i].npc) return -1;
  for (j=0; j<now;j++)
  {
    if (currchar[j]==i && (perm[j])) return j;
  }
  return -1;
}

int calcCharFromSer(int ser1, int ser2, int ser3, int ser4)
{
 int serial;

  serial=calcserial(ser1, ser2, ser3, ser4);
  return(findbyserial(&charsp[serial%256], serial, 1));
}

int calcCharFromSer(int serial)
{
  return(findbyserial(&charsp[serial%256], serial, 1));
}

int calcSerFromChar(int i)
{
  if ((i>=0) && (i < MAXCHARS))
     return (chars[i].ser1*16777216)+(chars[i].ser2*65536)+(chars[i].ser3*256)+chars[i].ser4;
  else
  {
    LogMessage("calcSerFromChar() - char not existant (%i)"_ i);
    return -1;
  }
}

int calcItemFromSer(int ser1, int ser2, int ser3, int ser4)
{
 int serial;
 serial=calcserial(ser1, ser2, ser3, ser4);
 return findbyserial(&itemsp[serial%256], serial, 0);
}

void npcwalk(int i, int j, int type)   //type is npcwalk mode (0 for normal, 1 for box, 2 for circle)
{
 int x,y,z;

 x=chars[i].x;
 y=chars[i].y;
 z=chars[i].z;
 if (chars[i].dir==j)  // If we're moving, not changing direction
 {
  switch(j) // Switch, based on the direction we're going to move.
  {
   case 0: // North
           if ((validNPCMove(x, y-1, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x, y-1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x, y-1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 1: // Northeast
           if ((validNPCMove(x+1, y-1, z, i) && validNPCMove(x+1, y, z, i) && validNPCMove(x, y-1, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x+1, y-1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x+1, y-1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 2: // East
           if ((validNPCMove(x+1, y, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x+1, y, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x+1, y, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 3: // Southeast
           if ((validNPCMove(x+1, y+1, z, i) && validNPCMove(x+1, y, z, i) && validNPCMove(x, y+1, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x+1, y+1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x+1, y+1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 4: // South
           if ((validNPCMove(x, y+1, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x, y+1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x, y+1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 5: // Southwest
           if ((validNPCMove(x-1, y+1, z, i) && validNPCMove(x-1, y, z, i) && validNPCMove(x, y+1, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x-1, y+1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x-1, y+1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 6: // West
           if ((validNPCMove(x-1, y, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x-1, y, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x-1, y, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
   case 7: // Northwest
           if ((validNPCMove(x-1, y-1, z, i) && validNPCMove(x-1, y, z, i) && validNPCMove(x, y-1, z, i))&&(
               (!type)||
               ((type==1)&&(checkBoundingBox(x-1, y-1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2, chars[i].fy2)))||
               ((type==2)&&(checkBoundingCircle(x-1, y-1, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2))))
              )
             walking(i, j, 256); // arm code
           break;
  }
 }
 else if (j<8) walking(i, j, 256);
}


void npcMovement(unsigned int currenttime)
{
//**********************************************************
//kolours - for increase in world performance
//**********************************************************
//taking it from the point of view of the player's chars, as
//i plan to have more npcs than players once the world is
//complete (therefore minimal calculations)

 register int i;
 register int k;
 
 int j, dnpctime, x;

 for(k=0;k<charcount;k++) 
 {
  if ((chars[k].npc == 0) && (online(k))) //player character && online
  {  
          int d;
          int d2;
          //*********************not implimented yet******************
          //vary the distance depending on whether or not the char is
          //in town by using the regions.scp file. make it a smaller
          //radius when in town (assuming crowded) than out in the wild.
          //the checkregion function sets the dist_influence variable.
          //**********************************************************

          d2 = 33; //currently this is the static radius around the player

      for (i=0;i<charcount;i++)
      {
       d=chardist(i, k);
           if ((d <= d2) && (chars[i].npc != 0) && (k != i)) //within dist && NPC && not the player
       {
                //After meeting the above conditions
                //allow npcmovement to take place
                //near the player character:

          dnpctime=0;
          if (chars[i].npc && (chars[i].npcmovetime<=currenttime||(overflow)))
          {
//kolours***************************************(09/19/98)
//fix for monsters to wander when within player's sphere
//of influence:
//              if (chars[i].npcaitype&0x02) 
//               {
//                        if (!(chars[i].war)) chars[i].npcWander=2;
//                }
//kolours*************************************************
           //if (chars[i].war)
           if (chars[i].war && chars[i].npcWander != 5)
           {
                k=chars[i].attacker;
                if (chardist(i, k)>1 ||
                        chardir(i, k)!=chars[i].dir)
                {
                 if (online(k)||chars[k].npc)
                 {
                  j=chardir(i, chars[i].attacker);
                  if (chars[i].blocked)
                  {
                   x=0;
                   if (j/2.0!=j/2) x=1;
                   //if (chars[i].blocked<=2) j =chars[i].dir2;
                   if (chars[i].blocked<=2) j=chars[i].dir2=(j-2-x)%8; //works better
                   else
                   {
                        if (rand()%2) j=chars[i].dir2=(j-2-x)%8;
                        else j=chars[i].dir2=(j+2+x)%8;
                   }
                  }
                  npcwalk(i,j,0);
                 }
                }
           }
           else
           {
                switch(chars[i].npcWander)
                {
                 case 0: // No movement
                                 break;
                 case 1: // Follow the follow target
                                 k=(chars[i].ftarg);
                                 if (!(online(k)||chars[k].npc)) break;
                                 if (chardist(i, k)>1 || chardir(i, k)!=chars[i].dir)
                                 {
                                  j=chardir(i, k);
                                  if (chars[i].blocked)
                                  {
                                   x=0;
                                   if (j/2.0!=j/2) x=1;
                                   if (chars[i].blocked<=2) j =chars[i].dir2;
                                   else
                                   {
                                        if (rand()%2) j=chars[i].dir2=(j-2-x)%8;
                                        else j=chars[i].dir2=(j+2+x)%8;
                                   }
                                  }
                                  npcwalk(i,j,0);
                                 }
                                 break;
                 case 2: // Wander freely, avoiding obstacles.
                                 j=rand()%40;
                                 if (j<8 || j>32) dnpctime=5;
                                 if (j>7 && j<33) // Let's move in the same direction lots of the time.  Looks nicer.
                                   j=chars[i].dir;
                                 npcwalk(i,j,0);
                                 break;
                 case 3: // Wander freely, within a defined box
                                 j=rand()%40;
                                 if (j<8 || j>32) dnpctime=5;
                                 if (j>7 && j<33) // Let's move in the same direction lots of the time.  Looks nicer.
                                   j=chars[i].dir;
                                 npcwalk(i,j,1);
                                 break;
                 case 4: // Wander freely, within a defined circle
/*                                 if (!(checkBoundingCircle(chars[i].x, chars[i].y, chars[i].fx1, chars[i].fy1, chars[i].fz1, chars[i].fx2)))
                                 {
doesnt flipping work.             chars[i].x=chars[i].fx1;
Who wrote this shit?              chars[i].y=chars[i].fy1;
                                  if (chars[i].fz1==-1)
                                  {
                                   chars[i].dispz=chars[i].z=height(chars[i].x, chars[i].y, chars[i].z);
                                  }
                                  else
                                  {
                                   chars[i].dispz=chars[i].z=chars[i].fz1;
                                  }
                                  teleport(i);
                                 }
*/
                                 j=rand()%40;
                                 j=rand()%40;
                                 if (j<8 || j>32) dnpctime=5;
                                 if (j>7 && j<33) // Let's move in the same direction lots of the time.  Looks nicer.
                                   j=chars[i].dir;
                                 npcwalk(i,j,0);
                                 break;
                 case 5: //FLEE!!!!!!
                         {
                                 k=chars[i].targ;
                                 //if (!(online(k)||chars[k].npc)) break;
                                 if (chardist(i, k)<15)
                                 {
                                  j=(chardir(i, k)+4)%8;
                                  if (chars[i].blocked)
                                  {
                                   x=0;
                                   if (j/2.0!=j/2) x=1;
                                   if (chars[i].blocked<=2) j =chars[i].dir2;
                                   else
                                   {
                                        if (rand()%2) j=chars[i].dir2=(j-2-x)%8;
                                        else j=chars[i].dir2=(j+2+x)%8;
                                   }
                                  }
                                  npcwalk(i,j,0);
                                 }
                                 break;
                         } break;
                }
           }
           chars[i].npcmovetime=(int)(currenttime+(NPCSPEED*CLOCKS_PER_SEC*(1+dnpctime))); //reset move timer
          }
         }
        }
  }
 }
}

int validNPCMove(int x, int y, int z, int s)
{
 int i, j=0, k=height(x, y, z);
 
 chars[s].blocked++;
 if (abs(k-z)<=5 && !(stablock(x, y, k)) && maptype(x,y)) // If the difference in heights is 5 or less.
                                                          // This should take care of dynamic object collision, I think.
                                                          // And there's no static object in the way at the new height.
 {
  j=1;
  for (i=0;i<charcount;i++) // Check collision.  If you want to make NPCs that shove, change this a bit.
  {
   if (chars[i].x==x && chars[i].y==y && chars[i].z==k)
     if (chars[i].npc || online(i))
      return 0;
  }  // Tauriel this needs to use region arrays! I gotta figure that out someday!
  for (i=0;i<itemcount;i++) // Check door and wall collision
  {
   if (items[i].x==x && items[i].y==y && items[i].z==k)
   {
    if (items[i].type==12)
    {
     // Dupois - Stops animals from opening doors (I find it really annoying)
     // Don't let animals open doors (animals have no titles & npcaitype = 0)
     // Only evil npc's and shopkeepers/guards should open doors (those with strlen(title)>0 & npcaitype!=0)
     // printf("NPC %s is attempting to open door (NPCAITYPE = %i)\n", chars[s].name, chars[s].npcaitype);
     if ((strlen(chars[s].title) > 0)||(chars[s].npcaitype != 0))
      {                                 
       // printf("NPC %s has opened the door. (NPCAI = %i)\n", chars[s].name, chars[s].npcaitype);
       dooruse(-1,i);
      }
     // End of change - Dupois
 
     //dooruse(-1,i);   // Commented out by Dupois for change above
     chars[s].blocked=0;
     return 0;
    }
    if (items[i].id1==0x39 && (items[i].id2==0x46 || items[i].id2==0x56)) return 0;
    if (items[i].id1<=2 || (items[i].id1==3 && items[i].id2<=0xE2)) return 0;
    if (items[i].id1==0x08 && (items[i].id2>0x54 && items[i].id2<0x66)) return 0;
   }
  }
  chars[s].blocked=0;
 }
 return j;
}

int checkBoundingBox(int xPos, int yPos, int fx1, int fy1, int fz1, int fx2, int fy2)
{
 if (xPos>=((fx1<fx2)?fx1:fx2) && xPos<=((fx1<fx2)?fx2:fx1))
   if (yPos>=((fy1<fy2)?fy1:fy2) && yPos<=((fy1<fy2)?fy2:fy1))
     if (fz1==-1 || abs(fz1-height(xPos, yPos, fz1))<=5)
       return 1;
 return 0;
}

int checkBoundingCircle(int xPos, int yPos, int fx1, int fy1, int fz1, int radius)
{
 if ( (xPos-fx1)*(xPos-fx1) + (yPos-fy1)*(yPos-fy1) <= radius * radius)
   if (fz1==-1 || abs(fz1-height(xPos, yPos, fz1))<=5)
     return 1;
 return 0;
}

void npcwandertarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if ((i!=-1) && (chars[i].npc=1)) chars[i].npcWander=npcshape[0];
}

void npctarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {

    addid1[s]=chars[i].ser1;
    addid2[s]=chars[i].ser2;
    addid3[s]=chars[i].ser3;
    addid4[s]=chars[i].ser4;
    target(s, 0, 1, 0, 57, "Select NPC to follow this player.");
  }
}

void npctarget2(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1 && chars[i].npc==1)
  {
   chars[i].ftarg=calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
   chars[i].npcWander=1;
  }
}

void npcrecttarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if ((i!=-1) && (chars[i].npc==1))
  {
    chars[i].fx1=npcshape[0];
    chars[i].fy1=npcshape[1];
    chars[i].fz1=-1;
    chars[i].fx2=npcshape[2];
    chars[i].fy2=npcshape[3];
    chars[i].npcWander=3;
  }
}

void npccircletarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);

  if ((i!=-1) && (chars[i].npc==1))
  {
    chars[i].fx1=npcshape[0];
    chars[i].fy1=npcshape[1];
    chars[i].fz1=-1;
    chars[i].fx2=npcshape[2];
    chars[i].npcWander=4;
   }
}

void respawn(unsigned int currenttime)
{
 int i, j, k,m,serial,serhash,ci;

 for(i=0;i<itemcount;i++)
 {
   if ((items[i].disabled!=0)&&((items[i].disabled<=currenttime)||(overflow)))
   {
     items[i].disabled=0;
   }
  m=0;
  if (items[i].type==61)
  {
   k=0;
//   for(j=0;j<itemcount;j++)
//   {
   serial=items[i].serial;
   serhash=serial%256;
   for (j=0;j<spawnsp[serhash].max;j++)
   {
     ci=spawnsp[serhash].pointer[j];
     if (items[i].serial==items[ci].spawnserial && (items[ci].free==0))
//     if (items[i].ser1==items[j].spawn1 && items[i].ser2==items[j].spawn2 &&
//         items[i].ser3==items[j].spawn3 && items[i].ser4==items[j].spawn4 && (items[j].free==0))
     {
      if (i!=ci && items[ci].x==items[i].x && items[ci].y==items[i].y && items[ci].z==items[i].z)
      {
      k=1;
      break; //j=itemcount;
     }
    }
   }
   if (k==0)
   {
    if (items[i].gatetime==0)
    {
     items[i].gatetime=(rand()%((int)(1+((items[i].morez-items[i].morey)*(CLOCKS_PER_SEC*60))))) +
              (items[i].morey*CLOCKS_PER_SEC*60)+currenttime;
    }
    if ((items[i].gatetime<=currenttime ||(overflow)) && items[i].morex!=0)
    {
     addrespawnitem(i,items[i].morex, 0);
     items[i].gatetime=0;
    }
   }
  }
  if (items[i].type==62 || items[i].type==69)
  {
		k=0;
		if (items[i].serial==1073763561)
		{
			k=0;
		}
    serial=items[i].serial;
    serhash=serial%256;
    for (j=0;j<cspawnsp[serhash].max;j++)
    {
      ci=cspawnsp[serhash].pointer[j];
      if (chars[ci].spawnserial==serial && chars[ci].free==0)
    {
     k++;
    }
   }
   if (k<items[i].amount)
   {
    if (items[i].gatetime==0)
    {
     items[i].gatetime=(rand()%((int)(1+
              ((items[i].morez-items[i].morey)*(CLOCKS_PER_SEC*60))))) +

              (items[i].morey*CLOCKS_PER_SEC*60)+currenttime;
    }
    if ((items[i].gatetime<=currenttime || (overflow)) && items[i].morex!=0)
    {
     addrespawnnpc(i,items[i].morex,1);
     items[i].gatetime=0;
    }
   }
  }
  if ((items[i].type==63)||(items[i].type==64)||(items[i].type==65))
  {
//   for(j=0;j<itemcount;j++)
//   {
//    if (items[i].ser1==items[j].spawn1 && items[i].ser2==items[j].spawn2 &&
//        items[i].ser3==items[j].spawn3 && items[i].ser4==items[j].spawn4 && (items[j].free==0))
    serial=items[i].serial;
    serhash=serial%256;
    for (j=0;j<spawnsp[serhash].max;j++)
    {
      ci=spawnsp[serhash].pointer[j];
      if (items[ci].spawnserial==serial && items[ci].free==0)
      {
        m++;
      }
    }
   if(m<6)
   {
    k=0;
    serial=items[i].serial;
    serhash=serial%256;
    for (j=0;j<spawnsp[serhash].max;j++)
    {
      ci=spawnsp[serhash].pointer[j];
      if (items[i].serial==items[ci].spawnserial && (items[ci].free==0))
      {
        if (i!=ci && items[ci].x==items[i].x && items[ci].y==items[i].y && items[ci].z==items[i].z)
        {
          k=1;
          break;
        }
      }
    }

    if (k==0)
    {
     if (items[i].gatetime==0)
     {
      items[i].gatetime=(rand()%((int)(1+((items[i].morez-items[i].morey)*(CLOCKS_PER_SEC*60))))) +
               (items[i].morey*CLOCKS_PER_SEC*60)+getclock();
     }
     if ((items[i].gatetime<=currenttime ||(overflow)) && items[i].morex!=0)
     {
      if(items[i].type==63) items[i].type=64; //Lock the container 
      addrespawnitem(i,items[i].morex, 1);
      items[i].gatetime=0;
     }
    }
   }
  }
 }
}

void addrespawnitem(int s, int x, int y) //Tauriel 11-22-98 updated for new items
{
  int c, j;
  c=CreateScriptItem(s, x, 1);

  if(y<=0)
  {
    items[c].x=items[s].x;
    items[c].y=items[s].y;
    items[c].z=items[s].z;
  } else
  {
    items[c].x=(rand()%80)+20;
    items[c].y=(rand()%40)+50;
    items[c].z=9;
    items[c].cont1=items[s].ser1;
    items[c].cont2=items[s].ser2;
    items[c].cont3=items[s].ser3;
    items[c].cont4=items[s].ser4;
    items[c].contserial=items[s].serial;
    setptr(&contsp[items[c].contserial%256], c); //set item in pointer array
  }
  setserial(c,s,2);

  if (x) for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
}

//Modified by Krozy (krozy@questworld.ml.org) 7-Sep-98 (Scripts need changed)
/*void addrespawnnpc(int s, int x, int type)
{
   int tmp, z,c,n, lovalue, hivalue, mypack, retitem;
   int storeval, shoppack1, shoppack2, shoppack3;
	 int k=0, xos=0, yos=0;
   char sect[512];
   long int pos;
   char rndlootlist[20];

   mypack=-1;
   retitem=-1;
   storeval=-1;
   shoppack1=-1;
   shoppack2=-1;
   shoppack3=-1;
   c=memcharfree ();

   initchar(c);
   if (type==1) {
     if (triggerx)
     {
       chars[c].x=triggerx;
       chars[c].y=triggery;
       chars[c].dispz=chars[c].z=triggerz;
       //triggerx=c;  Taur v69.02 moved to end of function
     } else {*/
 	   /*Zippy's Code chages for area spawns --> (Type 69) xos and yos (X OffSet, Y OffSet) 
		 are used to find a random number that is then added to the spawner's x and y (Using 
		 the spawner's z) and then place the NPC anywhere in a square around the spawner. 
		 This square is random anywhere from -10 to +10 from the spawner's location (for x and 
		 y) If the place chosen is not a valid position (the NPC can't walk there) then a new 
		 place will be chosen, if a valid place cannot be found in a certain # of tries (50), 
			 the NPC will be placed directly on the spawner and the server op will be warned. */
			 
/*			 if ((items[s].type==69)&&(items[s].contserial==-1))
			 {
				 if (items[s].more3==0) items[s].more3=10;
				 if (items[s].more4==0) items[s].more4=10;
				 do
				 {
					 if (k>=50) //this CAN be a bit laggy. adjust as nessicary
					 {
						 printf("UOX3: Problem area spawner found at [%i,%i,%i]. NPC placed at default location.\n",items[s].x,items[s].y,items[s].z);
						 xos=0;
						 yos=0;
						 break;
					 }
					 xos=RandomNum(-items[s].more3,items[s].more3);
					 yos=RandomNum(-items[s].more4,items[s].more4);
					 //printf("Spawning at Offset %i,%i (%i,%i,%i) [-%s,%s <-> -%s,%s]. [Loop #: %i]\n",xos,yos,items[s].x+xos,items[s].y+yos,items[s].z,items[s].more3,items[s].more3,items[s].more4,items[s].more4,k);
					 k++;
				 } while (!validNPCMove(items[s].x+xos,items[s].y+yos,items[s].z,c));
			 } // end Zippy's changes (exept for all the +xos and +yos around here....)
       if (chars[c].fx1==-1)
       {
         chars[c].fx1=items[s].x+xos;
         chars[c].fy1=items[s].y+yos;
         if (chars[c].fz1!=-1) chars[c].fz1=items[s].z;
       }
       chars[c].x=items[s].x+xos;
       chars[c].y=items[s].y+yos;
       chars[c].dispz=chars[c].z=items[s].z;
       setserial(c,s,6);
     }
   } else {
     if (chars[c].fx1==-1)
     {
       chars[c].fx1=(buffer[s][11]*256)+buffer[s][12]+xos;
       chars[c].fy1=(buffer[s][13]*256)+buffer[s][14]+yos;
       if (chars[c].fz1!=-1) chars[c].fz1=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
     }
     chars[c].x=(buffer[s][11]*256)+buffer[s][12]+xos;
     chars[c].y=(buffer[s][13]*256)+buffer[s][14]+yos;
     chars[c].dispz=chars[c].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
   }
   chars[c].priv=0x10;
   chars[c].npc=1;
   chars[c].att=1;
   chars[c].def=1;
   // Dupois - added to fix teleporting guards bug.  Guards would not teleport because
   // newly created NPC's would not have their chars[x].region updated on creation
   // (only after moving the first time).  Therefore if NPC was set never to move, or
   // never did move, its chars[x].region would always be -1 and never allow a guard
   // to teleport in to guard NPC
   chars[c].region=calcRegionFromXY(chars[c].x, chars[c].y);

   openscript("npc.scp");
   sprintf(sect, "NPC %i", x);
   if (!npc_script.find(sect)) {
      closescript();
      return;
   }
   do {
      read2();
      if (script1[0]!='}') {
         if (!(strcmp("NAME",script1))) {
            sprintf(chars[c].name, "%s", script2);
         }
         if (!(strcmp("NAMELIST", script1))) {
            pos=ftell(scpfile);
            closescript();
            setrandomname(c,script2);
            openscript("npc.scp");
            fseek(scpfile, pos, SEEK_SET);
            sprintf(script1, "DUMMY"); // To prevent accidental exit of loop.
         }
         if (!(strcmp("NPCLIST", script1))) {
            pos=ftell(scpfile);
            closescript();
            donpcupdate++;
            if (type==1){
            deletechar(c);
            addrandomnpc(s,script2,1);  //Taur v69.02
            //addrandomnpc(c,script2,s);
            }else{
            deletechar(c);
            addrandomnpc(c,script2,-1);
            }
            donpcupdate--;
            openscript("npc.scp");
            fseek(scpfile, pos, SEEK_SET);
            sprintf(script1, "DUMMY");
         }
         if (!(strcmp("TITLE",script1))) sprintf(chars[c].title, "%s", script2);
         if (!(strcmp("KARMA",script1))) chars[c].karma=str2num(script2);
         if (!(strcmp("FAME",script1))) chars[c].fame=str2num(script2);
         if (!(strcmp("ID",script1))) {
            tmp=hstr2num(script2);
            chars[c].id1=tmp/256;
            chars[c].id2=tmp%256;
            chars[c].xid1=chars[c].id1;
            chars[c].xid2=chars[c].id2;
         }
         if (!(strcmp("SKIN",script1))) {
            tmp=hstr2num(script2);
            chars[c].skin1=tmp/256;
            chars[c].skin2=tmp%256;
            chars[c].xskin1=chars[c].skin1;
            chars[c].xskin2=chars[c].skin2;
         }
         if (!(strcmp("DIRECTION",script1))) {
            if (!(strcmp("NE",script2))) chars[c].dir=1;
            if (!(strcmp("E",script2))) chars[c].dir=2;
            if (!(strcmp("SE",script2))) chars[c].dir=3;
            if (!(strcmp("S",script2))) chars[c].dir=4;
            if (!(strcmp("SW",script2))) chars[c].dir=5;
            if (!(strcmp("W",script2))) chars[c].dir=6;
            if (!(strcmp("NW",script2))) chars[c].dir=7;
            if (!(strcmp("N",script2))) chars[c].dir=0;
         }
         if (!(strcmp("BACKPACK", script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].ser1==chars[c].ser1 &&
                      items[z].ser2==chars[c].ser2 &&
                      items[z].ser3==chars[c].ser3 &&
                      items[z].ser4==chars[c].ser4 &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack==-1)
             {
               chars[c].packitem=n=SpawnItem(calcSocketFromChar(c),1,"Backpack",0,0x0E,0x75,0,0,0,0);
               items[n].x=0;
               items[n].y=0;
               items[n].z=0;
               setserial(n,c,4);
               items[n].layer=0x15;
               items[n].type=1;
               items[n].dye=1;
               mypack=n;
               retitem=n;
            }
         }
         if (!(strcmp("GOLD", script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].ser1==chars[c].ser1 &&
                      items[z].ser2==chars[c].ser2 &&
                      items[z].ser3==chars[c].ser3 &&
                      items[z].ser4==chars[c].ser4 &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack!=-1) 
             {
               n=SpawnItem(calcSocketFromChar(c),1,"#",1,0x0E,0xED,0,0,1,0);

               items[n].priv=items[n].priv|0x01;
               gettokennum(script2, 0);
               lovalue=str2num(gettokenstr);
               gettokennum(script2, 1);
               hivalue=str2num(gettokenstr);
               if (hivalue==0) {
                  items[n].amount=lovalue/2 + (rand()%(lovalue/2));
               } else {
                  items[n].amount=lovalue + (rand()%(hivalue-lovalue));
               }
               setserial(n,mypack,1);
            } else {
               printf("Warning: Bad NPC Script %d with problem no backpack for gold.\n", x);
            }
         }
         if (!(strcmp("LOOT",script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].ser1==chars[c].ser1 &&
                      items[z].ser2==chars[c].ser2 &&
                      items[z].ser3==chars[c].ser3 &&
                      items[z].ser4==chars[c].ser4 &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack!=-1) {
               sprintf(rndlootlist, "%s", script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addrandomloot(mypack, rndlootlist);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no backpack for loot.\n", x);
            }
         }
         if (!(strcmp("ITEM",script1))) {
            storeval=str2num(script2);
            pos=ftell(scpfile);
            closescript();
            retitem=addmenutarget(-1, 0, storeval);
            openscript("npc.scp");
            fseek(scpfile, pos, SEEK_SET);
            if (retitem!=-1)
						{
							setserial(retitem,c,4);
							if (items[retitem].layer==0) {
               printf("Warning: Bad NPC Script %d with problem item %d executed!\n", x, storeval);
							}
						}
            sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
         }
         if (!(strcmp("SHOPKEEPER", script1))) makeshop(c);
         if (!(strcmp("RSHOPITEM",script1))) {
            if (shoppack1==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].cont1==chars[c].ser1 &&
                      items[z].cont2==chars[c].ser2 &&
                      items[z].cont3==chars[c].ser3 &&
                      items[z].cont4==chars[c].ser4 &&
                      items[z].layer==0x1A) {
                     shoppack1=z;
                     break;
                  }
               }
            }
            if (shoppack1!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,shoppack1,1);
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no shoppack1 for item.\n", x);
            }
         }
         if (!(strcmp("VALUE",script1))) if (retitem!=-1) items[retitem].value=(str2num(script2));
         if (!(strcmp("SELLITEM",script1))) {
            if (shoppack3==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].cont1==chars[c].ser1 &&
                      items[z].cont2==chars[c].ser2 &&
                      items[z].cont3==chars[c].ser3 &&
                      items[z].cont4==chars[c].ser4 &&
                      items[z].layer==0x1C) {
                     shoppack3=z;
                     break;
                  }
               }
            }
            if (shoppack3!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,shoppack3,1);
								items[retitem].value=items[retitem].value/2;
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no shoppack3 for item.\n", x);
            }
         }
         if (!(strcmp("SHOPITEM",script1))) {
            if (shoppack2==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].cont1==chars[c].ser1 &&
                      items[z].cont2==chars[c].ser2 &&
                      items[z].cont3==chars[c].ser3 &&
                      items[z].cont4==chars[c].ser4 &&
                      items[z].layer==0x1B) {
                     shoppack2=z;
                     break;
                  }
               }
            }
            if (shoppack2!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,shoppack2,1);
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no shoppack2 for item.\n", x);
            }
         }
         if (!(strcmp("PACKITEM",script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].ser1==chars[c].ser1 &&
                      items[z].ser2==chars[c].ser2 &&
                      items[z].ser3==chars[c].ser3 &&
                      items[z].ser4==chars[c].ser4 &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,mypack,1);
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no backpack for packitem.\n", x);
            }
         }
         if (!(strcmp("COLOR",script1))) {
            items[retitem].color1=(hstr2num(script2))/256;
            items[retitem].color2=(hstr2num(script2))%256;
         }
         if (!(strcmp("SAYCOLOR",script1))) {
            chars[c].saycolor1=(hstr2num(script2))/256;
            chars[c].saycolor2=(hstr2num(script2))%256;
         }
         if (!(strcmp("EMOTECOLOR",script1))) {
            chars[c].emotecolor1=(hstr2num(script2))/256;
            chars[c].emotecolor2=(hstr2num(script2))%256;
         }
         if (!(strcmp("PRIV1",script1))) chars[c].priv=str2num(script2);
         if (!(strcmp("PRIV2",script1))) chars[c].priv2=str2num(script2);
         if (!(strcmp("SPEECH",script1))) chars[c].speech=str2num(script2);
         if (!(strcmp("NPCWANDER",script1))) chars[c].npcWander=str2num(script2);
         if (!(strcmp("FX1",script1))) chars[c].fx1=chars[c].x+str2num(script2);  // new NPCWANDER implementation
         if (!(strcmp("FX2",script1))) chars[c].fx2=chars[c].x+str2num(script2);
         if (!(strcmp("FY1",script1))) chars[c].fy1=chars[c].y+str2num(script2);
         if (!(strcmp("FY2",script1))) chars[c].fy2=chars[c].y+str2num(script2);
         if (!(strcmp("FZ1",script1))) chars[c].fz1=chars[c].z+str2num(script2);
         if (!(strcmp("NPCAI",script1))) chars[c].npcaitype=hstr2num(script2);
         if (!(strcmp("SPATTACK",script1))) chars[c].spattack=str2num(script2);
         if (!(strcmp("SPADELAY",script1))) chars[c].spadelay=str2num(script2);
         if (!(strcmp("POISON",script1))) chars[c].poison=str2num(script2);
         if (!(strcmp("FLEEAT",script1))) chars[c].fleeat=str2num(script2);
         if (!(strcmp("REATTACKAT",script1))) chars[c].reattackat=str2num(script2);
         if (!(strcmp(script1, "SPLIT"))) chars[c].split=str2num(script2);
         if (!(strcmp(script1, "SPLITCHANCE"))) chars[c].splitchnc=str2num(script2);
// When NPCs can either tame or teach the taming skill, uncomment the
// following line, and delete the next one after it.
//         if (!(strcmp("TOTAME", script1))) chars[c].taming=str2num(script2);
         if ((!(strcmp("TOTAME", script1)))||(!(strcmp("TAMING", script1)))) chars[c].taming=str2num(script2);

         //--------------------- NEW STAT & SKILL FORMAT ----------------
         //Handle Stats
            if ((!(strcmp("STR",script1)))||(!(strcmp("STRENGTH",script1)))) {
               chars[c].st  = getstatskillvalue(script2);
               chars[c].st2 = chars[c].st;
               chars[c].hp  = chars[c].st;
            }
            if ((!(strcmp("DEX",script1)))||(!(strcmp("DEXTERITY",script1)))) {
               chars[c].dx  = getstatskillvalue(script2);
               chars[c].dx2 = chars[c].dx;
               chars[c].stm = chars[c].dx;
            }
            if ((!(strcmp("INT",script1)))||(!(strcmp("INTELLIGENCE",script1)))) {
               chars[c].in  = getstatskillvalue(script2);
               chars[c].in2 = chars[c].in;
               chars[c].mn  = chars[c].in;
            }
         //Done Handling Stats
         //Handle Skills
            if ((!(strcmp("ALCHEMY",script1)))||(!(strcmp("SKILL0",script1)))) chars[c].baseskill[ALCHEMY] = getstatskillvalue(script2);
            if ((!(strcmp("ANATOMY",script1)))||(!(strcmp("SKILL1",script1)))) chars[c].baseskill[ANATOMY] = getstatskillvalue(script2);
            if ((!(strcmp("ANIMALLORE",script1)))||(!(strcmp("SKILL2",script1)))) chars[c].baseskill[ANIMALLORE] = getstatskillvalue(script2);
            if ((!(strcmp("ITEMID",script1)))||(!(strcmp("SKILL3",script1)))) chars[c].baseskill[ITEMID] = getstatskillvalue(script2);
            if ((!(strcmp("ARMSLORE",script1)))||(!(strcmp("SKILL4",script1)))) chars[c].baseskill[ARMSLORE] = getstatskillvalue(script2);
            if ((!(strcmp("PARRYING",script1)))||(!(strcmp("SKILL5",script1)))) chars[c].baseskill[PARRYING] = getstatskillvalue(script2);
            if ((!(strcmp("BEGGING",script1)))||(!(strcmp("SKILL6",script1)))) chars[c].baseskill[BEGGING] = getstatskillvalue(script2);
            if ((!(strcmp("BLACKSMITHING",script1)))||(!(strcmp("SKILL7",script1)))) chars[c].baseskill[BLACKSMITHING] = getstatskillvalue(script2);
            if ((!(strcmp("BOWCRAFT",script1)))||(!(strcmp("SKILL8",script1)))) chars[c].baseskill[BOWCRAFT] = getstatskillvalue(script2);
            if ((!(strcmp("PEACEMAKING",script1)))||(!(strcmp("SKILL9",script1)))) chars[c].baseskill[PEACEMAKING] = getstatskillvalue(script2);
            if ((!(strcmp("CAMPING",script1)))||(!(strcmp("SKILL10",script1)))) chars[c].baseskill[CAMPING] = getstatskillvalue(script2);
            if ((!(strcmp("CARPENTRY",script1)))||(!(strcmp("SKILL11",script1)))) chars[c].baseskill[CARPENTRY] = getstatskillvalue(script2);
            if ((!(strcmp("CARTOGRAPHY",script1)))||(!(strcmp("SKILL12",script1)))) chars[c].baseskill[CARTOGRAPHY] = getstatskillvalue(script2);
            if ((!(strcmp("COOKING",script1)))||(!(strcmp("SKILL13",script1)))) chars[c].baseskill[COOKING] = getstatskillvalue(script2);
            if ((!(strcmp("DETECTINGHIDDEN",script1)))||(!(strcmp("SKILL14",script1)))) chars[c].baseskill[DETECTINGHIDDEN] = getstatskillvalue(script2);
            if ((!(strcmp("ENTICEMENT",script1)))||(!(strcmp("SKILL15",script1)))) chars[c].baseskill[ENTICEMENT] = getstatskillvalue(script2);
            if ((!(strcmp("EVALUATINGINTEL",script1)))||(!(strcmp("SKILL16",script1)))) chars[c].baseskill[EVALUATINGINTEL] = getstatskillvalue(script2);
            if ((!(strcmp("HEALING",script1)))||(!(strcmp("SKILL17",script1)))) chars[c].baseskill[HEALING] = getstatskillvalue(script2);
            if ((!(strcmp("FISHING",script1)))||(!(strcmp("SKILL18",script1)))) chars[c].baseskill[FISHING] = getstatskillvalue(script2);
            if ((!(strcmp("FORENSICS",script1)))||(!(strcmp("SKILL19",script1)))) chars[c].baseskill[FORENSICS] = getstatskillvalue(script2);
            if ((!(strcmp("HERDING",script1)))||(!(strcmp("SKILL20",script1)))) chars[c].baseskill[HERDING] = getstatskillvalue(script2);
            if ((!(strcmp("HIDING",script1)))||(!(strcmp("SKILL21",script1)))) chars[c].baseskill[HIDING] = getstatskillvalue(script2);
            if ((!(strcmp("PROVOCATION",script1)))||(!(strcmp("SKILL22",script1)))) chars[c].baseskill[PROVOCATION] = getstatskillvalue(script2);
            if ((!(strcmp("INSCRIPTION",script1)))||(!(strcmp("SKILL23",script1)))) chars[c].baseskill[INSCRIPTION] = getstatskillvalue(script2);
            if ((!(strcmp("LOCKPICKING",script1)))||(!(strcmp("SKILL24",script1)))) chars[c].baseskill[LOCKPICKING] = getstatskillvalue(script2);
            if ((!(strcmp("MAGERY",script1)))||(!(strcmp("SKILL25",script1)))) chars[c].baseskill[MAGERY] = getstatskillvalue(script2);
            if ((!(strcmp("MAGICRESISTANCE",script1)))||(!(strcmp("RESIST",script1)))||(!(strcmp("SKILL26",script1)))) chars[c].baseskill[MAGICRESISTANCE] = getstatskillvalue(script2);
            if ((!(strcmp("TACTICS",script1)))||(!(strcmp("SKILL27",script1)))) chars[c].baseskill[TACTICS] = getstatskillvalue(script2);
            if ((!(strcmp("SNOOPING",script1)))||(!(strcmp("SKILL28",script1)))) chars[c].baseskill[SNOOPING] = getstatskillvalue(script2);
            if ((!(strcmp("MUSICIANSHIP",script1)))||(!(strcmp("SKILL29",script1)))) chars[c].baseskill[MUSICIANSHIP] = getstatskillvalue(script2);
            if ((!(strcmp("POISONING",script1)))||(!(strcmp("SKILL30",script1)))) chars[c].baseskill[POISONING] = getstatskillvalue(script2);
            if ((!(strcmp("ARCHERY",script1)))||(!(strcmp("SKILL31",script1)))) chars[c].baseskill[ARCHERY] = getstatskillvalue(script2);
            if ((!(strcmp("SPIRITSPEAK",script1)))||(!(strcmp("SKILL32",script1)))) chars[c].baseskill[SPIRITSPEAK] = getstatskillvalue(script2);
            if ((!(strcmp("STEALING",script1)))||(!(strcmp("SKILL33",script1)))) chars[c].baseskill[STEALING] = getstatskillvalue(script2);
            if ((!(strcmp("TAILORING",script1)))||(!(strcmp("SKILL34",script1)))) chars[c].baseskill[TAILORING] = getstatskillvalue(script2);
// Taming skill disabled for now for npcs - as they wont be training people
// nor taming things on their own for a while. - Eventually.. when they can
// train players how the taming skill, they themselves will need it.  Then
// it will require use of the "TOTAME" property outlined above.
//            if ((!(strcmp("TAMING",script1)))||(!(strcmp("SKILL35",script1)))) chars[c].baseskill[TAMING] = getstatskillvalue(script2);
            if ((!(strcmp("TASTEID",script1)))||(!(strcmp("SKILL36",script1)))) chars[c].baseskill[TASTEID] = getstatskillvalue(script2);
            if ((!(strcmp("TINKERING",script1)))||(!(strcmp("SKILL37",script1)))) chars[c].baseskill[TINKERING] = getstatskillvalue(script2);
            if ((!(strcmp("TRACKING",script1)))||(!(strcmp("SKILL38",script1)))) chars[c].baseskill[TRACKING] = getstatskillvalue(script2);
            if ((!(strcmp("VETERINARY",script1)))||(!(strcmp("SKILL39",script1)))) chars[c].baseskill[VETERINARY] = getstatskillvalue(script2);
            if ((!(strcmp("SWORDSMANSHIP",script1)))||(!(strcmp("SKILL40",script1)))) chars[c].baseskill[SWORDSMANSHIP] = getstatskillvalue(script2);
            if ((!(strcmp("MACEFIGHTING",script1)))||(!(strcmp("SKILL41",script1)))) chars[c].baseskill[MACEFIGHTING] = getstatskillvalue(script2);
            if ((!(strcmp("FENCING",script1)))||(!(strcmp("SKILL42",script1)))) chars[c].baseskill[FENCING] = getstatskillvalue(script2);
            if ((!(strcmp("WRESTLING",script1)))||(!(strcmp("SKILL43",script1)))) chars[c].baseskill[WRESTLING] = getstatskillvalue(script2);
            if ((!(strcmp("LUMBERJACKING",script1)))||(!(strcmp("SKILL44",script1)))) chars[c].baseskill[LUMBERJACKING] = getstatskillvalue(script2);
            if ((!(strcmp("MINING",script1)))||(!(strcmp("SKILL45",script1)))) chars[c].baseskill[MINING] = getstatskillvalue(script2);
         //Done Handling Skills
         //Handle Extras
            if ((!(strcmp("DAMAGE",script1)))||(!(strcmp("ATT",script1)))) {
               gettokennum(script2, 0);
               lovalue=str2num(gettokenstr);
               gettokennum(script2, 1);
               hivalue=str2num(gettokenstr);
               chars[c].lodamage = lovalue;
               chars[c].hidamage = lovalue;
               if(hivalue) {
                  chars[c].hidamage = hivalue;
               }
            }
				if (!(strcmp(script1, "NOTRAIN"))) chars[x].cantrain=0;
            if (!(strcmp("DEF",script1))) chars[c].def = getstatskillvalue(script2);
         //Done Handling Extras
         //Handle Obsolete Stuff
            if (!(strcmp("LODAMAGE",script1))) chars[c].lodamage=str2num(script2);
            if (!(strcmp("HIDAMAGE",script1))) chars[c].hidamage=str2num(script2);
            if (!(strcmp("SKILL", script1))) {
               gettokennum(script2, 0);
               z=str2num(gettokenstr);
               gettokennum(script2, 1);
               chars[c].baseskill[z]=str2num(gettokenstr);
            }
         //Done Handling Obsolete Stuff
         //--------------- DONE NEW STAT & SKILL FORMAT ---------------------
      }
   }
   while (script1[0]!='}');
   closescript();

	 if (type==1 && triggerx) triggerx=c; //Taur v69.02
   //Now find real 'skill' based on 'baseskill' (stat modifiers)
   for(z=0;z<TRUESKILLS;z++)
	 {
		 updateSkillLevel(c,z);
   }
	 
   if (donpcupdate==0) 
   {
     updatechar(c);
   }
}*/
void addrespawnnpc(int s, int npcNum, int type)
{
   int tmp, z,c,n, lovalue, hivalue, mypack, retitem;
   int storeval, shoppack1, shoppack2, shoppack3;
	 int k=0, xos=0, yos=0;
   char sect[512];
   long int pos;
   char rndlootlist[20];

   mypack=-1;
   retitem=-1;
   storeval=-1;
   shoppack1=-1;
   shoppack2=-1;
   shoppack3=-1;
   //
   // First things first...lets find out what NPC# we should spawn
   //
   openscript("npc.scp");
   sprintf(sect, "NPC %i", npcNum);
   if (!npc_script.find(sect)) {
      closescript();
      return;
   }
   
  do
  {
  	read2();
    if (script1[0]!='}')
    {
    	if (!(strcmp("NPCLIST", script1)))
      {
      	pos=ftell(scpfile);
        closescript();
        if (type==1)
        {
         	npcNum=addrandomnpc(s,script2,1);
         	if (npcNum==-1) return;
        }
        else
        {
         	npcNum=addrandomnpc(s,script2,-1);
         	if (npcNum==-1) return;
        }
        break;  //got the NPC number to add stop reading
      }
    }
	} while (script1[0]!='}');
  closescript();

	//
	// Now lets spawn him/her
	//
   c=memcharfree ();
   initchar(c);
   
   chars[c].priv=0x10;
   chars[c].npc=1;
   chars[c].att=1;
   chars[c].def=1;

   openscript("npc.scp");
   sprintf(sect, "NPC %i", npcNum);
   if (!npc_script.find(sect)) {
      closescript();
      return;
   }
   do {
      read2();
      if (script1[0]!='}') {
         if (!(strcmp("NAME",script1))) sprintf(chars[c].name, "%s", script2);
         if (!(strcmp("NAMELIST", script1))) {
            pos=ftell(scpfile);
            closescript();
            setrandomname(c,script2);
            openscript("npc.scp");
            fseek(scpfile, pos, SEEK_SET);
            sprintf(script1, "DUMMY"); // To prevent accidental exit of loop.
         }
         if (!(strcmp("TITLE",script1))) sprintf(chars[c].title, "%s", script2);
         if (!(strcmp("KARMA",script1))) chars[c].karma=str2num(script2);
         if (!(strcmp("FAME",script1))) chars[c].fame=str2num(script2);
         if (!(strcmp("ID",script1))) {
            tmp=hstr2num(script2);
            chars[c].id1=tmp/256;
            chars[c].id2=tmp%256;
            chars[c].xid1=chars[c].id1;
            chars[c].xid2=chars[c].id2;
         }
         if (!(strcmp("SKIN",script1))) {
            tmp=hstr2num(script2);
            chars[c].skin1=tmp/256;
            chars[c].skin2=tmp%256;
            chars[c].xskin1=chars[c].skin1;
            chars[c].xskin2=chars[c].skin2;
         }
         if (!(strcmp("DIRECTION",script1))) {
            if (!(strcmp("NE",script2))) chars[c].dir=1;
            if (!(strcmp("E",script2))) chars[c].dir=2;
            if (!(strcmp("SE",script2))) chars[c].dir=3;
            if (!(strcmp("S",script2))) chars[c].dir=4;
            if (!(strcmp("SW",script2))) chars[c].dir=5;
            if (!(strcmp("W",script2))) chars[c].dir=6;
            if (!(strcmp("NW",script2))) chars[c].dir=7;
            if (!(strcmp("N",script2))) chars[c].dir=0;
         }
         if (!(strcmp("BACKPACK", script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].serial==chars[c].serial &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack==-1)
             {
               pos=ftell(scpfile);
               closescript();
               chars[c].packitem=n=SpawnItem(calcSocketFromChar(c),1,"Backpack",0,0x0E,0x75,0,0,0,0);
               items[n].x=0;
               items[n].y=0;
               items[n].z=0;
               setserial(n,c,4);
               items[n].layer=0x15;
               items[n].type=1;
               items[n].dye=1;
               mypack=n;
               retitem=n;
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            }
         }
         if (!(strcmp("GOLD", script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].serial==chars[c].serial &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack!=-1) 
             {
               n=SpawnItem(calcSocketFromChar(c),1,"#",1,0x0E,0xED,0,0,1,0);

               items[n].priv=items[n].priv|0x01;
               gettokennum(script2, 0);
               lovalue=str2num(gettokenstr);
               gettokennum(script2, 1);
               hivalue=str2num(gettokenstr);
               if (hivalue==0) {
                  items[n].amount=lovalue/2 + (rand()%(lovalue/2));
               } else {
                  items[n].amount=lovalue + (rand()%(hivalue-lovalue));
               }
               setserial(n,mypack,1);
            } else {
               printf("Warning: Bad NPC Script %d with problem no backpack for gold.\n", npcNum);
            }
         }
         if (!(strcmp("LOOT",script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].serial==chars[c].serial &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack!=-1) {
               sprintf(rndlootlist, "%s", script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addrandomloot(mypack, rndlootlist);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no backpack for loot.\n", npcNum);
            }
         }
         if (!(strcmp("ITEM",script1))) {
            storeval=str2num(script2);
            pos=ftell(scpfile);
            closescript();
            retitem=addmenutarget(-1, 0, storeval);
            openscript("npc.scp");
            fseek(scpfile, pos, SEEK_SET);
            if (retitem!=-1)
						{
							setserial(retitem,c,4);
							if (items[retitem].layer==0) {
               printf("Warning: Bad NPC Script %d with problem item %d executed!\n", npcNum, storeval);
							}
						}
            sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
         }
         if (!(strcmp("SHOPKEEPER", script1))) makeshop(c);
         if (!(strcmp("RSHOPITEM",script1))) {
            if (shoppack1==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].contserial==chars[c].serial &&
                      items[z].layer==0x1A) {
                     shoppack1=z;
                     break;
                  }
               }
            }
            if (shoppack1!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,shoppack1,1);
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no shoppack1 for item.\n", npcNum);
            }
         }
         if (!(strcmp("VALUE",script1))) if (retitem!=-1) items[retitem].value=(str2num(script2));
         if (!(strcmp("SELLITEM",script1))) {
            if (shoppack3==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].contserial==chars[c].serial &&
                      items[z].layer==0x1C) {
                     shoppack3=z;
                     break;
                  }
               }
            }
            if (shoppack3!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,shoppack3,1);
								items[retitem].value=items[retitem].value/2;
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no shoppack3 for item.\n", npcNum);
            }
         }
         if (!(strcmp("SHOPITEM",script1))) {
            if (shoppack2==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].cont1==chars[c].ser1 &&
                      items[z].cont2==chars[c].ser2 &&
                      items[z].cont3==chars[c].ser3 &&
                      items[z].cont4==chars[c].ser4 &&
                      items[z].layer==0x1B) {
                     shoppack2=z;
                     break;
                  }
               }
            }
            if (shoppack2!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,shoppack2,1);
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no shoppack2 for item.\n", npcNum);
            }
         }
         if (!(strcmp("PACKITEM",script1))) {
            if (mypack==-1) {
               for(z=0;z<itemcount;z++) {
                  if (items[z].ser1==chars[c].ser1 &&
                      items[z].ser2==chars[c].ser2 &&
                      items[z].ser3==chars[c].ser3 &&
                      items[z].ser4==chars[c].ser4 &&
                      items[z].layer==0x15) {
                     mypack=z;
                     break;
                  }
               }
            }
            if (mypack!=-1) {
               storeval=str2num(script2);
               pos=ftell(scpfile);
               closescript();
               retitem=addmenutarget(-1, 0, storeval);
               openscript("npc.scp");
               fseek(scpfile, pos, SEEK_SET);
               if (retitem!=-1)
							 {
								setserial(retitem,mypack,1);
								items[retitem].x=50+(rand()%80);
								items[retitem].y=50+(rand()%80);
								items[retitem].z=9;
							 }
               sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
            } else {
               printf("Warning: Bad NPC Script %d with problem no backpack for packitem.\n", npcNum);
            }
         }
         if (!(strcmp("COLOR",script1))) {
            items[retitem].color1=(hstr2num(script2))/256;
            items[retitem].color2=(hstr2num(script2))%256;
         }
         if (!(strcmp("SAYCOLOR",script1))) {
            chars[c].saycolor1=(hstr2num(script2))/256;
            chars[c].saycolor2=(hstr2num(script2))%256;
         }
         if (!(strcmp("EMOTECOLOR",script1))) {
            chars[c].emotecolor1=(hstr2num(script2))/256;
            chars[c].emotecolor2=(hstr2num(script2))%256;
         }
         if (!(strcmp("PRIV1",script1))) chars[c].priv=str2num(script2);
         if (!(strcmp("PRIV2",script1))) chars[c].priv2=str2num(script2);
         if (!(strcmp("SPEECH",script1))) chars[c].speech=str2num(script2);
         if (!(strcmp("NPCWANDER",script1))) chars[c].npcWander=str2num(script2);
         if (!(strcmp("FX1",script1))) chars[c].fx1=chars[c].x+str2num(script2);  // new NPCWANDER implementation
         if (!(strcmp("FX2",script1))) chars[c].fx2=chars[c].x+str2num(script2);
         if (!(strcmp("FY1",script1))) chars[c].fy1=chars[c].y+str2num(script2);
         if (!(strcmp("FY2",script1))) chars[c].fy2=chars[c].y+str2num(script2);
         if (!(strcmp("FZ1",script1))) chars[c].fz1=chars[c].z+str2num(script2);
         if (!(strcmp("NPCAI",script1))) chars[c].npcaitype=hstr2num(script2);
         if (!(strcmp("SPATTACK",script1))) chars[c].spattack=str2num(script2);
         if (!(strcmp("SPADELAY",script1))) chars[c].spadelay=str2num(script2);
         if (!(strcmp("POISON",script1))) chars[c].poison=str2num(script2);
         if (!(strcmp("FLEEAT",script1))) chars[c].fleeat=str2num(script2);
         if (!(strcmp("REATTACKAT",script1))) chars[c].reattackat=str2num(script2);
         if (!(strcmp(script1, "SPLIT"))) chars[c].split=str2num(script2);
         if (!(strcmp(script1, "SPLITCHANCE"))) chars[c].splitchnc=str2num(script2);
// When NPCs can either tame or teach the taming skill, uncomment the
// following line, and delete the next one after it.
//         if (!(strcmp("TOTAME", script1))) chars[c].taming=str2num(script2);
         if ((!(strcmp("TOTAME", script1)))||(!(strcmp("TAMING", script1)))) chars[c].taming=str2num(script2);

         //--------------------- NEW STAT & SKILL FORMAT ----------------
         //Handle Stats
            if ((!(strcmp("STR",script1)))||(!(strcmp("STRENGTH",script1)))) {
               chars[c].st  = getstatskillvalue(script2);
               chars[c].st2 = chars[c].st;
               chars[c].hp  = chars[c].st;
            }
            if ((!(strcmp("DEX",script1)))||(!(strcmp("DEXTERITY",script1)))) {
               chars[c].dx  = getstatskillvalue(script2);
               chars[c].dx2 = chars[c].dx;
               chars[c].stm = chars[c].dx;
            }
            if ((!(strcmp("INT",script1)))||(!(strcmp("INTELLIGENCE",script1)))) {
               chars[c].in  = getstatskillvalue(script2);
               chars[c].in2 = chars[c].in;
               chars[c].mn  = chars[c].in;
            }
         //Done Handling Stats
         //Handle Skills
            if ((!(strcmp("ALCHEMY",script1)))||(!(strcmp("SKILL0",script1)))) chars[c].baseskill[ALCHEMY] = getstatskillvalue(script2);
            if ((!(strcmp("ANATOMY",script1)))||(!(strcmp("SKILL1",script1)))) chars[c].baseskill[ANATOMY] = getstatskillvalue(script2);
            if ((!(strcmp("ANIMALLORE",script1)))||(!(strcmp("SKILL2",script1)))) chars[c].baseskill[ANIMALLORE] = getstatskillvalue(script2);
            if ((!(strcmp("ITEMID",script1)))||(!(strcmp("SKILL3",script1)))) chars[c].baseskill[ITEMID] = getstatskillvalue(script2);
            if ((!(strcmp("ARMSLORE",script1)))||(!(strcmp("SKILL4",script1)))) chars[c].baseskill[ARMSLORE] = getstatskillvalue(script2);
            if ((!(strcmp("PARRYING",script1)))||(!(strcmp("SKILL5",script1)))) chars[c].baseskill[PARRYING] = getstatskillvalue(script2);
            if ((!(strcmp("BEGGING",script1)))||(!(strcmp("SKILL6",script1)))) chars[c].baseskill[BEGGING] = getstatskillvalue(script2);
            if ((!(strcmp("BLACKSMITHING",script1)))||(!(strcmp("SKILL7",script1)))) chars[c].baseskill[BLACKSMITHING] = getstatskillvalue(script2);
            if ((!(strcmp("BOWCRAFT",script1)))||(!(strcmp("SKILL8",script1)))) chars[c].baseskill[BOWCRAFT] = getstatskillvalue(script2);
            if ((!(strcmp("PEACEMAKING",script1)))||(!(strcmp("SKILL9",script1)))) chars[c].baseskill[PEACEMAKING] = getstatskillvalue(script2);
            if ((!(strcmp("CAMPING",script1)))||(!(strcmp("SKILL10",script1)))) chars[c].baseskill[CAMPING] = getstatskillvalue(script2);
            if ((!(strcmp("CARPENTRY",script1)))||(!(strcmp("SKILL11",script1)))) chars[c].baseskill[CARPENTRY] = getstatskillvalue(script2);
            if ((!(strcmp("CARTOGRAPHY",script1)))||(!(strcmp("SKILL12",script1)))) chars[c].baseskill[CARTOGRAPHY] = getstatskillvalue(script2);
            if ((!(strcmp("COOKING",script1)))||(!(strcmp("SKILL13",script1)))) chars[c].baseskill[COOKING] = getstatskillvalue(script2);
            if ((!(strcmp("DETECTINGHIDDEN",script1)))||(!(strcmp("SKILL14",script1)))) chars[c].baseskill[DETECTINGHIDDEN] = getstatskillvalue(script2);
            if ((!(strcmp("ENTICEMENT",script1)))||(!(strcmp("SKILL15",script1)))) chars[c].baseskill[ENTICEMENT] = getstatskillvalue(script2);
            if ((!(strcmp("EVALUATINGINTEL",script1)))||(!(strcmp("SKILL16",script1)))) chars[c].baseskill[EVALUATINGINTEL] = getstatskillvalue(script2);
            if ((!(strcmp("HEALING",script1)))||(!(strcmp("SKILL17",script1)))) chars[c].baseskill[HEALING] = getstatskillvalue(script2);
            if ((!(strcmp("FISHING",script1)))||(!(strcmp("SKILL18",script1)))) chars[c].baseskill[FISHING] = getstatskillvalue(script2);
            if ((!(strcmp("FORENSICS",script1)))||(!(strcmp("SKILL19",script1)))) chars[c].baseskill[FORENSICS] = getstatskillvalue(script2);
            if ((!(strcmp("HERDING",script1)))||(!(strcmp("SKILL20",script1)))) chars[c].baseskill[HERDING] = getstatskillvalue(script2);
            if ((!(strcmp("HIDING",script1)))||(!(strcmp("SKILL21",script1)))) chars[c].baseskill[HIDING] = getstatskillvalue(script2);
            if ((!(strcmp("PROVOCATION",script1)))||(!(strcmp("SKILL22",script1)))) chars[c].baseskill[PROVOCATION] = getstatskillvalue(script2);
            if ((!(strcmp("INSCRIPTION",script1)))||(!(strcmp("SKILL23",script1)))) chars[c].baseskill[INSCRIPTION] = getstatskillvalue(script2);
            if ((!(strcmp("LOCKPICKING",script1)))||(!(strcmp("SKILL24",script1)))) chars[c].baseskill[LOCKPICKING] = getstatskillvalue(script2);
            if ((!(strcmp("MAGERY",script1)))||(!(strcmp("SKILL25",script1)))) chars[c].baseskill[MAGERY] = getstatskillvalue(script2);
            if ((!(strcmp("MAGICRESISTANCE",script1)))||(!(strcmp("RESIST",script1)))||(!(strcmp("SKILL26",script1)))) chars[c].baseskill[MAGICRESISTANCE] = getstatskillvalue(script2);
            if ((!(strcmp("TACTICS",script1)))||(!(strcmp("SKILL27",script1)))) chars[c].baseskill[TACTICS] = getstatskillvalue(script2);
            if ((!(strcmp("SNOOPING",script1)))||(!(strcmp("SKILL28",script1)))) chars[c].baseskill[SNOOPING] = getstatskillvalue(script2);
            if ((!(strcmp("MUSICIANSHIP",script1)))||(!(strcmp("SKILL29",script1)))) chars[c].baseskill[MUSICIANSHIP] = getstatskillvalue(script2);
            if ((!(strcmp("POISONING",script1)))||(!(strcmp("SKILL30",script1)))) chars[c].baseskill[POISONING] = getstatskillvalue(script2);
            if ((!(strcmp("ARCHERY",script1)))||(!(strcmp("SKILL31",script1)))) chars[c].baseskill[ARCHERY] = getstatskillvalue(script2);
            if ((!(strcmp("SPIRITSPEAK",script1)))||(!(strcmp("SKILL32",script1)))) chars[c].baseskill[SPIRITSPEAK] = getstatskillvalue(script2);
            if ((!(strcmp("STEALING",script1)))||(!(strcmp("SKILL33",script1)))) chars[c].baseskill[STEALING] = getstatskillvalue(script2);
            if ((!(strcmp("TAILORING",script1)))||(!(strcmp("SKILL34",script1)))) chars[c].baseskill[TAILORING] = getstatskillvalue(script2);
            if ((!(strcmp("TAMING",script1)))||(!(strcmp("SKILL35",script1)))) chars[c].baseskill[TAMING] = getstatskillvalue(script2);
            if ((!(strcmp("TASTEID",script1)))||(!(strcmp("SKILL36",script1)))) chars[c].baseskill[TASTEID] = getstatskillvalue(script2);
            if ((!(strcmp("TINKERING",script1)))||(!(strcmp("SKILL37",script1)))) chars[c].baseskill[TINKERING] = getstatskillvalue(script2);
            if ((!(strcmp("TRACKING",script1)))||(!(strcmp("SKILL38",script1)))) chars[c].baseskill[TRACKING] = getstatskillvalue(script2);
            if ((!(strcmp("VETERINARY",script1)))||(!(strcmp("SKILL39",script1)))) chars[c].baseskill[VETERINARY] = getstatskillvalue(script2);
            if ((!(strcmp("SWORDSMANSHIP",script1)))||(!(strcmp("SKILL40",script1)))) chars[c].baseskill[SWORDSMANSHIP] = getstatskillvalue(script2);
            if ((!(strcmp("MACEFIGHTING",script1)))||(!(strcmp("SKILL41",script1)))) chars[c].baseskill[MACEFIGHTING] = getstatskillvalue(script2);
            if ((!(strcmp("FENCING",script1)))||(!(strcmp("SKILL42",script1)))) chars[c].baseskill[FENCING] = getstatskillvalue(script2);
            if ((!(strcmp("WRESTLING",script1)))||(!(strcmp("SKILL43",script1)))) chars[c].baseskill[WRESTLING] = getstatskillvalue(script2);
            if ((!(strcmp("LUMBERJACKING",script1)))||(!(strcmp("SKILL44",script1)))) chars[c].baseskill[LUMBERJACKING] = getstatskillvalue(script2);
            if ((!(strcmp("MINING",script1)))||(!(strcmp("SKILL45",script1)))) chars[c].baseskill[MINING] = getstatskillvalue(script2);
         //Done Handling Skills
         //Handle Extras
            if ((!(strcmp("DAMAGE",script1)))||(!(strcmp("ATT",script1)))) {
               gettokennum(script2, 0);
               lovalue=str2num(gettokenstr);
               gettokennum(script2, 1);
               hivalue=str2num(gettokenstr);
               chars[c].lodamage = lovalue;
               chars[c].hidamage = lovalue;
               if(hivalue) {
                  chars[c].hidamage = hivalue;
               }
            }
				if (!(strcmp(script1, "NOTRAIN"))) chars[c].cantrain=0;
            if (!(strcmp("DEF",script1))) chars[c].def = getstatskillvalue(script2);
         //Done Handling Extras
         //Handle Obsolete Stuff
            if (!(strcmp("LODAMAGE",script1))) chars[c].lodamage=str2num(script2);
            if (!(strcmp("HIDAMAGE",script1))) chars[c].hidamage=str2num(script2);
            if (!(strcmp("SKILL", script1))) {
               gettokennum(script2, 0);
               z=str2num(gettokenstr);
               gettokennum(script2, 1);
               chars[c].baseskill[z]=str2num(gettokenstr);
            }
         //Done Handling Obsolete Stuff
         //--------------- DONE NEW STAT & SKILL FORMAT ---------------------
      }
   }
   while (script1[0]!='}');
   closescript();

	// Now that we have created the NPC, lets place him
   if (type==1) {
     if (triggerx)
     {
       chars[c].x=triggerx;
       chars[c].y=triggery;
       chars[c].dispz=chars[c].z=triggerz;
       triggerx=c;
     } else {
 	   /*Zippy's Code chages for area spawns --> (Type 69) xos and yos (X OffSet, Y OffSet) 
		 are used to find a random number that is then added to the spawner's x and y (Using 
		 the spawner's z) and then place the NPC anywhere in a square around the spawner. 
		 This square is random anywhere from -10 to +10 from the spawner's location (for x and 
		 y) If the place chosen is not a valid position (the NPC can't walk there) then a new 
		 place will be chosen, if a valid place cannot be found in a certain # of tries (50), 
		 the NPC will be placed directly on the spawner and the server op will be warned. */
			 
			 if ((items[s].type==69)&&(items[s].contserial==-1))
			 {
				 if (items[s].more3==0) items[s].more3=10;
				 if (items[s].more4==0) items[s].more4=10;
				 do
				 {
					 if (k>=50) //this CAN be a bit laggy. adjust as nessicary
					 {
						 printf("UOX3: Problem area spawner found at [%i,%i,%i]. NPC placed at default location.\n",items[s].x,items[s].y,items[s].z);
						 xos=0;
						 yos=0;
						 break;
					 }
					 xos=RandomNum(-items[s].more3,items[s].more3);
					 yos=RandomNum(-items[s].more4,items[s].more4);
					 //printf("Spawning at Offset %i,%i (%i,%i,%i) [-%s,%s <-> -%s,%s]. [Loop #: %i]\n",xos,yos,items[s].x+xos,items[s].y+yos,items[s].z,items[s].more3,items[s].more3,items[s].more4,items[s].more4,k);
					 k++;
				 } while (!validNPCMove(items[s].x+xos,items[s].y+yos,items[s].z,c));
			 } // end Zippy's changes (exept for all the +xos and +yos around here....)
       if (chars[c].fx1==-1)
       {
         chars[c].fx1=items[s].x+xos;
         chars[c].fy1=items[s].y+yos;
         if (chars[c].fz1!=-1) chars[c].fz1=items[s].z;
       }
       chars[c].x=items[s].x+xos;
       chars[c].y=items[s].y+yos;
       chars[c].dispz=chars[c].z=items[s].z;
       setserial(c,s,6);
     }
   } else {
     if (chars[c].fx1==-1)
     {
       chars[c].fx1=(buffer[s][11]*256)+buffer[s][12]+xos;
       chars[c].fy1=(buffer[s][13]*256)+buffer[s][14]+yos;
       if (chars[c].fz1!=-1) chars[c].fz1=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
     }
     chars[c].x=(buffer[s][11]*256)+buffer[s][12]+xos;
     chars[c].y=(buffer[s][13]*256)+buffer[s][14]+yos;
     chars[c].dispz=chars[c].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
   }

   chars[c].region=calcRegionFromXY(chars[c].x, chars[c].y);

   //Now find real 'skill' based on 'baseskill' (stat modifiers)
   for(z=0;z<TRUESKILLS;z++)
	 {
		 updateSkillLevel(c,z);
   }
	 
   if (donpcupdate==0) 
   {
     updatechar(c);
   }
}

// clock() is supposed to return CPU time used - it doesn't on Windows, but
// does on Linux. Thus it doesn't go up on Linux, and time seems to stand
// still. This function emulates clock()
#ifndef __NT__
unsigned long int getclock()
        {
    struct timeval tv;
    gettimeofday(&tv, NULL);
        // We want to keep the value within 32 bits; we could also substract
        // startup time I suppose
    return ((tv.tv_sec - 900000000) * CLOCKS_PER_SEC) +
        tv.tv_usec / (1000000 / CLOCKS_PER_SEC);
        }
#endif

void staticeffect(int player, char eff1, char eff2, char speed, char loop)
{
 char effect[29];
 int i, j;
 for (i=0;i<29;i++)
 {
  effect[i]=0;
 }
 effect[0]=0x70; // Effect message
 effect[1]=0x03; // Static effect
 effect[2]=chars[player].ser1;
 effect[3]=chars[player].ser2;
 effect[4]=chars[player].ser3;
 effect[5]=chars[player].ser4;
 //[6] to [9] are the target ser, not applicable here.
 effect[10]=eff1;// Object id of the effect
 effect[11]=eff2;
 effect[12]=chars[player].x/256;
 effect[13]=chars[player].x%256;
 effect[14]=chars[player].y/256;
 effect[15]=chars[player].y%256;
 effect[16]=chars[player].z;
 //[17] to [21] are the target's position, not applicable here.
 effect[22]=speed;
 effect[23]=loop; // 0 is really long.  1 is the shortest.
 effect[24]=0; // This value is unknown
 effect[25]=0; // This value is unknown
 effect[26]=0; // This value is unknown
 effect[27]=0; // This value is used for moving effects that explode on impact.
 for (j=0;j<now;j++)
 {
  if ((inrange1p(currchar[j],player))&&(perm[j]))
  {
   xsend(j, effect, 28, 0);
  }
 }
}

// staticeffect2 is for effects on items
void staticeffect2(int nItem, char eff1, char eff2, char speed, char loop, char explode)
{
 char effect[29];
 int i, j;
 for (i=0;i<29;i++)
 {
  effect[i]=0;
 }
 effect[0]=0x70; // Effect message
 effect[1]=0x02; // Static effect
 effect[2]=items[nItem].ser1;
 effect[3]=items[nItem].ser2;
 effect[4]=items[nItem].ser3;
 effect[5]=items[nItem].ser4;
 effect[6]=items[nItem].ser1;
 effect[7]=items[nItem].ser2;
 effect[8]=items[nItem].ser3;
 effect[9]=items[nItem].ser4;
 //[6] to [9] are the target ser, not applicable here.
 effect[10]=eff1;// Object id of the effect
 effect[11]=eff2;
 effect[12]=items[nItem].x/256;
 effect[13]=items[nItem].x%256;
 effect[14]=items[nItem].y/256;
 effect[15]=items[nItem].y%256;
 effect[16]=items[nItem].z;
 effect[17]=items[nItem].x/256;
 effect[18]=items[nItem].x%256;
 effect[19]=items[nItem].y/256;
 effect[20]=items[nItem].y%256;
 effect[21]=items[nItem].z;
 //[17] to [21] are the target's position, not applicable here.
 effect[22]=speed;
 effect[23]=loop; // 0 is really long.  1 is the shortest.
 effect[24]=0; // This value is unknown
 effect[25]=0; // This value is unknown
 effect[26]=0; // This value is unknown
 effect[27]=explode; // This value is used for moving effects that explode on impact.
 for (j=0;j<now;j++)
 {  // if inrange of effect and online send effect
  if (inrange2(j,nItem) && perm[j])
  {
   xsend(j, effect, 28, 0);
  }
 }
}

void bolteffect(int player)
{
 char effect[29];
 int i, j;
 for (i=0;i<29;i++)
 {
  effect[i]=0;
 }
 effect[0]=0x70; // Effect message
 effect[1]=0x01; // Bolt effect
 effect[2]=chars[player].ser1;
 effect[3]=chars[player].ser2;
 effect[4]=chars[player].ser3;
 effect[5]=chars[player].ser4;
 //[6] to [11] are  not applicable here.
 effect[12]=chars[player].x/256;
 effect[13]=chars[player].x%256;
 effect[14]=chars[player].y/256;
 effect[15]=chars[player].y%256;
 effect[16]=chars[player].z;
 //[17] to [27] are not applicable here.
 for (j=0;j<now;j++)
 {
  if ((inrange1p(currchar[j],player))&&(perm[j]))
  {
   xsend(j, effect, 28, 0);
  }
 }
}

void movingeffect(int source, int dest, char eff1, char eff2, char speed, char loop, char explode)
{
 //0x0f 0x42 = arrow 0x1b 0xfe=bolt
 char effect[29];
 int i, j;
 for (i=0;i<29;i++)
 {
  effect[i]=0;
 }
 effect[0]=0x70; // Effect message
 effect[1]=0x00; // Moving effect
 effect[2]=chars[source].ser1;
 effect[3]=chars[source].ser2;
 effect[4]=chars[source].ser3;
 effect[5]=chars[source].ser4;
 effect[6]=chars[dest].ser1;
 effect[7]=chars[dest].ser2;
 effect[8]=chars[dest].ser3;
 effect[9]=chars[dest].ser4;
 effect[10]=eff1;// Object id of the effect
 effect[11]=eff2;
 effect[12]=chars[source].x/256;
 effect[13]=chars[source].x%256;
 effect[14]=chars[source].y/256;
 effect[15]=chars[source].y%256;
 effect[16]=chars[source].z;
 effect[17]=chars[dest].x/256;
 effect[18]=chars[dest].x%256;
 effect[19]=chars[dest].y/256;
 effect[20]=chars[dest].y%256;
 effect[21]=chars[dest].z;
 effect[22]=speed;
 effect[23]=loop; // 0 is really long.  1 is the shortest.
 effect[24]=0; // This value is unknown
 effect[25]=0; // This value is unknown
 effect[26]=0; // This value is unknown
 effect[27]=explode; // This value is used for moving effects that explode on impact.
 for (j=0;j<now;j++)
 {
  if ((inrange1p(currchar[j],source))&&(inrange1p(currchar[j],dest))&&(perm[j]))
  {
   xsend(j, effect, 28, 0);
  }
 }
}

//	- Movingeffect2 is used to send an object from a char
//    to another object (like purple potions)
void movingeffect2(int source, int dest, char eff1, char eff2, char speed, char loop, char explode)
{
 //0x0f 0x42 = arrow 0x1b 0xfe=bolt
 char effect[29];
 int i, j;
 for (i=0;i<29;i++)
 {
  effect[i]=0;
 }
 effect[0]=0x70; // Effect message
 effect[1]=0x00; // Moving effect
 effect[2]=chars[source].ser1;
 effect[3]=chars[source].ser2;
 effect[4]=chars[source].ser3;
 effect[5]=chars[source].ser4;
 effect[6]=items[dest].ser1;
 effect[7]=items[dest].ser2;
 effect[8]=items[dest].ser3;
 effect[9]=items[dest].ser4;
 effect[10]=eff1;// Object id of the effect
 effect[11]=eff2;
 effect[12]=chars[source].x/256;
 effect[13]=chars[source].x%256;
 effect[14]=chars[source].y/256;
 effect[15]=chars[source].y%256;
 effect[16]=chars[source].z;
 effect[17]=items[dest].x/256;
 effect[18]=items[dest].x%256;
 effect[19]=items[dest].y/256;
 effect[20]=items[dest].y%256;
 effect[21]=items[dest].z;
 effect[22]=speed;
 effect[23]=loop; // 0 is really long.  1 is the shortest.
 effect[24]=0; // This value is unknown
 effect[25]=0; // This value is unknown
 effect[26]=0; // This value is unknown
 effect[27]=explode; // This value is used for moving effects that explode on impact.
 for (j=0;j<now;j++)
 {   // - If in range of source person or destination position and online send effect
  if ((inrange1p(currchar[j],source) || inrange2(j,dest)) && (perm[j]))
  {
   xsend(j, effect, 28, 0);
  }
 }
}

void axetarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;

 if (((buffer[s][0x11]==0x0C)&&
      ((buffer[s][0x12]==0xD0)||(buffer[s][0x12]==0xD3)||(buffer[s][0x12]==0xD6)||
       (buffer[s][0x12]==0xD8)||(buffer[s][0x12]==0xDA)||(buffer[s][0x12]==0xDD)||
       (buffer[s][0x12]==0xE0)||(buffer[s][0x12]==0xE3)||(buffer[s][0x12]==0xE6)||
       ((buffer[s][0x12]>=0xCA)&&(buffer[s][0x12]<=0xCD))))||
     ((buffer[s][0x11]==0x12)&&(buffer[s][0x12]>=0xB8)&&(buffer[s][0x12]<=0xBB))||
     ((buffer[s][0x11]==0x0D)&&
      ((buffer[s][0x12]==0x42)||(buffer[s][0x12]==0x43)||(buffer[s][0x12]==0x58)||
       (buffer[s][0x12]==0x59)||(buffer[s][0x12]==0x70)||(buffer[s][0x12]==0x85)||
       (buffer[s][0x12]==0x94)||(buffer[s][0x12]==0x95)||(buffer[s][0x12]==0x98)||
       (buffer[s][0x12]==0xa4)||(buffer[s][0x12]==0xa8)||(buffer[s][0x12]==0x58))))
 {
  treetarget(s);
 } else
 if ((buffer[s][0x11]==0x20) && (buffer[s][0x12]==0x06))
 {
  corpsetarget(s);
 }
}

void corpsetarget(int s)
{
   int i;
   int n=0;

   for (i=0;i<itemcount;i++)
   {
      if ((items[i].ser1==buffer[s][7])&&(items[i].ser2==buffer[s][8])&&
         (items[i].ser3==buffer[s][9])&&(items[i].ser4==buffer[s][10])&&
         (iteminrange(s,i,1)))
      {
         npcshape[0]=i;
         action(s,0x20);
         n=1;
         if(items[i].more1==0){
            items[i].more1=1;
            switch(items[i].amount) {
            case 0x01: carvetarget(s, 0, 2, 0, 0, 0); break;  //Ogre
            case 0x02: carvetarget(s, 0, 5, 0, 0, 0); break;  //Ettin
            case 0x03: break;                                 //Zombie
            case 0x04: break;                                 //Gargoyle
            case 0x05: carvetarget(s, 36, 1, 0, 0, 0); break; //Eagle
            case 0x06: carvetarget(s, 25, 1, 0, 0, 0); break; //Bird
            case 0x07: carvetarget(s, 0, 1, 0, 0, 0); break;  //Orc w/axe
            case 0x08: break;                                 //Corpser
            case 0x09: carvetarget(s, 0, 1, 0, 0, 0); break;  //Deamon
            case 0x0A: carvetarget(s, 0, 1, 0, 0, 0); break;  //Deamon w/sword
            case 0x0B: break;                                 //-NULL-
            case 0x0C: carvetarget(s, 0, 19, 20, 0, 0); break;//Dragon (green)
            case 0x0D: break;                                 //Air Elemental
            case 0x0E: break;                                 //Earth Elemental
            case 0x0F: break;                                 //Fire Elemental
            case 0x10: break;                                 //Water Elemental
            case 0x11: carvetarget(s, 0, 1, 0, 0, 0); break;  //Orc
            case 0x12: carvetarget(s, 0, 5, 0, 0, 0); break;  //Ettin w/club
            case 0x13: break;                                 //-NULL-
            case 0x14: break;                                 //-NULL-
            case 0x15: carvetarget(s, 0, 4, 20, 0, 0); break; //Giant Serpent
            case 0x16: carvetarget(s, 0, 1, 0, 0, 0); break;  //Gazer
            case 0x17: break;                                 //-NULL-
            case 0x18: break;                                 //Liche
            case 0x19: break;                                 //-NULL-
            case 0x1A: break;                                 //Ghoul
            case 0x1B: break;                                 //-NULL-
            case 0x1C: break;                                 //Spider
            case 0x1D: carvetarget(s, 0, 1, 0, 1, 0); break;  //Gorilla
            case 0x1E: carvetarget(s, 50, 1, 0, 0, 0); break; //Harpy
            case 0x1F: carvetarget(s, 0, 1, 0, 0, 0); break;  //Headless
            case 0x20: break;                                 //-NULL-
            case 0x21: carvetarget(s, 0, 1, 12, 0, 0); break; //Lizardman
            case 0x22: break;                                 //-NULL-
            case 0x23: carvetarget(s, 0, 1, 12, 0, 0); break; //Lizardman w/spear
            case 0x24: carvetarget(s, 0, 1, 12, 0, 0); break; //Lizardman w/mace
            case 0x25: break;                                 //-NULL-
            case 0x26: break;                                 //-NULL-
            case 0x27: carvetarget(s, 0, 1, 0, 0, 0); break;  //Mongbat
            case 0x28: break;                                 //-NULL-
            case 0x29: carvetarget(s, 0, 1, 0, 0, 0); break;  //Orc w/club
            case 0x2A: break;                                 //Ratman
            case 0x2B: break;                                 //-NULL-
            case 0x2C: break;                                 //Ratman w/axe
            case 0x2D: break;                                 //Ratman w/dagger
            case 0x2E: break;                                 //-NULL-
            case 0x2F: break;                                 //Reaper
            case 0x30: break;                                 //Scorpion
            case 0x31: break;                                 //-NULL-
            case 0x32: break;                                 //Skeleton
            case 0x33: break;                                 //Slime
            case 0x34: carvetarget(s, 0, 1, 0, 0, 0); break;  //Snake
            case 0x35: carvetarget(s, 0, 2, 0, 0, 0); break;  //Troll w/axe
            case 0x36: carvetarget(s, 0, 2, 0, 0, 0); break;  //Troll
            case 0x37: carvetarget(s, 0, 2, 0, 0, 0); break;  //Troll w/club
            case 0x38: break;                                 //Skeleton w/axe
            case 0x39: break;                                 //Skeleton w/sword
            case 0x3A: break;                                 //Wisp
            case 0x3B: carvetarget(s, 0, 19, 20, 0, 0); break;//Dragon (red)
            case 0x3C: carvetarget(s, 0, 10, 20, 0, 0); break;//Drake (green)
            case 0x3D: carvetarget(s, 0, 10, 20, 0, 0); break;//Drake (red)
            case 0x46: carvetarget(s, 0, 5, 7, 0, 0); break;//Terathen Matriarche - t2a
            case 0x47: carvetarget(s, 0, 5, 7, 0, 0); break;//Terathen drone - t2a
            case 0x48: carvetarget(s, 0, 5, 7, 0, 0); break;//Terathen warrior, Terathen Avenger - t2a
            case 0x4B: carvetarget(s, 0, 15, 5, 0, 0); break;//Titan - t2a
            case 0x4C: carvetarget(s, 0, 5, 2, 0, 0); break;//Cyclopedian Warrior - t2a
            case 0x50: carvetarget(s, 0, 10, 2, 0, 0); break;//Giant Toad - t2a
            case 0x51: carvetarget(s, 0, 4, 1, 0, 0); break;//Bullfrog - t2a
            case 0x55: carvetarget(s, 0, 5, 7, 0, 0); break;//Ophidian apprentice, Ophidian Shaman - t2a
            case 0x56: carvetarget(s, 0, 5, 7, 0, 0); break;//Ophidian warrior, Ophidian Enforcer, Ophidian Avenger - t2a
            case 0x57: carvetarget(s, 0, 5, 7, 0, 0); break;//Ophidian Matriarche - t2a
            case 0x5F: carvetarget(s, 0, 19, 20, 0, 0); break;//Kraken - t2a
               //case 0x3E-case 0x95: break;                     //-NULL-
            case 0x96: carvetarget(s, 0, 10, 0, 0, 0); break; //Sea Monster
            case 0x97: carvetarget(s, 0, 1, 0, 0, 0); break;  //Dolphin
               //case 0x98-case 0xC7: break;                     //-NULL-
            case 0xC8: carvetarget(s, 0, 3, 10, 0, 0); break; //Horse (tan)
            case 0xC9: carvetarget(s, 0, 1, 0, 1, 0); break;  //Cat
            case 0xCA: carvetarget(s, 0, 1, 12, 0, 0); break; //Alligator
            case 0xCB: carvetarget(s, 0, 6, 0, 0, 0); break;  //Pig
            case 0xCC: carvetarget(s, 0, 3, 10, 0, 0); break; //Horse (dark)
            case 0xCD: carvetarget(s, 0, 1, 0, 1, 0); break;  //Rabbit
            case 0xCE: carvetarget(s, 0, 1, 12,0 ,0); break;  //Lava Lizard - t2a
            case 0xCF: carvetarget(s, 0, 3, 0, 0, 1); break;  //Sheep
            case 0xD0: carvetarget(s, 25, 1, 0, 0, 0); break; //Chicken
            case 0xD1: carvetarget(s, 0, 2, 8, 0, 0); break;  //Goat
            case 0xD2: carvetarget(s, 0, 15, 0, 0, 0); break;  //Desert Ostarge - t2a
            case 0xD3: carvetarget(s, 0, 1, 0, 1, 0); break;  //Bear
            case 0xD4: carvetarget(s, 0, 1, 0, 1, 0); break;  //Grizzly Bear
            case 0xD5: carvetarget(s, 0, 2, 0, 3, 0); break;  //Polar Bear
            case 0xD6: carvetarget(s, 0, 1, 0, 1, 0); break;  //Cougar
            case 0xD7: carvetarget(s, 0, 1, 0, 1, 0); break;  //Giant Rat
            case 0xD8: carvetarget(s, 0, 8, 12, 0, 0); break; //Cow (black)
            case 0xD9: carvetarget(s, 0, 1, 0, 0, 0); break;  //Dog
            case 0xDA: carvetarget(s, 0, 15, 0, 0, 0); break;  //Frenzied Ostard - t2a
            case 0xDB: carvetarget(s, 0, 15, 0, 0, 0); break;  //Forest Ostard - t2a
            case 0xDC: carvetarget(s, 0, 7, 0, 12, 0); break;  //Llama
            case 0xDD: carvetarget(s, 0, 1, 12, 0, 0); break; //Walrus
            case 0xDE: break;                                 //-NULL-
            case 0xDF: carvetarget(s, 0, 3, 0, 0, 0); break;  //Sheep (BALD)
            case 0xE1: carvetarget(s, 0, 1, 0, 1, 0); break;  //Timber Wolf
            case 0xE2: carvetarget(s, 0, 3, 10, 0, 0); break; //Horse (Silver)
            case 0xE3: break;                                 //-NULL-
            case 0xE4: carvetarget(s, 0, 3, 10, 0, 0); break; //Horse (tan)
            case 0xE5: break;                                 //-NULL-
            case 0xE6: break;                                 //-NULL-
            case 0xE7: carvetarget(s, 0, 3, 12, 0, 0); break; //Cow (brown)
            case 0xE8: carvetarget(s, 0, 10, 15, 0, 0); break;//Bull (brown)
            case 0xE9: carvetarget(s, 0, 10, 15, 0, 0); break;//Bull (d-brown)
            case 0xEA: carvetarget(s, 0, 6, 15, 0, 0); break; //Great Heart
            case 0xEB: break;                                 //-NULL-
            case 0xEC: break;                                 //-NULL-
            case 0xED: carvetarget(s, 0, 5, 8, 0, 0); break;  //Hind
            case 0xEE: carvetarget(s, 0, 1, 0, 0, 0); break;  //Rat
               //case 0xEF-case 0xFF: break;                     //-NULL-                     //-NULL-
     }
   } else {
     sysmessage(s, "You carve the corpse but find nothing usefull.");
   }
   break;
  }
 }
 if (!n) sysmessage(s, "That is too far away.");
}

void carvetarget(int s, int feat, int ribs, int hides, int fur, int wool)
{

 int k,c;
 int feather=0;
 int meat=0;
 int leath=0;
 int furs=0;
 int wools=0;

 c=SpawnItem(s,1,"#",0,0x12,0x2A,0,0,0,0);  //add the blood puddle
 items[c].x=items[npcshape[0]].x;
 items[c].y=items[npcshape[0]].y;
 items[c].z=items[npcshape[0]].z;
 items[c].decaytime=(getclock()+(server_data.decaytimer*CLOCKS_PER_SEC));
 for (k=0;k<now;k++) if (perm[k]) senditem(k,c);

 if (feat)
 {
  c=SpawnItem(s,feat,"feathers",1,0x1B,0xD1,0,0,1,1);
  items[c].layer=0x01;
  items[c].att=5;
//  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  feather=1;

 }
 if (ribs)
 {
  c=SpawnItem(s,ribs,"raw ribs",1,0x09,0xF1,0,0,1,1);
  items[c].layer=0x01;
  items[c].att=5;
//  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  meat=1;
 }

 if (hides)
 {
  c=SpawnItem(s,hides,"hides",1,0x10,0x78,0,0,1,1);
  items[c].att=5;
//  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  leath=1;
 }

 if (fur)
 {
  c=SpawnItem(s,fur,"fur",1,0x11,0xFA,0,0,1,1);
  items[c].layer=0x01;
  items[c].att=5;
//  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  furs=1;
 }

 if (wool)
 {
  c=SpawnItem(s,wool,"unspun wool",1,0x0D,0xF8,0,0,1,1);
  items[c].layer=0x01;
  items[c].att=5;
//  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  wools=1;
 }

 if(feather) sysmessage(s,"You pluck the bird and get some feathers.");
 if(meat) sysmessage(s,"You carve away some meat.");
 if(leath) sysmessage(s,"You skin the corpse and get the hides.");
 if(furs) sysmessage(s, "You skin the corpse and get some fur.");
 if(wools) sysmessage(s, "You skin the corpse and get some unspun wool.");
}


void setabovelight(char lightchar)
{
 int i;
 if (lightchar != worldcurlevel)
 {
  worldcurlevel=lightchar;
  for (i=0;i<now;i++)
  {
   if (perm[i]) dolight(i, worldcurlevel);
  }
 }
}

void dolight(int s, char level)
{
  char light[3]="\x4F\x00";

  if ((s==-1)||(!perm[s])) return;
  light[1]=level;
  if (worldfixedlevel!=255)
  {
   light[1]=worldfixedlevel;
  } else {
   if (chars[currchar[s]].fixedlight!=255)
   {
    light[1]=chars[currchar[s]].fixedlight;
   } else {
    if (indungeon(currchar[s]))
    {
     light[1]=dungeonlightlevel;
    }
    else
    {
     light[1]=level;
    }
   }
  }
  xsend(s, light, 2, 0);
}

void doworldlight(void)
{
 char c=255;
 int i=-1;
 if ((hour<=3 && (!ampm)) || (hour>=10 && ampm)) i=worlddarklevel;
 if ((hour>=10&& (!ampm)) || (hour<=3  && ampm)) i=worldbrightlevel;
 if (i==-1)
 {
         i=(((60*(hour-4))+minute) * (worlddarklevel-worldbrightlevel)) / 360;
     if (ampm)
         {
                 i=i+worldbrightlevel;
         } else {
                 i=worlddarklevel-i;
         }
 }
 if (wtype) i=i+2;
 if (moon1+moon2<4) i=i+1;
 if (moon1+moon2<10) i=i+1;
 c=i;
 setabovelight(c);
}

void swordtarget(int s)
{
 if (buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return;
 int k,c;

 if (((buffer[s][0x11]==0x0C)&&
      ((buffer[s][0x12]==0xD0)||(buffer[s][0x12]==0xD3)||(buffer[s][0x12]==0xD6)||
       (buffer[s][0x12]==0xD8)||(buffer[s][0x12]==0xDA)||(buffer[s][0x12]==0xDD)||
       (buffer[s][0x12]==0xE0)||(buffer[s][0x12]==0xE3)||(buffer[s][0x12]==0xE6)||
       ((buffer[s][0x12]>=0xCA)&&(buffer[s][0x12]<=0xCD))))||
       ((buffer[s][0x11]==0x12)&&(buffer[s][0x12]>=0xB8)&&(buffer[s][0x12]<=0xBB)))
 {
  if (!chars[s].onhorse) action(s,0x0D);
  else action(s,0x1d);
  soundeffect(s,0x01,0x3E);
  c=SpawnItem(s,1,"#",1,0x0D,0xE1,0,0,0,0); //Kindling
  items[c].x=chars[currchar[s]].x;
  items[c].y=chars[currchar[s]].y;
  items[c].z=chars[currchar[s]].z;
  for (k=0;k<now;k++) if (perm[k]) senditem(k,c);
  sysmessage(s, "You hack at the tree and produce some kindling.");
 }
 else
 if((buffer[s][0x11]==0x1B) && ((buffer[s][0x12]==0xDD) || buffer[s][0x12]==0xE0))  // vagrant
 {
  bowcraft(s);
  return;
 }
 else if ((buffer[s][0x11]==0x20) && (buffer[s][0x12]==0x06))
 {
  corpsetarget(s);
  return;
 }
 else sysmessage(s,"You can't think of a way to use your blade on that.");
}

void initchar(int nChar)
{
 int i;

//if (nChar==charcount)
// {
 chars[nChar].ser1=charcount2/16777216;
 chars[nChar].ser2=charcount2/65536;
 chars[nChar].ser3=charcount2/256;
 chars[nChar].ser4=charcount2;
 chars[nChar].serial=charcount2;
 setptr(&charsp[charcount2%256], nChar);
 if (nChar==charcount)
 {
   charcount++;
 }
 charcount2++;

// }
 chars[nChar].free=0;
 sprintf(chars[nChar].name, "John Doe");
 *(chars[nChar].title)='\0'; // was sprintf(chars[nChar].title,"");
 chars[nChar].account=-1;  // This could be a problem in the future... and already is.  Changed back from 999.
 chars[nChar].id1=0x01;
 chars[nChar].id2=0x90;
 chars[nChar].xid1=0x01;
 chars[nChar].xid2=0x90;
 chars[nChar].skin1=0x83;
 chars[nChar].skin2=0xFF;
 chars[nChar].xskin1=0x83;
 chars[nChar].xskin2=0xFF;
 chars[nChar].priv=0;
 chars[nChar].priv2=0;
 chars[nChar].x=0;
 chars[nChar].y=0;
 chars[nChar].z=0;
 chars[nChar].dispz=0;
 chars[nChar].dir=3;
 chars[nChar].fonttype=3;
 chars[nChar].saycolor1=0;
 chars[nChar].saycolor2=0;
 chars[nChar].emotecolor1=0;
 chars[nChar].emotecolor2=0;
 chars[nChar].hp=chars[nChar].st=50;
 chars[nChar].stm=chars[nChar].dx=50;
 chars[nChar].mn=chars[nChar].in=50;
 chars[nChar].st2=50;
 chars[nChar].dx2=50;
 chars[nChar].in2=50;
 for (i=0;i<TRUESKILLS;i++)
 {
   chars[nChar].baseskill[i]=10;
   updateSkillLevel(nChar,i);
 }
 chars[nChar].npc=0;
 chars[nChar].shop=0;
 chars[nChar].cell=0;
 chars[nChar].own1=255;
 chars[nChar].own2=255;
 chars[nChar].own3=255;
 chars[nChar].own4=255;
 chars[nChar].ownserial=-1;
 chars[nChar].robe1=255;
 chars[nChar].robe2=255;
 chars[nChar].robe3=255;
 chars[nChar].robe4=255;
 chars[nChar].karma=0;
 chars[nChar].fame=0;
 chars[nChar].kills=0;
 chars[nChar].deaths=0;
 chars[nChar].dead=0;
 chars[nChar].fixedlight=255;
 chars[nChar].speech=0;
 chars[nChar].att=0;
 chars[nChar].def=0;
 chars[nChar].war=0;
 chars[nChar].targ=-1;
 chars[nChar].timeout=0;
 chars[nChar].regen=0;
 chars[nChar].regen2=0;
 chars[nChar].regen3=0;
 chars[nChar].runenumb=-1;
 chars[nChar].attacker=-1;
 chars[nChar].npcWander=0;
 chars[nChar].ftarg=-1;
 chars[nChar].fx1=0;
 chars[nChar].fy1=0;
 chars[nChar].fz1=0;
 chars[nChar].fx2=0;
 chars[nChar].fy2=0;
 chars[nChar].spawn1=0;
 chars[nChar].spawn2=0;
 chars[nChar].spawn3=0;
 chars[nChar].spawn4=0;
 chars[nChar].spawnserial=-1;
 chars[nChar].hidden=0;
 chars[nChar].invistimeout=0;
 chars[nChar].attackfirst=0;
 chars[nChar].hunger=6;
 chars[nChar].smeltitem=-1;
 chars[nChar].npcaitype=0;
 chars[nChar].playercallnum=0;
 chars[nChar].callnum=0;
 chars[nChar].pagegm=0;
 chars[nChar].skilldelay=0;
 chars[nChar].objectdelay=0;
 chars[nChar].region=255;
 chars[nChar].making=0;
 chars[nChar].dir2=0;
 chars[nChar].blocked=0;
 chars[nChar].spiritspeaktimer=0; // initchar to not be spirit speaking
 chars[nChar].spattack=0;
 chars[nChar].spadelay=0;
 chars[nChar].spatimer=0;
 chars[nChar].lodamage=0;
 chars[nChar].hidamage=0;
 chars[nChar].summontimer=0;
 chars[nChar].taming=0;
 chars[nChar].fishingtimer=0;
 chars[nChar].townvote1=255;
 chars[nChar].townvote2=255;
 chars[nChar].townvote3=255;
 chars[nChar].townvote4=255;
 chars[nChar].towntitle=0;
 chars[nChar].townpriv=0;
 chars[nChar].advobj=0;
 chars[nChar].poison=0;
 chars[nChar].poisoned=0;
 chars[nChar].fleeat=0;
 chars[nChar].reattackat=0;
 chars[nChar].split=0;
 chars[nChar].splitchnc=0;
 chars[nChar].trigger=0;
 chars[nChar].disabled=0;
 chars[nChar].trainer=-1; 
 chars[nChar].trainingplayerin=-1;
 chars[nChar].cantrain=1;
}

void telltime(int s)
{
 char tstring[100];
 char tstring2[100];
 int lhour;
 lhour=hour;

 if ((minute>=0)&&(minute<=14)) sprintf(tstring,"It is");
 else if ((minute>=15)&&(minute<=30)) sprintf(tstring,"It is a quarter past");
 else if ((minute>=30)&&(minute<=45)) sprintf(tstring,"It is half past");
 else
 {
  sprintf(tstring,"It is a quarter till");
  lhour++;
  if (lhour==0) lhour=12;
 }

 if (lhour==1) sprintf(tstring2,"%s one o'clock",tstring);
 else if (lhour==2) sprintf(tstring2,"%s two o'clock",tstring);
 else if (lhour==3) sprintf(tstring2,"%s three o'clock",tstring);
 else if (lhour==4) sprintf(tstring2,"%s four o'clock",tstring);
 else if (lhour==5) sprintf(tstring2,"%s five o'clock",tstring);
 else if (lhour==6) sprintf(tstring2,"%s six o'clock",tstring);
 else if (lhour==7) sprintf(tstring2,"%s seven o'clock",tstring);
 else if (lhour==8) sprintf(tstring2,"%s eight o'clock",tstring);
 else if (lhour==9) sprintf(tstring2,"%s nine o'clock",tstring);
 else if (lhour==10) sprintf(tstring2,"%s ten o'clock",tstring);
 else if (lhour==11) sprintf(tstring2,"%s eleven o'clock",tstring);
 else if ((lhour==12)&&(ampm)) sprintf(tstring2,"%s midnight.",tstring);
 else sprintf(tstring2,"%s noon.",tstring);

 if (lhour==12) sprintf(tstring,"%s",tstring2);
 else if (ampm)
 {
  if ((lhour>=1)&&(lhour<6)) sprintf(tstring,"%s in the afternoon.",tstring2);
  else if ((lhour>=6)&&(lhour<9)) sprintf(tstring,"%s in the evening.",tstring2);
  else sprintf(tstring,"%s at night.",tstring2);
 }
 else
 {
  if ((lhour>=1)&&(lhour<5)) sprintf(tstring,"%s at night.",tstring2);
  else sprintf(tstring,"%s in the morning.",tstring2);
 }

 sysmessage(s,tstring);
}

void updateskill(int s, int skillnum)
{
 char update[8];
 int i;
 for (i=0;i<8;i++)
 {
  update[i]=0;
 }
 update[0]=0x3A; // Skill Update Message
 update[1]=0x00; // Length of message
 update[2]=0x08; // Length of message
 update[3]=0xff; // Unknown
 update[4]=0x00;
 update[5]=skillnum;
 update[6]=chars[currchar[s]].skill[skillnum]/256;
 update[7]=chars[currchar[s]].skill[skillnum]%256;
 if (s!=-1) xsend(s, update, 8, 0);
}

void setdirtarget(int s)
{
  int i,j,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);

  if (buffer[s][7]>=0x40)
  {
    i=findbyserial(&itemsp[serial%256], serial, 0);
    if (i!=-1)
    {
      items[i].dir=addx[s];
      for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
      return;
    }
  }
  else
  {
    i=findbyserial(&charsp[serial%256], serial, 1);
    if (i!=-1)
    {
      chars[i].dir=addx[s];
      updatechar(i);
      return;
    }
  }
}

void objprivtarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].priv=addid1[s];
  }
}

void impaction(int s, int act)
{
 if (chars[currchar[s]].onhorse && (act==0x10 || act==0x11))
 {
  action(s, 0x1b);
  return;
 }
 if ((chars[currchar[s]].onhorse || (chars[currchar[s]].id1<1 && chars[currchar[s]].id2<90))
         && (act==0x22))
 {
  return;
 }
 action(s, act);
}

int chardirxyz(int a, int x, int y, int z)   // direction from character a to char b
{
 int dir,xdif,ydif;

 xdif = x-chars[a].x;
 ydif = y-chars[a].y;

 if ((xdif==0)&&(ydif<0)) dir=0;
 else if ((xdif>0)&&(ydif<0)) dir=1;
 else if ((xdif>0)&&(ydif==0)) dir=2;
 else if ((xdif>0)&&(ydif>0)) dir=3;
 else if ((xdif==0)&&(ydif>0)) dir=4;
 else if ((xdif<0)&&(ydif>0)) dir=5;
 else if ((xdif<0)&&(ydif==0)) dir=6;
 else if ((xdif<0)&&(ydif<0)) dir=7;
 else dir=-1;

 return dir;
}

int fielddir(int s, int x, int y, int z)
{
 int dir=chardirxyz(s, x, y, z);
 switch (dir)
 {
 case 0:
 case 4:
         return 0;
         break;
 case 2:
 case 6:
         return 1;
         break;
 case 1:
 case 3:
 case 5:
 case 7:
 case -1:
         switch(chars[currchar[s]].dir)
         {
         case 0:
         case 4:
                 return 0;
                 break;
         case 2:
         case 6:
                 return 1;
                 break;
         case 1:
         case 3:
         case 5:
         case 7:
                 return 1;
         }
 }
 return 1;
}

int checkforchar(int x, int y, int z)
{
 int i;
 for (i=0;i<charcount;i++)
 {
  if (online(i) || chars[i].npc)
  {
   if (chars[i].x==x && chars[i].y==y && chars[i].z==z)
   {
     return 1;
   }
  }
 }
 return 0;
}


void tempeffectsoff()
{
 int i, s;
 for (i=0;i<teffectcount;i++)
 {
  s=calcCharFromSer(teffects[i].dest1, teffects[i].dest2,
                    teffects[i].dest3, teffects[i].dest4);
  switch(teffects[i].num)
  {
   case 1:
           chars[s].priv2=chars[s].priv2&0xFD;
           break;
   case 2:
           chars[s].fixedlight=255;
           break;
   case 3:
           chars[s].dx=chars[s].dx+teffects[i].more1;
           break;
   case 4:
           chars[s].in=chars[s].in+teffects[i].more1;
           break;
   case 5:
           chars[s].st=chars[s].st+teffects[i].more1;
           break;
   case 6:
           chars[s].dx=chars[s].dx-teffects[i].more1;
           break;
   case 7:
           chars[s].in=chars[s].in-teffects[i].more1;
           break;
   case 8:
           chars[s].st=chars[s].st-teffects[i].more1;
           break;
   case 11:
           chars[s].st=chars[s].st-teffects[i].more1;
           chars[s].dx=chars[s].dx-teffects[i].more2;
           chars[s].in=chars[s].in-teffects[i].more3;
           break;
   case 12:
           chars[s].st=chars[s].st+teffects[i].more1;
           chars[s].dx=chars[s].dx+teffects[i].more2;
           chars[s].in=chars[s].in+teffects[i].more3;
           break;
  }
 }
}

void tempeffectson()
{
 int i, s;
 for (i=0;i<teffectcount;i++)
 {
  s=calcCharFromSer(teffects[i].dest1, teffects[i].dest2,
                    teffects[i].dest3, teffects[i].dest4);
  switch(teffects[i].num)
  {
   case 1:
           chars[s].priv2=chars[s].priv2|0x02;
           break;
   case 2:
           chars[s].fixedlight=worldbrightlevel;
           break;
   case 3:
           chars[s].dx=chars[s].dx-teffects[i].more1;
           break;
   case 4:
           chars[s].in=chars[s].in-teffects[i].more1;
           break;
   case 5:
           chars[s].st=chars[s].st-teffects[i].more1;
           break;
   case 6:
           chars[s].dx=chars[s].dx+teffects[i].more1;
           break;
   case 7:
           chars[s].in=chars[s].in+teffects[i].more1;
           break;
   case 8:
           chars[s].st=chars[s].st+teffects[i].more1;
           break;
   case 11:
           chars[s].st=chars[s].st+teffects[i].more1;
           chars[s].dx=chars[s].dx+teffects[i].more2;
           chars[s].in=chars[s].in+teffects[i].more3;
           break;
   case 12:
           chars[s].st=chars[s].st-teffects[i].more1;
           chars[s].dx=chars[s].dx-teffects[i].more2;
           chars[s].in=chars[s].in-teffects[i].more3;
           break;
  }
 }
}


void checktempeffects()
{
 int i, j, s, mortar;
 j=getclock();
 for(i=0;i<teffectcount;i++)
 {
  if (teffects[i].expiretime<=j)
  {
   s=calcCharFromSer(teffects[i].dest1, teffects[i].dest2,
                         teffects[i].dest3, teffects[i].dest4);
   if ((teffects[i].num != 9) && (teffects[i].num != 10) &&
		   (teffects[i].num !=17))
   {
   //Added by TANiS to fix errors, memory corruption and door auto-close 10-6-98
   // Check to see if it's a dead char and delete the wrong effect, or if it's just
   // a door auto-close effect and process it the right way.
   if ( ((s < 0) || (s >= MAXCHARS)) && (teffects[i].num != 14) && (teffects[i].num != 13) && (teffects[i].num != 9) && (teffects[i].num != 10) )
   { 
      //LogMessage("checktempeffects() - char overflow s (%i) i (%i)\n" _ s _ i);
      //LogMessage("teffects num = (%i)\n" _ teffects[i].num);
      //LogMessage("Fixing on the fly..\n");

      memcpy(&teffects[i],&teffects[teffectcount-1],sizeof(teffect_st));      
      teffectcount--;
      i--;
      break;
   } //End of TANiS' change
   }
   //if (s != -1)
   switch(teffects[i].num)
   {
   case 1:
           if (chars[s].priv2&0x02)
           {
            chars[s].priv2=chars[s].priv2&0xFD;
            s=calcSocketFromChar(s);
            if (s!=-1) sysmessage(s, "You are no longer frozen.");
           }
           break;
   case 2:
           chars[s].fixedlight=255;
           dolight(calcSocketFromChar(s), worldbrightlevel);
           break;
   case 3:
           chars[s].dx=chars[s].dx+teffects[i].more1;
           statwindow(calcSocketFromChar(s), s);
           break;
   case 4:
           chars[s].in=chars[s].in+teffects[i].more1;
           statwindow(calcSocketFromChar(s), s);
           break;
   case 5:
           chars[s].st=chars[s].st+teffects[i].more1;
           statwindow(calcSocketFromChar(s), s);
           break;
   case 6:
           chars[s].dx=chars[s].dx-teffects[i].more1;
           chars[s].stm=min(chars[s].stm, chars[s].dx);
           statwindow(calcSocketFromChar(s), s);
           break;
   case 7:
           chars[s].in=chars[s].in-teffects[i].more1;
           chars[s].mn=min(chars[s].mn, chars[s].in);
           statwindow(calcSocketFromChar(s), s);
           break;
   case 8:
           chars[s].st=chars[s].st-teffects[i].more1;
           chars[s].hp=min(chars[s].hp, chars[s].st);
           statwindow(calcSocketFromChar(s), s);
           break;
   case 9:
           switch(teffects[i].more1)
           {
           case 0:
                   if (teffects[i].more2!=0)
                   {
                    sprintf(temp, "*%s continues grinding.*", chars[s].name);
                    npcemoteall(s, temp);
                   }
                   soundeffect2(s, 0x02, 0x42);
                   break;
           }
           break;
   case 10:
           s=calcCharFromSer(teffects[i].sour1, teffects[i].sour2,
                             teffects[i].sour3, teffects[i].sour4);
           mortar=calcItemFromSer(teffects[i].dest1, teffects[i].dest2,
                                  teffects[i].dest3, teffects[i].dest4);
           createpotion(s, teffects[i].more1, teffects[i].more2, mortar);
           break;
   case 11:
           chars[s].st=chars[s].st-teffects[i].more1;
           chars[s].hp=min(chars[s].hp, chars[s].st);
           chars[s].dx=chars[s].dx-teffects[i].more2;
           chars[s].stm=min(chars[s].stm, chars[s].dx);
           chars[s].in=chars[s].in-teffects[i].more3;
           chars[s].mn=min(chars[s].mn, chars[s].in);
           statwindow(calcSocketFromChar(s), s);
           break;
   case 12:
           chars[s].st=chars[s].st+teffects[i].more1;
           chars[s].dx=chars[s].dx+teffects[i].more2;
           chars[s].in=chars[s].in+teffects[i].more3;
           statwindow(calcSocketFromChar(s), s);
           break;
   case 13: 
           mortar=calcItemFromSer(teffects[i].dest1, teffects[i].dest2, // door
                                  teffects[i].dest3, teffects[i].dest4);
           if (items[mortar].dooropen==0) break;
           items[mortar].dooropen=0;
           dooruse(calcSocketFromChar(s), mortar);
           break;
   case 14: //- training dummies Tauriel check to see if item moved or not before searching for it
          j = teffects[i].itemptr;
          if (items[j].ser1 == teffects[i].dest1 && items[j].ser2 == teffects[i].dest2 &&
              items[j].ser3 == teffects[i].dest3 && items[j].ser4 == teffects[i].dest4)
              {mortar = j;}
          else  mortar=calcItemFromSer(teffects[i].dest1, teffects[i].dest2, teffects[i].dest3, teffects[i].dest4);
          if ((items[mortar].id1==0x10) && (items[mortar].id2==0x71))
          {
            items[mortar].id2=0x70;
            items[mortar].gatetime=0;
            for (j=0;j<now;j++) if (perm[j]) senditem(j,mortar);    
          } else
          if ((items[mortar].id1==0x10) && (items[mortar].id2==0x75))
          {
            items[mortar].id2=0x74;
            items[mortar].gatetime=0;
            for (j=0;j<now;j++) if (perm[j]) senditem(j,mortar); 
          } 
          break;
     case 15: //reactive armor
           chars[s].ra=0;
          break;
   case 16: //Explosion potion messages  Tauriel
         sprintf(temp, "%i", teffects[i].more3);
         sysmessage(s, temp);
         break;
   case 17: //Explosion potion explosion  Tauriel
         s=calcCharFromSer(teffects[i].sour1, teffects[i].sour2,
                           teffects[i].sour3, teffects[i].sour4);
				 explodeitem(calcSocketFromChar(s), teffects[i].itemptr); //explode this item
         /*teffects[teffectcount].expiretime=getclock()+(more2*CLOCKS_PER_SEC);
         teffects[teffectcount].num=9;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
				 teffects[teffectcount].more3=more3;
         teffects[teffectcount].dispellable=0;*/
         break;
   }
   memcpy(&teffects[i],&teffects[teffectcount-1],sizeof(teffect_st));
   teffectcount--;
   i--;
  }
 }
}

char tempeffect(int source, int dest, int num, char more1, char more2, char more3)
{
 if (teffectcount==MAXEFFECTS)
   return 0;
 teffects[teffectcount].sour1=chars[source].ser1;
 teffects[teffectcount].sour2=chars[source].ser2;
 teffects[teffectcount].sour3=chars[source].ser3;
 teffects[teffectcount].sour4=chars[source].ser4;
 teffects[teffectcount].dest1=chars[dest].ser1;
 teffects[teffectcount].dest2=chars[dest].ser2;
 teffects[teffectcount].dest3=chars[dest].ser3;
 teffects[teffectcount].dest4=chars[dest].ser4;
 switch (num)
 {
 case 1:
         chars[dest].priv2=chars[dest].priv2|0x02;
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/100)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=1;
         teffects[teffectcount].more1=0;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 2:
         chars[dest].fixedlight=worldbrightlevel;
         dolight(calcSocketFromChar(dest), worldbrightlevel);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY])*CLOCKS_PER_SEC);
         teffects[teffectcount].num=2;
         teffects[teffectcount].more1=0;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 3:
         if (chars[dest].dx<more1)
           more1=chars[dest].dx;
         chars[dest].dx=chars[dest].dx-more1;
         chars[dest].stm=min(chars[dest].stm, chars[dest].dx);
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=3;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 4:
         if (chars[dest].in<more1)
           more1=chars[dest].in;
         chars[dest].in=chars[dest].in-more1;
         chars[dest].mn=min(chars[dest].mn, chars[dest].in);
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=4;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 5:
         if (chars[dest].st<more1)
           more1=chars[dest].st;
         chars[dest].st=chars[dest].st-more1;
         chars[dest].hp=min(chars[dest].hp, chars[dest].st);
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=5;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 6:
         if (chars[dest].dx+more1>255)
           more1=chars[dest].dx-255;
         chars[dest].dx=chars[dest].dx+more1;
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=6;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 7:
         if (chars[dest].in+more1>255)
           more1=chars[dest].in-255;
         chars[dest].in=chars[dest].in+more1;
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=7;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 8:
         if (chars[dest].st+more1>255)
           more1=chars[dest].st-255;
         chars[dest].st=chars[dest].st+more1;
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=8;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=0;
         teffects[teffectcount].dispellable=1;
         break;
 case 9:
         teffects[teffectcount].expiretime=getclock()+(more2*CLOCKS_PER_SEC);
         teffects[teffectcount].num=9;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
         teffects[teffectcount].dispellable=0;
         break;
 case 10:
         teffects[teffectcount].expiretime=getclock()+(12*CLOCKS_PER_SEC);
         teffects[teffectcount].dispellable=0;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
         teffects[teffectcount].num=10;
         break;
 case 11: // Bless
         if (chars[dest].st+more1>255)
           more1=chars[dest].st-255;
         if (chars[dest].dx+more2>255)
           more2=chars[dest].dx-255;
         if (chars[dest].in+more3>255)
           more3=chars[dest].in-255;
         chars[dest].st=chars[dest].st+more1;
         chars[dest].dx=chars[dest].dx+more2;
         chars[dest].in=chars[dest].in+more3;
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=11;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
         teffects[teffectcount].more3=more3;
         teffects[teffectcount].dispellable=1;
         break;
 case 12: // Curse
         if (chars[dest].st<more1)
           more1=chars[dest].st;
         if (chars[dest].dx<more2)
           more2=chars[dest].dx;
         if (chars[dest].in<more3)
           more3=chars[dest].in;
         chars[dest].st=chars[dest].st-more1;
         chars[dest].dx=chars[dest].dx-more2;
         chars[dest].in=chars[dest].in-more3;
         statwindow(calcSocketFromChar(dest), dest);
         teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=12;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
         teffects[teffectcount].more3=more3;
         teffects[teffectcount].dispellable=1;
         break;
   case 15: // Reactive armor
          teffects[teffectcount].expiretime=getclock()+((chars[source].skill[MAGERY]/10)*CLOCKS_PER_SEC);
         teffects[teffectcount].num=15;
         teffects[teffectcount].dispellable=1;
         break;
   case 16: //Explosion potions  Tauriel
         teffects[teffectcount].expiretime=getclock()+(more2*CLOCKS_PER_SEC);
         teffects[teffectcount].num=16;
         teffects[teffectcount].more1=more1; //item/potion
         teffects[teffectcount].more2=more2; //seconds
				 teffects[teffectcount].more3=more3; //countdown#
         teffects[teffectcount].dispellable=0;
         break;
 }
 teffectcount++;
 return 1;
}

char tempeffect2(int source, int dest, int num, char more1, char more2, char more3)
{
 if (teffectcount==MAXEFFECTS)
   return 0;
 teffects[teffectcount].sour1=chars[source].ser1;
 teffects[teffectcount].sour2=chars[source].ser2;
 teffects[teffectcount].sour3=chars[source].ser3;
 teffects[teffectcount].sour4=chars[source].ser4;
 teffects[teffectcount].dest1=items[dest].ser1;
 teffects[teffectcount].dest2=items[dest].ser2;
 teffects[teffectcount].dest3=items[dest].ser3;
 teffects[teffectcount].dest4=items[dest].ser4;
 switch (num)
 {
 case 10:
         teffects[teffectcount].expiretime=getclock()+(12*CLOCKS_PER_SEC);
         teffects[teffectcount].dispellable=0;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
         teffects[teffectcount].num=10;
         break;
 case 13:
         if (items[dest].dooropen)
         {
          items[dest].dooropen=0;
          return 0;
         }
         teffects[teffectcount].expiretime=getclock()+(10*CLOCKS_PER_SEC);
         teffects[teffectcount].num=13;
         teffects[teffectcount].dispellable=0;
         items[dest].dooropen=1;
         break;
 case 14: //Tauriel training dummies swing for 5(?) seconds
         teffects[teffectcount].expiretime=getclock()+(5*CLOCKS_PER_SEC);
         teffects[teffectcount].num=14;
         teffects[teffectcount].dispellable=0;
         teffects[teffectcount].itemptr=dest; //used to try and cut search time down
         teffects[teffectcount].more2=0;
         break;
   case 17: //Explosion potion (explosion)  Tauriel (explode in 4 seconds)
         teffects[teffectcount].expiretime=getclock()+(4*CLOCKS_PER_SEC);
         teffects[teffectcount].num=17;
         teffects[teffectcount].more1=more1;
         teffects[teffectcount].more2=more2;
				 teffects[teffectcount].itemptr=dest;
         teffects[teffectcount].dispellable=0;
         break;
 }
 teffectcount++;
 return 1;
}


char indungeon(int s)
{
 int x1, y1;
 if (chars[s].x<5119) return 0;
 x1=(chars[s].x-5119)/256;
 y1=(chars[s].y/256);
 if (y1==0) return 1;
 if (y1==1)
 {
  if (x1!=0) return 1;
  return 0;
 }
 if (y1==2 || y1==3)
 {
  if (x1<3) return 1;
  return 0;
 }
 if (y1==4)
 {
  if (x1==0) return 1;
  return 0;
 }
 if (y1==5)
 {
  return 1;
 }
 if (y1==6)
 {
  if (x1==0) return 1;
  return 0;
 }
 if (y1==7)
 {
  if (x1<2) return 1;
  return 0;
 }
 return 0;
}

void npcattacktarget(int target2, int target)
{
 playmonstersound(target, chars[target].id1, chars[target].id2, SND_STARTATTACK);
 int i;
 if (target==target2) return;
 if ((chars[target].targ==target2)&&(chars[target2].targ==target)) 
 return;
 if ((chardist(target, chars[target].targ))>chardist(target, target2))
  {
  chars[target].targ=target2;
  chars[target].attacker=target2;
  chars[target].attackfirst=1;
  }
 if (((chardist(target2, chars[target2].targ))>chardist(target, target2))&&
    ((!(chars[target2].npcaitype==0x40))||(!((chars[target2].targ==-1)))))
  {
  chars[target2].targ=target;
  chars[target2].attacker=target;
  chars[target2].attackfirst=0;
 }
 if ((chars[target].hidden)&&(!(chars[target].priv2&8)))
 {
  chars[target].hidden=0;
  updatechar(target);
 }
 if ((chars[target2].hidden)&&(!(chars[target2].priv2&8)))
 {
  chars[target2].hidden=0;
  updatechar(target);
 }
 if (chars[target].npc)
 {
  if (!(chars[target].war)) npcToggleCombat(target);
  chars[target].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
 }
 if ((chars[target2].npc)&&!(chars[target2].npcaitype==0x40))
 {
  if (!(chars[target2].war)) npcToggleCombat(target2);
  chars[target2].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
 }
 sprintf(temp, "* You see %s attacking %s *", chars[target].name, chars[target2].name);
 for (i=0;i<now;i++)
 {
  if (inrange1p(currchar[i], target)&&perm[i])
  {
   //itemmessage(i, temp, chars[target].ser1, chars[target].ser2,
   //                     chars[target].ser3, chars[target].ser4);
    chars[target2].emotecolor1=0x00;
    chars[target2].emotecolor2=0x26;
    npcemoteall(target2,temp);
  }
 }
 // Teleporting Guards code 
 if ( (region[chars[target2].region].priv&0x01 == 1) && (server_data.guardsactive) &&
	    (!(chars[target].npc) || (chars[target].npc) && (chars[target].npcaitype==2)))
         spawnguard(target, target2, chars[target].x+2, chars[target].y, chars[target].z);

}


void npcsimpleattacktarget(int target2, int target)
{
 if ((chars[target].targ==target2)&&(chars[target2].targ==target)) return;
  chars[target].targ=target2;
  chars[target].attacker=target2;
  chars[target].attackfirst=1;
  chars[target2].targ=target;
  chars[target2].attacker=target;
  chars[target2].attackfirst=0;
 if ((chars[target].hidden)&&(!(chars[target].priv2&8)))
 {
  chars[target].hidden=0;
  updatechar(target);
 }
 if ((chars[target2].hidden)&&(!(chars[target2].priv2&8)))
 {
  chars[target2].hidden=0;
  updatechar(target);
 }
 if (chars[target].npc)
 {
  if (!(chars[target].war)) npcToggleCombat(target);
  chars[target].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
 }
 if ((chars[target2].npc)&&!(chars[target2].npcaitype==0x40))
 {
  if (!(chars[target2].war)) npcToggleCombat(target2);
  chars[target2].npcmovetime=(int)(getclock()+(NPCSPEED*CLOCKS_PER_SEC));
 }
}

void checknpcai(unsigned int currenttime)
{
int i, k, j, d, d2, onl, maxstat; //maxstat variable not used?!?!?!

 if (nextnpcaitime<=currenttime||(overflow)) 
 {
  for (i=0;i<charcount;i++)
  {
   if (chars[i].npc) 
   {
    switch(chars[i].npcaitype)
    {
     case 1 : // Healers
              for (k=0;k<now;k++) 
              {
               if ((chars[currchar[k]].dead)&&(chardist(i, currchar[k])<=3)) 
               {
                npcaction(i, 0x10);
                npcresurrecttarget(currchar[k]);
                staticeffect(currchar[k], 0x37, 0x6A, 0x09, 0x06);
                switch(rand()%5) 
                {
                 case 0: npctalkall(i, "Thou art dead, but 'tis within my power to resurrect thee.  Live!"); break;
                 case 1: npctalkall(i, "Allow me to resurrect thee ghost.  Thy time of true death has not yet come."); break;
                 case 2: npctalkall(i, "Perhaps thou shouldst be more careful.  Here, I shall resurrect thee."); break;
                 case 3: npctalkall(i, "Live again, ghost!  Thy time in this world is not yet done."); break;
                 case 4: npctalkall(i, "I shall attempt to resurrect thee."); break;
                }
               }
              }
              break;
     case 2 : // Monsters, PK's
              if (!(chars[i].war)) 
              {
               d2=10;
               j=-1;
               for (k=0;k<charcount;k++) 
               {
                onl=online(k);
                d=chardist(i, k);
                if ((k!=i)&&(d<=d2)&&(!(chars[k].priv&0x04))&&(chars[k].hidden==0)&&
                    (!(chars[k].dead))&&(onl || ((chars[k].npc)&&(!(chars[k].npcaitype&0x02))
                    &&(!(chars[k].npcaitype&0x01)))&&(((server_data.monsters_vs_animals == 0)&&
                    (!(chars[k].npcaitype&0x01)))||((server_data.monsters_vs_animals == 1)&&
                    (RandomNum(1,100)<=server_data.animals_attack_chance)))))
                {
                 d2=d;
                 j=k;
                 break;
                }
               }
               if (j!=-1) npcattacktarget(j, i);
              }
              break;
     case 4 : // Guards
              if (!(chars[i].war)) 
              {
               d2=10;
               j=-1;
               for (k=0;k<charcount;k++) 
               {
                d=chardist(i, k);
                if ((k!=i)&&(d<=10)&&(!(chars[k].priv&0x04))&&
                   (!(chars[k].dead))&&(chars[k].npcaitype&0x02)) 
                {
                 d2=d;
                 j=k;
                 break;
                }
               }
               if (j!=-1) 
               {
                npcattacktarget(i, j);
                npctalkall(i, "Thou shalt regret thine actions, swine!");
               }
              }
              break;
     case 30 : //  ? No idea
               if (!(chars[i].war))
               {
                d2=10;
                j=-1;
                for (k=0;k<charcount;k++)
                {
                 d=chardist(i, k);
                 if ((k!=i)&&(d<=10)&&(!(chars[k].priv&0x04))&&
                    (!(chars[k].dead))&&(chars[k].npcaitype&0x30)) 
                 {
                  d2=d;
                  j=k;
                  break;
                 }
                }
                if (j!=-1) npcattacktarget(j, i);
               }
               break;
    }// switch
    nextnpcaitime=currenttime+(2*CLOCKS_PER_SEC);
   }// if (chars[i].npc)
  }// for (i=0;i<charcount;i++)
 }// if (nextnpcaitime<=currenttime||(overflow))
}// void checknpcai


//o---------------------------------------------------------------------------o
//|   Function    -  void npcresurrecttarget(int i)
//|   Date        -  UnKnown
//|   Programmer  -  UnKnown  (Touched tabstops by Tauriel Dec 28, 1998)
//o---------------------------------------------------------------------------o
//|   Purpose     -  Resurrects a character
//o---------------------------------------------------------------------------o
void npcresurrecttarget(int i)
{
  int j,c;

  if (chars[i].dead==1)
  {
    Fame(i,0);
    soundeffect2(i, 0x02, 0x14);
    chars[i].id1=chars[i].xid1;
    chars[i].id2=chars[i].xid2;
    chars[i].skin1=chars[i].xskin1;
    chars[i].skin2=chars[i].xskin2;
    chars[i].dead=0;
    chars[i].hp=chars[i].st/10;
    chars[i].stm=chars[i].dx/10;
    chars[i].mn=chars[i].in/10;
    chars[i].attacker=-1;
    chars[i].attackfirst=0;
    chars[i].war=0;

  
    for (j=0;j<itemcount;j++)
    {
      /*if (items[j].cont1==chars[i].ser1 && items[j].cont2==chars[i].ser2 &&
            items[j].cont3==chars[i].ser3 && items[j].cont4==chars[i].ser4 &&*/
      if (items[j].contserial==chars[i].serial && items[j].layer==0x1A)
      {
        items[j].layer=0x15;
        chars[i].packitem=j;  //Tauriel packitem speedup
        //break;
      }
    }
    for (j=0;j<itemcount;j++)
    {
      if ((items[j].ser1==chars[i].robe1)&&(items[j].ser2==chars[i].robe2)&&
          (items[j].ser3==chars[i].robe3)&&(items[j].ser4==chars[i].robe4))
      {
        deleitem(j);

        c=SpawnItem(calcSocketFromChar(i),1,"a resurrect robe",0,0x1F,0x03,0,0,0,0);
        setserial(c,i,4);
        items[c].layer=0x16;
        items[c].dye=1;
        //for (k=0;k<now;k++) if (inrange1p(i, currchar[k])&&perm[i]) wornitems(k, i);
        break;
      }
    }
    teleport(i);
  }
  return;
}

void npcaitarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);

  if (i!=-1)
  {
   chars[i].npcaitype=addid1[s];
  }
}

void xbanktarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 0);
  if (i!=-1)
  {
   openbank(s, i);
  }
}

void openbank(int s, int i)
{
 int j,c,serial,serhash,ci;
  serial=chars[i].serial;
  serhash=serial%256;
  for (ci=0;ci<ownsp[serhash].max;ci++)
  {
    j=ownsp[serhash].pointer[ci];
    if (items[j].ownserial==serial &&
        items[j].type==1 && items[j].morex==1)
  {
   wearitem[1]=items[j].ser1;
   wearitem[2]=items[j].ser2;
   wearitem[3]=items[j].ser3;
   wearitem[4]=items[j].ser4;
   wearitem[5]=items[j].id1;
   wearitem[6]=items[j].id2;
   wearitem[8]=items[j].layer;
   wearitem[9]=items[j].cont1;
   wearitem[10]=items[j].cont2;
   wearitem[11]=items[j].cont3;
   wearitem[12]=items[j].cont4;
   wearitem[13]=items[j].color1;
   wearitem[14]=items[j].color2;
   xsend(s, wearitem, 15, 0);
   backpack(s, items[j].ser1, items[j].ser2, items[j].ser3, items[j].ser4);
   return;
  }
 }
 sprintf(temp, "%s's bank box.", chars[i].name);
 c=SpawnItem(s,1,temp,0,0x09,0xAB,0,0,0,0);

 items[c].layer=0x1d;
 setserial(c,i,3);
 setserial(c,i,4);
 items[c].morex=1;
 items[c].type=1;
 wearitem[1]=items[c].ser1;
 wearitem[2]=items[c].ser2;
 wearitem[3]=items[c].ser3;
 wearitem[4]=items[c].ser4;
 wearitem[5]=items[c].id1;
 wearitem[6]=items[c].id2;
 wearitem[8]=items[c].layer;
 wearitem[9]=items[c].cont1;
 wearitem[10]=items[c].cont2;
 wearitem[11]=items[c].cont3;
 wearitem[12]=items[c].cont4;
 wearitem[13]=items[c].color1;
 wearitem[14]=items[c].color2;
 xsend(s, wearitem, 15, 0);
 backpack(s, items[c].ser1, items[c].ser2, items[c].ser3, items[c].ser4);
}

char inbankrange(int i)
{
 int j;
 for (j=0;j<charcount;j++)
 {
  if (chars[j].npcaitype&0x08)
  {
   if (chardist(i, j)<=6)
   {
        return 1;
   }
  }
 }
 return 0;
}

void deathaction(int s, int x) // Character does a certain action
{
 int i;
 char deathact[14]="\xAF\x01\x02\x03\x04\x01\x02\x00\x05\x00\x00\x00\x00";

 deathact[1]=chars[s].ser1;
 deathact[2]=chars[s].ser2;
 deathact[3]=chars[s].ser3;
 deathact[4]=chars[s].ser4;
 deathact[5]=items[x].ser1;
 deathact[6]=items[x].ser2;
 deathact[7]=items[x].ser3;
 deathact[8]=items[x].ser4;
 for (i=0;i<now;i++) if ((inrange1p(s, currchar[i]))&&(perm[i]) && (currchar[i]!=s)) xsend(i, deathact, 13, 0);
}

void deathmenu(int s) // Character sees death menu
{
 char testact[3]="\x2C\x00";
 xsend(s, testact, 2, 0);
}

int getamount(int s, char id1, char id2)
{
 int i,p,serial,serhash,ci;
 int total=0;

 p=packitem(s);
  serial=items[p].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if (items[i].contserial==serial)
    {
      if (items[i].id1==id1 && items[i].id2==id2) total=total+items[i].amount;
      if (items[i].type==1) total=total+getsubamount(i, id1, id2);
    }
  }
 return total;
}

int getsubamount(int p, char id1, char id2)
{
  int i,serial,serhash,ci;
  int total=0;
  serial=items[p].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if (items[i].contserial==serial)
    {
      if (items[i].id1==id1 && items[i].id2==id2) total=total+items[i].amount;
      if (items[i].type==1) total=total+getsubamount(i, id1, id2);
    }
  }
  return total;
}

void delequan(int s, int id1, int id2, int amount)
{
 int i, j, p, total, serial, serhash, ci;
 total=amount;
 p=packitem(s);
  serial=items[p].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if (items[i].contserial==serial)
    {
      if (items[i].type==1)
      {
        total=total-delesubquan(i, id1, id2, total);
      }
      if (items[i].id1==id1 && items[i].id2==id2)
      {
        if (items[i].amount<=total)
        {
         total=total-items[i].amount;
         deleitem(i);
        }
        else
        {
          items[i].amount=items[i].amount-total;
          total=0;
          for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
        }
      }
      if (total==0) return;
    }
  }
}

int delesubquan(int p, int id1, int id2, int amount)
{
 int i, j, k, serial, serhash, ci;
 int total, totaldel=0;
 total=amount;
  serial=items[p].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if (items[i].contserial==serial)
    {
      if (items[i].type==1)
      {
        k=delesubquan(i, id1, id2, total);
        total=total-k;
        totaldel=totaldel+k;
      }
      if (items[i].id1==id1 && items[i].id2==id2)
      {
        if (items[i].amount<=total)
        {
         total=total-items[i].amount;
         totaldel=totaldel+items[i].amount;
         deleitem(i);
        }
        else
        {
          items[i].amount=items[i].amount-total;
          totaldel=totaldel+total;
          total=0;
          for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
        }
      }
      if (total==0) return totaldel;
    }
  }
  return totaldel;
}

void movetobagtarget(int s)
{
  int i, j, x, y, serial;
  x=rand()%80;
  y=rand()%80;
  int p;
  p=packitem(currchar[s]);
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if ((i!=-1)&& (items[i].serial==serial))
  {
    items[i].x=x+50;
    items[i].y=y+50;
    items[i].z=9;
    setserial(i,p,1);
    items[i].layer=0x00;
    items[i].decaytime=0;//reset decaytimer
    removeitem[1]=items[i].ser1;
    removeitem[2]=items[i].ser2;
    removeitem[3]=items[i].ser3;
    removeitem[4]=items[i].ser4;
    for(j=0;j<now;j++) if (perm[j])
    {
      xsend(j, removeitem, 5, 0);
      senditem(j, i);
    }
  }
}

void dupetarget(int s)
{
  int dupetimes,serial;
  if (addid1[s]>=1)
  {
    dupetimes=addid1[s];
    int dupeit;
    int i;

    serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
    i=findbyserial(&itemsp[serial%256], serial, 0);
    if (i!=-1)
    {
      for (dupeit=0;dupeit<dupetimes;dupeit++)
      {
        dupeitem(s, i, items[i].amount);
      }
    }
  }
}

void dupeitem(int s, int i, int amount)
{
 int p, j, c;
 p=packitem(currchar[s]);
 if (items[i].corpse==0)
 {
  c=memitemfree();
  inititem(c);
  //Tauriel - Crap... another one that can't use the standard stuff. (2nd so far)
  memcpy(&items[c], &items[i], sizeof(item_st));
  items[c].ser1=itemcount2/16777216;
  items[c].ser2=itemcount2/65536;
  items[c].ser3=itemcount2/256;
  items[c].ser4=itemcount2;
  items[c].serial=itemcount2;
  setptr(&itemsp[itemcount2%256], c); //set item in pointer array
  //if (items[c].contserial!=-1) setptr(&contsp[items[c].contserial%256], c);
  setserial(c,p,1);
  items[c].amount=amount;
  if (items[c].ownserial!=-1) setptr(&ownsp[items[c].ownserial%256],c);
  if (items[c].spawnserial!=-1) setptr(&spawnsp[items[c].spawnserial%256],c);

  if (c==itemcount) itemcount++;
  itemcount2++;
  for(j=0;j<now;j++) if (perm[j]) senditem(j, c);
 }
}

void impowncreate(int s, int i, int z) //socket, player to send
{
  int j, k,ci;
  char oc[1024];

  if ( (i < 0) || (i > MAXCHARS) )
  {
    #ifdef DEBUG
       printf("impowncreate -> i overflow. (%i)", i);
    #endif
    i = 0;
  }
 
  oc[0]=0x78; // Message type 78
  oc[1]=0x00; // Length bit 1;
  oc[2]=0x00; // Length bit 2;
  oc[3]=chars[i].ser1; // Character serial number
  oc[4]=chars[i].ser2; // Character serial number
  oc[5]=chars[i].ser3; // Character serial number
  oc[6]=chars[i].ser4; // Character serial number
  oc[7]=chars[i].id1; // Character art id
  oc[8]=chars[i].id2; // Character art id
  oc[9]=chars[i].x/256;  // Character x position
  oc[10]=chars[i].x%256; // Character x position
  oc[11]=chars[i].y/256; // Character y position
  oc[12]=chars[i].y%256; // Character y position
  if (z) oc[13]=chars[i].dispz; // Character z position
  else oc[13]=chars[i].z;
  oc[14]=chars[i].dir; // Character direction
  oc[15]=chars[i].skin1; // Character skin color
  oc[16]=chars[i].skin2; // Character skin color
  oc[17]=0; // Character flags
  if (chars[i].hidden || !(online(i)||chars[i].npc)) oc[17]=oc[17]|0x80; // Show hidden state correctly
  oc[18]=0;
  if (chars[i].npcaitype&0x0D) oc[18]=1; // If a good NPC, show as blue
  if (chars[i].npcaitype&0x02) oc[18]=6; // If a bad  NPC, show as red.
  if (chars[i].npcaitype&0x58) oc[18]=6; // EV Being marked as red
  k=19;

  for (j=0;j<MAXLAYERS;j++) layers[j] = 0;

  for (ci=0;ci<contsp[chars[i].serial%256].max;ci++)
  {
    j=contsp[chars[i].serial%256].pointer[ci];

    if ((j!=-1) && items[j].contserial==chars[i].serial && (!items[j].free))
    {
      if ( layers[items[j].layer] == 0 )
      {
        oc[k+0]=items[j].ser1;
        oc[k+1]=items[j].ser2;
        oc[k+2]=items[j].ser3;
        oc[k+3]=items[j].ser4;
        oc[k+4]=items[j].id1;
        oc[k+5]=items[j].id2;
        oc[k+6]=items[j].layer;
        k=k+7;
        if (items[j].color1!=0 || items[j].color2!=0)
        {
          oc[k-3]=oc[k-3]|0x80;
          oc[k+0]=items[j].color1;
          oc[k+1]=items[j].color2;
          k=k+2;
        }
        layers[items[j].layer] = 1;
      }
      else
      {
        #ifdef DEBUG
           printf("Double layer (%i) on Item (%i) on Char (%i)\n", items[j].layer , j , i);
           sprintf(temp, "Double layer (%i) on Item (%2x %2x %2x %2x) on Char (%2x %2x %2x %2x)\n",
           items[j].layer, items[j].ser1, items[j].ser2, items[j].ser3, items[j].ser4,
           chars[i].ser1, chars[i].ser2, chars[i].ser3, chars[i].ser4);
           sysbroadcast(temp);
        #endif
      }
    }
  }

  oc[k+0]=0;// Not well understood.  It's a serial number.  I set this to my serial number,
  oc[k+1]=0;// and all of my messages went to my paperdoll gump instead of my character's
  oc[k+2]=0;// head, when I was a character with serial number 0 0 0 1.
  oc[k+3]=0;
  k=k+4;

  oc[1]=k/256;
  oc[2]=k%256;
  xsend(s, oc, k, 0);
}

void gettokennum(char * s, int num)
{
 int i, j;

 for (i=0;i<255;i++)
 {
  gettokenstr[i]=0;
 }

 i=0;

 while(num!=0)
 {
  if (s[i]==0)
  {
   num=num-1;
  }
  else
  {
   if (s[i]==' ' && i!=0 && s[i-1]!=' ')
   {
        num=num-1;
   }
   i++;
  }
 }
 j=0;
 while(num!=-1)
 {
  if (s[i]==0)
  {
   num=num-1;
  }
  else
  {
   if (s[i]==' ' && i!=0 && s[i-1]!=' ')
   {
        num=num-1;
   }
   else
   {
    gettokenstr[j]=s[i];
    j++;
   }
   i++;
  }
 }
}

int addrandomloot(int s, char * lootlist)
{
	char sect[512];
	int i,j,retitem, storeval;
	retitem=-1;
	storeval=-1;
	long int pos;
	i=0; j=0;
	openscript("npc.scp");
	sprintf(sect, "LOOTLIST %s", lootlist);
	if (!npc_script.find(sect))
	{
		closescript();
		return -1;
	}
	do
	{
		read1();
		if (script1[0]!='}')
		{
			i++; // Count number of entries on list.
		}
	} while (script1[0]!='}');

	closescript();
	if(i>0)
	{
		i=rand()%(i);
		openscript("npc.scp");
		if(!npc_script.find(sect))
		{
			closescript();
			return -1;
		}
		do
		{
			read1();
			if (script1[0]!='}')
			{
				if(j==i)
				{
					//script1 = ITEM#
					storeval=str2num(script1);
					pos=ftell(scpfile);
					closescript();
					retitem=addmenutarget(-1, 0, storeval);
					openscript("npc.scp");
					fseek(scpfile, pos, SEEK_SET);
					if(retitem!=-1)
					{
						items[retitem].x=50+(rand()%80);
						items[retitem].y=50+(rand()%80);
						items[retitem].z=9;
						setserial(retitem,s,1);
					}
					j++;    
				}
				else j++;
			}
		}	while (script1[0]!='}');
		closescript();
	}
	return retitem;
}

void setrandomname(int s, char * namelist)
{
 char sect[512];
 int i=0,j=0;
 openscript("npc.scp");
 sprintf(sect, "RANDOMNAME %s", namelist);
 if (!npc_script.find(sect))
 {
  closescript();
  sprintf(chars[s].name, "Error Namelist %s Not Found", namelist);
  return;
 }
 do
 {
  read1();
  if (script1[0]!='}')
  {
   i++;
  }
 }
 while (script1[0]!='}');
 closescript();
 sprintf(chars[s].name,"namecount %i",i);
 if(i>0)
 {
  i=rand()%(i);
  openscript("npc.scp");
  if(!npc_script.find(sect))
  {
   closescript();
   sprintf(chars[s].name, "Error Namelist %s Not Found", namelist);
   return;
  }
  do
  {
   read1();
   if (script1[0]!='}')
   {
    if(j==i)
    {
     sprintf(chars[s].name, "%s", script1);
     j++;
    }
    else j++;
   }
  }
  while (script1[0]!='}');
  closescript();
 }
}

int addrandomnpc(int s, char * npclist, int spawnpoint)
{
	//This function gets the random npc number from the list and recalls
	//addrespawnnpc passing the new number
	char sect[512];
	unsigned int uiTempList[100];
	int i=0,j=0,k=0;
	openscript("npc.scp");
	sprintf(sect, "NPCLIST %s", npclist);
	if (!npc_script.find(sect))
	{
		closescript();
		return -1;
	}
	do
	{
		read1();
		if (script1[0]!='}')
		{
			uiTempList[i]=str2num(script1);
			i++;
		}
	}
	while (script1[0]!='}');
	closescript();
	if(i>0)
	{
		i=rand()%(i);
		k=uiTempList[i];
	}
	/*  openscript("npc.scp");
  if(!npc_script.find(sect))
  {
	closescript();
	return;
  }
  do
  {
	read1();
	if (script1[0]!='}')
	{
	if(j==i)
	{
	k=str2num(script1);
	j++;
	}
	else j++;
	}
  }
  while (script1[0]!='}');
  closescript();
}*/
	if(k!=0)
	{
		if (spawnpoint==-1)
		{
			addmitem[s]=k;
			npcmenutarget(s);
			return -1;
		}
		else
		{
			return k; //addrespawnnpc(spawnpoint,k,1);
		}
	}
	return -1;
}

void addrandomitem(int s, char * itemlist, int spawnpoint) //Tauriel will be removed
{
 //This function gets the random npc number from the list and recalls
 //addrespawnnpc passing the new number
 char sect[512];
 int i=0,j=0,k=0;
 openscript("items.scp");
 sprintf(sect, "ITEMLIST %s", itemlist);
 if (!items_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read1();
  if (script1[0]!='}')
  {
   i++;
  }
 }
 while (script1[0]!='}');
 closescript();
 if(i>0)
 {
  i=rand()%(i);
  openscript("items.scp");
  if(!items_script.find(sect))
  {
   closescript();
   return;
  }
  do
  {
   read1();
   if (script1[0]!='}')
   {
   if(j==i)
      {
         k=str2num(script1);
         j++;
   }
   else j++;
   }
  }
  while (script1[0]!='}');
  closescript();
 }
 if(k!=0)
 {
  if (spawnpoint==-1)
  {
   addmitem[s]=k;
   addmenutarget(s, 0, addmitem[s]);
  }
  else
  {
  addrespawnitem(spawnpoint,k,1);
  }
 }
}


void showgmque(int s, int type) // Shows next unhandled call in the GM queue
{
 
 // Type is 0 if it is a Counselor doing the command (or a GM doing /cq) and 1 if it is a GM

 int i;
 int x=0;

 if(type==1) //Player is a GM
 {
  for(i=1;i<MAXPAGES;i++)
  {
   if (gmpages[i].handled==0)
   {
    if(x==0)
    {
     sysmessage(s,"");
     sprintf(temp,"Next unhandled page from %s", gmpages[i].name);
     sysmessage(s,temp);
     sprintf(temp,"Problem: %s.", gmpages[i].reason);
     sysmessage(s,temp);
     sprintf(temp,"Serial number %x %x %x %x", gmpages[i].ser1, gmpages[i].ser2, gmpages[i].ser3, gmpages[i].ser4);
     sysmessage(s,temp);
     sprintf(temp,"Paged at %s.", gmpages[i].timeofcall);
     sysmessage(s,temp);
    }
    x++;
   }
  }
  if (x>0)
  {
   sprintf(temp,"Total pages in queue: %i",x);
   sysmessage(s,"");
   sysmessage(s,temp);
  }
  else sysmessage(s,"The GM queue is currently empty");
 } //end of first if
 else //Player is a counselor so show counselor queue
 {
  for(i=1;i<MAXPAGES;i++)
  {
   if (counspages[i].handled==0)
   {
    if(x==0)
    {
     sysmessage(s,"");
     sprintf(temp,"Next unhandled page from %s", counspages[i].name);
     sysmessage(s,temp);
     sprintf(temp,"Problem: %s.", counspages[i].reason);
     sysmessage(s,temp);
     sprintf(temp,"Serial number %x %x %x %x", counspages[i].ser1, counspages[i].ser2, counspages[i].ser3, counspages[i].ser4);
     sysmessage(s,temp);
     sprintf(temp,"Paged at %s.", counspages[i].timeofcall);
     sysmessage(s,temp);
    }
    x++;
   }
  }
  if (x>0)
  {
   sprintf(temp,"Total pages in queue: %i",x);
   sysmessage(s,"");
   sysmessage(s,temp);
  }
  else sysmessage(s,"The Counselor queue is currently empty");
 }
}

void initque() // Initilizes the gmpages[] and counspages[] arrays and also jails
{
 int i;
 for(i=1;i<MAXPAGES;i++)
 {
  *(gmpages[i].name)='\0'; // was sprintf(gmpages[i].name,"");
  *(gmpages[i].reason)='\0'; // was sprintf(gmpages[i].reason,"");
  gmpages[i].ser1='\x00';
  gmpages[i].ser2='\x00';
  gmpages[i].ser3='\x00';
  gmpages[i].ser4='\x00';
  gmpages[i].timeofcall[0]=0;
  gmpages[i].handled=1;
 }
 for(i=1;i<MAXPAGES;i++)
 {
  *(counspages[i].name)='\0'; // was sprintf(counspages[i].name,"");
  *(counspages[i].reason)='\0'; // was sprintf(counspages[i].reason,"");
  counspages[i].ser1='\x00';
  counspages[i].ser2='\x00';
  counspages[i].ser3='\x00';
  counspages[i].ser4='\x00';
  counspages[i].timeofcall[0]=0;
  counspages[i].handled=1;
 }
 jails[1].x=5276; // Jail1
 jails[1].y=1164;
 jails[1].z=0;
 jails[1].occupied=0;

 jails[2].x=5286; // Jail2
 jails[2].y=1164;
 jails[2].z=0;
 jails[2].occupied=0;

 jails[3].x=5296; // Jail3
 jails[3].y=1164;
 jails[3].z=0;
 jails[3].occupied=0;

 jails[4].x=5306; // Jail4
 jails[4].y=1164;
 jails[4].z=0;
 jails[4].occupied=0;

 jails[5].x=5276; // Jail5
 jails[5].y=1174;
 jails[5].z=0;
 jails[5].occupied=0;

 jails[6].x=5286; // Jail6
 jails[6].y=1174;
 jails[6].z=0;
 jails[6].occupied=0;

 jails[7].x=5296; // Jail7
 jails[7].y=1174;
 jails[7].z=0;
 jails[7].occupied=0;

 jails[8].x=5306; // Jail8
 jails[8].y=1174;
 jails[8].z=0;
 jails[8].occupied=0;

 jails[9].x=5283; // Jail9
 jails[9].y=1184;
 jails[9].z=0;
 jails[9].occupied=0;

 jails[10].x=5304; // Jail10
 jails[10].y=1184;
 jails[10].z=0;
 jails[10].occupied=0;
}

void nextcall(int s, int type)
{
  // Type is the same as it is in showgmqueue()

  int i,j;
  int x=0;

  if(chars[currchar[s]].callnum!=0)
  {
    donewithcall(s, type);
  }
  if(type==1) //Player is a GM
  {
    for(i=1;i<MAXPAGES;i++)
    {
      if(gmpages[i].handled==0)
      {
        for (j=0;j<charcount;j++)
        {
          if ((chars[j].ser1==gmpages[i].ser1)&&(chars[j].ser2==gmpages[i].ser2)&&
              (chars[j].ser3==gmpages[i].ser3)&&(chars[j].ser4==gmpages[i].ser4))
          {
            sysmessage(s,"");
            sprintf(temp,"Transporting to next call: %s", gmpages[i].name);
            sysmessage(s,temp);
            sprintf(temp,"Problem: %s.", gmpages[i].reason);
            sysmessage(s,temp);
            sprintf(temp,"Serial number %x %x %x %x", gmpages[i].ser1,
            gmpages[i].ser2, gmpages[i].ser3, gmpages[i].ser4);
            sysmessage(s,temp);
            sprintf(temp,"Paged at %s.", gmpages[i].timeofcall);
            sysmessage(s,temp);
            gmpages[i].handled=1;
            chars[currchar[s]].x=chars[j].x;
            chars[currchar[s]].y=chars[j].y;
            chars[currchar[s]].dispz=chars[currchar[s]].z=chars[j].z;
            chars[currchar[s]].callnum=i;
            teleport(currchar[s]);
            x++;
            break;
          }
        }
        if(x>0)break;
      }
    }
    if(x==0) sysmessage(s,"The GM queue is currently empty");
  } //end first IF
  else //Player is only a counselor
  {
    x=0;
    for(i=1;i<MAXPAGES;i++)
    {
      if(counspages[i].handled==0)
      {
        for (j=0;j<charcount;j++)
        {
          if ((chars[j].ser1==counspages[i].ser1)&&(chars[j].ser2==counspages[i].ser2)&&
              (chars[j].ser3==counspages[i].ser3)&&(chars[j].ser4==counspages[i].ser4))
          {
            sysmessage(s,"");
            sprintf(temp,"Transporting to next call: %s", counspages[i].name);
            sysmessage(s,temp);
            sprintf(temp,"Problem: %s.", counspages[i].reason);
            sysmessage(s,temp);
            sprintf(temp,"Serial number %x %x %x %x", counspages[i].ser1,
            counspages[i].ser2, counspages[i].ser3, counspages[i].ser4);
            sysmessage(s,temp);
            sprintf(temp,"Paged at %s.", counspages[i].timeofcall);
            sysmessage(s,temp);
            gmpages[i].handled=1;
            chars[currchar[s]].x=chars[j].x;
            chars[currchar[s]].y=chars[j].y;
            chars[currchar[s]].dispz=chars[currchar[s]].z=chars[j].z;
            chars[currchar[s]].callnum=i;
            teleport(currchar[s]);
            x++;
            break;
          }
        }
        if(x>0)break;
      }
    }
    if(x==0) sysmessage(s,"The Counselor queue is currently empty");
  }
}

void donewithcall(int s, int type)
{
 if(chars[currchar[s]].callnum!=0) //Player is on a call
 {
  if(type==1) //Player is a GM
  {
   gmpages[chars[currchar[s]].callnum].handled=1;
   *(gmpages[chars[currchar[s]].callnum].name)='\0'; // was sprintf(gmpages[chars[currchar[s]].callnum].name,"");
   *(gmpages[chars[currchar[s]].callnum].reason)='\0'; // was sprintf(gmpages[chars[currchar[s]].callnum].reason,"");
   gmpages[chars[currchar[s]].callnum].ser1=0;
   gmpages[chars[currchar[s]].callnum].ser2=0;
   gmpages[chars[currchar[s]].callnum].ser3=0;
   gmpages[chars[currchar[s]].callnum].ser4=0;
   chars[currchar[s]].callnum=0;
   sysmessage(s,"Call removed from the GM queue.");
  }
  else //Player is a counselor
  {
   counspages[chars[currchar[s]].callnum].handled=1;
   *(counspages[chars[currchar[s]].callnum].name)='\0'; // was sprintf(counspages[chars[currchar[s]].callnum].name,"");
   *(counspages[chars[currchar[s]].callnum].reason)='\0'; // was sprintf(counspages[chars[currchar[s]].callnum].reason,"");
   counspages[chars[currchar[s]].callnum].ser1=0;
   counspages[chars[currchar[s]].callnum].ser2=0;
   counspages[chars[currchar[s]].callnum].ser3=0;
   counspages[chars[currchar[s]].callnum].ser4=0;
   chars[currchar[s]].callnum=0;
   sysmessage(s,"Call removed from the Counselor queue.");
  }
 }
 else
 {
  sysmessage(s,"You are currently not on a call");
 }
}

void gotocurcall(int s) //Teleport you to the player who called you if they leave
{
 int i;
 int x=0;

 if(chars[currchar[s]].callnum==0)
 {
  sysmessage(s,"You are not currently on a call.");
 }
 else
 {  
  {
   for(i=0;i<charcount;i++)
   {
    if(chars[i].ser1==gmpages[chars[currchar[s]].callnum].ser1 && chars[i].ser2==gmpages[chars[currchar[s]].callnum].ser2 && chars[i].ser3==gmpages[chars[currchar[s]].callnum].ser3 && chars[i].ser4==gmpages[chars[currchar[s]].callnum].ser4)
    {
     chars[currchar[s]].x=chars[i].x;
     chars[currchar[s]].y=chars[i].y;
     chars[currchar[s]].dispz=chars[currchar[s]].z=chars[i].z;
     sysmessage(s,"Transporting to your current call.");
     teleport(currchar[s]);
     x++;
     break;
    }
   }  
   if(x==0)
   {
   for(i=0;i<charcount;i++)
   {
    if(chars[i].ser1==counspages[chars[currchar[s]].callnum].ser1 && chars[i].ser2==counspages[chars[currchar[s]].callnum].ser2 && chars[i].ser3==counspages[chars[currchar[s]].callnum].ser3 && chars[i].ser4==counspages[chars[currchar[s]].callnum].ser4)
    {
     chars[currchar[s]].x=chars[i].x;
     chars[currchar[s]].y=chars[i].y;
     chars[currchar[s]].dispz=chars[currchar[s]].z=chars[i].z;
     sysmessage(s,"Transporting to your current call.");
     teleport(currchar[s]);
     break;
    }
   }
   }
  }
 }
}

void gmtransfer(int s)
{
 int i;
 int x2=0;

 if(chars[currchar[s]].callnum!=0)
 {
  if(!(chars[currchar[s]].priv&1)) //Char is a counselor
  {
   for(i=1;i<MAXPAGES;i++)
   {
    if(gmpages[i].handled==1)
    {
     gmpages[i].handled=0;
     sprintf(gmpages[i].name,counspages[chars[currchar[s]].callnum].name);
     sprintf(gmpages[i].reason,counspages[chars[currchar[s]].callnum].reason);
     gmpages[i].ser1=counspages[chars[currchar[s]].callnum].ser1;
     gmpages[i].ser2=counspages[chars[currchar[s]].callnum].ser2;
     gmpages[i].ser3=counspages[chars[currchar[s]].callnum].ser3;
     gmpages[i].ser4=counspages[chars[currchar[s]].callnum].ser4;
     time_t current_time = time(0);
     struct tm *local = localtime(&current_time);
     sprintf(gmpages[i].timeofcall, "%02d:%02d:%02d", local->tm_hour, local->tm_min, local->tm_sec);
     x2++;
     break;
    }
   }
   if (x2==0)
   {
    sysmessage(s,"The GM Queue is currently full. Contact the shard operator");
    sysmessage(s,"and ask them to increase the size of the queue.");
   }
   else
   {
    sysmessage(s,"Call successfully transferred to the GM queue.");
    donewithcall(s,1);
   }
  }
  else
  {
   sysmessage(s,"Only Counselors may use this command.");
  }
 }
 else
 {
  sysmessage(s,"You are not currently on a call");
 }
}

void jailtarget(int s,int c)
{
  int i,tmpnum=0,serial;
  int x=0;
  if (c==-1)
	  {
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);	  
  if (i!=-1)
  tmpnum=i;
	  }
else
	  {
  i=findbyserial(&charsp[c%256], c, 1);
  tmpnum=i;
	  }

		if(chars[tmpnum].cell>0)
		{
		sysmessage(s,"That player is already in jail!");
		return;
		}

    for (i=1;i<11;i++)
    {
      if(jails[i].occupied==0)
      {
        chars[tmpnum].oldx=chars[tmpnum].x;
        chars[tmpnum].oldy=chars[tmpnum].y;
        chars[tmpnum].oldz=chars[tmpnum].z;
        chars[tmpnum].x=jails[i].x;
        chars[tmpnum].y=jails[i].y;
        chars[tmpnum].dispz=chars[tmpnum].z=jails[i].z;
        chars[tmpnum].cell=i;
        teleport(tmpnum);
        jails[i].occupied=1;
        sprintf(temp,"Player %s has been jailed in jail %i.",chars[tmpnum].name,i);
        sysmessage(s,temp);
        x++;
        break;
		  }
		}
    if(x==0) sysmessage(s,"All jails are currently full!");
	  
}

void releasetarget(int s,int c)
  {
  int i,serial;
if(c==-1)
	{
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);	
	}
	else
		{
		i=findbyserial(&charsp[c%256], c, 1);
	//	i=c;
		}
 if (i!=-1)
  {
    if(chars[i].cell==0)
    {
      sysmessage(s,"That player is not in jail!");
    }
    else
    {
      jails[chars[i].cell].occupied=0;
      chars[i].x=chars[i].oldx;
      chars[i].y=chars[i].oldy;
      chars[i].dispz=chars[i].z=chars[i].oldz;
      chars[i].cell=0;
      teleport(i);
      sprintf(temp,"Player %s released.",chars[i].name);
      sysmessage(s,temp);
    }
  }
}

void gmopentarget(int s)
{
 int i,serial,serhash,ci;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && (items[i].layer==addmitem[s]))
    {
      backpack(s,items[i].ser1,items[i].ser2,items[i].ser3,items[i].ser4);
      return;
    }
  }
  sysmessage(s,"No object was found at that layer on that character");
}

void staminatarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    soundeffect2(i, 0x01, 0xF2);
    staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
    chars[i].stm=chars[i].dx;
    updatestats(i, 2);
    return;
  }
  sysmessage(s,"That is not a person.");
}

void manatarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    soundeffect2(i, 0x01, 0xF2);
    staticeffect(i, 0x37, 0x6A, 0x09, 0x06);
    chars[i].mn=chars[i].in;
    updatestats(i, 1);
    return;
  }
  sysmessage(s,"That is not a person.");
}

void makeshoptarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    makeshop(i);
    teleport(i);
    sysmessage(s, "The buy containers have been added.");
    return;
  }
  sysmessage(s, "Target character not found...");
}

void makeshop(int c)
{
 int i,n,serial,serhash,ci, skip=0;
 chars[c].shop=1;
  serial=chars[c].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && (items[i].layer==0x1A))
    {
      skip=1;
      break;
    }
  }
 if (skip==0)
 {
  n=SpawnItem(calcSocketFromChar(c),1,"#",0,0x2A,0xF8,0,0,0,0);
  setserial(n,c,4);
  items[n].layer=0x1A;
  items[n].type=1;
  items[n].priv=items[n].priv|0x02;
 }
 skip=0;

  serial=chars[c].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && (items[i].layer==0x1B))
    {
      skip=1;
      break;
    }
  }
 if (skip==0)
 {
  n=SpawnItem(calcSocketFromChar(c),1,"#",0,0x2A,0xF8,0,0,0,0);
  setserial(n,c,4);
  items[n].layer=0x1B;
  items[n].type=1;
  items[n].priv=items[n].priv|0x02;
 }
  serial=chars[c].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial) && (items[i].layer==0x1C))
    {
      skip=1;
      break;
    }
  }
 if (skip==0)
 {
  n=SpawnItem(calcSocketFromChar(c),1,"#",0,0x2A,0xF8,0,0,0,0);
  setserial(n,c,4);
  items[n].layer=0x1C;
  items[n].type=1;
  items[n].priv=items[n].priv|0x02;
 }
}

int response(int s)
{
 char buffer1[MAXBUFFER];
 int i,j;
 int k;
 char *comm;

 char *response1;
 char *response2;
 char *response3;

 char search1[50];
 char search2[50];
 char search3[50];

 char nonuni[512];
 char temp[512];
 char temp2[512];
 int x=-1;
 int y=0;

 if(chars[currchar[s]].unicode)
 for (i=13;i<(buffer[s][1]*256)+buffer[s][2];i=i+2)
  {
    nonuni[(i-13)/2]=buffer[s][i];
  } 
 
 if(!(chars[currchar[s]].unicode))
 {
 for (i=7; i < MAXBUFFER; i++)
 {
  tbuffer[i]=buffer1[i];
  buffer1[i]=toupper(buffer[s][i]);
 }
 }
 else
 {
 for (i=0; i < MAXBUFFER-8; i++)
 {
  tbuffer[i+8]=buffer1[i+8];
  buffer1[i+8]=toupper(nonuni[i]);
 }
 }



 comm=&buffer1[8];

  for(k=0;k<charcount;k++)
  if (abs(chars[currchar[s]].x-chars[k].x)<=2 &&
      abs(chars[currchar[s]].y-chars[k].y)<=2 &&
      abs(chars[currchar[s]].z-chars[k].z)<=5)
  {
    if (chars[k].trigger)
    {
      if (strlen(chars[k].trigword))
      {
        sprintf(search1, chars[k].trigword);
        strupr(search1);
        response1=(strstr( comm, search1));
        if (response1 && (!(chars[currchar[s]].dead)))
        {
          if (chars[k].disabled)
          {
            npctalkall(k,"I'm a little busy now! Leave me be!");
          } else {
           triggernpc(currchar[s],k);
          }
          return 1;
        }
      }
    }
  }

 sprintf(search1,"BANK");
 response1=(strstr( comm, search1));
 if (response1 && (!(chars[currchar[s]].dead)) && inbankrange(currchar[s]))
 {
  openbank(s, currchar[s]);
 }
/*
 sprintf(search1, "VENDOR");
 sprintf(search2, "SHOPKEEPER");
 sprintf(search3, "NPC");
 sprintf(search4, " BUY");
 response1=(strstr( comm, search1));
 response2=(strstr( comm, search2));
 response3=(strstr( comm, search3));
 response4=(strstr( comm, search4));

 if ((response1 || response2 || response3) && response4)
 {
  for(k=0;k<charcount;k++)
  if (abs(chars[currchar[s]].x-chars[k].x)<=1 &&
      abs(chars[currchar[s]].y-chars[k].y)<=1 &&
      abs(chars[currchar[s]].z-chars[k].z)<=5)
  {
   if (buyshop(s, k)) k=charcount;
  }
 }

 sprintf(search4, " SELL");
 response4=(strstr( comm, search4));
 if (response4)
 {
  for(k=0;k<charcount;k++)
  if (abs(chars[currchar[s]].x-chars[k].x)<=1 &&
      abs(chars[currchar[s]].y-chars[k].y)<=1 &&
      abs(chars[currchar[s]].z-chars[k].z)<=5)
  {
   if (sellstuff(s, k)) k=charcount;
  }
 }
*/
 // This training code is by Anthracks (fred1117@tiac.net) and really psychotic
 // if it doesn't work or you can't decipher it, you know who to blame
	sprintf(search1,"TRAIN");
	sprintf(search2,"TEACH");
	sprintf(search3,"LEARN");
	response1=(strstr( comm, search1));
	response2=(strstr( comm, search2));
	response3=(strstr( comm, search3));
	if (response1 || response2 || response3) //if the player wants to train
	{
		unsigned int nChar=currchar[s];  //for the chars[] #
		chars[nChar].trainer=-1; //this is to prevent errors when a player says "train <skill>" then doesn't pay the npc
		for(i=0;i<ALLSKILLS;i++)
		{
			if(strstr(comm, skillname[i]))
			{
				x=i;
				break;
			}
		}
		if(x==-1) // Didn't ask to be trained in a specific skill
		{
			if(chars[nChar].trainer==-1) //not being trained, asking what skills they can train in
			{
				for (k=0;k<charcount;k++)
				{
					if (chars[k].npc)
					{
						if (chardist(k, currchar[s])<=1 && chars[k].id1==0x01 && (chars[k].id2==0x90 || chars[k].id2==0x91))
						{
							if(!chars[k].cantrain)
							{
								npctalk(s, k, "I am sorry, but I have nothing to teach thee");
								return 1;
							}
							chars[k].trainingplayerin=-1; // Like above, this is to prevent  errors when a player says "train <skill>" then doesn't pay the npc
							sprintf(temp,"%s", "I can teech thee the following skills: ");
							for(j=0;j<ALLSKILLS;j++)
							{
								if(chars[k].baseskill[j]>10)
								{
									sprintf(temp2,"%s, ", strlwr(skillname[j]));
									strupr(skillname[j]); // I found out strlwr changes the actual  string permanently, so this undoes that
									if(!y) temp2[0]=toupper(temp2[0]); // If it's the first skill,  capitalize it.
									strcat(temp,temp2);
									y++;
								}
							}
							if(y)
							{
								temp[strlen(temp)-2]='.'; // Make last character a . not a ,  just to look nicer
								npctalk(s, k, temp);
							}
							else
							{
								npctalk(s, k, "I am sorry, but I have nothing to teach thee");
							}
							return 1;
						}
					}
				}
			} // End it .trainer if statement
		} // The if for if they are asking to train in a specific skill
		else // They do want to learn a specific skill
		{
			for (k=0;k<charcount;k++)
			{
				if (chars[k].npc)
				{
					if (chardist(k, nChar)<=1 && (chars[k].id1==0x01 && ((chars[k].id2==0x90) || (chars[k].id2==0x91))))
					{
						if(!chars[k].cantrain)
						{
							npctalk(s, k, "I am sorry, but I have nothing to teach thee");
							return 1;
						}
						if(chars[k].baseskill[x]>10)
						{
							sprintf(temp,"Thou wishest to learn of  %s?",strlwr(skillname[x]));
							strupr(skillname[x]); // I found out strlwr changes the actual string permanently, so this undoes that
							if(chars[nChar].baseskill[x]>=250)
							{
								strcat(temp, " I can teach thee no more than thou already knowest!");
							}
							else
							{
								if(chars[k].baseskill[x]<=250)
								{
									sprintf(temp2, " Very well I, can train thee up to the level of %i percent for %i gold. Pay for less and I shall teach thee less.",(int)(chars[k].baseskill[x]/2/10),(int)(chars[k].baseskill[x]/2)-chars[nChar].baseskill[x]);
								}
								else
								{
									sprintf(temp2, " Very well I, can train thee up to the level of %i percent for %i gold. Pay for less and I shall teach thee less.",25,250-chars[nChar].baseskill[x]);
								}
								strcat(temp, temp2);
								chars[nChar].trainer=chars[k].serial;
								chars[k].trainingplayerin=x;
							}
							npctalk(s, k, temp);
							return 1;
						} // They cannot teach x skill
						else
						{npctalk(s, k, "I am sorry but I cannot train thee in that skill."); return 1; }
					}
				}
			}
		} // end the else
	}

 sprintf(search1," FOLLOW");
 sprintf(search2," ME");
 response1=(strstr( comm, search1));
 response2=(strstr( comm, search2));

 if (response1) //if follow
 {
  for (k=0;k<charcount;k++)
  {
   //printf("%i \n", k);
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      if (response2) //if me is in
      {
       chars[k].ftarg=(currchar[s]);
       chars[k].npcWander=1;
       return 1;
      }
      else
      {
       //add pet follow code here
       addid1[s]=chars[k].ser1;
       addid2[s]=chars[k].ser2;
       addid3[s]=chars[k].ser3;
       addid4[s]=chars[k].ser4;
       target(s, 0, 1, 0, 117, "Click on the target to follow.");
       return 1;
      }
     }
    }
   }
  }
 }
 sprintf(search1," KILL");
 sprintf(search2," ATTACK");
 response1=(strstr( comm, search1));
 response2=(strstr( comm, search2));
 if ((response1)||(response2)) //if kill||attack
 {
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      addid1[s]=chars[k].ser1;
      addid2[s]=chars[k].ser2;
      addid3[s]=chars[k].ser3;
      addid4[s]=chars[k].ser4;
      //pet kill code here
      target(s, 0, 1, 0, 118, "Select the target to attack.");
      return 1;
     }
    }
   }
  }
 }
 sprintf(search1," FETCH");
 sprintf(search2," GET");
 response1=(strstr( comm, search1));
 response2=(strstr( comm, search2));
 if ((response1)||(response2)) //if fetch||get
 {
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      addid1[s]=chars[k].ser1;
      addid2[s]=chars[k].ser2;
      addid3[s]=chars[k].ser3;
      addid4[s]=chars[k].ser4;
      //pet fetch code here
      target(s, 0, 1, 0, 120, "Click on the object to fetch.");
      return 1;
     }
    }
   }
  }
 }

 sprintf(search1," COME");
 response1=(strstr( comm, search1));
 if (response1) //if come
 {
  int k;
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      chars[k].ftarg=(currchar[s]);
      chars[k].npcWander=1;
      sysmessage(s, "Your pet begins following you.");
      return 1;
     }
    }
   }
  }
 }

 sprintf(search1," GUARD");
 sprintf(search2," ME");
 response1=(strstr( comm, search1));
 response2=(strstr( comm, search2));
 if (response1) //if guard
 {
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      if (response2) //if me is in
      {
       sysmessage(s, "Your pet would now be guarding you, if it could.");
       //add pet guard me code here
       return 1;
      }
      else
      {
       sysmessage(s, "You would now get a targeting cursor, if guarding worked.");
       //add pet guard code here
       return 1;
      }
     }
    }
   }
  }
 }

 sprintf(search1," STOP");
 response1=(strstr( comm, search1));
 if (response1) //if stop
 {
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      //pet stop code here
      chars[k].ftarg=-1;
      chars[k].targ=-1;
      if (chars[k].war) npcToggleCombat(k);
      chars[k].npcWander=0;
      return 1;
     }
    }
   }
  }
 }
 sprintf(search1," TRANSFER");
 response1=(strstr( comm, search1));
 if (response1) //if transfer
 {
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
      //pet transfer code here
      addid1[s]=chars[k].ser1;
      addid2[s]=chars[k].ser2;
      addid3[s]=chars[k].ser3;
      addid4[s]=chars[k].ser4;
      target(s, 0, 1, 0, 119, "Select character to transfer your pet to.");
      return 1;
     }
    }
   }
  }
 }
 sprintf(search1," RELEASE");
 response1=(strstr( comm, search1));
 if (response1) //if transfer
 {
  for (k=0;k<charcount;k++)
  {
   if (chars[k].ownserial==chars[currchar[s]].serial)
   {
    strcpy(search3,chars[k].name);
    strupr(search3);
    response3=(strstr( comm, search3));
    if (response3) //if petname is in
    {
     if (chardist(k, currchar[s])<=7)
     {
        if (chars[k].summontimer)
        {
          chars[k].summontimer=getclock();
        }
      //pet release code here
      chars[k].ftarg=-1;
      chars[k].npcWander=2;
      removefromptr(&cownsp[chars[k].ownserial%256], k);
      chars[k].own1=255;
      chars[k].own2=255;
      chars[k].own3=255;
      chars[k].own4=255;
      chars[k].ownserial=-1;
      sprintf(temp, "*%s appears to have decided that it is better off without a master *", chars[k].name);
      npctalkall(k,temp);
          if (chars[k].summontimer)
          {
           soundeffect(i, 0x01, 0xFE);
           deletechar(k) ;
          }
      return 1;
     }
    }
   }
  }
 }
 return 0;
}

void responsevendor(int s)
{
 char buffer1[MAXBUFFER];
 int i;
 int k;
 char *comm;

 char *response1;
 char *response2;
 char *response3;
 char *response4;

 char search1[50];
 char search2[50];
 char search3[50];
 char search4[50];

 char nonuni[512];

if(chars[currchar[s]].unicode)
 for (i=13;i<(buffer[s][1]*256)+buffer[s][2];i=i+2)
  {
    nonuni[(i-13)/2]=buffer[s][i];
  } 
 
 if(!(chars[currchar[s]].unicode))
 {
 for (i=7; i < MAXBUFFER; i++)
 {
  tbuffer[i]=buffer1[i];
  buffer1[i]=toupper(buffer[s][i]);
 }
 }
 else
 {
 for (i=0; i < MAXBUFFER-8; i++)
 {
  tbuffer[i+8]=buffer1[i+8];
  buffer1[i+8]=toupper(nonuni[i]);
 }
 }

 comm=&buffer1[8];

 sprintf(search1, "VENDOR");
 sprintf(search2, "SHOPKEEPER");
 sprintf(search3, "NPC");
 sprintf(search4, " BUY");
 response1=(strstr( comm, search1));
 response2=(strstr( comm, search2));
 response3=(strstr( comm, search3));
 response4=(strstr( comm, search4));

 if ((response1 || response2 || response3) && response4)
 {
  for(k=0;k<charcount;k++)
  if (abs(chars[currchar[s]].x-chars[k].x)<=3 &&
      abs(chars[currchar[s]].y-chars[k].y)<=3 &&
      abs(chars[currchar[s]].z-chars[k].z)<=5)
  {
   if (buyshop(s, k)) k=charcount;
  }
 }

 sprintf(search4, " SELL");
 response4=(strstr( comm, search4));
 if (response4)
 {
  for(k=0;k<charcount;k++)
  if (abs(chars[currchar[s]].x-chars[k].x)<=3 &&
      abs(chars[currchar[s]].y-chars[k].y)<=3 &&
      abs(chars[currchar[s]].z-chars[k].z)<=5 && currchar[s]!=k)
  {
   if (sellstuff(s, k)) k=charcount;
  }
 }
 return;
}


void attacktarget(int s)
{
 int target, target2;

 target=calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
 target2=calcCharFromSer(buffer[s][7], buffer[s][8], buffer[s][9], buffer[s][10]);

 if (target2==-1 || target==-1) return;
 npcattacktarget(target2, target);
}

void followtarget(int s)
{
 int char1, char2;

 char1=calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
 char2=calcCharFromSer(buffer[s][7], buffer[s][8], buffer[s][9], buffer[s][10]);

 chars[char1].ftarg=char2;
 chars[char1].npcWander=1;
}

void transfertarget(int s)
{
 int char1, char2;
 char t[120];

 char1=calcCharFromSer(addid1[s], addid2[s], addid3[s], addid4[s]);
 char2=calcCharFromSer(buffer[s][7], buffer[s][8], buffer[s][9], buffer[s][10]);

 sprintf(t,"* %s will now take %s as his master *",chars[char1].name,chars[char2].name);
 npctalkall(char1,t);

 removefromptr(&cownsp[chars[char1].ownserial%256], char1);
 setserial(char1,char2, 5);
 chars[char1].npcWander=1;

 chars[char1].ftarg=-1;
 chars[char1].npcWander=0;
}

void buyshoptarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if ((i!=-1) && (chars[i].serial==serial))
  {
   buyshop(s, i);
   return;
  }
  sysmessage(s, "Target shopkeeper not found...");
}

int buyshop(int s, int c)
{
 int i, cont1, cont2,serial,serhash,ci;
 char shopgumpopen[8]="\x24\x00\x00\x00\x01\x00\x30";

 cont1=-1;
 cont2=-1;
  serial=chars[c].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))
    {
      if (items[i].layer==0x1A)
      {
        cont1=i;
      }
      else if (items[i].layer==0x1B)
      {
        cont2=i;
      }
    }
  }

 if (cont1==-1 || cont2==-1)
 {
  return 0;
 }

 impowncreate(s, c, 0); // Send the NPC again to make sure info is current. (OSI does this we might not have to)
 sendshopinfo(s, c, cont1); // Send normal shop itemsa
 sendshopinfo(s, c, cont2); // Send items sold to shop by players
 shopgumpopen[1]=chars[c].ser1;
 shopgumpopen[2]=chars[c].ser2;
 shopgumpopen[3]=chars[c].ser3;
 shopgumpopen[4]=chars[c].ser4;
 xsend(s, shopgumpopen, 7, 0);
 statwindow(s,currchar[s]); // Make sure the gold total has been sent.
 return 1;
}

void sendshopinfo(int s, int c, int i)
{
	char m1[4096];
	char m2[4096];
	char itemname[256];
	char cFoundItems=0;
	memset(m1,0,4096);
	memset(m2,0,4096);
	memset(itemname,0,256);
	int j, k, m1t, m2t, value,serial,serhash,ci;

	m1[0]=0x3C; // Container content message
	m1[1]=0;// Size of message
	m1[2]=0;// Size of message
	m1[3]=0;// Count of items
	m1[4]=0;// Count of items
	m2[0]=0x74;// Buy window details message
	m2[1]=0;// Size of message
	m2[2]=8;// Size of message
	m2[3]=items[i].ser1;// Container object
	m2[4]=items[i].ser2;// Container object
	m2[5]=items[i].ser3;// Container object
	m2[6]=items[i].ser4;// Container object
	m2[7]=0; // Count of items;
	m1t=5;
	m2t=8;
  serial=items[i].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    j=contsp[serhash].pointer[ci];
    if ((j!=-1) && (items[j].contserial==serial) &&
        (m2[7]!=255) && (items[j].amount!=0)) // 255 items max per shop container
    {
      m1[m1t+0]=items[j].ser1;//Item serial number
      m1[m1t+1]=items[j].ser2;//Item serial number
      m1[m1t+2]=items[j].ser3;//Item serial number
      m1[m1t+3]=items[j].ser4;//Item serial number
      m1[m1t+4]=items[j].id1; //Item art id number
      m1[m1t+5]=items[j].id2; //Item art id number
      m1[m1t+6]=0;            //Always zero
      m1[m1t+7]=items[j].amount/256;//Amount for sale
      m1[m1t+8]=items[j].amount%256;//Amount for sale
      m1[m1t+9]=j/256;//items[j].x/256; //Item x position
      m1[m1t+10]=j%256;//items[j].x%256;//Item x position
      m1[m1t+11]=j/256;//items[j].y/256;//Item y position
      m1[m1t+12]=j%256;//items[j].y%256;//Item y position
      m1[m1t+13]=items[i].ser1; //Container serial number
      m1[m1t+14]=items[i].ser2; //Container serial number
      m1[m1t+15]=items[i].ser3; //Container serial number
      m1[m1t+16]=items[i].ser4; //Container serial number
      m1[m1t+17]=items[j].color1;//Item color
      m1[m1t+18]=items[j].color2;//Item color
      m1[4]++; // Increase item count.
      m1t=m1t+19;
      value=items[j].value;
      value=calcValue(j, value);
      m2[m2t+0]=value/16777216;// Item value/price
      m2[m2t+1]=value/65536;//Item value/price
      m2[m2t+2]=value/256; // Item value/price
      m2[m2t+3]=value%256; // Item value/price
      m2[m2t+4]=getname(j, itemname); // Item name length
			//printf("[%x %x] %i - %s\n",items[j].id1, items[j].id2, items[j].amount, itemname);
      for(k=0;k<m2[m2t+4];k++)
      {
        m2[m2t+5+k]=itemname[k];
      }
      m2t=m2t+(m2[m2t+4])+5;
      m2[7]++;
			cFoundItems=1; //we found items so send message
    }
  }
  m1[1]=m1t/256;
  m1[2]=m1t%256;
  m2[1]=m2t/256;
  m2[2]=m2t%256;
	if (cFoundItems==1)
	{
		xsend(s, m1, m1t, 0);
    xsend(s, m2, m2t, 0);
	}
}

int getname(int i, char* itemname)
{
 tile_st tile;
 int j, len, mode, used, ok;
 if (items[i].name[0]!='#')
 {
  sprintf(itemname, items[i].name);
  return strlen(itemname)+1;
 }
 seektile((items[i].id1*256)+items[i].id2, &tile);
 if (tile.flag2&0x80) sprintf(itemname, "an ");
 else if (tile.flag2&0x40) sprintf(itemname, "a ");
 else itemname[0]=0;
 mode=0;
 used=0;
 len=strlen(tile.name);
 for (j=0;j<len;j++)
 {
  ok=0;
  if ((tile.name[j]=='%')&&(mode==0)) mode=2;
  else if ((tile.name[j]=='%')&&(mode!=0)) mode=0;
  else if ((tile.name[j]=='/')&&(mode==2)) mode=1;
  else if (mode==0) ok=1;
  else if ((mode==1)&&(items[i].amount==1)) ok=1;
  else if ((mode==2)&&(items[i].amount>1)) ok=1;
  if (ok)
  {
   sprintf(itemname, "%s%c", itemname, tile.name[j]);
   if (mode) used=1;
  }
 }
 return strlen(itemname)+1;
}

void goldsfx(int s, int goldtotal)
{
    if (goldtotal==1) soundeffect(s, 0x00, 0x35);
    if ((goldtotal>1)&&(goldtotal<6)) soundeffect(s, 0x00, 0x36);
    else soundeffect(s, 0x00, 0x37);
    return;
}

void buyaction(int s)
{
	char clearmsg[8];
	int clear, i, j;
	int bitems[512];
	int amount[512];
	int layer[512];
	int playergoldtotal;
	int goldtotal;
	int itemtotal;
	int npc;
	int soldout;
	int p;

	p=packitem(currchar[s]);
	npc=calcCharFromSer(buffer[s][3], buffer[s][4], buffer[s][5], buffer[s][6]);
	clear=0;
	goldtotal=0;
	soldout=0;
	itemtotal=(((256*(buffer[s][1]))+buffer[s][2])-8)/7;
	for(i=0;i<itemtotal;i++)
	{
		layer[i]=buffer[s][8+(7*i)];
		bitems[i]=calcItemFromSer(buffer[s][8+(7*i)+1], buffer[s][8+(7*i)+2],
                               buffer[s][8+(7*i)+3], buffer[s][8+(7*i)+4]);
		amount[i]=(256*(buffer[s][8+(7*i)+5]))+buffer[s][8+(7*i)+6];
		goldtotal=goldtotal+(amount[i]*(items[bitems[i]].value));
	}
	playergoldtotal=getamount(currchar[s], 0x0E, 0xED);
	if ((playergoldtotal>=goldtotal)||(chars[currchar[s]].priv&1))
	{
		for (i=0;i<itemtotal;i++)
		{
			if (items[bitems[i]].amount<amount[i])
			{
				soldout=1;
			}
		}
		if (soldout)
		{
			npctalk(s, npc, "Alas, I no longer have all those goods in stock.  Let me know if there is something else thou wouldst buy.");
			clear=1;
		}
		else
		{
			if (chars[currchar[s]].priv&1)
			{
				sprintf(temp, "Here you are, %s. Someone as special as thee will receive my wares for free of course.", chars[currchar[s]].name);
			}
			else
			{
				if (goldtotal==1)
				{
					sprintf(temp, "Here you are, %s.  That will be %d gold coin.  I thank thee for thy business.", chars[currchar[s]].name, goldtotal);
				}
				else
				{
					sprintf(temp, "Here you are, %s.  That will be %d gold coins.  I thank thee for thy business.", chars[currchar[s]].name, goldtotal);
				}

				// Dupois, SFX for gold movement
				// Added Oct 08, 1998
				goldsfx(s, goldtotal);
			}
			npctalkall(npc, temp);

			clear=1;
			if (!(chars[currchar[s]].priv&1)) delequan(currchar[s], 0x0E, 0xED, goldtotal);
			for (i=0;i<itemtotal;i++)
			{
				if (items[bitems[i]].amount>amount[i])
        {
					if (items[bitems[i]].pileable)
					{
						dupeitem(s, bitems[i], amount[i]);
					}
					else
					{
						for (j=0;j<amount[i];j++)
						{
							dupeitem(s, bitems[i], 1);
						}
					}
					items[bitems[i]].amount=items[bitems[i]].amount-amount[i];
					items[bitems[i]].restock=items[bitems[i]].restock+amount[i];
        }
        else
        {
					switch(layer[i])
					{
						case 0x1A:
							if (items[bitems[i]].pileable)
							{
								dupeitem(s, bitems[i], amount[i]);
							}
							else
							{
								for (j=0;j<amount[i];j++)
								{
									dupeitem(s, bitems[i], 1);
								}
							}
							items[bitems[i]].amount=items[bitems[i]].amount-amount[i];
							items[bitems[i]].restock=items[bitems[i]].restock+amount[i];
							break;
						case 0x1B:
							if (items[bitems[i]].pileable)
							{
								if (items[bitems[i]].contserial!=-1)
									removefromptr(&contsp[items[bitems[i]].contserial%256], bitems[i]);
								items[bitems[i]].cont1=items[p].ser1;
								items[bitems[i]].cont2=items[p].ser2;
								items[bitems[i]].cont3=items[p].ser3;
								items[bitems[i]].cont4=items[p].ser4;
								items[bitems[i]].contserial=items[p].serial;
								if (items[bitems[i]].contserial!=-1)
								setptr(&contsp[items[bitems[i]].contserial%256], bitems[i]);
								for(j=0;j<now;j++) if (perm[j]) senditem(j, bitems[i]);
							}
							else
							{
								for (j=0;j<amount[i]-1;j++)
								{
									dupeitem(s, bitems[i], 1);
								}
								if (items[bitems[i]].contserial!=-1)
								removefromptr(&contsp[items[bitems[i]].contserial%256], bitems[i]);
								setserial(bitems[i],p,1);
								items[bitems[i]].amount=1;
								for(j=0;j<now;j++) if (perm[j]) senditem(j, bitems[i]);
							}
							break;
					}
        }
			}
		}
	}
	else
	{
		npctalkall(npc, "Alas, thou dost not possess sufficient gold for this purchase!");
	}

	if (clear)
	{
		clearmsg[0]=0x3B;
		clearmsg[1]=0x00;
		clearmsg[2]=0x08;
		clearmsg[3]=buffer[s][3];
		clearmsg[4]=buffer[s][4];
		clearmsg[5]=buffer[s][5];
		clearmsg[6]=buffer[s][6];
		clearmsg[7]=0x00;
		xsend(s, clearmsg, 8, 0);
	}
  //chars[currchar[s]].weight=calcweight(currchar[s]);
  statwindow(s,currchar[s]);
}


void setvaluetarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if ((i!=-1))
  {
   items[i].value=addx[s];
   return;
  }
  sysmessage(s, "Target item not found.");
}

void setrestocktarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if ((i!=-1))
  {
   items[i].restock=addx[s];
   return;
  }
 sysmessage(s, "Target item not found.");
}

void restock(int s)
{
 int i, a,serial,ci;
 int tt=getclock();

 for (i=0;i<itemcount;i++)
 {
  // Dupois - added this check to only restock items that ... well ... have a restock value >0
  // Added Oct 25, 1998
  if (items[i].restock && items[i].cont1>=0x40)
  {
    serial=items[i].contserial;
    ci=findbyserial(&itemsp[serial%256], serial, 0);
    if ((ci!=-1) && (items[ci].layer==0x1A))
    {
      if (s)
      {
        items[i].amount=items[i].amount+items[i].restock;
        items[i].restock=0;
      }
      else
      {
        if (items[i].restock>0)
        {
          a=min(items[i].restock, (items[i].restock/2)+1);
          items[i].amount=items[i].amount+a;
          items[i].restock=items[i].restock-a;
        }
      }
    }
  }
 }// printf(UOX3:  restock() - time to execute =%d\n", (getclock()-tt));
}
void who(int s)
{
 int i, j=0;
 sysmessage(s,"Current Users in the World:");
 for (i=0;i<now;i++)
 {
  if(perm[i]) //Keeps NPC's from appearing on the list
  {
   j++;
        sprintf(temp, "%i) %s [%x %x %x %x]", (j-1), chars[currchar[i]].name, chars[currchar[i]].ser1, chars[currchar[i]].ser2, chars[currchar[i]].ser3, chars[currchar[i]].ser4);
        sysmessage(s, temp);
   //sysmessage(s, chars[currchar[i]].name);
  }
 }
 sprintf(temp,"Total Users Online: %d\n", j);
 sysmessage(s,temp);
 sysmessage(s,"End of userlist");
}

void gms(int s)
{
 int i, j=0;
 sysmessage(s,"Current GMs and Counselors in the world:");
 for (i=0;i<now;i++)
 {
  if(perm[i] && ((chars[currchar[i]].priv&0x01)||(chars[currchar[i]].priv&0x80))) //Keeps NPC's from appearing on the list
  {
   j++;
   sysmessage(s, chars[currchar[i]].name);
  }
 }
 sprintf(temp, "Total Staff Online: %d\n", j);
 sysmessage(s, temp);
 sysmessage(s,"End of stafflist");
}

void playmonstersound(int monster, int id1, int id2, int sfx)
{
 int basesound=0;

 switch(id1)
 {
  case 0x00:
             switch(id2)
             {
              case 0x01:
                          basesound=0x01AB;
                          break;
              case 0x02:
                          basesound=0x016F;
                          break;
              case 0x03:
                          basesound=0x01D7;
                          break;
              case 0x04:
                          basesound=0x0174;
                          break;
              case 0x05:
                          basesound=0x008F;
                          break;
              case 0x06:
                          basesound=0x007D;
                          break;
              case 0x07:
                          basesound=0x01B0;
                          break;
              case 0x09:
                          basesound=0x0165;
                          break;
              case 0x0A:
                          basesound=0x0165;
                          break;
              case 0x0C:
                          basesound=0x016A;
                          break;
              case 0x0D:
                          basesound=0x0107;
                          break;
              case 0x0E:
                          basesound=0x010C;
                          break;
              case 0x0F:
                          basesound=0x0111;
                          break;
              case 0x10:
                          basesound=0x0116;
                          break;
              case 0x11:
                          basesound=0x01B0;
                          break;
              case 0x12:
                          basesound=0x016F;
                          break;
              case 0x15:
                          basesound=0x00DB;
                          break;
              case 0x16:
                          basesound=0x0179;
                          break;
              case 0x18:
                          basesound=0x019C;
                          break;
              case 0x1A:
                          basesound=0x017E;
                          break;
              case 0x1C:
                          basesound=0x0183;
                          break;
              case 0x1D:
                          basesound=0x009E;
                          break;
              case 0x1E:
                          basesound=0x0192;
                          break;
              case 0x1F:
                          basesound=0x0197;
                          break;
              case 0x21:
                          basesound=0x01A1;
                          break;
              case 0x23:
                          basesound=0x01A1;
                          break;
              case 0x24:
                          basesound=0x01A1;
                          break;
              case 0x27:
                          basesound=0x01A6;
                          break;
              case 0x29:
                          basesound=0x01B0;
                          break;
              case 0x2A:
                          basesound=0x01B5;
                          break;
              case 0x2C:
                          basesound=0x01B5;
                          break;
              case 0x2D:
                          basesound=0x01B5;
                          break;
              case 0x2F:
                          basesound=0x01BA;
                          break;
              case 0x30:
                          basesound=0x018D;
                          break;
              case 0x32:
                          basesound=0x01C3;
                          break;
              case 0x33:
                          basesound=0x01C8;
                          break;
              case 0x34:
                          basesound=0x00DB;
                          break;
              case 0x35:
                          basesound=0x01CD;
                          break;
              case 0x36:
                          basesound=0x01CD;
                          break;
              case 0x37:
                          basesound=0x01CD;
                          break;
              case 0x38:
                          basesound=0x01C3;
                          break;
              case 0x39:
                          basesound=0x01C3;
                          break;
              case 0x3A:
                          basesound=0x01D2;
                          break;
              case 0x3B:
                          basesound=0x016A;
                          break;
              case 0x3C:
                          basesound=0x016A;
                          break;
              case 0x3D:
                          basesound=0x016A;
                          break;
              case 0x97:
                          basesound=0x008A;
                          break;
              case 0xC8:
                          basesound=0x00A8;
                          break;
              case 0xC9:
                          basesound=0x0069;
                          break;
              case 0xCA:
                          basesound=0x005A;
                          break;
              case 0xCB:
                          basesound=0x00C4;
                          break;
              case 0xCC:
                          basesound=0x00A8;
                          break;
              case 0xCF:
                          basesound=0x00D7;
                          break;
              case 0xD0:
                          basesound=0x006E;
                          break;
              case 0xD1:
                          basesound=0x0099;
                          break;
              case 0xD3:
                          basesound=0x005F;
                          break;
              case 0xD4:
                          basesound=0x00A3;
                          break;
              case 0xD5:
                          basesound=0x005F;
                          break;
              case 0xD6:
                          basesound=0x00BA;
                          break;
              case 0xD7:
                          basesound=0x0188;
                          break;
              case 0xD8:
                          basesound=0x0078;
                          break;
              case 0xD9:
                          basesound=0x0085;
                          break;
              case 0xDD:
                          basesound=0x00E0;
                          break;
              case 0xE1:
                          basesound=0x00E5;
                          break;
              case 0xE2:
                          basesound=0x00A8;
                          break;
              case 0xE4:
                          basesound=0x00A8;
                          break;
              case 0xE7:
                          basesound=0x0078;
                          break;
              case 0xE8:
                          basesound=0x0064;
                          break;
              case 0xE9:
                          basesound=0x0078;
                          break;
              case 0xEE:
                          basesound=0x00CC;
                          break;
                         }
                }

switch(id1)
{
        case 0x01:

             switch(id2)
             {
              case 0x22:
                          basesound=0x00C4;
                          break;
              case 0x23:
                          basesound=0x00A8;
                          break;
             }
}

 if (basesound != 0)
 {
  basesound=basesound+sfx;
  soundeffect2(monster, basesound/256, basesound%256);
  return;
 }
 if(id1 == 0x00 && id2 == 0x08)
 {
  switch(sfx)
  {
   case 0:
           soundeffect2(monster, 0x01, 0x61);
           break;
   case 2:
           soundeffect2(monster, 0x01, 0x62);
           break;
   case 3:
           soundeffect2(monster, 0x01, 0x63);
           break;
   case 4:
           soundeffect2(monster, 0x01, 0x64);
           break;
  }
 }
 if (id1 == 0x00 && id2 == 0x96)
 {
  switch(sfx)
  {
   case 0:
           soundeffect2(monster, 0x01, 0xBF);
           break;
   case 2:
           soundeffect2(monster, 0x01, 0xC0);
           break;
   case 3:
           soundeffect2(monster, 0x01, 0xC1);
           break;
   case 4:
           soundeffect2(monster, 0x01, 0xC2);
           break;
  }
 }
 if(id1 == 0x00 && id2 == 0xCD)
 {
  switch(sfx)
  {
   case 2:
           soundeffect2(monster, 0x00, 0xC9);
           break;
   case 3:
           soundeffect2(monster, 0x00, 0xCA);
           break;
   case 4:
           soundeffect2(monster, 0x00, 0xCB);
           break;
  }
 }
 if((id1 == 0x00 && id2 == 0xDC) ||
    (id1 == 0x00 && id2 == 0xDA) ||
    (id1 == 0x00 && id2 == 0xDB) ||
    (id1 == 0x00 && id2 == 0xD2) ||
    (id1 == 0x01 && id2 == 0x24))
   {
    switch(sfx)
    {
    case 2:
       soundeffect2(monster, 0x00, 0xB7);
       break;
    case 3:
       soundeffect2(monster, 0x00, 0xB8);
       break;
    case 4:
       soundeffect2(monster, 0x00, 0xB9);
       break;
    }
 }
 if (id1 == 0x00 && id2 == 0xEA || id2 == 0xED)
 {
  switch(sfx)
  {
   case 2:
           soundeffect2(monster, 0x00, 0x82);
           break;
   case 3:
           soundeffect2(monster, 0x00, 0x83);
           break;
   case 4:
           soundeffect2(monster, 0x00, 0x84);
           break;
  }
 }
}

void sellstufftarget(int s)
{
 int i,serial;

 serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
 i=findbyserial(&charsp[serial%256], serial, 1);
 if (i!=-1)
 {
   sellstuff(s, i);
 }
}

int sellstuff(int s, int i)
{
 char itemname[256];
 int p=-1, j, q, m1t, pack, z, value;
 int serial,serhash,ci,serial1,serhash1,ci1;
 char m1[2048];
 char m2[2];
 
 serial=chars[i].serial;
 serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    q=contsp[serhash].pointer[ci];
    if ((q!=-1) && (items[q].contserial==serial) &&
        (items[q].layer==0x1C))
    {
      p=q;
      //q=itemcount;
      break;
    }
  }
  if (p==-1) return 0;

 m2[0]=0x33;
 m2[1]=0x01;
 xsend(s, m2, 2, 0);
 
 pack=packitem(currchar[s]);

 m1[0]=0x9E; // Header
 m1[1]=0; // Size
 m1[2]=0; // Size
 m1[3]=chars[i].ser1;
 m1[4]=chars[i].ser2;
 m1[5]=chars[i].ser3;
 m1[6]=chars[i].ser4;
 m1[7]=0; // Num items
 m1[8]=0; // Num items
 m1t=9;

 /*  We just did this above... why do it again???  
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    q=contsp[serhash].pointer[i];
    if ((q!=-1) && (items[q].contserial==serial) &&
        (items[q].layer==0x1C))
    {
      p=q;
      //q=itemcount;
      break;
    }
  }*/

 //if (p==-1) return 0;
/*  for(q=0;q<itemcount;q++)
  {
    if (items[q].cont1==items[p].ser1 && items[q].cont2==items[p].ser2 &&
        items[q].cont3==items[p].ser3 && items[q].cont4==items[p].ser4)
    {
    for(j=0;j<itemcount;j++)
      {
        if (items[j].id1==items[q].id1 && items[j].id2==items[q].id2 &&
            items[j].type==items[q].type &&
            items[j].cont1==items[pack].ser1 && items[j].cont2==items[pack].ser2 &&
            items[j].cont3==items[pack].ser3 && items[j].cont4==items[pack].ser4 &&
            m1[8]<75)*/
  serial=items[p].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    q=contsp[serhash].pointer[ci];
    if ((q!=-1) && (items[q].contserial==serial))
    {
      serial1=items[pack].serial;
      serhash1=serial1%256;
      for (ci1=0;ci1<contsp[serhash1].max;ci1++)
      {
        j=contsp[serhash1].pointer[ci1];
        if ((j!=-1) && (items[j].contserial==serial1) &&
            (items[j].id1==items[q].id1) && (items[j].id2==items[q].id2) &&
            (items[j].type==items[q].type) && (m1[8]<75))
        {
          m1[m1t+0]=items[j].ser1;
          m1[m1t+1]=items[j].ser2;
          m1[m1t+2]=items[j].ser3;
          m1[m1t+3]=items[j].ser4;
          m1[m1t+4]=items[j].id1;
          m1[m1t+5]=items[j].id2;
          m1[m1t+6]=items[j].color1;
          m1[m1t+7]=items[j].color2;
          m1[m1t+8]=items[j].amount/256;
          m1[m1t+9]=items[j].amount%256;
          value=items[q].value;
          value=calcValue(j, value);
          m1[m1t+10]=value/256;
          m1[m1t+11]=value%256;
          m1[m1t+12]=0;// Unknown... 2nd length byte for string?
          m1[m1t+13]=getname(j, itemname);
          m1t=m1t+14;
          for(z=0;z<m1[m1t-1];z++)
          {
            m1[m1t+z]=itemname[z];
          }
          m1t=m1t+m1[m1t-1];
          m1[8]++;
        }
      }
    }
  }

  m1[1]=m1t/256;
  m1[2]=m1t%256;
  if (m1[8]!=0)
  {
    xsend(s, m1, m1t, 0);
  }
  else
  {
    npctalkall(i, "Thou doth posses nothing of interest to me.");
  }
  m2[0]=0x33;
  m2[1]=0x00;
  xsend(s, m2, 2, 0);
  return 1;
}

void sellaction(int s)
{
 int n, npa=0, npb=0, npc=0, i, j, k, amt, value=0, join, totgold=0, z;
 int serial,serhash,ci;
 char clearmsg[9];
 if (buffer[s][8]!=0)
 {
  n=calcCharFromSer(buffer[s][3], buffer[s][4], buffer[s][5], buffer[s][6]);
  serial=chars[n].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))
   {
    if (items[i].layer==0x1A) npa=i;
    if (items[i].layer==0x1B) npb=i;
    if (items[i].layer==0x1C) npc=i;
   }
  }
  for (i=0;i<buffer[s][8];i++)
  {
   j=calcItemFromSer(buffer[s][9+((6*i)+0)], buffer[s][9+((6*i)+1)],
                         buffer[s][9+((6*i)+2)], buffer[s][9+((6*i)+3)]);
   amt=(256*buffer[s][9+((6*i)+4)])+buffer[s][9+((6*i)+5)];
   if (items[j].amount<amt)
   {
    npctalkall(n, "Cheating scum! Leave now, before I call the guards!");
    return;
   }
   join=-1;
    serial=items[npa].serial;
    serhash=serial%256;
    for (ci=0;ci<contsp[serhash].max;ci++)
    {
      k=contsp[serhash].pointer[ci];
      if ((k!=-1) && (items[k].contserial==serial))
      {
        if (items[k].id1==items[j].id1 && items[k].id2==items[j].id2 &&
            items[j].type==items[k].type)
        {
          join=k;
        }
      }
    }
    serial=items[npc].serial;
    serhash=serial%256;
    for (ci=0;ci<contsp[serhash].max;ci++)
    {
      k=contsp[serhash].pointer[ci];
      if ((k!=-1) && (items[k].contserial==serial) &&
          (items[k].id1==items[j].id1) && (items[k].id2==items[j].id2) &&
           (items[j].type==items[k].type))
      {
        value=items[k].value;
        value=calcValue(j, value);
      }
    }
  if (join!=-1)
  {
    items[join].amount=items[join].amount+amt;
    items[join].restock=items[join].restock-amt;
    totgold=totgold+(amt*value);
    if (items[j].amount==amt)
    {
     deleitem(j);
    }
    else
    {
     items[j].amount=items[j].amount-amt;
     senditem(s, j);
    }
  }
  else
  {
    totgold=totgold+(amt*value);
    items[j].cont1=items[npb].ser1;
    items[j].cont2=items[npb].ser2;
    items[j].cont3=items[npb].ser3;
    items[j].cont4=items[npb].ser4;
		//remove from shopkeeps inventory lookup tauriel
		if (items[j].contserial!=-1) removefromptr(&contsp[items[j].contserial%256], j);
    removeitem[1]=items[j].ser1;
    removeitem[2]=items[j].ser2;
    removeitem[3]=items[j].ser3;
    removeitem[4]=items[j].ser4;
    for (z=0;z<now;z++)
    {
     if (perm[z]) xsend(z, removeitem, 5, 0);
    }
    if (items[j].amount!=amt) dupeitem(s, j, items[j].amount-amt);
   }
  }
  addgold(s, totgold);
    // Dupois, SFX for gold movement
    // Added Oct 08, 1998
    goldsfx(s, totgold);
    // End coin sfx
 }

 clearmsg[0]=0x3B;
 clearmsg[1]=0x00;
 clearmsg[2]=0x08;
 clearmsg[3]=buffer[s][3];
 clearmsg[4]=buffer[s][4];
 clearmsg[5]=buffer[s][5];
 clearmsg[6]=buffer[s][6];
 clearmsg[7]=0x00;
 xsend(s, clearmsg, 8, 0);
}

void addgold(int s, int totgold)
{
 int c;
 c=SpawnItem(s,totgold,"#",1,0x0E,0xED,0,0,1,1);
}

void playmidi(int s, char num1, char num2)
{
 char msg[3];
 msg[0]=0x6D;
 msg[1]=num1;
 msg[2]=num2;
 xsend(s, msg, 3, 0);
}

void gumpopen(int s, int i, int num1, int num2)
{
 char shopgumpopen[8]="\x24\x00\x00\x00\x01\x00\x30";
 shopgumpopen[1]=chars[i].ser1;
 shopgumpopen[2]=chars[i].ser2;
 shopgumpopen[3]=chars[i].ser3;
 shopgumpopen[4]=chars[i].ser4;
 shopgumpopen[5]=num1;
 shopgumpopen[6]=num2;
 xsend(s, shopgumpopen, 7, 0);
}

void usepotion(int p, int i)
{
 int s, j, x;

 s=calcSocketFromChar(p);

 switch(items[i].morey)
 {
 case 1: // Agility Potion
       break;
 case 2: // Cure Potion
       {
         if (chars[p].poisoned<1) sysmessage(s,"The potion had no effect.");
         else
         {
           switch(items[i].morez)
           {
            case 1:
                 x=RandomNum(1,100);
                 if (chars[p].poisoned==1 && x<81) chars[p].poisoned=0;
                 if (chars[p].poisoned==2 && x<41) chars[p].poisoned=0;
                 if (chars[p].poisoned==3 && x<21) chars[p].poisoned=0;
                 if (chars[p].poisoned==4 && x<6)  chars[p].poisoned=0;
                break;
            case 2:
                 x=RandomNum(1,100);
                 if (chars[p].poisoned==1) chars[p].poisoned=0;
                 if (chars[p].poisoned==2 && x<81) chars[p].poisoned=0;
                 if (chars[p].poisoned==3 && x<41) chars[p].poisoned=0;
                 if (chars[p].poisoned==4 && x<21)  chars[p].poisoned=0;
                 break;
            case 3:
                 x=RandomNum(1,100);
                 if (chars[p].poisoned==1) chars[p].poisoned=0;
                 if (chars[p].poisoned==2) chars[p].poisoned=0;
                 if (chars[p].poisoned==3 && x<81) chars[p].poisoned=0;
                 if (chars[p].poisoned==4 && x<61)  chars[p].poisoned=0;
                 break;
           }
        if (chars[p].poisoned) sysmessage(s,"The potion was not able to cure this poison."); else
        {
           staticeffect(p, 0x37, 0x3A, 0, 15);
           soundeffect2(p, 0x01, 0xE0); //cure sound - SpaceDog
           sysmessage(s,"The poison was cured.");
        }
       }
      }
 case 3: // Explosion Potion
  addid1[s]=items[i].ser1;
  addid2[s]=items[i].ser2;
  addid3[s]=items[i].ser3;
  addid4[s]=items[i].ser4;
	sprintf(temp, "Now would be a good time to throw it!");
  sysmessage(currchar[s], temp);
  tempeffect(currchar[s], currchar[s], 16, 0, 1, 3);
  tempeffect(currchar[s], currchar[s], 16, 0, 2, 2);
  tempeffect(currchar[s], currchar[s], 16, 0, 3, 1);
  tempeffect2(currchar[s], i, 17, 0, 4, 0);
  target(s,0,1,0,207,"");
  //target(s,0,1,0,207,"Where would you like to throw this potion?");
  return;
  break;
 case 4: // Heal Potion
  switch(items[i].morez)
  {
  case 1:
   chars[p].hp=min(chars[p].hp+3+(rand()%5)+(items[i].morex/200), chars[p].st);
   break;
  case 2:
   chars[p].hp=min(chars[p].hp+13+(rand()%5)+(items[i].morex/200), chars[p].st);
   break;
  case 3:
   chars[p].hp=min(chars[p].hp+15+(rand()%9)+(items[i].morex/100), chars[p].st);
   break;
  }
  if (s!=-1) updatestats(p, 0);
  staticeffect(p, 0x37, 0x6A, 0x09, 0x06); // Sparkle effect
  soundeffect2(p, 0x01, 0xF2); //Healing Sound - SpaceDog
  break;
 case 5: // Night Sight Potion
         {
          staticeffect(p, 0x37, 0x6A, 0x09, 0x06);
      tempeffect(currchar[s], p, 2, 0, 0, 0);
      soundeffect2(p, 0x01, 0xE3);
          printf("POTN: Nightsight used by %s\n",chars[p].name);
          break;
         }
 case 6: // Poison Potion
  switch(items[i].morez)
  {
  case 1:
   chars[p].poisoned=1;
   break;
  case 2:
   chars[p].poisoned=2;
   break;
  case 3:
   chars[p].poisoned=3;
   break;
  case 4:
   chars[p].poisoned=4;
   break;
  }
  soundeffect2(p, 0x02, 0x46); //poison sound - SpaceDog
  sysmessage(s, "You poisoned yourself! *sigh*"); //message -SpaceDog
  break;
 case 7: // Refresh Potion
  break;
 case 8: // Strength Potion
  break;
 case 9: // Mana Potion
  switch(items[i].morez)
  {
  case 1:
   chars[p].mn=min(chars[p].mn+10+items[i].morex/100, chars[p].in);
   break;
  case 2:
   chars[p].mn=min(chars[p].mn+20+items[i].morex/50, chars[p].in);
   break;
  }
  if (s!=-1) updatestats(p, 1);
  staticeffect(p, 0x37, 0x6A, 0x09, 0x06); // Sparkle effect
  soundeffect2(p, 0x01, 0xE7); //agility sound - SpaceDog
  break;
 }
 soundeffect2(p, 0x00, 0x30);
 if (chars[p].id1>=1 && chars[p].id2>90 && chars[p].onhorse==0) npcaction(p, 0x22);
 //empty bottle after drinking - Tauriel
 if (items[i].amount!=1)
 {
  items[i].amount--;
 }
 //empty bottle after drinking - Tauriel
 if (items[i].contserial!=-1) removefromptr(&contsp[items[i].contserial%256], i);
 if (items[i].morey!=3)
 {
    int k1=items[i].ser1;
    int k2=items[i].ser2;
    int k3=items[i].ser3;
    int k4=items[i].ser4;
		int kser=items[i].serial;
    inititem(i);
    items[i].ser1=k1;
    items[i].ser2=k2;
    items[i].ser3=k3;
    items[i].ser4=k4;
		items[i].serial=kser;
    items[i].id1=0x0F;
    items[i].id2=0x0E;
    items[i].pileable=1;
    items[i].x=chars[p].x;
    items[i].y=chars[p].y;
    items[i].z=chars[p].z;
    items[i].priv|=0x01;
 }
 else
 {
    deleitem(i);
 }
 for (j=0;j<now;j++) if (perm[j] && inrange2(j, i)) senditem(j, i);
// end empty bottle change
}

int calcValue(int i, int value)
{
 int mod=10;

 if (items[i].type==19)
 {
  if (items[i].morex>500) mod=mod+1;
  if (items[i].morex>900) mod=mod+1;
  if (items[i].morex>1000) mod=mod+1;
  if (items[i].morez>1) mod=mod+(3*(items[i].morez-1));
  value=(value*mod)/10;
 }
 return value;
}

int tradestart(int s, int i)
{
 int ps, pi, bps, bpi, s2,c;
 char msg[90];

 bps=packitem(currchar[s]);
 bpi=packitem(i);
 s2=calcSocketFromChar(i);

  c=SpawnItem(s2,1,"#",0,0x1E,0x5E,0,0,0,0);
 items[c].x=26;
 items[c].y=0;
 items[c].z=0;
 setserial(c,currchar[s],4);
 items[c].layer=0;
 items[c].type=1;
 items[c].dye=0;
 ps=c;
 sendbpitem(s, ps);
 if (s2!=-1) sendbpitem(s2, ps);

  c=SpawnItem(s2,1,"#",0,0x1E,0x5E,0,0,0,0);
 items[c].x=26;
 items[c].y=0;
 items[c].z=0;
 setserial(c,i,4);
 items[c].layer=0;
 items[c].type=1;
 items[c].dye=0;
 pi=c;
 sendbpitem(s, pi);
 if (s2!=-1) sendbpitem(s2, pi);

 items[pi].moreb1=items[ps].ser1;
 items[pi].moreb2=items[ps].ser2;
 items[pi].moreb3=items[ps].ser3;
 items[pi].moreb4=items[ps].ser4;
 items[ps].moreb1=items[pi].ser1;
 items[ps].moreb2=items[pi].ser2;
 items[ps].moreb3=items[pi].ser3;
 items[ps].moreb4=items[pi].ser4;
 items[pi].morez=0;
 items[ps].morez=0;

 msg[0]=0x6F; // Header Byte
 msg[1]=0; // Size
 msg[2]=47; // Size
 msg[3]=0; // Initiate
 msg[4]=chars[i].ser1;
 msg[5]=chars[i].ser2;
 msg[6]=chars[i].ser3;
 msg[7]=chars[i].ser4;
 msg[8]=items[ps].ser1;
 msg[9]=items[ps].ser2;
 msg[10]=items[ps].ser3;
 msg[11]=items[ps].ser4;
 msg[12]=items[pi].ser1;
 msg[13]=items[pi].ser2;
 msg[14]=items[pi].ser3;
 msg[15]=items[pi].ser4;
 msg[16]=1;
 sprintf(&(msg[17]), "%s", chars[i].name);
 xsend(s, msg, 47, 0);

 msg[0]=0x6F; // Header Byte
 msg[1]=0; // Size
 msg[2]=47; // Size
 msg[3]=0; // Initiate
 msg[4]=chars[currchar[s]].ser1;
 msg[5]=chars[currchar[s]].ser2;
 msg[6]=chars[currchar[s]].ser3;
 msg[7]=chars[currchar[s]].ser4;
 msg[8]=items[pi].ser1;
 msg[9]=items[pi].ser2;
 msg[10]=items[pi].ser3;
 msg[11]=items[pi].ser4;
 msg[12]=items[ps].ser1;
 msg[13]=items[ps].ser2;
 msg[14]=items[ps].ser3;
 msg[15]=items[ps].ser4;
 msg[16]=1;
 sprintf(&(msg[17]), "%s", chars[currchar[s]].name);
 xsend(s2, msg, 47, 0);

 return ps;
}

void clearalltrades()
{
  int i, j, k, p,serial,serhash,ci;
  for (i=0;i<itemcount;i++)
  {
    if (items[i].type==1 && items[i].x==26 && items[i].y==0 && items[i].z==0 &&
        items[i].id1==0x1E && items[i].id2==0x5E)
    {
      k=calcCharFromSer(items[i].cont1, items[i].cont2, items[i].cont3, items[i].cont4);
      p=packitem(k);
      serial=items[i].serial;
      serhash=serial%256;
      for (ci=0;ci<contsp[serhash].max;ci++)
      {
        j=contsp[serhash].pointer[ci];
        if ((j!=-1) && (items[j].contserial==serial))
        {
          removefromptr(&contsp[items[j].contserial%256], j);
          setserial(j,p,1);
        }
      }
      deleitem(i);
      printf("Trade cleared\n");
    }
  }
}

void trademsg(int s)
{
 int cont1, cont2;
 //printf("%x %x %x %x %x\n", buffer[s][3], buffer[s][4], buffer[s][5], buffer[s][6], buffer[s][7]);
 switch(buffer[s][3])
 {
 case 0://Start trade - Never happens, sent out by the server only.
  break;
 case 2://Change check marks.  Possibly conclude trade
  cont1=calcItemFromSer(buffer[s][4], buffer[s][5], buffer[s][6], buffer[s][7]);
  cont2=calcItemFromSer(items[cont1].moreb1, items[cont1].moreb2, items[cont1].moreb3, items[cont1].moreb4);
  items[cont1].morez=buffer[s][11];
  sendtradestatus(cont1, cont2);
  if (items[cont1].morez && items[cont2].morez)
  {
   dotrade(cont1, cont2);
   endtrade(buffer[s][4], buffer[s][5], buffer[s][6], buffer[s][7]);
  }
  break;
 case 1://Cancel trade.  Send each person cancel messages, move items.
  endtrade(buffer[s][4], buffer[s][5], buffer[s][6], buffer[s][7]);
  break;
 }
}

void sendtradestatus(int cont1, int cont2)
{
 char msg[30];
 int p1, p2, s1, s2;

 p1=calcCharFromSer(items[cont1].cont1, items[cont1].cont2, items[cont1].cont3, items[cont1].cont4);
 p2=calcCharFromSer(items[cont2].cont1, items[cont2].cont2, items[cont2].cont3, items[cont2].cont4);
 s1=calcSocketFromChar(p1);
 s2=calcSocketFromChar(p2);

 msg[0]=0x6F;//Header
 msg[1]=0x00;//Size
 msg[2]=0x11;//Size
 msg[3]=0x02;//State
 msg[4]=items[cont1].ser1;
 msg[5]=items[cont1].ser2;
 msg[6]=items[cont1].ser3;
 msg[7]=items[cont1].ser4;
 msg[8]=0;
 msg[9]=0;
 msg[10]=0;
 msg[11]=items[cont1].morez%256;
 msg[12]=0;
 msg[13]=0;
 msg[14]=0;
 msg[15]=items[cont2].morez%256;
 msg[16]=0; // No name in this message
 if (s1!=-1) xsend(s1, msg, 17, 0);

 msg[4]=items[cont2].ser1;
 msg[5]=items[cont2].ser2;
 msg[6]=items[cont2].ser3;
 msg[7]=items[cont2].ser4;
 msg[11]=items[cont2].morez%256;
 msg[15]=items[cont1].morez%256;
 if (s2!=-1) xsend(s2, msg, 17, 0);
}

void endtrade(int b1, int b2, int b3, int b4)
{
 int cont1, cont2, p1, p2, bp1, bp2, s1, s2, i;
 int serial,serhash,ci;
 char msg[30];

 cont1=calcItemFromSer(b1, b2, b3, b4);
 cont2=calcItemFromSer(items[cont1].moreb1, items[cont1].moreb2, items[cont1].moreb3, items[cont1].moreb4);
 p1=calcCharFromSer(items[cont1].cont1, items[cont1].cont2, items[cont1].cont3, items[cont1].cont4);
 p2=calcCharFromSer(items[cont2].cont1, items[cont2].cont2, items[cont2].cont3, items[cont2].cont4);
 bp1=packitem(p1);
 bp2=packitem(p2);
 s1=calcSocketFromChar(p1);
 s2=calcSocketFromChar(p2);

 msg[0]=0x6F;//Header Byte
 msg[1]=0x00;//Size
 msg[2]=0x11;//Size
 msg[3]=0x01;//State byte
 msg[4]=items[cont1].ser1;
 msg[5]=items[cont1].ser2;
 msg[6]=items[cont1].ser3;
 msg[7]=items[cont1].ser4;
 msg[8]=0;
 msg[9]=0;
 msg[10]=0;
 msg[11]=0;
 msg[12]=0;
 msg[13]=0;
 msg[14]=0;
 msg[15]=0;
 msg[16]=0;
 if (s1!=-1) xsend(s1, msg, 17, 0);

 msg[0]=0x6F;//Header Byte
 msg[1]=0x00;//Size
 msg[2]=0x11;//Size
 msg[3]=0x01;//State byte
 msg[4]=items[cont2].ser1;
 msg[5]=items[cont2].ser2;
 msg[6]=items[cont2].ser3;
 msg[7]=items[cont2].ser4;
 msg[8]=0;
 msg[9]=0;
 msg[10]=0;
 msg[11]=0;
 msg[12]=0;
 msg[13]=0;
 msg[14]=0;
 msg[15]=0;
 msg[16]=0;
  if (s2!=-1) xsend(s2, msg, 17, 0);

  serial=items[cont1].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))
    {
      removefromptr(&contsp[serhash], i);
      setserial(i,bp1,1);
      items[i].x=50+(rand()%80);
      items[i].y=50+(rand()%80);
      items[i].z=9;
      if (s1!=-1) sendbpitem(s1, i);
    }
  }
  serial=items[cont2].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))

    {
      removefromptr(&contsp[serhash], i);
      setserial(i,bp2,1);
      items[i].x=50+(rand()%80);
      items[i].y=50+(rand()%80);
      items[i].z=9;
      if (s2!=-1) sendbpitem(s2, i);
    }
  }
  deleitem(cont1);
  deleitem(cont2);
}

void dotrade(int cont1, int cont2)
{
 int p1, p2, bp1, bp2, s1, s2, i;
 int serial,serhash,ci;

 p1=calcCharFromSer(items[cont1].cont1, items[cont1].cont2, items[cont1].cont3, items[cont1].cont4);
 p2=calcCharFromSer(items[cont2].cont1, items[cont2].cont2, items[cont2].cont3, items[cont2].cont4);
 bp1=packitem(p1);
 bp2=packitem(p2);
 s1=calcSocketFromChar(p1);
 s2=calcSocketFromChar(p2);

  serial=items[cont1].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))
    {
      removefromptr(&contsp[serhash], i);
      setserial(i,bp2,1);
      items[i].x=50+(rand()%80);
      items[i].y=50+(rand()%80);
      items[i].z=9;
      if (s1!=-1) sendbpitem(s1, i);
      if (s2!=-1) sendbpitem(s2, i);
    }
  }
  serial=items[cont2].serial;
  serhash=serial%256;
  for (ci=0;ci<contsp[serhash].max;ci++)
  {
    i=contsp[serhash].pointer[ci];
    if ((i!=-1) && (items[i].contserial==serial))
    {
      removefromptr(&contsp[serhash], i);
      setserial(i,bp1,1);
      items[i].x=50+(rand()%80);
      items[i].y=50+(rand()%80);
      items[i].z=9;
      if (s2!=-1) sendbpitem(s2, i);
      if (s1!=-1) sendbpitem(s1, i);
    }
  }
}

void loadregions()
{
 int i, noregion, l=0, a=0;
 char sect[512];
 for (i=0;i<256;i++)
 {
  region[i].midilist=0;
  region[i].priv=0;
  region[i].snowchance=0;
  region[i].rainchance=0;
  region[i].name[0]=0;
  region[i].name[0]=0;
  noregion=0;
  for (a=0;a<10;a++)
  {
   region[i].guardnum[a]=RandomNum(1000,1001);
  }
  a=0;
  openscript("regions.scp");
  sprintf(sect, "REGION %i", i);
  if (!regions_script.find(sect))
  {
   noregion=1;
  }
  do
  {
   read2();
   if (script1[0]!='}')
   {
     if (!(strcmp("GUARDNUM",script1)))
     {
       if (a<10)
       {
          region[i].guardnum[a]=str2num(script2);
          //printf("DEBUG: Guardnum %i for Region %i\n",region[i].guardnum[a],i);
          a++;
       }
       else
       {
          printf("ERROR: Region %i has more than 10 'GUARDNUM', The ones after 10 will not be used\n",i);
       }
     }
    if (!(strcmp("NAME",script1)))
    {
     sprintf(region[i].name, "%s", script2);
    }
    if (!(strcmp("GUARDOWNER",script1)))
    {
     sprintf(region[i].guardowner, "%s", script2);
    }
    if (!(strcmp("MIDILIST",script1)))
    {
     region[i].midilist=str2num(script2);
    }
    if (!(strcmp("GUARDED",script1)))
    {
     if (str2num(script2)) region[i].priv=region[i].priv|0x01;   
    }
    if (!(strcmp("MAGICDAMAGE",script1)))
    {
     if (!(str2num(script2))) region[i].priv=region[i].priv|0x40;
    }
    if (!(strcmp("MARK",script1)))
    {
     if (str2num(script2)) region[i].priv=region[i].priv|0x02;
    }
    if (!(strcmp("GATE",script1)))
    {
     if (str2num(script2)) region[i].priv=region[i].priv|0x04;
    }
    if (!(strcmp("RECALL",script1)))
    {
     if (str2num(script2)) region[i].priv=region[i].priv|0x08;
    }
    if (!(strcmp("SNOWCHANCE", script1)))
    {
     region[i].snowchance=str2num(script2);
    }
    if (!(strcmp("RAINCHANCE", script1)))
    {
     region[i].rainchance=str2num(script2);
    }
    if (!(strcmp("X1", script1)))
    {
         location[l].x1=str2num(script2);
    }
    if (!(strcmp("X2", script1)))
    {
         location[l].x2=str2num(script2);
    }
    if (!(strcmp("Y1", script1)))
    {
     location[l].y1=str2num(script2);
    }
    if (!(strcmp("Y2", script1)))
    {
         location[l].y2=str2num(script2);
         location[l].region=i;
         l++;
    }
   }
  }
  while (script1[0]!='}' && !noregion);
  closescript();
 }
 locationcount=l;
}

char calcRegionFromXY(int x, int y)
{
 int i;
 for (i=0;i<locationcount;i++)
 {
  if (location[i].x1<=x && location[i].y1<=y && location[i].x2>=x &&
          location[i].y2>=y)
  {
   return location[i].region;
  }
 }
 return -1;
}

void checkregion(int i)
{

 int calcreg, s, j;

 calcreg=calcRegionFromXY(chars[i].x, chars[i].y);
 if (calcreg!=chars[i].region)
 {
  s=calcSocketFromChar(i);
  if (s!=-1)
  {
   if (region[chars[i].region].name[0]!=0)
   {
    sprintf(temp, "You have left %s.", region[chars[i].region].name);
    sysmessage(s, temp);
   }
   if (region[calcreg].name[0]!=0)
   {
    sprintf(temp, "You have entered %s.", region[calcreg].name);
    sysmessage(s, temp);
   }
   j=strcmp(region[calcreg].guardowner, region[chars[i].region].guardowner);
   if ( (region[calcreg].priv&0x01)!=(region[chars[i].region].priv&0x01) ||
            (region[calcreg].priv&0x01 && j))
   {
    if (region[calcreg].priv&0x01)
    {
     if (region[calcreg].guardowner[0]==0)
     {
      sysmessage(s, "You are now under the protection of the guards.");
     }
     else
     {
      sprintf(temp, "You are now under the protection of %s guards.", region[calcreg].guardowner);
      sysmessage(s, temp);
     }
    } 
    else
    {
     if (region[chars[i].region].guardowner[0]==0)
     {
      sysmessage(s, "You are no longer under the protection of the guards.");
     }
     else
     {
      sprintf(temp, "You are no longer under the protection of %s guards.", region[chars[i].region].guardowner);
      sysmessage(s, temp);
     }
    }
   }
  }
  chars[i].region=calcreg;
  if (s!=-1) dosocketmidi(s);
 }
}

void dosocketmidi(int s)
{
 int i=0;
 char midiarray[50];
 char sect[512];

 openscript("regions.scp");
 if (chars[currchar[s]].war)
 {
 sprintf(sect, "MIDILIST COMBAT");
 }
 else
 {
 sprintf(sect, "MIDILIST %i", region[chars[currchar[s]].region].midilist);
 }
 if (region[chars[currchar[s]].region].midilist!=0 && !regions_script.find(sect))
 {
  closescript();
  return;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   if (!(strcmp("MIDI",script1)))
   {
    midiarray[i]=str2num(script2);
    i++;
   }
  }
 }
 while (script1[0]!='}');
 closescript();
 if (i!=0)
 {
  i=rand()%(i);
  playmidi(s, 0, midiarray[i]);
 }
}

void wipenpcs (int s) // remove ALL npcs
{
 int j,i,deleted=0;

 printf("UOX3: %s has initiated an NPC wipe\n",chars[currchar[s]].name);

 for(j=0;j<charcount;j++)
 {
 if(chars[j].npc)
 {
 removeitem[1]=chars[j].ser1;
 removeitem[2]=chars[j].ser2;
 removeitem[3]=chars[j].ser3;
 removeitem[4]=chars[j].ser4;
 for (i=0;i<now;i++)
 {
  xsend(i, removeitem, 5, 0);
  //if (currchar[i]>j) currchar[i]--;
 }
  chars[j].free=1;
  chars[j].x=20+(rand()%40);
  chars[j].y=50+(rand()%80);
  chars[j].z=9;
  chars[j].summontimer=0;
 if (cmemcheck<300)
  {
  cmemcheck++;
  freecharmem[cmemcheck]=j;
  }
 else cmemover=1;
 deleted++; 
}
}
gcollect();
charcount=charcount-deleted;
sysbroadcast("All NPC's have been wiped.");
}

void respawnnow()
{
 int i, j, k,serial,serhash,ci;

  for(i=0;i<itemcount;i++)  // Item Spawner
  {
    if (items[i].type==61)
    {
      k=0;
      serial=items[i].serial;
      serhash=serial%256;
      for (ci=0;ci<spawnsp[serhash].max;ci++)
      {
        j=spawnsp[serhash].pointer[ci];
        if (i!=j && j!=-1 && items[j].x==items[i].x && items[j].y==items[i].y &&
            items[j].z==items[i].z)
        {
          if (items[i].serial==items[j].spawnserial)
          {
             k=1;
             break;
          }
        }
      }
      if (k==0)
      {
        addrespawnitem(i,items[i].morex,0);
      }
    }

    if (items[i].type==62||items[i].type==69)  // NPC Spawner
    {
      k=0;
      serial=items[i].serial;
      serhash=serial%256;
      for (ci=0;ci<cspawnsp[serhash].max;ci++)
      {
        j=cspawnsp[serhash].pointer[ci];
        if (j!=-1 && items[i].serial==chars[j].spawnserial)
        {
          k++;
        }
      }
      addrespawnnpc(i,items[i].morex,1);
      items[i].gatetime=0;
    }
  }
}

void loadskills()
{
 int i, noskill, l=0;
 char sect[512];

 for (i=0;i<50;i++)
 {
  skill[i].st=0;
  skill[i].dx=0;
  skill[i].in=0;
  skill[i].advance_index=l;
  noskill=0;
  openscript("skills.scp");
  sprintf(sect, "SKILL %i", i);
  if (!skills_script.find(sect))
  {
   noskill=1;
  }
  do
  {
   read2();
   if (script1[0]!='}')
   {
    if (!(strcmp("STR", script1)))
    {
     skill[i].st=str2num(script2);
    }
    if (!(strcmp("DEX", script1)))
    {
     skill[i].dx=str2num(script2);
    }
    if (!(strcmp("INT", script1)))
    {
     skill[i].in=str2num(script2);
    }
    if (!(strcmp("SKILLPOINT", script1)))
    {
     advance[l].skill=i;
     gettokennum(script2, 0);
     advance[l].base=str2num(gettokenstr);
     gettokennum(script2, 1);
     advance[l].success=str2num(gettokenstr);
     gettokennum(script2, 2);
     advance[l].failure=str2num(gettokenstr);
     l++;
    }
   }
  }
  while (script1[0]!='}' && !noskill);
  closescript();
 }
}

void tellmessage(int i, int s, char *txt)
{
 int tl;

 sprintf(temp, "GM tells %s: %s", chars[currchar[s]].name, txt);

 tl=44+strlen(temp)+1;
 talk[1]=tl/256;
 talk[2]=tl%256;
 talk[3]=1;
 talk[4]=1;
 talk[5]=1;
 talk[6]=1;
 talk[7]=1;
 talk[8]=1;
 talk[9]=0;
 talk[10]=0x00; //First Part  \_Yellow
 talk[11]=0x35; //Second Part /
 talk[12]=0;
 talk[13]=3;
 xsend(s, talk, 14, 0);
 xsend(s, sysname, 30, 0);
 xsend(s, temp, strlen(temp)+1, 0);
}

void fullstatstarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].mn=chars[i].in;
   chars[i].hp=chars[i].st;
   chars[i].stm=chars[i].dx;
   updatestats(i, 0);
   updatestats(i, 1);
   updatestats(i, 2);
   return;
  }
  sysmessage(s,"That is not a person.");
}

void setspattacktarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].spattack=tempint[s];
  }
}

void setspadelaytarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].spadelay=tempint[s];
  }
}

void setpoisontarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].poison=tempint[s];
  }
}

void setpoisonedtarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].poisoned=tempint[s];
  }
}

void setadvobjtarget(int s)
{
 int i,serial;
  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
   chars[i].advobj=tempint[s];
  }
}

void permHideTarget(int s)
{
int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    if(chars[i].hidden==1)
    {
      sysmessage(s,"You are already hiding");
      return;
    }
    chars[i].priv2=chars[i].priv2|8;
    chars[i].hidden=1;
    updatechar(calcSocketFromChar(i));
  }
}

void unhidetarget(int s)
{
int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    if(chars[i].hidden==0)
    {
      sysmessage(s,"You are not hiding");
      return;
    }
    chars[i].priv2=chars[i].priv2|8;
    chars[i].hidden=0;
    updatechar(calcSocketFromChar(i));
  }
}

void setwipetarget(int s)
{
 int i, j,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&itemsp[serial%256], serial, 0);
  if (i!=-1)
  {
   items[i].wipe=addid1[s];
   for (j=0;j<now;j++) if (perm[j]) senditem(j,i);
  }
}

#ifdef __NT__
void Writeslot(LPSTR lpszMessage)
{
 BOOL fResult;
 HANDLE hFile;
 DWORD cbWritten;

 hFile = CreateFile("\\\\*\\mailslot\\uoxmail", GENERIC_WRITE,FILE_SHARE_READ,
                   (LPSECURITY_ATTRIBUTES) NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,
                   (HANDLE) NULL);
 fResult = WriteFile(hFile,lpszMessage,(DWORD) lstrlen(lpszMessage) + 1,
 &cbWritten,(LPOVERLAPPED) NULL);
 fResult = CloseHandle(hFile);
 if(!atoi(lpszMessage)) printf("UOX3: %s\n",lpszMessage);
}
#else
void Writeslot(char * lpszMessage)
{
 FILE *f;

 f=fopen("UOX3.log","a");
 if(f==NULL) return;
 fprintf(f,"%s\n",lpszMessage);
 if(!atoi(lpszMessage)) printf("UOX3: %s\n",lpszMessage);
 fclose(f);
 return;
}
#endif

void setspeechtarget(int s)
{
 int i,serial;

  serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
  i=findbyserial(&charsp[serial%256], serial, 1);
  if (i!=-1)
  {
    if (chars[i].npc==0)
    {
      sysmessage(s,"You can only change speech for npcs.");
      return;
    }
    chars[i].speech=addx[s];
  }
}

void saveserverscript(char x)
{
 FILE *file;
 file=fopen("server.scp", "w");

 fprintf(file,"// UOX3 Server Script\n");
 fprintf(file,"// Generated by UOX3 Version %s\n\n",VER);

 fprintf(file,"SECTION SERVER\n");
 fprintf(file,"{\n");
 fprintf(file,"DECAYTIMER %i\n",server_data.decaytimer);
 fprintf(file,"INVISTIMER %i\n",server_data.invisibiliytimer);
 fprintf(file,"HUNGERRATE %i\n",server_data.hungerrate);
 fprintf(file,"SKILLDELAY %i\n",server_data.skilldelay);
 fprintf(file,"OBJECTDELAY %i\n",server_data.objectdelay);
 fprintf(file,"HITPOINTS_REGENRATE %i\n",server_data.hitpointrate);
 fprintf(file,"STAMINA_REGENRATE %i\n",server_data.staminarate);
 fprintf(file,"MANA_REGENRATE %i\n",server_data.manarate);
 fprintf(file,"GATETIMER %i\n",server_data.gatetimer);
 fprintf(file,"MINECHECK %i\n",server_data.minecheck);
 fprintf(file,"SHOWDEATHANIM %i\n",server_data.showdeathanim);
 fprintf(file,"COMBAT_HIT_MESSAGE %i\n",server_data.combathitmessage);
 fprintf(file,"MONSTERS_VS_ANIMALS %i\n",server_data.monsters_vs_animals); 
 fprintf(file,"ANIMALS_ATTACK_CHANCE %i\n",server_data.animals_attack_chance); 
 fprintf(file,"ANIMALS_GUARDED %i\n",server_data.animals_guarded); 
 fprintf(file,"NPC_BASE_FLEEAT %i\n",server_data.npc_base_fleeat);
 fprintf(file,"NPC_BASE_REATTACKAT %i\n",server_data.npc_base_reattackat);
 fprintf(file,"GUARDSACTIVE %i\n",server_data.guardsactive);
 fprintf(file,"BG_SOUNDS %i\n",server_data.bg_sounds);
 fprintf(file,"ARCHIVEPATH %s\n",server_data.archivepath);
 fprintf(file,"UOXBOT %i\n",server_data.UOXBot);
 fprintf(file,"HUNGER_DAMAGE %i\n",server_data.hungerdamage);
 fprintf(file,"HUNGER_DAMAGE_RATE %i\n",server_data.hungerdamagerate);
 fprintf(file,"ARMOR_AFFECT_MANA_REGEN %i\n",server_data.armoraffectmana);
 fprintf(file,"JOINMSG %i\n",server_data.joinmsg);
 fprintf(file,"PARTMSG %i\n",server_data.partmsg);
 fprintf(file,"LOG %i\n",server_data.log);
 fprintf(file,"ROGUE %i\n",server_data.rogue);
 //   EviLDeD  -  Output current serverstatus regarding world saves
 //   December 27, 1998
 fprintf(file,"ANNOUNCE_WORLDSAVES %i\n",server_data.announceworldsaves);
 //   EviLDeD  -  End
 fprintf(file,"}\n\n");

 fprintf(file,"SECTION TRACKING\n");
 fprintf(file,"{\n");
 fprintf(file,"BASE_TRACKING_RANGE %i\n",tracking_data.baserange);
 fprintf(file,"MAX_TRACKING_TARGETS %i\n",tracking_data.maxtargets);
 fprintf(file,"BASE_TRACKING_TIME %i\n",tracking_data.basetimer);
 fprintf(file,"TRACKING_MESSAGE_REDISPLAY_TIME %i\n",tracking_data.redisplaytime);
 fprintf(file,"}\n\n");

 fprintf(file,"SECTION BEGGING\n");
 fprintf(file,"{\n");
 fprintf(file,"BEGGING_RANGE %i\n",begging_data.range);
 fprintf(file,"BEGGING_TEXT0 %s\n",begging_data.text[0]);
 fprintf(file,"BEGGING_TEXT1 %s\n",begging_data.text[1]);
 fprintf(file,"BEGGING_TEXT2 %s\n",begging_data.text[2]);
 fprintf(file,"}\n\n");

 fprintf(file,"SECTION FISHING\n");
 fprintf(file,"{\n");
 fprintf(file,"BASE_FISHING_TIME %i\n",fishing_data.basetime);
 fprintf(file,"RANDOM_FISHING_TIME %i\n",fishing_data.randomtime);
 fprintf(file,"}\n\n");

 fprintf(file,"SECTION SPIRITSPEAK\n");
 fprintf(file,"{\n");
 fprintf(file,"SPIRITSPEAKTIMER %i\n",spiritspeak_data.spiritspeaktimer);
 fprintf(file,"}\n\n");

 fprintf(file,"SECTION TIME_LIGHT\n");
 fprintf(file,"{\n");
 fprintf(file,"DAY %i\n", day);
 fprintf(file,"HOUR %i\n", hour);
 fprintf(file,"MINUTE %i\n", minute);
 fprintf(file,"AMPM %i\n", ampm);
 fprintf(file,"MOON1UPDATE %i\n", moon1update);
 fprintf(file,"MOON2UPDATE %i\n", moon2update);
 fprintf(file,"MOON1 %i\n", moon1);
 fprintf(file,"MOON2 %i\n", moon2);
 fprintf(file,"DUNGEONLIGHTLEVEL %i\n", dungeonlightlevel);
 fprintf(file,"WORLDFIXEDLEVEL %i\n", worldfixedlevel);
 fprintf(file,"WORLDCURLEVEL %i\n", worldcurlevel);
 fprintf(file,"WORLDBRIGHTLEVEL %i\n", worldbrightlevel);
 fprintf(file,"WORLDDARKLEVEL %i\n", worlddarklevel);
 fprintf(file,"}\n\n");

 fprintf(file,"EOF\n\n");
 fclose(file);
 if (x) printf("UOX3: Server data saved.(Manual)\n");
 else printf("UOX3: Server data saved.(AUTO)\n");
}

void loadserverscript() // Load server script
{
 wscfile=fopen("server.scp", "r");
 if(wscfile==NULL)
 {
  printf("server.scp not found...defaults are loaded\n");
  return;
 }
 do
 {
  readw2();
  if (!(strcmp(script1, "SECTION")))
  {
   if(!(strcmp(script2, "SERVER"))) loadserver();
   else if(!(strcmp(script2, "TRACKING"))) loadtracking();
   else if(!(strcmp(script2, "BEGGING"))) loadbegging();
   else if(!(strcmp(script2, "FISHING"))) loadfishing();
   else if(!(strcmp(script2, "SPIRITSPEAK"))) loadspiritspeak();
   else if(!(strcmp(script2, "TIME_LIGHT"))) loadtime_light();
  }
 }
 while (strcmp(script1, "EOF"));
 fclose(wscfile);
}

void loadserver()
{
 do
 {
  readw2();
  if(!(strcmp(script1,"DECAYTIMER"))) server_data.decaytimer=str2num(script2);
  if(!(strcmp(script1,"INVISTIMER"))) server_data.invisibiliytimer=str2num(script2);
  if(!(strcmp(script1,"HUNGERRATE"))) server_data.hungerrate=str2num(script2);
  if(!(strcmp(script1,"SKILLDELAY"))) server_data.skilldelay=str2num(script2);
  if(!(strcmp(script1,"OBJECTDELAY"))) server_data.objectdelay=str2num(script2);
  if(!(strcmp(script1,"HITPOINTS_REGENRATE"))) server_data.hitpointrate=str2num(script2);
  if(!(strcmp(script1,"STAMINA_REGENRATE"))) server_data.staminarate=str2num(script2);
  if(!(strcmp(script1,"MANA_REGENRATE"))) server_data.manarate=str2num(script2);
  if(!(strcmp(script1,"GATETIMER"))) server_data.gatetimer=str2num(script2);
  if(!(strcmp(script1,"MINECHECK"))) server_data.minecheck=str2num(script2);
  if(!(strcmp(script1,"SHOWDEATHANIM"))) server_data.showdeathanim=str2num(script2);
  if(!(strcmp(script1,"COMBAT_HIT_MESSAGE"))) server_data.combathitmessage=str2num(script2);
  if(!(strcmp(script1,"MONSTERS_VS_ANIMALS"))) server_data.monsters_vs_animals=str2num(script2);
  if(!(strcmp(script1,"ANIMALS_ATTACK_CHANCE"))) server_data.animals_attack_chance=str2num(script2);
  if(!(strcmp(script1,"ANIMALS_GUARDED"))) server_data.animals_guarded=str2num(script2);
  if(!(strcmp(script1,"NPC_BASE_FLEEAT"))) server_data.npc_base_fleeat=str2num(script2);
  if(!(strcmp(script1,"NPC_BASE_REATTACKAT"))) server_data.npc_base_reattackat=str2num(script2);
  if(!(strcmp(script1,"GUARDSACTIVE"))) server_data.guardsactive=str2num(script2);
  //  EviLDeD  -  Server information token for toggling world save announcements on or off
  //  December 27, 1998
  if(!(strcmp(script1,"ANNOUNCE_WORLDSAVES"))) server_data.announceworldsaves=str2num(script2);
  //  EviLDeD  -  End
  if(!(strcmp(script1,"BG_SOUNDS"))) server_data.bg_sounds=str2num(script2);
  if(!(strcmp(script1,"ARCHIVEPATH"))) strcpy(server_data.archivepath,script2);
  if(!(strcmp(script1,"UOXBOT"))) server_data.UOXBot=str2num(script2);
  if(!(strcmp(script1,"HUNGER_DAMAGE"))) server_data.hungerdamage=str2num(script2);
  if(!(strcmp(script1,"HUNGER_DAMAGE_RATE"))) server_data.hungerdamagerate=str2num(script2);
  if(!(strcmp(script1,"ARMOR_AFFECT_MANA_REGEN"))) server_data.armoraffectmana=str2num(script2);
  if(!(strcmp(script1,"JOINMSG"))) server_data.joinmsg=str2num(script2);
  if(!(strcmp(script1,"PARTMSG"))) server_data.partmsg=str2num(script2);
  if(!(strcmp(script1,"LOG"))) server_data.log=str2num(script2);
  if(!(strcmp(script1,"ROGUE"))) server_data.rogue=str2num(script2);
 }
 while (strcmp(script1, "}"));
}

void loadtracking() // Load scriptable tracking data
{
 do
 {
  readw2();
  if(!(strcmp(script1,"BASE_TRACKING_RANGE"))) tracking_data.baserange=str2num(script2);
  if(!(strcmp(script1,"MAX_TRACKING_TARGETS")))
  {
   tracking_data.maxtargets=str2num(script2);
   if(tracking_data.maxtargets>30) tracking_data.maxtargets=MAXTRACKINGTARGETS;
  }
  if(!(strcmp(script1,"BASE_TRACKING_TIME"))) tracking_data.basetimer=str2num(script2);
  if(!(strcmp(script1,"TRACKING_MESSAGE_REDISPLAY_TIME"))) tracking_data.redisplaytime=str2num(script2);
 }
 while (strcmp(script1, "}"));
}

void loadbegging()
{
 do
 {
  readw2();
  if(!(strcmp(script1,"BEGGING_RANGE"))) begging_data.range=str2num(script2);
  if(!(strcmp(script1,"BEGGING_TEXT0"))) strcpy(begging_data.text[0],script2);
  if(!(strcmp(script1,"BEGGING_TEXT1"))) strcpy(begging_data.text[1],script2);
  if(!(strcmp(script1,"BEGGING_TEXT2"))) strcpy(begging_data.text[2],script2);
 }
 while (strcmp(script1, "}"));
}

void loadfishing()
{
 do
 {
  readw2();
  if(!(strcmp(script1,"BASE_FISHING_TIME"))) fishing_data.basetime=str2num(script2);
  if(!(strcmp(script1,"RANDOM_FISHING_TIME"))) fishing_data.randomtime=str2num(script2);
 }
 while (strcmp(script1, "}"));
}

void loadspiritspeak()
{
 do
 {
  readw2();
  if(!(strcmp(script1,"SPIRITSPEAKTIMER"))) spiritspeak_data.spiritspeaktimer=str2num(script2);
 }
 while (strcmp(script1, "}"));
}

void loadtime_light()
{
 do
 {
  readw2();
  if(!(strcmp(script1,"DAY"))) day=str2num(script2);
  if(!(strcmp(script1,"HOUR"))) hour=str2num(script2);
  if(!(strcmp(script1,"MINUTE"))) minute=str2num(script2);
  if(!(strcmp(script1,"AMPM"))) ampm=str2num(script2);
  if(!(strcmp(script1,"MOON1UPDATE"))) moon1update=str2num(script2);
  if(!(strcmp(script1,"MOON2UPDATE"))) moon2update=str2num(script2);
  if(!(strcmp(script1,"MOON1"))) moon1=str2num(script2);
  if(!(strcmp(script1,"MOON2"))) moon2=str2num(script2);
  if(!(strcmp(script1,"DUNGEONLIGHTLEVEL"))) dungeonlightlevel=str2num(script2);
  if(!(strcmp(script1,"WORLDFIXEDLEVEL"))) worldfixedlevel=str2num(script2);
  if(!(strcmp(script1,"WORLDCURLEVEL"))) worldcurlevel=str2num(script2);
  if(!(strcmp(script1,"WORLDBRIGHTLEVEL"))) worldbrightlevel=str2num(script2);
  if(!(strcmp(script1,"WORLDDARKLEVEL"))) worlddarklevel=str2num(script2);
 }
 while (strcmp(script1, "}"));
}

void loadserverdefaults(void)
{
// load defaults values
 server_data.decaytimer=DECAYTIMER;
 server_data.invisibiliytimer=INVISTIMER;
 server_data.hungerrate=HUNGERRATE;
 server_data.skilldelay=SKILLDELAY;
 server_data.objectdelay=OBJECTDELAY;
 server_data.hitpointrate=REGENRATE1;
 server_data.staminarate=REGENRATE2;
 server_data.manarate=REGENRATE3;
 server_data.gatetimer=GATETIMER;
 server_data.minecheck=MINECHECK;
 server_data.showdeathanim=SHOWDEATHANIM;
 server_data.combathitmessage=COMBATHITMESSAGE;
 server_data.monsters_vs_animals=MONSTERS_VS_ANIMALS;
 server_data.animals_attack_chance=ANIMALS_ATTACK_CHANCE;
 server_data.animals_guarded=ANIMALS_GUARDED;
 server_data.npc_base_fleeat=NPC_BASE_FLEEAT;
 server_data.npc_base_reattackat=NPC_BASE_REATTACKAT;
 server_data.guardsactive=1;
 server_data.bg_sounds=2;
 //   EviLDeD  -  Set default  of worldsave saves to 0(false)
 //   December 27, 1998
 server_data.announceworldsaves=1;
 //   EviLDeD  -  End
 server_data.joinmsg=1;
 server_data.partmsg=1;
 server_data.log=1;
 server_data.rogue=1;
 *(server_data.archivepath)='\0'; // was strcpy(server_data.archivepath,"");
 server_data.UOXBot=0;
 tracking_data.baserange=TRACKINGRANGE;
 tracking_data.maxtargets=MAXTRACKINGTARGETS;
 tracking_data.basetimer=TRACKINGTIMER;
 tracking_data.redisplaytime=TRACKINGDISPLAYTIME;
 begging_data.range=BEGGINGRANGE;
 strcpy(begging_data.text[0],"Could thou spare a few coins?");
 strcpy(begging_data.text[1],"Hey buddy can you spare some gold?");
 strcpy(begging_data.text[2],"I have a family to feed, think of the children.");
 fishing_data.basetime=FISHINGTIMEBASE;
 fishing_data.randomtime=FISHINGTIMER;
 spiritspeak_data.spiritspeaktimer=SPIRITSPEAKTIMER;
}

int numbitsset( int number )
{
 int bitsset = 0;

 while( number )
 {
  if( number & 0x1 ) bitsset++;
  number >>= 1;
 }

 return bitsset;
}

int whichbit( int number, int bit )
{
 int i, setbits = 0, whichbit = 0, intsize = sizeof(int) * 8;

 for( i=0;i<intsize;i++ )
 {
  if( number & 0x1 ) setbits++;

  if( setbits == bit )
  {
   whichbit = i+1;
   break;
  }
  number >>= 1;
 }

 return whichbit;
}

/*#ifndef __NT__
void strupr(char *s)
{
 for (; *s; s++) *s = toupper(*s);
}
#endif
*/

int RandomNum(int nLowNum, int nHighNum)
{
    if (nHighNum - nLowNum + 1)
        return ((rand() % (nHighNum - nLowNum + 1)) + nLowNum);
    else
        return nLowNum;
}

// Added by Krozy on 7-Sep-98
// New getstatskillvalue function.
// Takes a string, gets the tokens.
// If its one value - It returns that value.
// If its two values - It gets a random number between the values
int getstatskillvalue(char *stringguy) {
   char values[512];
   int lovalue,hivalue,retcode;

   strcpy(values, stringguy);
   gettokennum(values, 0);
   lovalue=str2num(gettokenstr);
   gettokennum(values, 1);
   hivalue=str2num(gettokenstr);

   if (hivalue) {
      retcode = RandomNum(lovalue, hivalue);
   } else {
      retcode = lovalue;
   }
   return retcode;
}

int addnpcxyz(int s, int x, int type, int x1, int y1, int z1)
{
 int tmp, z,c,n, lost, hist, lodx, hidx, loin, hiin,
     loresist, hiresist, lomagery, himagery, lotactics, hitactics,
     loparrying, hiparrying, lowrestling, hiwrestling;
 char sect[512];
 long int pos;
 int mypack, retitem, storeval, goldmin, goldmax, shoppack1, shoppack2, shoppack3;
 char rndlootlist[20];
 
 mypack=-1;
 retitem=-1;
 storeval=-1;
 shoppack1=-1;
 shoppack2=-1;
 shoppack3=-1;
 lost=-1;
 hist=-1;
 lodx=-1;
 hidx=-1;
 loin=-1;
 hiin=-1;
 lowrestling=-1;
 hiwrestling=-1;
 lotactics=-1;
 hitactics=-1;
 lomagery=-1;
 himagery=-1;
 loparrying=-1;
 hiparrying=-1;
 loresist=-1;
 hiresist=-1;

 c=memcharfree ();
 
 initchar(c);
 if (type==1)
 {
  chars[c].x=items[s].x;
  chars[c].y=items[s].y;
  chars[c].dispz=chars[c].z=items[s].z;
  setserial(c,s,6);
 }
 else
 {
  chars[c].x=x1;
  chars[c].y=y1;
  chars[c].dispz=chars[c].z=z1;
 }
 
 chars[c].priv=0x10;
 chars[c].npc=1;
 chars[c].att=1;
 chars[c].def=1;
 openscript("npc.scp");
 sprintf(sect, "NPC %i", x);
 if (!npc_script.find(sect)) 
 {
  closescript();
  return -1;
 }
 do
 {
  read2();
  if (script1[0]!='}')
  {
   if (!(strcmp("NAME",script1)))
   {
    sprintf(chars[c].name, "%s", script2);
   }
   if (!(strcmp("NAMELIST", script1)))
   {
    pos=ftell(scpfile);
    closescript();
    setrandomname(c,script2);
    openscript("npc.scp");
    fseek(scpfile, pos, SEEK_SET);
    sprintf(script1, "DUMMY"); // To prevent accidental exit of loop.
   }
   if (!(strcmp("NPCLIST", script1)))
   {
    pos=ftell(scpfile);
    closescript();
    donpcupdate++;
    if (type==1) addrandomnpc(c,script2,s);
    else addrandomnpc(c,script2,-1);
    donpcupdate--;
    openscript("npc.scp");
    fseek(scpfile, pos, SEEK_SET);
    sprintf(script1, "DUMMY");
   }
   if (!(strcmp("TITLE",script1)))
   {
    sprintf(chars[c].title, "%s", script2);
   }
   if (!(strcmp("KARMA",script1)))
   {
    chars[c].karma=str2num(script2);
   }
   if (!(strcmp("FAME",script1)))
   {
    chars[c].fame=str2num(script2);
   }
	if (!(strcmp(script1, "NOTRAIN"))) chars[x].cantrain=0;

   if (!(strcmp("ID",script1)))
   {
    tmp=hstr2num(script2);
    chars[c].id1=tmp/256;
    chars[c].id2=tmp%256;
    chars[c].xid1=tmp/256;
    chars[c].xid2=tmp%256;
   }
   if (!(strcmp("SKIN",script1)))
   {
    tmp=hstr2num(script2);
    chars[c].skin1=tmp/256;
    chars[c].skin2=tmp%256;
    chars[c].xskin1=tmp/256;
    chars[c].xskin2=tmp%256;
        }
   if (!(strcmp("DIRECTION",script1)))
   {
    if (!(strcmp("NE",script2)))
    {
     chars[c].dir=1;
    }
    if (!(strcmp("E",script2)))
    {
     chars[c].dir=2;
    }
    if (!(strcmp("SE",script2)))
    {
     chars[c].dir=3;
    }
    if (!(strcmp("S",script2)))
    {
     chars[c].dir=4;
    }
    if (!(strcmp("SW",script2)))
    {
     chars[c].dir=5;
         }
    if (!(strcmp("W",script2)))
    {
     chars[c].dir=6;
    }
    if (!(strcmp("NW",script2)))
    {
     chars[c].dir=7;
    }
    if (!(strcmp("N",script2)))
    {
     chars[c].dir=0;
    }
   }
   if (!(strcmp("BACKPACK", script1)))
   {
    if (mypack==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x15))
        {
          mypack=z;
          break;
        }
      }
    }
    if (mypack==-1)
    {
     n=SpawnItem(calcSocketFromChar(c),1,"#",0,0x0E,0x75,0,0,0,0);

     setserial(n,c,4);
     items[n].layer=0x15;
     items[n].type=1;
     items[n].dye=1;
     mypack=n;
     retitem=n;
    }
   }

   if (!(strcmp("GOLD", script1)))
   {
    if (mypack==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x15))
      {
       mypack=z;
       break;
      }
     }
    }
    if (mypack!=-1)
    {

     n=SpawnItem(calcSocketFromChar(c),1,"#",0,0x0E,0xED,0,0,0,0);
     gettokennum(script2, 0);
     goldmin=str2num(gettokenstr);
     gettokennum(script2, 1);
     goldmax=str2num(gettokenstr);
     if (goldmax==0)
     {
      items[n].amount=goldmin/2 + (rand()%(goldmin/2));
     }
     else
     {
      items[n].amount=goldmin + (rand()%(goldmax-goldmin));
     }
     items[n].x=50+(rand()%80);
     items[n].y=50+(rand()%80);
     items[n].z=9;
     setserial(n,mypack,1);
    }
    else
    {
      printf("addnpcxyz() - Bad NPC Script %d with problem no backpack for gold.\n", x);
    }
   }
   if (!(strcmp("LOOT",script1)))
   {
    if (mypack==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x15))
      {
       mypack=z;
       break;
      }
     }
    }
    if (mypack!=-1)
    {
     sprintf(rndlootlist, "%s", script2);
     pos=ftell(scpfile);
     closescript();
     retitem=addrandomloot(mypack, rndlootlist);
     openscript("npc.scp");
     fseek(scpfile, pos, SEEK_SET);
     sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
    }
    else
    {
     printf("addnpcxyz() - Bad NPC Script %d with problem no backpack for loot.\n" , x);
    }
   }
   if (!(strcmp("ITEM",script1)))
   {
    storeval=str2num(script2);
    pos=ftell(scpfile);
    closescript();
    retitem=addmenutarget(-1, 0, storeval);
    openscript("npc.scp");
    fseek(scpfile, pos, SEEK_SET);
    setserial(retitem,c,4);
    if (items[retitem].layer==0) 
       printf("addnpcxyz() - Bad NPC Script %d with problem item %d executed!\n" , x , storeval);
    sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
   }
   if (!(strcmp("SHOPKEEPER", script1)))
   {
    makeshop(c);
   }
   if (!(strcmp("RSHOPITEM",script1)))
   {
    if (shoppack1==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x1A))
      {
       shoppack1=z;
       break;
      }
     }
    }
    if (shoppack1!=-1)
    {
     storeval=str2num(script2);
     pos=ftell(scpfile);
     closescript();
     retitem=addmenutarget(-1, 0, storeval);
     openscript("npc.scp");
     fseek(scpfile, pos, SEEK_SET);
     setserial(retitem,shoppack1,1);
     items[retitem].x=50+(rand()%80);
     items[retitem].y=50+(rand()%80);
     items[retitem].z=9;
     sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
    }
    else
    {
     printf("addnpcxyz() - Bad NPC Script %d with problem no shoppack1 for item.\n" , x);
    }
   }
   if (!(strcmp("VALUE",script1)))
   {
    items[retitem].value=(str2num(script2));
   }
   if (!(strcmp("SELLITEM",script1)))
   {
    if (shoppack3==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x1C))
      {
       shoppack3=z;
       break;
      }
     }
    }
    if (shoppack3!=-1)
    {
     storeval=str2num(script2);
     pos=ftell(scpfile);
     closescript();
     retitem=addmenutarget(-1, 0, storeval);
     openscript("npc.scp");
     fseek(scpfile, pos, SEEK_SET);
     setserial(retitem,shoppack3,1);
     items[retitem].value=items[retitem].value/2;
     items[retitem].x=50+(rand()%80);
     items[retitem].y=50+(rand()%80);
     items[retitem].z=9;
     sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
    }
    else
    {
     printf("addnpcxyz() - Bad NPC Script %d with problem no shoppack3 for item.\n" , x);
    }
   }
   if (!(strcmp("SHOPITEM",script1)))
   {
    if (shoppack2==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x1B))
      {
       shoppack2=z;
       break;
      }
     }
    }
    if (shoppack2!=-1)
    {
     storeval=str2num(script2);
     pos=ftell(scpfile);
     closescript();
     retitem=addmenutarget(-1, 0, storeval);
     openscript("npc.scp");
     fseek(scpfile, pos, SEEK_SET);
     setserial(retitem,shoppack2,1);
     items[retitem].x=50+(rand()%80);
     items[retitem].y=50+(rand()%80);
     items[retitem].z=9;
     sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
    }
    else
    {
     printf("addnpcxyz() - Bad NPC Script %d with problem no shoppack2 for item.\n" , x);
    }
   }
   if (!(strcmp("PACKITEM",script1)))
   {
    if (mypack==-1)
    {
      int serial,ci;
      serial=chars[c].serial;
      for (ci=0;ci<contsp[serial%256].max;ci++)
      {
        z=contsp[serial%256].pointer[ci];
        if ((z!=-1) && (items[z].serial==serial) && (items[z].layer==0x15))
      {
       mypack=z;
       break;
      }
     }
    }
    if (mypack!=-1)
    {
     storeval=str2num(script2);
     pos=ftell(scpfile);
     closescript();
     retitem=addmenutarget(-1, 0, storeval);
     openscript("npc.scp");
     fseek(scpfile, pos, SEEK_SET);
     setserial(retitem,mypack,1);
     items[retitem].x=50+(rand()%80);
     items[retitem].y=50+(rand()%80);
     items[retitem].z=9;
     sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
    }
    else
    {
     printf("addnpcxyz() - Bad NPC Script %d with problem no backpack for packitem.\n" , x);
    }
   }
   if (!(strcmp("COLOR",script1)))
   {
    items[retitem].color1=(hstr2num(script2))/256;
    items[retitem].color2=(hstr2num(script2))%256;
   }
   if (!(strcmp("SAYCOLOR",script1)))
   {
    chars[c].saycolor1=(hstr2num(script2))/256;
    chars[c].saycolor2=(hstr2num(script2))%256;
   }
   if (!(strcmp("EMOTECOLOR",script1)))
   {
    chars[c].emotecolor1=(hstr2num(script2))/256;
    chars[c].emotecolor2=(hstr2num(script2))%256;
   }
   if (!(strcmp("SPEECH",script1)))
   {
    chars[c].speech=str2num(script2);
   }
   if (!(strcmp("ATT",script1)))
   {
    chars[c].att=str2num(script2);
   }
   if (!(strcmp("DEF",script1)))
   {
    chars[c].def=str2num(script2);
   }
   if (!(strcmp("NPCWANDER",script1)))
   {
    chars[c].npcWander=str2num(script2);
   }
   if (!(strcmp("FX1",script1)))
   {
    chars[c].fx1=chars[c].x+str2num(script2);  // new NPCWANDER implementation
   }
   if (!(strcmp("FX2",script1)))
   {
    chars[c].fx2=chars[c].x+str2num(script2);
   }
   if (!(strcmp("FY1",script1)))
   {
    chars[c].fy1=chars[c].y+str2num(script2);
   }
   if (!(strcmp("FY2",script1)))
   {
    chars[c].fy2=chars[c].y+str2num(script2);
   }
   if (!(strcmp("FZ1",script1)))
   {
    chars[c].fz1=chars[c].z+str2num(script2);
   }
   if (!(strcmp("HISTR",script1)))
   {
    hist=str2num(script2);
   }
   if (!(strcmp("HIDEX",script1)))
   {
    hidx=str2num(script2);
   }
   if (!(strcmp("HIINT",script1)))
   {
    hiin=str2num(script2);
   }
   if (!(strcmp("LOSTR",script1)))
   {
    lost=str2num(script2);
   }
   if (!(strcmp("LODEX",script1)))
   {
    lodx=str2num(script2);
   }
   if (!(strcmp("LOINT",script1)))
   {
    loin=str2num(script2);
   }
   if (!(strcmp("LODAMAGE",script1)))
   {
    chars[c].lodamage=str2num(script2);
   }
   if (!(strcmp("HIDAMAGE",script1)))
   {
    chars[c].hidamage=str2num(script2);
   }
   if (!(strcmp("WRESTLING", script1)))
   {
    chars[c].baseskill[WRESTLING]=str2num(script2);
   }
   if (!(strcmp("TACTICS", script1)))
   {
    chars[c].baseskill[TACTICS]=str2num(script2);
   }
   if (!(strcmp("MAGERY", script1)))
   {
    chars[c].baseskill[MAGERY]=str2num(script2);
   }
   if (!(strcmp("PARRYING", script1)))
   {
    chars[c].baseskill[PARRYING]=str2num(script2);
   }
   if (!(strcmp("MAGICRESISTANCE", script1)))
   {
    chars[c].baseskill[MAGICRESISTANCE]=str2num(script2);
   }
   if (!(strcmp("LOWRESTLING", script1)))
   {
    lowrestling=str2num(script2);
   }
   if (!(strcmp("HIWRESTLING", script1)))
   {
    hiwrestling=str2num(script2);
   }
   if (!(strcmp("LOTACTICS", script1)))
   {
    lotactics=str2num(script2);
   }
   if (!(strcmp("HITACTICS", script1)))
   {
    hitactics=str2num(script2);
   }
   if (!(strcmp("LOMAGERY", script1)))
   {
    lomagery=str2num(script2);
   }
   if (!(strcmp("HIMAGERY", script1)))
   {
    himagery=str2num(script2);
   }
   if (!(strcmp("LOPARRYING", script1)))
   {
    loparrying=str2num(script2);
   }
   if (!(strcmp("HIPARRYING", script1)))
   {
    hiparrying=str2num(script2);
   }
   if (!(strcmp("LORESIST", script1)))
   {
    loresist=str2num(script2);
   }
   if (!(strcmp("HIRESIST", script1)))
   {
    hiresist=str2num(script2);
   }
   if (!(strcmp("STRENGTH",script1)))
   {
    chars[c].st=str2num(script2);
    chars[c].st2=str2num(script2);
    chars[c].hp=str2num(script2);
   }
   if (!(strcmp("DEXTERITY",script1)))
   {
    chars[c].dx=str2num(script2);
    chars[c].dx2=str2num(script2);
    chars[c].stm=str2num(script2);
   }
   if (!(strcmp("INTELLIGENCE",script1)))
   {
    chars[c].in=str2num(script2);
    chars[c].in2=str2num(script2);
    chars[c].mn=str2num(script2);
   }
   if (!(strcmp("STR",script1)))
   {
    chars[c].st=str2num(script2);
    chars[c].st2=str2num(script2);
    chars[c].hp=str2num(script2);
   }
   if (!(strcmp("DEX",script1)))
   {
    chars[c].dx=str2num(script2);
    chars[c].dx2=str2num(script2);
    chars[c].stm=str2num(script2);
   }
   if (!(strcmp("INT",script1)))
   {
    chars[c].in=str2num(script2);
    chars[c].in2=str2num(script2);
    chars[c].mn=str2num(script2);
   }
   if (!(strcmp("NPCAI",script1)))
   {
    chars[c].npcaitype=hstr2num(script2);
   }
   if (!(strcmp("SPATTACK",script1)))
   {
    chars[c].spattack=str2num(script2);
   }
   if (!(strcmp("SPADELAY",script1)))
   {
    chars[c].spadelay=str2num(script2);
   }
   if (!(strcmp("POISON",script1)))
   {
    chars[c].poison=str2num(script2);
   }
   if (!(strcmp("FLEEAT",script1)))
   {
    chars[c].fleeat=str2num(script2);
   }
   if (!(strcmp("REATTACKAT",script1)))
   {
    chars[c].reattackat=str2num(script2);
   }
   if (!(strcmp("TAMING", script1)))
   {
    chars[c].taming=str2num(script2);
   }
   if (!(strcmp("SKILL", script1)))
   {
    gettokennum(script2, 0);
    z=str2num(gettokenstr);
    gettokennum(script2, 1);
    chars[c].baseskill[z]=str2num(gettokenstr);
                updateSkillLevel(c, z);
   }
  }
 }
 while (script1[0]!='}');
 closescript();
 
   // Setup the npc's Skills


 if((lowrestling>0)&&(hiwrestling>0))
 {
  if (lowrestling!=hiwrestling) chars[c].baseskill[WRESTLING]=(rand()%(hiwrestling-lowrestling)+lowrestling);
  else chars[c].baseskill[WRESTLING]=lowrestling;
 }
 if((lotactics>0)&&(hitactics>0))
 {
  if (lotactics!=hitactics) chars[c].baseskill[TACTICS]=(rand()%(hitactics-lotactics)+lotactics);
  else chars[c].baseskill[TACTICS]=lotactics;
 }
 if((lomagery>0)&&(himagery>0))
 {
  if (lomagery!=himagery) chars[c].baseskill[MAGERY]=(rand()%(himagery-lomagery)+lomagery);
  else chars[c].baseskill[MAGERY]=lomagery;
 }
 if((loparrying>0)&&(hiparrying>0))
 {
  if (loparrying!=hiparrying) chars[c].baseskill[PARRYING]=(rand()%(hiparrying-loparrying)+loparrying);
  else chars[c].baseskill[PARRYING]=loparrying;
 }
 if((loresist>0)&&(hiresist>0))
 {
  if (loresist!=hiresist) chars[c].baseskill[MAGICRESISTANCE]=(rand()%(hiresist-loresist)+loresist);
  else chars[c].baseskill[MAGICRESISTANCE]=loresist;
 }
 
  // Setup the npc's str,dex and other values
 
 if((lost>0)&&(hist>0))
 {
  if (hist!=lost) chars[c].st=(rand()%(hist-lost))+(lost);
  else chars[c].st=lost;
  chars[c].st2=chars[c].st;
  chars[c].hp=chars[c].st;
 }
 if((hiin>0)&&(loin>0))
 {
  if (hiin!=loin) chars[c].in=(rand()%(hiin-loin))+(loin);
  else chars[c].in=loin;
  chars[c].in2=chars[c].in;
  chars[c].mn=chars[c].in;
 }
 if((hidx>0)&&(lodx>0))
 {
 chars[c].dx=(rand()%(hidx-lodx))+(lodx);
 if (hidx!=lodx) chars[c].dx=(rand()%(hidx-lodx))+(lodx);
 else chars[c].dx=lodx;
 chars[c].dx2=chars[c].dx;
 chars[c].stm=chars[c].dx;
 }
 
 if (chars[c].fx1==-1)
 {
  if (type==1)
  {
   chars[c].fx1=items[s].x;
   chars[c].fy1=items[s].y;
   if (chars[c].fz1!=-1) chars[c].fz1=items[s].z;
  }
  else
  {
   chars[c].fx1=(buffer[s][11]*256)+buffer[s][12];
   chars[c].fy1=(buffer[s][13]*256)+buffer[s][14];
   if (chars[c].fz1!=-1) chars[c].fz1=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
  }
 }
 if (donpcupdate==0)
 {
   /*if (c==charcount)
   {
     charcount++;
     charcount2++;
   }*/
   updatechar(c);
 }
 return c;
}

void StartMilliTimer(unsigned long &Seconds, unsigned long &Milliseconds)
{
#ifdef __NT__
        struct timeb t;
        ftime(&t);
        Seconds = t.time;
        Milliseconds = t.millitm;
#else

#endif
}

unsigned long CheckMilliTimer(unsigned long &Seconds, unsigned long &Milliseconds)
{
#ifdef __NT__
        struct timeb t;
        ftime(&t);
        return(1000*(t.time - Seconds) + (t.millitm - Milliseconds));
#else
        return(0);
#endif
}

void advancementobjects(int s, int x, int allways)
{
 char sect[512];
 
 int hairobject=-1, beardobject=-1;
 int j,pos,packnum,i;
 if ((chars[s].advobj==0)||(allways==1))
 {
 staticeffect(s, 0x37, 0x3A, 0, 15);
 soundeffect2(s, 0x01, 0xE9);
 chars[s].advobj=x;
 openscript("advance.scp");
 sprintf(sect, "ADVANCEMENT %i", x);
 if (!advance_script.find(sect))
 {
  closescript();
  printf("ADVANCEMENT OBJECT: Script section not found. Aborting.\n");
  chars[s].advobj=0;
  return;
 }
 else
 do 
 {
  read2();
  if (script1[0]!='}')
  { 
   if ((!(strcmp("STR",script1)))||(!(strcmp("STRENGTH",script1))))
   {
    chars[s].st  = getstatskillvalue(script2);
    chars[s].st2 = chars[s].st;
   }
   if ((!(strcmp("DEX",script1)))||(!(strcmp("DEXTERITY",script1))))
   {
    chars[s].dx  = getstatskillvalue(script2);
    chars[s].dx2 = chars[s].dx;
   }
   if ((!(strcmp("INT",script1)))||(!(strcmp("INTELLIGENCE",script1))))
   {
    chars[s].in  = getstatskillvalue(script2);
    chars[s].in2 = chars[s].in;
   }
   if ((!(strcmp("ALCHEMY",script1)))||(!(strcmp("SKILL0",script1)))) chars[s].baseskill[ALCHEMY] = getstatskillvalue(script2);
   if ((!(strcmp("ANATOMY",script1)))||(!(strcmp("SKILL1",script1)))) chars[s].baseskill[ANATOMY] = getstatskillvalue(script2);
   if ((!(strcmp("ANIMALLORE",script1)))||(!(strcmp("SKILL2",script1)))) chars[s].baseskill[ANIMALLORE] = getstatskillvalue(script2);
   if ((!(strcmp("ITEMID",script1)))||(!(strcmp("SKILL3",script1)))) chars[s].baseskill[ITEMID] = getstatskillvalue(script2);
   if ((!(strcmp("ARMSLORE",script1)))||(!(strcmp("SKILL4",script1)))) chars[s].baseskill[ARMSLORE] = getstatskillvalue(script2);
   if ((!(strcmp("PARRYING",script1)))||(!(strcmp("SKILL5",script1)))) chars[s].baseskill[PARRYING] = getstatskillvalue(script2);
   if ((!(strcmp("BEGGING",script1)))||(!(strcmp("SKILL6",script1)))) chars[s].baseskill[BEGGING] = getstatskillvalue(script2);
   if ((!(strcmp("BLACKSMITHING",script1)))||(!(strcmp("SKILL7",script1)))) chars[s].baseskill[BLACKSMITHING] = getstatskillvalue(script2);
   if ((!(strcmp("BOWCRAFT",script1)))||(!(strcmp("SKILL8",script1)))) chars[s].baseskill[BOWCRAFT] = getstatskillvalue(script2);
   if ((!(strcmp("PEACEMAKING",script1)))||(!(strcmp("SKILL9",script1)))) chars[s].baseskill[PEACEMAKING] = getstatskillvalue(script2);
   if ((!(strcmp("CAMPING",script1)))||(!(strcmp("SKILL10",script1)))) chars[s].baseskill[CAMPING] = getstatskillvalue(script2);
   if ((!(strcmp("CARPENTRY",script1)))||(!(strcmp("SKILL11",script1)))) chars[s].baseskill[CARPENTRY] = getstatskillvalue(script2);
   if ((!(strcmp("CARTOGRAPHY",script1)))||(!(strcmp("SKILL12",script1)))) chars[s].baseskill[CARTOGRAPHY] = getstatskillvalue(script2);
   if ((!(strcmp("COOKING",script1)))||(!(strcmp("SKILL13",script1)))) chars[s].baseskill[COOKING] = getstatskillvalue(script2);
   if ((!(strcmp("DETECTINGHIDDEN",script1)))||(!(strcmp("SKILL14",script1)))) chars[s].baseskill[DETECTINGHIDDEN] = getstatskillvalue(script2);
   if ((!(strcmp("ENTICEMENT",script1)))||(!(strcmp("SKILL15",script1)))) chars[s].baseskill[ENTICEMENT] = getstatskillvalue(script2);
   if ((!(strcmp("EVALUATINGINTEL",script1)))||(!(strcmp("SKILL16",script1)))) chars[s].baseskill[EVALUATINGINTEL] = getstatskillvalue(script2);
   if ((!(strcmp("HEALING",script1)))||(!(strcmp("SKILL17",script1)))) chars[s].baseskill[HEALING] = getstatskillvalue(script2);
   if ((!(strcmp("FISHING",script1)))||(!(strcmp("SKILL18",script1)))) chars[s].baseskill[FISHING] = getstatskillvalue(script2);
   if ((!(strcmp("FORENSICS",script1)))||(!(strcmp("SKILL19",script1)))) chars[s].baseskill[FORENSICS] = getstatskillvalue(script2);
   if ((!(strcmp("HERDING",script1)))||(!(strcmp("SKILL20",script1)))) chars[s].baseskill[HERDING] = getstatskillvalue(script2);
   if ((!(strcmp("HIDING",script1)))||(!(strcmp("SKILL21",script1)))) chars[s].baseskill[HIDING] = getstatskillvalue(script2);
   if ((!(strcmp("PROVOCATION",script1)))||(!(strcmp("SKILL22",script1)))) chars[s].baseskill[PROVOCATION] = getstatskillvalue(script2);
   if ((!(strcmp("INSCRIPTION",script1)))||(!(strcmp("SKILL23",script1)))) chars[s].baseskill[INSCRIPTION] = getstatskillvalue(script2);
   if ((!(strcmp("LOCKPICKING",script1)))||(!(strcmp("SKILL24",script1)))) chars[s].baseskill[LOCKPICKING] = getstatskillvalue(script2);
   if ((!(strcmp("MAGERY",script1)))||(!(strcmp("SKILL25",script1)))) chars[s].baseskill[MAGERY] = getstatskillvalue(script2);
   if ((!(strcmp("MAGICRESISTANCE",script1)))||(!(strcmp("RESIST",script1)))||(!(strcmp("SKILL26",script1)))) chars[s].baseskill[MAGICRESISTANCE] = getstatskillvalue(script2);
   if ((!(strcmp("TACTICS",script1)))||(!(strcmp("SKILL27",script1)))) chars[s].baseskill[TACTICS] = getstatskillvalue(script2);
   if ((!(strcmp("SNOOPING",script1)))||(!(strcmp("SKILL28",script1)))) chars[s].baseskill[SNOOPING] = getstatskillvalue(script2);
   if ((!(strcmp("MUSICIANSHIP",script1)))||(!(strcmp("SKILL29",script1)))) chars[s].baseskill[MUSICIANSHIP] = getstatskillvalue(script2);
   if ((!(strcmp("POISONING",script1)))||(!(strcmp("SKILL30",script1)))) chars[s].baseskill[POISONING] = getstatskillvalue(script2);
   if ((!(strcmp("ARCHERY",script1)))||(!(strcmp("SKILL31",script1)))) chars[s].baseskill[ARCHERY] = getstatskillvalue(script2);
   if ((!(strcmp("SPIRITSPEAK",script1)))||(!(strcmp("SKILL32",script1)))) chars[s].baseskill[SPIRITSPEAK] = getstatskillvalue(script2);
   if ((!(strcmp("STEALING",script1)))||(!(strcmp("SKILL33",script1)))) chars[s].baseskill[STEALING] = getstatskillvalue(script2);
   if ((!(strcmp("TAILORING",script1)))||(!(strcmp("SKILL34",script1)))) chars[s].baseskill[TAILORING] = getstatskillvalue(script2);
   if ((!(strcmp("TAMING",script1)))||(!(strcmp("SKILL35",script1)))) chars[s].baseskill[TAMING] = getstatskillvalue(script2);
   if ((!(strcmp("TASTEID",script1)))||(!(strcmp("SKILL36",script1)))) chars[s].baseskill[TASTEID] = getstatskillvalue(script2);
   if ((!(strcmp("TINKERING",script1)))||(!(strcmp("SKILL37",script1)))) chars[s].baseskill[TINKERING] = getstatskillvalue(script2);
   if ((!(strcmp("TRACKING",script1)))||(!(strcmp("SKILL38",script1)))) chars[s].baseskill[TRACKING] = getstatskillvalue(script2);
   if ((!(strcmp("VETERINARY",script1)))||(!(strcmp("SKILL39",script1)))) chars[s].baseskill[VETERINARY] = getstatskillvalue(script2);
   if ((!(strcmp("SWORDSMANSHIP",script1)))||(!(strcmp("SKILL40",script1)))) chars[s].baseskill[SWORDSMANSHIP] = getstatskillvalue(script2);
   if ((!(strcmp("MACEFIGHTING",script1)))||(!(strcmp("SKILL41",script1)))) chars[s].baseskill[MACEFIGHTING] = getstatskillvalue(script2);
   if ((!(strcmp("FENCING",script1)))||(!(strcmp("SKILL42",script1)))) chars[s].baseskill[FENCING] = getstatskillvalue(script2);
   if ((!(strcmp("WRESTLING",script1)))||(!(strcmp("SKILL43",script1)))) chars[s].baseskill[WRESTLING] = getstatskillvalue(script2);
   if ((!(strcmp("LUMBERJACKING",script1)))||(!(strcmp("SKILL44",script1)))) chars[s].baseskill[LUMBERJACKING] = getstatskillvalue(script2);
   if ((!(strcmp("MINING",script1)))||(!(strcmp("SKILL45",script1)))) chars[s].baseskill[MINING] = getstatskillvalue(script2);

   if ((!(strcmp("DYEHAIR",script1)))) 
   {
     int serial,serhash,ci;
     serial=chars[s].serial;
     serhash=serial%256;
     for (ci=0;ci<contsp[serhash].max;ci++)
     {
       i=contsp[serhash].pointer[ci];
       if ((i!=-1) && (items[i].layer==0x0B) && (items[i].contserial==serial))
       {
        hairobject=i;
        break;
       }  
     }
    if (hairobject>-1)
        {
     x=hstr2num(script2);
     items[hairobject].color1=x/256;   
     items[hairobject].color2=x%256;
     for (j=0;j<now;j++) if (perm[j]) senditem(j,hairobject);  
     teleport(s);
        }
   }
   
   if ((!(strcmp("DYEBEARD",script1)))) 
   {
     int serial,serhash,ci;
      serial=chars[s].serial;
      serhash=serial%256;
      for (ci=0;ci<contsp[serhash].max;ci++)
      {
        i=contsp[serhash].pointer[ci];
        if ((i!=-1) && (items[i].layer==0x10) && (items[i].contserial==serial))
         {
          beardobject=i;
          break;
         }  
        }
    if (beardobject>-1)
        {
     x=hstr2num(script2);
     items[beardobject].color1=x/256;   
     items[beardobject].color2=x%256;  
     for (j=0;j<now;j++) if (perm[j]) senditem(j,beardobject);   
     teleport(s);
        }
   }
   
   if (!(strcmp("KILLHAIR",script1)))
   {
     int serial,serhash,ci;
     serial=chars[s].serial;
     serhash=serial%256;
     for (ci=0;ci<contsp[serhash].max;ci++)
     {
       i=contsp[serhash].pointer[ci];
       if ((i!=-1) && (items[i].layer==0x0B) && (items[i].contserial==serial))
       {
        deleitem(i);
        break;
        }   
     }  
   }

   if (!(strcmp("KILLBEARD",script1)))
   {
     int serial,serhash,ci;
     serial=chars[s].serial;
     serhash=serial%256;
     for (ci=0;ci<contsp[serhash].max;ci++)
     {
       i=contsp[serhash].pointer[ci];
       if ((i!=-1) && (items[i].layer==0x10) && (items[i].contserial==serial))
       {
        deleitem(i);
        break;
       }   
     } 
   }

   if (!(strcmp("KILLPACK",script1)))
   {
     int serial,serhash,ci;
     serial=chars[s].serial;
     serhash=serial%256;
     for (ci=0;ci<contsp[serhash].max;ci++)
     {
       i=contsp[serhash].pointer[ci];
       if ((i!=-1) && (items[i].layer==0x15) && (items[i].contserial==serial))
       {
        deleitem(i);
        break;
       }   
     } 
   }

      if (!(strcmp("ITEM",script1)))
   {
        x=str2num(script2);            
        pos=ftell(scpfile);
        j=addmenutarget(-1, 0, x);
        openscript("advance.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");   
        packnum=packitem(s);
        items[j].x=50+(rand()%80);
        items[j].y=50+(rand()%80);
        items[j].z=9;
        if(items[j].layer==0x0b || items[j].layer==0x10)
        {
          setserial(j,s,4);
        }
        else
        {
          setserial(j,packnum,1);
        }
        for (i=0;i<now;i++) if (perm[i])
        senditem(i,j);                
        teleport(s);
   }

   if (!(strcmp(script1,"SKIN")))
   {
        i=hstr2num(script2);
        chars[s].skin1=i/256;
        chars[s].skin2=i%256;
        teleport(s);
   }

   if (!(strcmp("POLY",script1)))
   {
        x=hstr2num(script2);
        chars[s].id1=x/256;
        chars[s].xid1=x/256;
        chars[s].id2=x%256;
        chars[s].xid2=x%256;
        teleport(s);  
   }

   if (!(strcmp("ADVOBJ",script1)))
   {
        x=str2num(script2);
        chars[s].advobj=x;
   }
  }
 }
 while (script1[0]!='}');
 closescript();
 }
 else sysmessage(calcSocketFromChar(s),"You have allready used an advancement object with this character.");
}

// Dupois - added to do easy item sound effects based on an 
//          items id1 and id2 fields in struct items. Then just define the CASE statement
//          with the proper sound function to play for a certain item as shown.
//          Use the DEFAULT case for ranges of  items (like all ingots make the same thump).
// Sounds - coins dropping (all the same no matter what amount because all id's equal 0x0EED
//          ingot dropping (makes a big thump - used the heavy gem sound)
//          gems dropping (two type broke them in half to make some sound different then others)
// NOTE   - I wasn't sure what the different soundeffect() func's did so I just used 
//          soundeffect() and it seemed to work fairly well.
// Added Oct 09, 1998
void itemsfx(int s, int ID1, int ID2)
{
 int item=0;
 
 item = (ID1*256) + ID2;
 
 switch(item)
 {
 /* This doesn't work, as gold is allways id 0EED, the only thing that changes is the ammount. SJ.
 case 0x0EEA:  // single copper coin
        goldsfx(s, 1); break;
 case 0x0EEB:  // couple copper coins
        goldsfx(s, 2); break;
 case 0x0EEC:  // pile copper coins
        goldsfx(s, 6); break;
 case 0x0EED:  // single gold coin
        goldsfx(s, 1); break;
 case 0x0EEE:  // couple gold coins
        goldsfx(s, 2); break;
 case 0x0EEF:  // pile gold coins
        goldsfx(s, 6); break;
 case 0x0EF0:  // single silver coin
        goldsfx(s, 1); break;
 case 0x0EF1:  // couple silver coins
        goldsfx(s, 2); break;
 case 0x0EF2:  // pile silver coins
        goldsfx(s, 6); break;
 */
 default:
                if (item==0x0EED)
                {
         goldsfx(s, 2);
         break;
                }
        if ((item>=0x0F0F)&&(item<=0x0F20))  // Any gem stone (typically smaller)
        {
         soundeffect(s, 0x00, 0x32);
         break;
        }
        if ((item>=0x0F21)&&(item<=0x0F30))  // Any gem stone (typically larger)
        {
         soundeffect(s, 0x00, 0x34);
         break;
        }
        if ((item>=0x1BE3)&&(item<=0x1BFA))  // Any Ingot
        {
         soundeffect(s, 0x00, 0x33);
         break;
        }
        soundeffect(s, 0x00, 0x42); break;  // play default item move sfx // 00 48
 }
} // Dupois - end 


void bgsound (int s) // Plays background sounds of the game
  {
  int x, ds, dx, sound;
  int distance=(VISRANGE+5);
  int inrange[15];
  int y=0;
  int basesound=0;
  
  for (x=1;x<=charcount;x++)
    {
    if((chars[x].npc)&&(!(chars[x].dead))&&(!(chars[x].war))&&(y<=10))
      {
      ds=abs(chars[s].x-chars[x].x);
      dx=abs(chars[s].y-chars[x].y);
      if((ds<=distance)&&(dx<=distance)) 
        {
        y++;
        inrange[y]=x;
        }
      }
    }
  if (y!=0)
    {
    sound=((rand()%(y))+1);
    
    switch(chars[inrange[sound]].id1)
      {
      case 0x00:
        {
        switch(chars[inrange[sound]].id2)
          {
          case 0x01: basesound=0x01AB; break; // Ogre
          case 0x02: // Ettin 
          case 0x12: basesound=0x016F; break; // Ettin with stone ax
          case 0x03: basesound=0x01D7; break; // Zombie
          case 0x04: basesound=0x0174; break; // Gargoyle
          case 0x05: basesound=0x008f; break; // Eagle
          case 0x06: basesound=0x007d; break; // Bird
          case 0x07: // Full armed Orc
          case 0x11: // Orc
          case 0x29: basesound=0x01b0; break; // Orc with club
          case 0x08: basesound=0x01ba; break; // Reaper
          case 0x09: // Daemon
          case 0x0a: basesound=0x0165; break; // Daemon with sword
          case 0x0c: // Green Dragon
          case 0x3b: // Red Dragon
          case 0x3c: // Smaller Green Dragon
          case 0x3d: basesound=0x016A; break; // Smaller Red Dragon
          case 0x0D: basesound=0x0107; break; // Wind Elemental
          case 0x0E: basesound=0x010C; break; // Earth Elemental
          case 0x0F: basesound=0x0111; break; // Fire Elemental
          case 0x10: basesound=0x0116; break; // Water Elemental
          case 0x15: // Giant Snake
          case 0x34: basesound=0x00db; break; // Snake
          case 0x16: basesound=0x0179; break; // Gazer
          case 0x18: basesound=0x019C; break; // Liche
          case 0x1a: basesound=0x017E; break; // Floating Skeleton
          case 0x1C: basesound=0x0183; break; // Giant Spider
          case 0x1D: basesound=0x009E; break; // Gorilla
          case 0x1E: basesound=0x0192; break; // Harpy
          case 0x1F: basesound=0x0197; break; // Headless
          case 0x21: // Lizardman
          case 0x23:
          case 0x24: basesound=0x01A1; break;
          case 0x27: basesound=0x01A6; break; // Mongbatt
          case 0x2A: // Ratman
          case 0x2C:
          case 0x2D: basesound=0x01B5; break;
          case 0x2F: basesound=0x01BA; break; // Reaper
          case 0x30: basesound=0x018D; break; // Giant Scorpion
          case 0x32: // Skeleton
          case 0x38: // Skeleton with ax
          case 0x39: basesound=0x01C3; break; // Skeleton with sword and shield
          case 0x33: basesound=0x01C8; break; // Slime
          case 0x35: // Troll 1
          case 0x36: // Troll 2
          case 0x37: basesound=0x01CD; break; // Troll 3
          case 0x3A: basesound=0x01D2; break; // Wisp
          case 0x97: basesound=0x008A; break; // Dolphin
          case 0xc9: basesound=0x0069; break; // Cat
          case 0xca: basesound=0x005A; break; // Alligator
          case 0xcb: basesound=0x00C4; break; // Pig
          case 0xcf: // Sheep
          case 0xdf: basesound=0x00D7; break; // Sheep
          case 0xd0: basesound=0x006E; break; // Chicken
          case 0xd1: basesound=0x0099; break; // Goat
          case 0xd3: // Brown Bear
          case 0xd5: basesound=0x005f; break; // Polar Bear
          case 0xd4: basesound=0x00a3; break; // Grizzly Bear 
          case 0xd6: basesound=0x00ba; break; // Panther
          case 0xd7: // Rat
          case 0xee: basesound=0x0188; break; // Rat
          case 0xd8: // Cow
          case 0xe7: // Cow
          case 0xe9: basesound=0x0078; break; // Cow
          case 0xd9: basesound=0x0085; break; // Dog
          case 0xdd: basesound=0x00e0; break; // Walrus
          case 0xe1: basesound=0x00e5; break; // Jackal
          case 0xe8: basesound=0x0064; break; // Bull
          case 0xe2: // Horse
          case 0xe4: // Horse
          case 0xc8: // White Horse
          case 0xcc: basesound=0x00a8; break; // Brown Horse
          case 0x96: basesound=0x01bf; break; // Sea Serpent
          }
        }
      case 0x01:
        {
        switch(chars[inrange[sound]].id2)
          {
          case 0x22: basesound=0x00c4; break; // Pig
          case 0x23: basesound=0x01a1; break; // Pack Horse with Saddle Bags
          }
        }
      }
    if (basesound !=0)
      { 
      sfx[2]=basesound/256;
      sfx[3]=basesound%256;
      sfx[6]=chars[inrange[sound]].x/256;
      sfx[7]=chars[inrange[sound]].x%256;
      sfx[8]=chars[inrange[sound]].y/256;
      sfx[9]=chars[inrange[sound]].y%256;
      xsend(s, sfx, 12, 0);
      }
    }
} 


void monstergate(int s, int x)
{
  int tmp, n, z, lovalue, hivalue, mypack, retitem, j;
  int storeval, shoppack1, shoppack2, shoppack3;
  //unsigned short int tempskill;
  char sect[512];
  long int pos;
  char rndlootlist[20];

  if (chars[s].npc) return;

  mypack=-1;
  retitem=-1;
  storeval=-1;
  shoppack1=-1;
  shoppack2=-1;
  shoppack3=-1;

  openscript("npc.scp");
  sprintf(sect, "NPC %i", x);
  if (!npc_script.find(sect))
  {
    closescript();
    return;
  }

  *(chars[s].title)='\0'; // was sprintf(chars[s].title, "");
  for(z=0;z<itemcount;z++)
  {
    if (items[z].contserial==chars[s].serial &&
        items[z].layer!=0x15 && items[z].layer!=0x1D &&
        items[z].layer!=0x10 && items[z].layer!=0x0B && (items[z].free==0))
    {
      if (mypack==-1)
      {
        mypack=packitem(s);
      }
      if (mypack==-1)
      {
        chars[s].packitem=n=SpawnItem(calcSocketFromChar(s),1,"#",0,0x0E,0x75,0,0,0,0);
        setserial(n,s,4);
        items[n].layer=0x15;
        items[n].type=1;
        items[n].dye=1;
        mypack=n;
        retitem=n;
      }
      items[z].x=(rand()%80)+50;
      items[z].y=(rand()%80)+50;
      items[z].z=9;
			if (items[z].contserial!=-1) removefromptr(&contsp[items[z].contserial%256], z);
      setserial(z,mypack,1);
      items[z].layer=0x00;

      removeitem[1]=items[z].ser1;
      removeitem[2]=items[z].ser2;
      removeitem[3]=items[z].ser3;
      removeitem[4]=items[z].ser4;
      for(j=0;j<now;j++)
      if (perm[j])
      {
        xsend(j, removeitem, 5, 0);
        senditem(j, z);
      }
    }
    else if (items[z].contserial==chars[s].serial &&
            (items[z].layer==0x0B || items[z].layer==0x10))
    {
      deleitem(z);
    }
  }

  do
  {
    read2();
    if (script1[0]!='}')
    {
      if (!(strcmp("NAME",script1)))
      {
        sprintf(chars[s].name, "%s", script2);
      }
      if (!(strcmp("NAMELIST", script1)))
      {
        pos=ftell(scpfile);
        closescript();
        setrandomname(s,script2);
        openscript("npc.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY"); // To prevent accidental exit of loop.
      }
      if (!(strcmp("TITLE",script1))) sprintf(chars[s].title, "%s", script2);
      if (!(strcmp("KARMA",script1))) chars[s].karma=str2num(script2);
      if (!(strcmp("FAME",script1))) chars[s].fame=str2num(script2);
      if (!(strcmp("ID",script1)))
      {
        tmp=hstr2num(script2);
        chars[s].id1=tmp/256;
        chars[s].id2=tmp%256;
        chars[s].xid1=chars[s].id1;
        chars[s].xid2=chars[s].id2;
      }
      if (!(strcmp("SKIN",script1)))
      {
        tmp=hstr2num(script2);
        chars[s].skin1=tmp/256;
        chars[s].skin2=tmp%256;
        chars[s].xskin1=chars[s].skin1;
        chars[s].xskin2=chars[s].skin2;
      }

      if (!(strcmp("GOLD", script1)))
			{
        retitem=n=SpawnItem(calcSocketFromChar(s),1,"#",1,0x0E,0xED,0,0,1,0);
        gettokennum(script2, 0);
        lovalue=str2num(gettokenstr);
        gettokennum(script2, 1);
        hivalue=str2num(gettokenstr);
        if (hivalue==0)
        {
          items[n].amount=lovalue/2 + (rand()%(lovalue/2));
        }
				else
				{
					items[n].amount=lovalue + (rand()%(hivalue-lovalue));
				}
			}
		if (!(strcmp("LOOT",script1)))
		{
				sprintf(rndlootlist, "%s", script2);
				pos=ftell(scpfile);
				closescript();
				retitem=addrandomloot(mypack, rndlootlist);
				openscript("npc.scp");
				fseek(scpfile, pos, SEEK_SET);
				sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
		}
  if (!(strcmp("ITEM",script1)))
   {
   storeval=str2num(script2);
   pos=ftell(scpfile);
   closescript();
   retitem=addmenutarget(-1, 0, storeval);
   openscript("npc.scp");
   fseek(scpfile, pos, SEEK_SET);
   setserial(retitem,s,4);
   if (items[retitem].layer==0)
   {
			printf("Warning: Bad NPC Script %d with problem item %d executed!\n", x, storeval);
   }
   sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
   }
		if (!(strcmp("PACKITEM",script1)))
		{
			storeval=str2num(script2);
			pos=ftell(scpfile);
			closescript();
			retitem=addmenutarget(-1, 0, storeval);
			openscript("npc.scp");
			fseek(scpfile, pos, SEEK_SET);
			setserial(retitem,mypack,1);
			items[retitem].x=50+(rand()%80);
			items[retitem].y=50+(rand()%80);
			items[retitem].z=9;
			sprintf(script1, "DUMMY"); // Prevents unexpected matchups...
   }
  if (!(strcmp("COLOR",script1)))
   {
   items[retitem].color1=(hstr2num(script2))/256;
   items[retitem].color2=(hstr2num(script2))%256;
   }
  if (!(strcmp("POISON",script1))) chars[s].poison=str2num(script2);

  //--------------------- NEW STAT & SKILL FORMAT ----------------
  //Handle Stats
  if ((!(strcmp("STR",script1)))||(!(strcmp("STRENGTH",script1))))
   {
   chars[s].st = getstatskillvalue(script2);
   chars[s].st2 = chars[s].st;
   chars[s].hp = chars[s].st;
   }
  if ((!(strcmp("DEX",script1)))||(!(strcmp("DEXTERITY",script1))))
   {
   chars[s].dx = getstatskillvalue(script2);
   chars[s].dx2 = chars[s].dx;
   chars[s].stm = chars[s].dx;
   }
  if ((!(strcmp("INT",script1)))||(!(strcmp("INTELLIGENCE",script1))))
   {
   chars[s].in = getstatskillvalue(script2);
   chars[s].in2 = chars[s].in;
   chars[s].mn = chars[s].in;
   }
  //Done Handling Stats

  //Handle Skills
  if ((!(strcmp("ALCHEMY",script1)))||(!(strcmp("SKILL0",script1))))
     chars[s].baseskill[ALCHEMY] = getstatskillvalue(script2);
  if ((!(strcmp("ANATOMY",script1)))||(!(strcmp("SKILL1",script1))))
     chars[s].baseskill[ANATOMY] = getstatskillvalue(script2);
  if ((!(strcmp("ANIMALLORE",script1)))||(!(strcmp("SKILL2",script1))))
     chars[s].baseskill[ANIMALLORE] = getstatskillvalue(script2);
  if ((!(strcmp("ITEMID",script1)))||(!(strcmp("SKILL3",script1))))
     chars[s].baseskill[ITEMID] = getstatskillvalue(script2);
  if ((!(strcmp("ARMSLORE",script1)))||(!(strcmp("SKILL4",script1))))
     chars[s].baseskill[ARMSLORE] = getstatskillvalue(script2);
  if ((!(strcmp("PARRYING",script1)))||(!(strcmp("SKILL5",script1))))
     chars[s].baseskill[PARRYING] = getstatskillvalue(script2);
  if ((!(strcmp("BEGGING",script1)))||(!(strcmp("SKILL6",script1))))
     chars[s].baseskill[BEGGING] = getstatskillvalue(script2);
  if ((!(strcmp("BLACKSMITHING",script1)))||(!(strcmp("SKILL7",script1))))
     chars[s].baseskill[BLACKSMITHING] = getstatskillvalue(script2);
  if ((!(strcmp("BOWCRAFT",script1)))||(!(strcmp("SKILL8",script1))))
     chars[s].baseskill[BOWCRAFT] = getstatskillvalue(script2);
  if ((!(strcmp("PEACEMAKING",script1)))||(!(strcmp("SKILL9",script1))))
     chars[s].baseskill[PEACEMAKING] = getstatskillvalue(script2);
  if ((!(strcmp("CAMPING",script1)))||(!(strcmp("SKILL10",script1))))
     chars[s].baseskill[CAMPING] = getstatskillvalue(script2);
  if ((!(strcmp("CARPENTRY",script1)))||(!(strcmp("SKILL11",script1))))
     chars[s].baseskill[CARPENTRY] = getstatskillvalue(script2);
  if ((!(strcmp("CARTOGRAPHY",script1)))||(!(strcmp("SKILL12",script1))))
     chars[s].baseskill[CARTOGRAPHY] = getstatskillvalue(script2);
  if ((!(strcmp("COOKING",script1)))||(!(strcmp("SKILL13",script1))))
     chars[s].baseskill[COOKING] = getstatskillvalue(script2);
  if ((!(strcmp("DETECTINGHIDDEN",script1)))||(!(strcmp("SKILL14",script1))))
     chars[s].baseskill[DETECTINGHIDDEN] = getstatskillvalue(script2);
  if ((!(strcmp("ENTICEMENT",script1)))||(!(strcmp("SKILL15",script1))))
     chars[s].baseskill[ENTICEMENT] = getstatskillvalue(script2);
  if ((!(strcmp("EVALUATINGINTEL",script1)))||(!(strcmp("SKILL16",script1))))
     chars[s].baseskill[EVALUATINGINTEL] = getstatskillvalue(script2);
  if ((!(strcmp("HEALING",script1)))||(!(strcmp("SKILL17",script1))))
     chars[s].baseskill[HEALING] = getstatskillvalue(script2);
  if ((!(strcmp("FISHING",script1)))||(!(strcmp("SKILL18",script1))))
     chars[s].baseskill[FISHING] =      getstatskillvalue(script2);
  if ((!(strcmp("FORENSICS",script1)))||(!(strcmp("SKILL19",script1))))
     chars[s].baseskill[FORENSICS] = getstatskillvalue(script2);
  if ((!(strcmp("HERDING",script1)))||(!(strcmp("SKILL20",script1))))
     chars[s].baseskill[HERDING] = getstatskillvalue(script2);
  if ((!(strcmp("HIDING",script1)))||(!(strcmp("SKILL21",script1))))
     chars[s].baseskill[HIDING] = getstatskillvalue(script2);
  if ((!(strcmp("PROVOCATION",script1)))||(!(strcmp("SKILL22",script1))))
     chars[s].baseskill[PROVOCATION] = getstatskillvalue(script2);
  if ((!(strcmp("INSCRIPTION",script1)))||(!(strcmp("SKILL23",script1))))
     chars[s].baseskill[INSCRIPTION] = getstatskillvalue(script2);
  if ((!(strcmp("LOCKPICKING",script1)))||(!(strcmp("SKILL24",script1))))
     chars[s].baseskill[LOCKPICKING] = getstatskillvalue(script2);
  if ((!(strcmp("MAGERY",script1)))||(!(strcmp("SKILL25",script1))))
     chars[s].baseskill[MAGERY] = getstatskillvalue(script2);
  if ((!(strcmp("MAGICRESISTANCE",script1)))||(!(strcmp("RESIST",script1)))||(!(strcmp("SKILL26",script1))))
     chars[s].baseskill[MAGICRESISTANCE] = getstatskillvalue(script2);
  if ((!(strcmp("TACTICS",script1)))||(!(strcmp("SKILL27",script1))))
     chars[s].baseskill[TACTICS] = getstatskillvalue(script2);
  if ((!(strcmp("SNOOPING",script1)))||(!(strcmp("SKILL28",script1))))
     chars[s].baseskill[SNOOPING] = getstatskillvalue(script2);
  if ((!(strcmp("MUSICIANSHIP",script1)))||(!(strcmp("SKILL29",script1))))
     chars[s].baseskill[MUSICIANSHIP] = getstatskillvalue(script2);
  if ((!(strcmp("POISONING",script1)))||(!(strcmp("SKILL30",script1))))
     chars[s].baseskill[POISONING] = getstatskillvalue(script2);
  if ((!(strcmp("ARCHERY",script1)))||(!(strcmp("SKILL31",script1))))
     chars[s].baseskill[ARCHERY] = getstatskillvalue(script2);
  if ((!(strcmp("SPIRITSPEAK",script1)))||(!(strcmp("SKILL32",script1))))
     chars[s].baseskill[SPIRITSPEAK] = getstatskillvalue(script2);
  if ((!(strcmp("STEALING",script1)))||(!(strcmp("SKILL33",script1))))
     chars[s].baseskill[STEALING] = getstatskillvalue(script2);
  if ((!(strcmp("TAILORING",script1)))||(!(strcmp("SKILL34",script1))))
     chars[s].baseskill[TAILORING] = getstatskillvalue(script2);
  // Taming skill disabled for now for npcs - as they wont be training people
  // nor taming things on their own for a while. - Eventually.. when they can
  // train players how the taming skill, they themselves will need it. Then
  // it will require use of the "TOTAME" property outlined above.
  // if ((!(strcmp("TAMING",script1)))||(!(strcmp("SKILL35",script1))))
  //     chars[s].baseskill[TAMING] = getstatskillvalue(script2);
  if ((!(strcmp("TASTEID",script1)))||(!(strcmp("SKILL36",script1))))
     chars[s].baseskill[TASTEID] = getstatskillvalue(script2);
  if ((!(strcmp("TINKERING",script1)))||(!(strcmp("SKILL37",script1))))
     chars[s].baseskill[TINKERING] = getstatskillvalue(script2);
  if ((!(strcmp("TRACKING",script1)))||(!(strcmp("SKILL38",script1))))
     chars[s].baseskill[TRACKING] = getstatskillvalue(script2);
  if ((!(strcmp("VETERINARY",script1)))||(!(strcmp("SKILL39",script1))))
     chars[s].baseskill[VETERINARY] = getstatskillvalue(script2);
  if ((!(strcmp("SWORDSMANSHIP",script1)))||(!(strcmp("SKILL40",script1))))
     chars[s].baseskill[SWORDSMANSHIP] = getstatskillvalue(script2);
  if ((!(strcmp("MACEFIGHTING",script1)))||(!(strcmp("SKILL41",script1))))
     chars[s].baseskill[MACEFIGHTING] = getstatskillvalue(script2);
  if ((!(strcmp("FENCING",script1)))||(!(strcmp("SKILL42",script1))))
     chars[s].baseskill[FENCING] = getstatskillvalue(script2);
  if ((!(strcmp("WRESTLING",script1)))||(!(strcmp("SKILL43",script1))))
     chars[s].baseskill[WRESTLING] = getstatskillvalue(script2);
  if ((!(strcmp("LUMBERJACKING",script1)))||(!(strcmp("SKILL44",script1))))
     chars[s].baseskill[LUMBERJACKING] = getstatskillvalue(script2);
  if ((!(strcmp("MINING",script1)))||(!(strcmp("SKILL45",script1))))
     chars[s].baseskill[MINING] = getstatskillvalue(script2);
  //Done Handling Skills

  //Handle Extras
  if ((!(strcmp("DAMAGE",script1)))||(!(strcmp("ATT",script1))))
   {
   gettokennum(script2, 0);
   lovalue=str2num(gettokenstr);
   gettokennum(script2, 1);
   hivalue=str2num(gettokenstr);
   chars[s].lodamage = lovalue;
   chars[s].hidamage = lovalue;
   if(hivalue) chars[s].hidamage = hivalue;
   }
  if (!(strcmp("DEF",script1))) chars[s].def = getstatskillvalue(script2);
  //Done Handling Extras

  //Handle Obsolete Stuff
  if (!(strcmp("LODAMAGE",script1))) chars[s].lodamage=str2num(script2);
  if (!(strcmp("HIDAMAGE",script1))) chars[s].hidamage=str2num(script2);
  if (!(strcmp("SKILL", script1)))
   {
   gettokennum(script2, 0);
   z=str2num(gettokenstr);
   gettokennum(script2, 1);
   chars[s].baseskill[z]=str2num(gettokenstr);
   }
  //Done Handling Obsolete Stuff
  }
 //--------------- DONE NEW STAT & SKILL FORMAT ---------------------
 }
while (script1[0]!='}');
closescript();

//Now find real 'skill' based on 'baseskill' (stat modifiers)
for(z=0;z<TRUESKILLS;z++)
 {
 updateSkillLevel(s,z);
 }
if (donpcupdate==0)
 {
 //printf("1 "); /*DEBUG*/
 updatechar(s);
 //printf("2 "); /*DEBUG*/
 staticeffect(s, 0x37, 0x3A, 0, 15);
 //printf("3 "); /*DEBUG*/
 soundeffect2(s, 0x01, 0xE9);
 }
}

void Karma(int nCharID,int nKilledID, int nKarma)
{                                                                                               // nEffect = 1 positive karma effect
   int nCurKarma=0, nChange=0, nEffect=0;
        
   nCurKarma = chars[nCharID].karma;
   if((nCurKarma>10000)||(nCurKarma<-10000))
      if(nCurKarma>10000)
         chars[nCharID].karma=10000;
      else
         chars[nCharID].karma=-10000;
   if(nCurKarma<nKarma && nKarma>0)
   {
      nChange=((nKarma-nCurKarma)/75);
      chars[nCharID].karma=(nCurKarma+nChange);
      nEffect=1;
   }
   if((nCurKarma>nKarma)&&(chars[nKilledID].karma>0)||
      (nCurKarma>nKarma)&&(nKilledID==-1))
   {
      nChange=((nCurKarma-nKarma)/50);
      chars[nCharID].karma=(nCurKarma-nChange);
      nEffect=0;
   }
   if((nChange==0)||(chars[nCharID].npc==1))
      return;
if(nChange<=25)
 if(nEffect)
 {
 sysmessage(calcSocketFromChar(nCharID),
    "You have gained a little karma.");
 return;
 }
else
 {
 sysmessage(calcSocketFromChar(nCharID),
    "You have lost a little karma.");
 return;
 }
if(nChange<=50)
 if(nEffect)
 {
 sysmessage(calcSocketFromChar(nCharID),
    "You have gained some karma.");
 return;
 }
else
 {
 sysmessage(calcSocketFromChar(nCharID),
    "You have lost some karma.");
 return;
 }
if((nChange<=100)||(nChange>100))
 if(nEffect)
 {
 sysmessage(calcSocketFromChar(nCharID),
    "You have gained alot of karma.");
 return;
 }
else
 {
 sysmessage(calcSocketFromChar(nCharID),
    "You have lost alot of karma.");
 return;
 }
}
//added by Genesis 11-8-98
void Fame(int nCharID, int nFame)   
{
   int nCurFame, nChange=0, nEffect=0;

   nCurFame  = chars[nCharID].fame;
   if(nCurFame>nFame) // if player fame greater abort function
   {
      if(nCurFame>10000)
         chars[nCharID].fame=10000;
      return;
   }
   if(nCurFame<nFame)
   {
      nChange=(nFame-nCurFame)/75;
      chars[nCharID].fame=(nCurFame+nChange);
      nEffect=1;
   }
   if(chars[nCharID].dead==1)
   {
      if(nCurFame<=0)
         chars[nCharID].fame=0;
      else
      {
         nChange=(nCurFame-0)/25;
         chars[nCharID].fame=(nCurFame-nChange);
      }
      chars[nCharID].deaths++;
      nEffect=0;
   }
   if((nChange==0)||(chars[nCharID].npc==1))
      return;
   if(nChange<=25)
      if(nEffect)
      {
         sysmessage(calcSocketFromChar(nCharID),
            "You have gained a little fame.");
         return;
      }
      else
      {
         sysmessage(calcSocketFromChar(nCharID),
            "You have lost a little fame.");
         return;
      }
   if(nChange<=50)
      if(nEffect)
      {
         sysmessage(calcSocketFromChar(nCharID),
            "You have gained some fame.");
         return;
      }
      else
      {
         sysmessage(calcSocketFromChar(nCharID),
            "You have lost some fame.");
         return;
      }
   if((nChange<=100)||(nChange>100))
      if(nEffect)
      {
         sysmessage(calcSocketFromChar(nCharID),
            "You have gained alot of fame.");
         return;
      }
      else
      {
         sysmessage(calcSocketFromChar(nCharID),
            "You have lost alot of fame.");
         return;
      }
}

void enlist(int s, int listnum) // listnum is stored in items morex
{
int x,pos,i,j;
char sect[50];

openscript("items.scp");
sprintf(sect, "ITEMLIST %i", listnum);
if (!items_script.find(sect))
 {
 closescript();
 printf("UOX3: ITEMLIST not found, aborting.\n");
 return;
 }
 
do
 {
 read2();
 if (script1[0]!='}')
  {
  x=str2num(script1);
  pos=ftell(scpfile);
  j=SpawnItemBackpack2(s, x, 0);
  openscript("items.scp");
  fseek(scpfile, pos, SEEK_SET);
  sprintf(script1, "DUMMY");
  for (i=0;i<now;i++) if (perm[i]) senditem(i,j);
  }
 } 
while(strcmp(script1,"}"));
}

// new wipe function, basically it prints output on the console when someone wipes so that
// if a malicious GM wipes the world you know who to blame

void wipe(int s)
{
int k;

printf("UOX3: %s has initiated an item wipe\n",chars[currchar[s]].name);

for(k=0;k<=itemcount;k++)
 {
 if(items[k].contserial==-1 && items[k].wipe==0)
  {
  deleitem(k);
  }
 }
sysbroadcast("All items have been wiped."); 
}

int split(int k) // For NPCs That Split during combat
{
 int c,serial;

  c=memcharfree ();
  
  initchar(c);
  serial=chars[c].serial;
  memcpy(&chars[c],&chars[k],sizeof(char_st));
  chars[c].ser1=serial/16777216;
  chars[c].ser2=serial/65536;
  chars[c].ser3=serial/256;
  chars[c].ser4=serial%256;
  chars[c].serial=serial;
  chars[c].ftarg=-1;
  chars[c].x=chars[k].x+1;
  chars[c].y=chars[k].y;
  chars[c].kills=0;
  chars[c].hp=chars[k].st;
  chars[c].stm=chars[k].dx;
  chars[c].mn=chars[k].in;
  chars[c].split=0;  // Only the orignal can split test at 5% showed 30 slimes and growing
                     // from one slime
  /*if (c==charcount)
  {
   charcount++;
   charcount2++;
  }*/
  updatechar(c);
  return -1;
}
//o---------------------------------------------------------------------------o
//|	Class		:	void cantraintarget(int s)
//|	Date		:	1-3-99
//|	Programmer	:	Antrhacks
//o---------------------------------------------------------------------------o
//| Purpose		:Used for training by NPC's
//o---------------------------------------------------------------------------o
void cantraintarget(int s)
{
	int i,serial;

	serial=calcserial(buffer[s][7],buffer[s][8],buffer[s][9],buffer[s][10]);
	i=findbyserial(&charsp[serial%256], serial, 1);
	if (i!=-1)
	{
		if (chars[i].npc==0)
		{
			sysmessage(s, "Only NPC's may train.");
			return;
		}
		chars[i].cantrain=(chars[i].cantrain^1);  //turn on if off, off if on
	}
}

//o---------------------------------------------------------------------------o
//|	Class		:	void checkdumpdata(unsigned int currenttime)
//|	Date		:	1-5-99
//|	Programmer	:	Ridcully
//o---------------------------------------------------------------------------o
//| Purpose		:Used for Creating file read by UOXBot
//o---------------------------------------------------------------------------o
void checkdumpdata(unsigned int currenttime) // This dumps data for Ridcully's UOXBot 0.02 (jluebbe@hannover.aball.de)
{
  static unsigned int lastdump;
  if ((currenttime - lastdump)<30000)
  {
    return;
  }
  FILE *datafile;
  int i;

  //printf("UOX3: Dumping data!\n");

  datafile=fopen("botdata.txt","w");
  if (datafile==NULL)
  {
    printf("ERROR: botdata.txt could not be created.\n");
    return;
  }

  fprintf(datafile, "ONLINEPLAYERS = (");
  int firstplayer = 1;
  for (i=0;i<now;i++)
  {
    if(perm[i]) //Keeps NPC's from appearing on the list
    {
      if(firstplayer)
      {
        fprintf(datafile, "'%s'", chars[currchar[i]].name);
      }
      else
      {
        fprintf(datafile, ", '%s'", chars[currchar[i]].name);
      }
      firstplayer = 0;
    }
  }
  if(firstplayer)
  {
    fprintf(datafile, ")\n");
  }
  else
  {
    fprintf(datafile, ",)\n");
  }

  fprintf(datafile, "UOSERVER = '%s:%i'\n", serv[0][1], UOX_PORT);

  fprintf(datafile, "UOSERVERUP = 1\n");

  fclose(datafile);

  lastdump = currenttime;
}


void setsplittarget(int s)
{
 int i;
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   chars[i].split=tempint[s];
   break;
  }
 }
}

void setsplitchancetarget(int s)
{
 int i;
 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))
  {
   chars[i].splitchnc=tempint[s];
   break;
  }
 }
}

void possess(int s) // Needs work not fully done but works
{
 int i;

 for (i=0;i<charcount;i++)
 {
  if ((chars[i].ser1==buffer[s][7])&&(chars[i].ser2==buffer[s][8])&&
      (chars[i].ser3==buffer[s][9])&&(chars[i].ser4==buffer[s][10]))      
  {
   if ((chars[i].npc==1)&&(!(chars[i].shop)))
   {
    chars[i].account=chars[currchar[s]].account;
    chars[i].npc=0;
    chars[currchar[s]].npc=1;
    chars[currchar[s]].account=-1;
    chars[i].priv=chars[currchar[s]].priv;
    chars[i].priv2=chars[currchar[s]].priv2;
    chars[currchar[s]].priv=0x10;
    chars[currchar[s]].priv2=0;
    currchar[s]=i;
    sysmessage(s, "******");
    sysmessage(s, "YOU MUST NOW LOG OFF THEN BACK ON AS THAT CHARACTER");
    sysmessage(s, "******");
    walksequence[calcSocketFromChar(s)]=-1;
 //   impowncreate(calcSocketFromChar(s), i, 0);
    impowncreate(s,calcSocketFromChar(i), 1);
    break;
   }
   else
   {
    if (chars[i].shop) sysmessage(s,"You cannot use shopkeepers.");
    if (!(chars[i].npc)) sysmessage(s,"You can only use NPCs.");
    break;
   }
   break;
  }
 }
}



int line_of_sight(int s, int x1, int y1, int z1, int x2, int y2, int z2, int checkfor)
{
/*
Char (x1, y1, z1) is the char(pc/npc),  Target (x2, y2, z2) is the target.
s is for pc's, in case a message needs to be sent.
the checkfor is what is checked for along the line of sight.  
Look at uox3.h to see options. Works like npc magic.

#define TREES_BUSHES 1 // Trees and other large vegetaion in the way
#define WALLS_CHIMNEYS 2  // Walls, chimineys, ovens, etc... in the way
#define DOORS 4 // Doors in the way
#define ROOFING_SLANTED 8  // So can't tele onto slanted roofs, basically
#define FLOORS_FLAT_ROOFING 16  //  For attacking between floors
#define LAVA_WATER 32  // Don't know what all to use this for yet

Just add the values for the diff things together to get what to search for.
So put in place of the paramater checkfor for example

if (line_of_sight(s, x1, y1, z1, x2, y2, z2, WALLS_CHIMNEYS + DOORS + ROOFING_SLANTED))


This whole thing is based on the Pythagorean Theorem.  What I have done is
taken the coordinates from both chars and created a right triange with the
hypotenuse as the line of sight.  Then by sectioning off side "a" into a number
of equal lengths and finding the other sides lengths according to that one,  I 
have been able to find the coordinates of the tiles that lie along the line of
sight(line "c").  Then these tiles are searched from an item that would block 
the line of sight.
*/

 int a, b;     //  Lengths of sides a & b
 int xcheck=x1, ycheck=y1, zcheck=z1, prexcheck=-128, preycheck=-128, prezcheck=-128;
 double c;      //  Length of side c,  Line of sight
 int asquared, bsquared, csquared;  // Squares of a, b, c
 double a_divide;      //  this is how many times the entire line is checked 
 double a1_incrament= .1;  // the line is checked by this length incrament, can be chenged, the larger the num less checks, more misses
 double a2_incrament= a1_incrament;
 double c1_incrament, c2_incrament;  //  c/a_divide,  this give the length incrament along c
 double b1_incrament, b2_incrament, aplus=0, bplus=0, a2plus=0, b2plus=0;  //  the length of b1 at a1,c1
 int checkcount, dyncount;
 int x1check=0, xoff=0, y1check=0, yoff=0;
 int blocked=0;
 int not_blocked=1;
 double a2, b2, c2;
 staticrecord stat;
 tile_st tile;
 FILE *mfile;
 st_multi multi;
 struct map_st
 {
  short int id;
  signed char z;
 };
 map_st map1;
 long int pos, pos2, length, i,j;
/////what is checked for
 int itemids[MAXITEMS], checkitemcount=0;
 int checkthis[ITEM_TYPE_CHOICES];
 int checkthistotal;
 int itemtype;
/////item cahcing until item lookup is implimented
 int loscache[MAXITEMS], loscachecount=0;
///////////////////////////////////////////////////////////
/////////////////  These next lines initialize arrays
/*
 This function has to search the items array a number of times which
 caused a bit of lag.  I made this item cache to be used instead.  
 The items array is only search once for items in a 40 tile area.
 if an item is found, it is put into the cache, which is then used
 by the rest of the function.  This way it doesn't have to check the 
 entire array each time.
*/
 for (i=0;i<itemcount;i++)//  LoS Cache
 {
  if (
      (items[i].x<= x1 +20)&& 
      (items[i].x>= x1 -20)&&
	  (items[i].y<= y1 +20)&&
	  (items[i].y>= y1 -20)
	 )
  {
   loscache[loscachecount]=i;
   loscachecount++;
  }
 }
 for (i=0;i<itemcount;i++) itemids[i]=NULL; // Initializing
 for (i=0;i<=ITEM_TYPE_CHOICES;i++) checkthis[i]=NULL; // Initializing

////////////End Initilzations
//////////////////////////////////////////////////////////////
/*
  char(player/npc)
  1 2  *_____a_____
 1      \          |
 2        \        |
		    c      b   x -->
			  \    |   y  ^  
			    \  |      |
				  \|
                   *
				    target
 */

  if ((x2==65535)&&(y2==65535))  return not_blocked;  // target cancled
 


  a=abs(x1-x2)+1;  // length of side a
  b=abs(y1-y2)+1;  // length of side b 
  asquared=(a * a);
  bsquared=(b * b);
  csquared=(asquared + bsquared);
  c=sqrt(csquared);// length of c(hypotenuse==line of sight)

  a_divide = (a / a1_incrament);
  c1_incrament = (c / a_divide);

  if(a==1)
  {
   c1_incrament=1;
   a1_incrament=0;
   a_divide = b;  
  }
  
  b1_incrament=sqrt((c1_incrament*c1_incrament)-(a1_incrament*a1_incrament));
  if (b==1)
  {
   a1_incrament=1;
   a_divide=a;
   b1_incrament=0;
  }
//////////////////////////////////////////////////////////
// X position
  if (x2==x1) // Target has same x value
  {
   a1_incrament=(a1_incrament * 0); // sets x incraments to zero,  no incrament
  }
  if (x2>x1) // Target has greater x value
  {
   a1_incrament=(a1_incrament * 1); // sets x incrament positive
  }
  if (x2<x1) // Target has lesser x value
  {
   a1_incrament=(a1_incrament * -1); // sets x incrament negative, postitive initially
  }

// Y position
  if (y2==y1) // Target has same y value
  {
   b1_incrament=(b1_incrament * 0); //  sets y incrament to zero, no incrament
  }
  if (y2>y1) // Target has greater y value
  {
   b1_incrament=(b1_incrament * 1); // sets y incraments positive
  }
  if (y2<y1) // Target has lesser y value
  {
   b1_incrament=(b1_incrament * -1);  // sets y incrament negative, it's positive initially
  }
//////////////////////////////////////////////////////////////////////////////
/*
To find the tiles along the z axis another right triangle is formed.  This triangle
is formed along the line of sight between Char1 & Target, where the length of that line
is the length of the base of the triange.  The hiegth of the triangle is the targets z 
position.  We now have two sides, and to find the third we use the pathagorean theorem 
again, and that gives us the true line of sight in 3 dimentions: X, Y, Z.

*/
  a2=c;  // length of base
  b2=abs(z2-z1)+1;  // hieght of side 
  asquared=(a2 * a2);
  bsquared=(b2 * b2);
  csquared=(asquared + bsquared);
  c2=sqrt(csquared); //  length of true line of sight 3D

  a_divide = (a2 / a2_incrament);
  c2_incrament = (c2 / a_divide);
  b2_incrament=sqrt((c2_incrament*c2_incrament)-(a2_incrament*a2_incrament));  

  if (z1>z2) // going down
  {
   b2_incrament = (b2_incrament * -1);
  }
  if (z1==z2) // level ground
  {
   b2_incrament = 0;
  }

  aplus=a1_incrament;
  bplus=b1_incrament;
  b2plus=b2_incrament; // going up or down
////////////////////////////////////////////////////////
  ////////////////  This determines what to check for
  i=0;
  itemtype=1;
  checkthistotal=0;
  while (checkfor)
  {
   if ((checkfor>=itemtype)&&(checkfor<(itemtype * 2))&&(checkfor))
   {
    checkthis[i]=itemtype;
    ++i;
    checkfor = (checkfor - itemtype);
    ++checkthistotal;
    itemtype=1;
   }
    else
	if (checkfor)
	{
	 itemtype=(itemtype * 2);
	}
  }    
///////////////////////////////////////////////////////////////////////////
////////////////////  This next stuff is what searches each tile for things
 for (checkcount=1; checkcount<=a_divide; checkcount++)
 {
  if (xcheck!=x2) xcheck=(x1 + aplus); // x coord to check
  if (ycheck!=y2) ycheck=(y1 + bplus); // y coord to check
  if (zcheck!=z2) zcheck=(z1 + b2plus); // z coord to check
  if ((xcheck!=prexcheck)||(ycheck!=preycheck)||(zcheck!=prezcheck))
  { 
   // Texture mapping  
   x1check=xcheck/8; // Block
   y1check=ycheck/8;
   xoff=(xcheck-(x1check*8)); // Offset
   yoff=(ycheck-(y1check*8));
   pos=(x1check*512*196)+(y1check*196)+(yoff*24)+(xoff*3)+4;
   fseek(mapfile, pos, SEEK_SET);
   fread(&map1, 3, 1, mapfile);
   if (map1.id!=2) 
   {
    if ( // Mountain walls
		((map1.id>=431)&&(map1.id<=432))||
		((map1.id>=467)&&(map1.id<=475))||
		((map1.id>=543)&&(map1.id<=560))||
		((map1.id>=1754)&&(map1.id<=1757))||
		((map1.id>=1787)&&(map1.id<=1789))||
		((map1.id>=1821)&&(map1.id<=1824))||
		((map1.id>=1851)&&(map1.id<=1854))||
		((map1.id>=1881)&&(map1.id<=1884))
	   )
	{
	 sysmessage(s, "There seems to be something in the way!");
	 return blocked;
	}
   }	 

 // Statics

//   x1check=xcheck/8; // Block
//   y1check=ycheck/8;
//   xoff=(xcheck-(x1check*8)); // Offset
//   yoff=(ycheck-(y1check*8));

/// Uses same blocks and offsets as above 
   pos=(x1check*512*12)+(y1check*12);
   fseek(sidxfile, pos, SEEK_SET);
   fread(&pos2, 4, 1, sidxfile);
   if (pos2!=-1)
   {
    fread(&length, 4, 1, sidxfile);
    length=length/7;
    fseek(statfile, pos2, SEEK_SET);
    for (i=0;i<length;i++)
    {
     fread(&stat, 7, 1, statfile);
	 seektile(stat.itemid, &tile);
     if ((stat.xoff==xoff)&&
		 (stat.yoff==yoff)&&
		 (zcheck>=stat.zoff)&&
		 (zcheck<=(stat.zoff+tile.height)))
     {	  
      itemids[checkitemcount]=stat.itemid;
	  checkitemcount++;	  
     }// if
    }// for
   }// if

   // Items
   for (i=0;i<loscachecount;i++)
   {
	dyncount=loscache[i];
	if (items[dyncount].id1<0x40)
    { // Dynamic items
	 seektile((items[dyncount].id1*256)+items[dyncount].id2, &tile);
	 if ((items[dyncount].x==xcheck)&&
		 (items[dyncount].y==ycheck)&&
		 (zcheck>=items[dyncount].z)&&
		 (zcheck<=(items[dyncount].z+tile.height))&&
		 (items[dyncount].visible==0))
	 {	 
	  itemids[checkitemcount]=((items[dyncount].id1 * 256) + items[dyncount].id2);
	  checkitemcount++;
	 }
	}
     else
	 {// Multi's
	  if ((abs(x1-x2)<=BUILDRANGE)&&(abs(y1-y2)<=BUILDRANGE))
      {
       seekmulti((items[dyncount].id1*256+items[dyncount].id2)-0x4000, &mfile, &length);
       length=length/sizeof(st_multi);
       if (length == -1)
	   {
        printf("LoS - Bad length in multi file. Avoiding stall.\n");
        length = 0;
	   }
       for (j=0;j<length;j++)
	   {
        fread(&multi, sizeof(st_multi), 1, mfile);
        if ((multi.visible)&&
			(items[dyncount].x+multi.x == xcheck)&&
			(items[dyncount].y+multi.y == ycheck))			
	    {
         pos=ftell(mfile);
         seektile(multi.tile, &tile);
         fseek(mfile, pos, SEEK_SET);
         if ((zcheck>=items[dyncount].z+multi.z)&&
			 (zcheck<=(items[dyncount].z+multi.z + tile.height)))
		 {
          itemids[checkitemcount]=multi.tile;
	      checkitemcount++;
		 }
	    }
	   }
	  }
	 }// end else
   } // for
   if ((xcheck==x2)&&(ycheck==y2)&&(zcheck==z2)) checkcount=a_divide+1;
   prexcheck=xcheck;
   preycheck=ycheck;
   prezcheck=zcheck;
  } // if statment
  if (xcheck!=x2) aplus=aplus+a1_incrament;
  if (ycheck!=y2) bplus=bplus+b1_incrament;
  if (zcheck!=z2) b2plus=b2plus+b2_incrament;
 } // for loop

 for (i=0;i<checkitemcount;i++)
 {
  for (j=0;j<checkthistotal;j++)
  {
   switch(checkthis[j])
   {
    case 1 : // Trees, Shrubs, bushes
             if ((itemids[i]==3240)||(itemids[i]==3242)||((itemids[i]>=3215)&&(itemids[i]<=3218))||
		         ((itemids[i]>=3272)&&(itemids[i]<=3280))||(itemids[i]==3283)||(itemids[i]==3286)||
		         (itemids[i]==3288)||(itemids[i]==3290)||(itemids[i]==3293)||(itemids[i]==3296)||
				 (itemids[i]==3299)||(itemids[i]==3302)||(itemids[i]==3305)||(itemids[i]==3306)||
				 (itemids[i]==3320)||(itemids[i]==3323)||(itemids[i]==3326)||(itemids[i]==3329)||
				 (itemids[i]==3381)||(itemids[i]==3383)||(itemids[i]==3384)||(itemids[i]==3394)||
				 (itemids[i]==3395)||((itemids[i]>=3416)&&(itemids[i]<=3418))||
				 (itemids[i]==3440)||(itemids[i]==3461)||(itemids[i]==3476)||(itemids[i]==3480)||
				 (itemids[i]==3484)||(itemids[i]==3488)||(itemids[i]==3492)||(itemids[i]==3496)||
				 (itemids[i]==3512)||(itemids[i]==3513)||((itemids[i]>=4792)&&(itemids[i]<=4795)))
			 {
//			  sprintf(temp, "You can't see the forest for the trees!");
//			  sysmessage(s, temp);
			  return blocked;
			 }
			 break;
    case 2 : // Walls, Chimneys, ovens, not fences
	         if (((itemids[i]>=6)&&(itemids[i]<=748))||((itemids[i]>=761)&&(itemids[i]<=881))||
	             ((itemids[i]>=895)&&(itemids[i]<=1006))||((itemids[i]>=1057)&&(itemids[i]<=1061))||
				 (itemids[i]==1072)||(itemids[i]==1073)||((itemids[i]>=1080)&&(itemids[i]<=1166))||
				 ((itemids[i]>=2347)&&(itemids[i]<=2412))||((itemids[i]>=16114)&&(itemids[i]<=16134))||
				 ((itemids[i]>=8538)&&(itemids[i]<=8553))||((itemids[i]>=9535)&&(itemids[i]<=9555))||
				 (itemids[i]==12583))
			 {
//			  sprintf(temp, "There seems to be some sort of wall in the way!");
//			  sysmessage(s, temp);
              return blocked;
			 }
             break;
    case 4 : // Doors, not gates
	         if (((itemids[i]>=1653)&&(itemids[i]<=1782))||((itemids[i]>=8173)&&(itemids[i]<=8188)))
			 {
//			  sprintf(temp, "Only ghosts do things through doors!");
//			  sysmessage(s, temp);
			  return blocked;
			 }
             break;
    case 8 : // Roofing Slanted
             if (((itemids[i]>=1414)&&(itemids[i]<=1578))||((itemids[i]>=1587)&&(itemids[i]<=1590))||
	             ((itemids[i]>=1608)&&(itemids[i]<=1617))||((itemids[i]>=1630)&&(itemids[i]<=1652))||
		         ((itemids[i]>=1789)&&(itemids[i]<=1792)))
			 {
//			  sprintf(temp, "The roof is too steep!");
//			  sysmessage(s, temp);
			  return blocked;
			 }
             break;
    case 16 : // Floors & Flat Roofing (Attacking through floors Roofs)
			if (((itemids[i]>=1169)&&(itemids[i]<=1413))||((itemids[i]>=1508)&&(itemids[i]<=1514))||
				((itemids[i]>=1579)&&(itemids[i]<=1586))||((itemids[i]>=1591)&&(itemids[i]<=1598)))
			{
				if (z1==z2) // in case of char and target on same roof
				{
					return not_blocked;
				}
				else
				{
					//               sprintf(temp, "You would love to do that, but the is a floor in the way!");
					//               sysmessage(s, temp);
					return blocked;
				}
			}
			break;
    case 32 :  // Lava, water
		      if (((itemids[i]>=4846)&&(itemids[i]<=4941))||((itemids[i]>=6038)&&(itemids[i]<=6066))||
			      ((itemids[i]>=12934)&&(itemids[i]<=12977))||((itemids[i]>=13371)&&(itemids[i]<=13420))||
				  ((itemids[i]>=13422)&&(itemids[i]<=13638))||((itemids[i]>=13639)&&(itemids[i]<=13665)))
			  {
//			   sprintf(temp, "Yah, you wish!");
//			   sysmessage(s, temp);
			   return blocked;
			  }
              break;
   } // switch
  } //for
 } //for
 return not_blocked;
} //function

