// *******************************************************************
// trigger.cpp (Trigger processing module)
//
// The trigger is activated here.  When the users doubleclicks on a triggered
// item or a triggered NPC, this routine will load the trigger from the
// triggers.scp (for dynamic), ntrigrs.scp (for NPCs) file or wtrigrs.scp
// (static world objects) and process the tokens for the trigger.
// NOTE: By using this source you are agreeing to all the terms of the GNU
// agreement.  Any use of this code, sniplets of this code, concepts of
// this code or ideas derived from this code requires that any program(s)
// and source containing any of the above mentioned states of the code, must
// be released in its entirety.
//
// DO NOT MODIFY THIS CODE UNLESS you are sure you know what your doing.
// The trigger system is not designed for making tokens that do just one
// thing.  Remember, if it can't be used for multiple things, it shouldnt
// be here. Do not distribute your changes unless its either by consent of
// the author(Zadius) or if the change and/or addition is by popular
// demand and it has been thouroughly tested.
// 
// Zadius 11-4-98 (linkage@xmission.com)
// *******************************************************************


#include <errno.h>
#include "uox3.h"


//This routine processes both Static and Dynamic items
void triggerwitem(int ts, int ti, int ttype)
{
  char sect[512];
  char buff[512];
  char effect[29];
  char fmsg[512];
	char cmsg[512]; //completed trigger message
  char clr1;
  char clr2;
  int serial,serhash=-1,ci;
  unsigned int i,uiTempi, uiCompleted=0;
  int tl;
  int p,j;
  int c;
  int r;
  int itemnum=-1;
  int needitem=-1;
  int npcnum=-1;
  int trig=0;
  int x1=0,y1=0,x2=0,y2=0,z2=0,dx,dy;
  long int pos;

  *fmsg='\0'; // was sprintf(fmsg,"");

  if (ttype==1)
  {
    if (chars[currchar[ts]].targtrig)
      trig=chars[currchar[ts]].targtrig;
    else
      trig=items[ti].trigger;
    chars[currchar[ts]].targtrig=0;
    openscript("triggers.scp");
    sprintf(sect, "TRG %i", trig);
    if (!trigger_script.find(sect))
    {
      closescript();
      return;
    }
  }
	else
	{
    /*if ((buffer[ts][7]!=0)&&(buffer[ts][8]!=0)&&(buffer[ts][9]!=0)&&(buffer[ts][10]!=0))
    {
      return;
    }*/
    openscript("wtrigrs.scp");
    sprintf(buff,"x%x%x",buffer[ts][0x11],buffer[ts][0x12]);
    if (!wtrigger_script.isin(buff))
    {
      sprintf(sect,"You cant think of a way to use that.");
      sysmessage(ts,sect);
      closescript();
      return;
    }
  }
  do
  {
    read2();
    if (script1[0]!='}')
    {
			// Start Tauriel's new trigger Tokens
      if (!(strcmp("END_TRIGGER",script1)))  //End execution of a trigger
      {
				uiTempi=str2num(script2);
				if ((uiTempi && uiCompleted) || (!uiTempi && !uiCompleted))
        return;
      }
			// End Tauriel's new trigger token
      if (!(strcmp("RANGE",script1)))  //Player in in range
      {
				    x1=chars[currchar[ts]].x;
				    y1=chars[currchar[ts]].y;
				    if (ti>-1)
				    {
						    x2=items[ti].x;
						    y2=items[ti].y;
						    z2=items[ti].z;
				      p=currchar[ts];
          r=packitem(currchar[ts]);
          /*if (!((items[ti].cont1==items[r].ser1)&&(items[ti].cont2==items[r].ser2)&&
              (items[ti].cont3==items[r].ser3)&&(items[ti].cont4==items[r].ser4)))*/
          if (items[ti].contserial!=items[r].serial)
				      {
				        dx=abs(x1-x2);
				        dy=abs(y1-y2);
				        if ((dx>str2num(script2))||(dy>str2num(script2)))
				        {
				          sprintf(sect,"You are not close enough to use that.");
				          sysmessage(ts,sect);
						        closescript();
				          return;
				        }
				      }
        } else {
						    x2=(buffer[ts][11]*256)+buffer[ts][12];
						    y2=(buffer[ts][13]*256)+buffer[ts][14];
						    z2=(buffer[ts][15]*256)+buffer[ts][16];
		        dx=abs(x1-x2);
		        dy=abs(y1-y2);
		        if ((dx>str2num(script2))||(dy>str2num(script2)))
		        {
		          sprintf(sect,"You are not close enough to use that.");
		          sysmessage(ts,sect);
				        closescript();
		          return;
				      }
				    }
				  }
      if (!(strcmp("EMT",script1)))  //Player says something when trigger is activated
      {
        sprintf(sect,"%s",script2);
        for (i=0;i<now;i++)
        {
          if (inrange1p(currchar[ts], currchar[i])&&perm[i])
          {
            tl=44+strlen(sect)+1;
            talk[1]=tl/256;
            talk[2]=tl%256;
            talk[3]=chars[currchar[ts]].ser1;
            talk[4]=chars[currchar[ts]].ser2;
            talk[5]=chars[currchar[ts]].ser3;
            talk[6]=chars[currchar[ts]].ser4;
            talk[7]=chars[currchar[ts]].id1;
            talk[8]=chars[currchar[ts]].id2;
            talk[9]=0; // Type
            talk[10]=chars[currchar[ts]].saycolor1;
            talk[11]=chars[currchar[ts]].saycolor2;
            talk[12]=0;
            talk[13]=chars[currchar[ts]].fonttype;
            xsend(i, talk, 14, 0);
            xsend(i, chars[currchar[ts]].name, 30, 0);
            xsend(i, sect, strlen(sect)+1, 0);
          }
        }
      }
      if (!(strcmp("MSG",script1)))  //Display a message when trigger is activated
      {
        sprintf(sect,"%s",script2);
        sysmessage(ts,sect);
      }
			// Start Tauriel's new trigger Tokens
      if (!(strcmp("RANDOM_ITEM",script1)))  //%chance to IADD item
      {
        uiCompleted=0;
				cline = &script2[0];
        splitline();
				unsigned int uiItemNum=makenumber(0);
        unsigned int uiChance=makenumber(1);
        
				if (uiChance >= ((rand()%100)+1))
				{
					sprintf(script1,"IADD");
					sprintf(script2,"%i",uiItemNum);
					uiCompleted = 1;
				}
			}
      if (!(strcmp("RANDOM_NPC",script1)))  //%chance to NADD item
      {
        uiCompleted=0;
				cline = &script2[0];
        splitline();
				unsigned int uiItemNum=makenumber(0);
        unsigned int uiChance=makenumber(1);
        
				if (uiChance >= ((rand()%100)+1))
				{
					sprintf(script1,"NADD");
					sprintf(script2,"%i",uiItemNum);
					uiCompleted = 1;
				}
			}
			if (!(strcmp("CMSG",script1)))  //Set Token Completed message
      {
        if (uiCompleted)
				{
					sprintf(cmsg,"%s",script2);
					if (strlen(cmsg)) sysmessage(ts,cmsg);
				}
      }
      //End Tauriel's new trigger Tokens

			if (!(strcmp("FMSG",script1)))  //Set fail message
      {
        sprintf(fmsg,"%s",script2);
      }
      if (!(strcmp("SND",script1)))  //Play a sound when trigger is activated
      {
        cline = &script2[0];
        splitline();
        soundeffect(ts, hexnumber(0), hexnumber(1));
      }
      if (!(strcmp("REMOVE",script1)))  //Remove item after triggered
      {
        if (ti>-1)
        {
          if (items[ti].amount>1)
          {
            items[ti].amount--;
          } else {
            deleitem(ti);
          }
        }
      }
      if (!(strcmp("SETTRG",script1)))  //Set items trigger to new trigger
      {
        if (ti>-1) items[ti].trigger=str2num(script2);
      }
      if (!(strcmp("SETID",script1)))  //Set items id to new id
      {
        if (ti>-1)
        {
          cline = &script2[0];
          splitline();
          items[ti].id1=hexnumber(0);
          items[ti].id2=hexnumber(1);
          for (uiTempi=0;uiTempi<now;uiTempi++) if (perm[uiTempi]) senditem(uiTempi,ti);
          itemnum=ti;
        }
      }
      if (!(strcmp("COLOR",script1)))  //Set the color check
      {
        cline = &script2[0];
        splitline();
        clr1=hexnumber(0);
        clr2=hexnumber(1);
      }
      if (!(strcmp("SETEVID",script1)))  //Set envoked items id to new id
      {
        if (chars[currchar[ts]].envokeitem>-1)
        {
          cline = &script2[0];
          splitline();
          items[chars[currchar[ts]].envokeitem].id1=hexnumber(0);
          items[chars[currchar[ts]].envokeitem].id2=hexnumber(1);
          for (uiTempi=0;uiTempi<now;uiTempi++) if (perm[uiTempi]) senditem(uiTempi,chars[currchar[ts]].envokeitem);
          itemnum=chars[currchar[ts]].envokeitem;
        }
      }
      if (!(strcmp("IFOWNER",script1)))  //If item is owned by triggerer
      {
        if (ti>-1)
        {
          p=currchar[ts];
          if (items[ti].ownserial!=chars[p].serial)
          {
            sysmessage(ts,"You do not own that.");
            closescript();
            return;
          }
        }
      }
      if (!(strcmp("IFSKL",script1)))  //If skill meets a certain criteria
      {
        cline = &script2[0];
        splitline();
        p=currchar[ts];
        i=makenumber(0);
        j=makenumber(1);
        if (j>=0)
        {
          if (!(chars[p].baseskill[i]>=j))
          {
            if (strlen(fmsg)) sysmessage(ts,fmsg);
            closescript();
            return;
          }
        } else {
          if (!(chars[p].baseskill[i]<=abs(j)))
          {
            if (strlen(fmsg)) sysmessage(ts,fmsg);
            closescript();
            return;
          }
        }
      }
      if (!(strcmp("SETOWNER",script1)))  //Set ownership of item
      {
        if (ti>-1)
        {
          p=currchar[ts];
          if (items[ti].ownserial!=-1) removefromptr(&ownsp[items[ti].ownserial%256], ti);
          setserial(ti,p,3);
        }
      }
      if (!(strcmp("NEWOWNER",script1)))  //Set ownership of item
      {
        if (itemnum>-1)
        {
          p=currchar[ts];
          if (items[itemnum].ownserial!=-1) removefromptr(&ownsp[items[itemnum].ownserial%256], itemnum);
          setserial(itemnum,p,3);
        }
        if (npcnum>-1)
        {
          p=currchar[ts];
          if (chars[npcnum].ownserial!=-1) removefromptr(&cownsp[chars[npcnum].ownserial%256], npcnum);
          setserial(npcnum,p,5);
        }
      }
      if (!(strcmp("NADD",script1)))  //Add NPC at given location
      {
        if (ti>-1)
        {
          p=currchar[ts];
          if (items[ti].contserial==items[chars[p].packitem].serial)
          {
            triggerx=chars[p].x+1;
            triggery=chars[p].y+1;
            triggerz=chars[p].z;
          } else {
            triggerx=items[ti].x;
            triggery=items[ti].y;
            triggerz=items[ti].z;
          }
        }
				else
				{
						    x2=(buffer[ts][11]*256)+buffer[ts][12];
								y2=(buffer[ts][13]*256)+buffer[ts][14];
								z2=(buffer[ts][15]*256)+buffer[ts][16];
								triggerx=x2;
								triggery=y2;
								triggerz=z2;
        }
        pos=ftell(scpfile);
        closescript();
        addrespawnnpc(ti,str2num(script2),1);
        //addrespawnnpc(ts,str2num(script2),1);
        npcnum=triggerx;
        triggerx=0;
        if (ttype) openscript("triggers.scp");
        else openscript("wtrigrs.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");
      }
      if (!(strcmp("IDADD",script1)))  //Add item in front of player by ID
      {
				unsigned int low=0,high=0;
        cline = &script2[0];
        splitline();
        p=packitem(currchar[ts]);
        //r=(rand()%(makenumber(2)))+1;
				low=makenumber(2);
				high = (tnum==4) ? makenumber(3) : low;
				r=RandomNum(low,high);
        c=SpawnItem(ts,r,"#",1,hexnumber(0),hexnumber(1),0,0,1,1);
				itemnum=c;
      }
      if ((!(strcmp("NEWTYPE",script1)))||(!(strcmp("SETTYPE",script1))))  //Set active item type
      {
        if (itemnum>-1)
          items[itemnum].type=str2num(script2);
        else
        {
          if (ti>-1)
            items[ti].type=str2num(script2);
        }
      }
      if (!(strcmp("IADD",script1)))  //Add item in front of player
      {
        switch (chars[currchar[ts]].dir)
        {
          case 0: {
            triggerx=chars[currchar[ts]].x;
            triggery=chars[currchar[ts]].y-1;
            break;
          }
          case 1: {
            triggerx=chars[currchar[ts]].x+1;
            triggery=chars[currchar[ts]].y-1;
            break;
          }
          case 2: {
            triggerx=chars[currchar[ts]].x+1;
            triggery=chars[currchar[ts]].y;
            break;
          }
          case 3: {
            triggerx=chars[currchar[ts]].x+1;
            triggery=chars[currchar[ts]].y+1;
            break;
          }
          case 4: {
            triggerx=chars[currchar[ts]].x;
            triggery=chars[currchar[ts]].y+1;
            break;
          }
          case 5: {
            triggerx=chars[currchar[ts]].x-1;
            triggery=chars[currchar[ts]].y+1;
            break;
          }
          case 6: {
            triggerx=chars[currchar[ts]].x-1;
            triggery=chars[currchar[ts]].y;
            break;
          }
          case 7: {
            triggerx=chars[currchar[ts]].x-1;
            triggery=chars[currchar[ts]].y-1;
            break;
          }
          default: {
            triggerx=chars[currchar[ts]].x+1;
            triggery=chars[currchar[ts]].y+1;
            break;
          }
        }
        triggerz=chars[currchar[ts]].z;
        pos=ftell(scpfile);
        closescript();
        itemnum=addmenutarget(ts,1,str2num(script2));
        triggerx=0;
        if (ttype) openscript("triggers.scp");
        else openscript("wtrigrs.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");
      }
      if (!(strcmp("DISABLE",script1)))  //Disable Item for n seconds
      {
        if (ti>-1) items[ti].disabled=(getclock()+( CLOCKS_PER_SEC*str2num(script2) ));
      }
      if (!(strcmp("PUT",script1)))  //Send player to X Y Z when triggered
      {
        cline = &script2[0];
        splitline();

        chars[currchar[ts]].x=makenumber(0);
        chars[currchar[ts]].y=makenumber(1);
        chars[currchar[ts]].z=makenumber(2);
        teleport(currchar[ts]);
      }
      if (!(strcmp("ACT",script1)))  //Make player perform an action
      {
        cline = &script2[0];
        splitline();
        action(ts,hexnumber(0));
      }
      if (!(strcmp("HEA",script1)))  //Do math on players health
      {
        j=str2num(script2);
        if((j<0)&&(chars[currchar[ts]].hp<abs(j))&&(!(chars[currchar[ts]].priv&4)))
        {
          deathstuff(currchar[ts]);
          closescript();
          return;
        }
        chars[currchar[ts]].hp += j;
        if (chars[currchar[ts]].hp>chars[currchar[ts]].st) chars[currchar[ts]].hp=chars[currchar[ts]].st;
        updatestats(currchar[ts],0);
      }
      if (!(strcmp("MAN",script1)))  //Do math on players mana
      {
        j=str2num(script2);
        if((j<0)&&(chars[currchar[ts]].mn<abs(j)))
        {
          sysmessage(ts,"Your mind is too tired to do that.");
          closescript();
          return;
        }
        chars[currchar[ts]].mn += j;
        if (chars[currchar[ts]].mn>chars[currchar[ts]].in) chars[currchar[ts]].mn=chars[currchar[ts]].in;
        updatestats(currchar[ts],1);
      }
      if (!(strcmp("STAM",script1)))  //Do math on players stamina
      {
        j=str2num(script2);
        if((j<0)&&(chars[currchar[ts]].stm<abs(j)))
        {
          sysmessage(ts,"You are too tired to do that.");
          closescript();
          return;
        }
        chars[currchar[ts]].stm += j;
        if (chars[currchar[ts]].stm>chars[currchar[ts]].dx) chars[currchar[ts]].stm=chars[currchar[ts]].dx;
        updatestats(currchar[ts],2);
      }
      if (!(strcmp("STR",script1)))  //Do math on players strength
      {
        j=str2num(script2);
        if(j<0)
        {
          sysmessage(ts,"You lost strength!");
        } else {
          sysmessage(ts,"You are getting stronger!");
        }
        chars[currchar[ts]].st += j;
        if (chars[currchar[ts]].st<1) chars[currchar[ts]].st=1;
      }
      if (!(strcmp("INT",script1)))  //Do math on players intelligence
      {
        j=str2num(script2);
        if(j<0)
        {
          sysmessage(ts,"Your mind is growing weaker!");
        } else {
          sysmessage(ts,"Your mind is getting stronger!");
        }
        chars[currchar[ts]].in += j;
        if (chars[currchar[ts]].in<1) chars[currchar[ts]].in=1;
      }
      if (!(strcmp("DEX",script1)))  //Do math on players dexterity
      {
        j=str2num(script2);
        if(j<0)
        {
          sysmessage(ts,"You are getting clumsier!");
        } else {
          sysmessage(ts,"You are getting more agile!");
        }
        chars[currchar[ts]].dx += j;
        if (chars[currchar[ts]].dx<1) chars[currchar[ts]].dx=1;
      }
      if (!(strcmp("CSKL",script1)))  //Make a check on the players skill
      {
        i=(rand()%1000)+1;
				//Taur 69.02 added to get some chance of
				// skill gain on failure
				unsigned int skill=str2num(script2);
				unsigned int baseskill=chars[currchar[ts]].baseskill[skill];
        if (i > baseskill)
        {
          advanceskill(currchar[ts],skill,0);
					updateSkillLevel(currchar[ts], skill);
					updateskill(ts, skill);
/*					unsigned int skillpercent= (baseskill<250) ? 50 : (baseskill<500) ? 25 : (baseskill <750) ? 10 : 5;
          if (strlen(fmsg)) sysmessage(ts,fmsg);
					i=(rand()%100)+1;
					if (i < skillpercent) // 50% on fail to add a .1% to a skill
					{
						if (baseskill<1000)
						{
							chars[currchar[ts]].baseskill[skill]+=1;
							if (chars[currchar[ts]].baseskill[skill]>1000) chars[currchar[ts]].baseskill[skill]=1000;
							updateSkillLevel(currchar[ts], skill);
							updateskill(ts, skill);
						}
					}*/
					sprintf(temp,"You fail in your attempt...");
					sysmessage(ts, temp);
					closescript();
					return;
				} //Taur end 69.02 change
      }
      if (!(strcmp("SKL",script1)))  //Do math on the players skill
      {
        cline = &script2[0];
        splitline();
        p=makenumber(0);
        j=makenumber(1);

        if (j)
        {
          if (chars[currchar[ts]].baseskill[p]<1000)
          {
            chars[currchar[ts]].baseskill[p]+=j;
            if (chars[currchar[ts]].baseskill[p]>1000) chars[currchar[ts]].baseskill[p]=1000;
						advancestats(currchar[ts], p);
						updateSkillLevel(currchar[ts], p);
						updateskill(ts, p);
          }
        } else {
          advanceskill(currchar[ts],p,1);
					updateSkillLevel(currchar[ts], p);
					updateskill(ts, p);
        }
      }
      if (!(strcmp("REQ",script1)))  //Check if envoked by certain item.
      {
        sprintf(sect,"x%x%x",chars[currchar[ts]].envokeid1,chars[currchar[ts]].envokeid2);
        if (!strstr(script2,sect))
        {
          sysmessage(ts,"That didn't seem to work.");
          closescript();
          return;
        }
      }
      if (!(strcmp("NEED",script1)))  //The item here is required and will be removed
      {
        p=packitem(currchar[ts]);
        serial=items[p].serial;
        serhash=serial%256;
        for (ci=0;ci<contsp[serhash].max;ci++)
        {
					int i;
          i=contsp[serhash].pointer[ci];
          if (i!=-1)
          {
            sprintf(sect,"x%x%x",items[i].id1,items[i].id2);
            if (strstr(script2,sect))
            {
              needitem=i;
              break;
            }
          }
        }

        /*for (i=0;i<itemcount;i++)
        {
          if ((items[i].cont1==items[p].ser1)&&(items[i].cont2==items[p].ser2)&&
              (items[i].cont3==items[p].ser3)&&(items[i].cont4==items[p].ser4))
          {
            sprintf(sect,"x%x%x",items[i].id1,items[i].id2);
            if (strstr(script2,sect))
            {
              needitem=i;
              break;
            }
          }
        } */
        if (needitem<0)
        {
          sysmessage(ts,"You don't have the neccessary supplies to do that.");
          closescript();
          return;
        }
      }
      if (!(strcmp("USEUP",script1)))  //The item here is required and will be removed
      {
        p=packitem(currchar[ts]);
        if (needitem<0)
        {
          for (ci=0;ci<contsp[serhash].max;ci++)
          {
						int i;
            i=contsp[serhash].pointer[ci];
            if (i!=-1)
            {
              sprintf(sect,"x%x%x",items[i].id1,items[i].id2);
              if (strstr(script2,sect))
              {
                needitem=i;
                break;
              }
            }
          }
          /*for (i=0;i<itemcount;i++)
          {
            if ((items[i].cont1==items[p].ser1)&&(items[i].cont2==items[p].ser2)&&
                (items[i].cont3==items[p].ser3)&&(items[i].cont4==items[p].ser4))
            {
              sprintf(sect,"x%x%x",items[i].id1,items[i].id2);
              if (strstr(script2,sect))
              {
                needitem=i;
                break;
              }
            }
          }*/
        }
        if (needitem<0)
        {
          sysmessage(ts,"It appears as though you have insufficient supplies to make that with.");
          closescript();
          return;
        } else {
          if (items[needitem].amount>1)
            items[needitem].amount--;
          else
            deleitem(needitem);
        }
      }
      if (!(strcmp("MAKE",script1)))  //Give user the make menu
      {
        //itemmenu(ts,str2num(script2));
        cline = &script2[0];
        splitline();
        itemmake[ts].materialid1=hexnumber(2);
        itemmake[ts].materialid2=hexnumber(3);
			     itemmake[ts].has=getamount(currchar[ts], itemmake[ts].materialid1, itemmake[ts].materialid2); 
			     itemmake[ts].has2=getamount(currchar[ts], itemmake[ts].materialid1b, itemmake[ts].materialid2b);
        pos=ftell(scpfile);
        closescript();
        makemenu(ts,makenumber(0),makenumber(1));
        if (ttype) openscript("triggers.scp");
        else openscript("wtrigrs.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");
      }
      if (!(strcmp("CALCUSES",script1)))  //Calculate an items uses
      {
        if (ti>-1)
        {
          if (items[ti].tuses)
          {
            items[ti].tuses+=str2num(script2);
            closescript();
            return;
          }
        }
      }
      if (!(strcmp("SETUSES",script1)))  //Set an items uses
      {
        if (ti>-1)
        {
          items[ti].tuses=str2num(script2);
        }
      }
      if (!(strcmp("RNDUSES",script1)))  //Randomly set an items uses
      {
        if (ti>-1)
        {
          if (!items[ti].tuses)
          {
            cline = &script2[0];
            splitline();
            items[ti].tuses=(rand()%(makenumber(1)))+makenumber(0);
          }
        }
      }
      if (!(strcmp("IDFX",script1)))  //Makes an effect at players by ID
      {
  			for (i=0;i<29;i++)
		 		{
				  effect[i]=0;
 				}
    		if (ti>-1)
        {
          j=packitem(currchar[ts]);
          p=currchar[ts];
          /*if ((items[ti].cont1==items[j].ser1)&&(items[ti].cont2==items[j].ser2)&&
              (items[ti].cont3==items[j].ser3)&&(items[ti].cont4==items[j].ser4))*/
          if (items[ti].contserial==items[j].serial)
          {
			      closescript();
			      return;
          }
          else
          {
            triggerx=items[ti].x;
            triggery=items[ti].y;
            triggerz=items[ti].z;
          }
         }
         else {
          triggerx=(buffer[ts][11]*256)+buffer[ts][12];
          triggery=(buffer[ts][13]*256)+buffer[ts][14];
          triggerz=(buffer[ts][15]*256)+buffer[ts][16];
        }
        cline = &script2[0];
        splitline();
							 effect[0]=0x70; // Effect message
							 effect[1]=0x00; // Moving effect
        effect[2]=chars[currchar[ts]].ser1;
        effect[3]=chars[currchar[ts]].ser2;
        effect[4]=chars[currchar[ts]].ser3;
        effect[5]=chars[currchar[ts]].ser4;
//        effect[6]=chars[currchar[ts]].ser1;
//        effect[7]=chars[currchar[ts]].ser2;
//        effect[8]=chars[currchar[ts]].ser3;
//        effect[9]=chars[currchar[ts]].ser4;
							 effect[10]=hexnumber(0);// Object id of the effect
							 effect[11]=hexnumber(1);
        effect[12]=chars[currchar[ts]].x/256;
        effect[13]=chars[currchar[ts]].x%256;
        effect[14]=chars[currchar[ts]].y/256;
        effect[15]=chars[currchar[ts]].y%256;
        effect[16]=chars[currchar[ts]].z;
							 effect[17]=triggerx/256;
							 effect[18]=triggerx%256;
							 effect[19]=triggery/256;
							 effect[20]=triggery%256;
							 effect[21]=triggerz;
        effect[22]=0x09;
        effect[23]=0x06; // 0 is really long.  1 is the shortest.
        effect[24]=0; // This value is unknown
        effect[25]=0; // This value is unknown
							 effect[26]=0; // This value is unknown
        effect[27]=0x01; // This value is used for moving effects that explode on impact.
							 for (uiTempi=0;uiTempi<now;uiTempi++)
							 {
							  if ((inrange1p(currchar[uiTempi],ts))&&(inrange1p(currchar[uiTempi],ts))&&(perm[uiTempi]))
							  {
							   xsend(uiTempi, effect, 28, 0);
							  }
							 }

      }
      if (!(strcmp("RAND",script1)))  //Does a random check
      {
        cline = &script2[0];
        splitline();
        p=(rand()%(makenumber(0)))+1;
        if (p>makenumber(1))
        {
          if (strlen(fmsg)) sysmessage(ts,fmsg);
          closescript();
          return;
        }
      }
      if (!(strcmp("TARG",script1)))  //Give a targeter with trigger number
      {
        target(ts,0,1,0,204,"Select a target");
        chars[currchar[ts]].targtrig=str2num(script2);
      }
      if ((!(strcmp("NEWNAME",script1))))  //Give the new item/npc a name
      {
        if (itemnum>-1)
        {
          sprintf(items[itemnum].name,script2);
        }
        if (npcnum>-1)
        {
          sprintf(chars[npcnum].name,script2);
        }
      }
      if (!(strcmp("NEWTRIG",script1)))  //Give the new item/npc a dynamic trigger number
      {
        if (itemnum>-1)
        {
          items[itemnum].trigger=str2num(script2);
        }
        if (npcnum>-1)
        {
          chars[npcnum].trigger=str2num(script2);
        }
      }
      if (!(strcmp("NEWWORD",script1)))  //Give the new npc a trigger word
      {
        if (npcnum>-1)
        {
          sprintf(chars[npcnum].trigword,script2);
        }
      }
      if (!(strcmp("MISC",script1)))  //Perform a miscellaneous function
      {
        if (!(strcmp("bank",strlwr(script2)))) openbank(ts,currchar[ts]);
      }
      // End World Triggers
    }
  }
  while (script1[0]!='}');
  closescript();
}
//**************************************************************************
//This routine processes tokens for the NPC triggers.
void triggernpc(int ts,int ti)
{
  char sect[512];
  char effect[29];
  unsigned int j;
  int p;
  int c;
  unsigned int i;
  int itemnum=-1;
  int npcnum=-1;
  int needitem=-1;
  long int pos;
  char fmsg[512];

  *fmsg='\0'; // was sprintf(fmsg,"");

  openscript("ntrigrs.scp");
  sprintf(sect, "TRG %i", chars[ti].trigger);
  if (!ntrigger_script.find(sect))
  {
    closescript();
    return;
  }
  do
  {
    read2();
    if (script1[0]!='}')
    {
      if (!(strcmp("EMT",script1)))  //Player says something when trigger is activated
      {
        sprintf(sect,"%s",script2);
        npctalkall(ti,sect);
      }
      if (!(strcmp("MSG",script1)))  //Display a message when trigger is activated
      {
        if (!(chars[ts].npc))
        {
          sprintf(sect,"%s",script2);
          sysmessage(ts,sect);
        }
      }
      if (!(strcmp("FMSG",script1)))  //Set fail message
      {
        sprintf(fmsg,"%s",script2);
      }
      if (!(strcmp("SND",script1)))  //Play a sound when trigger is activated
      {
        cline = &script2[0];
        splitline();
        soundeffect2(ti, hexnumber(0), hexnumber(1));
      }
      if (!(strcmp("SETTRG",script1)))  //Set npcs trigger to new trigger
      {
        chars[ti].trigger=str2num(script2);
      }
      if (!(strcmp("SETID",script1)))  //Set items id to new id
      {
        cline = &script2[0];
        splitline();
        chars[ti].id1=hexnumber(0);
        chars[ti].id2=hexnumber(1);
        chars[ti].xid1=hexnumber(0);
        chars[ti].xid2=hexnumber(1);
        for (j=0;j<now;j++) if (perm[j]) updatechar(ti);
      }
      if (!(strcmp("NADD",script1)))  //Add NPC at given location
      {
        p=currchar[ts];
        triggerx=chars[p].x+1;
        triggery=chars[p].y+1;
        triggerz=chars[p].z;
        pos=ftell(scpfile);
        closescript();
        addrespawnnpc(ti,str2num(script2),1);
        npcnum=triggerx;
        triggerx=0;
        openscript("ntrigrs.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");

      }
      if (!(strcmp("IDADD",script1)))  //Add item in player pack by ID
      {
        cline = &script2[0];
        splitline();
				//c=memitemfree();
        p=packitem(currchar[ts]);
        c=SpawnItem(ts,1,"#",1,hexnumber(0),hexnumber(1),0,0,1,1);
/*				for(i=0;i<itemcount;i++)
				{
					if((items[i].id1==hexnumber(0)&&
							items[i].id2==hexnumber(1)))
					{
						if ((items[i].cont1==items[p].ser1)&&
								(items[i].cont2==items[p].ser2)&&
								(items[i].cont3==items[p].ser3)&&
								(items[i].cont4==items[p].ser4))
						{
							items[i].amount=items[i].amount+1;
							inpack = 1;
							for(j=0;j<now;j++) 
								if(perm[j])
										senditem(j,i); 
								if(c==itemcount)
										itemcount++;
								itemcount2++;
								break;           // was doing both the create an add items not just one or the other.
							}
						}
					}
							
								if(!inpack)
								{
									inititem(c);
									i=c;
									//if(cName!=NULL) sprintf(items[c].name,cName);
									items[c].ser1=itemcount2/16777216;
									items[c].ser2=itemcount2/65536;
									items[c].ser3=itemcount2/256;
									items[c].ser4=itemcount2;
									items[c].id1=hexnumber(0);
									items[c].id2=hexnumber(1);
									items[c].cont1=items[p].ser1;
									items[c].cont2=items[p].ser2;
									items[c].cont3=items[p].ser3;
									items[c].cont4=items[p].ser4;
									//items[c].color1=cColorId1;
									//items[c].color2=cColorId2;
									//if(cColorId1!='\0') items[c].color1=cColorId1;
									//if(cColorId1!='\0') items[c].color2=cColorId2;
									items[c].x=(50+rand()%80);
									items[c].y=(50+rand()%80);
									items[c].z=9;
									items[c].amount=1;
									items[c].pileable=1;
									items[c].att=5;
									items[c].priv=items[c].priv|0x01;
									chars[currchar[ts]].making=c;
									for(j=0;j<now;j++) 
												if(perm[j])
													senditem(j,c); 
												if(c==itemcount)
													itemcount++;
									itemcount2++;
								}
        itemnum=c;
         //chars[currchar[ts]].weight=calcweight(currchar[ts]);
         //statwindow(ts,currchar[ts]);*/
      }
      if (!(strcmp("IADD",script1)))  //Add item in front of player
      {
        switch (chars[ts].dir)
        {
          case 0: {
            triggerx=chars[ts].x;
            triggery=chars[ts].y-1;
            break;
          }
          case 1: {
            triggerx=chars[ts].x+1;
            triggery=chars[ts].y-1;
            break;
          }
          case 2: {
            triggerx=chars[ts].x+1;
            triggery=chars[ts].y;
            break;
          }
          case 3: {
            triggerx=chars[ts].x+1;
            triggery=chars[ts].y+1;
            break;
          }
          case 4: {
            triggerx=chars[ts].x;
            triggery=chars[ts].y+1;
            break;
          }
          case 5: {
            triggerx=chars[ts].x-1;
            triggery=chars[ts].y+1;
            break;
          }
          case 6: {
            triggerx=chars[ts].x-1;
            triggery=chars[ts].y;
            break;
          }
          case 7: {
            triggerx=chars[ts].x-1;
            triggery=chars[ts].y-1;
            break;
          }
          default: {
            triggerx=chars[ts].x+1;
            triggery=chars[ts].y+1;
            break;
          }
        }
        triggerz=chars[ts].z;
        pos=ftell(scpfile);
        closescript();
        itemnum=addmenutarget(ts,1,str2num(script2));
        triggerx=0;
        openscript("ntrigrs.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");
      }
      if (!(strcmp("DISABLE",script1)))  //Disable NPC for n seconds
      {
        chars[ti].disabled=(getclock()+(CLOCKS_PER_SEC*str2num(script2)));
      }
      if (!(strcmp("PUT",script1)))  //Send player to X Y Z when triggered
      {
        cline = &script2[0];
        splitline();

        chars[ts].x=makenumber(0);
        chars[ts].y=makenumber(1);
        chars[ts].z=makenumber(2);
        teleport(ts);
      }
      if (!(strcmp("ACT",script1)))  //Make player perform an action
      {
        cline = &script2[0];
        splitline();
        action(ts,hexnumber(0));
      }
      if (!(strcmp("NPCACT",script1)))  //Make player perform an action
      {
        cline = &script2[0];
        splitline();
        npcaction(ti,hexnumber(0));
      }
      if (!(strcmp("HEA",script1)))  //Do math on players health
      {
        j=str2num(script2);
        if((j<0)&&(chars[currchar[ts]].hp<abs(j))&&(!(chars[currchar[ts]].priv&4)))
        {
          deathstuff(currchar[ts]);
          closescript();
          return;
        }
        chars[currchar[ts]].hp += j;
        if (chars[currchar[ts]].hp>chars[currchar[ts]].st) chars[currchar[ts]].hp=chars[currchar[ts]].st;
        updatestats(currchar[ts],0);
      }
      if (!(strcmp("MAN",script1)))  //Do math on players mana
      {
        j=str2num(script2);
        if((j<0)&&(chars[currchar[ts]].mn<abs(j)))
        {
          sysmessage(ts,"Your mind is too tired to do that.");
          closescript();
          return;
        }
        chars[currchar[ts]].mn += j;
        if (chars[currchar[ts]].mn>chars[currchar[ts]].in) chars[currchar[ts]].mn=chars[currchar[ts]].in;
        updatestats(currchar[ts],1);
      }
      if (!(strcmp("STAM",script1)))  //Do math on players stamina
      {
        j=str2num(script2);
        if((j<0)&&(chars[currchar[ts]].stm<abs(j)))
        {
          sysmessage(ts,"You are too tired to do that.");
          closescript();
          return;
        }
        chars[currchar[ts]].stm += j;
        if (chars[currchar[ts]].stm>chars[currchar[ts]].dx) chars[currchar[ts]].stm=chars[currchar[ts]].dx;
        updatestats(currchar[ts],2);
      }
      if (!(strcmp("STR",script1)))  //Do math on players strength
      {
        j=str2num(script2);
        if(j<0)
        {
          sysmessage(ts,"You lost strength!");
        } else {
          sysmessage(ts,"You are getting stronger!");
        }
        chars[currchar[ts]].st += j;
        if (chars[currchar[ts]].st<1) chars[currchar[ts]].st=1;
      }
      if (!(strcmp("INT",script1)))  //Do math on players intelligence
      {
        j=str2num(script2);
        if(j<0)
        {
          sysmessage(ts,"Your mind is growing weaker!");
        } else {
          sysmessage(ts,"Your mind is getting stronger!");
        }
        chars[currchar[ts]].in += j;
        if (chars[currchar[ts]].in<1) chars[currchar[ts]].in=1;
      }
      if (!(strcmp("DEX",script1)))  //Do math on players dexterity
      {
        j=str2num(script2);
        if(j<0)
        {
          sysmessage(ts,"You are getting clumsier!");
        } else {
          sysmessage(ts,"You are getting more agile!");
        }
        chars[currchar[ts]].dx += j;
        if (chars[currchar[ts]].dx<1) chars[currchar[ts]].dx=1;
      }
      if (!(strcmp("CSKL",script1)))  //Make a check on the players skill
      {
        i=(rand()%1000)+1;
        if (i>chars[currchar[ts]].baseskill[str2num(script2)])
        {
          if (strlen(fmsg)) sysmessage(ts,fmsg);
          closescript();
          return;
        }
      }
      if (!(strcmp("SKL",script1)))  //Do math on the players skill
      {
        cline = &script2[0];
        splitline();
        p=makenumber(0);
        j=makenumber(1);

        if (j)
        {
          if (chars[currchar[ts]].baseskill[p]<1000)
          {
            chars[currchar[ts]].baseskill[p]+=j;
            if (chars[currchar[ts]].baseskill[p]>1000) chars[currchar[ts]].baseskill[p]=1000;
          }
        } else {
          advanceskill(currchar[ts],p,1);
        }
      }
      if (!(strcmp("IFOWNER",script1)))  //If character is owned by triggerer
      {
        if (ti>-1)
        {
          p=currchar[ts];
/*          if (!((chars[ti].own1==chars[p].ser1)&&(chars[ti].own2==chars[p].ser2)&&
              (chars[ti].own3==chars[p].ser3)&&(chars[ti].own4==chars[p].ser4)))*/
          if (chars[ti].ownserial!=chars[p].serial)
          {
            sysmessage(ts,"You do not own this creature.");
            closescript();
            return;
          }
        }
      }
      if (!(strcmp("SETOWNER",script1)))  //Set ownership of NPC
      {
        if (ti>-1)
        {
          p=currchar[ts];
          if (chars[ti].ownserial!=-1)
            removefromptr(&cownsp[chars[ti].ownserial%256], ti);
          setserial(ti,p,5);
          /*chars[ti].own1=chars[p].ser1;
          chars[ti].own2=chars[p].ser2;
          chars[ti].own3=chars[p].ser3;
          chars[ti].own4=chars[p].ser4;*/
        }
      }
      if (!(strcmp("NEWOWNER",script1)))  //Set ownership of NPC
      {
        if (itemnum>-1)
        {
          p=currchar[ts];
          if (items[itemnum].ownserial!=-1)
            removefromptr(&ownsp[items[itemnum].ownserial%256], itemnum);
          setserial(itemnum,p,3);
          /*items[itemnum].owner1=chars[p].ser1;
          items[itemnum].owner2=chars[p].ser2;
          items[itemnum].owner3=chars[p].ser3;
          items[itemnum].owner4=chars[p].ser4;*/
        }
        if (npcnum>-1)
        {
          p=currchar[ts];
          if (chars[npcnum].ownserial!=-1)
            removefromptr(&cownsp[chars[npcnum].ownserial%256], npcnum);
          setserial(npcnum,p,5);
          /*chars[npcnum].own1=chars[p].ser1;
          chars[npcnum].own2=chars[p].ser2;
          chars[npcnum].own3=chars[p].ser3;
          chars[npcnum].own4=chars[p].ser4;*/
        }
      }
      if (!(strcmp("NEED",script1)))  //The item here is required and will be removed
      {
        p=packitem(currchar[ts]);
        for (i=0;i<itemcount;i++)
        {
          /*if ((items[i].cont1==items[p].ser1)&&(items[i].cont2==items[p].ser2)&&
              (items[i].cont3==items[p].ser3)&&(items[i].cont4==items[p].ser4))*/
          if (items[i].contserial==items[p].serial)
          {
            sprintf(sect,"x%x%x",items[i].id1,items[i].id2);
            if (strstr(script2,sect))
            {
              needitem=i;
              break;
            }
          }
        }
        if (needitem<0)
        {
          sysmessage(ts,"You don't have the neccessary supplies to do that.");
          closescript();
          return;
        }
      }
      if (!(strcmp("USEUP",script1)))  //The item here is required and will be removed
      {
        p=packitem(currchar[ts]);
        if (needitem<0)
        {
          for (i=0;i<itemcount;i++)
          {
            if ((items[i].cont1==items[p].ser1)&&(items[i].cont2==items[p].ser2)&&
                (items[i].cont3==items[p].ser3)&&(items[i].cont4==items[p].ser4))
            {
              sprintf(sect,"x%x%x",items[i].id1,items[i].id2);
              if (strstr(script2,sect))
              {
                needitem=i;
                break;
              }
            }
          }
        }
        if (needitem<0)
        {
          sysmessage(ts,"It appears as though you have insufficient supplies to make that with.");
          closescript();
          return;
        } else {
          if (items[needitem].amount>1)
            items[needitem].amount--;
          else
            deleitem(needitem);
        }
      }
      if (!(strcmp("MAKE",script1)))  //Give user the make menu
      {
        cline = &script2[0];
        splitline();
        itemmake[ts].materialid1=hexnumber(2);
        itemmake[ts].materialid2=hexnumber(3);
			     itemmake[ts].has=getamount(currchar[ts], itemmake[ts].materialid1, itemmake[ts].materialid2); 
			     itemmake[ts].has2=getamount(currchar[ts], itemmake[ts].materialid1b, itemmake[ts].materialid2b);
        pos=ftell(scpfile);
        closescript();
        makemenu(ts,makenumber(0),makenumber(1));
        openscript("ntrigrs.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");
      }
      if ((!(strcmp("NEWTYPE",script1)))||(!(strcmp("SETTYPE",script1))))  //Set active item type
      {
        if (itemnum>-1)
          items[itemnum].type=str2num(script2);
      }
      if (!(strcmp("RAND",script1)))  //Does a random check
      {
        cline = &script2[0];
        splitline();
        p=(rand()%(makenumber(0)))+1;
        if (p>makenumber(1))
        {
          if (strlen(fmsg)) sysmessage(ts,fmsg);
          closescript();
          return;
        }
      }
      if (!(strcmp("SETWORD",script1)))  //Sets the trigger word of an NPC
      {
        sprintf(chars[ti].trigword,"%s",script2);
      }
      if (!(strcmp("IDFX",script1)))  //Makes an effect at players by ID
      {
  			   for (i=0;i<29;i++)
		 					{
								  effect[i]=0;
 							}
        cline = &script2[0];
        splitline();
							 effect[0]=0x70; // Effect message
							 effect[1]=0x00; // Moving effect
        effect[2]=chars[ti].ser1;
        effect[3]=chars[ti].ser2;
        effect[4]=chars[ti].ser3;
        effect[5]=chars[ti].ser4;
        effect[6]=chars[currchar[ts]].ser1;
        effect[7]=chars[currchar[ts]].ser2;
        effect[8]=chars[currchar[ts]].ser3;
        effect[9]=chars[currchar[ts]].ser4;
							 effect[10]=hexnumber(0);// Object id of the effect
							 effect[11]=hexnumber(1);
        effect[12]=chars[ti].x/256;
        effect[13]=chars[ti].x%256;
        effect[14]=chars[ti].y/256;
        effect[15]=chars[ti].y%256;
        effect[16]=chars[ti].z;
        effect[17]=chars[currchar[ts]].x/256;
        effect[18]=chars[currchar[ts]].x%256;
        effect[19]=chars[currchar[ts]].y/256;
        effect[20]=chars[currchar[ts]].y%256;
        effect[21]=chars[currchar[ts]].z;
        effect[22]=0x09;
        effect[23]=0x06; // 0 is really long.  1 is the shortest.
        effect[24]=0; // This value is unknown
        effect[25]=0; // This value is unknown
							 effect[26]=0; // This value is unknown
        effect[27]=0x00; // This value is used for moving effects that explode on impact.
							 for (j=0;j<now;j++)
							 {
							  if ((inrange1p(currchar[j],ts))&&(inrange1p(currchar[j],ts))&&(perm[j]))
							  {
							   xsend(j, effect, 28, 0);
							  }
							 }

      }
      if (!(strcmp("NEWNAME",script1)))  //Give the new item/npc a name
      {
        if (itemnum>-1)
        {
          sprintf(items[itemnum].name,script2);
        }
        if (npcnum>-1)
        {
          sprintf(chars[npcnum].name,script2);
        }
      }
      if (!(strcmp("NEWTRIG",script1)))  //Give the new item/npc a dynamic trigger number
      {
        if (itemnum>-1)
        {
          items[itemnum].trigger=str2num(script2);
        }
        if (npcnum>-1)
        {
          chars[npcnum].trigger=str2num(script2);
        }
      }
      if (!(strcmp("NEWWORD",script1)))  //Give the new npc a triggerword
      {
        if (npcnum>-1)
        {
          sprintf(chars[npcnum].trigword,script2);
        }
      }
      if (!(strcmp("MISC",script1)))  //Perform a miscellaneous function
      {
        if (!(strcmp("bank",strlwr(script2)))) openbank(ts,currchar[ts]);
      }
      // End NPC Triggers
    }
  }
  while (script1[0]!='}');
  closescript();
}
//**************************************************************************
int checkenvoke(char eid1, char eid2)
{
  FILE *envokefile;
  char buf[1024];

  if (!(envokefile = fopen("envoke.scp", "r"))) {
    fprintf(stderr, "Cannot open envoke.scp: %s", strerror(errno));
    exit(1);
  }
  while(fgets(buf, sizeof(buf), envokefile))
  {
    sprintf(temp,"x%x%x",eid1,eid2);
    if (strstr(buf, temp) > 0)
    {
      fclose(envokefile);
      return 1;
    }
  }
  fclose(envokefile);

  return 0;
}
