//
// -- Items.cpp  Item specific routines (add, delete change) in preperation for
//               going to a pointer based system
//
#include "uox3.h"
#include "debug.h"

#define DBGFILE "items.cpp"

// -- Find a free item slot, checking freeitemmem[] first
int memitemfree()
{
int k;
unsigned int i;
k=-1;

if (imemcheck!=-1)
   {
   k=freeitemmem[imemcheck];
   imemcheck--;
   }

if (k==-1)
 {
 k=itemcount;
 if (cmemover==1)
  {
  imemover=0;
  imemcheck++;
  for (i=0;i<itemcount;i++)
   {
   if (imemcheck==300)
    {
    imemover=1; 
    break;
    }
   if (items[i].free==1)
    {
    freeitemmem[imemcheck]=i;
    imemcheck++;
    }
   }
  }
 }
return k;
}

// -- Initialize an Item in the items[] array
void inititem(int i)
{
 sprintf(items[i].name,"#");
 items[i].ser1=0; // Item serial number
 items[i].ser2=0;
 items[i].ser3=0;
 items[i].ser4=0;
 items[i].serial=0;
 items[i].free=0;
 items[i].id1=0; // Item visuals as stored in the client
 items[i].id2=0;
 items[i].x=0;
 items[i].y=0;
 items[i].z=0;
 items[i].color1=0; // Hue
 items[i].color2=0;
 items[i].cont1=255; // Container that this item is found in
 items[i].cont2=255;
 items[i].cont3=255;
 items[i].cont4=255;
 items[i].contserial=-1;
 items[i].layer=0; // Layer if equipped on paperdoll
 items[i].type=0; // For things that do special things on doubleclicking
 items[i].more1=0; // For various stuff
 items[i].more2=0;
 items[i].more3=0;
 items[i].more4=0;
 items[i].moreb1=0;
 items[i].moreb2=0;
 items[i].moreb3=0;
 items[i].moreb4=0;
 items[i].morex=0;
 items[i].morey=0;
 items[i].morez=0;
 items[i].amount=1; // Amount of items in pile
 items[i].doordir=0; // Reserved for doors
 items[i].dooropen=0;
 items[i].pileable=0; // Can item be piled
 items[i].dye=0; // Reserved: Can item be dyed by dye kit
 items[i].corpse=0; // Is item a corpse
 items[i].att=0; // Item attack
 items[i].def=0; // Item defense
 items[i].magic=0; // 0=Default as stored in client, 1=Always movable, 2=Never movable, 3=Owner movable.
 items[i].gatetime=0;
 items[i].gatenumber=0;
 items[i].decaytime=0;
 items[i].owner1=0;
 items[i].owner2=0;
 items[i].owner3=0;
 items[i].owner4=0;
 items[i].ownserial=0;
 items[i].visible=0; // 0=Normally Visible, 1=Owner & GM Visible, 2=GM Visible
 items[i].spawn1=0;  // Spawned by...
 items[i].spawn2=0;
 items[i].spawn3=0;
 items[i].spawn4=0;
 items[i].spawnserial=0;
 items[i].dir=0;
 items[i].priv=0;
 items[i].value=1;
 items[i].restock=0;
 items[i].lodamage=0;
 items[i].hidamage=0;
 items[i].trigger=0;
 items[i].trigtype=0;
 items[i].disabled=0;
}

// -- delete an item (Actually just mark it is free)
void deleitem(int i)
{
  unsigned int j;
  if (items[i].free==0)
  {
    removeitem[1]=items[i].ser1;
    removeitem[2]=items[i].ser2;
    removeitem[3]=items[i].ser3;
    removeitem[4]=items[i].ser4;
    for (j=0;j<now;j++)
    {
      if (perm[j]) xsend(j, removeitem, 5, 0);
    }
    // - remove from pointer arrays
    removefromptr(&itemsp[items[i].serial%256], i);
    if (items[i].spawnserial!=-1) removefromptr(&spawnsp[items[i].spawnserial%256], i);
    if (items[i].ownserial!=-1) removefromptr(&ownsp[items[i].ownserial%256], i);
    if (items[i].contserial!=-1) removefromptr(&contsp[items[i].contserial%256], i);

    items[i].free=1;
    items[i].x=20+(xcounter++);
    items[i].y=50+(ycounter);
    items[i].z=9;
    items[i].cont1=255;
    items[i].cont2=255;
    items[i].cont3=255;
    items[i].cont4=255;
    items[i].contserial=-1;

    if (xcounter==40)
    {
      ycounter++;
      xcounter=0;
    }
    if (ycounter==80)
    {
      ycounter=0;
      xcounter=0;
    }
    if (imemcheck<500)
    {
      imemcheck++;
      freeitemmem[imemcheck]=i;
    }
    else imemover=1;
  }
}

int CreateScriptItem(int s, int itemnum, int nSpawned)
{
  char sect[512];
  int tmp, theitem;
	unsigned int c;
  long int pos;
  tile_st tile;
 
  openscript("items.scp");
  sprintf(sect, "ITEM %i", itemnum);
  if (!items_script.find(sect))
  {
    closescript();
    return -1;
  }

  c=memitemfree();

  inititem(c);
  theitem=c;
  items[c].ser1=itemcount2/16777216;
  items[c].ser2=itemcount2/65536;
  items[c].ser3=itemcount2/256;
  items[c].ser4=itemcount2;
  items[c].serial=itemcount2;
  setptr(&itemsp[itemcount2%256], c); //set item in pointer array
  items[c].id1=0x09;
  items[c].id2=0x15;
  items[c].wipe=0;
  if ((s!=-1) && (!nSpawned))
  {
    if (triggerx)
    {
      items[c].x=triggerx;
      items[c].y=triggery;
      items[c].z=triggerz;
    } else {
      items[c].x=(buffer[s][11]*256)+buffer[s][12];
      items[c].y=(buffer[s][13]*256)+buffer[s][14];
      items[c].z=buffer[s][16]+tileheight(buffer[s][17]*256+buffer[s][18]);
    }
  }

  do
  {
    read2();
    if (script1[0]!='}')
    {
      if (!(strcmp("NAME",script1))) sprintf(items[c].name, "%s", script2);
      if (!(strcmp("NAME2",script1))) sprintf(items[c].name2, "%s", script2);
      if (!(strcmp("ITEMLIST", script1)))
      {
        pos=ftell(scpfile);
        closescript();
        deleitem(c);
        CreateScriptRandomItem(s, script2);
        //addrandomitem(c,script2,s);
        openscript("items.scp");
        fseek(scpfile, pos, SEEK_SET);
        sprintf(script1, "DUMMY");
      }
      if (!(strcmp("ID",script1)))
      {
        tmp=hstr2num(script2);
        items[c].id1=tmp/256;
        items[c].id2=tmp%256;
      }
      if (!(strcmp("AMOUNT",script1))) items[c].amount=str2num(script2);
      if (!(strcmp("COLOR",script1)))
      {
        tmp=hstr2num(script2);
        items[c].color1=tmp/256;
        items[c].color2=tmp%256;
      }
      if (!(strcmp("TYPE",script1))) items[c].type=str2num(script2);
      if (!(strcmp("OFFSPELL",script1))) items[c].offspell=str2num(script2);
      if ((!(strcmp("DAMAGE",script1)))||(!(strcmp("ATT",script1)))) 
           items[c].att = getstatskillvalue(script2);
      if (!(strcmp("DEF",script1))) items[c].def=str2num(script2);
      if (!(strcmp("HP", script1))) items[c].hp=str2num(script2);
      if (!(strcmp("HP", script1))) items[c].maxhp=str2num(script2);
      if (!(strcmp("STR", script1))) items[c].st=str2num(script2);
      if (!(strcmp("STRADD", script1))) items[c].st2=str2num(script2);
      if (!(strcmp("DEX", script1))) items[c].dx=str2num(script2);
      if (!(strcmp("DEXADD", script1))) items[c].dx2=str2num(script2);
      if (!(strcmp("INT", script1))) items[c].in=str2num(script2);
      if (!(strcmp("INTADD", script1))) items[c].in2=str2num(script2);
      if (!(strcmp("LODAMAGE", script1))) items[c].lodamage=str2num(script2);
      if (!(strcmp("HIDAMAGE", script1))) items[c].hidamage=str2num(script2);
      if (!(strcmp("MOVABLE",script1))) items[c].magic=str2num(script2);
      if (!(strcmp("VISIBLE",script1))) items[c].visible=str2num(script2);
      if (!(strcmp("DYE",script1))) items[c].dye=str2num(script2);
      //Added by Krozy on 7-Sep-98
      //MORE & MORE2 for objects like books
      if (!(strcmp("MORE", script1)))
      {
        tmp=str2num(script2);
        items[c].more1=tmp/16777216;
        items[c].more2=tmp/65536;
        items[c].more3=tmp/256;
        items[c].more4=tmp%256;
      }
      //MORE2 may not be useful ?
      if (!(strcmp("MORE2", script1)))
      {
        tmp=str2num(script2);
        items[c].moreb1=tmp/16777216;
        items[c].moreb2=tmp/65536;
        items[c].moreb3=tmp/256;
        items[c].moreb4=tmp%256;
      }
      if (!(strcmp("MOREX",script1))) items[c].morex=str2num(script2);
      if (!(strcmp("MOREY",script1))) items[c].morey=str2num(script2);
      if (!(strcmp("MOREZ",script1))) items[c].morez=str2num(script2);
      if (!(strcmp("DIR",script1))) items[c].dir=str2num(script2);
      if (!(strcmp("SPD",script1))) items[c].spd=str2num(script2);
      if (!(strcmp("DECAY",script1))) items[c].priv=items[c].priv|0x01;
      if (!(strcmp("NEWBIE",script1))) items[c].priv=items[c].priv|0x02;
      if (!(strcmp("DISPELLABLE",script1))) items[c].priv=items[c].priv|0x04;
      if (!(strcmp("VALUE",script1))) items[c].value=str2num(script2);
      if (!(strcmp("RESTOCK",script1))) items[c].restock=str2num(script2);
      if (!(strcmp("LAYER",script1))&&(s==-1)) items[c].layer=str2num(script2);
      if (!(strcmp("TRIGGER",script1))) items[c].trigger=str2num(script2);
      if (!(strcmp("TRIGTYPE",script1))) items[c].trigtype=str2num(script2);
      if (!(strcmp("DISABLED",script1))) items[c].disabled=str2num(script2);
      if (!(strcmp("USES",script1))) items[c].tuses=str2num(script2);
    }
  } while (script1[0]!='}');

  closescript();
  seektile((items[c].id1*256)+items[c].id2, &tile);
  if (tile.flag2&0x08) items[c].pileable=1;
//  if (x) for (j=0;j<now;j++) if (perm[j]) senditem(j,c);
  if (c==itemcount) itemcount++;
  itemcount2++;
  return theitem;
}

void CreateScriptRandomItem(int s, char * sItemList)
{
  int i=0, Items[256], k;  //-- no more than 256 items in a single item list
  char sect[512];
  openscript("items.scp");
  sprintf(sect, "ITEMLIST %s", sItemList);
  if (!items_script.find(sect)) // -- Valid itemlist?
  {
    closescript();
    return;
  }

  do  // -- count items storing item #'s in Items[]
  {
    read1();
    if (script1[0]!='}')
    {
      Items[i]=str2num(script1);
      i++;
    }
  } while (script1[0]!='}');
  closescript();

  i=rand()%(i);
  k=Items[i];   // -- Get random Item #

  if (k!=0)
  {
    i=CreateScriptItem(s, k, 1);  // -- Create Item
  }
}

//added by genesis 11-4-98 modified by Myth 11/12/98 fix for dupe problem in pack.
//int SpawnItemBackpack(int s, int nAmount, char* cName, int nStackable,
//        char cItemId1, char cItemId2, char cColorId1, char cColorId2)

// Spawn item- Will create an item based on item ID1 and ID2. If nPack is 1 it will
//             put the item in nSocket's pack (auto-stacking). If nSend is 1 it will
//             senditem() to all online characters. If you want to make specific changes
//             to the item before sending the information pass nSend as 0.
int SpawnItem(int nSocket, int nAmount, char* cName, int nStackable,
        char cItemId1, char cItemId2, char cColorId1, char cColorId2, int nPack, int nSend)
{
//  int nItem;
	unsigned int i=0,m,c;
	int inpack = 0;
	int p=packitem(currchar[nSocket]); //new added by Myth 11/12/98

   //Auto-Stack code!
	if (nPack && nStackable==1)
  {
    for(i=0;i<itemcount;i++)
	  {
		  if ((items[i].id1==cItemId1) && (items[i].id2==cItemId2) &&
        ((cColorId1==0x00 && cColorId2==0x00) ||
         (items[i].color1==cColorId1 && items[i].color2==cColorId2)))
		  {
/*			  if ((items[i].cont1==items[p].ser1)&&
				    (items[i].cont2==items[p].ser2)&&
				    (items[i].cont3==items[p].ser3)&&
				    (items[i].cont4==items[p].ser4))*/
        if (items[i].contserial==items[p].serial)
			  {
				  items[i].amount=items[i].amount+nAmount;
				  inpack = 1;
				  for(m=0;m<now;m++) if(perm[m]) senditem(m,i); 
				  break;
			  }
		  }
	  }
  }

	if(!nPack || (nPack && !inpack))
	{
   	c=memitemfree();
    inititem(c);
		i=c;
		if(cName!=NULL) sprintf(items[c].name,cName);
		items[c].ser1=itemcount2/16777216;
		items[c].ser2=itemcount2/65536;
		items[c].ser3=itemcount2/256;
		items[c].ser4=itemcount2;
    items[c].serial=itemcount2;
    setptr(&itemsp[itemcount2%256], c); //set item in pointer array
		items[c].id1=cItemId1;
		items[c].id2=cItemId2;
    if (nPack) 
    {
      setserial(c, p, 1);
    }
		items[c].color1=cColorId1;
		items[c].color2=cColorId2;
    if (nPack)
    {
		  items[c].x=(50+rand()%80);
		  items[c].y=(50+rand()%80);
		  items[c].z=9;
    }
		items[c].amount=nAmount;
		items[c].pileable=nStackable;
		items[c].att=5;
		items[c].priv=items[c].priv|0x01;
		chars[currchar[nSocket]].making=c;
		if (nSend) for(m=0;m<now;m++) if(perm[m]) senditem(m,c); 
		if(c==itemcount) itemcount++;
		itemcount2++;
	}
	if (nSend) statwindow(nSocket,currchar[nSocket]);
	return i;
}

int SpawnItemBackpack2(int s, int nItem, int nDigging) // Added by Genesis 11-5-98
{
  char sect[512];
  int c, nTheItem,p;

  openscript("items.scp");
  sprintf(sect, "ITEM %i", nItem);
  if(!items_script.find(sect))
  {
    closescript();
    return -1;
  }

  p=packitem(currchar[s]);
  nTheItem=c=CreateScriptItem(s, nItem, 1);

  setserial(c, p, 1);
  items[c].x=(50+rand()%80);
  items[c].y=(50+rand()%80);
  items[c].z=9;
  if(nDigging) 
  {
    if (items[c].value!=0) items[c].value=1+(rand()%(items[c].value));
    if (items[c].hp!=0) items[c].hp=1+(rand()%(items[c].hp));
  }
	for(unsigned int m=0;m<now;m++) if(perm[m]) senditem(m,c); 

  statwindow(s,currchar[s]);
  return nTheItem;
}
