#ifndef DEBUG_H
#define DEBUG_H

#include <stdio.h>
#include <string.h>
#ifdef _WIN32
 #include <stdarg.h>
 #include <windows.h>
#else
 #include <stdarg.h>
 #include <time.h>
 //#include <varargs.h>
#endif
#if defined _WIN32 && (!__MINGW32__)
 //#include <crtdbg.h>
#endif
          

//---------------------------------------------------------------------------
//     Prototypes of functions
//---------------------------------------------------------------------------
void MessageReady(char *OutputMessage);
#ifdef WIN32
	void LogMessageF(unsigned char Type, long Line, char *File, char *Message, ...);
#else
	void LogMessageF(unsigned char Type, long Line, char *File, char *Message, ...);
#endif
//---------------------------------------------------------------------------
//     Translator macros for functions
//---------------------------------------------------------------------------
#ifdef WIN32
  #define LogMessage(Message)	LogMessageF('M', __LINE__, DBGFILE, Message)
#else
  #define LogMessage(Message)	LogMessageF('M', __LINE__, DBGFILE, Message)
#endif
#define LogWarning(WarningMessage)	LogMessageF('W', __LINE__, DBGFILE, WarningMessage)
#define LogError(ErrorMessage)	LogMessageF('E', __LINE__, DBGFILE, ErrorMessage)
#define LogCritical(CriticalMessage)	LogMessageF('C', __LINE__, DBGFILE, CriticalMessage)

#define _ ,

#endif