// File:    archive.cpp
// Header:  archive.h
//
// Author:  Dupois (dupois@hotmail.com)
// Created: August 29, 1998
// Details: Created to allow for UOX3.WSC file to be archived into any directory
//          by simply passing in three char arrays.  The first being the name of
//          the file you want to archive.  The second is the directory where the
//          file should be archived to.  Mainly for Win32 users though.
//
// Example: char ArchiveFile[] = "uox3.wsc";
//          char ArchiveDir[] = "C:\\Archive\\";          // Note: directory must exist
//          fileArchive(ArchiveFile, ArchiveDir);
//
// Any comments or constructive criticism would be much appreciated as this
// is one of my first C/C++ functions.  I'm sure that there are many areas where
// I could improve this piece of code so I would be glad to hear any suggestions.
//
// I put the function call after the gcollect() call in function savenewworld().
//
// Here is the portion of code in uox3.cpp where I inserted the variables and function call... 
//
//          void savenewworld (char x) // Save world state
//          {
//           int i, j;
//
//           char ArcFil[]="uox3.wsc";       // New code
//           char ArcDir[]="";               // New code
//          
//           tempeffectsoff();
//           gcollect();
//          #ifdef _WIN32                    // New code
//           fileArchive(ArcFil, ArcDir);    // New code
//          #endif                           // New code
//            ...
//
//
// Here are the prototypes and defines needed to compile.  Typically I just paste them
// into the uox.h header at the end:
//
//          #define MAXARCHID 14
//          void fileArchive(char *pFile2Archive, char *pArchiveDir);
//          void ArchiveID(char archiveid[MAXARCHID]);
//
#include "uox3.h"

void fileArchive(char *pFile2Archive, char *pArchiveDir)
{
	char ext[255] = "";
	char *pext = NULL;
	char destfile[255] = "";
	char *pdestfile = destfile;
	char timenow[MAXARCHID];

	int	ch = '.';
	int p=0;

// Determine the extension of the file and save the extension into array ext
	pext = (strchr(pFile2Archive, ch));
	if (pext != NULL)
	{
		while (pext[p] != '\0')
		{
			ext[p]=pext[p];
			p++;
		}
	}

// Create the destination file name
	strcpy(destfile, pArchiveDir);
	strcat(destfile, pFile2Archive);
	pdestfile=(strchr(destfile, ch));
	*pdestfile=0;
	strcat(destfile, "-");
	pdestfile = &destfile[strlen(destfile)];
	ArchiveID(timenow);
	strcat(destfile, timenow);
	strcat(destfile, ext);

// Rename/Move the pFile2Archive to destfile
	if( rename( pFile2Archive, destfile ) != 0 )
		printf( "UOX3: Err-Could not rename/move file.\nFile '%s' or directory '%s' may not exist.\n", pFile2Archive, pArchiveDir );
	else
		printf( "UOX3: '%s' renamed/moved to '%s'\n", pFile2Archive, destfile );

	return;
}

void ArchiveID(char archiveid[MAXARCHID])
{
	time_t mytime;
	tm *ptime;
	
	char temp[5] = "";
	char intdate[5] = "";
	
	time(&mytime);
	ptime = localtime(&mytime);

// Create the 4 digit year date
	_itoa((ptime->tm_year + 1900), intdate, 10);
	strcpy(archiveid, intdate);

// Create the 3 digit day of the year date
	strcpy(temp, "");
	if (ptime->tm_yday < 10)
		strcpy(temp, "0");
	if (ptime->tm_yday < 100)
		strcpy(temp, "00");
	_itoa(ptime->tm_yday, intdate, 10);
	strcat(temp, intdate);
	strcat(archiveid, temp); 


// Create the 2 digit hour of the day time
	strcpy(temp, "");
	if (ptime->tm_hour < 10)
		strcpy(temp, "0");
	_itoa(ptime->tm_hour, intdate, 10);
	strcat(temp, intdate);
	strcat(archiveid, temp); 

// Create the 2 digit minute of the day time
	strcpy(temp, "");
	if (ptime->tm_min < 10)
		strcpy(temp, "0");
	_itoa(ptime->tm_min, intdate, 10);
	strcat(temp, intdate);
	strcat(archiveid, temp); 

// Create the 2 digit sec of the day time
	strcpy(temp, "");
	if (ptime->tm_sec < 10)
		strcpy(temp, "0");
	_itoa(ptime->tm_sec, intdate, 10);
	strcat(temp, intdate);
	strcat(archiveid, temp); 

	return;
}
