/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin.remoteui.xml.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestHandler;
import org.gudy.azureus2.pluginsimpl.remote.RemoteMethodInvoker;
import org.gudy.azureus2.ui.webplugin.WebPlugin;
import org.gudy.azureus2.ui.webplugin.WebPluginAccessController;
import org.gudy.azureus2.ui.webplugin.remoteui.xml.server.XMLRequestProcessor2;

public class XMLHTTPServerPlugin
extends WebPlugin {
    public static final int DEFAULT_PORT = 6884;
    protected static Properties defaults = new Properties();
    protected RPRequestHandler request_handler;
    protected RPRequestAccessController access_controller;
    protected boolean serialise_debug = false;
    protected boolean deserialise_debug = false;
    protected LoggerChannel channel = null;
    protected boolean log_to_plugin = false;

    public XMLHTTPServerPlugin() {
        super(defaults);
    }

    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        super.initialize(_plugin_interface);
        BasicPluginConfigModel config = this.getConfigModel();
        LabelParameter debug_section_description = config.addLabelParameter2("xmlhttp.config.group.debug.description");
        final BooleanParameter deserialise_param = config.addBooleanParameter2("xmlhttp.config.option.debug.deserialisation", "xmlhttp.config.option.debug.deserialisation", false);
        final BooleanParameter method_lookup_param = config.addBooleanParameter2("xmlhttp.config.option.debug.method_lookup", "xmlhttp.config.option.debug.method_lookup", false);
        final BooleanParameter method_invoke_param = config.addBooleanParameter2("xmlhttp.config.option.debug.method_invocation", "xmlhttp.config.option.debug.method_invocation", false);
        final BooleanParameter serialise_param = config.addBooleanParameter2("xmlhttp.config.option.debug.serialisation", "xmlhttp.config.option.debug.serialisation", false);
        config.createGroup("xmlhttp.config.group.debug", new Parameter[]{debug_section_description, deserialise_param, method_lookup_param, method_invoke_param, serialise_param});
        LabelParameter log_section_description = config.addLabelParameter2("xmlhttp.config.group.logging.description");
        BooleanParameter log_to_plugin_param = config.addBooleanParameter2("xmlhttp.config.option.log_to_plugin", "xmlhttp.config.option.log_to_plugin", true);
        BooleanParameter log_to_console = config.addBooleanParameter2("xmlhttp.config.option.log_to_console", "xmlhttp.config.option.log_to_console", false);
        this.log_to_plugin = log_to_plugin_param.getValue();
        config.createGroup("xmlhttp.config.group.logging", new Parameter[]{log_section_description, log_to_plugin_param, log_to_console});
        ParameterListener pl = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                boolean new_value = ((BooleanParameter)param).getValue();
                if (param == method_lookup_param) {
                    RemoteMethodInvoker.setLogResolution(new_value);
                } else if (param == method_invoke_param) {
                    RemoteMethodInvoker.setLogInvocation(new_value);
                } else if (param == deserialise_param) {
                    XMLHTTPServerPlugin.this.deserialise_debug = new_value;
                } else if (param == serialise_param) {
                    XMLHTTPServerPlugin.this.serialise_debug = new_value;
                }
            }
        };
        deserialise_param.addListener(pl);
        serialise_param.addListener(pl);
        method_lookup_param.addListener(pl);
        method_invoke_param.addListener(pl);
        final BasicPluginViewModel view_model = this.getViewModel();
        this.channel = log_to_console.getValue() ? _plugin_interface.getLogger().getChannel("XML/HTTP") : _plugin_interface.getLogger().getNullChannel("XML/HTTP");
        if (this.log_to_plugin) {
            this.channel.addListener(new LoggerChannelListener(){

                public void messageLogged(int type, String message) {
                    view_model.getLogArea().appendText("  " + message + "\n");
                }

                public void messageLogged(String message, Throwable error) {
                    this.messageLogged(-1, message);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    error.printStackTrace(pw);
                    pw.flush();
                    this.messageLogged(-1, sw.toString());
                }
            });
        }
        this.deserialise_debug = deserialise_param.getValue();
        this.serialise_debug = serialise_param.getValue();
        this.request_handler = new RPRequestHandler(_plugin_interface, true);
        this.access_controller = new WebPluginAccessController(_plugin_interface);
    }

    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String url = request2.getURL().toLowerCase();
        if (url.equals("process.cgi") || url.equals("/process.cgi")) {
            String user_agent_text;
            InputStream is = null;
            Map req_headers = request2.getHeaders();
            String user_agent = (String)req_headers.get("user-agent");
            boolean space_out_xml = false;
            if (user_agent == null && "www.adv-clan.com".equals(req_headers.get("host")) && "www.adv-clan.com".equals(req_headers.get("referer"))) {
                user_agent = "GTSdll v1 (auto-detected)";
                space_out_xml = true;
            }
            String string = user_agent_text = user_agent == null ? "" : ", User-Agent: " + user_agent;
            if (this.log_to_plugin) {
                this.getViewModel().getLogArea().appendText("REQUEST START: " + request2.getClientAddress() + ", time: " + DateFormat.getTimeInstance().format(new Date()) + user_agent_text + "\n");
            }
            try {
                response.setContentType("text/xml; charset=\"utf-8\"");
                new XMLRequestProcessor2(this.request_handler, this.access_controller, request2.getClientAddress(), request2.getInputStream(), response.getOutputStream(), this.plugin_interface, this.channel, this.serialise_debug, this.deserialise_debug, space_out_xml);
                if (this.log_to_plugin) {
                    this.getViewModel().getLogArea().appendText("REQUEST END\n");
                    if (is != null) {
                        is.close();
                    }
                }
                return true;
            }
            catch (Throwable t) {
                Debug.out("Serious error in XML / HTTP plugin - error escaped to this level");
                Debug.printStackTrace(t);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        return false;
    }

    static {
        defaults.put("Port", new Integer(6884));
        defaults.put("DefaultHideResourceConfig", new Boolean(true));
    }
}

