/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.pieces;

import java.util.HashMap;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class WritersItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public WritersItem() {
        super("writers", 1, -1, 80, "Pieces");
        this.setObfustication(true);
        this.setRefreshInterval(4);
    }

    public void refresh(TableCell cell) {
        int i;
        PEPiece piece = (PEPiece)cell.getDataSource();
        String[] core_writers = piece.getWriters();
        String[] my_writers = new String[core_writers.length];
        StringBuffer sb = new StringBuffer();
        int writer_count = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        String last_writer = null;
        int end_range = 0;
        for (i = 0; i < core_writers.length; ++i) {
            String this_writer = core_writers[i];
            if (last_writer == this_writer) {
                if (this_writer != null) {
                    end_range = i;
                }
            } else {
                if (end_range != 0) {
                    map.put(last_writer, (String)map.get(last_writer) + "-" + end_range);
                    end_range = 0;
                }
                if (this_writer != null) {
                    String value = (String)map.get(this_writer);
                    if (value == null) {
                        value = Integer.toString(i);
                        my_writers[writer_count++] = this_writer;
                    } else {
                        value = value + "," + i;
                    }
                    map.put(this_writer, value);
                }
            }
            last_writer = this_writer;
        }
        if (end_range != 0) {
            map.put(last_writer, (String)map.get(last_writer) + "-" + end_range);
        }
        for (i = 0; i < writer_count; ++i) {
            String writer = my_writers[i];
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append(writer);
            sb.append("[");
            sb.append((String)map.get(writer));
            sb.append("]");
        }
        String value = sb.toString();
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

