/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.stats.ActivityView;
import org.gudy.azureus2.ui.swt.views.stats.CacheView;
import org.gudy.azureus2.ui.swt.views.stats.DHTView;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiView;

public class StatsView
extends AbstractIView {
    GlobalManager manager;
    AzureusCore core;
    TabFolder folder;
    TabItem itemActivity;
    TabItem itemStats;
    TabItem itemCache;
    TabItem itemDHT;
    TabItem itemDHTcvs;
    TabItem itemVivaldi;
    IView viewActivity;
    IView viewStats;
    IView viewCache;
    IView viewDHT;
    IView viewDHTcvs;
    IView viewVivaldi;
    UpdateThread updateThread;

    public StatsView(GlobalManager manager, AzureusCore core) {
        this.manager = manager;
        this.core = core;
    }

    public void initialize(Composite composite) {
        this.folder = new TabFolder(composite, 16384);
        this.folder.setBackground(Colors.background);
        this.itemActivity = new TabItem(this.folder, 0);
        this.itemStats = new TabItem(this.folder, 0);
        this.itemCache = new TabItem(this.folder, 0);
        this.itemDHT = new TabItem(this.folder, 0);
        if (Constants.isCVSVersion()) {
            this.itemDHTcvs = new TabItem(this.folder, 0);
        }
        this.itemVivaldi = new TabItem(this.folder, 0);
        this.viewActivity = new ActivityView(this.manager);
        this.viewStats = new TransferStatsView(this.manager, this.core);
        this.viewCache = new CacheView();
        this.viewDHT = new DHTView(0);
        if (Constants.isCVSVersion()) {
            this.viewDHTcvs = new DHTView(1);
        }
        this.viewVivaldi = new VivaldiView();
        Messages.setLanguageText((Widget)this.itemActivity, this.viewActivity.getData());
        Messages.setLanguageText((Widget)this.itemStats, this.viewStats.getData());
        Messages.setLanguageText((Widget)this.itemCache, this.viewCache.getData());
        Messages.setLanguageText((Widget)this.itemDHT, this.viewDHT.getData());
        if (this.viewDHTcvs != null) {
            Messages.setLanguageText((Widget)this.itemDHTcvs, this.viewDHTcvs.getData());
        }
        Messages.setLanguageText((Widget)this.itemVivaldi, this.viewVivaldi.getData());
        TabItem[] items = new TabItem[]{this.itemActivity};
        this.folder.setSelection(items);
        this.viewActivity.initialize((Composite)this.folder);
        this.itemActivity.setControl((Control)this.viewActivity.getComposite());
        this.viewStats.initialize((Composite)this.folder);
        this.itemStats.setControl((Control)this.viewStats.getComposite());
        this.viewCache.initialize((Composite)this.folder);
        this.itemCache.setControl((Control)this.viewCache.getComposite());
        this.viewDHT.initialize((Composite)this.folder);
        this.itemDHT.setControl((Control)this.viewDHT.getComposite());
        if (this.viewDHTcvs != null) {
            this.viewDHTcvs.initialize((Composite)this.folder);
            this.itemDHTcvs.setControl((Control)this.viewDHTcvs.getComposite());
        }
        this.viewVivaldi.initialize((Composite)this.folder);
        this.itemVivaldi.setControl((Control)this.viewVivaldi.getComposite());
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatsView.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        this.viewActivity.getComposite().layout(true);
        this.viewVivaldi.getComposite().layout(true);
        this.updateThread = new UpdateThread();
        this.updateThread.setDaemon(true);
        this.updateThread.start();
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        try {
            int index = this.folder.getSelectionIndex();
            if (index == 0) {
                if (this.viewActivity != null && !this.itemActivity.isDisposed()) {
                    this.viewActivity.refresh();
                }
                return;
            }
            if (index == 1) {
                if (this.viewStats != null && !this.itemStats.isDisposed()) {
                    this.viewStats.refresh();
                }
                return;
            }
            if (index == 2) {
                if (this.viewCache != null && !this.itemCache.isDisposed()) {
                    this.viewCache.refresh();
                }
                return;
            }
            if (index == 3) {
                if (this.viewDHT != null && !this.itemDHT.isDisposed()) {
                    this.viewDHT.refresh();
                }
                return;
            }
            if (Constants.isCVSVersion()) {
                if (index == 4) {
                    if (this.viewDHTcvs != null && !this.itemDHTcvs.isDisposed()) {
                        this.viewDHTcvs.refresh();
                    }
                    return;
                }
                if (index == 5) {
                    if (this.viewVivaldi != null && !this.itemVivaldi.isDisposed()) {
                        this.viewVivaldi.refresh();
                    }
                    return;
                }
            }
            if (index == 4) {
                if (this.viewVivaldi != null && !this.itemVivaldi.isDisposed()) {
                    this.viewVivaldi.refresh();
                }
                return;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void showTransfers() {
        this.folder.setSelection(new TabItem[]{this.itemStats});
    }

    public void showDHT() {
        this.folder.setSelection(new TabItem[]{this.itemDHT});
    }

    public Composite getComposite() {
        return this.folder;
    }

    public String getFullTitle() {
        return MessageText.getString("Stats.title.full");
    }

    public void delete() {
        this.updateThread.stopIt();
        if (Constants.isOSX && this.folder != null && !this.folder.isDisposed()) {
            TabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDisposed()) continue;
                items[i].dispose();
            }
        }
        this.viewActivity.delete();
        this.viewStats.delete();
        this.viewCache.delete();
        this.viewDHT.delete();
        if (this.viewDHTcvs != null) {
            this.viewDHTcvs.delete();
        }
        if (!this.folder.isDisposed()) {
            Utils.disposeComposite((Composite)this.folder);
        }
    }

    private class UpdateThread
    extends Thread {
        boolean bContinue;

        public UpdateThread() {
            super("StatsView Update Thread");
        }

        public void run() {
            try {
                this.bContinue = true;
                while (this.bContinue) {
                    ((ActivityView)StatsView.this.viewActivity).periodicUpdate();
                    ((CacheView)StatsView.this.viewCache).periodicUpdate();
                    ((DHTView)StatsView.this.viewDHT).periodicUpdate();
                    ((TransferStatsView)StatsView.this.viewStats).periodicUpdate();
                    if (StatsView.this.viewDHTcvs != null) {
                        ((DHTView)StatsView.this.viewDHTcvs).periodicUpdate();
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

