/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.SWT.GraphicSWT;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class TorrentInfoView
extends AbstractIView {
    private static final String TEXT_PREFIX = "TorrentInfoView.";
    private DownloadManager download_manager;
    private DownloadManager core_data_source;
    private Download plugin_data_source;
    private Composite outer_panel;
    private Font headerFont;
    private ExternalCell[] cells;
    private ExternalRow external_row = new ExternalRow();

    protected TorrentInfoView(DownloadManager _download_manager) {
        this.core_data_source = this.download_manager = _download_manager;
        try {
            this.plugin_data_source = DownloadManagerImpl.getDownloadStatic(this.download_manager);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initialize(Composite composite) {
        ScrolledComposite sc = new ScrolledComposite(composite, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        sc.setLayoutData((Object)gridData);
        this.outer_panel = sc;
        Composite panel = new Composite((Composite)sc, 0);
        sc.setContent((Control)panel);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Composite cHeader = new Composite(panel, 2048);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 3;
        configLayout.marginWidth = 0;
        cHeader.setLayout((Layout)configLayout);
        gridData = new GridData(772);
        cHeader.setLayoutData((Object)gridData);
        Display d = panel.getDisplay();
        cHeader.setBackground(d.getSystemColor(26));
        cHeader.setForeground(d.getSystemColor(27));
        Label lHeader = new Label(cHeader, 0);
        lHeader.setBackground(d.getSystemColor(26));
        lHeader.setForeground(d.getSystemColor(27));
        FontData[] fontData = lHeader.getFont().getFontData();
        fontData[0].setStyle(1);
        int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
        fontData[0].setHeight(fontHeight);
        this.headerFont = new Font((Device)d, fontData);
        lHeader.setFont(this.headerFont);
        lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.download_manager.getDisplayName().replaceAll("&", "&&"));
        gridData = new GridData(772);
        lHeader.setLayoutData((Object)gridData);
        Composite gTorrentInfo = new Composite(panel, 0);
        gridData = new GridData(272);
        gTorrentInfo.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentInfo.setLayout((Layout)layout);
        Label label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("TorrentInfoView.torrent.encoding") + ": ");
        TOTorrent torrent = this.download_manager.getTorrent();
        label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(torrent == null ? "" : LocaleTorrentUtil.getCurrentTorrentEncoding(torrent));
        label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("MyTrackerView.tracker") + ": ");
        String trackers = "";
        if (torrent != null) {
            TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
            TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
            ArrayList<String> tracker_list = new ArrayList<String>();
            URL url = torrent.getAnnounceURL();
            tracker_list.add(url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort()));
            for (int i = 0; i < sets.length; ++i) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    url = urls[j];
                    String str = url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort());
                    if (tracker_list.contains(str)) continue;
                    tracker_list.add(str);
                }
            }
            TRTrackerAnnouncer announcer = this.download_manager.getTrackerClient();
            URL active_url = null;
            if (announcer != null) {
                active_url = announcer.getTrackerUrl();
            } else {
                TRTrackerScraperResponse scrape = this.download_manager.getTrackerScrapeResponse();
                if (scrape != null) {
                    active_url = scrape.getURL();
                }
            }
            if (active_url == null) {
                active_url = torrent.getAnnounceURL();
            }
            trackers = active_url.getHost() + (active_url.getPort() == -1 ? "" : ":" + active_url.getPort());
            tracker_list.remove(trackers);
            if (tracker_list.size() > 0) {
                trackers = trackers + " (";
                for (int i = 0; i < tracker_list.size(); ++i) {
                    trackers = trackers + (i == 0 ? "" : ", ") + tracker_list.get(i);
                }
                trackers = trackers + ")";
            }
        }
        label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(trackers);
        Group gColumns = new Group(panel, 0);
        Messages.setLanguageText((Widget)gColumns, "TorrentInfoView.columns");
        gridData = new GridData(272);
        gColumns.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        gColumns.setLayout((Layout)layout);
        HashMap usable_cols = new HashMap();
        TableColumnManager col_man = TableColumnManager.getInstance();
        TableColumnCore[][] cols_sets = new TableColumnCore[][]{col_man.getAllTableColumnCoreAsArray("MyTorrents"), col_man.getAllTableColumnCoreAsArray("MySeeders")};
        for (int i = 0; i < cols_sets.length; ++i) {
            int position_base = i == 0 ? 0 : 1000;
            int position_invisible_base = i == 0 ? 10000 : 20000;
            TableColumnCore[] cols = cols_sets[i];
            for (int j = 0; j < cols.length; ++j) {
                TableColumnCore col = cols[j];
                if (usable_cols.containsKey(col.getClass())) continue;
                ExternalCell ext_cell = null;
                int position = col.getPosition();
                position = position == -1 ? position_invisible_base++ : position_base + position;
                List refresh_listeners = col.getCellRefreshListeners();
                if (refresh_listeners.size() > 0) {
                    TableCellRefreshListener tcrl = (TableCellRefreshListener)refresh_listeners.get(0);
                    ext_cell = new ExternalCell(col, tcrl, position);
                } else {
                    List add_listeners = col.getCellAddedListeners();
                    if (add_listeners.size() > 0) {
                        TableCellAddedListener tcal = (TableCellAddedListener)add_listeners.get(0);
                        ext_cell = new ExternalCell(col, null, position);
                        try {
                            tcal.cellAdded(ext_cell);
                            List l = ext_cell.getRefreshListeners();
                            if (l.size() > 0) {
                                TableCellRefreshListener tcrl = (TableCellRefreshListener)l.get(0);
                                ext_cell.setTarget(tcrl);
                            } else {
                                ext_cell.dispose();
                                ext_cell = null;
                            }
                        }
                        catch (Throwable e) {
                            ext_cell.dispose();
                            ext_cell = null;
                        }
                    }
                }
                if (ext_cell == null) continue;
                try {
                    ext_cell.refresh();
                    usable_cols.put(col.getClass(), ext_cell);
                    continue;
                }
                catch (Throwable e) {
                    ext_cell.dispose();
                }
            }
        }
        Collection values = usable_cols.values();
        this.cells = new ExternalCell[values.size()];
        values.toArray(this.cells);
        Arrays.sort(this.cells, new Comparator(){

            public int compare(Object o1, Object o2) {
                ExternalCell c1 = (ExternalCell)o1;
                ExternalCell c2 = (ExternalCell)o2;
                return c1.getPosition() - c2.getPosition();
            }
        });
        for (int i = 0; i < this.cells.length; ++i) {
            ExternalCell cell = this.cells[i];
            label = new Label((Composite)gColumns, 0);
            gridData = new GridData();
            if (i % 2 == 1) {
                gridData.horizontalIndent = 16;
            }
            label.setLayoutData((Object)gridData);
            label.setText(cell.getName() + ": ");
            label = new Label((Composite)gColumns, 0);
            cell.setLabel(label);
            gridData = new GridData();
            gridData = new GridData(768);
            label.setLayoutData((Object)gridData);
        }
        this.refresh();
        sc.setMinSize(panel.computeSize(-1, -1));
    }

    public void refresh() {
        if (this.cells != null) {
            for (int i = 0; i < this.cells.length; ++i) {
                ExternalCell cell = this.cells[i];
                cell.refresh();
            }
        }
    }

    public Composite getComposite() {
        return this.outer_panel;
    }

    public String getFullTitle() {
        return MessageText.getString("GeneralView.section.info");
    }

    public String getData() {
        return "GeneralView.section.info";
    }

    public void delete() {
        super.delete();
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        if (this.cells != null) {
            for (int i = 0; i < this.cells.length; ++i) {
                ExternalCell cell = this.cells[i];
                cell.dispose();
            }
        }
    }

    protected class ExternalRow
    implements TableRowCore {
        protected ExternalRow() {
        }

        public void delete(boolean bDeleteSWTObject) {
        }

        public void doPaint(GC gc) {
        }

        public Object getDataSource() {
            return null;
        }

        public Color getForeground() {
            return null;
        }

        public String getTableID() {
            return null;
        }

        public void invalidate() {
        }

        public boolean isValid() {
            return false;
        }

        public void refresh(boolean bDoGraphics) {
        }

        public void refresh(boolean bDoGraphics, boolean bVisible) {
        }

        public void setForeground(Color c) {
        }

        public void setUpToDate(boolean upToDate) {
        }

        public void doPaint(GC gc, boolean bVisible) {
        }

        public Color getBackground() {
            return null;
        }

        public Object getDataSource(boolean bCoreObject) {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public TableCell getTableCell(String sColumnName) {
            return null;
        }

        public TableCellCore getTableCellCore(String field) {
            return null;
        }

        public boolean isRowDisposed() {
            return false;
        }

        public boolean isSelected() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void locationChanged(int iStartColumn) {
        }

        public void repaint() {
        }

        public void setAlternatingBGColor(boolean bEvenIfNotVisible) {
        }

        public boolean setHeight(int iHeight) {
            return false;
        }

        public boolean setIconSize(Point pt) {
            return false;
        }

        public void setSelected(boolean bSelected) {
        }

        public boolean setTableItem(int newIndex) {
            return false;
        }
    }

    protected class ExternalCell
    implements TableCellCore {
        private TableColumnCore column;
        private TableCellRefreshListener target;
        private int position;
        private Label label;
        private Image label_image;
        private List refresh_listeners = new ArrayList();
        private List dispose_listeners = new ArrayList();
        private boolean refresh_failed;
        private Graphic graphic;

        protected ExternalCell(TableColumnCore _column, TableCellRefreshListener _target, int _position) {
            this.column = _column;
            this.target = _target;
            this.position = _position;
        }

        protected void setTarget(TableCellRefreshListener _target) {
            this.target = _target;
        }

        protected void setLabel(Label _label) {
            this.label = _label;
        }

        protected String getName() {
            return MessageText.getString(this.column.getTitleLanguageKey());
        }

        public void refresh() {
            if (this.refresh_failed) {
                this.label.setText("Not Available");
                return;
            }
            try {
                this.target.refresh(this);
            }
            catch (RuntimeException e) {
                this.refresh_failed = true;
                throw e;
            }
        }

        protected int getPosition() {
            return this.position;
        }

        protected List getRefreshListeners() {
            return this.refresh_listeners;
        }

        public Object getDataSource() {
            return this.column.getUseCoreDataSource() ? TorrentInfoView.this.core_data_source : TorrentInfoView.this.plugin_data_source;
        }

        public TableColumn getTableColumn() {
            throw new RuntimeException("getTableColumn not imp");
        }

        public TableRow getTableRow() {
            throw new RuntimeException("getTableRow not imp");
        }

        public String getTableID() {
            throw new RuntimeException("getTableID not imp");
        }

        public boolean setText(String original_text) {
            if (this.label != null && !this.label.isDisposed()) {
                String text = DisplayFormatters.truncateString(original_text.replaceAll("&", "&&"), 64);
                this.label.setText(text);
                this.label.setToolTipText(original_text);
            }
            return true;
        }

        public String getText() {
            return this.label == null || this.label.isDisposed() ? "" : this.label.getText();
        }

        public boolean setForeground(int red, int green, int blue) {
            return true;
        }

        public boolean setSortValue(Comparable valueToSort) {
            return true;
        }

        public boolean setSortValue(long valueToSort) {
            return true;
        }

        public boolean setSortValue(float valueToSort) {
            return true;
        }

        public Comparable getSortValue() {
            throw new RuntimeException("getSortValue not imp");
        }

        public boolean isShown() {
            return true;
        }

        public boolean isValid() {
            return false;
        }

        public void invalidate() {
        }

        public void setToolTip(Object tooltip) {
        }

        public Object getToolTip() {
            return null;
        }

        public boolean isDisposed() {
            return false;
        }

        public int getWidth() {
            return this.label == null || this.label.isDisposed() ? 0 : this.label.getBounds().width;
        }

        public int getHeight() {
            return this.label == null || this.label.isDisposed() ? 0 : this.label.getBounds().height;
        }

        public boolean setGraphic(Graphic img) {
            Image imgSWT;
            this.graphic = img;
            if (img instanceof GraphicSWT) {
                imgSWT = ((GraphicSWT)img).getImage();
                this.setImage(imgSWT);
            }
            if (img instanceof UISWTGraphic) {
                imgSWT = ((UISWTGraphic)img).getImage();
                this.setImage(imgSWT);
            }
            return true;
        }

        public Graphic getGraphic() {
            return this.graphic;
        }

        public void setFillCell(boolean bFillCell) {
        }

        public void setMarginHeight(int height) {
        }

        public void setMarginWidth(int width) {
        }

        public void addRefreshListener(TableCellRefreshListener listener) {
            this.refresh_listeners.add(listener);
        }

        public void removeRefreshListener(TableCellRefreshListener listener) {
            this.refresh_listeners.remove(listener);
        }

        public void addDisposeListener(TableCellDisposeListener listener) {
            this.dispose_listeners.add(listener);
        }

        public void removeDisposeListener(TableCellDisposeListener listener) {
            this.dispose_listeners.remove(listener);
        }

        public void addToolTipListener(TableCellToolTipListener listener) {
        }

        public void removeToolTipListener(TableCellToolTipListener listener) {
        }

        public void addMouseListener(TableCellMouseListener listener) {
        }

        public void removeMouseListener(TableCellMouseListener listener) {
        }

        public void addListeners(Object listener) {
            if (listener instanceof TableCellRefreshListener) {
                this.refresh_listeners.add(listener);
            }
            if (listener instanceof TableCellDisposeListener) {
                this.dispose_listeners.add(listener);
            }
        }

        public void invalidate(boolean bMustRefresh) {
        }

        public boolean setForeground(Color color) {
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setForeground(color);
            }
            return true;
        }

        public void refresh(boolean bDoGraphics) {
        }

        public void refresh(boolean bDoGraphics, boolean bRowVisible) {
        }

        public void dispose() {
            for (int i = 0; i < this.dispose_listeners.size(); ++i) {
                try {
                    ((TableCellDisposeListener)this.dispose_listeners.get(i)).dispose(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.column.invokeCellDisposeListeners(this);
        }

        public void setImage(Image img) {
            if (this.label != null && !this.label.isDisposed()) {
                this.label_image = img;
                if (this.label.getText().length() == 0) {
                    this.label.setImage(img);
                }
            }
        }

        public boolean needsPainting() {
            return true;
        }

        public void doPaint(GC gc) {
        }

        public void locationChanged() {
        }

        public TableRowCore getTableRowCore() {
            return TorrentInfoView.this.external_row;
        }

        public Point getSize() {
            throw new RuntimeException("getSize not imp");
        }

        public Rectangle getBounds() {
            throw new RuntimeException("getBounds not imp");
        }

        public boolean setGraphic(Image img) {
            this.setImage(img);
            return true;
        }

        public Image getGraphicSWT() {
            return this.label_image;
        }

        public void invokeToolTipListeners(int type) {
        }

        public void invokeMouseListeners(TableCellMouseEvent event2) {
        }

        public void setUpToDate(boolean upToDate) {
        }

        public String getObfusticatedText() {
            return null;
        }

        public Image getBackgroundImage() {
            return null;
        }

        public Color getForeground() {
            return null;
        }

        public BufferedTableItem getBufferedTableItem() {
            throw new RuntimeException("getBufferedTableItem not imp");
        }

        public int getCursorID() {
            return 0;
        }

        public void setCursorID(int cursorID) {
        }

        public boolean isUpToDate() {
            return true;
        }

        public int compareTo(Object arg0) {
            return 0;
        }
    }
}

