/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TrackerChangerWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.shells.InputShell;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.wizards.sendtorrent.SendTorrentWizard;

public class MyTorrentsView
extends TableView
implements GlobalManagerListener,
ParameterListener,
DownloadManagerListener,
CategoryManagerListener,
CategoryListener,
KeyListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final int ASYOUTYPE_MODE_FIND = 0;
    private static final int ASYOUTYPE_MODE_FILTER = 1;
    private static final int ASYOUTYPE_MODE = 1;
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    private boolean isSeedingView;
    private Composite cTablePanel;
    private Font fontButton = null;
    private Composite cCategories;
    private ControlAdapter catResizeAdapter;
    private Menu menuCategory;
    private MenuItem menuItemChangeDir = null;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    private Composite cHeader = null;
    private Label lblHeader = null;
    private Text txtFilter = null;
    private Label lblX = null;
    int userMode;
    boolean isTrackerOn;
    private Category currentCategory;
    private int drag_drop_line_start = -1;
    private boolean confirmDataDelete = COConfigurationManager.getBooleanParameter("Confirm Data Delete", true);
    private String sLastSearch = "";
    private long lLastSearchTime;
    private boolean bRegexSearch = false;
    private boolean top;
    private boolean bottom;
    private boolean up;
    private boolean down;
    private boolean run;
    private boolean host;
    private boolean publish;
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MyTorrentsView(AzureusCore _azureus_core, boolean isSeedingView, TableColumnCore[] basicItems) {
        super(isSeedingView ? "MySeeders" : "MyTorrents", "MyTorrentsView", basicItems, "#", 0x10010002);
        this.setRowDefaultIconSize(new Point(16, 16));
        this.azureus_core = _azureus_core;
        this.globalManager = this.azureus_core.getGlobalManager();
        this.isSeedingView = isSeedingView;
        this.currentCategory = CategoryManager.getCategory(1);
    }

    public void initialize(Composite composite0) {
        if (this.cTablePanel != null) {
            return;
        }
        super.initialize(composite0);
        this.createTabs();
        this.createDragDrop();
        COConfigurationManager.addParameterListener("Confirm Data Delete", this);
        COConfigurationManager.addAndFireParameterListener("User Mode", this);
        if (this.currentCategory != null) {
            this.currentCategory.addCategoryListener(this);
        }
        CategoryManager.addCategoryManagerListener(this);
        this.globalManager.addListener(this, false);
        Object[] dms = this.globalManager.getDownloadManagers().toArray();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = (DownloadManager)dms[i];
            dm.addListener(this);
            if (this.isOurDownloadManager(dm)) continue;
            dms[i] = null;
        }
        this.addDataSources(dms);
        this.processDataSourceQueue();
    }

    public void tableStructureChanged() {
        super.tableStructureChanged();
        this.createDragDrop();
        this.activateCategory(this.currentCategory);
    }

    public Composite createMainPanel(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        this.cTablePanel = new Composite(panel, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.cTablePanel.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.cTablePanel.setLayout((Layout)layout);
        return panel;
    }

    private void createTabs() {
        boolean showCat;
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        boolean bl = showCat = this.sLastSearch.length() > 0;
        if (!showCat) {
            for (int i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                showCat = true;
                break;
            }
        }
        if (!showCat) {
            if (this.cCategories != null && !this.cCategories.isDisposed()) {
                Control[] controls = this.cCategories.getChildren();
                for (int i = 0; i < controls.length; ++i) {
                    controls[i].dispose();
                }
            }
        } else {
            if (this.cCategories == null) {
                Composite parent = this.getComposite();
                this.cCategories = new Composite(parent, 0);
                GridData gridData = new GridData(128);
                this.cCategories.setLayoutData((Object)gridData);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.marginLeft = 3;
                rowLayout.marginRight = 0;
                rowLayout.spacing = 0;
                rowLayout.wrap = true;
                this.cCategories.setLayout((Layout)rowLayout);
                this.cHeader = new Composite(parent, 0);
                gridData = new GridData(768);
                gridData.horizontalIndent = 5;
                this.cHeader.setLayoutData((Object)gridData);
                GridLayout layout = new GridLayout();
                layout.numColumns = 6;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.horizontalSpacing = 2;
                layout.verticalSpacing = 0;
                this.cHeader.setLayout((Layout)layout);
                this.lblHeader = new Label(this.cHeader, 64);
                gridData = new GridData();
                this.lblHeader.setLayoutData((Object)gridData);
                this.updateTableLabel();
                Label lblSep = new Label(this.cHeader, 514);
                gridData = new GridData(1040);
                gridData.heightHint = 5;
                lblSep.setLayoutData((Object)gridData);
                Label lblFilter = new Label(this.cHeader, 64);
                gridData = new GridData(1);
                lblFilter.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)lblFilter, "MyTorrentsView.filter");
                this.lblX = new Label(this.cHeader, 64);
                Messages.setLanguageTooltip((Widget)this.lblX, "MyTorrentsView.clearFilter.tooltip");
                gridData = new GridData(128);
                this.lblX.setLayoutData((Object)gridData);
                this.lblX.setImage(ImageRepository.getImage("smallx-gray"));
                this.lblX.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        if (e.y <= 10) {
                            MyTorrentsView.this.sLastSearch = "";
                            MyTorrentsView.this.updateLastSearch();
                        }
                    }
                });
                this.txtFilter = new Text(this.cHeader, 2048);
                Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                this.txtFilter.addKeyListener((KeyListener)this);
                gridData = new GridData(768);
                this.txtFilter.setLayoutData((Object)gridData);
                this.txtFilter.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        MyTorrentsView.this.sLastSearch = ((Text)e.widget).getText();
                        MyTorrentsView.this.updateLastSearch();
                    }
                });
                this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 0x1000002) {
                            MyTorrentsView.this.getTable().setFocus();
                            e.doit = false;
                        }
                    }
                });
                lblSep = new Label(this.cHeader, 514);
                gridData = new GridData(1040);
                gridData.heightHint = 5;
                lblSep.setLayoutData((Object)gridData);
                this.cHeader.moveAbove(null);
                this.cCategories.moveBelow((Control)this.cHeader);
            } else {
                Control[] controls = this.cCategories.getChildren();
                for (int i = 0; i < controls.length; ++i) {
                    controls[i].dispose();
                }
            }
            int iFontPixelsHeight = 11;
            int iFontPointHeight = iFontPixelsHeight * 72 / this.cCategories.getDisplay().getDPI().y;
            for (int i = 0; i < categories.length; ++i) {
                final Button catButton = new Button(this.cCategories, 2);
                catButton.addKeyListener((KeyListener)this);
                if (i == 0 && this.fontButton == null) {
                    Font f = catButton.getFont();
                    FontData fd = f.getFontData()[0];
                    fd.setHeight(iFontPointHeight);
                    this.fontButton = new Font((Device)this.cCategories.getDisplay(), fd);
                }
                catButton.setText("|");
                catButton.setFont(this.fontButton);
                catButton.pack(true);
                if (catButton.computeSize((int)100, (int)-1).y > 0) {
                    RowData rd = new RowData();
                    rd.height = catButton.computeSize((int)100, (int)-1).y - 2 + catButton.getBorderWidth() * 2;
                    catButton.setLayoutData((Object)rd);
                }
                String name = categories[i].getName();
                if (categories[i].getType() == 0) {
                    catButton.setText(name);
                } else {
                    Messages.setLanguageText((Widget)catButton, name);
                }
                catButton.setData("Category", categories[i]);
                if (categories[i] == this.currentCategory) {
                    catButton.setSelection(true);
                }
                catButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button curButton = (Button)e.widget;
                        boolean isEnabled = curButton.getSelection();
                        Control[] controls = MyTorrentsView.this.cCategories.getChildren();
                        if (!isEnabled) {
                            curButton = (Button)controls[0];
                        }
                        for (int i = 0; i < controls.length; ++i) {
                            Button b = (Button)controls[i];
                            if (b != curButton && b.getSelection()) {
                                b.setSelection(false);
                                continue;
                            }
                            if (b != curButton || b.getSelection()) continue;
                            b.setSelection(true);
                        }
                        MyTorrentsView.this.activateCategory((Category)curButton.getData("Category"));
                    }
                });
                catButton.addListener(32, new Listener(){

                    public void handleEvent(Event event2) {
                        Button curButton = (Button)event2.widget;
                        Category curCategory = (Category)curButton.getData("Category");
                        List dms = curCategory.getDownloadManagers();
                        long ttlActive = 0L;
                        long ttlSize = 0L;
                        long ttlRSpeed = 0L;
                        long ttlSSpeed = 0L;
                        int count = 0;
                        Iterator iter = dms.iterator();
                        while (iter.hasNext()) {
                            DownloadManager dm = (DownloadManager)iter.next();
                            if (!MyTorrentsView.this.isOurDownloadManager(dm)) continue;
                            ++count;
                            if (dm.getState() == 50 || dm.getState() == 60) {
                                ++ttlActive;
                            }
                            ttlSize += dm.getSize();
                            ttlRSpeed += dm.getStats().getDataReceiveRate();
                            ttlSSpeed += dm.getStats().getDataSendRate();
                        }
                        if (count == 0) {
                            curButton.setToolTipText(null);
                            return;
                        }
                        curButton.setToolTipText("Total: " + count + "\n" + "Downloading/Seeding: " + ttlActive + "\n" + "\n" + "Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed / (long)count) + "/" + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed / (long)count) + "\n" + "Size: " + DisplayFormatters.formatByteCountToKiBEtc(ttlSize));
                    }
                });
                final DropTarget tabDropTarget = new DropTarget((Control)catButton, 23);
                Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
                tabDropTarget.setTransfer(types);
                tabDropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dragOver(DropTargetEvent e) {
                        e.detail = MyTorrentsView.this.drag_drop_line_start >= 0 ? 2 : 0;
                    }

                    public void drop(DropTargetEvent e) {
                        e.detail = 0;
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.this.assignSelectedToCategory((Category)catButton.getData("Category"));
                        }
                    }
                });
                catButton.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (tabDropTarget != null && !tabDropTarget.isDisposed()) {
                            tabDropTarget.dispose();
                        }
                    }
                });
                Menu menu = new Menu((Decorations)this.getComposite().getShell(), 8);
                MenuItem itemDelete = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemDelete, "MyTorrentsView.menu.category.delete");
                menu.setDefaultItem(itemDelete);
                if (categories[i].getType() == 0) {
                    itemDelete.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            Category catToDelete = (Category)catButton.getData("Category");
                            if (catToDelete != null) {
                                List managers = catToDelete.getDownloadManagers();
                                DownloadManager[] dms = managers.toArray(new DownloadManager[managers.size()]);
                                for (int i = 0; i < dms.length; ++i) {
                                    dms[i].getDownloadState().setCategory(null);
                                }
                                if (MyTorrentsView.this.currentCategory == catToDelete) {
                                    MyTorrentsView.this.activateCategory(CategoryManager.getCategory(1));
                                } else {
                                    MyTorrentsView.this.activateCategory(MyTorrentsView.this.currentCategory);
                                }
                                CategoryManager.removeCategory(catToDelete);
                            }
                        }
                    });
                    itemDelete.setEnabled(true);
                } else {
                    itemDelete.setEnabled(false);
                }
                catButton.setMenu(menu);
            }
            this.cCategories.layout();
            this.getComposite().layout();
            if (this.catResizeAdapter == null) {
                this.catResizeAdapter = new ControlAdapter(){

                    public void controlResized(ControlEvent event2) {
                        if (MyTorrentsView.this.getComposite().isDisposed() || MyTorrentsView.this.cCategories.isDisposed()) {
                            return;
                        }
                        GridData gridData = new GridData(128);
                        int parentWidth = ((MyTorrentsView)MyTorrentsView.this).cCategories.getParent().getClientArea().width;
                        int catsWidth = ((MyTorrentsView)MyTorrentsView.this).cCategories.computeSize((int)-1, (int)-1).x;
                        int textWidth = 5 + ((MyTorrentsView)MyTorrentsView.this).cHeader.computeSize((int)-1, (int)-1).x + MyTorrentsView.this.cHeader.getBorderWidth() * 2;
                        Object layoutData = MyTorrentsView.this.cHeader.getLayoutData();
                        if (layoutData instanceof GridData) {
                            GridData labelGrid = (GridData)layoutData;
                            textWidth += labelGrid.horizontalIndent;
                        }
                        if (textWidth + catsWidth > parentWidth) {
                            gridData.widthHint = parentWidth - textWidth;
                        }
                        MyTorrentsView.this.cCategories.setLayoutData((Object)gridData);
                        MyTorrentsView.this.cCategories.getParent().layout(true);
                    }
                };
                this.getTableComposite().addControlListener((ControlListener)this.catResizeAdapter);
            }
            this.catResizeAdapter.controlResized(null);
        }
    }

    private boolean isOurDownloadManager(DownloadManager dm) {
        boolean bOurs;
        if (!this.isInCategory(dm, this.currentCategory)) {
            return false;
        }
        boolean bCompleted = dm.isDownloadComplete(false);
        boolean bl = bOurs = bCompleted && this.isSeedingView || !bCompleted && !this.isSeedingView;
        if (bOurs && this.sLastSearch.length() > 0) {
            try {
                String name = dm.getDisplayName();
                String s = this.bRegexSearch ? this.sLastSearch : "\\Q" + this.sLastSearch.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
                Pattern pattern = Pattern.compile(s, 2);
                if (!pattern.matcher(name).find()) {
                    bOurs = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bOurs;
    }

    public Table createTable(Composite panel) {
        Table table = new Table(this.cTablePanel, this.iTableStyle);
        table.setLayoutData((Object)new GridData(1808));
        table.addKeyListener((KeyListener)this);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Utils.execSWTThread(new AERunnable(this){
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void runSupport() {
                        MyTorrentsView.access$1000(10.access$900(this.this$1));
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.refreshIconBar();
                        }
                    }
                });
            }

            static /* synthetic */ MyTorrentsView access$900(10 x0) {
                return x0.MyTorrentsView.this;
            }
        });
        this.cTablePanel.layout();
        return table;
    }

    public void runDefaultAction() {
        UIFunctions uiFunctions;
        DownloadManager dm = (DownloadManager)this.getFirstSelectedDataSource();
        if (dm != null && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
            uiFunctions.openManagerView(dm);
        }
    }

    public void fillTorrentMenu(Menu menu) {
        boolean bChecked;
        String msg_text;
        boolean bChangeDir;
        Object[] dms = this.getSelectedDataSources();
        boolean hasSelection = dms.length > 0;
        this.isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        boolean moveDown = bChangeDir = hasSelection;
        boolean moveUp = bChangeDir;
        boolean fileRescan = true;
        boolean fileMove = true;
        boolean changeSpeed = true;
        boolean manualUpdate = true;
        boolean barsOpened = true;
        boolean changeUrl = true;
        boolean stop = false;
        boolean start = false;
        boolean recheck = false;
        boolean forceStartEnabled = false;
        boolean forceStart = false;
        boolean upSpeedDisabled = false;
        long totalUpSpeed = 0L;
        boolean upSpeedUnlimited = false;
        long upSpeedSetMax = 0L;
        boolean downSpeedDisabled = false;
        long totalDownSpeed = 0L;
        boolean downSpeedUnlimited = false;
        long downSpeedSetMax = 0L;
        boolean allScanSelected = true;
        boolean allScanNotSelected = true;
        boolean allStopped = true;
        if (hasSelection) {
            bChangeDir = true;
            for (int i = 0; i < dms.length; ++i) {
                int state;
                TRTrackerAnnouncer trackerClient;
                DownloadManager dm = (DownloadManager)dms[i];
                try {
                    int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    int maxdl = dm.getStats().getDownloadRateLimitBytesPerSecond();
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                }
                catch (NullPointerException ex) {
                    changeSpeed = false;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
                if (dm.getTrackerClient() == null) {
                    changeUrl = false;
                }
                if (barsOpened && !MinimizedWindow.isOpen(dm)) {
                    barsOpened = false;
                }
                stop = stop || ManagerUtils.isStopable(dm);
                start = start || ManagerUtils.isStartable(dm);
                recheck = recheck || dm.canForceRecheck();
                forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                forceStart = forceStart || dm.isForceStart();
                boolean stopped = ManagerUtils.isStopped(dm);
                allStopped &= stopped;
                boolean bl = fileMove = fileMove && stopped && dm.isPersistent();
                if (!dm.getGlobalManager().isMoveableDown(dm)) {
                    moveDown = false;
                }
                if (!dm.getGlobalManager().isMoveableUp(dm)) {
                    moveUp = false;
                }
                if (this.userMode > 1 && (trackerClient = dm.getTrackerClient()) != null) {
                    boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                    manualUpdate &= update_state;
                }
                bChangeDir &= ((state = dm.getState()) == 100 || state == 70) && dm.isDownloadComplete(false) && !dm.filesExist();
                boolean scan = dm.getDownloadState().getFlag(2L);
                boolean incomplete = !dm.isDownloadComplete(true);
                allScanSelected = incomplete && allScanSelected && scan;
                allScanNotSelected = incomplete && allScanNotSelected && !scan;
            }
            fileRescan = allScanSelected || allScanNotSelected;
        } else {
            barsOpened = false;
            forceStart = false;
            forceStartEnabled = false;
            start = false;
            stop = false;
            fileMove = false;
            fileRescan = false;
            upSpeedDisabled = true;
            downSpeedDisabled = true;
            changeUrl = false;
            recheck = false;
            manualUpdate = false;
        }
        if (bChangeDir) {
            this.menuItemChangeDir = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)this.menuItemChangeDir, "MyTorrentsView.menu.changeDirectory");
            this.menuItemChangeDir.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MyTorrentsView.this.changeDirSelectedTorrents();
                }
            });
        }
        MenuItem itemDetails = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemDetails, "MyTorrentsView.menu.showdetails");
        menu.setDefaultItem(itemDetails);
        Utils.setMenuItemImage(itemDetails, "details");
        itemDetails.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.openManagerView((DownloadManager)row.getDataSource(true));
                }
            }
        });
        itemDetails.setEnabled(hasSelection);
        MenuItem itemBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemBar, "MyTorrentsView.menu.showdownloadbar");
        Utils.setMenuItemImage(itemBar, "downloadBar");
        itemBar.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (MinimizedWindow.isOpen(dm)) {
                    MinimizedWindow.close(dm);
                } else {
                    new MinimizedWindow(dm, MyTorrentsView.this.cTablePanel.getShell());
                }
            }
        });
        itemBar.setEnabled(hasSelection);
        itemBar.setSelection(barsOpened);
        new MenuItem(menu, 2);
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "MyTorrentsView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        itemOpen.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.runSelectedTorrents();
            }
        });
        itemOpen.setEnabled(hasSelection);
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu.explore");
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.openSelectedTorrents();
            }
        });
        itemExplore.setEnabled(hasSelection);
        MenuItem itemSend = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemSend, "MyTorrentsView.menu.sendTorrent");
        itemSend.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.openSendTorrentWizForSelected();
            }
        });
        itemSend.setEnabled(hasSelection);
        MenuItem itemAdvanced = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemAdvanced, "MyTorrentsView.menu.advancedmenu");
        itemAdvanced.setEnabled(hasSelection);
        Menu menuAdvanced = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemAdvanced.setMenu(menuAdvanced);
        MenuItem itemDownSpeed = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemDownSpeed, "MyTorrentsView.menu.setDownSpeed");
        Utils.setMenuItemImage(itemDownSpeed, "speed");
        Menu menuDownSpeed = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemDownSpeed.setMenu(menuDownSpeed);
        MenuItem itemCurrentDownSpeed = new MenuItem(menuDownSpeed, 8);
        itemCurrentDownSpeed.setEnabled(false);
        StringBuffer speedText = new StringBuffer();
        String separator = "";
        if (downSpeedDisabled) {
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
            separator = " / ";
        }
        if (downSpeedUnlimited) {
            speedText.append(separator);
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
            separator = " / ";
        }
        if (totalDownSpeed > 0L) {
            speedText.append(separator);
            speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalDownSpeed));
        }
        itemCurrentDownSpeed.setText(speedText.toString());
        new MenuItem(menuDownSpeed, 2);
        MenuItem[] itemsDownSpeed = new MenuItem[12];
        Listener itemsDownSpeedListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget != null && e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    int speed = item.getData("maxdl") == null ? 0 : (Integer)item.getData("maxdl");
                    MyTorrentsView.this.setSelectedTorrentsDownSpeed(speed);
                }
            }
        };
        itemsDownSpeed[1] = new MenuItem(menuDownSpeed, 8);
        Messages.setLanguageText((Widget)itemsDownSpeed[1], "MyTorrentsView.menu.setSpeed.unlimit");
        itemsDownSpeed[1].setData("maxdl", (Object)new Integer(0));
        itemsDownSpeed[1].addListener(13, itemsDownSpeedListener);
        if (hasSelection) {
            long maxDownload = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024;
            if (maxDownload == 0L) {
                maxDownload = downSpeedSetMax == 0L ? 204800L : 4L * (downSpeedSetMax / 1024L) * 1024L;
            }
            for (int i = 2; i < 12; ++i) {
                itemsDownSpeed[i] = new MenuItem(menuDownSpeed, 8);
                itemsDownSpeed[i].addListener(13, itemsDownSpeedListener);
                int limit = (int)(maxDownload / (long)(10 * dms.length) * (long)(12 - i));
                StringBuffer speed = new StringBuffer();
                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * dms.length));
                if (dms.length > 1) {
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.in"));
                    speed.append(" ");
                    speed.append(dms.length);
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.slots"));
                    speed.append(" ");
                    speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit));
                }
                itemsDownSpeed[i].setText(speed.toString());
                itemsDownSpeed[i].setData("maxdl", (Object)new Integer(limit));
            }
        }
        new MenuItem(menuDownSpeed, 2);
        MenuItem itemDownSpeedManual = new MenuItem(menuDownSpeed, 8);
        Messages.setLanguageText((Widget)itemDownSpeedManual, "MyTorrentsView.menu.manual");
        itemDownSpeedManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSpeed;
                String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
                InputShell is = new InputShell("MyTorrentsView.dialog.setSpeed.title", new String[]{MessageText.getString("MyTorrentsView.dialog.setNumber.download")}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, MessageText.getString("MyTorrentsView.dialog.setNumber.download")});
                String sReturn = is.open();
                if (sReturn == null) {
                    return;
                }
                try {
                    newSpeed = (int)(Double.valueOf(sReturn) * 1024.0);
                }
                catch (NumberFormatException er) {
                    MessageBox mb = new MessageBox(MyTorrentsView.this.getComposite().getShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                MyTorrentsView.this.setSelectedTorrentsDownSpeed(newSpeed);
            }
        });
        MenuItem itemUpSpeed = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemUpSpeed, "MyTorrentsView.menu.setUpSpeed");
        Utils.setMenuItemImage(itemUpSpeed, "speed");
        Menu menuUpSpeed = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemUpSpeed.setMenu(menuUpSpeed);
        MenuItem itemCurrentUpSpeed = new MenuItem(menuUpSpeed, 8);
        itemCurrentUpSpeed.setEnabled(false);
        separator = "";
        speedText = new StringBuffer();
        if (upSpeedDisabled) {
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
            separator = " / ";
        }
        if (upSpeedUnlimited) {
            speedText.append(separator);
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
            separator = " / ";
        }
        if (totalUpSpeed > 0L) {
            speedText.append(separator);
            speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalUpSpeed));
        }
        itemCurrentUpSpeed.setText(speedText.toString());
        new MenuItem(menuUpSpeed, 2);
        MenuItem[] itemsUpSpeed = new MenuItem[12];
        Listener itemsUpSpeedListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget != null && e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    int speed = item.getData("maxul") == null ? 0 : (Integer)item.getData("maxul");
                    MyTorrentsView.this.setSelectedTorrentsUpSpeed(speed);
                }
            }
        };
        itemsUpSpeed[1] = new MenuItem(menuUpSpeed, 8);
        Messages.setLanguageText((Widget)itemsUpSpeed[1], "MyTorrentsView.menu.setSpeed.unlimit");
        itemsUpSpeed[1].setData("maxul", (Object)new Integer(0));
        itemsUpSpeed[1].addListener(13, itemsUpSpeedListener);
        if (hasSelection) {
            long maxUpload = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024;
            maxUpload = maxUpload == 0L ? 76800L : (upSpeedSetMax == 0L ? 204800L : 4L * (upSpeedSetMax / 1024L) * 1024L);
            for (int i = 2; i < 12; ++i) {
                itemsUpSpeed[i] = new MenuItem(menuUpSpeed, 8);
                itemsUpSpeed[i].addListener(13, itemsUpSpeedListener);
                int limit = (int)(maxUpload / (long)(10 * dms.length) * (long)(12 - i));
                StringBuffer speed = new StringBuffer();
                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * dms.length));
                if (dms.length > 1) {
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.in"));
                    speed.append(" ");
                    speed.append(dms.length);
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.slots"));
                    speed.append(" ");
                    speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit));
                }
                itemsUpSpeed[i].setText(speed.toString());
                itemsUpSpeed[i].setData("maxul", (Object)new Integer(limit));
            }
        }
        new MenuItem(menuUpSpeed, 2);
        MenuItem itemUpSpeedManual = new MenuItem(menuUpSpeed, 8);
        Messages.setLanguageText((Widget)itemUpSpeedManual, "MyTorrentsView.menu.manual");
        itemUpSpeedManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSpeed;
                String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
                InputShell is = new InputShell("MyTorrentsView.dialog.setSpeed.title", new String[]{MessageText.getString("MyTorrentsView.dialog.setNumber.upload")}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, MessageText.getString("MyTorrentsView.dialog.setNumber.upload")});
                String sReturn = is.open();
                if (sReturn == null) {
                    return;
                }
                try {
                    newSpeed = (int)(Double.valueOf(sReturn) * 1024.0);
                }
                catch (NumberFormatException er) {
                    MessageBox mb = new MessageBox(MyTorrentsView.this.getComposite().getShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                MyTorrentsView.this.setSelectedTorrentsUpSpeed(newSpeed);
            }
        });
        Menu menuTracker = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemTracker = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemTracker, "MyTorrentsView.menu.tracker");
        itemTracker.setMenu(menuTracker);
        MenuItem itemChangeTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemChangeTracker, "MyTorrentsView.menu.changeTracker");
        Utils.setMenuItemImage(itemChangeTracker, "add_tracker");
        itemChangeTracker.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                TRTrackerAnnouncer tc = ((DownloadManager)row.getDataSource(true)).getTrackerClient();
                if (tc != null) {
                    new TrackerChangerWindow(MyTorrentsView.this.getComposite().getDisplay(), tc);
                }
            }
        });
        itemChangeTracker.setEnabled(changeUrl);
        MenuItem itemEditTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTracker, "MyTorrentsView.menu.editTracker");
        Utils.setMenuItemImage(itemEditTracker, "edit_trackers");
        itemEditTracker.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (dm.getTorrent() != null) {
                    TOTorrent torrent = dm.getTorrent();
                    List group = TorrentUtils.announceGroupsToList(torrent);
                    new MultiTrackerEditor(null, group, new TrackerEditorListener(this, torrent, dm){
                        private final /* synthetic */ TOTorrent val$torrent;
                        private final /* synthetic */ DownloadManager val$dm;
                        private final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$torrent = val$torrent;
                            this.val$dm = val$dm;
                        }

                        public void trackersChanged(String str, String str2, List group) {
                            TorrentUtils.listToAnnounceGroups(group, this.val$torrent);
                            try {
                                TorrentUtils.writeToFile(this.val$torrent);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            if (this.val$dm.getTrackerClient() != null) {
                                this.val$dm.getTrackerClient().resetTrackerUrl(true);
                            }
                        }
                    }, true);
                }
            }
        });
        itemEditTracker.setEnabled(hasSelection);
        MenuItem itemManualUpdate = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualUpdate, "GeneralView.label.trackerurlupdate");
        itemManualUpdate.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                ((DownloadManager)row.getDataSource(true)).requestTrackerAnnounce(false);
            }
        });
        itemManualUpdate.setEnabled(manualUpdate);
        boolean scrape_enabled = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
        boolean scrape_stopped = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
        boolean manualScrape = !scrape_enabled || !scrape_stopped && allStopped;
        MenuItem itemManualScrape = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualScrape, "GeneralView.label.trackerscrapeupdate");
        itemManualScrape.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                ((DownloadManager)row.getDataSource(true)).requestTrackerScrape(true);
            }
        });
        itemManualScrape.setEnabled(manualScrape);
        MenuItem itemFiles = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemFiles, "ConfigView.section.files");
        Menu menuFiles = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemFiles.setMenu(menuFiles);
        MenuItem itemFileMoveData = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveData, "MyTorrentsView.menu.movedata");
        itemFileMoveData.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Object[] dms = MyTorrentsView.this.getSelectedDataSources();
                if (dms != null && dms.length > 0) {
                    DirectoryDialog dd = new DirectoryDialog(MyTorrentsView.this.getComposite().getShell());
                    dd.setFilterPath(TorrentOpener.getFilterPathData());
                    dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                    String path = dd.open();
                    if (path != null) {
                        TorrentOpener.setFilterPathData(path);
                        File target = new File(path);
                        for (int i = 0; i < dms.length; ++i) {
                            try {
                                ((DownloadManager)dms[i]).moveDataFiles(target);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(true, "Download data move operation failed", e));
                            }
                        }
                    }
                }
            }
        });
        itemFileMoveData.setEnabled(fileMove);
        MenuItem itemFileMoveTorrent = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveTorrent, "MyTorrentsView.menu.movetorrent");
        itemFileMoveTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Object[] dms = MyTorrentsView.this.getSelectedDataSources();
                if (dms != null && dms.length > 0) {
                    DirectoryDialog dd = new DirectoryDialog(MyTorrentsView.this.getComposite().getShell());
                    dd.setFilterPath(TorrentOpener.getFilterPathTorrent());
                    dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                    String path = dd.open();
                    if (path != null) {
                        File target = new File(path);
                        TorrentOpener.setFilterPathTorrent(target.toString());
                        for (int i = 0; i < dms.length; ++i) {
                            try {
                                ((DownloadManager)dms[i]).moveTorrentFile(target);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(true, "Download torrent move operation failed", e));
                            }
                        }
                    }
                }
            }
        });
        itemFileMoveTorrent.setEnabled(fileMove);
        final MenuItem itemFileRescan = new MenuItem(menuFiles, 32);
        Messages.setLanguageText((Widget)itemFileRescan, "MyTorrentsView.menu.rescanfile");
        itemFileRescan.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                dm.getDownloadState().setFlag(2L, itemFileRescan.getSelection());
            }
        });
        itemFileRescan.setSelection(allScanSelected);
        itemFileRescan.setEnabled(fileRescan);
        if (this.userMode > 0) {
            MenuItem itemExport = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemExport, "MyTorrentsView.menu.exportmenu");
            Utils.setMenuItemImage(itemExport, "export");
            itemExport.setEnabled(hasSelection);
            Menu menuExport = new Menu((Decorations)this.getComposite().getShell(), 4);
            itemExport.setMenu(menuExport);
            final MenuItem itemExportXML = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportXML, "MyTorrentsView.menu.export");
            itemExportXML.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DownloadManager dm = (DownloadManager)MyTorrentsView.this.getFirstSelectedDataSource();
                    if (dm != null) {
                        new ExportTorrentWizard(MyTorrentsView.this.azureus_core, itemExportXML.getDisplay(), dm);
                    }
                }
            });
            MenuItem itemExportTorrent = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportTorrent, "MyTorrentsView.menu.exporttorrent");
            itemExportTorrent.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DownloadManager dm = (DownloadManager)MyTorrentsView.this.getFirstSelectedDataSource();
                    if (dm != null) {
                        FileDialog fd = new FileDialog(MyTorrentsView.this.getComposite().getShell(), 8192);
                        fd.setFileName(dm.getTorrentFileName());
                        String path = fd.open();
                        if (path != null) {
                            try {
                                File target = new File(path);
                                if (target.exists()) {
                                    MessageBox mb = new MessageBox(MyTorrentsView.this.getComposite().getShell(), 196);
                                    mb.setText(MessageText.getString("exportTorrentWizard.process.outputfileexists.title"));
                                    mb.setMessage(MessageText.getString("exportTorrentWizard.process.outputfileexists.message"));
                                    int result = mb.open();
                                    if (result == 128) {
                                        return;
                                    }
                                    if (!target.delete()) {
                                        throw new Exception("Failed to delete file");
                                    }
                                }
                                TorrentUtils.copyToFile(dm.getDownloadState().getTorrent(), target);
                                TOTorrent dest = TOTorrentFactory.deserialiseFromBEncodedFile(target);
                                dest.removeAdditionalProperties();
                                dest.serialiseToBEncodedFile(target);
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(false, "Torrent export failed", e));
                            }
                        }
                    }
                }
            });
        }
        if (this.userMode > 0) {
            MenuItem itemPeerSource = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemPeerSource, "MyTorrentsView.menu.peersource");
            Menu menuPeerSource = new Menu((Decorations)this.getComposite().getShell(), 4);
            itemPeerSource.setMenu(menuPeerSource);
            for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                boolean bEnabled;
                final String p = PEPeerSource.PS_SOURCES[i];
                msg_text = "ConfigView.section.connection.peersource." + p;
                final MenuItem itemPS = new MenuItem(menuPeerSource, 32);
                itemPS.setData("peerSource", (Object)p);
                Messages.setLanguageText((Widget)itemPS, msg_text);
                itemPS.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        ((DownloadManager)row.getDataSource(true)).getDownloadState().setPeerSourceEnabled(p, itemPS.getSelection());
                    }
                });
                itemPS.setSelection(true);
                bChecked = hasSelection;
                boolean bl = bEnabled = !hasSelection;
                if (bChecked) {
                    bEnabled = true;
                    for (int j = 0; j < dms.length; ++j) {
                        DownloadManager dm = (DownloadManager)dms[j];
                        if (!dm.getDownloadState().isPeerSourceEnabled(p)) {
                            bChecked = false;
                        }
                        if (dm.getDownloadState().isPeerSourcePermitted(p)) continue;
                        bEnabled = false;
                    }
                }
                itemPS.setSelection(bChecked);
                itemPS.setEnabled(bEnabled);
            }
        }
        if (this.userMode > 1) {
            MenuItem itemNetworks = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemNetworks, "MyTorrentsView.menu.networks");
            Menu menuNetworks = new Menu((Decorations)this.getComposite().getShell(), 4);
            itemNetworks.setMenu(menuNetworks);
            for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                final String nn = AENetworkClassifier.AT_NETWORKS[i];
                msg_text = "ConfigView.section.connection.networks." + nn;
                final MenuItem itemNetwork = new MenuItem(menuNetworks, 32);
                itemNetwork.setData("network", (Object)nn);
                Messages.setLanguageText((Widget)itemNetwork, msg_text);
                itemNetwork.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        ((DownloadManager)row.getDataSource(true)).getDownloadState().setNetworkEnabled(nn, itemNetwork.getSelection());
                    }
                });
                bChecked = hasSelection;
                if (bChecked) {
                    for (int j = 0; j < dms.length; ++j) {
                        DownloadManager dm = (DownloadManager)dms[j];
                        if (dm.getDownloadState().isNetworkEnabled(nn)) continue;
                        bChecked = false;
                        break;
                    }
                }
                itemNetwork.setSelection(bChecked);
            }
        }
        MenuItem itemPositionManual = new MenuItem(menuAdvanced, 8);
        Messages.setLanguageText((Widget)itemPositionManual, "MyTorrentsView.menu.reposition.manual");
        itemPositionManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputShell is = new InputShell("MyTorrentsView.dialog.setPosition.title", "MyTorrentsView.dialog.setPosition.text");
                String sReturn = is.open();
                if (sReturn == null) {
                    return;
                }
                int newPosition = -1;
                try {
                    newPosition = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    // empty catch block
                }
                int size = MyTorrentsView.this.globalManager.downloadManagerCount(MyTorrentsView.this.isSeedingView);
                if (newPosition > size) {
                    newPosition = size;
                }
                if (newPosition <= 0) {
                    MessageBox mb = new MessageBox(MyTorrentsView.this.getComposite().getShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                MyTorrentsView.this.moveSelectedTorrentsTo(newPosition);
            }
        });
        if (this.userMode > 0 && this.isTrackerOn) {
            MenuItem itemHost = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemHost, "MyTorrentsView.menu.host");
            Utils.setMenuItemImage(itemHost, "host");
            itemHost.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    MyTorrentsView.this.hostSelectedTorrents();
                }
            });
            MenuItem itemPublish = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPublish, "MyTorrentsView.menu.publish");
            Utils.setMenuItemImage(itemPublish, "publish");
            itemPublish.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    MyTorrentsView.this.publishSelectedTorrents();
                }
            });
            itemHost.setEnabled(hasSelection);
            itemPublish.setEnabled(hasSelection);
        }
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        itemCategory.setEnabled(hasSelection);
        this.addCategorySubMenu();
        MenuItem itemRename = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemRename, "MyTorrentsView.menu.rename");
        itemRename.setEnabled(hasSelection);
        Menu menuRename = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemRename.setMenu(menuRename);
        DownloadManager first_selected = (DownloadManager)this.getFirstSelectedDataSource();
        MenuItem itemRenameDisplayed = new MenuItem(menuRename, 64);
        Messages.setLanguageText((Widget)itemRenameDisplayed, "MyTorrentsView.menu.rename.displayed");
        itemRenameDisplayed.setEnabled(hasSelection);
        if (itemRenameDisplayed.isEnabled()) {
            itemRenameDisplayed.setData("suggested_text", (Object)first_selected.getDisplayName());
            itemRenameDisplayed.setData("display_name", (Object)true);
            itemRenameDisplayed.setData("save_name", (Object)false);
            itemRenameDisplayed.setData("msg_key", (Object)"displayed");
        }
        MenuItem itemRenameSavePath = new MenuItem(menuRename, 64);
        Messages.setLanguageText((Widget)itemRenameSavePath, "MyTorrentsView.menu.rename.save_path");
        itemRenameSavePath.setEnabled(fileMove && dms.length == 1);
        if (itemRenameSavePath.isEnabled()) {
            itemRenameSavePath.setData("suggested_text", (Object)first_selected.getAbsoluteSaveLocation().getName());
            itemRenameSavePath.setData("display_name", (Object)false);
            itemRenameSavePath.setData("save_name", (Object)true);
            itemRenameSavePath.setData("msg_key", (Object)"save_path");
        }
        MenuItem itemRenameBoth = new MenuItem(menuRename, 64);
        Messages.setLanguageText((Widget)itemRenameBoth, "MyTorrentsView.menu.rename.displayed_and_save_path");
        itemRenameBoth.setEnabled(fileMove && dms.length == 1);
        if (itemRenameBoth.isEnabled()) {
            itemRenameBoth.setData("suggested_text", (Object)first_selected.getAbsoluteSaveLocation().getName());
            itemRenameBoth.setData("display_name", (Object)true);
            itemRenameBoth.setData("save_name", (Object)true);
            itemRenameBoth.setData("msg_key", (Object)"displayed_and_save_path");
        }
        Listener rename_listener = new Listener(){

            public void handleEvent(Event event2) {
                MenuItem mi = (MenuItem)event2.widget;
                String suggested = (String)mi.getData("suggested_text");
                boolean change_displayed_name = (Boolean)mi.getData("display_name");
                boolean change_save_name = (Boolean)mi.getData("save_name");
                String msg_key_prefix = "MyTorrentsView.menu.rename." + (String)mi.getData("msg_key") + ".enter.";
                SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow(MyTorrentsView.this.getComposite().getDisplay(), msg_key_prefix + "title", msg_key_prefix + "message", suggested, null);
                if (text_entry.wasDataSubmitted()) {
                    String value = text_entry.getStoredString();
                    String value_to_set = value.length() == 0 ? null : value;
                    MyTorrentsView.this.runForSelectedRows(new TableView.GroupTableRowRunner(this, change_displayed_name, value_to_set, change_save_name){
                        private final /* synthetic */ boolean val$change_displayed_name;
                        private final /* synthetic */ String val$value_to_set;
                        private final /* synthetic */ boolean val$change_save_name;
                        private final /* synthetic */ 37 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$change_displayed_name = val$change_displayed_name;
                            this.val$value_to_set = val$value_to_set;
                            this.val$change_save_name = val$change_save_name;
                            super(37.access$2300(this$1));
                        }

                        public void run(TableRowCore row) {
                            DownloadManager dm = (DownloadManager)row.getDataSource(true);
                            if (this.val$change_displayed_name) {
                                dm.getDownloadState().setDisplayName(this.val$value_to_set);
                            }
                            if (this.val$change_save_name) {
                                try {
                                    dm.renameDownload(this.val$value_to_set == null ? dm.getDisplayName() : this.val$value_to_set);
                                }
                                catch (Exception e) {
                                    Logger.log(new LogAlert(true, "Download data rename operation failed", e));
                                }
                            }
                        }
                    });
                }
            }

            static /* synthetic */ MyTorrentsView access$2300(37 x0) {
                return x0.MyTorrentsView.this;
            }
        };
        itemRenameDisplayed.addListener(13, rename_listener);
        itemRenameSavePath.addListener(13, rename_listener);
        itemRenameBoth.addListener(13, rename_listener);
        new MenuItem(menu, 2);
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTorrentsView.this.queueSelectedTorrents();
            }
        });
        itemQueue.setEnabled(start);
        if (this.userMode > 0) {
            final MenuItem itemForceStart = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)itemForceStart, "MyTorrentsView.menu.forceStart");
            Utils.setMenuItemImage(itemForceStart, "forcestart");
            itemForceStart.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

                public void run(TableRowCore row) {
                    DownloadManager dm = (DownloadManager)row.getDataSource(true);
                    if (ManagerUtils.isForceStartable(dm)) {
                        dm.setForceStart(itemForceStart.getSelection());
                    }
                }
            });
            itemForceStart.setSelection(forceStart);
            itemForceStart.setEnabled(forceStartEnabled);
        }
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTorrentsView.this.stopSelectedTorrents();
            }
        });
        itemStop.setEnabled(stop);
        MenuItem itemRecheck = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRecheck, "MyTorrentsView.menu.recheck");
        Utils.setMenuItemImage(itemRecheck, "recheck");
        itemRecheck.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
        itemRecheck.setEnabled(recheck);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        itemRemove.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), false, false);
            }
        });
        itemRemove.setEnabled(hasSelection);
        MenuItem itemRemoveAnd = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemRemoveAnd, "MyTorrentsView.menu.removeand");
        Utils.setMenuItemImage(itemRemoveAnd, "delete");
        itemRemoveAnd.setEnabled(hasSelection);
        Menu menuRemove = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemRemoveAnd.setMenu(menuRemove);
        MenuItem itemDeleteTorrent = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteTorrent, "MyTorrentsView.menu.removeand.deletetorrent");
        itemDeleteTorrent.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), true, false);
            }
        });
        MenuItem itemDeleteData = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteData, "MyTorrentsView.menu.removeand.deletedata");
        itemDeleteData.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), false, true);
            }
        });
        MenuItem itemDeleteBoth = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteBoth, "MyTorrentsView.menu.removeand.deleteboth");
        itemDeleteBoth.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), true, true);
            }
        });
    }

    public void fillMenu(Menu menu) {
        boolean hasSelection;
        Object[] dms = this.getSelectedDataSources();
        boolean bl = hasSelection = dms.length > 0;
        if (hasSelection) {
            this.fillTorrentMenu(menu);
            new MenuItem(menu, 2);
        }
        MenuItem itemFilter = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemFilter, "MyTorrentsView.menu.filter");
        itemFilter.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.openFilterDialog();
            }
        });
        super.fillMenu(menu);
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTorrentsView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTorrentsView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.addCategory();
            }
        });
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        final Table table = this.getTable();
        if (sColumnName.equals("health")) {
            MenuItem item = new MenuItem(menuThisColumn, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.health");
            Utils.setMenuItemImage(item, "st_explain");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(table.getDisplay());
                }
            });
        } else if (sColumnName.equals("maxuploads")) {
            int iStart = COConfigurationManager.getIntParameter("Max Uploads") - 2;
            if (iStart < 2) {
                iStart = 2;
            }
            for (int i = iStart; i < iStart + 6; ++i) {
                MenuItem item = new MenuItem(menuThisColumn, 8);
                item.setText(String.valueOf(i));
                item.setData("MaxUploads", (Object)new Long(i));
                item.addListener(13, (Listener)new TableView.SelectedTableRowsListener(){

                    public void run(TableRowCore row) {
                        DownloadManager dm = (DownloadManager)row.getDataSource(true);
                        MenuItem item = (MenuItem)this.event.widget;
                        if (item != null) {
                            int value = ((Long)item.getData("MaxUploads")).intValue();
                            dm.setMaxUploads(value);
                        }
                    }
                });
            }
        }
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                this.dropTarget.dispose();
            }
            this.dragSource = new DragSource((Control)this.getTable(), 2);
            this.dragSource.setTransfer(types);
            this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

                public void dragStart(DragSourceEvent event2) {
                    Table table = MyTorrentsView.this.getTable();
                    if (table.getSelectionCount() != 0) {
                        event2.doit = true;
                        MyTorrentsView.this.drag_drop_line_start = table.getSelectionIndex();
                    } else {
                        event2.doit = false;
                        MyTorrentsView.this.drag_drop_line_start = -1;
                    }
                }

                public void dragSetData(DragSourceEvent event2) {
                    event2.data = "moveRow";
                }
            });
            this.dropTarget = new DropTarget((Control)this.getTable(), 31);
            if (SWT.getVersion() >= 3107) {
                this.dropTarget.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
            } else {
                this.dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
            }
            this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void dropAccept(DropTargetEvent event2) {
                    event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                }

                public void dragEnter(DropTargetEvent event2) {
                    if (MyTorrentsView.this.drag_drop_line_start < 0) {
                        if (event2.detail != 1) {
                            if ((event2.operations & 4) > 0) {
                                event2.detail = 4;
                            } else if ((event2.operations & 1) > 0) {
                                event2.detail = 1;
                            }
                        }
                    } else if (TextTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                        event2.feedback = 31;
                        event2.detail = event2.item == null ? 0 : 2;
                    }
                }

                public void drop(DropTargetEvent event2) {
                    if (!(event2.data instanceof String) || !((String)event2.data).equals("moveRow")) {
                        TorrentOpener.openDroppedTorrents(MyTorrentsView.this.azureus_core, event2, true);
                        return;
                    }
                    if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                        event2.detail = 0;
                        if (event2.item == null) {
                            return;
                        }
                        int drag_drop_line_end = MyTorrentsView.this.getTable().indexOf((TableItem)event2.item);
                        MyTorrentsView.this.moveSelectedTorrents(MyTorrentsView.this.drag_drop_line_start, drag_drop_line_end);
                        MyTorrentsView.this.drag_drop_line_start = -1;
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LOGID, "failed to init drag-n-drop", t));
        }
    }

    private void moveSelectedTorrents(int drag_drop_line_start, int drag_drop_line_end) {
        if (drag_drop_line_end == drag_drop_line_start) {
            return;
        }
        TableItem ti = this.getTable().getItem(drag_drop_line_end);
        TableRowCore row = (TableRowCore)ti.getData("TableRow");
        DownloadManager dm = (DownloadManager)row.getDataSource(true);
        this.moveSelectedTorrentsTo(dm.getPosition());
    }

    private void moveSelectedTorrentsTo(int iNewPos) {
        List list = this.getSelectedRowsList();
        if (list.size() == 0) {
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            TableRowCore row = (TableRowCore)iter.next();
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            int iOldPos = dm.getPosition();
            this.globalManager.moveTo(dm, iNewPos);
            if (this.rowSorter.isAscending()) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        boolean bForceSort = this.rowSorter.getColumnName().equals("#");
        this.columnInvalidate("#");
        this.refresh(bForceSort);
    }

    public void refresh(boolean bForceSort) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
        super.refresh(bForceSort);
    }

    public void delete() {
        super.delete();
        if (this.dragSource != null && !this.dragSource.isDisposed()) {
            this.dragSource.dispose();
            this.dragSource = null;
        }
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.dispose();
            this.dropTarget = null;
        }
        if (this.fontButton != null && !this.fontButton.isDisposed()) {
            this.fontButton.dispose();
            this.fontButton = null;
        }
        CategoryManager.removeCategoryManagerListener(this);
        this.globalManager.removeListener(this);
        COConfigurationManager.removeParameterListener("Confirm Data Delete", this);
    }

    public void keyPressed(KeyEvent e) {
        int key = e.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (e.stateMask == 393216) {
            if (key == 115) {
                ManagerUtils.asyncStopAll();
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000002) {
                this.moveSelectedTorrents(10);
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000001) {
                this.moveSelectedTorrents(-10);
                e.doit = false;
                return;
            }
        }
        if (e.stateMask == SWT.MOD1) {
            switch (key) {
                case 97: {
                    if (e.widget != this.getTable()) break;
                    this.getTable().selectAll();
                    e.doit = false;
                    break;
                }
                case 99: {
                    if (e.widget != this.getTable()) break;
                    this.clipboardSelected();
                    e.doit = false;
                    break;
                }
                case 102: {
                    this.openFilterDialog();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 262144) {
            switch (e.keyCode) {
                case 0x1000001: {
                    this.moveSelectedTorrentsUp();
                    e.doit = false;
                    break;
                }
                case 0x1000002: {
                    this.moveSelectedTorrentsDown();
                    e.doit = false;
                    break;
                }
                case 0x1000007: {
                    this.moveSelectedTorrentsTop();
                    e.doit = false;
                    break;
                }
                case 0x1000008: {
                    this.moveSelectedTorrentsEnd();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
            switch (key) {
                case 114: {
                    this.resumeSelectedTorrents();
                    e.doit = false;
                    break;
                }
                case 115: {
                    this.stopSelectedTorrents();
                    e.doit = false;
                    break;
                }
                case 120: {
                    this.bRegexSearch = !this.bRegexSearch;
                    e.doit = false;
                    this.updateLastSearch();
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 0 && e.keyCode == 127 && e.widget == this.getTable()) {
            this.removeSelectedTorrents();
            e.doit = false;
            return;
        }
        if (e.keyCode != 8 && ((e.stateMask & 0xFFFDFFFF) != 0 || e.character < ' ')) {
            return;
        }
        if (e.widget == this.txtFilter) {
            return;
        }
        if (e.keyCode == 8) {
            if (e.stateMask == 262144) {
                this.sLastSearch = "";
            } else if (this.sLastSearch.length() > 0) {
                this.sLastSearch = this.sLastSearch.substring(0, this.sLastSearch.length() - 1);
            }
        } else {
            this.sLastSearch = this.sLastSearch + String.valueOf(e.character);
        }
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            this.txtFilter.setFocus();
        }
        this.updateLastSearch();
        e.doit = false;
    }

    private void openFilterDialog() {
        InputShell is = new InputShell("MyTorrentsView.dialog.setFilter.title", "MyTorrentsView.dialog.setFilter.text");
        is.setTextValue(this.sLastSearch);
        is.setLabelParameters(new String[]{MessageText.getString(this.sTableID + "View.header")});
        String sReturn = is.open();
        if (sReturn == null) {
            return;
        }
        this.sLastSearch = sReturn;
        this.updateLastSearch();
    }

    private void updateLastSearch() {
        if (this.lblHeader == null || this.lblHeader.isDisposed()) {
            this.createTabs();
        }
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            if (!this.sLastSearch.equals(this.txtFilter.getText())) {
                this.txtFilter.setText(this.sLastSearch);
                this.txtFilter.setSelection(this.sLastSearch.length());
            }
            if (this.sLastSearch.length() > 0) {
                if (this.bRegexSearch) {
                    try {
                        Pattern.compile(this.sLastSearch, 2);
                        this.txtFilter.setBackground(Colors.colorAltRow);
                        Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                    }
                    catch (Exception e) {
                        this.txtFilter.setBackground(Colors.colorErrorBG);
                        this.txtFilter.setToolTipText(e.getMessage());
                    }
                } else {
                    this.txtFilter.setBackground(null);
                    Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                }
            }
        }
        if (this.lblX != null && !this.lblX.isDisposed()) {
            Image img = ImageRepository.getImage(this.sLastSearch.length() > 0 ? "smallx" : "smallx-gray");
            this.lblX.setImage(img);
        }
        this.activateCategory(this.currentCategory);
    }

    public void keyReleased(KeyEvent e) {
    }

    private void changeDirSelectedTorrents() {
        File f;
        String sDefPath;
        Object[] dataSources = this.getSelectedDataSources();
        if (dataSources.length <= 0) {
            return;
        }
        String string = sDefPath = COConfigurationManager.getBooleanParameter("Use default data dir") ? COConfigurationManager.getStringParameter("Default save path", "") : "";
        if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
            f.mkdirs();
        }
        DirectoryDialog dDialog = new DirectoryDialog(this.cTablePanel.getShell(), 131072);
        dDialog.setFilterPath(sDefPath);
        dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath"));
        String sSavePath = dDialog.open();
        if (sSavePath != null) {
            for (int i = 0; i < dataSources.length; ++i) {
                DownloadManager dm = (DownloadManager)dataSources[i];
                if (dm.getState() != 100) continue;
                dm.setTorrentSaveDir(sSavePath);
                if (!dm.filesExist()) continue;
                dm.stopIt(70, false, false);
                ManagerUtils.queue(dm, this.cTablePanel);
            }
        }
    }

    private void removeTorrent(final DownloadManager dm, final boolean bDeleteTorrent, final boolean bDeleteData) {
        int choice;
        if (COConfigurationManager.getBooleanParameter("confirm_torrent_removal")) {
            MessageBox mb = new MessageBox(this.cTablePanel.getShell(), 200);
            mb.setText(MessageText.getString("deletedata.title"));
            mb.setMessage(MessageText.getString("deletetorrent.message1") + dm.getDisplayName() + " :\n" + dm.getTorrentFileName() + MessageText.getString("deletetorrent.message2"));
            if (mb.open() == 128) {
                return;
            }
        }
        if (this.confirmDataDelete && bDeleteData) {
            String path = dm.getSaveLocation().toString();
            MessageBox mb = new MessageBox(this.cTablePanel.getShell(), 200);
            mb.setText(MessageText.getString("deletedata.title"));
            mb.setMessage(MessageText.getString("deletedata.message1") + dm.getDisplayName() + " :\n" + path + MessageText.getString("deletedata.message2"));
            choice = mb.open();
        } else {
            choice = 64;
        }
        if (choice == 64) {
            new AEThread("asyncStop", true){

                public void runSupport() {
                    try {
                        dm.stopIt(70, bDeleteTorrent, bDeleteData);
                        dm.getGlobalManager().removeDownloadManager(dm);
                    }
                    catch (GlobalManagerDownloadRemovalVetoException f) {
                        if (!f.isSilent()) {
                            Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", f);
                        }
                    }
                    catch (Exception ex) {
                        Debug.printStackTrace(ex);
                    }
                }
            }.start();
        }
    }

    private void removeSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), false, false);
            }
        });
    }

    private void stopSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                ManagerUtils.stop((DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
    }

    private void queueSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                ManagerUtils.queue((DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
    }

    private void resumeSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                ManagerUtils.start((DownloadManager)row.getDataSource(true));
            }
        });
    }

    private void hostSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                ManagerUtils.host(MyTorrentsView.this.azureus_core, (DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.showMyTracker();
        }
    }

    private void publishSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                ManagerUtils.publish(MyTorrentsView.this.azureus_core, (DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.showMyTracker();
        }
    }

    private void runSelectedTorrents() {
        Object[] dataSources = this.getSelectedDataSources();
        for (int i = dataSources.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (dm == null) continue;
            ManagerUtils.run(dm);
        }
    }

    private void openSelectedTorrents() {
        Object[] dataSources = this.getSelectedDataSources();
        for (int i = dataSources.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (dm == null) continue;
            ManagerUtils.open(dm);
        }
    }

    private void moveSelectedTorrentsDown() {
        Object[] dataSources = this.getSelectedDataSources();
        Arrays.sort(dataSources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
            }
        });
        for (int i = dataSources.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!dm.getGlobalManager().isMoveableDown(dm)) continue;
            dm.getGlobalManager().moveDown(dm);
        }
        boolean bForceSort = this.rowSorter.getColumnName().equals("#");
        this.columnInvalidate("#");
        this.refresh(bForceSort);
    }

    private void moveSelectedTorrentsUp() {
        Object[] dataSources = this.getSelectedDataSources();
        Arrays.sort(dataSources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
            }
        });
        for (int i = 0; i < dataSources.length; ++i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!dm.getGlobalManager().isMoveableUp(dm)) continue;
            dm.getGlobalManager().moveUp(dm);
        }
        boolean bForceSort = this.rowSorter.getColumnName().equals("#");
        this.columnInvalidate("#");
        this.refresh(bForceSort);
    }

    private void moveSelectedTorrents(int by) {
        DownloadManager dm;
        int i;
        Object[] dataSources = this.getSelectedDataSources();
        if (dataSources.length <= 0) {
            return;
        }
        int[] newPositions = new int[dataSources.length];
        if (by < 0) {
            Arrays.sort(dataSources, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                }
            });
        } else {
            Arrays.sort(dataSources, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((DownloadManager)b).getPosition() - ((DownloadManager)a).getPosition();
                }
            });
        }
        int count = this.globalManager.downloadManagerCount(this.isSeedingView);
        for (i = 0; i < dataSources.length; ++i) {
            dm = (DownloadManager)dataSources[i];
            int pos = dm.getPosition() + by;
            if (pos < i + 1) {
                pos = i + 1;
            } else if (pos > count - i) {
                pos = count - i;
            }
            newPositions[i] = pos;
        }
        for (i = 0; i < dataSources.length; ++i) {
            dm = (DownloadManager)dataSources[i];
            this.globalManager.moveTo(dm, newPositions[i]);
        }
        boolean bForceSort = this.rowSorter.getColumnName().equals("#");
        this.columnInvalidate("#");
        this.refresh(bForceSort);
    }

    private void moveSelectedTorrentsTop() {
        this.moveSelectedTorrentsTopOrEnd(true);
    }

    private void moveSelectedTorrentsEnd() {
        this.moveSelectedTorrentsTopOrEnd(false);
    }

    private void moveSelectedTorrentsTopOrEnd(boolean moveToTop) {
        DownloadManager[] downloadManagers = (DownloadManager[])this.getSelectedDataSources(new DownloadManager[0]);
        if (downloadManagers.length == 0) {
            return;
        }
        if (moveToTop) {
            this.globalManager.moveTop(downloadManagers);
        } else {
            this.globalManager.moveEnd(downloadManagers);
        }
        if (this.rowSorter.getColumnName().equals("#")) {
            this.columnInvalidate("#");
            this.refresh(true);
        }
    }

    public void parameterChanged(String parameterName) {
        super.parameterChanged(parameterName);
        this.confirmDataDelete = COConfigurationManager.getBooleanParameter("Confirm Data Delete", true);
        this.userMode = COConfigurationManager.getIntParameter("User Mode");
    }

    private void computePossibleActions() {
        Object[] dataSources = this.getSelectedDataSources();
        this.remove = dataSources.length > 0;
        this.run = this.remove;
        this.down = this.remove;
        this.up = this.remove;
        this.publish = false;
        this.host = false;
        this.stop = false;
        this.start = false;
        this.bottom = false;
        this.top = false;
        for (int i = 0; i < dataSources.length; ++i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!this.start && ManagerUtils.isStartable(dm)) {
                this.start = true;
            }
            if (!this.stop && ManagerUtils.isStopable(dm)) {
                this.stop = true;
            }
            if (!this.top && dm.getGlobalManager().isMoveableUp(dm)) {
                this.top = true;
            }
            if (!this.bottom && dm.getGlobalManager().isMoveableDown(dm)) {
                this.bottom = true;
            }
            if (this.userMode <= 0 || !this.isTrackerOn) continue;
            this.publish = true;
            this.host = true;
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("run")) {
            return this.run;
        }
        if (itemKey.equals("host")) {
            return this.host;
        }
        if (itemKey.equals("publish")) {
            return this.publish;
        }
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        if (itemKey.equals("top")) {
            return this.top;
        }
        if (itemKey.equals("bottom")) {
            return this.bottom;
        }
        if (itemKey.equals("up")) {
            return this.up;
        }
        if (itemKey.equals("down")) {
            return this.down;
        }
        if (itemKey.equals("send")) {
            return this.run;
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("top")) {
            this.moveSelectedTorrentsTop();
            return;
        }
        if (itemKey.equals("bottom")) {
            this.moveSelectedTorrentsEnd();
            return;
        }
        if (itemKey.equals("up")) {
            this.moveSelectedTorrentsUp();
            return;
        }
        if (itemKey.equals("down")) {
            this.moveSelectedTorrentsDown();
            return;
        }
        if (itemKey.equals("run")) {
            this.runSelectedTorrents();
            return;
        }
        if (itemKey.equals("host")) {
            this.hostSelectedTorrents();
            return;
        }
        if (itemKey.equals("publish")) {
            this.publishSelectedTorrents();
            return;
        }
        if (itemKey.equals("start")) {
            this.queueSelectedTorrents();
            return;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedTorrents();
            return;
        }
        if (itemKey.equals("remove")) {
            this.removeSelectedTorrents();
            return;
        }
        if (itemKey.equals("send")) {
            this.openSendTorrentWizForSelected();
            return;
        }
    }

    public void openSendTorrentWizForSelected() {
        Object[] dms = this.getSelectedDataSources();
        TOTorrent[] torrents = new TOTorrent[dms.length];
        for (int i = 0; i < torrents.length; ++i) {
            if (!(dms[i] instanceof DownloadManager)) continue;
            torrents[i] = ((DownloadManager)dms[i]).getTorrent();
        }
        new SendTorrentWizard(this.azureus_core, this.getTable().getDisplay(), torrents);
    }

    private Category addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(this.getComposite().getDisplay());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
        return newCategory;
    }

    public void downloadManagerAdded(Category category, DownloadManager manager) {
        if (this.isOurDownloadManager(manager)) {
            this.addDataSource(manager);
        }
    }

    public void downloadManagerRemoved(Category category, DownloadManager removed) {
        this.removeDataSource(removed);
    }

    public void stateChanged(DownloadManager manager, int state) {
        final TableRowCore row = this.getRow(manager);
        if (row != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    row.refresh(true);
                }
            });
        }
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
        if (this.isOurDownloadManager(manager)) {
            if (this.currentCategory == null || this.currentCategory.getType() == 1) {
                this.addDataSource(manager);
            } else {
                int catType = this.currentCategory.getType();
                Category manager_category = manager.getDownloadState().getCategory();
                if (manager_category == null) {
                    if (catType == 2) {
                        this.addDataSource(manager);
                    }
                } else if (this.currentCategory.getName().equals(manager_category.getName())) {
                    this.addDataSource(manager);
                }
            }
        } else if (this.isSeedingView && !bCompleted || !this.isSeedingView && bCompleted) {
            this.removeDataSource(manager);
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    private void assignSelectedToCategory(final Category category) {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                ((DownloadManager)row.getDataSource(true)).getDownloadState().setCategory(category);
            }
        });
    }

    private void activateCategory(Category category) {
        if (category != this.currentCategory) {
            if (this.currentCategory != null) {
                this.currentCategory.removeCategoryListener(this);
            }
            if (category != null) {
                category.addCategoryListener(this);
            }
            this.currentCategory = category;
        }
        Object[] managers = this.globalManager.getDownloadManagers().toArray();
        List<Object> list = Arrays.asList(this.getDataSources());
        for (int i = 0; i < managers.length; ++i) {
            DownloadManager dm = (DownloadManager)managers[i];
            boolean bHave = list.contains(dm);
            if (!this.isOurDownloadManager(dm)) {
                if (!bHave) continue;
                this.removeDataSource(dm);
                continue;
            }
            if (bHave) continue;
            this.addDataSource(dm);
        }
        this.refreshTable(false);
    }

    private boolean isInCategory(DownloadManager manager, Category category) {
        if (category == null) {
            return true;
        }
        int type = category.getType();
        if (type == 1) {
            return true;
        }
        Category dmCategory = manager.getDownloadState().getCategory();
        if (dmCategory == null) {
            return type == 2;
        }
        return category.equals(dmCategory);
    }

    public void categoryAdded(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.createTabs();
            }
        });
    }

    public void categoryRemoved(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.createTabs();
            }
        });
    }

    public void downloadManagerAdded(DownloadManager dm) {
        dm.addListener(this);
        this.downloadManagerAdded(null, dm);
    }

    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removeListener(this);
        MinimizedWindow.close(dm);
        this.downloadManagerRemoved(null, dm);
    }

    public void destroyInitiated() {
    }

    public void destroyed() {
    }

    public void seedingStatusChanged(boolean seeding_only_mode) {
    }

    private void setSelectedTorrentsUpSpeed(int speed) {
        Object[] dms = this.getSelectedDataSources();
        if (dms.length > 0) {
            for (int i = 0; i < dms.length; ++i) {
                try {
                    DownloadManager dm = (DownloadManager)dms[i];
                    dm.getStats().setUploadRateLimitBytesPerSecond(speed);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private void setSelectedTorrentsDownSpeed(int speed) {
        Object[] dms = this.getSelectedDataSources();
        if (dms.length > 0) {
            for (int i = 0; i < dms.length; ++i) {
                try {
                    DownloadManager dm = (DownloadManager)dms[i];
                    dm.getStats().setDownloadRateLimitBytesPerSecond(speed);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public synchronized void addDataSources(Object[] dataSources) {
        super.addDataSources(dataSources);
        this.updateTableLabel();
    }

    public synchronized void removeDataSources(Object[] dataSources) {
        super.removeDataSources(dataSources);
        this.updateTableLabel();
    }

    public void processDataSourceQueue() {
        super.processDataSourceQueue();
        this.updateTableLabel();
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.updateTableLabel();
        this.getComposite().layout(true, true);
    }

    private void updateTableLabel() {
        if (this.lblHeader == null || this.lblHeader.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MyTorrentsView.this.lblHeader != null && !MyTorrentsView.this.lblHeader.isDisposed()) {
                    String sText = MessageText.getString(MyTorrentsView.this.sTableID + "View.header") + " (" + MyTorrentsView.this.getRowCount() + ")";
                    MyTorrentsView.this.lblHeader.setText(sText);
                    MyTorrentsView.this.lblHeader.getParent().layout();
                }
            }
        });
    }

    static /* synthetic */ void access$1000(MyTorrentsView x0) {
        x0.computePossibleActions();
    }
}

