/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class AuthenticatorWindow
implements SEPasswordListener {
    private static final String CONFIG_PARAM = "swt.auth.persistent.cache";
    protected Map auth_cache = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("AuthWind");

    public AuthenticatorWindow() {
        SESecurityManager.addPasswordListener(this);
        Map cache = COConfigurationManager.getMapParameter(CONFIG_PARAM, new HashMap());
        try {
            Iterator it = cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                String user = new String((byte[])value.get("user"), "UTF-8");
                char[] pw = new String((byte[])value.get("pw"), "UTF-8").toCharArray();
                this.auth_cache.put(key, new authCache(key, new PasswordAuthentication(user, pw), true));
            }
        }
        catch (Throwable e) {
            COConfigurationManager.setParameter(CONFIG_PARAM, new HashMap());
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAuthCache() {
        try {
            this.this_mon.enter();
            HashMap map = new HashMap();
            Iterator it = this.auth_cache.values().iterator();
            while (it.hasNext()) {
                authCache value = (authCache)it.next();
                if (!value.isPersistent()) continue;
                try {
                    HashMap<String, byte[]> entry_map = new HashMap<String, byte[]>();
                    entry_map.put("user", value.getAuth().getUserName().getBytes("UTF-8"));
                    entry_map.put("pw", new String(value.getAuth().getPassword()).getBytes("UTF-8"));
                    map.put(value.getKey(), entry_map);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            COConfigurationManager.setParameter(CONFIG_PARAM, map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPasswords() {
        try {
            this.this_mon.enter();
            this.auth_cache = new HashMap();
            this.saveAuthCache();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        try {
            this.this_mon.enter();
            PasswordAuthentication passwordAuthentication = this.getAuthentication(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort());
            return passwordAuthentication;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
        try {
            this.this_mon.enter();
            this.setAuthenticationOutcome(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort(), success);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationOutcome(String realm, String protocol, String host, int port, boolean success) {
        try {
            this.this_mon.enter();
            String tracker = protocol + "://" + host + ":" + port + "/";
            String auth_key = realm + ":" + tracker;
            authCache cache = (authCache)this.auth_cache.get(auth_key);
            if (cache != null) {
                cache.setOutcome(success);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Exception decompiling
     */
    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String[] getAuthenticationDialog(final String realm, final String tracker) {
        String persist;
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        final AESemaphore sem = new AESemaphore("SWTAuth");
        final authDialog[] dialog = new authDialog[1];
        TOTorrent torrent = TorrentUtils.getTLSTorrent();
        final String torrent_name = torrent == null ? null : TorrentUtils.getLocalisedName(torrent);
        try {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    dialog[0] = new authDialog(sem, display, realm, tracker, torrent_name);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
        sem.reserve();
        String user = dialog[0].getUsername();
        String pw = dialog[0].getPassword();
        String string = persist = dialog[0].savePassword() ? "true" : "false";
        if (user == null) {
            return null;
        }
        return new String[]{user, pw == null ? "" : pw, persist};
    }

    protected class authCache {
        private String key;
        private PasswordAuthentication auth;
        private boolean persist;
        private int life = 5;
        private boolean succeeded;

        protected authCache(String _key, PasswordAuthentication _auth, boolean _persist) {
            this.key = _key;
            this.auth = _auth;
            this.persist = _persist;
        }

        protected String getKey() {
            return this.key;
        }

        protected boolean isPersistent() {
            return this.persist;
        }

        protected void setOutcome(boolean success) {
            if (success) {
                this.succeeded = true;
            } else {
                if (this.persist) {
                    this.persist = false;
                    AuthenticatorWindow.this.saveAuthCache();
                }
                if (!this.succeeded) {
                    this.auth = null;
                }
            }
        }

        protected PasswordAuthentication getAuth() {
            if (this.succeeded) {
                return this.auth;
            }
            --this.life;
            if (this.life >= 0) {
                return this.auth;
            }
            if (this.persist) {
                this.persist = false;
                AuthenticatorWindow.this.saveAuthCache();
            }
            return null;
        }
    }

    protected class authDialog {
        private Shell shell;
        private AESemaphore sem;
        private String username;
        private String password;
        private boolean persist;

        protected authDialog(AESemaphore _sem, Display display, String realm, String tracker, String torrent_name) {
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.release();
                return;
            }
            this.shell = new Shell(display, 67680);
            if (!Constants.isOSX) {
                this.shell.setImage(ImageRepository.getImage("azureus"));
            }
            Messages.setLanguageText((Widget)this.shell, "authenticator.title");
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label realm_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)realm_label, "authenticator.realm");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            realm_label.setLayoutData((Object)gridData);
            Label realm_value = new Label((Composite)this.shell, 0);
            realm_value.setText(realm.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            realm_value.setLayoutData((Object)gridData);
            Label tracker_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)tracker_label, "authenticator.tracker");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            tracker_label.setLayoutData((Object)gridData);
            Label tracker_value = new Label((Composite)this.shell, 0);
            tracker_value.setText(tracker.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            tracker_value.setLayoutData((Object)gridData);
            if (torrent_name != null) {
                Label torrent_label = new Label((Composite)this.shell, 0);
                Messages.setLanguageText((Widget)torrent_label, "authenticator.torrent");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                torrent_label.setLayoutData((Object)gridData);
                Label torrent_value = new Label((Composite)this.shell, 0);
                torrent_value.setText(torrent_name.replaceAll("&", "&&"));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                torrent_value.setLayoutData((Object)gridData);
            }
            Label user_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)user_label, "authenticator.user");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            user_label.setLayoutData((Object)gridData);
            Text user_value = new Text((Composite)this.shell, 2048);
            user_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            user_value.setLayoutData((Object)gridData);
            user_value.addListener(24, new Listener(this, user_value){
                private final /* synthetic */ Text val$user_value;
                private final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$user_value = val$user_value;
                }

                public void handleEvent(Event event2) {
                    authDialog.access$002(this.this$1, this.val$user_value.getText());
                }
            });
            Label password_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)password_label, "authenticator.password");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            password_label.setLayoutData((Object)gridData);
            Text password_value = new Text((Composite)this.shell, 2048);
            password_value.setEchoChar('*');
            password_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            password_value.setLayoutData((Object)gridData);
            password_value.addListener(24, new Listener(this, password_value){
                private final /* synthetic */ Text val$password_value;
                private final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$password_value = val$password_value;
                }

                public void handleEvent(Event event2) {
                    authDialog.access$102(this.this$1, this.val$password_value.getText());
                }
            });
            Label blank_label = new Label((Composite)this.shell, 0);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            blank_label.setLayoutData((Object)gridData);
            Button checkBox = new Button((Composite)this.shell, 32);
            checkBox.setText(MessageText.getString("authenticator.savepassword"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            checkBox.setLayoutData((Object)gridData);
            checkBox.addListener(13, new Listener(this, checkBox){
                private final /* synthetic */ Button val$checkBox;
                private final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$checkBox = val$checkBox;
                }

                public void handleEvent(Event e) {
                    authDialog.access$202(this.this$1, this.val$checkBox.getSelection());
                }
            });
            Label labelSeparator = new Label((Composite)this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Button bOk = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bOk, "Button.ok");
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOk.setLayoutData((Object)gridData);
            bOk.addListener(13, new Listener(this){
                private final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(true);
                }
            });
            Button bCancel = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bCancel, "Button.cancel");
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bCancel.setLayoutData((Object)gridData);
            bCancel.addListener(13, new Listener(this){
                private final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(this){
                private final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.this$1.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            if (ok) {
                if (this.username == null) {
                    this.username = "";
                }
                if (this.password == null) {
                    this.password = "";
                }
            } else {
                this.username = null;
                this.password = null;
            }
            this.shell.dispose();
            this.sem.release();
        }

        protected String getUsername() {
            return this.username;
        }

        protected String getPassword() {
            return this.password;
        }

        protected boolean savePassword() {
            return this.persist;
        }

        static /* synthetic */ String access$002(authDialog x0, String x1) {
            x0.username = x1;
            return x0.username;
        }

        static /* synthetic */ String access$102(authDialog x0, String x1) {
            x0.password = x1;
            return x0.password;
        }

        static /* synthetic */ boolean access$202(authDialog x0, boolean x1) {
            x0.persist = x1;
            return x0.persist;
        }
    }
}

