/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;

public class StartServer {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String ACCESS_STRING = "Azureus Start Server Access";
    private ServerSocket socket;
    private int state;
    private boolean bContinue;
    public static final int STATE_FAULTY = 0;
    public static final int STATE_LISTENING = 1;
    protected List queued_torrents = new ArrayList();
    protected boolean core_started = false;
    protected AEMonitor this_mon = new AEMonitor("StartServer");

    public StartServer() {
        try {
            this.socket = new ServerSocket(6880, 50, InetAddress.getByName("127.0.0.1"));
            this.state = 1;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "StartServer: listening on 127.0.0.1:6880 for passed torrent info"));
            }
        }
        catch (Throwable t) {
            this.state = 0;
            String reason = t.getMessage() == null ? "<>" : t.getMessage();
            Logger.log(new LogEvent(LOGID, 3, "StartServer ERROR: unable to bind to 127.0.0.1:6880 listening for passed torrent info: " + reason));
        }
    }

    public void pollForConnections(final AzureusCore azureus_core) {
        azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void started(AzureusCore core) {
                StartServer.this.openQueuedTorrents(azureus_core);
            }
        });
        if (this.socket != null) {
            AEThread t = new AEThread("Start Server"){

                public void runSupport() {
                    StartServer.this.pollForConnectionsSupport(azureus_core);
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void pollForConnectionsSupport(AzureusCore azureus_core) {
        this.bContinue = true;
        while (this.bContinue) {
            BufferedReader br = null;
            Socket sck = this.socket.accept();
            String address = sck.getInetAddress().getHostAddress();
            if (address.equals("localhost") || address.equals("127.0.0.1")) {
                br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                String line = br.readLine();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Main::startServer: received '" + line + "'"));
                }
                if (line != null) {
                    StringTokenizer st = new StringTokenizer(line, ";");
                    int i = 0;
                    if (st.countTokens() > 1) {
                        String[] args = new String[st.countTokens() - 1];
                        String checker = st.nextToken();
                        if (checker.equals(ACCESS_STRING)) {
                            String debug_str = "";
                            while (st.hasMoreElements()) {
                                String bit = st.nextToken().replaceAll("&;", ";").replaceAll("&&", "&");
                                debug_str = debug_str + (debug_str.length() == 0 ? "" : " ; ") + bit;
                                args[i++] = bit;
                            }
                            Logger.log(new LogEvent(LOGID, "Main::startServer: decoded to '" + debug_str + "'"));
                            if (!COConfigurationManager.getBooleanParameter("add_torrents_silently")) {
                                this.showMainWindow();
                            }
                            this.processArgs(azureus_core, args);
                        }
                    }
                }
            }
            sck.close();
            Object var13_13 = null;
            try {
                if (br == null) continue;
                br.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    if (!(e instanceof SocketException)) {
                        Debug.printStackTrace(e);
                    }
                    var13_13 = null;
                    try {
                        if (br == null) continue;
                        br.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var13_13 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processArgs(AzureusCore azureus_core, String[] args) {
        if (args.length < 1 || !args[0].equals("args")) {
            return;
        }
        boolean open = true;
        for (int i = 1; i < args.length; ++i) {
            String file_name;
            String arg = args[i];
            if (i == 1) {
                if (arg.equalsIgnoreCase("--closedown")) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.requestShutdown();
                    }
                    return;
                }
                if (arg.equalsIgnoreCase("--open")) continue;
                if (arg.equalsIgnoreCase("--share")) {
                    open = false;
                    continue;
                }
            }
            if ((file_name = arg).toUpperCase().startsWith("HTTP:") || file_name.toUpperCase().startsWith("MAGNET:")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "StartServer: args[" + i + "] handling as a URI: " + file_name));
                }
            } else {
                try {
                    File file = new File(file_name);
                    if (!file.exists()) {
                        throw new Exception("File not found");
                    }
                    file_name = file.getCanonicalPath();
                    Logger.log(new LogEvent(LOGID, "StartServer: file = " + file_name));
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(true, 3, "Failed to access torrent file '" + file_name + "'. Ensure sufficient temporary file space " + "available (check browser cache usage)."));
                }
            }
            boolean queued = false;
            try {
                this.this_mon.enter();
                if (!this.core_started) {
                    this.queued_torrents.add(new Object[]{file_name, new Boolean(open)});
                    queued = true;
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (queued) continue;
            this.handleFile(azureus_core, file_name, open);
        }
    }

    protected void handleFile(AzureusCore azureus_core, String file_name, boolean open) {
        try {
            if (open) {
                TorrentOpener.openTorrent(file_name);
            } else {
                File f = new File(file_name);
                if (f.isDirectory()) {
                    ShareUtils.shareDir(azureus_core, file_name);
                } else {
                    ShareUtils.shareFile(azureus_core, file_name);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openQueuedTorrents(AzureusCore azureus_core) {
        try {
            this.this_mon.enter();
            this.core_started = true;
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < this.queued_torrents.size(); ++i) {
            Object[] entry = (Object[])this.queued_torrents.get(i);
            String file_name = (String)entry[0];
            boolean open = (Boolean)entry[1];
            this.handleFile(azureus_core, file_name, open);
        }
    }

    protected void showMainWindow() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.bringToFront();
        }
    }

    public void stopIt() {
        this.bContinue = false;
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getState() {
        return this.state;
    }
}

