/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.tracker;

import java.net.InetAddress;
import java.net.URL;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;
import org.gudy.azureus2.pluginsimpl.remote.tracker.RPTrackerTorrent;

public class RPTracker
extends RPObject
implements Tracker {
    protected transient Tracker delegate;

    public static RPTracker create(Tracker _delegate) {
        RPTracker res = (RPTracker)RPTracker._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTracker(_delegate);
        }
        return res;
    }

    protected RPTracker(Tracker _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (Tracker)_delegate;
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("host[Torrent,boolean]")) {
            try {
                Torrent torrent;
                Torrent torrent2 = torrent = params[0] == null ? null : (Torrent)((RPTorrent)params[0])._setLocal();
                if (torrent == null) {
                    throw new RPException("Invalid torrent");
                }
                TrackerTorrent tt = this.delegate.host(torrent, (Boolean)params[1]);
                RPTrackerTorrent res = RPTrackerTorrent.create(tt);
                return new RPReply(res);
            }
            catch (TrackerException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("getTorrents")) {
            TrackerTorrent[] torrents = this.delegate.getTorrents();
            RPTrackerTorrent[] res = new RPTrackerTorrent[torrents.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = RPTrackerTorrent.create(torrents[i]);
            }
            return new RPReply(res);
        }
        throw new RPException("Unknown method: " + method);
    }

    public TrackerTorrent host(Torrent torrent, boolean persistent) throws TrackerException {
        try {
            RPTrackerTorrent resp = (RPTrackerTorrent)this._dispatcher.dispatch(new RPRequest(this, "host[Torrent,boolean]", new Object[]{torrent, new Boolean(persistent)})).getResponse();
            resp._setRemote(this._dispatcher);
            return resp;
        }
        catch (RPException e) {
            if (e.getCause() instanceof TrackerException) {
                throw (TrackerException)e.getCause();
            }
            throw e;
        }
    }

    public TrackerTorrent host(Torrent torrent, boolean persistent, boolean passive) throws TrackerException {
        this.notSupported();
        return null;
    }

    public TrackerTorrent publish(Torrent torrent) throws TrackerException {
        this.notSupported();
        return null;
    }

    public TrackerTorrent[] getTorrents() {
        TrackerTorrent[] res = (RPTrackerTorrent[])this._dispatcher.dispatch(new RPRequest(this, "getTorrents", null)).getResponse();
        for (int i = 0; i < res.length; ++i) {
            ((RPTrackerTorrent)res[i])._setRemote(this._dispatcher);
        }
        return res;
    }

    public TrackerTorrent getTorrent(Torrent t) {
        this.notSupported();
        return null;
    }

    public TrackerWebContext createWebContext(int port, int protocol) throws TrackerException {
        this.notSupported();
        return null;
    }

    public TrackerWebContext createWebContext(String name, int port, int protocol) throws TrackerException {
        this.notSupported();
        return null;
    }

    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip) throws TrackerException {
        this.notSupported();
        return null;
    }

    public void addListener(TrackerListener listener) {
    }

    public void removeListener(TrackerListener listener) {
    }

    public String getName() {
        this.notSupported();
        return null;
    }

    public URL[] getURLs() {
        this.notSupported();
        return null;
    }

    public void addPageGenerator(TrackerWebPageGenerator generator) {
    }

    public void removePageGenerator(TrackerWebPageGenerator generator) {
    }

    public TrackerWebPageGenerator[] getPageGenerators() {
        this.notSupported();
        return null;
    }

    public void addAuthenticationListener(TrackerAuthenticationListener l) {
    }

    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
    }
}

