/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class UTTimerImpl
implements UTTimer {
    private PluginInterface plugin_interface;
    private Timer timer;
    private boolean destroyed;

    public UTTimerImpl(String name, boolean lightweight) {
        if (!lightweight) {
            this.timer = new Timer(name);
        }
    }

    protected UTTimerImpl(PluginInterface pi, String name, boolean lightweight) {
        this.plugin_interface = pi;
        if (!lightweight) {
            this.timer = new Timer("Plugin " + pi.getPluginID() + ":" + name);
        }
    }

    public UTTimerEvent addEvent(long when, final UTTimerEventPerformer ext_performer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent res = new timerEvent();
        TimerEventPerformer performer = new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                UtilitiesImpl.setPluginThreadContext(UTTimerImpl.this.plugin_interface);
                res.perform(ext_performer);
            }
        };
        if (this.timer == null) {
            res.setEvent(SimpleTimer.addEvent("Plugin:" + ext_performer.getClass(), when, performer));
        } else {
            res.setEvent(this.timer.addEvent("Plugin:" + ext_performer.getClass(), when, performer));
        }
        return res;
    }

    public UTTimerEvent addPeriodicEvent(long periodic_millis, final UTTimerEventPerformer ext_performer) {
        if (this.destroyed) {
            throw new RuntimeException("Timer has been destroyed");
        }
        final timerEvent res = new timerEvent();
        TimerEventPerformer performer = new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                try {
                    UtilitiesImpl.setPluginThreadContext(UTTimerImpl.this.plugin_interface);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    res.perform(ext_performer);
                }
                catch (Throwable e) {
                    Debug.out("Plugin '" + UTTimerImpl.this.plugin_interface.getPluginName() + " (" + UTTimerImpl.this.plugin_interface.getPluginID() + " " + UTTimerImpl.this.plugin_interface.getPluginVersion() + ") caused an error while processing a timer event", e);
                }
            }
        };
        if (this.timer == null) {
            res.setEvent(SimpleTimer.addPeriodicEvent("Plugin:" + ext_performer.getClass(), periodic_millis, performer));
        } else {
            res.setEvent(this.timer.addPeriodicEvent("Plugin:" + ext_performer.getClass(), periodic_millis, performer));
        }
        return res;
    }

    public void destroy() {
        this.destroyed = true;
        if (this.timer != null) {
            this.timer.destroy();
        }
    }

    protected class timerEvent
    implements UTTimerEvent {
        protected TimerEvent ev;
        protected TimerEventPeriodic pev;

        protected timerEvent() {
        }

        protected void setEvent(TimerEventPeriodic _ev) {
            this.pev = _ev;
        }

        protected void setEvent(TimerEvent _ev) {
            this.ev = _ev;
        }

        protected void perform(UTTimerEventPerformer p) {
            p.perform(this);
        }

        public void cancel() {
            if (this.ev != null) {
                this.ev.cancel();
            } else {
                this.pev.cancel();
            }
        }
    }
}

