/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPieceImpl
implements PEPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private final DiskManagerPiece dmPiece;
    private final PEPeerManager manager;
    private final int nbBlocks;
    private long creationTime = SystemTime.getCurrentTime();
    private final String[] requested;
    private boolean fully_requested;
    private final boolean[] downloaded;
    private boolean fully_downloaded;
    private long time_last_download;
    private final String[] writers;
    private List writes;
    private String reservedBy;
    private int speed;
    private int resumePriority;
    private Object realTimeData;
    protected static final AEMonitor class_mon = new AEMonitor("PEPiece:class");

    public PEPieceImpl(PEPeerManager _manager, DiskManagerPiece _dm_piece, int _pieceSpeed) {
        this.manager = _manager;
        this.dmPiece = _dm_piece;
        this.speed = _pieceSpeed;
        this.nbBlocks = this.dmPiece.getNbBlocks();
        this.requested = new String[this.nbBlocks];
        boolean[] written = this.dmPiece.getWritten();
        this.downloaded = written == null ? new boolean[this.nbBlocks] : (boolean[])written.clone();
        this.writers = new String[this.nbBlocks];
        this.writes = new ArrayList(0);
    }

    public DiskManagerPiece getDMPiece() {
        return this.dmPiece;
    }

    public long getCreationTime() {
        long now = SystemTime.getCurrentTime();
        if (now >= this.creationTime && this.creationTime > 0L) {
            return this.creationTime;
        }
        this.creationTime = now;
        return now;
    }

    public long getTimeSinceLastActivity() {
        long now = SystemTime.getCurrentTime();
        long lastWriteTime = this.getLastDownloadTime(now);
        if (this.time_last_download > 0L && now >= this.time_last_download) {
            return now - this.time_last_download;
        }
        if (this.creationTime > 0L && now >= this.creationTime) {
            return now - this.creationTime;
        }
        this.creationTime = now;
        return 0L;
    }

    public long getLastDownloadTime(long now) {
        if (this.time_last_download <= now) {
            return this.time_last_download;
        }
        this.time_last_download = now;
        return this.time_last_download;
    }

    public boolean isRequested(int blockNumber) {
        return this.requested[blockNumber] != null;
    }

    public boolean isDownloaded(int blockNumber) {
        return this.downloaded[blockNumber];
    }

    public void setDownloaded(int offset) {
        this.time_last_download = SystemTime.getCurrentTime();
        this.downloaded[offset / 16384] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return;
        }
        this.fully_downloaded = true;
        this.fully_requested = false;
    }

    public void clearDownloaded(int offset) {
        this.downloaded[offset / 16384] = false;
        this.fully_downloaded = false;
    }

    public boolean isDownloaded() {
        return this.fully_downloaded;
    }

    public boolean[] getDownloaded() {
        return this.downloaded;
    }

    public boolean hasUndownloadedBlock() {
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return true;
        }
        return false;
    }

    public void setWritten(PEPeer peer, int blockNumber) {
        this.writers[blockNumber] = peer.getIp();
        this.dmPiece.setWritten(blockNumber);
    }

    public void clearRequested(int blockNumber) {
        this.requested[blockNumber] = this.downloaded[blockNumber] ? this.writers[blockNumber] : null;
        this.fully_requested = false;
    }

    public boolean isRequested() {
        return this.fully_requested;
    }

    public void setRequested() {
        this.fully_requested = true;
    }

    public boolean hasUnrequestedBlock() {
        boolean[] written = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
            return true;
        }
        return false;
    }

    public int[] getAndMarkBlocks(PEPeer peer, int nbWanted) {
        String ip = peer.getIp();
        boolean[] written = this.dmPiece.getWritten();
        int blocksFound = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            while (!(blocksFound >= nbWanted || i + blocksFound >= this.nbBlocks || this.downloaded[i + blocksFound] || this.requested[i + blocksFound] != null || written != null && written[i])) {
                this.requested[i + blocksFound] = ip;
                ++blocksFound;
            }
            if (blocksFound <= 0) continue;
            return new int[]{i, blocksFound};
        }
        return new int[]{-1, 0};
    }

    public boolean hasRealTimeBlock(PEPeer peer, int peerSpeedKBSec) {
        if (this.hasUnrequestedBlock()) {
            return true;
        }
        long now = SystemTime.getCurrentTime();
        boolean[] written = this.dmPiece.getWritten();
        String ip = peer.getIp();
        if (this.realTimeData == null) {
            this.realTimeData = new Object[]{new int[this.nbBlocks], new long[this.nbBlocks]};
        }
        int[] speeds = (int[])((Object[])this.realTimeData)[0];
        long[] target_times = (long[])((Object[])this.realTimeData)[1];
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] == null || this.requested[i].equals(ip) || written != null && written[i]) continue;
            int block_speed = speeds[i];
            long target_time = target_times[i];
            if (peerSpeedKBSec == 0) {
                peerSpeedKBSec = 1;
            }
            if (peerSpeedKBSec <= block_speed && (target_time <= 0L || now <= target_time)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] getAndMarkRealTimeBlocks(PEPeer peer, int nbWanted, int peerSpeedKBSec, int peerRequestCount) {
        int[] nArray;
        int pos;
        int[] result;
        block9: {
            int[] nArray2;
            block8: {
                int[] nArray3;
                block7: {
                    String ip = peer.getIp();
                    boolean[] written = this.dmPiece.getWritten();
                    result = new int[this.nbBlocks];
                    pos = 0;
                    try {
                        for (int i = 0; i < this.nbBlocks; ++i) {
                            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
                            this.requested[i] = ip;
                            result[pos++] = i;
                            if (pos != nbWanted) continue;
                            nArray3 = result;
                            Object var21_13 = null;
                            break block7;
                        }
                        if (pos < this.nbBlocks) {
                            long now = SystemTime.getCurrentTime();
                            if (this.realTimeData == null) {
                                this.realTimeData = new Object[]{new int[this.nbBlocks], new long[this.nbBlocks]};
                            }
                            int[] speeds = (int[])((Object[])this.realTimeData)[0];
                            long[] target_times = (long[])((Object[])this.realTimeData)[1];
                            for (int i = 0; i < this.nbBlocks; ++i) {
                                if (this.downloaded[i] || this.requested[i] == null || this.requested[i].equals(ip) || written != null && written[i]) continue;
                                int block_speed = speeds[i];
                                long target_time = target_times[i];
                                if (peerSpeedKBSec == 0) {
                                    peerSpeedKBSec = 1;
                                }
                                if (peerSpeedKBSec <= block_speed && (target_time <= 0L || now <= target_time)) continue;
                                long duration = 16000 * (peerRequestCount + 1) / peerSpeedKBSec;
                                duration *= 2L;
                                duration = Math.max(duration, 200L);
                                speeds[i] = peerSpeedKBSec;
                                target_times[i] = now + duration;
                                this.requested[i] = ip;
                                result[pos++] = i;
                                if (pos != nbWanted) continue;
                                nArray2 = result;
                                break block8;
                            }
                        }
                        nArray = result;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var21_16 = null;
                        if (pos >= result.length) throw throwable;
                        result[pos] = -1;
                        throw throwable;
                    }
                }
                if (pos >= result.length) return nArray3;
                result[pos] = -1;
                return nArray3;
            }
            Object var21_14 = null;
            if (pos >= result.length) return nArray2;
            result[pos] = -1;
            return nArray2;
        }
        Object var21_15 = null;
        if (pos >= result.length) return nArray;
        result[pos] = -1;
        return nArray;
    }

    public int getNbRequests() {
        int result = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] == null) continue;
            ++result;
        }
        return result;
    }

    public int getNbUnrequested() {
        int result = 0;
        boolean[] written = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
            ++result;
        }
        return result;
    }

    public boolean setRequested(PEPeer peer, int blockNumber) {
        if (!this.downloaded[blockNumber]) {
            this.requested[blockNumber] = peer.getIp();
            return true;
        }
        return false;
    }

    public boolean isRequestable() {
        return this.dmPiece.isDownloadable() && !this.fully_downloaded && !this.fully_requested;
    }

    public int getBlockSize(int blockNumber) {
        int length;
        if (blockNumber == this.nbBlocks - 1 && (length = this.dmPiece.getLength()) % 16384 != 0) {
            return length % 16384;
        }
        return 16384;
    }

    public int getBlockNumber(int offset) {
        return offset / 16384;
    }

    public int getNbBlocks() {
        return this.nbBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites() {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(int blockNumber) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getBlockNumber() == blockNumber) continue;
            iter.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(PEPeer peer) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (peer != null && peer.equals(write.getSender())) continue;
            iter.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(String ip) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getSender().equals(ip)) continue;
            iter.remove();
        }
        return result;
    }

    public void reset() {
        this.dmPiece.reset();
        for (int i = 0; i < this.nbBlocks; ++i) {
            this.requested[i] = null;
            this.downloaded[i] = false;
            this.writers[i] = null;
        }
        this.fully_downloaded = false;
        this.time_last_download = 0L;
        this.reservedBy = null;
        this.realTimeData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrite(PEPieceWriteImpl write) {
        try {
            class_mon.enter();
            this.writes.add(write);
        }
        finally {
            class_mon.exit();
        }
    }

    public void addWrite(int blockNumber, String sender, byte[] hash, boolean correct) {
        this.addWrite(new PEPieceWriteImpl(blockNumber, sender, hash, correct));
    }

    public String[] getWriters() {
        return this.writers;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int newSpeed) {
        this.speed = newSpeed;
    }

    public void setLastRequestedPeerSpeed(int peerSpeed) {
        if (peerSpeed > this.speed) {
            ++this.speed;
        }
    }

    public PEPeerManager getManager() {
        return this.manager;
    }

    public void setReservedBy(String peer) {
        this.reservedBy = peer;
    }

    public String getReservedBy() {
        return this.reservedBy;
    }

    public void reDownloadBlock(int blockNumber) {
        this.downloaded[blockNumber] = false;
        this.requested[blockNumber] = null;
        this.fully_downloaded = false;
        this.writers[blockNumber] = null;
        this.dmPiece.reDownloadBlock(blockNumber);
    }

    public void reDownloadBlocks(String address) {
        for (int i = 0; i < this.writers.length; ++i) {
            String writer = this.writers[i];
            if (writer == null || !writer.equals(address)) continue;
            this.reDownloadBlock(i);
        }
    }

    public void setResumePriority(int p) {
        this.resumePriority = p;
    }

    public int getResumePriority() {
        return this.resumePriority;
    }

    public int getAvailability() {
        return this.manager.getAvailability(this.dmPiece.getPieceNumber());
    }

    public int getNbWritten() {
        return this.dmPiece.getNbWritten();
    }

    public boolean[] getWritten() {
        return this.dmPiece.getWritten();
    }

    public boolean isWritten() {
        return this.dmPiece.isWritten();
    }

    public int getPieceNumber() {
        return this.dmPiece.getPieceNumber();
    }

    public int getLength() {
        return this.dmPiece.getLength();
    }

    public void setRequestable() {
        this.fully_downloaded = false;
        this.fully_requested = false;
        this.dmPiece.setDownloadable();
    }

    public boolean isChecking() {
        return this.dmPiece.isChecking();
    }

    public String getString() {
        String text = "";
        text = text + (this.isRequestable() ? "reqable," : "");
        text = text + "req=" + this.getNbRequests() + ",";
        text = text + (this.isRequested() ? "reqstd," : "");
        text = text + (this.isDownloaded() ? "downed," : "");
        text = text + (this.getReservedBy() != null ? "resrv," : "");
        text = text + "speed=" + this.getSpeed() + ",";
        if ((text = text + "pri=" + this.getResumePriority()).endsWith(",")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

