/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.ipfilter.BadIps;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BadIpsImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.util.FileUtil;

public class IpFilterManagerImpl
implements IpFilterManager,
ParameterListener {
    protected static IpFilterManagerImpl singleton = new IpFilterManagerImpl();
    private RandomAccessFile rafDescriptions = null;

    public IpFilterManagerImpl() {
        COConfigurationManager.addAndFireParameterListener("Ip Filter Enable Description Cache", this);
    }

    public Object addDecription(IpRange range, byte[] description) {
        if (this.rafDescriptions == null) {
            return null;
        }
        try {
            if (description == null || description.length == 0) {
                return null;
            }
            int[] info = new int[2];
            info[0] = (int)this.rafDescriptions.getFilePointer();
            int len = (int)this.rafDescriptions.length();
            if (info[0] != len) {
                this.rafDescriptions.seek(len);
                info[0] = (int)this.rafDescriptions.getFilePointer();
            }
            this.rafDescriptions.write(description);
            info[1] = (int)this.rafDescriptions.getFilePointer();
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getDescription(Object info) {
        if (info instanceof Object[]) {
            return (byte[])((Object[])info)[0];
        }
        if (this.rafDescriptions == null || !(info instanceof int[])) {
            return "".getBytes();
        }
        try {
            int[] pos = (int[])info;
            int len = pos[1] - pos[0];
            if (this.rafDescriptions.getFilePointer() != (long)pos[0]) {
                this.rafDescriptions.seek(pos[0]);
            }
            byte[] bytes = new byte[len];
            this.rafDescriptions.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            return "".getBytes();
        }
    }

    public void cacheAllDescriptions() {
        IpRange[] ranges = this.getIPFilter().getRanges();
        for (int i = 0; i < ranges.length; ++i) {
            Object info = ((IpRangeImpl)ranges[i]).getDescRef();
            if (!(info instanceof int[])) continue;
            byte[] desc = this.getDescription(info);
            Object[] data = new Object[]{desc, info};
            ((IpRangeImpl)ranges[i]).setDescRef(data);
        }
    }

    public void clearDescriptionCache() {
        IpRange[] ranges = this.getIPFilter().getRanges();
        for (int i = 0; i < ranges.length; ++i) {
            Object info = ((IpRangeImpl)ranges[i]).getDescRef();
            if (!(info instanceof Object[])) continue;
            int[] data = (int[])((Object[])info)[1];
            ((IpRangeImpl)ranges[i]).setDescRef(data);
        }
    }

    public static IpFilterManager getSingleton() {
        return singleton;
    }

    public IpFilter getIPFilter() {
        return IpFilterImpl.getInstance();
    }

    public BadIps getBadIps() {
        return BadIpsImpl.getInstance();
    }

    public void parameterChanged(String parameterName) {
        boolean enable = COConfigurationManager.getBooleanParameter(parameterName);
        if (enable && this.rafDescriptions == null) {
            File fDescriptions = FileUtil.getUserFile("ipfilter.cache");
            try {
                if (fDescriptions.exists()) {
                    fDescriptions.delete();
                }
                this.rafDescriptions = new RandomAccessFile(fDescriptions, "rw");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (!enable && this.rafDescriptions != null) {
            try {
                this.rafDescriptions.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rafDescriptions = null;
        }
    }
}

