/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.NoticeReference;

public class UserNotice
extends ASN1Encodable {
    NoticeReference noticeRef;
    DisplayText explicitText;

    public DERObject toASN1Object() {
        ASN1EncodableVector av = new ASN1EncodableVector();
        av.add(this.noticeRef);
        av.add(this.explicitText);
        return new DERSequence(av);
    }

    public UserNotice(NoticeReference noticeRef, DisplayText explicitText) {
        this.noticeRef = noticeRef;
        this.explicitText = explicitText;
    }

    public UserNotice(NoticeReference noticeRef, String str) {
        this.noticeRef = noticeRef;
        this.explicitText = new DisplayText(str);
    }

    public UserNotice(ASN1Sequence as) {
        NoticeReference nr = new NoticeReference(ASN1Sequence.getInstance(as.getObjectAt(0)));
        if (as.size() > 1) {
            this.explicitText = DisplayText.getInstance(ASN1Sequence.getInstance(as.getObjectAt(1)));
        }
    }
}

